//3D節點Skew實作
//已知問題 遊戲中無法動態Skew
var LocalDirtyFlag = cc.Enum({
    /**
     * !#en Flag for rotation, scale, position, skew dirty
     * !#zh 旋转，缩放，位置，或斜角 dirty 的标记位
     * @property {Number} TRSS
     * @static
     */
    TRSS: 1 << 0 | 1 << 1 | 1 << 2 | 1 << 3,
});
var ONE_DEGREE = Math.PI / 180;
cc.Class({
    extends: cc.Component,
    properties: {
        _skewX:{default:0 , visable:false},
        _skewY:{default:0 , visable:false},
        skewX_:{ type:cc.Integer, get:function(s){
            return this._skewX ;
        } ,  
        set:function(s){
            this._skewX = s;
            this.setSkew();
        }},
        skewY_:{type:cc.Integer,  get:function(s){
            return this._skewY ;
        } ,  
        set:function(s){
            this._skewY = s;

            this.setSkew();
        }},
        //SP:cc.Sprite,

    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
    //取得Sprite組件
        this.SP = this.node.getComponent(cc.Sprite);
    },
    editor: {
        //允許編輯器預覽觸發
        executeInEditMode:true, 
    },
    start () {
     
        this.setSkew(); 
    },
    setSkew:function(){
        //if (this.node._localMatDirty & LocalDirtyFlag.TRSS) 
        {
          
            let _skewX = this.skewX_ ;
            let _skewY = this.skewY_ ;
            
            let t = this.node._matrix;
            let tm = t.m;
            cc.Trs.toMat4(t, this.node._trs);

 
            if (_skewX || _skewY) {
                let a = tm[0], b = tm[1], c = tm[4], d = tm[5];
                let skx = Math.tan(_skewX * ONE_DEGREE);
                let sky = Math.tan(_skewY * ONE_DEGREE);
                if (skx === Infinity)
                    skx = 99999999;
                if (sky === Infinity)
                    sky = 99999999;
                tm[0] = a + c * sky;
                tm[1] = b + d * sky;
                tm[4] = c + a * skx; 
                tm[5] = d + b * skx;
            }
            this.node._localMatDirty &= ~LocalDirtyFlag.TRSS;
            // Register dirty status of world matrix so that it can be recalculated
            this.node._worldMatDirty = true;
            this.node.matrix = tm;

            if(this.SP){
               //有Sprite的話 更新Sprite
               this.SP._applySpriteFrame(this.SP._spriteFrame);
               if (!CC_EDITOR) {
                //    this.SP._applyAtlas(this.SP._spriteFrame);
               }
            } 
        }
    },
    // update (dt) {},
});
