'use strict';

const fs = require('fs');
const path = require('path');

module.paths.push(path.join(Editor.App.path, 'node_modules'));

const semver = require('semver');
const worker = require('@base/electron-worker');
const profile = Editor.Profile.load('local://packages/fix-1.1.0.json');

(async () => {
    if (semver.satisfies(Editor.App.version, '<=1.0.4')) {
        await profile.remove('fix-fbx');
        profile.save();
    }

    const bool = semver.satisfies(Editor.App.version, '1.1.0');
    const fbx = await profile.get('fix-fbx');

    if (bool && !fbx) {

        try {
            profile.set('fix-fbx', true);
            profile.save();
            // FBX 迁移
            const assets = path.join(Editor.Project.path, 'assets');
            const step = function(file) {
                if (!fs.existsSync(file)) {
                    return;
                }
                const stat = fs.statSync(file);
                if (!stat.isDirectory()) {
                    if (path.extname(file) === '.FBX') {
                        const name = path.basename(file, '.FBX');
                        const materials = path.join(file, `../Materials_${name}.FBX`);
                        if (fs.existsSync(materials)) {
                            // 迁移
                            fs.renameSync(materials, path.join(file, `../Materials_${name}`));
                        }
                    }
                    return;
                }
        
                // dir
                const names = fs.readdirSync(file);
                names.forEach((name) => {
                    step(path.join(file, name));
                });
            }
            step(assets);
        } catch(error) {
            console.error(error);
        }
    }
    
    if (bool) {
        let timer = null;
        let num = 0;
        
        const step = function() {
            clearTimeout(timer);
            const db = worker.query('Asset DB');
            if (!db) {
                if (num < 10000) {
                    timer = setTimeout(step, 100);
                }
                num++;
                return;
            }
            db.require(path.join(__dirname, './fix'));
        }
        step();
    }
})();

module.exports = {
    /**
     * 插件监听的消息
     * The message that the plug-in is currently listening
     */
    messages: {},

    /**
     * 启动的时候执行的初始化方法
     * Initialization method performed at startup
     */
    load() {},

    /**
     * 插件被关闭的时候执行的卸载方法
     * Uninstall method performed when the plug-in is closed
     */
    unload() {},
};
