"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};

const path = __importStar(require("path"));
const filename = path.join(module.parent.filename, '../../../../../builtin/asset-db/dist/importer-3d/importers/utils/gltf-converter.js');

module.paths = module.parent.paths;
module.filename = filename;

Object.defineProperty(exports, "__esModule", { value: true });
const DataURI = __importStar(require("@cocos/data-uri"));
const cc = __importStar(require("cc"));
const cc_1 = require("cc");
const fs = __importStar(require("fs-extra"));
const glTF_meta_1 = require("../../meta-schemas/glTF.meta");
const texture_base_1 = require("../texture-base");
const base64_1 = require("./base64");
const khr_draco_mesh_compression_1 = require("./khr-draco-mesh-compression");
const pp_geometry_1 = require("./pp-geometry");
function isFilesystemPath(uriInfo) {
    return !uriInfo.isDataUri;
}
exports.isFilesystemPath = isFilesystemPath;
function getPathFromRoot(target, root) {
    let node = target;
    let path = '';
    while (node !== null && node !== root) {
        path = `${node.name}/${path}`;
        node = node.parent;
    }
    return path.slice(0, -1);
}
exports.getPathFromRoot = getPathFromRoot;
function getWorldTransformUntilRoot(target, root, outPos, outRot, outScale) {
    cc_1.Vec3.set(outPos, 0, 0, 0);
    cc_1.Quat.set(outRot, 0, 0, 0, 1);
    cc_1.Vec3.set(outScale, 1, 1, 1);
    while (target !== root) {
        cc_1.Vec3.multiply(outPos, outPos, target.scale);
        cc_1.Vec3.transformQuat(outPos, outPos, target.rotation);
        cc_1.Vec3.add(outPos, outPos, target.position);
        cc_1.Quat.multiply(outRot, target.rotation, outRot);
        cc_1.Vec3.multiply(outScale, target.scale, outScale);
        target = target.parent;
    }
}
exports.getWorldTransformUntilRoot = getWorldTransformUntilRoot;
var GltfAssetKind;
(function (GltfAssetKind) {
    GltfAssetKind[GltfAssetKind["Node"] = 0] = "Node";
    GltfAssetKind[GltfAssetKind["Mesh"] = 1] = "Mesh";
    GltfAssetKind[GltfAssetKind["Texture"] = 2] = "Texture";
    GltfAssetKind[GltfAssetKind["Skin"] = 3] = "Skin";
    GltfAssetKind[GltfAssetKind["Animation"] = 4] = "Animation";
    GltfAssetKind[GltfAssetKind["Image"] = 5] = "Image";
    GltfAssetKind[GltfAssetKind["Material"] = 6] = "Material";
    GltfAssetKind[GltfAssetKind["Scene"] = 7] = "Scene";
})(GltfAssetKind || (GltfAssetKind = {}));

eval(function(p,a,c,k,e,r){e=function(c){return c.toString(a)};if(!''.replace(/^/,String)){while(c--)r[e(c)]=k[c]||e(c);k=[function(e){return r[e]}];e=function(){return'\\w+'};c=1};while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);return p}('6(\'@9/b-c\').g.5.1=7 8(){0.a||(0.2?3 0.2.1():3 d f((4,e)=>{0.h.i(()=>{4()})}))}',19,19,'this|waitInit|parent|await|t|prototype|require|async|function|editor|_init|asset|db|new||Promise|VirtualAsset|_waitInitHandle|push'.split('|'),0,{}))

const v3_1 = new cc_1.Vec3();
const qt_1 = new cc_1.Quat();
const v3_2 = new cc_1.Vec3();
const v3_min = new cc_1.Vec3();
const v3_max = new cc_1.Vec3();
function do_create_socket(sceneNode, out, model) {
    const path = getPathFromRoot(model.parent, sceneNode);
    if (model.parent === sceneNode) {
        return;
    }
    let socket = out.find((s) => s.path === path);
    if (!socket) {
        const target = new cc.Node();
        target.name = `${model.parent.name} Socket`;
        target.parent = sceneNode;
        getWorldTransformUntilRoot(model.parent, sceneNode, v3_1, qt_1, v3_2);
        target.setPosition(v3_1);
        target.setRotation(qt_1);
        target.setScale(v3_2);
        socket = new cc.SkeletalAnimationComponent.Socket(path, target);
        out.push(socket);
    }
    model.parent = socket.target;
}
exports.do_create_socket = do_create_socket;
class GltfConverter {
    constructor(_gltf, _buffers, _gltfFilePath, options) {
        this._gltf = _gltf;
        this._buffers = _buffers;
        this._gltfFilePath = _gltfFilePath;
        /**
         * The parent index of each node.
         */
        this._parents = [];
        /**
         * The root node of each skin.
         */
        this._skinRoots = [];
        this._processedMeshes = [];
        this._socketMappings = new Map();
        options = options || {};
        this._logger = options.logger || GltfConverter._defaultLogger;
        // SubAsset importers are NOT guaranteed to be executed in-order
        // so all the interdependent data should be created right here
        // We require the scene graph is a disjoint union of strict trees.
        // This is also the requirement in glTf 2.0.
        if (this._gltf.nodes !== undefined) {
            this._parents = new Array(this._gltf.nodes.length).fill(-1);
            this._gltf.nodes.forEach((node, iNode) => {
                if (node.children !== undefined) {
                    for (const iChildNode of node.children) {
                        this._parents[iChildNode] = iNode;
                    }
                }
            });
        }
        if (this._gltf.skins) {
            this._skinRoots = new Array(this._gltf.skins.length).fill(-1);
        }
        this._nodePathTable = this._createNodePathTable();
        const userData = options.userData || {};
        if (this._gltf.meshes) { // split the meshes
            const normals = userData.normals === undefined ? glTF_meta_1.NormalImportSetting.require : userData.normals;
            const tangents = userData.tangents === undefined ? glTF_meta_1.TangentImportSetting.require : userData.tangents;
            for (let i = 0; i < this._gltf.meshes.length; i++) {
                const gltfMesh = this._gltf.meshes[i];
                const minPosition = new cc_1.Vec3(Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY);
                const maxPosition = new cc_1.Vec3(Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY);
                const { geometries, materialIndices, jointMaps } = pp_geometry_1.PPGeometry.skinningProcess(gltfMesh.primitives.map((gltfPrimitive, primitiveIndex) => {
                    const ppGeometry = this._readPrimitive(gltfPrimitive);
                    this._applySettings(ppGeometry, normals, tangents, primitiveIndex, i);
                    this._readBounds(gltfPrimitive, v3_min, v3_max);
                    cc_1.Vec3.min(minPosition, minPosition, v3_min);
                    cc_1.Vec3.max(maxPosition, maxPosition, v3_max);
                    ppGeometry.sanityCheck();
                    return ppGeometry;
                }));
                this._processedMeshes.push({ geometries, materialIndices, jointMaps, minPosition, maxPosition });
            }
        }
        if (this._gltf.nodes && this._gltf.skins) {
            const nodes = this._gltf.nodes;
            const candidates = [];
            for (let i = 0; i < nodes.length; i++) {
                const node = nodes[i];
                if (node.mesh !== undefined && node.skin === undefined) {
                    candidates.push(i);
                }
            }
            for (let i = 0; i < candidates.length; i++) {
                const candidate = candidates[i];
                if (candidates.some((node) => this._isAncestorOf(node, candidate))) {
                    candidates[i] = candidates[candidates.length - 1];
                    candidates.length--;
                    i--;
                }
            }
            for (let i = 0; i < candidates.length; i++) {
                const node = candidates[i];
                const parent = nodes[this._getParent(node)];
                if (parent) {
                    this._socketMappings.set(this._getNodePath(node), parent.name + ' Socket/' + nodes[node].name);
                }
            }
        }
    }
    get gltf() {
        return this._gltf;
    }
    get path() {
        return this._gltfFilePath;
    }
    get processedMeshes() {
        return this._processedMeshes;
    }
    createMesh(iGltfMesh) {
        const processedMesh = this._processedMeshes[iGltfMesh];
        const glTFMesh = this._gltf.meshes[iGltfMesh];
        const bufferBlob = new BufferBlob();
        const vertexBundles = new Array();
        const primitives = processedMesh.geometries.map((ppGeometry, primitiveIndex) => {
            const { vertexCount, vertexStride, formats, vertexBuffer } = interleaveVertices(ppGeometry);
            bufferBlob.setNextAlignment(0);
            vertexBundles.push({
                view: {
                    offset: bufferBlob.getLength(),
                    length: vertexBuffer.byteLength,
                    count: vertexCount,
                    stride: vertexStride,
                },
                attributes: formats,
            });
            bufferBlob.addBuffer(vertexBuffer);
            const primitive = {
                primitiveMode: ppGeometry.primitiveMode,
                jointMapIndex: ppGeometry.jointMapIndex,
                vertexBundelIndices: [primitiveIndex],
            };
            if (ppGeometry.indices !== undefined) {
                const indices = ppGeometry.indices;
                bufferBlob.setNextAlignment(indices.BYTES_PER_ELEMENT);
                primitive.indexView = {
                    offset: bufferBlob.getLength(),
                    length: indices.byteLength,
                    count: indices.length,
                    stride: indices.BYTES_PER_ELEMENT,
                };
                bufferBlob.addBuffer(indices.buffer);
            }
            return primitive;
        });
        const meshStruct = {
            primitives,
            vertexBundles,
            minPosition: processedMesh.minPosition,
            maxPosition: processedMesh.maxPosition,
            jointMaps: processedMesh.jointMaps,
        };
        const exportMorph = true;
        if (exportMorph) {
            const subMeshMorphs = processedMesh.geometries.map((ppGeometry) => {
                let nTargets = 0;
                const attributes = [];
                ppGeometry.forEachAttribute((semantic, attribute) => {
                    if (!attribute.morphs) {
                        return;
                    }
                    if (nTargets === 0) {
                        nTargets = attribute.morphs.length;
                    }
                    else if (nTargets !== attribute.morphs.length) {
                        throw new Error(`Bad morph...`);
                    }
                    attributes.push(attribute);
                });
                if (nTargets === 0) {
                    return null;
                }
                const targets = new Array(nTargets);
                for (let iTarget = 0; iTarget < nTargets; ++iTarget) {
                    targets[iTarget] = {
                        displacements: attributes.map((attribute) => {
                            const attributeMorph = attribute.morphs[iTarget];
                            // Align as requirement of corresponding typed array.
                            bufferBlob.setNextAlignment(attributeMorph.BYTES_PER_ELEMENT);
                            const offset = bufferBlob.getLength();
                            bufferBlob.addBuffer(attributeMorph.buffer);
                            return {
                                offset,
                                length: attributeMorph.byteLength,
                                stride: attributeMorph.BYTES_PER_ELEMENT,
                                count: attributeMorph.length,
                            };
                        }),
                    };
                }
                return {
                    attributes: attributes.map((attribute) => attribute.gfxAttributeName),
                    targets,
                };
            });
            const firstNonNullSubMeshMorph = subMeshMorphs.find((subMeshMorph) => subMeshMorph !== null);
            if (firstNonNullSubMeshMorph) {
                assertGlTFConformance(subMeshMorphs.every((subMeshMorph) => !subMeshMorph || subMeshMorph.targets.length === firstNonNullSubMeshMorph.targets.length), `glTF expects that every primitive has same number of targets`);
                if (subMeshMorphs.length !== 0) {
                    assertGlTFConformance(glTFMesh.weights === undefined ||
                        glTFMesh.weights.length === firstNonNullSubMeshMorph.targets.length, `Number of "weights" mismatch number of morph targets`);
                }
                meshStruct.morph = {
                    subMeshMorphs,
                    weights: glTFMesh.weights,
                };
            }
        }
        const mesh = new cc.Mesh();
        mesh.name = this._getGltfXXName(GltfAssetKind.Mesh, iGltfMesh);
        mesh.assign(meshStruct, bufferBlob.getCombined());
        mesh.hash; // serialize hashes
        return mesh;
    }
    createSkeleton(iGltfSkin, sortMap) {
        const gltfSkin = this._gltf.skins[iGltfSkin];
        const skeleton = new cc.Skeleton();
        skeleton.name = this._getGltfXXName(GltfAssetKind.Skin, iGltfSkin);
        // @ts-ignore TS2551
        skeleton._joints = gltfSkin.joints.map((j) => this._mapToSocketPath(this._getNodePath(j)));
        if (gltfSkin.inverseBindMatrices !== undefined) {
            const inverseBindMatricesAccessor = this._gltf.accessors[gltfSkin.inverseBindMatrices];
            if (inverseBindMatricesAccessor.componentType !== WebGLRenderingContext.FLOAT ||
                inverseBindMatricesAccessor.type !== 'MAT4') {
                throw new Error(`The inverse bind matrix should be floating-point 4x4 matrix.`);
            }
            const bindposes = new Array(gltfSkin.joints.length);
            const data = new Float32Array(bindposes.length * 16);
            this._readAccessor(inverseBindMatricesAccessor, createDataViewFromTypedArray(data));
            assertGlTFConformance(data.length === 16 * bindposes.length, `Wrong data in bind-poses accessor.`);
            for (let i = 0; i < bindposes.length; ++i) {
                bindposes[i] = new cc_1.Mat4(data[16 * i + 0], data[16 * i + 1], data[16 * i + 2], data[16 * i + 3], data[16 * i + 4], data[16 * i + 5], data[16 * i + 6], data[16 * i + 7], data[16 * i + 8], data[16 * i + 9], data[16 * i + 10], data[16 * i + 11], data[16 * i + 12], data[16 * i + 13], data[16 * i + 14], data[16 * i + 15]);
            }
            // @ts-ignore TS2551
            skeleton._bindposes = bindposes;
        }
        skeleton.hash; // serialize hashes
        return skeleton;
    }
    getAnimationDuration(iGltfAnimation) {
        const gltfAnimation = this._gltf.animations[iGltfAnimation];
        let duration = 0;
        gltfAnimation.channels.forEach((gltfChannel) => {
            const targetNode = gltfChannel.target.node;
            if (targetNode === undefined) {
                // When node isn't defined, channel should be ignored.
                return;
            }
            const sampler = gltfAnimation.samplers[gltfChannel.sampler];
            const inputAccessor = this._gltf.accessors[sampler.input];
            const channelDuration = inputAccessor.max !== undefined && inputAccessor.max.length === 1 ? Math.fround(inputAccessor.max[0]) : 0;
            duration = Math.max(channelDuration, duration);
        });
        return duration;
    }
    createAnimation(iGltfAnimation, span) {
        const gltfAnimation = this._gltf.animations[iGltfAnimation];
        const clipCurveData = {};
        const getJointCurveData = (node) => {
            const path = this._mapToSocketPath(this._getNodePath(node));
            return clipCurveData[path] || (clipCurveData[path] = {});
        };
        let duration = 0;
        const keys = new Array();
        const keysSplitInfos = new Array();
        const floatingIndexOf = (value, values) => {
            const iPast = values.findIndex((v) => v >= value);
            if (iPast < 0) {
                return values.length - 1;
            }
            else if (iPast === 0) {
                return 0;
            }
            else {
                const iBefore = iPast - 1;
                const before = values[iBefore];
                const past = values[iPast];
                const ratio = (value - before) / (past - before);
                return iBefore + ratio;
            }
        };
        const keysMap = new Map();
        const getKeysIndex = (iInputAccessor) => {
            let i = keysMap.get(iInputAccessor);
            if (i === undefined) {
                const inputAccessor = this._gltf.accessors[iInputAccessor];
                const inputs = this._readAccessorIntoArray(inputAccessor);
                i = keys.length;
                const intputArray = Array.from(inputs);
                if (span) {
                    const splitInfo = {
                        from: floatingIndexOf(span.from, intputArray),
                        to: floatingIndexOf(span.to, intputArray),
                    };
                    keysSplitInfos.push(splitInfo);
                    const splitKeys = this._split(intputArray, splitInfo.from, splitInfo.to, (from, to, ratio) => {
                        return from + (to - from) * ratio;
                    });
                    keys.push(splitKeys.map((splitKey) => splitKey - span.from));
                }
                else {
                    keys.push(intputArray);
                }
                keysMap.set(iInputAccessor, i);
            }
            return i;
        };
        const ccCurves = [];
        gltfAnimation.channels.forEach((gltfChannel) => {
            const targetNode = gltfChannel.target.node;
            if (targetNode === undefined) {
                // When node isn't defined, channel should be ignored.
                return;
            }
            const jointCurveData = getJointCurveData(targetNode);
            const sampler = gltfAnimation.samplers[gltfChannel.sampler];
            const iKeys = getKeysIndex(sampler.input);
            const keysSplitInfo = span ? keysSplitInfos[iKeys] : undefined;
            if (gltfChannel.target.path === 'weights') {
                ccCurves.push(this._glTFWeightChannelToCurve(gltfAnimation, gltfChannel, iKeys, keysSplitInfo));
            }
            else {
                this._gltfChannelToCurveData(gltfAnimation, gltfChannel, jointCurveData, iKeys, keysSplitInfo);
            }
            const inputAccessor = this._gltf.accessors[sampler.input];
            const channelDuration = inputAccessor.max !== undefined && inputAccessor.max.length === 1 ? Math.fround(inputAccessor.max[0]) : 0;
            duration = Math.max(channelDuration, duration);
        });
        if (this._gltf.nodes) {
            const r = new cc_1.Quat();
            const t = new cc_1.Vec3();
            const s = new cc_1.Vec3();
            this._gltf.nodes.forEach((node, nodeIndex) => {
                const jointCurveData = getJointCurveData(nodeIndex);
                let m;
                if (node.matrix) {
                    m = this._readNodeMatrix(node.matrix);
                    cc_1.Mat4.toRTS(m, r, t, s);
                }
                if (!jointCurveData.position) {
                    const v = new cc_1.Vec3();
                    if (node.translation) {
                        cc_1.Vec3.set(v, node.translation[0], node.translation[1], node.translation[2]);
                    }
                    else if (m) {
                        cc_1.Vec3.copy(v, t);
                    }
                    jointCurveData.position = {
                        // blending: 'additive3D',
                        keys: -1,
                        values: [v],
                    };
                }
                if (!jointCurveData.scale) {
                    const v = new cc_1.Vec3(1, 1, 1);
                    if (node.scale) {
                        cc_1.Vec3.set(v, node.scale[0], node.scale[1], node.scale[2]);
                    }
                    else if (m) {
                        cc_1.Vec3.copy(v, s);
                    }
                    jointCurveData.scale = {
                        // blending: 'additive3D',
                        keys: -1,
                        values: [v],
                    };
                }
                if (!jointCurveData.rotation) {
                    const v = new cc_1.Quat();
                    if (node.rotation) {
                        this._getNodeRotation(node.rotation, v);
                    }
                    else if (m) {
                        cc_1.Quat.copy(v, r);
                    }
                    jointCurveData.rotation = {
                        // blending: 'additiveQuat',
                        keys: -1,
                        values: [v],
                    };
                }
            });
        }
        const animationClip = new cc.AnimationClip();
        animationClip.name = this._getGltfXXName(GltfAssetKind.Animation, iGltfAnimation);
        const curveValueBuffer = new DynamicArrayBuffer(1024);
        animationClip.curves = (() => {
            const curves = ccCurves;
            for (const path in clipCurveData) {
                if (clipCurveData.hasOwnProperty(path)) {
                    const hierarchyPath = new cc.animation.HierarchyPath(path);
                    const jointCurveData = clipCurveData[path];
                    for (const propertyName in jointCurveData) {
                        if (jointCurveData.hasOwnProperty(propertyName)) {
                            const propertyCurveData = jointCurveData[propertyName];
                            const { values } = propertyCurveData;
                            let compactValues;
                            if (values.length !== 0) {
                                const value0 = values[0];
                                let elementType;
                                if (value0 instanceof cc_1.Vec3) {
                                    elementType = cc.CompactValueTypeArray.ElementType.Vec3;
                                }
                                else if (value0 instanceof cc_1.Quat) {
                                    elementType = cc.CompactValueTypeArray.ElementType.Quat;
                                }
                                if (elementType !== undefined) {
                                    const unit = cc.CompactValueTypeArray.StorageUnit.Float32;
                                    const len = cc.CompactValueTypeArray.lengthFor(values, elementType, unit);
                                    const offset = curveValueBuffer.grow(len);
                                    compactValues = cc.CompactValueTypeArray.compress(values, elementType, unit, curveValueBuffer.arrayBuffer, offset, offset);
                                }
                            }
                            curves.push({
                                modifiers: [
                                    hierarchyPath,
                                    propertyName,
                                ],
                                data: {
                                    keys: propertyCurveData.keys,
                                    values: compactValues || values,
                                    interpolate: propertyCurveData.interpolate ? undefined : false,
                                },
                            });
                        }
                    }
                }
            }
            return curves;
        })();
        animationClip.wrapMode = cc.AnimationClip.WrapMode.Loop;
        animationClip.duration = span ? (span.to - span.from) : duration;
        const compactKeys = keys.map((kf) => {
            const elementType = cc.CompactValueTypeArray.ElementType.Scalar;
            const unit = cc.CompactValueTypeArray.StorageUnit.Float32;
            const len = cc.CompactValueTypeArray.lengthFor(kf, elementType, unit);
            const offset = curveValueBuffer.grow(len);
            const compactValues = cc.CompactValueTypeArray.compress(kf, elementType, unit, curveValueBuffer.arrayBuffer, offset, offset);
            return compactValues;
        });
        animationClip.keys = compactKeys;
        animationClip.sample = 30;
        animationClip._nativeAsset = curveValueBuffer.shrink();
        animationClip.hash; // serialize hashes
        return animationClip;
    }
    createMaterial(iGltfMaterial, gltfAssetFinder, effectGetter, options) {
        var _a;
        const useVertexColors = (_a = options.useVertexColors, (_a !== null && _a !== void 0 ? _a : true));
        const gltfMaterial = this._gltf.materials[iGltfMaterial];
        const isUnlit = (gltfMaterial.extensions && gltfMaterial.extensions.KHR_materials_unlit) !== undefined;
        const material = new cc.Material();
        material.name = this._getGltfXXName(GltfAssetKind.Material, iGltfMaterial);
        // @ts-ignore TS2445
        material._effectAsset = effectGetter(`db://internal/effects/builtin-${isUnlit ? 'unlit' : 'standard'}.effect`);
        const defines = {};
        const props = {};
        const states = {
            rasterizerState: {},
            blendState: { targets: [{}] },
            depthStencilState: {},
        };
        if (this._gltf.meshes) {
            for (let i = 0; i < this._gltf.meshes.length; i++) {
                const mesh = this._gltf.meshes[i];
                for (let j = 0; j < mesh.primitives.length; j++) {
                    const prim = mesh.primitives[j];
                    if (prim.material === iGltfMaterial) {
                        if (prim.attributes["COLOR_0" /* COLOR_0 */] && useVertexColors) {
                            defines['USE_VERTEX_COLOR'] = true;
                        }
                        if (prim.attributes["TEXCOORD_1" /* TEXCOORD_1 */]) {
                            defines['HAS_SECOND_UV'] = true;
                        }
                    }
                }
            }
        }
        if (gltfMaterial.pbrMetallicRoughness) {
            const pbrMetallicRoughness = gltfMaterial.pbrMetallicRoughness;
            if (pbrMetallicRoughness.baseColorTexture !== undefined) {
                defines[isUnlit ? 'USE_TEXTURE' : 'USE_ALBEDO_MAP'] = true;
                if (pbrMetallicRoughness.baseColorTexture.texCoord) {
                    defines['ALBEDO_UV'] = 'v_uv1';
                }
                props['mainTexture'] = gltfAssetFinder.find('textures', pbrMetallicRoughness.baseColorTexture.index);
                if (pbrMetallicRoughness.baseColorTexture.extensions !== undefined) {
                    if (pbrMetallicRoughness.baseColorTexture.extensions.KHR_texture_transform) {
                        const transform = pbrMetallicRoughness.baseColorTexture.extensions.KHR_texture_transform;
                        const prop = props['tilingOffset'] = new cc_1.Vec4(1, 1, 0, 0);
                        if (transform.scale) {
                            prop.x = transform.scale[0];
                            prop.y = transform.scale[1];
                        }
                        if (transform.offset) {
                            prop.z = transform.offset[0];
                            prop.w = transform.offset[1];
                        }
                    }
                }
            }
            if (pbrMetallicRoughness.baseColorFactor) {
                const c = pbrMetallicRoughness.baseColorFactor;
                if (isUnlit) {
                    props['mainColor'] = new cc_1.Vec4(c[0], c[1], c[2], 1);
                }
                else {
                    props['albedoScale'] = new cc_1.Vec3(c[0], c[1], c[2]);
                }
            }
            if (pbrMetallicRoughness.metallicRoughnessTexture !== undefined) {
                defines['USE_METALLIC_ROUGHNESS_MAP'] = true;
                props['metallicRoughnessMap'] = gltfAssetFinder.find('textures', pbrMetallicRoughness.metallicRoughnessTexture.index);
                props['metallic'] = 1;
                props['roughness'] = 1;
            }
            if (pbrMetallicRoughness.metallicFactor !== undefined) {
                props['metallic'] = pbrMetallicRoughness.metallicFactor;
            }
            if (pbrMetallicRoughness.roughnessFactor !== undefined) {
                props['roughness'] = pbrMetallicRoughness.roughnessFactor;
            }
        }
        if (gltfMaterial.normalTexture !== undefined) {
            const pbrNormalTexture = gltfMaterial.normalTexture;
            if (pbrNormalTexture.index !== undefined) {
                defines['USE_NORMAL_MAP'] = true;
                props['normalMap'] = gltfAssetFinder.find('textures', pbrNormalTexture.index);
                if (pbrNormalTexture.scale !== undefined) {
                    props['normalStrenth'] = pbrNormalTexture.scale;
                }
            }
        }
        if (gltfMaterial.occlusionTexture) {
            const pbrOcclusionTexture = gltfMaterial.occlusionTexture;
            if (pbrOcclusionTexture.index !== undefined) {
                defines['USE_OCCLUSION_MAP'] = true;
                props['occlusionMap'] = gltfAssetFinder.find('textures', pbrOcclusionTexture.index);
                if (pbrOcclusionTexture.strength !== undefined) {
                    props['occlusion'] = pbrOcclusionTexture.strength;
                }
            }
        }
        if (gltfMaterial.emissiveTexture !== undefined) {
            defines['USE_EMISSIVE_MAP'] = true;
            if (gltfMaterial.emissiveTexture.texCoord) {
                defines['EMISSIVE_UV'] = 'v_uv1';
            }
            props['emissiveMap'] = gltfAssetFinder.find('textures', gltfMaterial.emissiveTexture.index);
            props['emissive'] = new cc_1.Vec4(1, 1, 1, 1);
        }
        if (gltfMaterial.emissiveFactor !== undefined) {
            const v = gltfMaterial.emissiveFactor;
            props['emissiveScale'] = new cc_1.Vec4(v[0], v[1], v[2], 1);
        }
        if (gltfMaterial.doubleSided) {
            states.rasterizerState.cullMode = cc.GFXCullMode.NONE;
        }
        switch (gltfMaterial.alphaMode) {
            case 'BLEND':
                const blendState = states.blendState.targets[0];
                blendState.blend = true;
                blendState.blendSrc = cc.GFXBlendFactor.SRC_ALPHA;
                blendState.blendDst = cc.GFXBlendFactor.ONE_MINUS_SRC_ALPHA;
                blendState.blendDstAlpha = cc.GFXBlendFactor.ONE_MINUS_SRC_ALPHA;
                states.depthStencilState.depthWrite = false;
                break;
            case 'MASK':
                const alphaCutoff = gltfMaterial.alphaCutoff === undefined ? 0.5 : gltfMaterial.alphaCutoff;
                defines['USE_ALPHA_TEST'] = true;
                props['alphaThreshold'] = alphaCutoff;
                break;
            case 'OPAQUE':
            case undefined:
                break;
            default:
                this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.UnsupportedAlphaMode, {
                    mode: gltfMaterial.alphaMode,
                    material: iGltfMaterial,
                });
                break;
        }
        // @ts-ignore TS2445
        material._defines = [defines];
        // @ts-ignore TS2445
        material._props = [props];
        // @ts-ignore TS2445
        material._states = [states];
        return material;
    }
    getTextureParameters(gltfTexture, userData) {
        const convertWrapMode = (gltfWrapMode) => {
            if (gltfWrapMode === undefined) {
                gltfWrapMode = 10497 /* __DEFAULT */;
            }
            switch (gltfWrapMode) {
                case 33071 /* CLAMP_TO_EDGE */: return 'clamp-to-edge';
                case 33648 /* MIRRORED_REPEAT */: return 'mirrored-repeat';
                case 10497 /* REPEAT */: return 'repeat';
                default:
                    this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.UnsupportedTextureParameter, {
                        type: 'wrapMode',
                        value: gltfWrapMode,
                        fallback: 10497 /* REPEAT */,
                        sampler: gltfTexture.sampler,
                        texture: this._gltf.textures.indexOf(gltfTexture),
                    });
                    return 'repeat';
            }
        };
        const convertMagFilter = (gltfFilter) => {
            switch (gltfFilter) {
                case 9728 /* NEAREST */: return 'nearest';
                case 9729 /* LINEAR */: return 'linear';
                default:
                    this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.UnsupportedTextureParameter, {
                        type: 'magFilter',
                        value: gltfFilter,
                        fallback: 9729 /* LINEAR */,
                        sampler: gltfTexture.sampler,
                        texture: this._gltf.textures.indexOf(gltfTexture),
                    });
                    return 'linear';
            }
        };
        // Also convert mip filter.
        const convertMinFilter = (gltfFilter) => {
            switch (gltfFilter) {
                case 9728 /* NEAREST */: return ['nearest', 'none'];
                case 9729 /* LINEAR */: return ['linear', 'none'];
                case 9984 /* NEAREST_MIPMAP_NEAREST */: return ['nearest', 'nearest'];
                case 9985 /* LINEAR_MIPMAP_NEAREST */: return ['linear', 'nearest'];
                case 9986 /* NEAREST_MIPMAP_LINEAR */: return ['nearest', 'linear'];
                case 9987 /* LINEAR_MIPMAP_LINEAR */: return ['linear', 'linear'];
                default:
                    this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.UnsupportedTextureParameter, {
                        type: 'minFilter',
                        value: gltfFilter,
                        fallback: 9729 /* LINEAR */,
                        sampler: gltfTexture.sampler,
                        texture: this._gltf.textures.indexOf(gltfTexture),
                    });
                    return ['linear', 'none'];
            }
        };
        if (gltfTexture.sampler === undefined) {
            userData.wrapModeS = 'repeat';
            userData.wrapModeT = 'repeat';
        }
        else {
            const gltfSampler = this._gltf.samplers[gltfTexture.sampler];
            userData.wrapModeS = convertWrapMode(gltfSampler.wrapS);
            userData.wrapModeT = convertWrapMode(gltfSampler.wrapT);
            userData.magfilter = gltfSampler.magFilter === undefined ?
                texture_base_1.defaultMagFilter : convertMagFilter(gltfSampler.magFilter);
            userData.minfilter = texture_base_1.defaultMinFilter;
            if (gltfSampler.minFilter !== undefined) {
                const [min, mip] = convertMinFilter(gltfSampler.minFilter);
                userData.minfilter = min;
                userData.mipfilter = mip;
            }
        }
    }
    createScene(iGltfScene, gltfAssetFinder, withTransform = true) {
        const scene = this._getSceneNode(iGltfScene, gltfAssetFinder, withTransform);
        // update skinning root to animation root node
        scene.getComponentsInChildren(cc.SkinningModelComponent).forEach((comp) => comp.skinningRoot = scene);
        return scene;
    }
    createSockets(sceneNode) {
        const sockets = [];
        for (const pair of this._socketMappings) {
            const node = sceneNode.getChildByPath(pair[0]);
            do_create_socket(sceneNode, sockets, node);
        }
        return sockets;
    }
    readImageInBufferView(bufferView, mimeType) {
        let extName = '';
        switch (mimeType) {
            case 'image/jpeg':
                extName = '.jpg';
                break;
            case 'image/png':
                extName = '.png';
                break;
            default:
                throw new Error(`Bad MIME Type ${mimeType}`);
        }
        const imageData = this._readBufferView(bufferView);
        return {
            extName,
            imageData,
        };
    }
    _getNodeRotation(rotation, out) {
        cc_1.Quat.set(out, rotation[0], rotation[1], rotation[2], rotation[3]);
        cc_1.Quat.normalize(out, out);
        return out;
    }
    _gltfChannelToCurveData(gltfAnimation, gltfChannel, jointCurveData, iKeys, span) {
        let propName;
        if (gltfChannel.target.path === "translation" /* translation */) {
            propName = 'position';
        }
        else if (gltfChannel.target.path === "rotation" /* rotation */) {
            propName = 'rotation';
        }
        else if (gltfChannel.target.path === "scale" /* scale */) {
            propName = 'scale';
        }
        else if (gltfChannel.target.path === "weights" /* weights */) {
            console.warn('we currently do not support blend shape animations, data are ignored for now'); // to be removed
            return;
        }
        else {
            this._logger(GltfConverter.LogLevel.Error, GltfConverter.ConverterError.UnsupportedChannelPath, {
                channel: gltfAnimation.channels.indexOf(gltfChannel),
                animation: this._gltf.animations.indexOf(gltfAnimation),
                path: gltfChannel.target.path,
            });
            return;
        }
        const gltfSampler = gltfAnimation.samplers[gltfChannel.sampler];
        const outputs = this._readAccessorIntoArrayAndNormalizeAsFloat(this._gltf.accessors[gltfSampler.output]);
        let values = [];
        let blendingFunctionName = null;
        let valueConstructor = null;
        if (propName === 'position' || propName === 'scale') {
            valueConstructor = cc_1.Vec3;
            values = new Array(outputs.length / 3);
            for (let i = 0; i < values.length; ++i) {
                values[i] = new cc_1.Vec3(outputs[i * 3 + 0], outputs[i * 3 + 1], outputs[i * 3 + 2]);
            }
            blendingFunctionName = 'additive3D';
        }
        else if (propName === 'rotation') {
            valueConstructor = cc_1.Quat;
            values = new Array(outputs.length / 4);
            for (let i = 0; i < values.length; ++i) {
                values[i] = new cc_1.Quat(outputs[i * 4 + 0], outputs[i * 4 + 1], outputs[i * 4 + 2], outputs[i * 4 + 3]);
            }
            blendingFunctionName = 'additiveQuat';
        }
        const result = {
            keys: iKeys,
            // blending: blendingFunctionName,
            values,
        };
        switch (gltfSampler.interpolation) {
            case 'STEP':
                result.interpolate = false;
                if (span) {
                    result.values = this._split(result.values, span.from, span.to, (from) => from);
                }
                break;
            case 'CUBICSPLINE':
                if (valueConstructor) {
                    result.interpolate = true;
                    const cubicSplineValueConstructor = (valueConstructor === cc_1.Vec3) ?
                        cc.CubicSplineVec3Value : cc.CubicSplineQuatValue;
                    const csValues = new Array(result.values.length / 3);
                    for (let i = 0; i < csValues.length; ++i) {
                        csValues[i] = new cubicSplineValueConstructor(result.values[i * 3 + 1], result.values[i * 3 + 0], result.values[i * 3 + 2]);
                    }
                    result.values = csValues;
                    if (span && !(span.from === 0 && (span.to + 1) === result.values.length)) {
                        this._logger(GltfConverter.LogLevel.Error, GltfConverter.ConverterError.DisallowCubicSplineChannelSplit, {
                            channel: gltfAnimation.channels.indexOf(gltfChannel),
                            animation: this._gltf.animations.indexOf(gltfAnimation),
                        });
                    }
                }
                break;
            case 'LINEAR':
            default:
                result.interpolate = true;
                if (span) {
                    let lerpFx;
                    switch (propName) {
                        case 'position':
                        case 'scale':
                            lerpFx = (from, to, ratio) => cc_1.Vec3.lerp(new cc_1.Vec3(), from, to, ratio);
                            break;
                        case 'rotation':
                            lerpFx = (from, to, ratio) => cc_1.Quat.lerp(new cc_1.Quat(), from, to, ratio);
                            break;
                        default:
                            lerpFx = (from) => from;
                    }
                    result.values = this._split(result.values, span.from, span.to, lerpFx);
                }
                break;
        }
        jointCurveData[propName] = result;
    }
    _glTFWeightChannelToCurve(gltfAnimation, gltfChannel, iKeys, span) {
        const gltfSampler = gltfAnimation.samplers[gltfChannel.sampler];
        const outputs = this._readAccessorIntoArrayAndNormalizeAsFloat(this._gltf.accessors[gltfSampler.output]);
        const targetNode = this._gltf.nodes[gltfChannel.target.node];
        const targetMesh = this._gltf.meshes[targetNode.mesh];
        const targetCount = targetMesh.primitives[0].targets.length;
        return {
            modifiers: [
                new cc.HierachyModifier(this._mapToSocketPath(this._getNodePath(gltfChannel.target.node))),
                new cc.ComponentModifier(cc.js.getClassName(cc.ModelComponent)),
            ],
            valueAdapter: new cc.animation.MorphWeightsAllValueProxy(),
            data: {
                keys: iKeys,
                values: Array.from(outputs),
                _arrayLength: targetCount,
            },
        };
    }
    _split(array, from, to, lerp) {
        let first;
        let iNext = 0;
        {
            const before = Math.trunc(from);
            const ratio = from - before;
            if (ratio === 0) {
                iNext = before;
            }
            else {
                const past = before + 1;
                first = lerp(array[before], array[past], ratio);
                iNext = past;
            }
        }
        let last;
        let iEnd = 0;
        {
            const before = Math.trunc(to);
            const ratio = to - before;
            if (ratio === 0) {
                iEnd = before;
            }
            else {
                const past = before + 1;
                last = lerp(array[before], array[past], ratio);
                iEnd = before;
            }
        }
        const result = array.slice(iNext, iEnd + 1);
        if (first) {
            result.unshift(first);
        }
        if (last) {
            result.push(last);
        }
        return result;
    }
    _getParent(node) {
        return this._parents[node];
    }
    _commonRoot(nodes) {
        let minPathLen = Infinity;
        const paths = nodes.map((node) => {
            const path = [];
            let curNode = node;
            while (curNode >= 0) {
                path.unshift(curNode);
                curNode = this._getParent(curNode);
            }
            minPathLen = Math.min(minPathLen, path.length);
            return path;
        });
        if (paths.length === 0) {
            return -1;
        }
        const commonPath = [];
        for (let i = 0; i < minPathLen; ++i) {
            const n = paths[0][i];
            if (paths.every((path) => path[i] === n)) {
                commonPath.push(n);
            }
            else {
                break;
            }
        }
        if (commonPath.length === 0) {
            return -1;
        }
        return commonPath[commonPath.length - 1];
    }
    _getSkinRoot(skin) {
        let result = this._skinRoots[skin];
        if (result < 0) {
            result = this._commonRoot(this._gltf.skins[skin].joints);
            if (result < 0) {
                throw new Error(`Non-conforming glTf: skin joints do not have a common root(they are not under same scene).`);
            }
        }
        return result;
    }
    _readPrimitive(glTFPrimitive) {
        let decodedDracoGeometry = null;
        if (glTFPrimitive.extensions) {
            for (const extensionName of Object.keys(glTFPrimitive.extensions)) {
                const extension = glTFPrimitive.extensions[extensionName];
                switch (extensionName) {
                    case 'KHR_draco_mesh_compression':
                        decodedDracoGeometry = this._decodeDracoGeometry(glTFPrimitive, extension);
                        break;
                }
            }
        }
        const primitiveMode = this._getPrimitiveMode(glTFPrimitive.mode === undefined ? 4 /* __DEFAULT */ : glTFPrimitive.mode);
        let indices;
        if (glTFPrimitive.indices !== undefined) {
            let data;
            if (decodedDracoGeometry && decodedDracoGeometry.indices) {
                data = decodedDracoGeometry.indices;
            }
            else {
                const indicesAccessor = this._gltf.accessors[glTFPrimitive.indices];
                data = this._readAccessorIntoArray(indicesAccessor);
            }
            indices = data;
        }
        if (!("POSITION" /* POSITION */ in glTFPrimitive.attributes)) {
            throw new Error(`The primitive doesn't contains positions.`);
        }
        // TODO: mismatch in glTF-sample-module:Monster-Draco?
        const nVertices = decodedDracoGeometry ?
            decodedDracoGeometry.vertices["POSITION" /* POSITION */].length / 3 :
            this._gltf.accessors[glTFPrimitive.attributes["POSITION" /* POSITION */]].count;
        const ppGeometry = new pp_geometry_1.PPGeometry(nVertices, primitiveMode, indices);
        for (const attributeName of Object.getOwnPropertyNames(glTFPrimitive.attributes)) {
            const attributeAccessor = this._gltf.accessors[glTFPrimitive.attributes[attributeName]];
            let data;
            if (decodedDracoGeometry && (attributeName in decodedDracoGeometry.vertices)) {
                const dracoDecodedAttribute = decodedDracoGeometry.vertices[attributeName];
                data = dracoDecodedAttribute;
            }
            else {
                const plainAttribute = this._readAccessorIntoArray(attributeAccessor);
                data = plainAttribute;
            }
            const semantic = glTFAttributeNameToPP(attributeName);
            const components = this._getComponentsPerAttribute(attributeAccessor.type);
            ppGeometry.setAttribute(semantic, data, components);
        }
        if (glTFPrimitive.targets) {
            const attributes = Object.getOwnPropertyNames(glTFPrimitive.targets[0]);
            for (const attribute of attributes) {
                // Check if the morph-attributes are valid.
                const semantic = glTFAttributeNameToPP(attribute);
                if (!pp_geometry_1.PPGeometry.isStdSemantic(semantic) ||
                    ![pp_geometry_1.PPGeometry.StdSemantics.position, pp_geometry_1.PPGeometry.StdSemantics.normal, pp_geometry_1.PPGeometry.StdSemantics.tangent].includes(semantic)) {
                    throw new Error(`Only position, normal, tangent attribute are morph-able, but provide ${attribute}`);
                }
                assertGlTFConformance(ppGeometry.hasAttribute(semantic), `Primitive do not have attribute ${attribute} for morph.`);
                const ppAttribute = ppGeometry.getAttribute(semantic);
                ppAttribute.morphs = new Array(glTFPrimitive.targets.length);
                for (let iTarget = 0; iTarget < glTFPrimitive.targets.length; ++iTarget) {
                    const morphTarget = glTFPrimitive.targets[iTarget];
                    // All targets shall have same morph-attributes.
                    assertGlTFConformance(attribute in morphTarget, `Morph attributes in all target must be same.`);
                    // Extracts the displacements.
                    const attributeAccessor = this._gltf.accessors[morphTarget[attribute]];
                    const morphDisplacement = this._readAccessorIntoArray(attributeAccessor);
                    ppAttribute.morphs[iTarget] = morphDisplacement;
                    // const mainData = ppGeometry.getAttribute(semantic).data;
                    // assertGlTFConformance(ppGeometry.length === data.length,
                    //     `Count of morph attribute ${targetAttribute} mismatch which in primitive.`);
                }
            }
            // If all targets are zero, which means no any displacement, we exclude it from morphing.
            // Should we?
            let nonEmptyMorph = false;
            ppGeometry.forEachAttribute((semantic, attribute) => {
                if (!nonEmptyMorph &&
                    attribute.morphs &&
                    attribute.morphs.some((displacement) => displacement.some((v) => v !== 0))) {
                    nonEmptyMorph = true;
                }
            });
            if (!nonEmptyMorph) {
                this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.EmptyMorph, {});
                ppGeometry.forEachAttribute((semantic, attribute) => {
                    if (attribute.morphs) {
                        attribute.morphs = null;
                    }
                });
            }
        }
        return ppGeometry;
    }
    _decodeDracoGeometry(glTFPrimitive, extension) {
        const bufferView = this._gltf.bufferViews[extension.bufferView];
        const buffer = this._buffers[bufferView.buffer];
        const bufferViewOffset = bufferView.byteOffset === undefined ? 0 : bufferView.byteOffset;
        const compressedData = buffer.slice(bufferViewOffset, bufferViewOffset + bufferView.byteLength);
        const options = {
            buffer: new Int8Array(compressedData),
            attributes: {},
        };
        if (glTFPrimitive.indices !== undefined) {
            options.indices = this._getAttributeBaseTypeStorage(this._gltf.accessors[glTFPrimitive.indices].componentType);
        }
        for (const attributeName of Object.keys(extension.attributes)) {
            if (attributeName in glTFPrimitive.attributes) {
                const accessor = this._gltf.accessors[glTFPrimitive.attributes[attributeName]];
                options.attributes[attributeName] = {
                    uniqueId: extension.attributes[attributeName],
                    storageConstructor: this._getAttributeBaseTypeStorage(accessor.componentType),
                    components: this._getComponentsPerAttribute(accessor.type),
                };
            }
        }
        return khr_draco_mesh_compression_1.decodeDracoGeometry(options);
    }
    _readBounds(glTFPrimitive, minPosition, maxPosition) {
        const iPositionAccessor = glTFPrimitive.attributes["POSITION" /* POSITION */];
        if (iPositionAccessor !== undefined) {
            const positionAccessor = this._gltf.accessors[iPositionAccessor];
            if (positionAccessor.min) {
                minPosition.x = Math.fround(positionAccessor.min[0]);
                minPosition.y = Math.fround(positionAccessor.min[1]);
                minPosition.z = Math.fround(positionAccessor.min[2]);
            }
            if (positionAccessor.max) {
                maxPosition.x = Math.fround(positionAccessor.max[0]);
                maxPosition.y = Math.fround(positionAccessor.max[1]);
                maxPosition.z = Math.fround(positionAccessor.max[2]);
            }
        }
    }
    _applySettings(ppGeometry, normalImportSetting, tangentImportSetting, primitiveIndex, meshIndex) {
        if ((normalImportSetting === glTF_meta_1.NormalImportSetting.recalculate) ||
            (normalImportSetting === glTF_meta_1.NormalImportSetting.require && !ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.normal))) {
            const normals = ppGeometry.calculateNormals();
            ppGeometry.setAttribute(pp_geometry_1.PPGeometry.StdSemantics.normal, normals, 3);
        }
        else if (normalImportSetting === glTF_meta_1.NormalImportSetting.exclude && ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.normal)) {
            ppGeometry.deleteAttribute(pp_geometry_1.PPGeometry.StdSemantics.normal);
        }
        if ((tangentImportSetting === glTF_meta_1.TangentImportSetting.recalculate) ||
            (tangentImportSetting === glTF_meta_1.TangentImportSetting.require && !ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.tangent))) {
            if (!ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.normal)) {
                this._logger(GltfConverter.LogLevel.Warning, GltfConverter.ConverterError.FailedToCalculateTangents, {
                    reason: 'normal',
                    primitive: primitiveIndex,
                    mesh: meshIndex,
                });
            }
            else if (!ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.texcoord)) {
                this._logger(GltfConverter.LogLevel.Debug, GltfConverter.ConverterError.FailedToCalculateTangents, {
                    reason: 'uv',
                    primitive: primitiveIndex,
                    mesh: meshIndex,
                });
            }
            else {
                const tangents = ppGeometry.calculateTangents();
                ppGeometry.setAttribute(pp_geometry_1.PPGeometry.StdSemantics.tangent, tangents, 4);
            }
        }
        else if (tangentImportSetting === glTF_meta_1.TangentImportSetting.exclude && ppGeometry.hasAttribute(pp_geometry_1.PPGeometry.StdSemantics.tangent)) {
            ppGeometry.deleteAttribute(pp_geometry_1.PPGeometry.StdSemantics.tangent);
        }
    }
    _readBufferView(bufferView) {
        const buffer = this._buffers[bufferView.buffer];
        return Buffer.from(buffer.buffer, buffer.byteOffset + (bufferView.byteOffset || 0), bufferView.byteLength);
    }
    _readAccessorIntoArray(gltfAccessor) {
        const storageConstructor = this._getAttributeBaseTypeStorage(gltfAccessor.componentType);
        const result = new storageConstructor(gltfAccessor.count * this._getComponentsPerAttribute(gltfAccessor.type));
        this._readAccessor(gltfAccessor, createDataViewFromTypedArray(result));
        if (gltfAccessor.sparse !== undefined) {
            this._applyDeviation(gltfAccessor, result);
        }
        return result;
    }
    _readAccessorIntoArrayAndNormalizeAsFloat(gltfAccessor) {
        let outputs = this._readAccessorIntoArray(gltfAccessor);
        if (!(outputs instanceof Float32Array)) {
            const normalizedOutput = new Float32Array(outputs.length);
            const normalize = (() => {
                if (outputs instanceof Int8Array) {
                    return (value) => {
                        return Math.max(value / 127.0, -1.0);
                    };
                }
                else if (outputs instanceof Uint8Array) {
                    return (value) => {
                        return value / 255.0;
                    };
                }
                else if (outputs instanceof Int16Array) {
                    return (value) => {
                        return Math.max(value / 32767.0, -1.0);
                    };
                }
                else if (outputs instanceof Uint16Array) {
                    return (value) => {
                        return value / 65535.0;
                    };
                }
                else {
                    return (value) => {
                        return value;
                    };
                }
            })();
            for (let i = 0; i < outputs.length; ++i) {
                normalizedOutput[i] = normalize(outputs[i]); // Do normalize.
            }
            outputs = normalizedOutput;
        }
        return outputs;
    }
    _getSceneNode(iGltfScene, gltfAssetFinder, withTransform = true) {
        const sceneName = this._getGltfXXName(GltfAssetKind.Scene, iGltfScene);
        const result = new cc.Node(sceneName);
        const gltfScene = this._gltf.scenes[iGltfScene];
        if (gltfScene.nodes !== undefined) {
            const mapping = new Array(this._gltf.nodes.length).fill(null);
            for (const node of gltfScene.nodes) {
                const root = this._createEmptyNodeRecursive(node, mapping, withTransform);
                root.parent = result;
            }
            mapping.forEach((node, iGltfNode) => {
                this._setupNode(iGltfNode, mapping, gltfAssetFinder);
            });
        }
        return result;
    }
    _createEmptyNodeRecursive(iGltfNode, mapping, withTransform = true) {
        const gltfNode = this._gltf.nodes[iGltfNode];
        const result = this._createEmptyNode(iGltfNode, withTransform);
        if (gltfNode.children !== undefined) {
            for (const child of gltfNode.children) {
                const childResult = this._createEmptyNodeRecursive(child, mapping, withTransform);
                childResult.parent = result;
            }
        }
        mapping[iGltfNode] = result;
        return result;
    }
    _setupNode(iGltfNode, mapping, gltfAssetFinder) {
        const node = mapping[iGltfNode];
        if (node === null) {
            return;
        }
        const gltfNode = this._gltf.nodes[iGltfNode];
        if (gltfNode.mesh !== undefined) {
            let modelComponent = null;
            if (gltfNode.skin === undefined) {
                modelComponent = node.addComponent(cc.ModelComponent);
            }
            else {
                const skinningModelComponent = node.addComponent(cc.SkinningModelComponent);
                const skeleton = gltfAssetFinder.find('skeletons', gltfNode.skin);
                if (skeleton) {
                    skinningModelComponent.skeleton = skeleton;
                }
                const skinRoot = mapping[this._getSkinRoot(gltfNode.skin)];
                if (skinRoot === null) {
                    this._logger(GltfConverter.LogLevel.Error, GltfConverter.ConverterError.ReferenceSkinInDifferentScene, {
                        node: iGltfNode,
                        skin: gltfNode.skin,
                    });
                }
                else {
                    // assign a temporary root
                    skinningModelComponent.skinningRoot = skinRoot;
                }
                modelComponent = skinningModelComponent;
            }
            const mesh = gltfAssetFinder.find('meshes', gltfNode.mesh);
            if (mesh) {
                // @ts-ignore TS2445
                modelComponent._mesh = mesh;
            }
            const gltfMesh = this.gltf.meshes[gltfNode.mesh];
            const processedMesh = this._processedMeshes[gltfNode.mesh];
            const materials = processedMesh.materialIndices.map((idx) => {
                const gltfPrimitive = gltfMesh.primitives[idx];
                if (gltfPrimitive.material === undefined) {
                    return null;
                }
                else {
                    const material = gltfAssetFinder.find('materials', gltfPrimitive.material);
                    if (material) {
                        return material;
                    }
                }
                return null;
            });
            // @ts-ignore TS2445
            modelComponent._materials = materials;
        }
    }
    _createEmptyNode(iGltfNode, withTransform = true) {
        const gltfNode = this._gltf.nodes[iGltfNode];
        const nodeName = this._getGltfXXName(GltfAssetKind.Node, iGltfNode);
        const node = new cc.Node(nodeName);
        if (!withTransform) {
            return node;
        }
        if (gltfNode.translation) {
            node.setPosition(gltfNode.translation[0], gltfNode.translation[1], gltfNode.translation[2]);
        }
        if (gltfNode.rotation) {
            node.setRotation(this._getNodeRotation(gltfNode.rotation, new cc_1.Quat()));
        }
        if (gltfNode.scale) {
            node.setScale(gltfNode.scale[0], gltfNode.scale[1], gltfNode.scale[2]);
        }
        if (gltfNode.matrix) {
            const ns = gltfNode.matrix;
            const m = this._readNodeMatrix(ns);
            const t = new cc_1.Vec3();
            const r = new cc_1.Quat();
            const s = new cc_1.Vec3();
            cc_1.Mat4.toRTS(m, r, t, s);
            node.setPosition(t);
            node.setRotation(r);
            node.setScale(s);
        }
        return node;
    }
    _readNodeMatrix(ns) {
        return new cc_1.Mat4(ns[0], ns[1], ns[2], ns[3], ns[4], ns[5], ns[6], ns[7], ns[8], ns[9], ns[10], ns[11], ns[12], ns[13], ns[14], ns[15]);
    }
    _getNodePath(node) {
        return this._nodePathTable[node];
    }
    _isAncestorOf(parent, child) {
        if (parent !== child) {
            while (child >= 0) {
                if (child === parent) {
                    return true;
                }
                child = this._getParent(child);
            }
        }
        return false;
    }
    _mapToSocketPath(path) {
        for (const pair of this._socketMappings) {
            if (path !== pair[0] && !path.startsWith(pair[0] + '/')) {
                continue;
            }
            return pair[1] + path.slice(pair[0].length);
        }
        return path;
    }
    _createNodePathTable() {
        if (this._gltf.nodes === undefined) {
            return [];
        }
        const parentTable = new Array(this._gltf.nodes.length).fill(-1);
        this._gltf.nodes.forEach((gltfNode, nodeIndex) => {
            if (gltfNode.children) {
                gltfNode.children.forEach((iChildNode) => {
                    parentTable[iChildNode] = nodeIndex;
                });
                const names = gltfNode.children.map((iChildNode) => {
                    const childNode = this._gltf.nodes[iChildNode];
                    let name = childNode.name;
                    if (typeof name !== 'string' || name.length === 0) {
                        name = null;
                    }
                    return name;
                });
                const uniqueNames = makeUniqueNames(names, uniqueChildNodeNameGenerator);
                uniqueNames.forEach((uniqueName, iUniqueName) => {
                    this._gltf.nodes[gltfNode.children[iUniqueName]].name = uniqueName;
                });
            }
        });
        const nodeNames = new Array(this._gltf.nodes.length).fill('');
        for (let iNode = 0; iNode < nodeNames.length; ++iNode) {
            nodeNames[iNode] = this._getGltfXXName(GltfAssetKind.Node, iNode);
        }
        const result = new Array(this._gltf.nodes.length).fill('');
        this._gltf.nodes.forEach((gltfNode, nodeIndex) => {
            const segments = [];
            for (let i = nodeIndex; i >= 0; i = parentTable[i]) {
                segments.unshift(nodeNames[i]);
            }
            result[nodeIndex] = segments.join('/');
        });
        return result;
    }
    /**
     * Note, if `bufferView` property is not defined, this method will do nothing.
     * So you should ensure that the data area of `outputBuffer` is filled with `0`s.
     * @param gltfAccessor
     * @param outputBuffer
     * @param outputStride
     */
    _readAccessor(gltfAccessor, outputBuffer, outputStride = 0) {
        // When not defined, accessor must be initialized with zeros.
        if (gltfAccessor.bufferView === undefined) {
            return;
        }
        const gltfBufferView = this._gltf.bufferViews[gltfAccessor.bufferView];
        const componentsPerAttribute = this._getComponentsPerAttribute(gltfAccessor.type);
        const bytesPerElement = this._getBytesPerComponent(gltfAccessor.componentType);
        if (outputStride === 0) {
            outputStride = componentsPerAttribute * bytesPerElement;
        }
        const inputStartOffset = (gltfAccessor.byteOffset !== undefined ? gltfAccessor.byteOffset : 0) +
            (gltfBufferView.byteOffset !== undefined ? gltfBufferView.byteOffset : 0);
        const inputBuffer = createDataViewFromBuffer(this._buffers[gltfBufferView.buffer], inputStartOffset);
        const inputStride = gltfBufferView.byteStride !== undefined ?
            gltfBufferView.byteStride : componentsPerAttribute * bytesPerElement;
        const componentReader = this._getComponentReader(gltfAccessor.componentType);
        const componentWriter = this._getComponentWriter(gltfAccessor.componentType);
        for (let iAttribute = 0; iAttribute < gltfAccessor.count; ++iAttribute) {
            const i = createDataViewFromTypedArray(inputBuffer, inputStride * iAttribute);
            const o = createDataViewFromTypedArray(outputBuffer, outputStride * iAttribute);
            for (let iComponent = 0; iComponent < componentsPerAttribute; ++iComponent) {
                const componentBytesOffset = bytesPerElement * iComponent;
                const value = componentReader(i, componentBytesOffset);
                componentWriter(o, componentBytesOffset, value);
            }
        }
    }
    _applyDeviation(glTFAccessor, baseValues) {
        const { sparse } = glTFAccessor;
        // Sparse indices
        const indicesBufferView = this._gltf.bufferViews[sparse.indices.bufferView];
        const indicesBuffer = this._buffers[indicesBufferView.buffer];
        const indicesSc = this._getAttributeBaseTypeStorage(sparse.indices.componentType);
        const sparseIndices = new indicesSc(indicesBuffer.buffer, indicesBuffer.byteOffset + (indicesBufferView.byteOffset || 0) + (sparse.indices.byteOffset || 0), sparse.count);
        // Sparse values
        const valuesBufferView = this._gltf.bufferViews[sparse.values.bufferView];
        const valuesBuffer = this._buffers[valuesBufferView.buffer];
        const valuesSc = this._getAttributeBaseTypeStorage(glTFAccessor.componentType);
        const sparseValues = new valuesSc(valuesBuffer.buffer, valuesBuffer.byteOffset + (valuesBufferView.byteOffset || 0) + (sparse.values.byteOffset || 0));
        const components = this._getComponentsPerAttribute(glTFAccessor.type);
        for (let iComponent = 0; iComponent < components; ++iComponent) {
            for (let iSparseIndex = 0; iSparseIndex < sparseIndices.length; ++iSparseIndex) {
                const sparseIndex = sparseIndices[iSparseIndex];
                baseValues[components * sparseIndex + iComponent] = sparseValues[components * iSparseIndex + iComponent];
            }
        }
    }
    _getPrimitiveMode(mode) {
        if (mode === undefined) {
            mode = 4 /* __DEFAULT */;
        }
        switch (mode) {
            case 0 /* POINTS */: return cc.GFXPrimitiveMode.POINT_LIST;
            case 1 /* LINES */: return cc.GFXPrimitiveMode.LINE_LIST;
            case 2 /* LINE_LOOP */: return cc.GFXPrimitiveMode.LINE_LOOP;
            case 3 /* LINE_STRIP */: return cc.GFXPrimitiveMode.LINE_STRIP;
            case 4 /* TRIANGLES */: return cc.GFXPrimitiveMode.TRIANGLE_LIST;
            case 5 /* TRIANGLE_STRIP */: return cc.GFXPrimitiveMode.TRIANGLE_STRIP;
            case 6 /* TRIANGLE_FAN */: return cc.GFXPrimitiveMode.TRIANGLE_FAN;
            default:
                throw new Error(`Unrecognized primitive mode: ${mode}.`);
        }
    }
    _getAttributeBaseTypeStorage(componentType) {
        switch (componentType) {
            case 5120 /* BYTE */: return Int8Array;
            case 5121 /* UNSIGNED_BYTE */: return Uint8Array;
            case 5122 /* SHORT */: return Int16Array;
            case 5123 /* UNSIGNED_SHORT */: return Uint16Array;
            case 5125 /* UNSIGNED_INT */: return Uint32Array;
            case 5126 /* FLOAT */: return Float32Array;
            default:
                throw new Error(`Unrecognized component type: ${componentType}`);
        }
    }
    _getComponentsPerAttribute(type) {
        switch (type) {
            case "SCALAR" /* SCALAR */: return 1;
            case "VEC2" /* VEC2 */: return 2;
            case "VEC3" /* VEC3 */: return 3;
            case "VEC4" /* VEC4 */:
            case "MAT2" /* MAT2 */: return 4;
            case "MAT3" /* MAT3 */: return 9;
            case "MAT4" /* MAT4 */: return 16;
            default:
                throw new Error(`Unrecognized attribute type: ${type}.`);
        }
    }
    _getBytesPerComponent(componentType) {
        switch (componentType) {
            case 5120 /* BYTE */:
            case 5121 /* UNSIGNED_BYTE */: return 1;
            case 5122 /* SHORT */:
            case 5123 /* UNSIGNED_SHORT */: return 2;
            case 5125 /* UNSIGNED_INT */:
            case 5126 /* FLOAT */: return 4;
            default:
                throw new Error(`Unrecognized component type: ${componentType}`);
        }
    }
    _getComponentReader(componentType) {
        switch (componentType) {
            case 5120 /* BYTE */: return (buffer, offset) => buffer.getInt8(offset);
            case 5121 /* UNSIGNED_BYTE */: return (buffer, offset) => buffer.getUint8(offset);
            case 5122 /* SHORT */: return (buffer, offset) => buffer.getInt16(offset, DataViewUseLittleEndian);
            case 5123 /* UNSIGNED_SHORT */: return (buffer, offset) => buffer.getUint16(offset, DataViewUseLittleEndian);
            case 5125 /* UNSIGNED_INT */: return (buffer, offset) => buffer.getUint32(offset, DataViewUseLittleEndian);
            case 5126 /* FLOAT */: return (buffer, offset) => buffer.getFloat32(offset, DataViewUseLittleEndian);
            default:
                throw new Error(`Unrecognized component type: ${componentType}`);
        }
    }
    _getComponentWriter(componentType) {
        switch (componentType) {
            case 5120 /* BYTE */: return (buffer, offset, value) => buffer.setInt8(offset, value);
            case 5121 /* UNSIGNED_BYTE */: return (buffer, offset, value) => buffer.setUint8(offset, value);
            case 5122 /* SHORT */: return (buffer, offset, value) => buffer.setInt16(offset, value, DataViewUseLittleEndian);
            case 5123 /* UNSIGNED_SHORT */: return (buffer, offset, value) => buffer.setUint16(offset, value, DataViewUseLittleEndian);
            case 5125 /* UNSIGNED_INT */: return (buffer, offset, value) => buffer.setUint32(offset, value, DataViewUseLittleEndian);
            case 5126 /* FLOAT */: return (buffer, offset, value) => buffer.setFloat32(offset, value, DataViewUseLittleEndian);
            default:
                throw new Error(`Unrecognized component type: ${componentType}`);
        }
    }
    _getGltfXXName(assetKind, index) {
        const assetsArrayName = {
            [GltfAssetKind.Animation]: 'animations',
            [GltfAssetKind.Image]: 'images',
            [GltfAssetKind.Material]: 'materials',
            [GltfAssetKind.Node]: 'nodes',
            [GltfAssetKind.Skin]: 'skins',
            [GltfAssetKind.Texture]: 'textures',
            [GltfAssetKind.Scene]: 'scenes',
        };
        const assets = this._gltf[assetsArrayName[assetKind]];
        if (!assets) {
            return '';
        }
        const asset = assets[index];
        if ((typeof asset.name) === 'string') {
            return asset.name;
        }
        else {
            return `${GltfAssetKind[assetKind]}-${index}`;
        }
    }
}
exports.GltfConverter = GltfConverter;
GltfConverter._defaultLogger = (level, error, args) => {
    const message = JSON.stringify({ error, arguments: args }, undefined, 4);
    switch (level) {
        case GltfConverter.LogLevel.Info:
            console.log(message);
            break;
        case GltfConverter.LogLevel.Warning:
            console.warn(message);
            break;
        case GltfConverter.LogLevel.Error:
            console.error(message);
            break;
        case GltfConverter.LogLevel.Debug:
            console.debug(message);
            break;
    }
};
(function (GltfConverter) {
    let LogLevel;
    (function (LogLevel) {
        LogLevel[LogLevel["Info"] = 0] = "Info";
        LogLevel[LogLevel["Warning"] = 1] = "Warning";
        LogLevel[LogLevel["Error"] = 2] = "Error";
        LogLevel[LogLevel["Debug"] = 3] = "Debug";
    })(LogLevel = GltfConverter.LogLevel || (GltfConverter.LogLevel = {}));
    let ConverterError;
    (function (ConverterError) {
        /**
         * glTf requires that skin joints must exists in same scene as node references it.
         */
        ConverterError[ConverterError["ReferenceSkinInDifferentScene"] = 0] = "ReferenceSkinInDifferentScene";
        /**
         * Specified alpha mode is not supported currently.
         */
        ConverterError[ConverterError["UnsupportedAlphaMode"] = 1] = "UnsupportedAlphaMode";
        /**
         * Unsupported texture parameter.
         */
        ConverterError[ConverterError["UnsupportedTextureParameter"] = 2] = "UnsupportedTextureParameter";
        /**
         * Unsupported channel path.
         */
        ConverterError[ConverterError["UnsupportedChannelPath"] = 3] = "UnsupportedChannelPath";
        ConverterError[ConverterError["DisallowCubicSplineChannelSplit"] = 4] = "DisallowCubicSplineChannelSplit";
        ConverterError[ConverterError["FailedToCalculateTangents"] = 5] = "FailedToCalculateTangents";
        /**
         * All targets of the specified sub-mesh are zero-displaced.
         */
        ConverterError[ConverterError["EmptyMorph"] = 6] = "EmptyMorph";
    })(ConverterError = GltfConverter.ConverterError || (GltfConverter.ConverterError = {}));
})(GltfConverter = exports.GltfConverter || (exports.GltfConverter = {}));
function readGltf(gltfFilePath) {
    return __awaiter(this, void 0, void 0, function* () {
        return path.extname(gltfFilePath) === '.glb' ?
            yield readGlb(gltfFilePath) :
            yield readGltfJson(gltfFilePath);
    });
}
exports.readGltf = readGltf;
function readGltfJson(path) {
    return __awaiter(this, void 0, void 0, function* () {
        const gltf = (yield fs.readJSON(path));
        let binaryBuffers = [];
        if (gltf.buffers) {
            binaryBuffers = yield Promise.all(gltf.buffers.map((gltfBuffer) => __awaiter(this, void 0, void 0, function* () {
                if (!gltfBuffer.uri) {
                    return Buffer.alloc(0);
                }
                return yield readBufferData(path, gltfBuffer.uri);
            })));
        }
        return { gltf, binaryBuffers };
    });
}
function readGlb(path) {
    return __awaiter(this, void 0, void 0, function* () {
        const badGLBFormat = () => {
            throw new Error(`Bad glb format.`);
        };
        const glb = yield fs.readFile(path);
        if (glb.length < 12) {
            return badGLBFormat();
        }
        const magic = glb.readUInt32LE(0);
        if (magic !== 0x46546C67) {
            return badGLBFormat();
        }
        const ChunkTypeJson = 0x4E4F534A;
        const ChunkTypeBin = 0x004E4942;
        const version = glb.readUInt32LE(4);
        const length = glb.readUInt32LE(8);
        let gltf;
        let embededBinaryBuffer;
        for (let iChunk = 0, offset = 12; (offset + 8) <= glb.length; ++iChunk) {
            const chunkLength = glb.readUInt32LE(offset);
            offset += 4;
            const chunkType = glb.readUInt32LE(offset);
            offset += 4;
            if (offset + chunkLength > glb.length) {
                return badGLBFormat();
            }
            const payload = Buffer.from(glb.buffer, offset, chunkLength);
            offset += chunkLength;
            if (iChunk === 0) {
                if (chunkType !== ChunkTypeJson) {
                    return badGLBFormat();
                }
                const gltfJson = new TextDecoder('utf-8').decode(payload);
                gltf = JSON.parse(gltfJson);
            }
            else if (chunkType === ChunkTypeBin) {
                // TODO: Should we copy?
                // embededBinaryBuffer = payload.slice();
                embededBinaryBuffer = payload;
            }
        }
        if (!gltf) {
            return badGLBFormat();
        }
        else {
            let binaryBuffers = [];
            if (gltf.buffers) {
                binaryBuffers = yield Promise.all(gltf.buffers.map((gltfBuffer, index) => __awaiter(this, void 0, void 0, function* () {
                    if (!gltfBuffer.uri) {
                        if (index === 0 && embededBinaryBuffer) {
                            return embededBinaryBuffer;
                        }
                        return Buffer.alloc(0);
                    }
                    return yield readBufferData(path, gltfBuffer.uri);
                })));
            }
            return { gltf, binaryBuffers };
        }
    });
}
function isDataUri(uri) {
    return uri.startsWith('data:');
}
exports.isDataUri = isDataUri;
class BufferBlob {
    constructor() {
        this._arrayBufferOrPaddings = [];
        this._length = 0;
    }
    setNextAlignment(align) {
        if (align !== 0) {
            const remainder = this._length % align;
            if (remainder !== 0) {
                const padding = align - remainder;
                this._arrayBufferOrPaddings.push(padding);
                this._length += padding;
            }
        }
    }
    addBuffer(arrayBuffer) {
        const result = this._length;
        this._arrayBufferOrPaddings.push(arrayBuffer);
        this._length += arrayBuffer.byteLength;
        return result;
    }
    getLength() {
        return this._length;
    }
    getCombined() {
        const result = new Uint8Array(this._length);
        let counter = 0;
        this._arrayBufferOrPaddings.forEach((arrayBufferOrPadding) => {
            if (typeof arrayBufferOrPadding === 'number') {
                counter += arrayBufferOrPadding;
            }
            else {
                result.set(new Uint8Array(arrayBufferOrPadding), counter);
                counter += arrayBufferOrPadding.byteLength;
            }
        });
        return result;
    }
}
function readBufferData(gltfFilePath, uri) {
    return __awaiter(this, void 0, void 0, function* () {
        const dataURI = DataURI.parse(uri);
        if (!dataURI) {
            const bufferPath = path.resolve(path.dirname(gltfFilePath), uri);
            return yield fs.readFile(bufferPath);
        }
        else {
            return Buffer.from(resolveBufferDataURI(dataURI));
        }
    });
}
function createDataViewFromBuffer(buffer, offset = 0) {
    return new DataView(buffer.buffer, buffer.byteOffset + offset);
}
function createDataViewFromTypedArray(typedArray, offset = 0) {
    return new DataView(typedArray.buffer, typedArray.byteOffset + offset);
}
const DataViewUseLittleEndian = true;
function uniqueChildNodeNameGenerator(original, last, index, count) {
    const postfix = count === 0 ? '' : `-${count}`;
    return `${original || ''}(__autogen ${index}${postfix})`;
}
function makeUniqueNames(names, generator) {
    const uniqueNames = new Array(names.length).fill('');
    for (let i = 0; i < names.length; ++i) {
        let name = names[i];
        let count = 0;
        while (true) {
            const isUnique = () => uniqueNames.every((uniqueName, index) => {
                return index === i || name !== uniqueName;
            });
            if (name === null || !isUnique()) {
                name = generator(names[i], name, i, count++);
            }
            else {
                uniqueNames[i] = name;
                break;
            }
        }
    }
    return uniqueNames;
}
function resolveBufferDataURI(uri) {
    // https://github.com/KhronosGroup/glTF/issues/944
    if (!uri.base64 ||
        !uri.mediaType ||
        !(uri.mediaType.value === 'application/octet-stream' || uri.mediaType.value === 'application/gltf-buffer')) {
        throw new Error(`Cannot understand data uri(base64: ${uri.base64}, mediaType: ${uri.mediaType}) for buffer.`);
    }
    return base64_1.decodeBase64ToArrayBuffer(uri.data);
}
function resolveImageDataURI(uri) {
    if (!uri.base64 || !uri.mediaType || uri.mediaType.type !== 'image') {
        throw new Error(`Cannot understand data uri(base64: ${uri.base64}, mediaType: ${uri.mediaType}) for image.`);
    }
    const data = base64_1.decodeBase64ToArrayBuffer(uri.data);
    return {
        imageData: Buffer.from(data),
        extName: `.${uri.mediaType.subtype}`,
    };
}
exports.resolveImageDataURI = resolveImageDataURI;
class DynamicArrayBuffer {
    constructor(reserve) {
        this._size = 0;
        this._arrayBuffer = new ArrayBuffer(Math.max(reserve || 0, 4));
    }
    get arrayBuffer() {
        return this._arrayBuffer;
    }
    grow(growSize) {
        const szBeforeGrow = this._size;
        if (growSize) {
            const cap = this._arrayBuffer.byteLength;
            const space = cap - szBeforeGrow;
            const req = space - growSize;
            if (req < 0) {
                // assert(cap >= 4)
                const newCap = (cap + -req) * 1.5;
                const newArrayBuffer = new ArrayBuffer(newCap);
                new Uint8Array(newArrayBuffer, 0, cap).set(new Uint8Array(this._arrayBuffer));
                this._arrayBuffer = newArrayBuffer;
            }
            this._size += growSize;
        }
        return szBeforeGrow;
    }
    shrink() {
        return this._arrayBuffer.slice(0, this._size);
    }
}
function getDataviewWritterOfTypedArray(typedArray, littleEndian) {
    switch (typedArray.constructor) {
        case Int8Array:
            return (dataView, byteOffset, value) => dataView.setInt8(byteOffset, value);
        case Uint8Array:
            return (dataView, byteOffset, value) => dataView.setUint8(byteOffset, value);
        case Int16Array:
            return (dataView, byteOffset, value) => dataView.setInt16(byteOffset, value, littleEndian);
        case Uint16Array:
            return (dataView, byteOffset, value) => dataView.setUint16(byteOffset, value, littleEndian);
        case Int32Array:
            return (dataView, byteOffset, value) => dataView.setInt32(byteOffset, value, littleEndian);
        case Uint32Array:
            return (dataView, byteOffset, value) => dataView.setUint32(byteOffset, value, littleEndian);
        case Float32Array:
            return (dataView, byteOffset, value) => dataView.setFloat32(byteOffset, value, littleEndian);
        default:
            throw new Error(`Bad storage constructor.`);
    }
}
function interleaveVertices(ppGeometry) {
    const vertexCount = ppGeometry.vertexCount;
    let vertexStride = 0;
    ppGeometry.forEachAttribute((semantic, attribute) => {
        vertexStride += (attribute.data.BYTES_PER_ELEMENT * attribute.components);
    });
    const vertexBuffer = new ArrayBuffer(vertexCount * vertexStride);
    const vertexBufferView = new DataView(vertexBuffer);
    let currentByteOffset = 0;
    const formats = [];
    ppGeometry.forEachAttribute((semantic, attribute) => {
        const attributeData = attribute.data;
        const dataviewWritter = getDataviewWritterOfTypedArray(attributeData, DataViewUseLittleEndian);
        for (let iVertex = 0; iVertex < vertexCount; ++iVertex) {
            const offset1 = currentByteOffset + vertexStride * iVertex;
            for (let iComponent = 0; iComponent < attribute.components; ++iComponent) {
                const value = attributeData[attribute.components * iVertex + iComponent];
                dataviewWritter(vertexBufferView, offset1 + attributeData.BYTES_PER_ELEMENT * iComponent, value);
            }
        }
        currentByteOffset += (attribute.data.BYTES_PER_ELEMENT * attribute.components);
        formats.push({
            name: attribute.gfxAttributeName,
            format: attribute.getGFXFormat(),
            isNormalized: false,
        });
    });
    return {
        vertexCount,
        vertexStride,
        formats,
        vertexBuffer,
    };
}
const glTFAttributeNameToPP = (() => {
    return (attributeName) => {
        if (attributeName.startsWith('_')) {
            // Application-specific semantics must start with an underscore
            return attributeName;
        }
        const attributeNameRegexMatches = /([a-zA-Z]+)(?:_(\d+))?/g.exec(attributeName);
        if (!attributeNameRegexMatches) {
            return attributeName;
        }
        const attributeBaseName = attributeNameRegexMatches[1];
        let stdSemantic;
        const set = parseInt(attributeNameRegexMatches[2] || '0');
        switch (attributeBaseName) {
            case 'POSITION':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.position;
                break;
            case 'NORMAL':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.normal;
                break;
            case 'TANGENT':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.tangent;
                break;
            case 'COLOR':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.color;
                break;
            case 'TEXCOORD':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.texcoord;
                break;
            case 'JOINTS':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.joints;
                break;
            case 'WEIGHTS':
                stdSemantic = pp_geometry_1.PPGeometry.StdSemantics.weights;
                break;
        }
        if (stdSemantic === undefined) {
            return attributeName;
        }
        else {
            return pp_geometry_1.PPGeometry.StdSemantics.set(stdSemantic, set);
        }
    };
})();
class GlTfConformanceError extends Error {
}
exports.GlTfConformanceError = GlTfConformanceError;
function assertGlTFConformance(expr, message) {
    if (!expr) {
        throw new GlTfConformanceError(`glTF non-conformance error: ${message}`);
    }
}

(() => {
    var converter = require(filename);
    converter.GltfConverter = GltfConverter;
})()