const selectMap = [
    [0, 3, 6, 4, 8, 5, 2, 1], //条件1
    [0, 3, 6, 4, 8, 5, 2], //星空
]
cc.Class({
    extends: cc.Component,

    properties: {
        _itemSize: 55,
        itemNodeArr: [cc.Node],
        bgNode: cc.Node,
        linePrefab: cc.Prefab,
        lineRootNode: cc.Node
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {
        this.posArr = [];
        for (let i = 0; i < this.itemNodeArr.length; i++) {
            this.posArr.push(this.itemNodeArr[i].getPosition());
        };
        this.init();
        this.initTouchNode();
    },

    initTouchNode() {
        this.bgNode.on(cc.Node.EventType.TOUCH_START, event => {
            if (this.touchuId == -1) {
                this.touchuId = event.getID();
            }
            if (this.touchuId != event.getID()) return;
            this.selectIndexArr = [];
            let pos = this.bgNode.parent.convertToNodeSpaceAR(event.getLocation());
            this.judge(pos);
        });
        this.bgNode.on(cc.Node.EventType.TOUCH_MOVE, event => {
            if (this.touchuId != event.getID()) return;
            //方向
            let pos = this.bgNode.parent.convertToNodeSpaceAR(event.getLocation());
            this.judge(pos);
        });

        this.bgNode.on(cc.Node.EventType.TOUCH_END, event => {
            if (this.touchuId != event.getID()) return;
            let endPos = this.bgNode.parent.convertToNodeSpaceAR(event.getLocation());
            this.touchuId = -1;
            this.judge(endPos);
            this.check();
            this.clear();
        });

        this.bgNode.on(cc.Node.EventType.TOUCH_CANCEL, event => {
            if (this.touchuId != event.getID()) return;
            let endPos = this.bgNode.parent.convertToNodeSpaceAR(event.getLocation());
            this.touchuId = -1;
            this.judge(endPos);
            this.check();
            this.clear();
        });
    },

    judge(pos) {
        let index = this.judgeIndexItem(pos);
        if (index > -1) {
            let flag = this.judgeInSelectArr(index);
            if (flag == -1) {
                //当前连线点固定
                if (this.lineNode) {
                    let dis = _toolFun.disBetweenTwoPos(this.posArr[index], this.posArr[this.selectIndexArr[this.selectIndexArr.length - 1]]);
                    let angle = _toolFun.getAngle(this.posArr[this.selectIndexArr[this.selectIndexArr.length - 1]], this.posArr[index]);
                    this.lineNode.angle = angle;
                    this.lineNode.getChildByName("spr").getComponent(cc.Sprite).fillRange = dis / this.lineNode.getChildByName("spr").width;
                    this.lineNode = undefined;
                }
                if (!this.lineNode) this.addLine(this.posArr[index], index);
            } else {
                //当前点已经选择过，不能再连
                this.updateLineNode(pos);
            }
        } else {
            if (this.lineNode) {
                //更新连线的角度长度
                this.updateLineNode(pos);
            }
        }
    },

    updateLineNode(pos) {
        let index = this.selectIndexArr[this.selectIndexArr.length - 1];
        let dis = _toolFun.disBetweenTwoPos(pos, this.posArr[index]);
        let angle = _toolFun.getAngle(this.posArr[index], pos);
        this.lineNode.angle = angle;
        this.lineNode.getChildByName("spr").getComponent(cc.Sprite).fillRange = dis / this.lineNode.getChildByName("spr").width;
    },

    judgeInSelectArr(index) {
        let flag = this.selectIndexArr.indexOf(index);
        return flag;
    },

    judgeIndexItem(pos) {
        for (let i = 0; i < this.posArr.length; i++) {
            if (_toolFun.disBetweenTwoPos(pos, this.posArr[i]) < this._itemSize) return i;
        }
        return -1;
    },

    addLine(pos, index) {
        this.lineNode = cc.instantiate(this.linePrefab);
        this.lineNode.parent = this.lineRootNode;
        this.lineNode.setPosition(pos);

        this.selectIndexArr.push(index);
        this.itemNodeArr[index].color = new cc.Color(255, 255, 255);
    },

    init(data) {
        this.clear();
    },

    clear() {
        this.selectIndexArr = [];
        this.touchuId = -1;
        this.lineNode = undefined;
        for (let i = 0; i < this.itemNodeArr.length; i++) {
            this.itemNodeArr[i].color = new cc.Color(150, 150, 150);
        }
        this.lineRootNode.removeAllChildren();
    },

    btnCallBack(e, data) {
        audioCon.playAudioEff('click');
        switch (data) {
            case "close":
                this.removeNode();
                break;
        }
    },

    //隐藏面板
    removeNode() {
        _ui_mager.hidePrefabWin('huaPinNode');
    },

    check() {
        for (let i = 0; i < selectMap.length; i++) {
            if (selectMap[i].equals(this.selectIndexArr)) {
                // console.log('-------------触发条件', i);
                window.ranchNode.showXingKong();
                this.removeNode();
            }
        }
    }

    // update (dt) {},
});