// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class ChangeLabelText extends cc.Component {
    textLabelList: Array<cc.Label>;
    spriteNodeList: Array<cc.Node>;
    addButton: cc.Button;
    reduceButton: cc.Button;
    nodeMap: Map<string, cc.Node>;

    start() {
        this.textLabelList = new Array<cc.Label>(
            cc.find('Canvas/TestLayout/TipLabel').getComponent(cc.Label),
            cc.find('Canvas/Layout/TestLayout/TipLabel').getComponent(cc.Label)

        );

        this.spriteNodeList = new Array<cc.Node>(
            cc.find('Canvas/TestLayout/SpriteNode'),
            cc.find('Canvas/Layout/TestLayout/SpriteNode')
        )

        this.textLabelList[1].string = this.textLabelList[0].string
        this.seekButton();
    }
    seekButton() {
        this.nodeMap = new Map<string, cc.Node>([
            ['addLabelText', cc.find('Canvas/ButtonLayout/HorizontalLayout/AddButton')],
            ['reduceLabelText', cc.find('Canvas/ButtonLayout/HorizontalLayout2/ReduceButton')],
            ['addSpriteWidth', cc.find('Canvas/ButtonLayout/HorizontalLayout3/AddSpriteWidthButton')],
            ['reduceSpriteWidth', cc.find('Canvas/ButtonLayout/HorizontalLayout4/ReduceSpriteWidthButton')]
        ]);

        let componentName = /<(\w+)>/gi.exec(this.name)[1];

        this.nodeMap.forEach((node, handlerName) => {
            let clickEventHandler = new cc.Component.EventHandler();
            clickEventHandler.target = this.node;
            clickEventHandler.component = componentName;
            clickEventHandler.handler = handlerName;
            // clickEventHandler.customEventData = "foobar";

            let button = node.getComponent(cc.Button);
            button.clickEvents.push(clickEventHandler);
            // console.log(`handlerName:${handlerName},node:${node.name}`);
        })


    }
    addLabelText() {
        let charA = 'a';
        let charZ = 'z';
        let charLength = charZ.charCodeAt(0) - charA.charCodeAt(0) + 1;

        for (let i = 0; i < 3; i++) {
            let random = Math.floor(charA.charCodeAt(0) + Math.random() * charLength);
            let char = String.fromCharCode(random);
            char = Math.random() > 0.5 ? char.toUpperCase() : char;
            console.log(`addLabelText,char code:${char.charCodeAt(0)},char:${char}`);
            this.textLabelList.forEach(label => {
                label.string += char;
            })
        }

    }
    reduceLabelText() {
        for (let i = 0; i < 3; i++) {
            let length = this.textLabelList[0].string.length;
            if (length < 1) {
                return;
            }
            let index = Math.floor(Math.random() * length);
            let charArr = this.textLabelList[0].string.split('')
            let text = charArr.splice(index, 1);
            console.log(`reduceLabelText:${text.join()}`);
            this.textLabelList.forEach(label => {
                label.string = charArr.join('');
            });
        }

    }
    addSpriteWidth() {
        this.spriteNodeList.forEach(node => {
            node.width += 50;
        })
    }
    reduceSpriteWidth() {
        this.spriteNodeList.forEach(node => {
            if(node.width>=50){
                node.width -= 50;
            }
            
        })
    }
    onDestroy() {
        this.nodeMap.forEach((node, key) => {
            node.getComponent(cc.Button).clickEvents = [];
        });
    }
    // update (dt) {}
}
