(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Scripts/ChangeLabelText.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '144f2E9rg5CK6Dze/WVKx9b', 'ChangeLabelText', __filename);
// Scripts/ChangeLabelText.ts

// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChangeLabelText = /** @class */ (function (_super) {
    __extends(ChangeLabelText, _super);
    function ChangeLabelText() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeLabelText.prototype.start = function () {
        this.textLabelList = new Array(cc.find('Canvas/TestLayout/TipLabel').getComponent(cc.Label), cc.find('Canvas/Layout/TestLayout/TipLabel').getComponent(cc.Label));
        this.spriteNodeList = new Array(cc.find('Canvas/TestLayout/SpriteNode'), cc.find('Canvas/Layout/TestLayout/SpriteNode'));
        this.textLabelList[1].string = this.textLabelList[0].string;
        this.seekButton();
    };
    ChangeLabelText.prototype.seekButton = function () {
        var _this = this;
        this.nodeMap = new Map([
            ['addLabelText', cc.find('Canvas/ButtonLayout/HorizontalLayout/AddButton')],
            ['reduceLabelText', cc.find('Canvas/ButtonLayout/HorizontalLayout2/ReduceButton')],
            ['addSpriteWidth', cc.find('Canvas/ButtonLayout/HorizontalLayout3/AddSpriteWidthButton')],
            ['reduceSpriteWidth', cc.find('Canvas/ButtonLayout/HorizontalLayout4/ReduceSpriteWidthButton')]
        ]);
        var componentName = /<(\w+)>/gi.exec(this.name)[1];
        this.nodeMap.forEach(function (node, handlerName) {
            var clickEventHandler = new cc.Component.EventHandler();
            clickEventHandler.target = _this.node;
            clickEventHandler.component = componentName;
            clickEventHandler.handler = handlerName;
            // clickEventHandler.customEventData = "foobar";
            var button = node.getComponent(cc.Button);
            button.clickEvents.push(clickEventHandler);
            // console.log(`handlerName:${handlerName},node:${node.name}`);
        });
    };
    ChangeLabelText.prototype.addLabelText = function () {
        var charA = 'a';
        var charZ = 'z';
        var charLength = charZ.charCodeAt(0) - charA.charCodeAt(0) + 1;
        var _loop_1 = function (i) {
            var random = Math.floor(charA.charCodeAt(0) + Math.random() * charLength);
            var char = String.fromCharCode(random);
            char = Math.random() > 0.5 ? char.toUpperCase() : char;
            console.log("addLabelText,char code:" + char.charCodeAt(0) + ",char:" + char);
            this_1.textLabelList.forEach(function (label) {
                label.string += char;
            });
        };
        var this_1 = this;
        for (var i = 0; i < 3; i++) {
            _loop_1(i);
        }
    };
    ChangeLabelText.prototype.reduceLabelText = function () {
        var _loop_2 = function (i) {
            var length = this_2.textLabelList[0].string.length;
            if (length < 1) {
                return { value: void 0 };
            }
            var index = Math.floor(Math.random() * length);
            var charArr = this_2.textLabelList[0].string.split('');
            var text = charArr.splice(index, 1);
            console.log("reduceLabelText:" + text.join());
            this_2.textLabelList.forEach(function (label) {
                label.string = charArr.join('');
            });
        };
        var this_2 = this;
        for (var i = 0; i < 3; i++) {
            var state_1 = _loop_2(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    };
    ChangeLabelText.prototype.addSpriteWidth = function () {
        this.spriteNodeList.forEach(function (node) {
            node.width += 50;
        });
    };
    ChangeLabelText.prototype.reduceSpriteWidth = function () {
        this.spriteNodeList.forEach(function (node) {
            if (node.width >= 50) {
                node.width -= 50;
            }
        });
    };
    ChangeLabelText.prototype.onDestroy = function () {
        this.nodeMap.forEach(function (node, key) {
            node.getComponent(cc.Button).clickEvents = [];
        });
    };
    ChangeLabelText = __decorate([
        ccclass
    ], ChangeLabelText);
    return ChangeLabelText;
}(cc.Component));
exports.default = ChangeLabelText;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ChangeLabelText.js.map
        