const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    start() {
        this.playDragon();
    }

    playDragon() {

        let ske = "https://osshezhitao.oss-cn-beijing.aliyuncs.com/dragon/dragon01/Blingblingdengdui_ske.json";
        let texJson = ["https://osshezhitao.oss-cn-beijing.aliyuncs.com/dragon/dragon01/Blingblingdengdui_tex_0.json", "https://osshezhitao.oss-cn-beijing.aliyuncs.com/dragon/dragon01/Blingblingdengdui_tex_1.json"];
        let texImage = ["https://osshezhitao.oss-cn-beijing.aliyuncs.com/dragon/dragon01/Blingblingdengdui_tex_0.png", "https://osshezhitao.oss-cn-beijing.aliyuncs.com/dragon/dragon01/Blingblingdengdui_tex_1.png"];

        var node = new cc.Node();
        var dragonDisplay = node.addComponent(dragonBones.ArmatureDisplay);
        this.node.addChild(node);

        var asset = new dragonBones.DragonBonesAsset();
        var atlas = new dragonBones.DragonBonesAtlasAsset();
        cc.loader.load({ url: ske, type: 'txt' }, function (error, dragonBonesJson) {
            asset.dragonBonesJson = dragonBonesJson;
            dragonDisplay.dragonAsset = asset;

            for (let i = 0; i < 2; i++) {
                let image = texImage[i];
                let atl = texJson[i];
                cc.loader.load(image, function (error, texture) {
                    cc.loader.load({ url: atl, type: 'txt' }, function (error, atlasJson) {
                        atlas.atlasJson = atlasJson;
                        atlas.texture = image;
                        dragonDisplay.dragonAtlasAsset = atlas;
                        let armatureName = dragonDisplay.getArmatureNames()[0];
                        dragonDisplay.armatureName = armatureName
                        let name = dragonDisplay.getAnimationNames(armatureName)[0];
                        if (i == 1) {
                            dragonDisplay.playAnimation(name, 1);
                            dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, function () {
                                cc.log("播放完毕")
                            }, node);
                        }

                    })
                })
            }
        });
    }
}
