cc.Class({
    extends: cc.Component,

    properties: {
        enemyPrefab: cc.Prefab,
        _enemyPool: null,
    },

    onDestroy() {
        this._enemyPool.clear(); // 调用这个方法就可以清空对象池
    },
    // use this for initialization
    onLoad: function () {
        this._enemyPool = new cc.NodePool('Enemy'); //创建对象池

        this.node.on(cc.Node.EventType.TOUCH_END, () => {
            this.shot();
        }, this);
    },

    shot() {
        let sf = null;
        let pos = cc.p(0, 0);
        let parent = this.node;
        this.createEnemy(sf, pos, parent, (enemy) => {
            enemy.on(cc.Node.EventType.TOUCH_START, (event) => {
                cc.log('点击对象开始时');
                //也可以用 event.currentTarget 来获取enemy
                //销毁
                this.enemyKilled(enemy);
                //屏蔽传递
                event.stopPropagation();
            }, this);

            enemy.on(cc.Node.EventType.TOUCH_END, (event) => {
                cc.log('点击对象结束时');
                //屏蔽传递
                event.stopPropagation();
            }, this);

            //对对象进行一些处理，比如动作啊什么的
            //这里  让子弹飞一会儿 之后进行销毁
            let action = cc.moveBy(2, cc.p(Math.random() * 600 - 300, Math.random() * 800 - 400));
            let seq = cc.sequence(action, cc.callFunc(() => {
                this.enemyKilled(enemy);
            }, this));
            enemy.runAction(seq);
        });
    },

    enemyKilled: function (enemy) {
        // enemy 应该是一个 cc.Node
        this._enemyPool.put(enemy); // 和初始化时的方法一样，将节点放进对象池，这个方法会同时调用节点的 removeFromParent
        cc.log('---------销毁了一个对象--------');
    },

    /**
     * 
     * @param {any} sf          图片
     * @param {any} pos         坐标点
     * @param {any} parentNode  父节点
     * @param {any} initCB      创建完成的回调 (这个回调可用可不用，也可以retuen enemy来对对象处理它)
     */
    createEnemy: function (sf, pos, parentNode, initCB) {
        let enemy = null;
        if (this._enemyPool.size() > 0) { // 通过 size 接口判断对象池中是否有空闲的对象
            enemy = this._enemyPool.get();
        } else { // 如果没有空闲对象，也就是对象池中备用对象不够时，我们就用 cc.instantiate 重新创建
            enemy = cc.instantiate(this.enemyPrefab);
        }
        enemy.getComponent('Enemy').initData(sf, pos, parentNode); //接下来就可以调用 enemy 身上的脚本进行初始化

        //对象池的回调方法
        if (initCB) {
            initCB(enemy);
        }
    },
});
