"use strict";
cc._RF.push(module, '2aba0PGYblI7L/3CCgTmEe1', 'GaussBlurs');
// script/app/components/shader/shaders/GaussBlurs.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader= 高斯模糊
var GaussBlurs = /** @class */ (function (_super) {
    __extends(GaussBlurs, _super);
    function GaussBlurs() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "GaussBlurs";
        _this.params = [{ name: 'bluramount', type: _this.renderer.PARAM_FLOAT },];
        _this.defines = [];
        _this.frag = "\n    uniform sampler2D texture;\n    varying vec2 uv0;\n    uniform float bluramount;\n\n    vec4 draw(vec2 uv) {\n        return texture2D(texture, uv).rgba; \n    }\n\n    float grid(float var, float size) {\n        return floor(var*size)/size;\n    }\n\n    float rand(vec2 co){\n        return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n    }\n\n    void mainImage( out vec4 fragColor, in vec2 uv0 )\n    {\n        vec2 uv = uv0.xy;\n        vec4 blurred_image = vec4(0.);\n        #define repeats 5.\n        for (float i = 0.; i < repeats; i++) { \n            vec2 q = vec2(cos(degrees((i/repeats)*360.)),sin(degrees((i/repeats)*360.))) * (rand(vec2(i,uv.x+uv.y))+bluramount); \n            vec2 uv2 = uv+(q*bluramount);\n            blurred_image += draw(uv2)/2.;\n            q = vec2(cos(degrees((i/repeats)*360.)),sin(degrees((i/repeats)*360.))) * (rand(vec2(i+2.,uv.x+uv.y+24.))+bluramount); \n            uv2 = uv+(q*bluramount);\n            blurred_image += draw(uv2)/2.;\n        }\n        blurred_image /= repeats;\n        fragColor = vec4(blurred_image);\n    }\n\n    void main()\n    {\n        mainImage(gl_FragColor, uv0.xy);\n    }";
        return _this;
    }
    return GaussBlurs;
}(Shader_1.default));
exports.default = GaussBlurs;

cc._RF.pop();