"use strict";
cc._RF.push(module, '6585duBTlFF0a0x5qracuXs', 'Mosaic');
// script/app/components/shader/shaders/Mosaic.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader: 方形马赛克
var Mosaic = /** @class */ (function (_super) {
    __extends(Mosaic, _super);
    function Mosaic() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "Mosaic";
        _this.params = [
            { name: 'resolution', type: _this.renderer.PARAM_FLOAT3 },
            { name: 'mosaicSize', type: _this.renderer.PARAM_FLOAT },
            { name: 'time', type: _this.renderer.PARAM_FLOAT },
        ];
        _this.defines = [];
        _this.frag = "\n    uniform sampler2D texture;\n    uniform vec3 resolution;\n    uniform float mosaicSize;\n    varying vec2 uv0;\n     \n    void main(void)\n    {\n        vec4 color;\n        vec2 xy = vec2(uv0.x * resolution.x, uv0.y * resolution.y);\n        vec2 xyMosaic = vec2(floor(xy.x / mosaicSize) * mosaicSize, floor(xy.y / mosaicSize) * mosaicSize);\n        vec2 xyFloor = vec2(floor(mod(xy.x, mosaicSize)), floor(mod(xy.y, mosaicSize)));\n        vec2 uvMosaic = vec2(xyMosaic.x / resolution.x, xyMosaic.y / resolution.y);\n        color = texture2D( texture, uvMosaic);\n        gl_FragColor = color; \n    }";
        return _this;
    }
    return Mosaic;
}(Shader_1.default));
exports.default = Mosaic;

cc._RF.pop();