"use strict";
cc._RF.push(module, 'f82d3odBu5FAITZ1XNDSmFt', 'RadialBlur');
// script/app/components/shader/shaders/RadialBlur.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader: 径向模糊
var RadialBlur = /** @class */ (function (_super) {
    __extends(RadialBlur, _super);
    function RadialBlur() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "RadialBlur";
        _this.defines = [];
        _this.params = [
            { name: 'iCenter', type: _this.renderer.PARAM_FLOAT2 },
        ];
        _this.frag = "\n    uniform sampler2D texture;\n    uniform vec2 iCenter;\n    varying vec2 uv0;\n\n    void mainImage( out vec4 fragColor, in vec2 fragCoord )\n    {\n        const float Strength = 0.125;    \n        const int Samples = 64; //multiple of 2\n        \n        vec2 uv = fragCoord.xy;\n        \n        vec2 dir = (fragCoord.xy-iCenter.xy);\n    \n        vec4 color = vec4(0.0,0.0,0.0,0.0);\n        \n        for (int i = 0; i < Samples; i += 2) //operating at 2 samples for better performance\n        {\n            color += texture2D(texture,uv+float(i)/float(Samples)*dir*Strength);\n            color += texture2D(texture,uv+float(i+1)/float(Samples)*dir*Strength);\n        }   \n        \n        fragColor = color/float(Samples);\n    }\n     \n    void main(void)\n    {\n        mainImage(gl_FragColor, uv0);\n    }";
        return _this;
    }
    return RadialBlur;
}(Shader_1.default));
exports.default = RadialBlur;

cc._RF.pop();