(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/ShaderSprite.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '278b6FecIFBNpVPzKMedzFS', 'ShaderSprite', __filename);
// script/components/ShaderSprite.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ShaderManager_1 = require("./shader/ShaderManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, disallowMultiple = _a.disallowMultiple, requireComponent = _a.requireComponent, executeInEditMode = _a.executeInEditMode;
var NeedUpdate = [ShaderManager_1.ShaderType.Fluxay, ShaderManager_1.ShaderType.WaveShader, ShaderManager_1.ShaderType.Water, ShaderManager_1.ShaderType.RainShader, ShaderManager_1.ShaderType.FluxaySuper];
var BaseShaderSprite = /** @class */ (function (_super) {
    __extends(BaseShaderSprite, _super);
    function BaseShaderSprite() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._shader = ShaderManager_1.ShaderType.Default;
        _this.startTime = 0;
        return _this;
    }
    Object.defineProperty(BaseShaderSprite.prototype, "shader", {
        get: function () { return this._shader; },
        set: function (type) {
            this._shader = type;
            this.applyShaderSettings();
        },
        enumerable: true,
        configurable: true
    });
    BaseShaderSprite.prototype.start = function () {
        this.sprite = this.node.getComponent(cc.Sprite);
        this.applyShaderSettings();
    };
    BaseShaderSprite.prototype.update = function (dt) {
        var mat = this.sprite.getCurrMaterial();
        if (!mat)
            return;
        if (NeedUpdate.indexOf(this._shader) >= 0) {
            var deltaTime = new Date().getTime() - this.startTime;
            mat.setParamValue('time', deltaTime / 1000);
        }
    };
    BaseShaderSprite.prototype.applyShaderSettings = function () {
        // console.log("shaderType:" + ShaderType[this._shader]);
        var mat = ShaderManager_1.default.instance().setShader(this.sprite, this._shader);
        if (!mat)
            return;
        switch (this._shader) {
            case ShaderManager_1.ShaderType.Blur:
            case ShaderManager_1.ShaderType.GaussBlurs:
                mat.setParamValue('bluramount', 0.05);
                break;
            case ShaderManager_1.ShaderType.WaveShader:
                mat.setParamValue('iOffset', new cc.Vec2(0, 0.1));
                break;
            case ShaderManager_1.ShaderType.Mosaic:
                mat.setParamValue('mosaicSize', 10);
                break;
            default:
                break;
        }
        this.startTime = new Date().getTime();
    };
    BaseShaderSprite.prototype.onDestroy = function () {
        this.sprite && this.sprite.setState(0);
    };
    __decorate([
        property({ visible: false })
    ], BaseShaderSprite.prototype, "_shader", void 0);
    __decorate([
        property({ type: cc.Enum(ShaderManager_1.ShaderType) })
    ], BaseShaderSprite.prototype, "shader", null);
    BaseShaderSprite = __decorate([
        ccclass,
        disallowMultiple,
        executeInEditMode,
        requireComponent(cc.Sprite)
    ], BaseShaderSprite);
    return BaseShaderSprite;
}(cc.Component));
exports.default = BaseShaderSprite;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShaderSprite.js.map
        