(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/CustomMaterial.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'b21deW241hPT5hVECgWL0XS', 'CustomMaterial', __filename);
// script/app/components/shader/CustomMaterial.ts

/**
 * 自定义材质
 */
Object.defineProperty(exports, "__esModule", { value: true });
var renderEngine = cc.renderer.renderEngine;
var renderer = renderEngine.renderer;
var gfx = renderEngine.gfx;
var Material = renderEngine.Material;
var ShaderCustomMaterial = /** @class */ (function (_super) {
    __extends(ShaderCustomMaterial, _super);
    function ShaderCustomMaterial(name, params, defines) {
        var _this = _super.call(this) || this;
        // 设置自定义参数的值
        _this.setParamValue = function (name, value) {
            this._effect.setProperty(name, value);
            return this;
        };
        // 设置定义值
        _this.setDefine = function (name, value) {
            this._effect.define(name, value);
            return this;
        };
        Material.call(_this, false);
        var pass = new renderer.Pass(name);
        pass.setDepth(false, false);
        pass.setCullMode(gfx.CULL_NONE);
        pass.setBlend(gfx.BLEND_FUNC_ADD, gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA, gfx.BLEND_FUNC_ADD, gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA);
        var techParams = [
            { name: 'texture', type: renderer.PARAM_TEXTURE_2D },
            { name: 'color', type: renderer.PARAM_COLOR4 },
            { name: 'time', type: renderer.PARAM_FLOAT },
            { name: 'num', type: renderer.PARAM_FLOAT },
        ];
        if (params)
            techParams = techParams.concat(params);
        var mainTech = new renderer.Technique(['transparent'], techParams, [pass]);
        _this._texture = null;
        _this._color = { r: 1, g: 1, b: 1, a: 1 };
        _this._effect = new renderer.Effect([mainTech], {
            'color': _this._color,
            'time': 0.0,
            'num': 0.0,
        }, defines);
        _this.name = name;
        _this.params = params;
        _this.defines = defines;
        _this._mainTech = mainTech;
        return _this;
    }
    ShaderCustomMaterial.prototype.clone = function () {
        var copy = new ShaderCustomMaterial();
        copy.texture = this.texture;
        copy.color = this.color;
        copy.updateHash();
        return copy;
    };
    Object.defineProperty(ShaderCustomMaterial.prototype, "effect", {
        get: function () {
            return this._effect;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderCustomMaterial.prototype, "texture", {
        get: function () {
            return this._texture;
        },
        set: function (val) {
            if (this._texture !== val) {
                this._texture = val;
                this._effect.setProperty('texture', val.getImpl());
                this._texIds['texture'] = val.getId();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderCustomMaterial.prototype, "color", {
        get: function () {
            return this._color;
        },
        set: function (val) {
            var color = this._color;
            color.r = val.r / 255;
            color.g = val.g / 255;
            color.b = val.b / 255;
            color.a = val.a / 255;
            this._effect.setProperty('color', color);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderCustomMaterial.prototype, "name", {
        get: function () {
            return this._name;
        },
        set: function (name) {
            this._name = name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderCustomMaterial.prototype, "params", {
        get: function () {
            return this._params;
        },
        set: function (params) {
            this._params = params;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderCustomMaterial.prototype, "defines", {
        get: function () {
            return this._defines;
        },
        set: function (define) {
            this._defines = define;
        },
        enumerable: true,
        configurable: true
    });
    return ShaderCustomMaterial;
}(Material));
exports.default = ShaderCustomMaterial;
// if (Material)
// CustomMaterial.prototype = Object.create(Material && Material.prototype);
// CustomMaterial.prototype.constructor = CustomMaterial;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=CustomMaterial.js.map
        