(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/ShaderLib.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'c597eqpyJNHZLr50Gp0lerx', 'ShaderLib', __filename);
// script/app/components/shader/ShaderLib.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Overlay_1 = require("./shaders/Overlay");
var RainShader_1 = require("./shaders/RainShader");
var WaveShader_1 = require("./shaders/WaveShader");
var GaussBlurs_1 = require("./shaders/GaussBlurs");
var Glowing_1 = require("./shaders/Glowing");
var Outline_1 = require("./shaders/Outline");
var Mosaic_1 = require("./shaders/Mosaic");
var Water_1 = require("./shaders/Water");
var Ice_1 = require("./shaders/Ice");
var Fluxay_1 = require("./shaders/Fluxay");
var FluxaySuper_1 = require("./shaders/FluxaySuper");
var Banish_1 = require("./shaders/Banish");
var Blur_1 = require("./shaders/Blur");
var Dissolve_1 = require("./shaders/Dissolve");
var Frozen_1 = require("./shaders/Frozen");
var Invisible_1 = require("./shaders/Invisible");
var Mirror_1 = require("./shaders/Mirror");
var Poison_1 = require("./shaders/Poison");
var RadialBlur_1 = require("./shaders/RadialBlur");
var Stone_1 = require("./shaders/Stone");
var Vanish_1 = require("./shaders/Vanish");
var Default_1 = require("./shaders/Default");
var Gray_1 = require("./shaders/Gray");
var ShaderLib = /** @class */ (function () {
    function ShaderLib() {
        this._shaders = {};
        this.init();
    }
    ShaderLib.instance = function () {
        if (!this._instance) {
            this._instance = new ShaderLib();
        }
        return this._instance;
    };
    /**
     * 初始化一些shader实例
     */
    ShaderLib.prototype.init = function () {
        this.addShader(new Default_1.default());
        this.addShader(new Banish_1.default());
        this.addShader(new Blur_1.default());
        this.addShader(new Dissolve_1.default());
        this.addShader(new Fluxay_1.default());
        this.addShader(new FluxaySuper_1.default());
        this.addShader(new Frozen_1.default());
        this.addShader(new GaussBlurs_1.default());
        this.addShader(new Glowing_1.default());
        this.addShader(new Gray_1.default());
        this.addShader(new Ice_1.default());
        this.addShader(new Invisible_1.default());
        this.addShader(new Mirror_1.default());
        this.addShader(new Mosaic_1.default());
        this.addShader(new Outline_1.default());
        this.addShader(new Overlay_1.default());
        this.addShader(new Poison_1.default());
        this.addShader(new RadialBlur_1.default());
        this.addShader(new RainShader_1.default());
        this.addShader(new Stone_1.default());
        this.addShader(new Vanish_1.default());
        this.addShader(new Water_1.default());
        this.addShader(new WaveShader_1.default());
    };
    /**
      * 增加一个新的Shader
      * @param shader
      */
    ShaderLib.prototype.addShader = function (shader) {
        if (this._shaders && this._shaders[shader.name]) {
            return false;
        }
        cc.renderer._forward._programLib.define(shader.name, shader.vert, shader.frag, shader.defines);
        this._shaders[shader.name] = shader;
        return true;
    };
    /**
    * 取Shader的定义
    * @param name
    */
    ShaderLib.prototype.getShader = function (name) {
        if (this._shaders[name]) {
            return this._shaders[name];
        }
        throw "ShadlerLib中不存在Shader：" + name;
    };
    return ShaderLib;
}());
exports.default = ShaderLib;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShaderLib.js.map
        