(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/ShaderManager.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '10031NyB0hO1bq5GXHKazbB', 'ShaderManager', __filename);
// script/app/components/shader/ShaderManager.ts

Object.defineProperty(exports, "__esModule", { value: true });
var CustomMaterial_1 = require("./CustomMaterial");
var SpriteHook_1 = require("./SpriteHook");
var ShaderLib_1 = require("./ShaderLib");
// export enum ShaderType {
//     Default = "Default",
//     Banish = "Banish",
//     Blur = "Blur",
//     Dissolve = "Dissolve",
//     Fluxay = "Fluxay",
//     FluxaySuper = "FluxaySuper",
//     Frozen = "Frozen",
//     GaussBlurs = "GaussBlurs",
//     Glowing = "Glowing",
//     Ice = "Ice",
//     Invisible = "Invisible",
//     Mirror = "Mirror",
//     Mosaic = "Mosaic",
//     Outline = "Outline",
//     OverlayShader = "OverlayShader",
//     Poison = "Poison",
//     RadialBlur = "RadialBlur",
//     RainShader = "RainShader",
//     Stone = "Stone",
//     Vanish = "Vanish",
//     Water = "Water",
//     WaveShader = "WaveShader"
// }
var ShaderType;
(function (ShaderType) {
    ShaderType[ShaderType["Default"] = 0] = "Default";
    // Banish,
    ShaderType[ShaderType["Blur"] = 1] = "Blur";
    // Dissolve,
    ShaderType[ShaderType["Fluxay"] = 2] = "Fluxay";
    ShaderType[ShaderType["FluxaySuper"] = 3] = "FluxaySuper";
    // Frozen,
    ShaderType[ShaderType["GaussBlurs"] = 4] = "GaussBlurs";
    ShaderType[ShaderType["Glowing"] = 5] = "Glowing";
    // Gray,
    // Ice,
    // Invisible,
    // Mirror,
    ShaderType[ShaderType["Mosaic"] = 6] = "Mosaic";
    ShaderType[ShaderType["Outline"] = 7] = "Outline";
    // Overlay,
    // Poison,
    // RadialBlur,
    ShaderType[ShaderType["RainShader"] = 8] = "RainShader";
    // Stone,
    // Vanish,
    ShaderType[ShaderType["Water"] = 9] = "Water";
    ShaderType[ShaderType["WaveShader"] = 10] = "WaveShader";
})(ShaderType = exports.ShaderType || (exports.ShaderType = {}));
var ShaderManager = /** @class */ (function () {
    function ShaderManager() {
        SpriteHook_1.default.init();
    }
    ShaderManager.instance = function () {
        if (!this._instance) {
            this._instance = new ShaderManager();
        }
        return this._instance;
    };
    ShaderManager.prototype.setShader = function (_sprite, _shader, _handler) {
        // console.log(`【${_sprite.node.name}】->[setShader]->${ShaderType[_shader]}`);
        if (_shader == ShaderType.Default) {
            _sprite.setState(0);
            return;
        }
        var shaderName = ShaderType[_shader];
        var shader = ShaderLib_1.default.instance().getShader(shaderName);
        var sprite = _sprite;
        var mat = sprite.getMaterial(shaderName);
        if (!mat) {
            mat = new CustomMaterial_1.default(shader.name, shader.params, shader.defines);
            sprite.setMaterial(shaderName, mat);
            mat.texture = _sprite.spriteFrame.getTexture();
        }
        sprite.activateMaterial(shaderName);
        mat.texture.update();
        mat.setParamValue("resolution", new cc.Vec3(sprite.node.width, sprite.node.height, 0));
        mat.setParamValue("texSize", new cc.Vec2(sprite.node.width, sprite.node.height));
        if (_handler) {
            _handler(mat);
        }
        return mat;
    };
    return ShaderManager;
}());
exports.default = ShaderManager;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShaderManager.js.map
        