(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/SpriteHook.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'ac513PZIhtAxI2HZime5BcA', 'SpriteHook', __filename);
// script/app/components/shader/SpriteHook.ts

Object.defineProperty(exports, "__esModule", { value: true });
// var SpriteHook = {
// }
// 支持自定义Shader
var renderEngine = cc.renderer.renderEngine;
var SpriteMaterial = renderEngine.SpriteMaterial;
var GraySpriteMaterial = renderEngine.GraySpriteMaterial;
var STATE_CUSTOM = 101;
var SpriteHook = /** @class */ (function () {
    function SpriteHook() {
    }
    SpriteHook.init = function () {
        var prototype = cc.Sprite.prototype;
        // 取自定义材质
        prototype.getMaterial = function (name) {
            // console.log("prototype.getMaterial")
            if (this._materials) {
                return this._materials[name];
            }
            else {
                return undefined;
            }
        };
        // 设置自定义材质
        prototype.setMaterial = function (name, mat) {
            // console.log("prototype.setMaterial")
            if (!this._materials) {
                this._materials = {};
            }
            this._materials[name] = mat;
        };
        // 激活某个材质
        prototype.activateMaterial = function (name) {
            // console.log("prototype.activateMaterial", name)
            var mat = this.getMaterial(name);
            if (mat && mat !== this._currMaterial) {
                if (mat) {
                    if (this.node) {
                        mat.color = this.node.color;
                    }
                    if (this.spriteFrame) {
                        mat.texture = this.spriteFrame.getTexture();
                    }
                    this.node._renderFlag |= cc.RenderFlow.FLAG_COLOR;
                    this._currMaterial = mat;
                    this._currMaterial.name = name;
                    this._state = STATE_CUSTOM;
                    this._activateMaterial();
                }
                else {
                    // console.error("activateMaterial - unknwon material: ", name);
                }
            }
        };
        // 取当前的材质
        prototype.getCurrMaterial = function () {
            // console.log("prototype.getCurrMaterial")
            if (this._state === STATE_CUSTOM) {
                return this._currMaterial;
            }
        };
        prototype._activateMaterial = function () {
            // console.log("prototype._activateMaterial")
            var spriteFrame = this._spriteFrame;
            // WebGL
            if (cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
                // Get material
                var material = void 0;
                if (this._state === cc.Sprite.State.GRAY) {
                    if (!this._graySpriteMaterial) {
                        this._graySpriteMaterial = new GraySpriteMaterial();
                        this.node._renderFlag |= cc.RenderFlow.FLAG_COLOR;
                    }
                    material = this._graySpriteMaterial;
                    this._currMaterial = null;
                }
                else if (this._state === STATE_CUSTOM) {
                    if (!this._currMaterial) {
                        // console.error("_activateMaterial: _currMaterial undefined!")
                        return;
                    }
                    material = this._currMaterial;
                }
                else {
                    if (!this._spriteMaterial) {
                        this._spriteMaterial = new SpriteMaterial();
                        this.node._renderFlag |= cc.RenderFlow.FLAG_COLOR;
                    }
                    material = this._spriteMaterial;
                    this._currMaterial = null;
                }
                // Set texture
                if (spriteFrame && spriteFrame.textureLoaded()) {
                    var texture = spriteFrame.getTexture();
                    if (material.texture !== texture) {
                        material.texture = texture;
                        this._updateMaterial(material);
                    }
                    else if (material !== this._material) {
                        this._updateMaterial(material);
                    }
                    if (this._renderData) {
                        this._renderData.material = material;
                    }
                    this.markForUpdateRenderData(true);
                    this.markForRender(true);
                }
                else {
                    this.disableRender();
                }
            }
        };
    };
    return SpriteHook;
}());
exports.default = SpriteHook;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=SpriteHook.js.map
        