(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/FluxaySuper.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '87b5dY+4mxONbqK76Pd6cwQ', 'FluxaySuper', __filename);
// script/app/components/shader/shaders/FluxaySuper.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader= FluxaySuper
var FluxaySuper = /** @class */ (function (_super) {
    __extends(FluxaySuper, _super);
    function FluxaySuper() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "FluxaySuper";
        _this.defines = [];
        _this.params = [];
        _this.frag = "\n    #define TAU 6.12\n    #define MAX_ITER 5\n    uniform sampler2D texture;\n    uniform vec4 color;\n    uniform float time;\n    varying vec2 uv0;\n    \n    void main()\n    {\n        float time = time * .5+5.;\n        // uv should be the 0-1 uv of texture...\n        vec2 uv = uv0.xy;//fragCoord.xy / resolution.xy;\n    \n        vec2 p = mod(uv*TAU, TAU)-250.0;\n    \n        vec2 i = vec2(p);\n        float c = 1.0;\n        float inten = .0045;\n    \n        for (int n = 0; n < MAX_ITER; n++) \n        {\n            float t =  time * (1.0 - (3.5 / float(n+1)));\n            i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(1.5*t + i.x));\n            c += 1.0/length(vec2(p.x / (cos(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));\n        }\n        c /= float(MAX_ITER);\n        c = 1.17-pow(c, 1.4);\n        vec4 tex = texture2D(texture,uv);\n        vec3 colour = vec3(pow(abs(c), 20.0));\n        colour = clamp(colour + vec3(0.0, 0.0, .0), 0.0, tex.a);\n    \n        // \u6DF7\u5408\u6CE2\u5149\n        float alpha = c*tex[3];  \n        tex[0] = tex[0] + colour[0]*alpha; \n        tex[1] = tex[1] + colour[1]*alpha; \n        tex[2] = tex[2] + colour[2]*alpha; \n        gl_FragColor = color * tex;\n    }\n    ";
        return _this;
    }
    return FluxaySuper;
}(Shader_1.default));
exports.default = FluxaySuper;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=FluxaySuper.js.map
        