(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/Glowing.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '9c94cyd7vFJ46age1ga5xKd', 'Glowing', __filename);
// script/app/components/shader/shaders/Glowing.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader: 外发光
var Glowing = /** @class */ (function (_super) {
    __extends(Glowing, _super);
    function Glowing() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "Glowing";
        _this.params = [];
        _this.defines = [];
        _this.frag = "\n    uniform sampler2D texture;\n    uniform vec3 resolution;\n    uniform float time;\n    uniform vec4 color;\n    varying vec2 uv0;\n\n    const float radius = 4.0;\n    // const vec3 color = vec3(0.9, 0.9, 0.0);\n\n    float coefficient()\n    {\n        float v = mod(time, 3.0);\n        if(v > 1.5)\n            v = 3.0 - v;\n        return v;\n    }\n\n    void mainImage( out vec4 fragColor, in vec2 fragCoord )\n    {\n        vec2 uv = fragCoord.xy;\n        vec2 unit = 1.0 / resolution.xy;\n        vec4 texel = texture2D(texture, uv);\n        vec4 finalColor = vec4(0.0);\n        float density = 0.0;\n\n        if(texel.a >= 1.0)\n        {\n            finalColor = texel;\n        }\n        else\n        {\n            for(int i = 0; i < int(radius); ++i)\n            {\n                density += texture2D(texture, vec2(uv.x + unit.x * float(i), uv.y + unit.y * float(i))).a;\n                density += texture2D(texture, vec2(uv.x - unit.x * float(i), uv.y + unit.y * float(i))).a;\n                density += texture2D(texture, vec2(uv.x - unit.x * float(i), uv.y - unit.y * float(i))).a;\n                density += texture2D(texture, vec2(uv.x + unit.x * float(i), uv.y - unit.y * float(i))).a;\n            }\n            density = density / radius;\n            finalColor = vec4(color.rgb * density, density);\n            finalColor += vec4(texel.rgb * texel.a, texel.a);\n        }\n        fragColor = finalColor;\n    }\n\n    void main()\n    {\n        mainImage(gl_FragColor, uv0.xy);\n    }";
        return _this;
    }
    return Glowing;
}(Shader_1.default));
exports.default = Glowing;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Glowing.js.map
        