(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/Outline.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '27ce84k29NLiaqZYqOMG1d3', 'Outline', __filename);
// script/app/components/shader/shaders/Outline.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader: 描边
var Outline = /** @class */ (function (_super) {
    __extends(Outline, _super);
    function Outline() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "Outline";
        _this.params = [
            { name: 'resolution', type: _this.renderer.PARAM_FLOAT3 },
        ];
        _this.defines = [];
        _this.frag = "\n    uniform sampler2D texture;\n    varying vec2 uv0;\n    uniform vec3 resolution;\n\n    void main()\n    {\n        vec2 onePixel = vec2(1.0 / resolution.x, 1.0 / resolution.y);\n\n        vec4 color = texture2D(texture, uv0.xy);\n        vec4 colorRight = texture2D(texture, uv0.xy + vec2(0,onePixel.t));\n        vec4 colorBottom = texture2D(texture, uv0.xy + vec2(onePixel.s,0));\n\n        color.r = 3.0* sqrt( (color.r - colorRight.r) * (color.r - colorRight.r) + (color.r - colorBottom.r) * (color.r - colorBottom.r) );\n        color.g = 3.0* sqrt( (color.g - colorRight.g) * (color.g - colorRight.g) + (color.g - colorBottom.g) * (color.g - colorBottom.g) );\n        color.b = 3.0* sqrt( (color.b - colorRight.b) * (color.b - colorRight.b) + (color.b - colorBottom.b) * (color.b - colorBottom.b) );\n\n        color.r >1.0 ? 1.0 : color.r;\n        color.g >1.0 ? 1.0 : color.g;\n        color.b >1.0 ? 1.0 : color.b;\n        gl_FragColor = vec4(color.rgb, 1);\n    }";
        return _this;
    }
    return Outline;
}(Shader_1.default));
exports.default = Outline;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Outline.js.map
        