(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/Overlay.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'cf9dczh6+tOFI/oAUya4uaE', 'Overlay', __filename);
// script/app/components/shader/shaders/Overlay.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
// Shader= 纹理与颜色叠加
var Overlay = /** @class */ (function (_super) {
    __extends(Overlay, _super);
    function Overlay() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "Overlay";
        _this.defines = [];
        _this.params = [];
        _this.frag = "\n    uniform sampler2D texture;\n    varying vec2 uv0;\n    uniform vec4 color;\n    void main() \n    { \n        vec4 texColor = texture2D(texture, uv0);  \n        if (texColor.r <= 0.5)\n        gl_FragColor.r = 2.0 * texColor.r * color.r;\n        else\n        gl_FragColor.r = 1.0 - 2.0 * (1.0 - texColor.r) * (1.0 - color.r);\n        if (texColor.g <= 0.5)\n        gl_FragColor.g = 2.0 * texColor.g * color.g;\n        else\n        gl_FragColor.g = 1.0 - 2.0 * (1.0 - texColor.g) * (1.0 - color.g);\n        if (texColor.b <= 0.5)\n        gl_FragColor.b = 2.0 * texColor.b * color.b;\n        else\n        gl_FragColor.b = 1.0 - 2.0 * (1.0 - texColor.b) * (1.0 - color.b);\n        gl_FragColor.a = texColor.a * color.a;\n    }";
        return _this;
    }
    return Overlay;
}(Shader_1.default));
exports.default = Overlay;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Overlay.js.map
        