(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/RainShader.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'db310byLVpM87pg/zQZDaZF', 'RainShader', __filename);
// script/app/components/shader/shaders/RainShader.ts

Object.defineProperty(exports, "__esModule", { value: true });
var Shader_1 = require("../Shader");
var renderer = cc.renderer.renderEngine.renderer;
var RainShader = /** @class */ (function (_super) {
    __extends(RainShader, _super);
    function RainShader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = 'RainShader';
        _this.params = [
            { name: 'texSize', type: renderer.PARAM_FLOAT2 },
            { name: 'resolution', type: renderer.PARAM_FLOAT3 },
            { name: 'time', type: renderer.PARAM_FLOAT },
        ];
        _this.defines = [
            { name: 'HAS_HEART', value: false },
            { name: 'USE_POST_PROCESSING', value: true },
        ];
        _this.frag = "\n    // Heartfelt - by Martijn Steinrucken aka BigWings - 2017\n    // countfrolic@gmail.com\n    // License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.\n    \n    // I revisited the rain effect I did for another shader. This one is better in multiple ways:\n    // 1. The glass gets foggy.\n    // 2. Drops cut trails in the fog on the glass.\n    // 3. The amount of rain is adjustable (with Mouse.y)\n    \n    // To have full control over the rain, uncomment the HAS_HEART define \n    \n    // A video of the effect can be found here:\n    // https://www.youtube.com/watch?v=uiF5Tlw22PI&feature=youtu.be\n    \n    // Music - Alone In The Dark - Vadim Kiselev\n    // https://soundcloud.com/ahmed-gado-1/sad-piano-alone-in-the-dark\n    // Rain sounds:\n    // https://soundcloud.com/elirtmusic/sleeping-sound-rain-and-thunder-1-hours\n    \n    #define S(a, b, t) smoothstep(a, b, t)\n    //#define CHEAP_NORMALS\n    \n    uniform sampler2D texture;\n    uniform vec4 color;\n    uniform vec3 resolution;\n    uniform float time;\n    uniform vec2 texSize;\n    varying vec2 uv0;\n    \n    vec3 N13(float p) {\n        //  from DAVE HOSKINS\n       vec3 p3 = fract(vec3(p) * vec3(.1031,.11369,.13787));\n       p3 += dot(p3, p3.yzx + 19.19);\n       return fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));\n    }\n    \n    vec4 N14(float t) {\n        return fract(sin(t*vec4(123., 1024., 1456., 264.))*vec4(6547., 345., 8799., 1564.));\n    }\n    float N(float t) {\n        return fract(sin(t*12345.564)*7658.76);\n    }\n    \n    float Saw(float b, float t) {\n        return S(0., b, t)*S(1., b, t);\n    }\n    \n    vec2 DropLayer2(vec2 uv, float t) {\n        vec2 UV = uv;\n        \n        uv.y += t*0.75;\n        vec2 a = vec2(6., 1.);\n        vec2 grid = a*2.;\n        vec2 id = floor(uv*grid);\n        \n        float colShift = N(id.x); \n        uv.y += colShift;\n        \n        id = floor(uv*grid);\n        vec3 n = N13(id.x*35.2+id.y*2376.1);\n        vec2 st = fract(uv*grid)-vec2(.5, 0);\n        \n        float x = n.x-.5;\n        \n        float y = UV.y*20.;\n        float wiggle = sin(y+sin(y));\n        x += wiggle*(.5-abs(x))*(n.z-.5);\n        x *= .7;\n        float ti = fract(t+n.z);\n        y = (Saw(.85, ti)-.5)*.9+.5;\n        vec2 p = vec2(x, y);\n        \n        float d = length((st-p)*a.yx);\n        \n        float mainDrop = S(.4, .0, d);\n        \n        float r = sqrt(S(1., y, st.y));\n        float cd = abs(st.x-x);\n        float trail = S(.23*r, .15*r*r, cd);\n        float trailFront = S(-.02, .02, st.y-y);\n        trail *= trailFront*r*r;\n        \n        y = UV.y;\n        float trail2 = S(.2*r, .0, cd);\n        float droplets = max(0., (sin(y*(1.-y)*120.)-st.y))*trail2*trailFront*n.z;\n        y = fract(y*10.)+(st.y-.5);\n        float dd = length(st-vec2(x, y));\n        droplets = S(.3, 0., dd);\n        float m = mainDrop+droplets*r*trailFront;\n        \n        //m += st.x>a.y*.45 || st.y>a.x*.165 ? 1.2 : 0.;\n        return vec2(m, trail);\n    }\n    \n    float StaticDrops(vec2 uv, float t) {\n        uv *= 40.;\n        \n        vec2 id = floor(uv);\n        uv = fract(uv)-.5;\n        vec3 n = N13(id.x*107.45+id.y*3543.654);\n        vec2 p = (n.xy-.5)*.7;\n        float d = length(uv-p);\n        \n        float fade = Saw(.025, fract(t+n.z));\n        float c = S(.3, 0., d)*fract(n.z*10.)*fade;\n        return c;\n    }\n    \n    vec2 Drops(vec2 uv, float t, float l0, float l1, float l2) {\n        float s = StaticDrops(uv, t)*l0; \n        vec2 m1 = DropLayer2(uv, t)*l1;\n        vec2 m2 = DropLayer2(uv*1.85, t)*l2;\n        \n        float c = s+m1.x+m2.x;\n        c = S(.3, 1., c);\n        \n        return vec2(c, max(m1.y*l0, m2.y*l1));\n    }\n    \n    void main()\n    {\n        vec4 iMouse = vec4(0.0, 0.0, 0.0, 0.0);\n        vec2 fragCoord = vec2(uv0.x * texSize.x - 0.5 * texSize.x, 0.5 * texSize.y - uv0.y * texSize.y);\n    \n        vec2 uv = fragCoord.xy / resolution.y;\n        vec2 UV = (fragCoord.xy+.5*resolution.xy) / resolution.xy;\n        vec3 M = iMouse.xyz/resolution.xyz;\n        float T = time+M.x*2.;\n        \n        #ifdef HAS_HEART\n            T = mod(time, 102.);\n            T = mix(T, M.x*102., M.z>0.?1.:0.);\n        #endif\n        \n        float t = T*.2;\n        \n        float rainAmount = iMouse.z>0. ? M.y : sin(T*.05)*.3+.7;\n        \n        float maxBlur = mix(3., 6., rainAmount);\n        float minBlur = 2.;\n        \n        float story = 0.;\n        float heart = 0.;\n        \n        #ifdef HAS_HEART\n            story = S(0., 70., T);\n            \n            t = min(1., T/70.);\t\t\t\t\t\t// remap drop time so it goes slower when it freezes\n            t = 1.-t;\n            t = (1.-t*t)*70.;\n            \n            float zoom= mix(.3, 1.2, story);\t\t// slowly zoom out\n            uv *=zoom;\n            minBlur = 4.+S(.5, 1., story)*3.;\t\t// more opaque glass towards the end\n            maxBlur = 6.+S(.5, 1., story)*1.5;\n            \n            vec2 hv = uv-vec2(.0, -.1);\t\t\t\t// build heart\n            hv.x *= .5;\n            float s = S(110., 70., T);\t\t\t\t// heart gets smaller and fades towards the end\n            hv.y-=sqrt(abs(hv.x))*.5*s;\n            heart = length(hv);\n            heart = S(.4*s, .2*s, heart)*s;\n            rainAmount = heart;\t\t\t\t\t\t// the rain is where the heart is\n            \n            maxBlur-=heart;\t\t\t\t\t\t\t// inside the heart slighly less foggy\n            uv *= 1.5;\t\t\t\t\t\t\t\t// zoom out a bit more\n            t *= .25;\n        #else\n            float zoom = -cos(T*.2);\n            uv *= .7+zoom*.3;\n        #endif\n        UV = (UV-.5)*(.9+zoom*.1)+.5;\n        \n        float staticDrops = S(-.5, 1., rainAmount)*2.;\n        float layer1 = S(.25, .75, rainAmount);\n        float layer2 = S(.0, .5, rainAmount);\n        \n        vec2 c = Drops(uv, t, staticDrops, layer1, layer2);\n        #ifdef CHEAP_NORMALS\n            vec2 n = vec2(dFdx(c.x), dFdy(c.x));// cheap normals (3x cheaper, but 2 times shittier ;))\n        #else\n            vec2 e = vec2(.001, 0.);\n            float cx = Drops(uv+e, t, staticDrops, layer1, layer2).x;\n            float cy = Drops(uv+e.yx, t, staticDrops, layer1, layer2).x;\n            vec2 n = vec2(cx-c.x, cy-c.x);\t\t// expensive normals\n        #endif\n    \n        #ifdef HAS_HEART\n            n *= 1.-S(60., 85., T);\n            c.y *= 1.-S(80., 100., T)*.8;\n        #endif\n    \n        float focus = mix(maxBlur-c.y, minBlur, S(.1, .2, c.x));\n        vec3 col = texture2D(texture, UV+n).rgb;\n                                // make time sync with first lightnoing\n    \n        #ifdef USE_POST_PROCESSING\n            t = (T+3.)*.5;\t\t\t\n            float colFade = sin(t*.2)*.5+.5+story;\n            col *= mix(vec3(1.), vec3(.8, .9, 1.3), colFade);\t// subtle color shift\n            float fade = S(0., 10., T);\t\t\t\t\t\t\t// fade in at the start\n            float lightning = sin(t*sin(t*10.));\t\t\t\t// lighting flicker\n            lightning *= pow(max(0., sin(t+sin(t))), 10.);\t\t// lightning flash\n            col *= 1.+lightning*fade*mix(1., .1, story*story);\t// composite lightning\n            col *= 1.-dot(UV-=.5, UV);\t\t\t\t\t\t\t// vignette\n    \n            #ifdef HAS_HEART\n                col = mix(pow(col, vec3(1.2)), col, heart);\n                fade *= S(102., 97., T);\n            #endif\n    \n            col *= fade;\t\t\t\t\t\t\t\t\t\t// composite start and end fade\n        #endif\n    \n        //col = vec3(heart);\n        gl_FragColor = vec4(col, 1.);\n    }";
        return _this;
    }
    return RainShader;
}(Shader_1.default));
exports.default = RainShader;
;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=RainShader.js.map
        