(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/components/shader/shaders/WaveShader.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'f7f93lpFQFKRb/3WEfj2Sxs', 'WaveShader', __filename);
// script/app/components/shader/shaders/WaveShader.ts

Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 波浪流动效果
 * */
var Shader_1 = require("../Shader");
// Shader= 纹理与颜色叠加
var WaveShader = /** @class */ (function (_super) {
    __extends(WaveShader, _super);
    function WaveShader() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = "WaveShader";
        _this.params = [
            { name: 'time', type: _this.renderer.PARAM_FLOAT },
            { name: 'iOffset', type: _this.renderer.PARAM_FLOAT2 },
        ];
        _this.defines = [];
        _this.frag = "\n    uniform sampler2D texture;\n    uniform float time;\n    uniform vec2 iOffset;\n    varying vec2 uv0;\n    \n    void main() {\n        vec2 coord = uv0;\n        coord.x += (sin(coord.y * 30.0 + time * 3.0) / 30.0 * iOffset[0]);\n        coord.y += (sin(coord.x * 30.0 + time * 3.0) / 30.0 * iOffset[1]);\n        gl_FragColor = texture2D(texture, coord);\n    }";
        return _this;
    }
    return WaveShader;
}(Shader_1.default));
exports.default = WaveShader;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=WaveShader.js.map
        