// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        ca: {
            // ATTRIBUTES:
            default: null,        // The default value will be used only when the component attaching
            // to a node for the first time
            type: cc.Camera, // optional, default is typeof default

        },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {
        let handler = function (modelRay, node, distance) {
            // modelRay 为 ray 转换到 node 本地坐标系下的射线

            let meshRenderer = node.getComponent(cc.MeshRenderer);
            if (meshRenderer && meshRenderer.mesh) {
                // 如果有 mesh renderer，则对 mesh 进行检测，虽然比较消耗性能，但是检测会更加精确
                return cc.geomUtils.intersect.rayMesh(modelRay, meshRenderer.mesh);
            }

            // 返回
            console.log(distance);
            return distance;
        };


        this.node.on(cc.Node.EventType.TOUCH_START, (e) => {
            console.log(e.touch.getLocation());
            let camera = this.ca;
            // let ray = camera.getRay(cc.v2(376, 100));
            let ray = camera.getRay(e.touch.getLocation());
            let results = cc.geomUtils.intersect.raycast(cc.director.getScene(), ray);
            for (let i = 0; i < results.length; i++) {
                results[i].node.opacity = 100;
                console.log(results[i].node.name);
            }
            // console.log('results', results);


        }, this);

    },

    // update (dt) {},


});
