//-----
//player.js v0.1
//By PixelStorm(2754887003@qq.com)
//-----
//用于Cocos Creator的平台跳跃类角色脚本
//提供了一个键盘控制作为移动的范例，也可以加装逻辑用于敌人等角色
//节点上除了挂载本脚本外，还需要挂载一个物理RigidBody组件和一个物理碰撞组件
//注意：RigidBody要开启碰撞监听
//-----
cc.Class({
    extends: cc.Component,

    properties: {
        jumpOK:false,
        a:false,
        d:false,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.rigid=this.node.getComponent(cc.RigidBody);
        cc.getPhysicsManager().enabled=true;
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,this.onKeyUp,this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN,this.onKeyDown,this);
    },
    onKeyDown(key){
        if(key.keyCode === cc.macro.KEY.space && this.jumpOK === true){
            this.rigid.linearVelocity=cc.v2(this.rigid.linearVelocity.x,this.rigid.linearVelocity.y+550);
        }
        if(key.keyCode===cc.macro.KEY.a){
            this.a=true;
        }
        if(key.keyCode===cc.macro.KEY.d){
            this.d=true;
        }     
    },
    onKeyUp(key){
        if(key.keyCode===cc.macro.KEY.a){
            this.a=false;
        }
        if(key.keyCode===cc.macro.KEY.d){
            this.d=false;
        }
        if(this.jumpOK){
          this.rigid.linearVelocity=cc.v2(0,this.rigid.linearVelocity.y)
        }
    },
    onEndContact: function (contact, selfCollider, otherCollider) {
      this.jumpOK=false;  
    },
    onPostSolve: function (contact, selfCollider, otherCollider) {
        if(selfCollider.node.y-selfCollider.node.height*selfCollider.node.scaleY/2>=otherCollider.node.y+otherCollider.node.height*otherCollider.node.scaleY/2){this.jumpOK=true;}
    },
    onBeginContact: function (contact, selfCollider, otherCollider) {
        if(selfCollider.node.y-selfCollider.node.height*selfCollider.node.scaleY/2>=otherCollider.node.y+otherCollider.node.height*otherCollider.node.scaleY/2){this.jumpOK=true;}
    },
    start () {

    },
    update (dt) {
        if(this.a){
            this.rigid.linearVelocity=cc.v2(-200,this.rigid.linearVelocity.y);
        } 
        if(this.d){
            this.rigid.linearVelocity=cc.v2(200,this.rigid.linearVelocity.y);
        }   
    },
}
);