
cc.Class({
    extends: cc.Component,

    properties: {
        offMusic:true,
        offSound:true,
        musicVolume:1,
        soundVolume:1,

        music:{type: cc.AudioClip, default: []},
        click:{type: cc.AudioClip, default: null},
        harvest:{type: cc.AudioClip, default: null},
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad(){
        for(let i=0;i<this.music.length;i++){
            this.music[i].id = -1;
        }
        // console.log(this.harvest.nativeUrl)
    },


    //测试按键
    onClickButton(event,data){
        data = parseInt(data,10);
        switch(data){
            case 0:
                this.playMusic(0);
            break;
            case 1:
                this.pauseMusic(0);
            break;
            case 2:
                this.stopMusic(0);
            break;
            case 3:
                this.playMusic(1);
            break;
            case 4:
                this.pauseMusic(1);
            break;
            case 5:
                this.stopMusic(1);
            break;
            case 6:
            this.playSound(this.click);
            break;
            case 7:
            this.playSound(this.harvest);
            break;
        }
    },

    //播放背景音
    playMusic(num){
        if(!this.offMusic) return;
        num = num ===undefined?0:num;
        if(this.music[num].id === -1){
            this.music[num].id = cc.audioEngine.play(this.music[num], true, this.musicVolume);
        }else{
            cc.audioEngine.resume(this.music[num].id);
        }
    },


    //播放音效
    playSound(sound){
        if(!this.offSound) return;
        cc.audioEngine.play(sound, false, this.soundVolume);
    },

    //停止背景音
    stopMusic(num){
        num = num ===undefined?0:num;
        if(this.music[num].id ===-1 )return;
        cc.audioEngine.stop(this.music[num].id);
        this.music[num].id = -1;
    },

    //暂停背景音
    pauseMusic(num){
        num = num ===undefined?0:num;
        if(this.music[num].id ===-1 || cc.audioEngine.AudioState.PLAYING !== cc.audioEngine.getState(this.music[num].id) )return;
        cc.audioEngine.pause(this.music[num].id);
    },

    //设置背景音开关
    setMusicOff(bool){
        if(this.offMusic === bool) return;
        this.offMusic = bool
        if(bool){
            this.playMusic();
        }else{
            for(let i=0;i<this.music.length;i++){
                this.pauseMusic(i);
            }
        }
    },
    //设置音效开关
    setSoundOff(bool){
        if(this.offSound === bool) return;
        this.offSound = bool;
    },

    //设置背景音里
    setMusicVolume(value){
        this.musicVolume = value;
        for(let i=0;i<this.music.length;i++){
            if(this.music[i].id !== -1 && cc.audioEngine.AudioState.PLAYING === cc.audioEngine.getState(this.music[i].id)){
                cc.audioEngine.setVolume(this.music[i].id,this.musicVolume);
            }
        }
    },
    //设置音效音量
    setSoundVolume(value){
        this.soundVolume = value;
    }



});
