import { _decorator, Component, Node, sp } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('scene')
export class scene extends Component {
  @property(sp.Skeleton)
  skeleton: sp.Skeleton = null;

  private _times = 0;
  private _mat = null;

  protected onLoad(): void {
    this._mat = this.skeleton.customMaterialInstance;
  }
  start() {
    this.schedule(() => {
      const mat = this._mat;
      const x = this.skeleton.node.worldPosition.x + (this._times % 2 === 0 ? 100 : -100);
      console.log('nodeWorldPosX', x);
      mat.setProperty('nodeWorldPosX', x);

      this._times += 1;
    }, 1.0);
  }

  update(deltaTime: number) {}
}
