const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    start () {
        // init logic
        this.label.string = this.text;

        cc.resources.load<cc.AnimationClip>("baozi", cc.AnimationClip, (error, resource) => {
            if (error) {
                return;
            }
            for (let i = 0; i < 225; i++) {
                let node = new cc.Node();
                let sprite = node.addComponent(cc.Sprite);
                sprite.sizeMode = cc.Sprite.SizeMode.RAW;
                sprite.trim = false;
                let animation = node.addComponent(cc.Animation);
                animation.addClip(resource);
                animation.play(resource.name);
                node.parent = this.node;
                let rowCount = 15;
                let row = Math.floor(i / rowCount);
                let col = i - row * 15;
                node.position = cc.v3(col * 80, row * 80).sub(cc.v3(600, 600));
            }
        })
    }
}
