System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, ResCleaner, _crd, debugUrl;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  // copied from cocos engine. 略有改动
  function parseDepends(key, parsed) {
    const item = cc.loader['getItem'](key);

    if (item) {
      const depends = item.dependKeys;

      if (depends) {
        for (let i = 0; i < depends.length; i++) {
          const depend = depends[i];

          if (!parsed[depend]) {
            parsed[depend] = true;

            if (debugUrl === depend) {
              cc.log('debug');
            }

            parseDepends(depend, parsed);
          }
        }
      }
    }
  }

  function visitAsset(asset, excludeMap) {
    // assets generated programmatically or by user (e.g. label texture)
    if (!asset._uuid) {
      if (asset instanceof cc.SpriteFrame) {
        if (asset['_original']) {
          // 动态合图
          const texture = asset['_original']._texture;
          texture && visitAsset(texture, excludeMap);
        } else {
          const texture = asset.getTexture();
          texture && visitAsset(texture, excludeMap);
        }
      }

      return;
    }

    const key = cc.loader['_getReferenceKey'](asset);

    if (!excludeMap[key]) {
      excludeMap[key] = true;

      if (debugUrl === key) {
        cc.log('debug');
      }

      parseDepends(key, excludeMap);
    }
  }

  function visitComponent(comp, excludeMap) {
    const props = Object.getOwnPropertyNames(comp);

    for (let i = 0; i < props.length; i++) {
      const value = comp[props[i]];
      if (value instanceof cc.Node) continue;

      if (typeof value === 'object' && value) {
        if (value instanceof cc.NodePool) {
          visitNodePool(value, excludeMap);
        } else if (Array.isArray(value)) {
          for (let j = 0; j < value.length; j++) {
            const val = value[j];

            if (val instanceof cc.RawAsset) {
              visitAsset(val, excludeMap);
            }
          }
        } else if (!value.constructor || value.constructor === Object) {
          const keys = Object.getOwnPropertyNames(value);

          for (let j = 0; j < keys.length; j++) {
            const val = value[keys[j]];

            if (val instanceof cc.RawAsset) {
              visitAsset(val, excludeMap);
            }
          }
        } else if (value instanceof cc.RawAsset) {
          visitAsset(value, excludeMap);
        }
      }
    }
  }

  function visitNode(node, excludeMap) {
    if (!node.isValid) return;

    for (let i = 0; i < node._components.length; i++) {
      visitComponent(node._components[i], excludeMap);
    }

    for (let i = 0; i < node._children.length; i++) {
      visitNode(node._children[i], excludeMap);
    }
  }

  function visitItem(item, excludeMap) {
    if (excludeMap[item.url]) return;

    if (item.complete) {
      const asset = item.content;

      if (asset) {
        if (asset instanceof cc.RawAsset) {
          visitAsset(asset, excludeMap);
        } else {
          cc.log('asset instanceof cc.RawAsset === false');
        }
      } else {
        cc.log('item.complete === true, but item.content  is empty');
      }

      excludeMap[item.url] = true;

      if (debugUrl === item.url) {
        cc.log('debug');
      }
    } else {
      excludeMap[item.url] = true;

      if (debugUrl === item.url) {
        cc.log('debug');
      }

      const deps = item.deps;

      if (deps && deps.length > 0) {
        for (let i = 0; i < deps.length; i++) {
          const item = deps[i];
          visitItem(item, excludeMap);
        }
      }
    }
  }

  function visitNodePool(nodePool, excludeMap) {
    const pool = nodePool._pool;

    for (let j = 0; j < pool.length; j++) {
      const node = pool[j];
      visitNode(node, excludeMap);
    }
  }

  _export("ResCleaner", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "5d565wVUaVDPr73RyAj0Z55", "ResCleaner", undefined);

      debugUrl = '';

      _export("ResCleaner", ResCleaner = class ResCleaner {
        // 资源清理
        static clean() {
          cc.log('--->资源释放 开始');
          const start = Date.now();
          const excludeMap = cc.js.createMap();
          const cache = cc.loader['_cache']; // 排除内置资源

          const builtinDeps = cc['AssetLibrary'].getBuiltinDeps();

          for (const key in builtinDeps) {
            excludeMap[key] = true;
          } // 排除场景引用的资源


          const nodeList = cc.director.getScene().children;

          for (let i = 0; i < nodeList.length; i++) {
            visitNode(nodeList[i], excludeMap);
          } // 剔除加载中的资源


          const runningQueues = {};

          for (const key in cache) {
            const item = cache[key];
            const queue = cc.LoadingItems.getQueue(item);

            if (queue) {
              const queueId = queue['_id'];
              runningQueues[queueId] = queue;
            }
          }

          for (const queueId in runningQueues) {
            const queue = runningQueues[queueId];

            for (const url in queue.map) {
              const item = queue.map[url];
              visitItem(item, excludeMap);
            }
          } // 白名单


          for (const url in this._whiteList) {
            const asset = cc.loader.getRes(url);

            if (asset) {
              visitAsset(asset, excludeMap);
            }
          } // 遍历资源缓存，逐个资源判断是否被场景引用，若未被场景上的节点引用则释放。


          let textureMem = 0;
          const releaseList = [];

          for (const key in cache) {
            const item = cache[key];

            if (!excludeMap[key]) {
              if (!item.complete) {
                cc.warn('资源未加载完却被释放！');
                continue;
              }

              releaseList.push(key);
              const asset = item.content;

              if (asset && asset instanceof cc.Texture2D) {
                textureMem += asset.width * asset.height * 4; // 显存释放估计量
              }
            }
          }

          for (let i = 0; i < releaseList.length; i++) {
            const key = releaseList[i];
            const item = cache[key];
            if (!item) continue;
            let name = '';
            if (item.content && item.content.name) name = item.content.name; // cc.log('资源释放', key)

            cc.loader.release(key);
          }

          const timeSpan = Date.now() - start;
          cc.log(`<---资源释放结束。耗时：${timeSpan}ms, 释放资源数量：${releaseList.length}，释放显存：${textureMem / (1024 * 1024)}MB`);
        }
        /**
         * 资源释放白名单
         */


        /**
         *
         * @param url 被保护的资源
         */
        static set whiteList(urlList) {
          ResCleaner._whiteList = {};

          for (let i = 0; i < urlList.length; i++) {
            const url = urlList[i];
            ResCleaner._whiteList[url] = true;
          }
        }
        /**
         * 纹理的显存占用
         */


        static getTexGPUMemory() {
          let textureMem = 0;
          const cache = cc.loader['_cache'];

          for (const key in cache) {
            const item = cache[key];
            const asset = item.content;

            if (asset && asset instanceof cc.Texture2D) {
              // 显存估计量
              const bytes = asset.getPixelFormat() == cc.Texture2D.PixelFormat.RGBA8888 ? 4 : 3;
              textureMem += asset.width * asset.height * bytes;
            }
          }

          return textureMem / (1024 * 1024);
        }

      });

      _defineProperty(ResCleaner, "_whiteList", {});

      cc['ResCleaner'] = ResCleaner; // cc.ResCleaner.clean()
      // cc.ResCleaner.getTexGPUMemory()

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=ResCleaner.js.map