System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, _crd, debugUrl, ResCleaner;

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  // copied from cocos engine. 略有改动
  function parseDepends(key, parsed) {
    var item = cc.loader['getItem'](key);

    if (item) {
      var depends = item.dependKeys;

      if (depends) {
        for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];

          if (!parsed[depend]) {
            parsed[depend] = true;

            if (debugUrl === depend) {
              cc.log('debug');
            }

            parseDepends(depend, parsed);
          }
        }
      }
    }
  }

  function visitAsset(asset, excludeMap) {
    // assets generated programmatically or by user (e.g. label texture)
    if (!asset._uuid) {
      if (asset instanceof cc.SpriteFrame) {
        if (asset['_original']) {
          // 动态合图
          var texture = asset['_original']._texture;
          texture && visitAsset(texture, excludeMap);
        } else {
          var _texture = asset.getTexture();

          _texture && visitAsset(_texture, excludeMap);
        }
      }

      return;
    }

    var key = cc.loader['_getReferenceKey'](asset);

    if (!excludeMap[key]) {
      excludeMap[key] = true;

      if (debugUrl === key) {
        cc.log('debug');
      }

      parseDepends(key, excludeMap);
    }
  }

  function visitComponent(comp, excludeMap) {
    var props = Object.getOwnPropertyNames(comp);

    for (var i = 0; i < props.length; i++) {
      var value = comp[props[i]];
      if (value instanceof cc.Node) continue;

      if (typeof value === 'object' && value) {
        if (value instanceof cc.NodePool) {
          visitNodePool(value, excludeMap);
        } else if (Array.isArray(value)) {
          for (var j = 0; j < value.length; j++) {
            var val = value[j];

            if (val instanceof cc.RawAsset) {
              visitAsset(val, excludeMap);
            }
          }
        } else if (!value.constructor || value.constructor === Object) {
          var keys = Object.getOwnPropertyNames(value);

          for (var _j = 0; _j < keys.length; _j++) {
            var _val = value[keys[_j]];

            if (_val instanceof cc.RawAsset) {
              visitAsset(_val, excludeMap);
            }
          }
        } else if (value instanceof cc.RawAsset) {
          visitAsset(value, excludeMap);
        }
      }
    }
  }

  function visitNode(node, excludeMap) {
    if (!node.isValid) return;

    for (var i = 0; i < node._components.length; i++) {
      visitComponent(node._components[i], excludeMap);
    }

    for (var _i = 0; _i < node._children.length; _i++) {
      visitNode(node._children[_i], excludeMap);
    }
  }

  function visitItem(item, excludeMap) {
    if (excludeMap[item.url]) return;

    if (item.complete) {
      var asset = item.content;

      if (asset) {
        if (asset instanceof cc.RawAsset) {
          visitAsset(asset, excludeMap);
        } else {
          cc.log('asset instanceof cc.RawAsset === false');
        }
      } else {
        cc.log('item.complete === true, but item.content  is empty');
      }

      excludeMap[item.url] = true;

      if (debugUrl === item.url) {
        cc.log('debug');
      }
    } else {
      excludeMap[item.url] = true;

      if (debugUrl === item.url) {
        cc.log('debug');
      }

      var deps = item.deps;

      if (deps && deps.length > 0) {
        for (var i = 0; i < deps.length; i++) {
          var _item = deps[i];
          visitItem(_item, excludeMap);
        }
      }
    }
  }

  function visitNodePool(nodePool, excludeMap) {
    var pool = nodePool._pool;

    for (var j = 0; j < pool.length; j++) {
      var node = pool[j];
      visitNode(node, excludeMap);
    }
  }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "5d565wVUaVDPr73RyAj0Z55", "ResCleaner", undefined);

      debugUrl = '';

      _export("ResCleaner", ResCleaner = /*#__PURE__*/function () {
        function ResCleaner() {}

        // 资源清理
        ResCleaner.clean = function clean() {
          cc.log('--->资源释放 开始');
          var start = Date.now();
          var excludeMap = cc.js.createMap();
          var cache = cc.loader['_cache']; // 排除内置资源

          var builtinDeps = cc['AssetLibrary'].getBuiltinDeps();

          for (var key in builtinDeps) {
            excludeMap[key] = true;
          } // 排除场景引用的资源


          var nodeList = cc.director.getScene().children;

          for (var i = 0; i < nodeList.length; i++) {
            visitNode(nodeList[i], excludeMap);
          } // 剔除加载中的资源


          var runningQueues = {};

          for (var _key in cache) {
            var item = cache[_key];
            var queue = cc.LoadingItems.getQueue(item);

            if (queue) {
              var queueId = queue['_id'];
              runningQueues[queueId] = queue;
            }
          }

          for (var _queueId in runningQueues) {
            var _queue = runningQueues[_queueId];

            for (var url in _queue.map) {
              var _item2 = _queue.map[url];
              visitItem(_item2, excludeMap);
            }
          } // 白名单


          for (var _url in this._whiteList) {
            var asset = cc.loader.getRes(_url);

            if (asset) {
              visitAsset(asset, excludeMap);
            }
          } // 遍历资源缓存，逐个资源判断是否被场景引用，若未被场景上的节点引用则释放。


          var textureMem = 0;
          var releaseList = [];

          for (var _key2 in cache) {
            var _item3 = cache[_key2];

            if (!excludeMap[_key2]) {
              if (!_item3.complete) {
                cc.warn('资源未加载完却被释放！');
                continue;
              }

              releaseList.push(_key2);
              var _asset = _item3.content;

              if (_asset && _asset instanceof cc.Texture2D) {
                textureMem += _asset.width * _asset.height * 4; // 显存释放估计量
              }
            }
          }

          for (var _i2 = 0; _i2 < releaseList.length; _i2++) {
            var _key3 = releaseList[_i2];
            var _item4 = cache[_key3];
            if (!_item4) continue;
            var name = '';
            if (_item4.content && _item4.content.name) name = _item4.content.name; // cc.log('资源释放', key)

            cc.loader.release(_key3);
          }

          var timeSpan = Date.now() - start;
          cc.log("<---\u8D44\u6E90\u91CA\u653E\u7ED3\u675F\u3002\u8017\u65F6\uFF1A" + timeSpan + "ms, \u91CA\u653E\u8D44\u6E90\u6570\u91CF\uFF1A" + releaseList.length + "\uFF0C\u91CA\u653E\u663E\u5B58\uFF1A" + textureMem / (1024 * 1024) + "MB");
        }
        /**
         * 资源释放白名单
         */
        ;

        /**
         * 纹理的显存占用
         */
        ResCleaner.getTexGPUMemory = function getTexGPUMemory() {
          var textureMem = 0;
          var cache = cc.loader['_cache'];

          for (var key in cache) {
            var item = cache[key];
            var asset = item.content;

            if (asset && asset instanceof cc.Texture2D) {
              // 显存估计量
              var bytes = asset.getPixelFormat() == cc.Texture2D.PixelFormat.RGBA8888 ? 4 : 3;
              textureMem += asset.width * asset.height * bytes;
            }
          }

          return textureMem / (1024 * 1024);
        };

        _createClass(ResCleaner, null, [{
          key: "whiteList",
          set:
          /**
           *
           * @param url 被保护的资源
           */
          function set(urlList) {
            ResCleaner._whiteList = {};

            for (var i = 0; i < urlList.length; i++) {
              var url = urlList[i];
              ResCleaner._whiteList[url] = true;
            }
          }
        }]);

        return ResCleaner;
      }());

      _defineProperty(ResCleaner, "_whiteList", {});

      cc['ResCleaner'] = ResCleaner; // cc.ResCleaner.clean()
      // cc.ResCleaner.getTexGPUMemory()

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=ResCleaner.js.map