"use strict";
cc._RF.push(module, '1d5edQd7+dIoa/K+a6IRaJf', 'SpinePlusComponent');
// Script/Common/LiteGraphCore/SpinePlusComponent.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// const { ccclass, property, menu } = cc._decorator;
var SpinePlusComponent = /** @class */ (function (_super) {
    __extends(SpinePlusComponent, _super);
    function SpinePlusComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.customCollider = false;
        _this.actions = '';
        _this.camera = null;
        _this.clickEvent = [];
        _this.completeEvent = [];
        _this.polygonColliderArr = [];
        // @property({
        //     tooltip: CC_DEV && '是否为动态区域'
        // })
        _this.isDynamic = false;
        return _this;
    }
    Object.defineProperty(SpinePlusComponent.prototype, "spine", {
        get: function () {
            return this._spine;
        },
        set: function (spine) {
            this._spine = spine;
        },
        enumerable: false,
        configurable: true
    });
    SpinePlusComponent.prototype.onLoad = function () {
        this._spine = this.node.getComponent(sp.Skeleton);
        if (this._spine != null) {
            this._colliderSlot = this._spine.findSlot('Collider');
        }
        else {
            this.customCollider = true;
        }
    };
    SpinePlusComponent.prototype.update = function () {
        if (!this._polygonCollider || !this._colliderSlot || !this.isDynamic)
            return;
        //console.log('this._colliderSlot.bone.worldX', this._colliderSlot.bone.worldX)
        this._polygonCollider.offset.x = this._colliderSlot.bone.worldX;
        this._polygonCollider.offset.y = this._colliderSlot.bone.worldY;
        this._polygonCollider.points = [];
        for (var index = 0; index < this._colliderSlot.deform.length / 2; index++) {
            var v2 = this._polygonCollider.points[index];
            if (!v2)
                this._polygonCollider.points.push(cc.v2());
            this._polygonCollider.points[index].x = this._colliderSlot.deform[index * 2];
            this._polygonCollider.points[index].y = this._colliderSlot.deform[index * 2 + 1];
        }
    };
    SpinePlusComponent.prototype.refreshCollider = function () {
        this._colliderSlot = this._spine.findSlot('Collider');
        var attachement = this._colliderSlot.getAttachment(); //this._spine.getAttachment('Collider', 'Collider');
        //console.log(this._spine, attachement);
        // if (!this._attachment) {
        //     console.log('未获取碰撞边界组件', this.node.name);
        //     return;
        // }
        // this._polygonCollider.points = [];
        // for (let index = 0; index < this._attachment.vertices.length / 2; index++) {
        //     let v2: cc.Vec2 = this._polygonCollider.points[index];
        //     if (!v2) this._polygonCollider.points.push(cc.v2());
        //     this._polygonCollider.points[index].x = this._attachment.vertices[index * 2];
        //     this._polygonCollider.points[index].y = this._attachment.vertices[index * 2 + 1];
        // }
    };
    SpinePlusComponent.prototype.start = function () {
        // console.log('spinePlusComponent start')
        if (this.customCollider == true) {
            this.polygonColliderArr = this.node.getComponents(cc.PolygonCollider);
            if (this.polygonColliderArr.length > 0) {
                this.node['_hitTest'] = this.hitTest.bind(this);
            }
            this.addTouchEvent();
            // console.log('使用了spinePlusComponent customCollider')
            return;
        }
        this._attachment = this._spine.getAttachment('Collider', 'Collider');
        // console.log(this.node.name, this._spine);
        if (!this._attachment) {
            // console.log('spinePlusComponent 未获取碰撞边界组件', this.node.name);
            return;
        }
        this._polygonCollider = this.node.addComponent(cc.PolygonCollider);
        for (var index = 0; index < this._attachment.vertices.length / 2; index++) {
            var v2 = this._polygonCollider.points[index];
            if (!v2)
                this._polygonCollider.points.push(cc.v2());
            this._polygonCollider.points[index].x = this._attachment.vertices[index * 2];
            this._polygonCollider.points[index].y = this._attachment.vertices[index * 2 + 1];
        }
        // console.log('spinePlusComponent _polygonCollider_' + this.node.name, this._polygonCollider)
        this.node['_hitTest'] = this.hitTest.bind(this);
        this.addTouchEvent();
        if (this.actions.length > 0) {
            this.actionList = this.actions.split(',');
        }
        // this._spine.setEventListener((trackEntry: sp.spine.TrackEntry, event: sp.spine.Event) => {
        //     //待优化
        //     this.node.emit('SpineEvent', event.data.name);
        // });
    };
    Object.defineProperty(SpinePlusComponent.prototype, "actionList", {
        get: function () {
            return this._actionList;
        },
        set: function (actionList) {
            this._actionList = actionList;
        },
        enumerable: false,
        configurable: true
    });
    //添加触摸事件
    SpinePlusComponent.prototype.addTouchEvent = function () {
        if (this.node.hasEventListener(cc.Node.EventType.TOUCH_END)) {
            return;
        }
        this.node.on(cc.Node.EventType.TOUCH_END, this.spineClick.bind(this), this);
    };
    //移除触摸事件
    SpinePlusComponent.prototype.removeTouchEvent = function () {
        this.actionList = [];
        this.clickEvent = [];
        this.node.off(cc.Node.EventType.TOUCH_END, this.spineClick.bind(this), this);
    };
    SpinePlusComponent.prototype.playSpineAnimation = function () {
        var _this = this;
        if (!this._actionList)
            return;
        this.node.pauseSystemEvents(true);
        var aList = this._actionList.concat();
        var actName = this._endActName = aList.shift();
        var loopName = aList.pop();
        this._spine.setAnimation(0, actName, false);
        for (var index = 0; index < aList.length; index++) {
            var element = this._endActName = aList[index];
            this._spine.addAnimation(0, element, false);
        }
        this._spine.addAnimation(0, loopName, true);
        this._spine.setCompleteListener(function (trackEntry, loopCount) {
            var cAct = trackEntry.animation.name;
            //console.log(cAct, this._endActName);
            if (cAct == _this._endActName) {
                _this.node.resumeSystemEvents(true);
                _this._spine.setCompleteListener(null);
                cc.Component.EventHandler.emitEvents(_this.completeEvent, _this._spine);
            }
        });
    };
    SpinePlusComponent.prototype.spineClick = function () {
        this.playSpineAnimation();
        //console.log('click spine');
        cc.Component.EventHandler.emitEvents(this.clickEvent, this._spine);
    };
    SpinePlusComponent.prototype.hitTest = function (point) {
        // 坐标转换 //convertToNodeSpaceAR
        // let hitPos: cc.Vec2 = this.node.convertToNodeSpaceAR(point);
        var hitPos;
        if (this.camera) {
            var cpoint = this.camera.getScreenToWorldPoint(point);
            hitPos = this.node.convertToNodeSpaceAR(cpoint);
        }
        else {
            hitPos = this.node.convertToNodeSpaceAR(point);
        }
        if (this.polygonColliderArr != null && this.polygonColliderArr.length > 0) {
            var hasHit = false;
            for (var i = 0; i < this.polygonColliderArr.length; i++) {
                hasHit = cc.Intersection.pointInPolygon(cc.v2(hitPos), this.polygonColliderArr[i].points);
                if (hasHit == true) {
                    break;
                }
            }
            // console.log('碰撞组件的点击测试1', this.node.name, hasHit, this.polygonColliderArr, hitPos, '当前是否有camera：' + this.camera)
            return hasHit;
        }
        else {
            if (this._polygonCollider) {
                var bhit = cc.Intersection.pointInPolygon(cc.v2(hitPos), this._polygonCollider.points);
                // console.log("碰撞组件的点击测试2",  this.node.name, bhit)
                return bhit;
            }
        }
    };
    return SpinePlusComponent;
}(cc.Component));
exports.default = SpinePlusComponent;
cc.js.setClassName('SpinePlusComponent', SpinePlusComponent);

cc._RF.pop();