"use strict";
cc._RF.push(module, '5d355uaGNlIcbBoWitdX/Sj', 'customComponent');
// Script/Common/LiteGraphCore/nodes/customComponent.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseScriptRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(BaseScriptRobot, _LGraphNode);

  function BaseScriptRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "自定义脚本基础类";
    _this.desc = "直接挂载游戏中的脚本的指令继承于此";
    return _this;
  }

  var _proto = BaseScriptRobot.prototype;

  _proto.getCom = function getCom() {
    var configKey = this.properties.configKey;

    if (configKey.indexOf('cc.') != -1) {
      //使用cc内置组件
      return new cc[configKey.split('.')[1]]();
    }

    var comClass = cc.js.getClassByName(configKey);

    if (comClass == null) {
      console.warn('找不到脚本组件' + configKey + '请在App中测试真实运行效果');
      return null;
    }

    return new comClass();
  };

  _proto.onStart = function onStart() {
    var bindNode = this.getInputNode(0);

    if (bindNode != null && bindNode.codeNode != null) {
      //已经绑定到某个节点中
      this.hasRunRobotStart = true;

      if (this.component && this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    } else {
      var component = null;

      if (this.properties.isSingleClass == true) {
        component = this.getCom();
      } else {
        var rootccNode = this.graph.vars.rootccNode;

        if (rootccNode == null) {
          // 
          if (CocosMgr.isInApp == false) {
            var canvas = cc.director.getScene().getChildByName('Canvas');
            rootccNode = canvas.getChildByName('_componentsNode');

            if (rootccNode == null) {
              rootccNode = new cc.Node();
              rootccNode.name = '_componentsNode';
              rootccNode.parent = canvas;
            }
          } else {
            console.warn("没有rootccNode");
            return;
          }
        }

        component = this.getCom();
        rootccNode.addComponent(component);
      }

      if (component == null) {
        return;
      } //将变量同步到脚本中去


      for (var key in this.properties) {
        var value = null;
        var probInfo = this.getPropertyInfo(key);

        if (probInfo.type == 'robot') {
          value = this.graph.getNodeById(this.properties[key]);
        } else {
          // if(probInfo.type == 'enum' && this.properties[key].choosesKey != null){
          //     // console.log('应该动态赋值', this.properties[key].choosesKey[this.properties[key]])
          //     value = this.properties[key].choosesKey[this.properties[key]]
          // }else{
          // }
          value = this.properties[key];
        }

        if (component[key] != value) {
          component[key] = value;
        }
      }

      this.component = component;
      this.component.outputHandle = this.outputHandle;
      this.component.codeProgress = this.graph;

      if (this.component && this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    }

    if (this.getInputDataType(0) == 'codeNode') {
      if (this.getInputData(0) != null) {
        this.onBindCodeNode(this.getInputData(0));
      }
    }
  };

  _proto.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this2 = this;

    var comClass = cc.js.getClassByName(this.properties.configKey);

    if (comClass == null) {
      console.warn('找不到脚本组件' + this.properties.configKey + '请在App中测试真实运行效果');
      return;
    }

    var component = codeNode.getComponent(this.properties.configKey);

    if (component == null) {
      component = codeNode.addComponent(this.properties.configKey);
    }

    if (this.properties.configKey == 'cc.Mask') {
      //特殊处理一下
      if (this.properties.radius != 0) {
        var roundRectMask = codeNode.getComponent('RoundRectMask');

        if (roundRectMask == null) {
          roundRectMask = codeNode.addComponent('RoundRectMask');
        }

        roundRectMask._radius = this.properties.radius;
      } else {
        codeNode.removeComponent('RoundRectMask');
      }
    }

    var initKey = function initKey(key) {
      var value = null;

      var probInfo = _this2.getPropertyInfo(key);

      if (probInfo.type == 'robot') {
        value = _this2.graph.getNodeById(_this2.properties[key]);
      } else if (probInfo.type == 'spriteFrame') {
        _this2.codeProgress.codeRobotConfig.loadResHandle(_this2.properties[key], cc.SpriteFrame, function (res) {
          value = res;

          if (component[key] != value && value != null) {
            component[key] = value;
          }
        });
      } else {
        // if(probInfo.type == 'toggleGroup' && this.properties.otherConfig[key].choosesKey != null){
        //     // console.log('应该动态赋值', this.properties.otherConfig[key].choosesKey[this.properties.otherConfig[key]])
        //     value = this.properties.otherConfig[key].choosesKey[this.properties.otherConfig[key]]
        // }else{
        //     value = this.properties.otherConfig[key]
        // }
        value = _this2.properties[key];
      }

      if (component[key] != value && value != null) {
        component[key] = value;
      }
    }; // console.log('给component设置值的时候是否已经init了', component.hasInit)


    for (var key in this.properties) {
      initKey(key);
    }

    this.component = component;
    this.component.outputHandle = this.outputHandle.bind(this);
    this.component.codeProgress = this.graph; // console.log(this.properties.configKey,'this.hasRunRobotStart' ,this.hasRunRobotStart)

    if (this.hasRunRobotStart == true) {
      if (this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    }
  };

  _proto.inputHandle = function inputHandle(inputData) {
    if (this.component == null) {
      if (CocosMgr.isInApp == false) {
        CocosMgr.showAlert(this.properties.configKey + '还未初始化就输入了');
      } else {
        console.warn(this.properties.configKey + '还未初始化就输入了');
      }
    } else {
      if (this.component.inputHandle != null) {
        this.component.inputHandle(inputData);
      }
    }
  } //适配output handle的输出
  ;

  _proto.outputHandle = function outputHandle(key, value) {
    var index = this.findOutputSlot(key);

    if (index != -1) {
      var info = this.getOutputInfo(index);

      if (info.type == _litegraph.LiteGraph.EVENT) {
        this.triggerSlot(index, value);
      } else {
        this.setOutputData(index, value);
      }
    }
  };

  _proto.onPause = function onPause() {
    if (this.component && this.component.robotPause != null) {
      this.component.robotPause();
    }
  };

  _proto.onResume = function onResume() {
    if (this.component && this.component.robotResume != null) {
      this.component.robotResume();
    }
  } //运行时刷新配置
  ;

  _proto.inRunFreshConfig = function inRunFreshConfig(key) {
    if (this.component != null) {
      this.component[key] = this.properties.otherConfig[key];

      if (this.component.inRunFreshConfig != null) {
        this.component.inRunFreshConfig(key);
      }
    }
  } //停止运行
  ;

  _proto.onStop = function onStop() {
    this.hasRunRobotStart = false;

    if (this.component && this.component.robotRelease != null) {
      this.component.robotRelease();
    } // if(this.component != null){
    //     if(cc.isValid(this.component.node)){
    //         this.component.node.removeComponent(this.component)
    //     }
    //     this.component.codeProgress = null
    //     this.component = null
    // }

  };

  return BaseScriptRobot;
}(_litegraph.LGraphNode); //自定义脚本组件


var MotionText = /*#__PURE__*/function (_BaseScriptRobot) {
  _inheritsLoose(MotionText, _BaseScriptRobot);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function MotionText() {
    var _this3;

    _this3 = _BaseScriptRobot.call(this) || this; // this.serialize_widgets = true

    _this3.title = "字幕";
    _this3.desc = "在绘本中添加字幕";
    _this3.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this3.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this3.addInput("物体", 'codeNode');

    _this3.addInput("启用", _litegraph.LiteGraph.ACTION);

    _this3.addInput("隐藏", _litegraph.LiteGraph.ACTION);

    _this3.addOutput("onend", _litegraph.LiteGraph.EVENT);

    _this3.addProperty('autoRun', false, 'boolean');

    _this3.addWidget('toggle', '自动播放', _this3.properties.autoRun, 'autoRun');

    _this3.addProperty('dir', false, 'boolean');

    _this3.addWidget('toggle', '文本竖向排列', _this3.properties.dir, 'dir');

    _this3.addProperty('hideBeforRun', true, 'boolean');

    _this3.addWidget('toggle', '运行前隐藏', _this3.properties.hideBeforRun, 'hideBeforRun');

    _this3.addProperty('hideAfterRun', false, 'boolean');

    _this3.addWidget('toggle', '运行结束隐藏', _this3.properties.hideAfterRun, 'hideAfterRun');

    _this3.addProperty('hideBaseLabel', false, 'boolean');

    _this3.addWidget('toggle', '隐藏底层文字', _this3.properties.hideBaseLabel, 'hideBaseLabel');

    _this3.addProperty('position', '0,1', 'string');

    _this3.addWidget('string', '分段位置', _this3.properties.position, 'position');

    _this3.addProperty('positionTime', '0,2', 'string');

    _this3.addWidget('string', '分段时间', _this3.properties.positionTime, 'positionTime');

    _this3.addProperty('maskColor', '#88BF3D', 'string');

    _this3.addWidget('string', '过渡颜色', _this3.properties.maskColor, 'maskColor');

    _this3.addProperty('configKey', 'MotionText', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this3;
  }

  var _proto2 = MotionText.prototype;

  _proto2.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    console.log('MotionText onConnectInput', inputIndex, outPutType);

    if (inputIndex == 0 && outPutType == 'codeNode') {
      //将文本的anchorX设置为0
      linkedNode.setProperty('anchorX', 0);
    }
  } // 当节点Toggle时调用
  ;

  _proto2.onAction = function onAction(action, param) {
    if (this.component == null) {
      return;
    }

    if (this.component.inputHandle == null) {
      console.warn('inputHandle == null');
      return;
    }

    if (action == '启用') {
      this.component.inputHandle({
        targetSolt: 'show'
      });
    } else if (action == '隐藏') {
      this.component.inputHandle({
        targetSolt: 'hide'
      });
    }
  };

  return MotionText;
}(BaseScriptRobot);

MotionText.title = '字幕';

_litegraph.LiteGraph.registerNodeType("output/customComponent/MotionText", MotionText); //
//自定义脚本组件


var CaiDanComponent = /*#__PURE__*/function (_BaseScriptRobot2) {
  _inheritsLoose(CaiDanComponent, _BaseScriptRobot2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function CaiDanComponent() {
    var _this4;

    _this4 = _BaseScriptRobot2.call(this) || this; // this.serialize_widgets = true

    _this4.title = "桃桃彩蛋";
    _this4.desc = "在绘本中添加桃桃彩蛋";
    _this4.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this4.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this4.addInput("物体", 'codeNode'); // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);


    _this4.addOutput("onclick", _litegraph.LiteGraph.EVENT);

    _this4.addProperty('caidanYuyin', '', 'string');

    _this4.addWidget('string', '彩蛋语音', _this4.properties.caidanYuyin, 'caidanYuyin');

    _this4.addProperty('startSound', '', 'string');

    _this4.addWidget('string', '出现语音', _this4.properties.startSound, 'startSound');

    _this4.addProperty("caidanId", 0, "number");

    _this4.addWidget("slider", '彩蛋Id', _this4.properties.caidanId, "caidanId", {
      min: 0,
      max: 10,
      precision: 0
    });

    _this4.addProperty("caidanPosX", 0, "number");

    _this4.addWidget("number", '桃桃动画位置X', _this4.properties.caidanPosX, "caidanPosX", {
      precision: 1
    });

    _this4.addProperty("caidanPosY", 0, "number");

    _this4.addWidget("number", '桃桃动画位置Y', _this4.properties.caidanPosY, "caidanPosY", {
      precision: 1
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')


    _this4.addProperty('playSound', true, 'boolean');

    _this4.addWidget('toggle', '播放声音', _this4.properties.playSound, 'playSound'); // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')


    _this4.addProperty('configKey', 'CaiDanComponent', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this4;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return CaiDanComponent;
}(BaseScriptRobot);

CaiDanComponent.title = '桃桃彩蛋';

_litegraph.LiteGraph.registerNodeType("output/customComponent/CaiDanComponent", CaiDanComponent); //自定义脚本组件


var CaiDanComponent2 = /*#__PURE__*/function (_BaseScriptRobot3) {
  _inheritsLoose(CaiDanComponent2, _BaseScriptRobot3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function CaiDanComponent2() {
    var _this5;

    _this5 = _BaseScriptRobot3.call(this) || this; // this.serialize_widgets = true

    _this5.title = "收藏品彩蛋";
    _this5.desc = "在绘本中添加收藏品彩蛋";
    _this5.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this5.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this5.addInput("物体", 'codeNode'); // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);
    // this.addOutput("onclick", LiteGraph.EVENT)


    _this5.addProperty("caidanId", 0, "number");

    _this5.addWidget("slider", '彩蛋Id', _this5.properties.caidanId, "caidanId", {
      min: 0,
      max: 10,
      precision: 0
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')


    _this5.addProperty('configKey', 'CaiDanComponent2', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this5;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return CaiDanComponent2;
}(BaseScriptRobot);

CaiDanComponent2.title = '收藏品彩蛋';

_litegraph.LiteGraph.registerNodeType("output/customComponent/CaiDanComponent2", CaiDanComponent2); //剧情气泡
//自定义脚本组件


var ChatComponent = /*#__PURE__*/function (_BaseScriptRobot4) {
  _inheritsLoose(ChatComponent, _BaseScriptRobot4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ChatComponent() {
    var _this6;

    _this6 = _BaseScriptRobot4.call(this) || this; // this.serialize_widgets = true

    _this6.title = "对话提示气泡";
    _this6.desc = "在绘本中添加对话提示气泡";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this6.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this6.addInput("物体", 'codeNode');

    _this6.addInput("输入", _litegraph.LiteGraph.ACTION);

    _this6.addInput("更新", _litegraph.LiteGraph.ACTION);

    _this6.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this6.addProperty("key", '', "string");

    _this6.addWidget("string", '点击标记', _this6.properties.key, "key");

    _this6.addProperty('configKey', 'ChatComponent', 'string');

    _this6.addProperty('dirType', '左下', 'enum');

    _this6.addWidget('combo', '气泡箭头方向', _this6.properties.dirType, {
      property: "dirType",
      values: ['左下', '右下', '右上', '左上']
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this6;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ChatComponent;
}(BaseScriptRobot);

ChatComponent.title = '对话提示气泡';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ChatComponent", ChatComponent);

var VoiceCheck = /*#__PURE__*/function (_BaseScriptRobot5) {
  _inheritsLoose(VoiceCheck, _BaseScriptRobot5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function VoiceCheck() {
    var _this7;

    _this7 = _BaseScriptRobot5.call(this) || this; // this.serialize_widgets = true

    _this7.title = "声音检测";
    _this7.desc = "在绘本中添加声音检测";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this7.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    // this.addInput("物体", 'codeNode');

    _this7.addInput("开始", _litegraph.LiteGraph.ACTION);

    _this7.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this7.addOutput("输出", _litegraph.LiteGraph.EVENT);

    _this7.addProperty("testStr", '', "string");

    _this7.addWidget("string", '检测的字符', _this7.properties.testStr, "testStr");

    _this7.addProperty("testStrGroup", '', "string");

    _this7.addWidget("string", '检测的词组（用,分割）', _this7.properties.testStrGroup, "testStrGroup");

    _this7.addProperty('checkType', '左下', 'enum');

    _this7.addWidget('combo', '检测模式', _this7.properties.checkType, {
      property: "checkType",
      values: ['跟读', '关键字模式']
    });

    _this7.addProperty('configKey', 'VoiceCheck', 'string');

    _this7.addProperty('isSingleClass', true, 'boolean'); // this.addProperty("key", 0, "string");
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this7;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return VoiceCheck;
}(BaseScriptRobot);

VoiceCheck.title = '声音检测';

_litegraph.LiteGraph.registerNodeType("output/customComponent/VoiceCheck", VoiceCheck);

var AngleCompoment = /*#__PURE__*/function (_BaseScriptRobot6) {
  _inheritsLoose(AngleCompoment, _BaseScriptRobot6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function AngleCompoment() {
    var _this8;

    _this8 = _BaseScriptRobot6.call(this) || this; // this.serialize_widgets = true

    _this8.title = "角度定位";
    _this8.desc = "在绘本中添加物让其根据输入的角度定位";
    _this8.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this8.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this8.addInput("物体", 'codeNode');

    _this8.addInput("开启监听", _litegraph.LiteGraph.ACTION);

    _this8.addInput("重置", _litegraph.LiteGraph.ACTION);

    _this8.addOutput("number1", 'number'); // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this8.addProperty('configKey', 'AngleCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this8;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return AngleCompoment;
}(BaseScriptRobot);

AngleCompoment.title = '角度定位';

_litegraph.LiteGraph.registerNodeType("output/customComponent/AngleCompoment", AngleCompoment);

var ScaleObj = /*#__PURE__*/function (_BaseScriptRobot7) {
  _inheritsLoose(ScaleObj, _BaseScriptRobot7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ScaleObj() {
    var _this9;

    _this9 = _BaseScriptRobot7.call(this) || this; // this.serialize_widgets = true

    _this9.title = "双指缩放";
    _this9.desc = "在绘本中添加双指缩放手势";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this9.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this9.addInput("物体", 'codeNode');

    _this9.addInput("启用", _litegraph.LiteGraph.ACTION);

    _this9.addInput("关闭", _litegraph.LiteGraph.ACTION);

    _this9.addOutput("onScale", _litegraph.LiteGraph.EVENT); // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this9.addProperty('configKey', 'AngleCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')


    _this9.addProperty("scaleMin", 0.5, "number");

    _this9.addWidget('number', '最小缩放', _this9.properties.scaleMin, "scaleMin", {
      precision: 1
    });

    _this9.addProperty("scaleMax", 2, "number");

    _this9.addWidget('number', '最大缩放', _this9.properties.scaleMax, "scaleMax", {
      precision: 1
    });

    _this9.addProperty('dynimicCenter', false, 'boolean');

    _this9.addWidget('toggle', '是否以当前中心缩放', _this9.properties.dynimicCenter, 'dynimicCenter'); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ScaleObj;
}(BaseScriptRobot);

ScaleObj.title = '双指缩放';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ScaleObj", ScaleObj);

var ProgressCompoment = /*#__PURE__*/function (_BaseScriptRobot8) {
  _inheritsLoose(ProgressCompoment, _BaseScriptRobot8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ProgressCompoment() {
    var _this10;

    _this10 = _BaseScriptRobot8.call(this) || this; // this.serialize_widgets = true

    _this10.title = "进度条";
    _this10.desc = "发送绘本页面进度事件，关联图片类型的物体使用";
    _this10.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this10.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this10.addInput("物体", 'codeNode');

    _this10.addInput("进度", 'number');

    _this10.addInput("更新", _litegraph.LiteGraph.ACTION); // this.addOutput("增量", LiteGraph.EVENT)
    // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this10.addProperty('configKey', 'ProgressCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("scaleMin", 0.5, "number");
    // this.addWidget('number', '最小缩放', this.properties.scaleMin, "scaleMin", {precision: 1});
    // this.addProperty("scaleMax", 2, "number");
    // this.addWidget('number', '最大缩放', this.properties.scaleMax, "scaleMax", {precision: 1});
    // this.addProperty('dynimicCenter', false, 'boolean')
    // this.addWidget('toggle', '是否以当前中心缩放', this.properties.dynimicCenter, 'dynimicCenter')
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this10;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ProgressCompoment;
}(BaseScriptRobot);

ProgressCompoment.title = '进度条';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ProgressCompoment", ProgressCompoment);

var ccMask = /*#__PURE__*/function (_BaseScriptRobot9) {
  _inheritsLoose(ccMask, _BaseScriptRobot9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ccMask() {
    var _this11;

    _this11 = _BaseScriptRobot9.call(this) || this; // this.serialize_widgets = true

    _this11.title = "蒙版";
    _this11.desc = "给节点添加蒙版效果";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this11.addInput("物体", 'codeNode'); // this.addInput("进度", 'number');
    // this.addInput("更新", LiteGraph.ACTION);
    // this.addOutput("增量", LiteGraph.EVENT)
    // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");
    // console.log('cc.Mask Name', cc.Mask)


    _this11.addProperty('configKey', 'cc.Mask', 'string');

    _this11.addProperty('type', 0, 'number');

    _this11.addWidget('combo', '遮罩类型', _this11.properties.type, {
      property: "type",
      values: {
        0: '矩形',
        1: '圆形',
        2: '图片'
      }
    }); // let arr = [cc.Mask.Type.RECT,cc.Mask.Type.ELLIPSE,cc.Mask.Type.IMAGE_STENCIL]
    // console.log('这招类型', arr)
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')


    _this11.addProperty('inverted', false, 'boolean');

    _this11.addWidget('toggle', '反向遮罩', _this11.properties.inverted, 'inverted'); // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("scaleMin", 0.5, "number");
    // this.addWidget('number', '最小缩放', this.properties.scaleMin, "scaleMin", {precision: 1});


    _this11.addProperty("alphaThreshold", 0.5, "number");

    _this11.addWidget('number', '透明度阀值', _this11.properties.alphaThreshold, "alphaThreshold", {
      precision: 2,
      min: 0,
      max: 1
    });

    _this11.addProperty("segements", 50, "number");

    _this11.addWidget('number', '椭圆遮罩曲线数', _this11.properties.segements, "segements", {
      precision: 2,
      min: 1,
      max: 100
    });

    _this11.addProperty("radius", 0, "number");

    _this11.addWidget('number', '矩形圆角曲线数', _this11.properties.radius, "radius", {
      precision: 1,
      min: 0,
      max: 100
    });

    _this11.addProperty('spriteFrame', '', 'string');

    _this11.addWidget('string', '图片路径', _this11.properties.spriteFrame, 'spriteFrame'); // this.addProperty('dynimicCenter', false, 'boolean')
    // this.addWidget('toggle', '是否以当前中心缩放', this.properties.dynimicCenter, 'dynimicCenter')
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this11;
  }

  var _proto3 = ccMask.prototype;

  _proto3.updateWidght = function updateWidght() {
    var type = this.properties.type;
    this.widgets.map(function (widget) {
      if (widget.name == '矩形圆角曲线数') {
        widget.disabled = type != 0;
      } else if (widget.name == '椭圆遮罩曲线数') {
        widget.disabled = type != 1;
      }
    }); // this.expandToFitContent()
  };

  _proto3.onWidgetChanged = function onWidgetChanged(name) {
    console.log('当前这招类型', this.properties.type);

    if (name == '遮罩类型') {
      this.updateWidght();
    }
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }
  ;

  return ccMask;
}(BaseScriptRobot);

ccMask.title = '蒙版';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ccMask", ccMask);

cc._RF.pop();