"use strict";
cc._RF.push(module, '658f49F0xBEM7Yr/NJxLROE', 'objects');
// Script/Common/LiteGraphCore/nodes/objects.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

var _bezier = require("../../Bezier/bezier");

var _BaseYwNode = require("./BaseYwNode");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var soundFxs = ['无', 'popOut.mp3'];

var createObject = /*#__PURE__*/function (_BaseYWNode) {
  _inheritsLoose(createObject, _BaseYWNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function createObject() {
    var _this;

    _this = _BaseYWNode.call(this) || this; // this.serialize_widgets = true

    _this.title = "物体";
    _this.desc = "在界面中创建一个物体";
    _this.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this.addInput("创建", _litegraph.LiteGraph.ACTION); // this.addInput("触发", LiteGraph.ACTION);


    _this.addOutput("物体", 'codeNode');

    _this.addProperty('group', false, 'boolean');

    _this.addWidget('toggle', '是否作为UI', _this.properties.group, 'group');

    _this.addProperty('modal', '空物体', 'enum');

    _this.addWidget('combo', '物体类型', _this.properties.modal, {
      property: "modal",
      values: CocosMgr.objectTypes
    });

    _this.addProperty('customeName', '', 'string');

    _this.addWidget('string', '资源', _this.properties.customeName, 'customeName');

    _this.addProperty('showTime', 0, 'number');

    _this.addWidget('combo', '加载时机', _this.properties.showTime, {
      property: "showTime",
      values: {
        0: '初始化时',
        1: '输入时'
      }
    });

    _this.addProperty('premulAlpha', false, 'boolean');

    _this.addWidget('toggle', '是否预乘', _this.properties.premulAlpha, 'premulAlpha');

    _this.addProperty('zIndex', 1, 'number');

    _this.addWidget('number', '层级', _this.properties.zIndex, 'zIndex', {
      precision: 0
    });

    _this.addProperty('dynamiczIndex', false, 'boolean');

    _this.addWidget('toggle', '以y轴动态计算层级', _this.properties.dynamiczIndex, 'dynamiczIndex');

    _this.addProperty('x', -1280, 'number');

    _this.addWidget('number', '坐标-x', _this.properties.x, 'x', {
      precision: 2
    });

    _this.addProperty('y', -750, 'number');

    _this.addWidget('number', '坐标-y', _this.properties.y, 'y', {
      precision: 2
    });

    _this.addProperty('scaleX', 1, 'number');

    _this.addWidget('number', '缩放-x', _this.properties.scaleX, 'scaleX', {
      precision: 2
    });

    _this.addProperty('scaleY', 1, 'number');

    _this.addWidget('number', '缩放-y', _this.properties.scaleY, 'scaleY', {
      precision: 2
    });

    _this.addProperty('opacity', 255, 'number');

    _this.addWidget('slider', '透明度', _this.properties.opacity, 'opacity', {
      min: 0,
      max: 255,
      precision: 0
    });

    _this.addProperty('angle', 0, 'number');

    _this.addWidget('number', '角度', _this.properties.angle, 'angle', {
      min: -360,
      max: 360,
      precision: 0
    });

    _this.addProperty('anchorX', 0.5, 'number');

    _this.addWidget('number', '锚点x', _this.properties.anchorX, 'anchorX', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this.addProperty('anchorY', 0.5, 'number');

    _this.addWidget('number', '锚点y', _this.properties.anchorY, 'anchorY', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this.addProperty('width', 50, 'number');

    _this.widthWidget = _this.addWidget('number', '宽度', _this.properties.width, 'width', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this.addProperty('height', 50, 'number');

    _this.heightWidget = _this.addWidget('number', '高度', _this.properties.height, 'height', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this.addWidget('button', '重置为资源尺寸', "", function () {
      console.log('点击了重置按钮');

      _this.resetSizeConfig();
    });

    _this.addProperty('color', '#ffffff', 'string');

    _this.addWidget('string', '物体颜色', _this.properties.color, 'color');

    _this._hasToggleAssestLoad = false; //节点配置

    _this.addProperty('nodeConfig', {
      x: _this.properties.x,
      y: _this.properties.y,
      width: _this.properties.width,
      height: _this.properties.height,
      anchorX: _this.properties.anchorX,
      anchorY: _this.properties.anchorY,
      scaleX: _this.properties.scaleX,
      scaleY: _this.properties.scaleY,
      color: _this.properties.color,
      angle: _this.properties.angle
    }, 'object');

    _this.nodeConfigWidget = _this.addWidget('ccnode', '节点操控', _this.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    });

    _this.addProperty('string', '', 'string');

    _this.addWidget('string', '文本', _this.properties.string, 'string');

    _this.addProperty('outLineWidth', 0, 'number');

    _this.addWidget('slider', '描边宽度', _this.properties.outLineWidth, 'outLineWidth', {
      precision: 0,
      min: 0,
      max: 100
    });

    _this.addProperty('outLineColor', '#ffffff', 'string');

    _this.addWidget('string', '描边颜色', _this.properties.outLineColor, 'outLineColor');

    _this.addProperty('colliderValue', {}, 'object'); //需要创建设置碰撞框的组件
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    // this.properties.precision = 1
    // console.log('节点构建完毕')


    return _this;
  }

  var _proto = createObject.prototype;

  _proto.getExtraMenuOptions = function getExtraMenuOptions(graphcanvas) {
    var _this2 = this;

    // var that = this;
    return [{
      content: "编辑碰撞框",
      callback: function callback() {
        if (window.onGraphMenuClick != null) {
          // console.log(' this.properties.colliderValue.pointArr',  this.properties.colliderValue)
          if (Array.isArray(_this2.properties.colliderValue) == true) {
            _this2.properties.colliderValue = {};
          }

          window.onGraphMenuClick('editColider', {
            img: _this2.getPreviewImg(),
            scale: _this2.properties.colliderValue.scale || 1,
            pointArr: _this2.properties.colliderValue.pointArr || [],
            onValueChange: function onValueChange(pointArr, scale) {
              console.log('pointArr', pointArr, scale);
              _this2.properties.colliderValue.pointArr = pointArr;
              _this2.properties.colliderValue.baseWidth = _this2.properties.width;
              _this2.properties.colliderValue.baseHeight = _this2.properties.height;
              _this2.properties.colliderValue.scale = scale;
              var offsetX = 0;
              var offsetY = 0;

              if (_this2._renderSpine != null) {
                if (_this2._renderSpine.canRender) {
                  offsetX = _this2._renderSpine.bounds.offset.x + 0.5 * _this2.properties.width;
                  offsetY = _this2._renderSpine.bounds.offset.y + 0.5 * _this2.properties.height;
                }
              }

              _this2.properties.colliderValue.offsetX = offsetX;
              _this2.properties.colliderValue.offsetY = offsetY; //这个修改了的话，就要删除节点重新创建

              if (_this2.codeNode != null) {
                // console.log('碰撞框已经修改，删除节点重新创建')
                _this2.codeNode.destroyNode();

                _this2.codeNode = null;

                _this2.setOutputData(0, null);

                _this2.createObj();
              }
            }
          });
        }
      }
    }];
  };

  //onAdded每次添加到蓝图中都会调用
  _proto.onAdded = function onAdded() {
    console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal); //如果是拖拽资源的话，这里也是需要触发的

    this.updateWidght();
    this.updateRenderAssest(); //重新计算一下默认尺寸

    this.setSize(this.computeSize());
    this.sendAddEvent();
  };

  _proto.onRemoved = function onRemoved() {
    // console.log('我从graph中移除了', this.properties.customeName)
    if (this.codeNode != null) {
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);
    }

    this._image = null;
    this._renderSpine = null;
    this.sendRemoveEvent();

    if (this.checkAssestTimeOut != null) {
      clearInterval(this.checkAssestTimeOut);
      this.checkAssestTimeOut = null;
    }
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto.onConfigure = function onConfigure() {
    var _this3 = this;

    if (CocosMgr.isInApp == true) {
      return;
    }

    if (CocosMgr.isInImport == true) {
      return;
    } // console.log('createObject节点配置了', this.properties.customeName, this.properties.modal)


    this.updateWidght();
    this.updateRenderAssest();

    if (this.graph && CocosMgr.isSinglePreview == true) {
      //在另一个网页打开的单列，不需要canvas渲染蓝图
      this.createObj();
    } else {
      if (this.graph && this.graph.list_of_graphcanvas != null && this.graph.list_of_graphcanvas.length > 0) {
        //说明在编辑中，始终创建预览
        this.createObj(function () {
          if (_this3.properties.modal == 'spine') {
            setTimeout(function () {
              try {
                //根据连接的animate动画自动设置首选预览图
                var linkedNodes = _this3.getOutputNodes(0);

                if (linkedNodes != null) {
                  linkedNodes = linkedNodes.filter(function (node) {
                    return node.type == 'objects/animates/animate' && node.properties.autoRun == true;
                  });

                  if (linkedNodes[0] != null) {
                    var firstAni = linkedNodes[0];
                    firstAni.onSelected();
                    var skin = firstAni.properties.skin; // console.log('物体创建完成了', this.properties.customeName, this.properties.modal, skin, firstAni.properties.playAniName)

                    _this3.codeNode.setSkin(skin);

                    _this3.codeNode.playAnimation(firstAni.properties.playAniName, firstAni.properties.loop);
                  }
                }
              } catch (error) {}
            }, 1000);
          }
        });
      }
    } // this.createObj()

  } //开始运行会初始化
  ;

  _proto.onStartBeforeLoad = function onStartBeforeLoad() {
    var _this4 = this;

    console.log('createObject onStart', this.properties.showTime);
    var showTime = this.properties.showTime;

    if (showTime == 0) {
      //'初始化时'
      this.graph.config.assestTotal += 1;
      this.createObj(function () {
        _this4.graph.config.assestLoaded += 1;

        if (_this4.graph.checkAssestLoadComplete != null) {
          _this4.graph.checkAssestLoadComplete();
        }
      });
    }
  } //创建一个物体
  ;

  _proto.createObj = function createObj(loadCb) {
    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == true) {
        // if(CocosMgr.isInApp == true){
        //不重复生成，仅仅重置所有参数
        var config = _extends({}, this.properties);

        CocosMgr.syncConfigToCodeNode(this.codeNode, config);

        if (loadCb != null) {
          loadCb();
        }

        this.setOutputData(0, this.codeNode);
        return; // }
        // console.log('我删除了旧的codeNode', this.codeNode.node._id)
        // this.codeNode.destroyNode()
      }

      this.codeNode = null;
      this.setOutputData(0, null);
    }

    var config = _extends({}, this.properties); // console.log('createObj config', config)  //调用一个创建物体的配置


    var rootccNode = this.graph.vars.rootccNode;

    if (rootccNode != null) {
      config['parent'] = rootccNode;
    }

    this.codeNode = CocosMgr.createObj(config, loadCb);
    this.codeNode.graph = this.graph;
    console.log('我创建了的codeNode', this.codeNode.node._id);
    this.setOutputData(0, this.codeNode);
    return this.codeNode;
  };

  _proto.updateOutputData = function updateOutputData(slot) {
    console.log('我收到了更新物体的事件', slot);
    this.setOutputData(slot, this.codeNode);
  } //在不同的蓝图切换，需要查询是否存在预览节点，不存在的话就创建
  //当lagraph attach时此node可能还未创建，所以不能
  // onAttachCanvas(){
  //     console.log('onAttachCanvas', this.properties.customeName )
  //     this.createObj()
  // }
  // onDetachCanvas(){
  //     console.log('onDetachCanvas', this.properties.customeName )
  //     //如果当前是打开的是子蓝图，那就不要删除
  //     console.log('this.graph', this.graph)
  //     if(this.codeNode != null){
  //         this.codeNode.destroyNode()
  //         this.codeNode = null
  //     }
  // }
  // 当节点Toggle时调用
  ;

  _proto.onAction = function onAction(action, param) {
    if (action == '创建') {
      this.createObj();
    }
  };

  _proto.getTitle = function getTitle() {
    var value = this.properties.modal; // var customeName = this.properties.customeName
    // var firstDotIndex = customeName.indexOf('.')
    // if(firstDotIndex != -1){
    //     customeName = customeName.substring(0, firstDotIndex)
    // }

    if (value == '文本') {
      var str = this.properties.string.length < 9 ? this.properties.string : this.properties.string.substring(0, 8) + '..';
      value += ':' + str;
    }

    this.inputs;
    return value; //+ "  " + customeName
  };

  _proto.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      // widget.name == '描边宽度'
      if (widget.name == '文本' || widget.name == '描边颜色') {
        widget.hidden = value != '文本'; // widget.computedDisabled = value != '文本'
      }

      if (widget.name == '锚点x' || widget.name == '锚点y' || widget.name == '宽度' || widget.name == '高度') {
        widget.disabled = value == 'spine';
      }
    }); // this.expandToFitContent()
  } // onSelected(){
  // }
  ;

  _proto.onPause = function onPause() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null) {
        this.codeNode.spineCom.paused = true;
      }

      cc.director.getActionManager().pauseTarget(this.codeNode);
    }
  } //切换时间缩放
  ;

  _proto.onChangeTimeScale = function onChangeTimeScale() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null && this.graph.config.timeScale != null) {
        this.codeNode.spineCom.timeScale = this.graph.config.timeScale;
      }
    }
  };

  _proto.onResume = function onResume() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null) {
        this.codeNode.spineCom.paused = false;
      }

      cc.director.getActionManager().resumeTarget(this.codeNode);
    }
  };

  _proto.onStop = function onStop() {
    // this.isOutputConnected(0)
    // this.outputs.map((item)=>{
    //     return item.name
    // })
    // this.findInputSlot('播放')
    // let link = this.graph.links.get(2)
    // link.target_id
    //这里不能重制，重置了翻页会闪烁
    this.codeNode.targetOff();

    if (this.codeNode != null && CocosMgr.isInApp == false) {
      var config = _extends({}, this.properties.nodeConfig); // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }
  };

  _proto.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    // console.log('onPropertyChanged', name, value)
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }
      }
    }

    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == false) {
        this.codeNode = null;
        return;
      }

      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);

      if (property == 'string') {
        //修改文本重新设置尺寸
        this.resetSizeConfig();
      }
    } // if(property == 'modal'){
    //   this.updateRenderAssest()
    // }else if(property == 'customeName'){
    //   this.updateRenderAssest()
    // }


    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  _proto.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {
    // console.log('onWidgetChanged', name, value, oldValue, widget)
    // var property = widget.options.property
    if (name == '物体类型') {
      this.updateWidght();
      this.updateRenderAssest();
    } else if (name == '资源') {
      this.updateRenderAssest();
    }

    this.sendOtherEvent('onWidgetChanged', [name]);
  } //更新可以显示的资源
  ;

  _proto.updateRenderAssest = function updateRenderAssest() {
    var _this5 = this;

    if (CocosMgr.isInApp == true) {
      //在App中不会运行此操作
      return;
    } // console.log('导入时不会刷新资源预览', CocosMgr.isInImport)


    if (CocosMgr.isInImport == true) {
      //在App中不会运行此操作
      return;
    } // if(CocosMgr.isSinglePreview == true){
    //     //直接创建物体就行了，不需要创建预览，如果这里不加载预览，可能会导致获取不到资源信息，所以还是应该加载？
    //     this.createObj()
    //     return
    // }


    var modal = this.properties.modal;
    var customeName = this.properties.customeName;
    console.log('updateRenderAssest', modal, customeName);

    if (modal != 'spine') {
      this._renderSpine = null;
    }

    if (modal != '图片') {
      if (this._image != null) {
        this._image.src = null;
        this._image = null;
      }
    }

    if (modal == '图片') {
      if (this._image == null) {
        this._image = new Image();
      }

      var realSrc = CocosMgr.rootHost + '/' + customeName;

      if (this._image.src != realSrc) {
        this._image.src = realSrc;
        this._hasToggleAssestLoad = false;

        if (this.checkAssestTimeOut != null) {
          clearInterval(this.checkAssestTimeOut);
          this.checkAssestTimeOut = null;
        }

        this.checkAssestTimeOut = setInterval(function () {
          _this5.checkAssestLoaded();
        }, 500);
      }
    } else if (modal == 'spine') {
      if (this._renderSpine == null) {
        this._renderSpine = new SpineToImg();
      }

      var assetName = customeName + '.json';

      if (this._renderSpine.assets == null || this._renderSpine.assets.json != assetName) {
        this._hasToggleAssestLoad = false;

        if (this.checkAssestTimeOut != null) {
          clearInterval(this.checkAssestTimeOut);
          this.checkAssestTimeOut = null;
        }

        this.checkAssestTimeOut = setInterval(function () {
          _this5.checkAssestLoaded();
        }, 500); // if(customeName.indexOf('Common_Click') != -1){
        //     this._renderSpine.autoSetAni = true //防止spine预览加载不出来的情况
        // }else{
        //     this._renderSpine.autoSetAni = false
        // }
        // console.log('this._renderSpine.autoSetAni', this._renderSpine.autoSetAni)

        this._renderSpine.setAssets({
          dir: CocosMgr.rootHost,
          json: customeName + '.json',
          atlas: customeName + '.atlas'
        });
      }
    } else if (modal == '文本') {
      this.createObj();
      this.resetSizeConfig();
    } else if (modal == '空物体') {
      //空物体也要提前创建
      this.createObj();
    }
  } //部分动画切换皮肤可能直接就是修改了图片，所以需要重新修改预览
  ;

  _proto.updateSpinePreview = function updateSpinePreview(skin) {
    if (this._renderSpine != null) {
      this._renderSpine.setSkin(skin);

      this._renderSpine.genPreviewImg();
    }
  } //重置尺寸配置信息，只有在编辑模式下会触发
  ;

  _proto.resetSizeConfig = function resetSizeConfig() {
    var width = this.properties.width;
    var height = this.properties.height;

    if (this._image != null) {
      if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {
        width = this._image.width;
        height = this._image.height;
      }
    } else if (this._renderSpine != null) {
      if (this._renderSpine.canRender) {
        width = this._renderSpine.bounds.size.x;
        height = this._renderSpine.bounds.size.y;
      }
    } else if (this.properties.modal == '文本') {
      console.log('当前是否有text节点', this.codeNode);

      if (this.codeNode != null) {
        width = this.codeNode.width;
        height = this.codeNode.height;
      }
    }

    console.log('width', width, height);
    this.widthWidget.setValue(width, {
      e: null,
      node: this,
      canvas: null
    });
    this.heightWidget.setValue(height, {
      e: null,
      node: this,
      canvas: null
    });
    var nodeConfig = this.properties.nodeConfig;
    nodeConfig.width = width;
    nodeConfig.height = height;

    if (this.properties.modal != '文本') {
      //每次都重新创建物体
      this.createObj();
    } // this.nodeConfigWidget.setValue(nodeConfig, )

  };

  _proto.getPreviewImg = function getPreviewImg() {
    if (this._image != null) {
      if (this._image.complete == false) {
        //还没有完全加载完成
        return;
      }

      if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {} else {
        return;
      }

      return this._image.src;
    } else if (this._renderSpine != null) {
      if (this._renderSpine.canRender) {
        return this._renderSpine.getImgUrlOri();
      }
    }
  } //检查资源是否加载成功，之前放在node渲染时加载
  //如果不传ctx就仅仅判断是否加载成功
  ;

  _proto.checkAssestLoaded = function checkAssestLoaded(ctx) {
    var modal = this.properties.modal;

    if (modal == '图片') {
      if (this._image != null) {
        if (this._image.complete == false) {
          //还没有完全加载完成
          return;
        }

        if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {} else {
          //没有成功加载图片
          //可以绘制加载丢失的404警告
          if (ctx != null) {
            this.drawErrorTips(ctx);
          }

          return;
        }

        if (this._hasToggleAssestLoad == false) {
          this.resetSizeConfig();
          this._hasToggleAssestLoad = true;

          if (this.checkAssestTimeOut != null) {
            clearInterval(this.checkAssestTimeOut);
            this.checkAssestTimeOut = null;
          }
        }

        if (ctx != null) {
          var rect = this.drawAssestBox(ctx, this._image.width, this._image.height);
          ctx.drawImage(this._image, rect.x, rect.y, rect.width, rect.height);
        }
      }
    } else if (modal == 'spine') {
      //使用spineRender渲染节点
      if (this._renderSpine != null) {
        if (this._renderSpine.canRender) {
          if (ctx != null) {
            if (this._renderSpine.image != null && this._renderSpine.image.naturalWidth > 0 && this._renderSpine.image.naturalHeight > 0) {
              //根据连接的animate动画自动设置首选预览图
              var linkedNodes = this.getOutputNodes(0);

              if (linkedNodes != null) {
                linkedNodes = linkedNodes.filter(function (node) {
                  return node.type == 'objects/animates/animate' && node.properties.autoRun == true;
                });

                if (linkedNodes[0] != null) {
                  var firstAni = linkedNodes[0];
                  var skin = firstAni.properties.skin;
                  this.updateSpinePreview(skin);
                }
              }

              var rect = this.drawAssestBox(ctx, this._renderSpine.image.width, this._renderSpine.image.height);
              ctx.drawImage(this._renderSpine.image, rect.x, rect.y, rect.width, rect.height);
            }
          } // this._renderSpine.render(ctx, rect)


          if (this._hasToggleAssestLoad == false) {
            this.resetSizeConfig();
            this._hasToggleAssestLoad = true;

            if (this.checkAssestTimeOut != null) {
              clearInterval(this.checkAssestTimeOut);
              this.checkAssestTimeOut = null;
            }
          }
        } else {
          //判断是否加载出错
          if (ctx != null) {
            this.drawErrorTips(ctx);
          } // if(this._renderSpine.isLoadingComplete()){
          // }
          // if(this._renderSpine.isLoadIngError()){
          //     // console.log('调用了render spine')
          // }

        }
      }
    }
  };

  _proto.onDrawForeground = function onDrawForeground(ctx, lgCanvas, canvas) {
    // if (this.flags.collapsed) {
    //     return;
    // }
    this.checkAssestLoaded(ctx);
  };

  return createObject;
}(_BaseYwNode.BaseYWNode);

createObject.title = '物体';
createObject.showTypes = ['初始化时', '输入时'];

_litegraph.LiteGraph.registerNodeType("objects/createObject", createObject); //字幕组


var textGroup = /*#__PURE__*/function (_BaseYWNode2) {
  _inheritsLoose(textGroup, _BaseYWNode2);

  function textGroup() {
    var _this6;

    _this6 = _BaseYWNode2.call(this) || this;
    _this6.title = "字幕组";
    _this6.desc = "用于快速创建一个绘本中浮动的字幕";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT;

    _this6.addInput("物体", "codeNode"); // this.addInput("播放", LiteGraph.ACTION)
    // this.addInput("停止", LiteGraph.ACTION)


    _this6.addOutput("列表", 'array');

    _this6.addProperty('showInPageBottom', false, 'boolean');

    _this6.addWidget('toggle', '用作底部字幕', _this6.properties.showInPageBottom, 'showInPageBottom');

    _this6.addProperty('vertical', false, 'boolean');

    _this6.addWidget('toggle', '竖向文本', _this6.properties.vertical, 'vertical');

    _this6.addProperty('layout', '居左/下', 'enum');

    _this6.addWidget('combo', '排列', _this6.properties.layout, {
      property: "layout",
      values: textGroup.layoutEnum
    });

    _this6.addProperty('firstLineOffset', 0, 'number');

    _this6.addWidget('number', '首行缩进', _this6.properties.firstLineOffset, 'firstLineOffset', {
      precision: 0
    });

    _this6.addProperty('lineSpace', 0, 'number');

    _this6.addWidget('number', '行距', _this6.properties.lineSpace, 'lineSpace', {
      precision: 0
    });

    _this6.addProperty('fontSize', 45, 'number');

    _this6.addWidget('number', '字号', _this6.properties.fontSize, 'fontSize', {
      precision: 0
    });

    _this6.addProperty('color', '#000000', 'string');

    _this6.addWidget('string', '颜色', _this6.properties.color, 'color');

    _this6.addProperty('outLineWidth', 4, 'number');

    _this6.addWidget('slider', '描边宽度', _this6.properties.outLineWidth, 'outLineWidth', {
      precision: 0,
      min: 0,
      max: 100
    });

    _this6.addProperty('outLineColor', '#ffffff', 'string');

    _this6.addWidget('string', '描边颜色', _this6.properties.outLineColor, 'outLineColor');

    _this6.addProperty('hideBeforRun', false, 'boolean');

    _this6.addWidget('toggle', '运行前隐藏', _this6.properties.hideBeforRun, 'hideBeforRun');

    _this6.addProperty('hideAfterRun', false, 'boolean');

    _this6.addWidget('toggle', '运行结束隐藏', _this6.properties.hideAfterRun, 'hideAfterRun');

    _this6.addProperty('hideBaseLabel', false, 'boolean');

    _this6.addWidget('toggle', '隐藏底层文字', _this6.properties.hideBaseLabel, 'hideBaseLabel');

    _this6.addProperty('needColorAni', false, 'boolean');

    _this6.addWidget('toggle', '是否颜色过渡', _this6.properties.needColorAni, 'needColorAni');

    _this6.addProperty('maskColor', '#88BF3D', 'string');

    _this6.addWidget('string', '过渡颜色', _this6.properties.maskColor, 'maskColor'); // this.properties.linesNum = 0


    _this6.addProperty('linesNum', 0, 'number');

    _this6.addWidget('button', '添加一行', '', function () {
      _this6.addLine();
    });

    _this6.addWidget('button', '删除一行', '', function () {
      _this6.removeLine();
    }); // this.serialize_widgets = true


    return _this6;
  }

  var _proto2 = textGroup.prototype;

  _proto2.updateWidght = function updateWidght() {
    var value = this.properties.showInPageBottom;
    this.widgets.map(function (widget) {
      if (widget.name != '用作底部字幕') {
        widget.hidden = value;
      }
    });
    this.setSize(this.computeSize());
  } //从配置初始化时，自动创建widget
  ;

  _proto2.onConfigure = function onConfigure() {
    console.log('当前的配置信息', this.properties);

    for (var i = 0; i < this.properties.linesNum; i++) {
      var key = 'text' + (i + 1);
      this.addWidget('string', '文本', this.properties[key], key);
    }

    this.freshTexts();
  };

  _proto2.addLine = function addLine() {
    this.properties.linesNum += 1;
    var key = 'text' + this.properties.linesNum;
    this.addProperty(key, '', 'string');
    this.addWidget('string', '文本', '', key);
    this.freshTexts();
  };

  _proto2.removeLine = function removeLine() {
    if (this.properties.linesNum == 0) {
      return;
    }

    var key = 'text' + this.properties.linesNum;
    this.properties.linesNum -= 1;
    this.removeProperty(key);
    this.widgets.pop();
    this.setSize(this.computeSize());
    this.freshTexts();
  } //当条件修改
  ;

  _proto2.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      // console.warn('textGroup 当前没有物体')
      return;
    }

    if (codeNode.node == null) {
      // console.warn('textGroup 关联物体没有创建node')
      return;
    }

    if (property == 'showInPageBottom') {
      this.updateWidght();

      if (value == false) {
        this.freshTexts();
      } else {
        var codeNode = this.getInputData(0, true);

        if (codeNode != null) {
          codeNode.clearChildren();
        }
      }

      return;
    }

    if (property == 'layout') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var childCodeNode = codeNode.node.children[i].getComponent('CodeNodeLg');

        if (this.properties.vertical == true) {
          if (i == 0) {
            childCodeNode.y = this.properties.firstLineOffset;
          } else {
            childCodeNode.y = 0;
          }

          childCodeNode.anchorY = textGroup.anchorXDit[value];
          childCodeNode.anchorX = 0.5;
        } else {
          if (i == 0) {
            childCodeNode.x = this.properties.firstLineOffset;
          } else {
            childCodeNode.x = 0;
          }

          childCodeNode.anchorY = 0.5;
          childCodeNode.anchorX = textGroup.anchorXDit[value];
        }
      }
    } else if (property == 'vertical') {
      //垂直排列
      var layout = codeNode.checkAddComponent(cc.Layout);

      if (value == false) {
        layout.type = cc.Layout.Type.VERTICAL;
        layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
        layout.spacingY = this.properties.lineSpace;
        layout.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
      } else {
        layout.type = cc.Layout.Type.HORIZONTAL;
        layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
        layout.spacingX = this.properties.lineSpace;
        layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT;
      }

      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _childCodeNode = codeNode.node.children[i].getComponent('CodeNodeLg');

        _childCodeNode.overflow = value ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE;

        if (value == true) {
          if (i == 0) {
            _childCodeNode.y = this.properties.firstLineOffset;
          } else {
            _childCodeNode.y = 0;
          }
        } else {
          if (i == 0) {
            _childCodeNode.x = this.properties.firstLineOffset;
          } else {
            _childCodeNode.x = 0;
          }
        }

        if (value == false) {
          _childCodeNode.anchorX = textGroup.anchorXDit[this.properties.layout];
          _childCodeNode.anchorY = 0.5;
        } else {
          _childCodeNode.anchorX = 0.5;
          _childCodeNode.anchorY = textGroup.anchorXDit[this.properties.layout];
          _childCodeNode.width = this.properties.fontSize + 10;
        }
      } // anchorX: textGroup.anchorXDit[this.properties.layout],
      // overflow: this.properties.vertical ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE,
      // width: this.properties.fontSize + 10   

    } else if (property == 'lineSpace') {
      var _layout = codeNode.checkAddComponent(cc.Layout); // layout.type = cc.Layout.Type.VERTICAL
      // layout.resizeMode = cc.Layout.ResizeMode.CONTAINER


      if (this.properties.vertical) {
        _layout.spacingX = this.properties.lineSpace;
      } else {
        _layout.spacingY = this.properties.lineSpace;
      }
    } else if (property == 'firstLineOffset') {
      var child = codeNode.node.children[0];

      if (child != null) {
        if (this.properties.vertical) {
          child.getComponent('CodeNodeLg').y = this.properties.firstLineOffset;
        } else {
          child.getComponent('CodeNodeLg').x = this.properties.firstLineOffset;
        }
      }
    } else if (property == 'outLineColor') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child = codeNode.node.children[i];
        _child.getComponent('CodeNodeLg').outLineColor = this.properties.outLineColor;
      }
    } else if (property == 'outLineWidth') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child2 = codeNode.node.children[i];
        _child2.getComponent('CodeNodeLg').outLineWidth = this.properties.outLineWidth;
      }
    } else if (property == 'fontSize') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child3 = codeNode.node.children[i];
        _child3.getComponent('CodeNodeLg').fontSize = this.properties.fontSize;

        if (this.properties.vertical) {
          _child3.getComponent('CodeNodeLg').width = this.properties.fontSize + 10;
        }
      }
    } else if (property == 'color') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child4 = codeNode.node.children[i];
        _child4.getComponent('CodeNodeLg').color = this.properties.color;
      }
    } else {
      var childNode = codeNode.getChildByName(property);

      if (childNode != null) {
        childNode.getComponent('CodeNodeLg').string = value;
      }
    }
  } //根据当前配置刷新界面
  ;

  _proto2.freshTexts = function freshTexts(data) {
    var _this7 = this;

    var codeNode = this.getInputData(0, true);

    if (this.properties.showInPageBottom == true) {
      //只在绘本底部通用导航栏显示
      if (codeNode != null) {
        codeNode.clearChildren();
      }

      return;
    } // console.log('textGroup freshTexts', data,  codeNode)


    if (codeNode == null) {
      console.log('当前没有物体');

      if (CocosMgr.isInApp == false) {
        var linkNode = this.getRealLinkNode();

        if (linkNode == null) {
          console.log('当前没有关联节点');
          return;
        }

        codeNode = linkNode.codeNode;

        if (codeNode == null) {
          console.log('当前关联节点没有codeNode');
          return;
        }
      } else {
        return;
      }
    }

    var layout = codeNode.checkAddComponent(cc.Layout);

    if (this.properties.vertical == false) {
      layout.type = cc.Layout.Type.VERTICAL;
      layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      layout.spacingY = this.properties.lineSpace;
      layout.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
    } else {
      layout.type = cc.Layout.Type.HORIZONTAL;
      layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      layout.spacingX = this.properties.lineSpace;
      layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT;
    } // layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT


    codeNode.clearChildren();
    this.motionTextArr = []; // layout

    for (var i = 1; i <= this.properties.linesNum; i++) {
      var config = {
        parent: codeNode.node,
        modal: CocosMgr.ObjectTypeEnum.text,
        customeName: 'text' + i,
        string: this.properties['text' + i],
        outLineWidth: this.properties.outLineWidth,
        outLineColor: this.properties.outLineColor,
        fontSize: this.properties.fontSize,
        color: this.properties.color,
        // anchorX: textGroup.anchorXDit[this.properties.layout],
        overflow: this.properties.vertical ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE,
        width: this.properties.fontSize + 10 //只有竖向排列时生效

      };
      var node = CocosMgr.createObj(config);

      if (node != null && data != null) {
        console.log('生成字幕', this.properties.hideBeforRun, this.properties['text' + i], node.node._id, data);
        var motionText = node.checkAddComponent('MotionText');
        motionText.hideBeforRun = this.properties.hideBeforRun;
        motionText.hideAfterRun = this.properties.hideAfterRun;
        motionText.hideBaseLabel = this.properties.hideBaseLabel;
        motionText.dir = this.properties.vertical ? 1 : 0; // console.log('设置了motionText hideAfterRun', this.properties.hideAfterRun)

        motionText.maskColor = this.properties.maskColor;
        this.motionTextArr.push(motionText);
        var index = i - 1;

        if (data[index] != null) {
          motionText.position = data[index].position.map(function (value) {
            if (_this7.properties.needColorAni != true) {
              return 0;
            }

            return value * 0.01;
          }).join(',');
          motionText.positionTime = data[index].times.join(',');
          console.log('设置了motionText hideAfterRun', motionText.position, motionText.positionTime);
        }

        motionText.init();
      } //重新对齐一下


      this.onPropertyChanged('layout', this.properties.layout);
    }
  };

  _proto2.onAction = function onAction(name) {
    var _this8 = this;

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.log('当前没有物体');
      return;
    }

    console.log('textGroup onAction', name);

    if (name == '播放') {
      // for(var i = 0; i < codeNode.node.children.length; i++){
      //    let child = codeNode.node.children[i]
      //    child.getComponent('MotionText').
      // }
      var curIndex = 0;

      var run = function run() {
        var textArr = _this8.motionTextArr;

        if (textArr[curIndex] == null) {
          return;
        }

        var motionText = textArr[curIndex];
        console.log('textGroup 当前执行的motionText', curIndex, textArr[curIndex].node._id, motionText);

        if (motionText == null) {
          return;
        }

        motionText.dir = _this8.properties.vertical ? 1 : 0;
        motionText.inputHandle({
          data: 1
        });

        motionText.outputHandle = function () {
          curIndex += 1;

          if (textArr[curIndex] != null && textArr[curIndex].node.active == true) {
            run();
          } else {// this.scheduleOnce(()=>{
            //     //等待0.3秒再认为结束，因为开启录音会录制到没有说话的部分
            //     if(this.outputHandle != null){
            //         this.outputHandle('onend', 1)
            //     }
            // }, 0.3)
          }
        };
      };

      run();
    } else if (name == '停止') {
      var textArr = this.motionTextArr;

      for (var i = 0; i < textArr.length; i++) {
        var motionText = textArr[i];

        if (motionText != null) {
          motionText.inputHandle({
            data: 0
          });
        }
      }
    }
  };

  return textGroup;
}(_BaseYwNode.BaseYWNode);

textGroup.layoutEnum = ['居左/下', '居中', '居右/上'];
textGroup.anchorXDit = {
  '居左/下': 0,
  '居中': 0.5,
  '居右/上': 1
};
textGroup.title = '字幕组';

_litegraph.LiteGraph.registerNodeType("objects/textGroup", textGroup);

var animate = /*#__PURE__*/function (_BaseYWNode3) {
  _inheritsLoose(animate, _BaseYWNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function animate() {
    var _this9;

    _this9 = _BaseYWNode3.call(this) || this; // this.serialize_widgets = true

    _this9.title = "骨骼动画";
    _this9.desc = "用于控制动画播放";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this9.addInput("物体", "codeNode");

    _this9.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this9.addOutput("结束", _litegraph.LiteGraph.EVENT);

    _this9.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this9._skins = [];
    _this9._animations = [];

    _this9.addProperty('modal', '全设置', 'enum');

    _this9.addWidget('combo', '更新模式', _this9.properties.modal, {
      property: "modal",
      values: animate.modalEnum
    });

    _this9.addProperty('skin', '', 'enum');

    _this9.addWidget('combo', '选择皮肤', _this9.properties.skin, {
      property: "skin",
      values: _this9._skins
    });

    _this9.addProperty('playAniName', '', 'enum');

    _this9.addWidget('combo', '选择动画', _this9.properties.playAniName, {
      property: "playAniName",
      values: _this9._animations
    }); // this.addWidget('button','刷新皮肤和动画选项', "", ()=>{
    //     this.getEnums()
    // })


    _this9.addProperty('loop', false, 'boolean');

    _this9.addWidget('toggle', '是否循环', _this9.properties.loop, 'loop');

    _this9.addProperty('timeScale', 1, 'number');

    _this9.addWidget('slider', '播放速率', _this9.properties.timeScale, 'timeScale', {
      precision: 1,
      min: 0,
      max: 10
    });

    _this9.addProperty('autoRun', false, 'boolean');

    _this9.addWidget('toggle', '是否自动播放', _this9.properties.autoRun, 'autoRun');

    _this9.addProperty('clickWait', false, 'boolean');

    _this9.addWidget('toggle', '点击等待动画结束', _this9.properties.clickWait, 'clickWait');

    _this9.addProperty('softChange', false, 'boolean');

    _this9.addWidget('toggle', '柔和过度', _this9.properties.softChange, 'softChange');

    _this9.addProperty('cancelEvent', false, 'boolean');

    _this9.addWidget('toggle', '取消其他触摸事件', _this9.properties.cancelEvent, 'cancelEvent');

    _this9.addProperty('aniEndCanClick', false, 'boolean');

    _this9.addWidget('toggle', '动画结束后响应点击', _this9.properties.aniEndCanClick, 'aniEndCanClick');

    _this9.addProperty('toggleCount', 1, 'number');

    _this9.addWidget('number', '结束触发次数', _this9.properties.toggleCount, 'toggleCount', {
      precision: 0,
      min: 0
    });

    _this9.addProperty('aniClickReplay', false, 'boolean');

    _this9.addWidget('toggle', '点击重播动画', _this9.properties.aniClickReplay, 'aniClickReplay');

    _this9.addProperty('aniClickTimeSpace', 0, 'number');

    _this9.addWidget('number', '点击时间间隔', _this9.properties.aniClickTimeSpace, 'aniClickTimeSpace');

    _this9.addProperty('canClickOutLine', false, 'boolean');

    _this9.addWidget('toggle', '可点击时显示描边', _this9.properties.canClickOutLine, 'canClickOutLine');

    _this9.addProperty('isCanClick', true, 'boolean');

    var canClickWidget = _this9.addWidget('toggle', '是否可点击', _this9.properties.isCanClick, 'isCanClick');

    var linkSolt = _this9.addInput("触摸提示", "lgraphNode");

    _this9.addProperty('linkClickTip', '', 'string'); //保存一个节点id就行


    var linkTipsWidget = _this9.addWidget('linknode', '添加触摸提示', _this9.properties.linkClickTip, function () {
      _this9.oneClickCreateTouchTip();
    });

    _this9.addProperty('tipsJustOnce', true, 'boolean');

    _this9.addWidget('toggle', '触摸提示只出现一次', _this9.properties.tipsJustOnce, 'tipsJustOnce');

    linkSolt.widget = linkTipsWidget; // linkSolt.pos = [5, 100]
    // console.log("linkSolt.pos", linkSolt.pos)

    _this9.createCaidanBtn = _this9.addWidget('button', '创建点击彩蛋交互', "", function () {
      // this.syncTargetValue()
      _this9.createClickToNextAni();
    });
    _this9.createCaidanBtn.disabled = true;

    _this9.addWidget('button', '预览动画', "", function () {
      _this9.previewAni();

      _this9.sendBtnWidgetClickEvent('预览动画');
    });

    _this9.addProperty('listenAniEvent', true, 'boolean');

    var linkSoundSolt = _this9.addInput("关联音频", "lgraphNode");

    var linkSountWidget = _this9.addWidget('toggle', '关联动画音频', _this9.properties.listenAniEvent, 'listenAniEvent');

    linkSoundSolt.widget = linkSountWidget;

    var isCanClickInput = _this9.addInput('isCanClick', 'boolean');

    isCanClickInput.widget = canClickWidget;

    _this9.addProperty('soundFx', '无', 'enum');

    _this9.addWidget('combo', '音效', _this9.properties.soundFx, {
      property: "soundFx",
      values: soundFxs
    }); //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    //将此动画存在的音频事件也显示出来
    // this.addWidget('button','', "", (btnWidget)=>{
    //     // if(btnWidget.clickeName == '删除控制点'){
    //     // }else if(btnWidget.clickeName == '添加控制点'){
    //     // }
    // }, {buttons: ['事件1', '事件2']})
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto3 = animate.prototype;

  _proto3.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    // console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
    if (outPutType == 'codeNode') {
      if (linkedNode._renderSpine != null) {
        var _this$_skins, _this$_animations;

        (_this$_skins = this._skins).splice.apply(_this$_skins, [0, this._skins.length].concat(linkedNode._renderSpine.skins()));

        (_this$_animations = this._animations).splice.apply(_this$_animations, [0, this._animations.length].concat(linkedNode._renderSpine.animations()));
      }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto3.onSelected = function onSelected() {
    this.getEnums();
    this.onAction('播放');
    this.sendOtherEvent('onSelected');
  };

  _proto3.onDeselected = function onDeselected() {
    this.onAction('停止');
    this.sendOtherEvent('onDeselected');
  } //当所有创建物体初始化完成后触发
  ;

  _proto3.onStart = function onStart() {
    _BaseYWNode3.prototype.onStart.call(this);

    console.log('animate onStart', this.properties.autoRun);
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }
  };

  _proto3.onStop = function onStop() {
    this.onAction('停止');
  } // onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex){
  //     console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
  //     if(outPutType == 'codeNode'){
  //     }
  //     this.sendConnectEvent(inputIndex, linkedNode, outputIndex)
  // }
  ;

  _proto3.getEnums = function getEnums(autoSetLoop) {
    var linkedNode = this.getRealLinkNode();

    if (linkedNode == null) {
      return;
    }

    if (linkedNode._renderSpine != null) {
      var _this$_skins2, _this$_animations2;

      var eventDit = linkedNode._renderSpine.events(); // console.log('skeletonData events', eventDit)


      (_this$_skins2 = this._skins).splice.apply(_this$_skins2, [0, this._skins.length].concat(linkedNode._renderSpine.skins()));

      (_this$_animations2 = this._animations).splice.apply(_this$_animations2, [0, this._animations.length].concat(linkedNode._renderSpine.animations())); //如果只有一个选项，直接设置默认值


      if (this._skins.length == 1) {
        this.setProperty('skin', this._skins[0]);
      } else {
        //为适配旧版本动画，如果当前设置的playAniName是数值，查询可用的动画名称并设置
        if (Number(this.properties.skin) >= 0) {
          var realSkin = this._skins[Number(this.properties.skin)]; // console.log('我获取到了skin', realSkin, this._skins)


          if (realSkin != null) {
            this.setProperty('skin', realSkin);
          }
        }
      }

      if (this._animations.length == 1) {
        this.setProperty('playAniName', this._animations[0]);

        if (autoSetLoop == true) {
          this.setProperty('loop', true);
          this.setProperty('autoRun', true);
          this.collapse();
        }

        this.createCaidanBtn.disabled = true;
      } else {
        //为适配旧版本动画，如果当前设置的playAniName是数值，查询可用的动画名称并设置
        if (Number(this.properties.playAniName) >= 0) {
          var realAni = this._animations[Number(this.properties.playAniName)];

          if (realAni != null) {
            this.setProperty('playAniName', realAni);
          } else {
            console.log("我还是没有找到自己的动画", linkedNode.properties.customeName, this.properties.playAniName, this._animations);
          }
        }

        this.createCaidanBtn.disabled = false;
      }

      console.log('skeletonData eventssss', eventDit[this.properties.playAniName]);

      for (var _i = 0; _i < this.widgets.length; _i++) {
        if (this.widgets[_i].name.indexOf("音频") == 0) {
          this.widgets.splice(_i, 1);
          _i--;
        }
      }

      if (eventDit[this.properties.playAniName] != null) {
        var events = eventDit[this.properties.playAniName]; // console.log('')
        //添加button来显示事件
        // this.widgets.findIndex((item)=>{
        //     return item.name == 
        // })

        for (var i = 0; i < events.length; i++) {
          this.addWidget('button', '音频：' + events[i].name, "");
        }
      }
    }
  } //创建一个过渡到下一个动画的节点
  ;

  _proto3.createClickToNextAni = function createClickToNextAni() {
    var aniNode = _litegraph.LiteGraph.createNode("objects/animates/animate");

    aniNode.pos = [this.pos[0] + this.width + 3, this.pos[1]];
    this.graph.add(aniNode);
    this.connect(1, aniNode, 1);
    aniNode.connect(0, this, 1);
    aniNode.setProperty('skin', this.properties.skin);
    this.setProperty('playAniName', 'std');
    this.setProperty('loop', true);
    this.setProperty('autoRun', true);

    var curIndex = this._animations.indexOf(this.properties.playAniName);

    curIndex += 1;

    if (this._animations[curIndex] == null) {
      curIndex = 0;
    }

    var newAniName = this._animations[curIndex];
    aniNode.setProperty('playAniName', newAniName);
    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    target.connect(0, aniNode, 0);
  };

  _proto3.previewAni = function previewAni() {
    if (this.graph == null) {
      return;
    }

    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    if (this.properties.playAniName == '') {
      return;
    }

    if (target.codeNode != null) {
      target.codeNode.playAnimation(this.properties.playAniName, this.properties.loop);
    }
  };

  _proto3.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (this.graph == null) {
      return;
    }

    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    } // console.log('curLink', curLink, target)


    if (property == 'skin') {
      if (target.updateSpinePreview != null) {
        target.updateSpinePreview(value);
      }

      if (target.codeNode != null) {
        console.log('修改了皮肤', value);
        target.codeNode.setSkin(value); // 需要通知物体重新获取动画预览
        // target.codeNode.playAnimation(value)
      }
    } else if (property == 'playAniName') {
      //动画还是直接播放cocos渲染的，在蓝图中播放太奇怪了
      if (target.codeNode != null) {
        target.codeNode.playAnimation(value, this.properties.loop);
      }
    } else if (property == 'loop') {
      if (target.codeNode != null) {
        target.codeNode.playAnimation(this.properties.playAniName, value);
      }
    } else if (property == 'timeScale') {
      if (target.codeNode != null) {
        target.codeNode.setAnimationProb('timeScale', value);
      }
    } else if (property == 'canClickOutLine') {// if(target.codeNode != null){
      //     target.codeNode.setOutLine(value)
      // }
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } //当扩展切换
  ;

  _proto3.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {// console.log('onWidgetChanged', name, value, oldValue, widget)
  } //动态返回卡片显示的title
  ;

  _proto3.getTitle = function getTitle() {
    return this.title + ' ' + this.properties.skin + '-' + this.properties.playAniName;
  };

  //暂不清楚用处
  _proto3.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto3.onAction = function onAction(action, param) {
    var _this10 = this;

    // console.log("action", action, param)
    if (action == '播放') {
      this.mode = _litegraph.LiteGraph.ALWAYS;
      var codeNode = this.getInputData(0, true);

      if (codeNode != null) {
        //播放动画关联的声音
        this.playLinkSound(); //播放动画关联的音效

        if (this.properties.soundFx != '无' && this.properties.soundFx != '') {
          cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + this.properties.soundFx, function (err, clip) {
            if (err == null) {
              cc.audioEngine.play(clip, false, 1);
            }
          });
        }

        var modal = this.properties.modal;
        var loop = this.properties.loop;
        var softChange = this.properties.softChange;
        var aniEndCanClick = this.properties.aniEndCanClick;
        var clickWait = this.properties.clickWait;
        this.waitCanClick = false;
        this.hideClickTip();

        if (modal == '全设置' || modal == '仅设置皮肤') {
          codeNode.setSkin(this.properties.skin);
        }

        this._toggleCount = 0;

        if (modal == '全设置' || modal == '仅设置动画') {
          if (this.properties.cancelEvent == true) {
            codeNode.targetOff();
          }

          this.clickWaitOutPut = false;
          this.aniEnd = false;
          codeNode.setAnimationProb('timeScale', this.properties.timeScale);
          codeNode.playAnimation(this.properties.playAniName, loop, softChange, function (trackEntry, event) {
            console.log('我收到spine音频事件', event.data.name, event.intValue, _this10.properties.listenAniEvent, _this10.isInputConnected(3), _this10.graph.status);

            if (_this10.properties.listenAniEvent == false) {
              return;
            }

            if (_this10.isInputConnected(3) == true) {
              //当前已经关联了蓝图中的音频播放
              return;
            } // if(event.intValue < 0){
            //     return
            // }


            if (_this10.graph.status != 2) {
              //STATUS_RUNNING
              //当前没有在运行中
              return;
            } // console.log("这里应该播放spine事件声音:", event.data.name, codeNode.node.name + ':' + trackEntry.animation.name)
            //查找是否有音频节点的资源名称为 event.data.name，如果有就可以直接播放音频了
            //this.codeProgress.playSound(event.data.name ,spineCom.node.name + ':' + trackEntry.animation.name)


            var sounds = _this10.graph.findNodesByType('output/sound');

            var soundName = '';

            if (event.data) {
              soundName = event.data.name;
            }

            var soundNode = sounds.find(function (item) {
              return item.properties.customeName.split('.')[0] == soundName;
            }); // console.log("找到了", sounds, soundNode)

            if (soundNode != null) {
              soundNode.onAction('播放');
            } else {
              if (CocosMgr.isInApp == false) {
                CocosMgr.showAlert(codeNode.node.name + ':' + trackEntry.animation.name + '动画没有相应音频节点:' + soundName);
              } else {
                console.warn('没有对应的音频事件');
              }
            }
          }, function () {
            _this10._toggleCount += 1;

            if (_this10._toggleCount <= _this10.properties.toggleCount) {
              _this10.triggerSlot(0);
            }

            if (_this10.aniEnd != true) {
              if (_this10.isOutputConnected(1) || _this10.properties.aniClickReplay) {
                if (aniEndCanClick == true) {
                  if (_this10.getInputOrProperty('isCanClick') == true) {
                    _this10.showClickTip();
                  } else {
                    if (_this10.hasLinkIsCanClick() == true) {
                      _this10.waitCanClick = true;
                    }
                  }
                }
              }
            }

            _this10.aniEnd = true;

            if (_this10.clickWaitOutPut == true) {
              _this10.triggerSlot(1, codeNode);
            }
          }); // console.log("当前是否需要显示触摸提示",aniEndCanClick, this.isOutputConnected(1) , this.properties.aniClickReplay )

          if (this.isOutputConnected(1) || this.properties.aniClickReplay) {
            //监听点击事件
            codeNode.checkAddComponent('SpinePlusComponent');

            if (aniEndCanClick == false) {
              //如果等于true时是结束才显示
              //看看是否需要显示提示点击
              console.log(this.getRealLinkNode().properties.customeName, '当前是否需要等待显示点击', this.getInputOrProperty('isCanClick'), this.hasLinkIsCanClick());

              if (this.getInputOrProperty('isCanClick') == true) {
                this.showClickTip();
              } else {
                if (this.hasLinkIsCanClick() == true) {
                  this.waitCanClick = true;
                }
              }
            } //一进来就要开始等待时间才能点击
            // if(this.properties.aniClickTimeSpace > 0){
            //     this.curWaitTime = this.properties.aniClickTimeSpace
            // }


            codeNode.on(cc.Node.EventType.TOUCH_END, this.onClick.bind(this));
          }
        }
      } else {
        console.warn('当前没有关联codeNode');
      }
    } else if (action = '停止') {
      this.mode = _litegraph.LiteGraph.ON_EVENT;
      var codeNode = this.getInputData(0, true);
      this.waitCanClick = false;

      if (codeNode != null) {
        codeNode.pauseAnimation();
      }
    } //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //点击事件拎出来，方便记录调用
  ;

  _proto3.onClick = function onClick() {
    if (CocosMgr.isInApp == false) {
      if (window.onGraphNodeClick != null) {
        window.onGraphNodeClick({
          nodeId: this.getIdWithGraph(),
          time: this.graph.getTime(),
          funcName: 'onClick'
        });
      }
    }

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('点击的时候codeNode为空了');
      return;
    }

    if (this.graph.config.pause == 1) {
      return;
    }

    if (this.properties.aniEndCanClick == false) {//直接可以点击
    } else {
      //等待动画结束了才能点击
      if (this.aniEnd != true) {
        console.log('点击了但动画没有播放结束');
        return;
      }
    }

    var isCanClick = this.getInputOrProperty('isCanClick'); // console.log(this, "isCanClick", isCanClick, this.properties.aniClickTimeSpace, this.properties.aniClickReplay)

    if (isCanClick != true) {
      //可能为空所以不为true就不响应点击
      return;
    }

    if (this.curWaitTime != null) {
      //当前在等待点击
      console.log('当前需等待点击间隔', this.curWaitTime);
      return;
    }

    if (this.properties.aniClickTimeSpace > 0) {
      this.curWaitTime = this.properties.aniClickTimeSpace;
    }

    codeNode.targetOff();

    if (this.properties.clickWait == true) {
      this.clickWaitOutPut = true;
    } else {
      this.triggerSlot(1, codeNode);
      this.hideClickTip();
    }

    if (this.properties.aniClickReplay == true) {
      this.onAction('播放');
    }
  };

  _proto3.onExecute = function onExecute() {
    if (this.curWaitTime != null) {
      var dt = this.graph.elapsed_time; //in ms
      // console.log('dt', dt)

      this.curWaitTime -= dt;

      if (this.curWaitTime <= 0) {
        // console.log('延迟结束播放了声音', this.curWaitTime)
        this.curWaitTime = null;
      }
    } //等待进入可点击状态再显示触摸提示


    if (this.waitCanClick == true) {
      var isCanClick = this.getInputOrProperty('isCanClick'); // console.log(this, "isCanClick", isCanClick, this.properties.aniClickTimeSpace, this.properties.aniClickReplay)

      if (isCanClick == true) {
        //可能为空所以不为true就不响应点击
        this.showClickTip();
        this.waitCanClick = false;
      }
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return animate;
}(_BaseYwNode.BaseYWNode);

animate.title = '骨骼动画';
animate.modalEnum = ['全设置', '仅设置皮肤', '仅设置动画'];

_litegraph.LiteGraph.registerNodeType("objects/animates/animate", animate); //现在的动画编辑起来还是太复杂，下一步新增记录模式，直接记录object修改的属性并切换


var tween = /*#__PURE__*/function (_BaseYWNode4) {
  _inheritsLoose(tween, _BaseYWNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function tween() {
    var _this11;

    _this11 = _BaseYWNode4.call(this) || this;
    _this11.title = "数值动画";
    _this11.desc = "用于控制节点属性变化";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.serialize_widgets = true
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this11.addInput("物体", "codeNode");

    _this11.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this11.addOutput("结束", _litegraph.LiteGraph.EVENT);

    _this11.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this11.addProperty('duration', 1, 'number');

    _this11.addWidget('number', '动画时长', _this11.properties.duration, 'duration', {
      precision: 1,
      min: 0,
      max: 60
    });

    _this11.addProperty('delay', 0, 'number');

    _this11.addWidget('number', '延迟播放时间', _this11.properties.delay, 'delay', {
      precision: 1,
      min: 0,
      max: 60
    });

    _this11.addProperty('easing', '无', 'enum');

    _this11.addWidget('combo', '缓动效果', _this11.properties.easing, {
      property: "easing",
      values: tween.easingEnum
    });

    _this11.addProperty('tweenMode', '变化目标值', 'enum');

    _this11.addWidget('combo', '动画模式', _this11.properties.tweenMode, {
      property: "tweenMode",
      values: tween.tweenModeEnum
    });

    _this11.addProperty('dontTween', false, 'boolean');

    _this11.addWidget('toggle', '无动画直接修改值', _this11.properties.dontTween, 'dontTween');

    _this11.addProperty('cancelEvent', false, 'boolean');

    _this11.addWidget('toggle', '取消其他触摸事件', _this11.properties.cancelEvent, 'cancelEvent');

    _this11.addProperty('cancelOtherTween', false, 'boolean');

    _this11.addWidget('toggle', '打断其它数值动画', _this11.properties.cancelOtherTween, 'cancelOtherTween');

    _this11.addProperty('autoRun', false, 'boolean');

    _this11.addWidget('toggle', '是否自动播放', _this11.properties.autoRun, 'autoRun');

    _this11.addProperty('x', 0, 'number');

    _this11.addWidget('number', '坐标-x', _this11.properties.x, 'x', {
      precision: 1
    });

    _this11.addProperty('y', 0, 'number');

    _this11.addWidget('number', '坐标-y', _this11.properties.y, 'y', {
      precision: 1
    });

    _this11.addProperty('scaleX', 1, 'number');

    _this11.scaleXWidget = _this11.addWidget('number', '缩放-x', _this11.properties.scaleX, 'scaleX', {
      precision: 1
    });

    _this11.addProperty('scaleY', 1, 'number');

    _this11.scaleYWidget = _this11.addWidget('number', '缩放-y', _this11.properties.scaleY, 'scaleY', {
      precision: 1
    });

    _this11.addProperty('opacity', 255, 'number');

    _this11.addWidget('number', '透明度', _this11.properties.opacity, 'opacity', {
      precision: 0,
      min: -255,
      max: 255
    });

    _this11.addProperty('angle', 0, 'number');

    _this11.addWidget('number', '角度', _this11.properties.angle, 'angle', {
      min: -360,
      max: 360,
      precision: 0
    });

    _this11.addProperty('anchorX', 0.5, 'number');

    _this11.addWidget('number', '锚点x', _this11.properties.anchorX, 'anchorX', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this11.addProperty('anchorY', 0.5, 'number');

    _this11.addWidget('number', '锚点y', _this11.properties.anchorY, 'anchorY', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this11.addProperty('width', 50, 'number');

    _this11.widthWidget = _this11.addWidget('number', '宽度', _this11.properties.width, 'width', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this11.addProperty('height', 50, 'number');

    _this11.heightWidget = _this11.addWidget('number', '高度', _this11.properties.height, 'height', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this11.addProperty('color', '#ffffff', 'string');

    _this11.addWidget('string', '物体颜色', _this11.properties.color, 'color');

    _this11.addProperty("zoomRatio", 1, 'number');

    _this11.addWidget("number", "镜头缩放", _this11.properties.zoomRatio, "zoomRatio", {
      precision: 1,
      min: 1,
      max: 10,
      step2: 0.01
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    //节点配置


    _this11.addProperty('nodeConfig', {
      x: _this11.properties.x,
      y: _this11.properties.y,
      width: _this11.properties.width,
      height: _this11.properties.height,
      anchorX: _this11.properties.anchorX,
      anchorY: _this11.properties.anchorY,
      scaleX: _this11.properties.scaleX,
      scaleY: _this11.properties.scaleY,
      color: _this11.properties.color,
      angle: _this11.properties.angle
    }, 'object');

    _this11.nodeConfigWidget = _this11.addWidget('ccnode', '节点操控', _this11.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    });

    _this11.addWidget('button', '同步目标物体属性', "", function () {
      // this.getEnums()
      _this11.syncTargetValue();

      _this11.sendBtnWidgetClickEvent('同步目标物体属性');
    });

    _this11.addWidget('button', '重置变化多少值', "", function () {
      // this.getEnums()
      _this11.setProperty('x', 0);

      _this11.setProperty('y', 0);

      _this11.setProperty('width', 0);

      _this11.setProperty('height', 0);

      _this11.setProperty('anchorX', 0);

      _this11.setProperty('anchorY', 0);

      _this11.setProperty('scaleX', 0);

      _this11.setProperty('scaleY', 0);

      _this11.setProperty('opacity', 0);

      _this11.setProperty('color', '#000000');

      _this11.setProperty('angle', 0);

      _this11.setProperty('zoomRatio', 0);
    });

    _this11.addWidget('button', '预览动画', "", function () {
      if (_this11.previewTween != null) {
        _this11.syncTargetValue(_this11.previewTween);

        _this11.realRun(_this11.previewTween, '播放');
      }
    }); //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this11;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto4 = tween.prototype;

  _proto4.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    var _this12 = this;

    console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex);

    if (outPutType == 'codeNode') {
      // if(linkedNode._renderSpine != null){
      //     this._skins.splice(0, this._skins.length, ...linkedNode._renderSpine.skins())
      //     this._animations.splice(0, this._animations.length, ...linkedNode._renderSpine.animations())
      // }
      if (linkedNode.type == 'objects/camera') {
        if (linkedNode.codeNode != null) {
          setTimeout(function () {
            _this12.syncTargetValue();
          }, 100);
        }
      }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto4.onSelected = function onSelected() {
    // this.getEnums()
    if (this.previewTween == null) {
      var target = this.getRealLinkNode();

      if (target == null) {
        return;
      }

      if (target.codeNode != null && cc.isValid(target.codeNode.node)) {
        // console.log('target.codeNode', target.codeNode)
        var previewNode = cc.instantiate(target.codeNode.node);
        previewNode.isClone = true;
        previewNode.zIndex = 9999;
        this.previewTween = previewNode.getComponent('CodeNodeLg');

        if (this.previewTween != null) {
          this.previewTween.init();
          this.previewTween.parent = target.codeNode.parent;
          this.previewTween.nodeName += '_preview';
          CocosMgr.syncConfigToCodeNode(this.previewTween, this.properties.nodeConfig);
          this.previewTween.updatePreview();
        } else {
          console.warn('获取到了无效节点', previewNode);
        }
      }
    }

    this.sendOtherEvent('onSelected');
  };

  _proto4.onDeselected = function onDeselected() {
    if (this.previewTween != null) {
      this.previewTween.destroyNode();
      this.previewTween = null;
    }
  } //当所有创建物体初始化完成后触发
  ;

  _proto4.onStart = function onStart() {
    console.log('animate onStart', this.properties.autoRun);
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }

    _BaseYWNode4.prototype.onStart.call(this);
  };

  _proto4.onStop = function onStop() {
    this.onAction('停止');
  } //当扩展切换
  // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     // var curLink = this.getInputLink(0)
  //     // if(curLink == null){
  //     //     return
  //     // }
  //     // var target = this.graph.getNodeById(curLink.origin_id)
  //     // if(target == null){
  //     //     return
  //     // }
  //     // // console.log('curLink', curLink, target)
  //     // if(name == '选择皮肤'){
  //     // }
  // }
  //全部放置在canvas下
  //在子蓝图中无法获取到连接的物体，需要多一层查找
  // getRealLinkNode(){
  //     var curLink = this.getInputLink(0)
  //     if(curLink == null){
  //         return null   
  //     }
  //     if(this.graph._is_subgraph == true){
  //         let inputNode = this.graph.getNodeById(curLink.origin_id)
  //         let inputIndex = this.graph._subgraph_node.inputs.findIndex((solt)=>{
  //         return solt.name == inputNode.properties.name
  //         })
  //     //    console.log('getRealLinkNode', inputIndex, inputNode.properties.name, this.graph._subgraph_node.inputs)
  //         if(inputIndex != -1){
  //         let exLink = this.graph._subgraph_node.getInputLink(inputIndex)
  //         if(exLink == null){
  //             return null
  //         }
  //         return this.graph._subgraph_node.graph.getNodeById(exLink.origin_id)
  //         }
  //     }else{
  //         return this.graph.getNodeById(curLink.origin_id)
  //     }
  // }
  // 获取id，如果当前是在子图下，加上子图节点的id
  // getIdWithGraph(){
  //     if(this.graph == null){
  //     return this.id
  //     }
  //     if(this.graph._subgraph_node != null){
  //     return this.id + '_' + this.graph._subgraph_node.id
  //     }
  //     return this.id
  // }
  ;

  _proto4.syncTargetValue = function syncTargetValue(codeNode) {
    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    if (target.widgets) {
      // console.log('syncTargetValue',target.widgets)
      for (var i = 0; i < target.widgets.length; i++) {
        var targetWidget = target.widgets[i];

        if (targetWidget.type == 'ccnode') {
          for (var key in targetWidget.value) {
            var _index = this.widgets.findIndex(function (w) {
              return w.options.property == key;
            });

            if (_index != -1) {
              if (codeNode != null) {
                codeNode[this.widgets[_index].options.property] = targetWidget.value[key];
              } else {
                this.widgets[_index].setValue(targetWidget.value[key], {
                  e: null,
                  node: this,
                  canvas: null
                });
              }
            }
          }

          continue;
        }

        var index = this.widgets.findIndex(function (w) {
          return w.name == targetWidget.name;
        });

        if (index != -1) {
          if (codeNode != null) {
            codeNode[this.widgets[index].options.property] = targetWidget.value;
          } else {
            this.widgets[index].setValue(targetWidget.value, {
              e: null,
              node: this,
              canvas: null
            });
          }
        }
      }
    }
  };

  _proto4.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }

        if (property == 'zoomRatio' && value != 0) {
          if (this.nodeConfigWidget.value['scaleX'] != null) {
            this.nodeConfigWidget.value['scaleX'] = 1 / value;
            this.properties.nodeConfig['scaleX'] = 1 / value;
            this.nodeConfigWidget.value['scaleY'] = 1 / value;
            this.properties.nodeConfig['scaleY'] = 1 / value;
          }

          this.scaleXWidget.value = 1 / value;
          this.scaleYWidget.value = 1 / value;
          this.properties.scaleX = 1 / value;
          this.properties.scaleY = 1 / value;
        }
      }
    }

    if (this.previewTween != null) {
      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.previewTween, config);
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  _proto4.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {// var property = widget.options.property
    // console.log('onWidgetChanged', name, value, oldValue, property)
    // if(property != 'nodeConfig'){
    //     //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
    //     if(typeof this.nodeConfigWidget.value == 'object'){
    //         if(this.nodeConfigWidget.value[property] != null){
    //             this.nodeConfigWidget.value[property] = value
    //             this.properties.nodeConfig[property] = value
    //             // console.log('修改了nodeCondig的颜色值', this.nodeConfigWidget.value)
    //         }
    //         if(property == 'zoomRatio'){
    //             if(this.nodeConfigWidget.value['scaleX'] != null){
    //                 this.nodeConfigWidget.value['scaleX'] = 1 /  value
    //                 this.properties.nodeConfig['scaleX'] = 1 / value
    //                 this.nodeConfigWidget.value['scaleY'] = 1 /  value
    //                 this.properties.nodeConfig['scaleY'] = 1 /  value
    //             }
    //             this.scaleXWidget.value = 1 /  value
    //             this.scaleYWidget.value = 1 /  value
    //             this.properties.scaleX = 1 /  value
    //             this.properties.scaleY = 1 /  value
    //         }
    //     }
    // }
    // console.log('onWidgetChanged', name, value, oldValue, widget)
    // if(this.previewTween != null){
    //     var config = {}
    //     if(property == 'nodeConfig'){
    //         config = {...value}
    //     }else{
    //         config[property] = this.properties[property]
    //     }
    //     // console.log('更新节点配置', config, value)
    //     CocosMgr.syncConfigToCodeNode(this.previewTween, config)
    // }
  } //动态返回卡片显示的title
  // getTitle() {
  //    return this.title
  // };
  //暂不清楚用处
  ;

  _proto4.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto4.realRun = function realRun(codeNode) {
    var _this13 = this;

    var delay = this.properties.delay;
    var duration = this.properties.duration;
    var easing = this.properties.easing;
    var dontTween = this.properties.dontTween;
    var cancelOtherTween = this.properties.cancelOtherTween;
    var cancelEvent = this.properties.cancelEvent;
    var tweenMode = this.properties.tweenMode;

    var props = _extends({}, this.properties.nodeConfig); // console.log('当前的颜色值', props.color)


    var color = cc.Color.WHITE.fromHEX(props.color);
    props.r = color.getR();
    props.g = color.getG();
    props.b = color.getB();
    props.opacity = this.properties.opacity;
    delete props['color']; // let props = {x:this.properties.x, y: this.properties.y}
    //构建缓动模式

    if (easing != '无') {
      var index = tween.easingEnum.indexOf(easing);

      if (index != -1) {
        easing = {
          easing: tween.easingConfig[index]
        };
      } else {
        easing = {};
      }
    } else {
      easing = {};
    }

    this.aniEnd = false;
    this.inRun = true;

    if (cancelOtherTween == true) {
      cc.Tween.stopAllByTarget(codeNode);
      cc.Tween.stopAllByTarget(codeNode.node); //有的脚本组件是直接控制node的动画的，也要取消掉
    }

    if (cancelEvent == true) {
      codeNode.targetOff();
    }

    if (dontTween == true) {
      this.aniEnd = true;
      this.inRun = false;
      CocosMgr.syncConfigToCodeNode(codeNode, props);
    } else {
      console.log('开始播放动画', duration, JSON.parse(JSON.stringify(props)), easing);
      this.tweenTag = 'tween_' + this.getIdWithGraph();
      console.log('当前graphid tweenTag', this.graph.id, this.tweenTag);
      cc.Tween.stopAllByTag(this.tweenTag);

      if (codeNode.camera != null) {
        props['zoomRatio'] = this.properties.zoomRatio;
      }

      if (tweenMode == '变化目标值') {
        //变化到目标值，剔除不需要改变的属性
        console.log('目标值');
        CocosMgr.xorConfig(codeNode, props);
        console.log('剔除掉之后的值', props);
        this.tween = cc.tween(codeNode).tag(this.tweenTag).delay(delay).to(duration, props, easing).call(function () {
          _this13.triggerSlot(0, codeNode);

          _this13.aniEnd = true;
          _this13.inRun = false;
        }).start();
      } else if (tweenMode == '变化多少值') {
        CocosMgr.xorConfigZeroValue(props);
        console.log('剔除掉0值之后的值', props);
        this.tween = cc.tween(codeNode).tag(this.tweenTag).delay(delay).by(duration, props, easing).call(function () {
          _this13.triggerSlot(0, codeNode);

          _this13.aniEnd = true;
          _this13.inRun = false;
        }).start();
      }
    }

    if (this.isOutputConnected(1)) {
      //监听点击事件
      codeNode.checkAddComponent('SpinePlusComponent');
      codeNode.on(cc.Node.EventType.TOUCH_END, this.onClick.bind(this));
    }
  } // 当节点Toggle时调用
  ;

  _proto4.onAction = function onAction(action, param) {
    // console.log("action", action, param)
    if (action == '播放') {
      var codeNode = this.getInputData(0, true); // console.log('当前tween目标物体', codeNode)

      if (codeNode != null) {
        this.realRun(codeNode);
      } else {
        console.warn('当前没有关联codeNode');
      }
    } else if (action == '停止') {
      this.tweenTag = 'tween_' + this.getIdWithGraph();
      cc.Tween.stopAllByTag(this.tweenTag);
    } //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  };

  _proto4.onClick = function onClick() {
    if (CocosMgr.isInApp == false) {
      if (window.onGraphNodeClick != null) {
        window.onGraphNodeClick({
          nodeId: this.getIdWithGraph(),
          time: this.graph.getTime(),
          funcName: 'onClick'
        });
      }
    }

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('点击时codeNode == null');
      return;
    }

    if (this.graph.config.pause == 1) {
      return;
    }

    if (this.aniEnd == true) {
      codeNode.targetOff();
      this.triggerSlot(1, codeNode);
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return tween;
}(_BaseYwNode.BaseYWNode);

tween.title = '数值动画';
tween.easingEnum = ['无', '淡入', '淡出', '淡入淡出', '回弹', '弹跳'];
tween.easingConfig = ['none', 'quadIn', 'quadOut', 'quadInOut', 'backOut', 'bounceOut'];
tween.tweenModeEnum = ['变化目标值', '变化多少值'];

_litegraph.LiteGraph.registerNodeType("objects/animates/tween", tween);

var bezierCurve = /*#__PURE__*/function (_BaseYWNode5) {
  _inheritsLoose(bezierCurve, _BaseYWNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function bezierCurve() {
    var _this14;

    _this14 = _BaseYWNode5.call(this) || this;
    _this14.title = "路径动画";
    _this14.desc = "用于控制节点进行曲线移动";
    _this14.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.serialize_widgets = true
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this14.addInput("物体", "codeNode");

    _this14.addInput("长度", 'number');

    _this14.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this14.addInput("重置位置", _litegraph.LiteGraph.ACTION);

    _this14.addOutput("结束", _litegraph.LiteGraph.EVENT); // this.addOutput("点击", LiteGraph.EVENT);


    _this14.addProperty('points', [0, 0, 200, 200, 400, 0], 'array');

    _this14.curveWidget = _this14.addWidget('curve', '曲线控制点', _this14.properties.points, 'points', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    }); // this.addProperty('selectPoint', 0, 'number')

    _this14.selectCtrl = _this14.addWidget('number', '选择控制点', -1, function (value) {
      // console.log('选择控制点', value)
      _this14.properties.selectPoint = value;
      _this14.curveWidget.selectPoint = value;
    }, {
      precision: 0,
      min: -1,
      max: _this14.properties.points.length / 2 - 1
    });

    _this14.addWidget('button', '', "", function (btnWidget) {
      if (btnWidget.clickeName == '删除控制点') {
        _this14.curveWidget.remonveCtrlPoint(_assertThisInitialized(_this14));

        _this14.selectCtrl.options.max = _this14.properties.points.length / 2 - 1;
      } else if (btnWidget.clickeName == '添加控制点') {
        _this14.curveWidget.addCtrlPoint(_assertThisInitialized(_this14)); // console.log('this.properties.points.length', this.properties.points.length)


        _this14.selectCtrl.options.max = _this14.properties.points.length / 2 - 1;
      }
    }, {
      buttons: ['删除控制点', '添加控制点']
    }); // this.addWidget('button','删除选中控制点', "", ()=>{
    //     this.curveWidget.remonveCtrlPoint(this)
    //     // console.log('this.properties.points.length', this.properties.points.length)
    //     this.selectCtrl.options.max = this.properties.points.length / 2 - 1
    // })
    // this.addWidget('button','添加控制点', "", ()=>{
    // })
    // this.addWidget('number', '曲线控制点', this.properties.duration, 'duration',  {precision: 1, min: 0, max: 60})


    _this14.addProperty('startT', 0, 'number');

    _this14.addWidget('slider', '起始位置', _this14.properties.startT, 'startT', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    });

    _this14.addProperty('endT', 1, 'number');

    _this14.addWidget('slider', '终点位置', _this14.properties.endT, 'endT', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    }); // this.addProperty('easing', '无', 'enum')
    // this.addWidget('combo', '缓动效果', this.properties.easing, {property: "easing", values: tween.easingEnum })


    _this14.addProperty('aniType', '随步长', 'enum');

    _this14.addWidget('combo', '动画模式', _this14.properties.aniType, {
      property: "aniType",
      values: bezierCurve.tweenModeEnum
    }); // 【随步长】输入一次根据步长增加移动位置的百分比，不停的输入直至移动到终点位置\n
    // 【随时间】输入后自动根据时间从起始位置运行到终点位置\n 
    // 【随长度】根据输入的数值移动对应长度


    _this14.addProperty('duration', 1, 'number');

    _this14.durationWidget = _this14.addWidget('slider', '动画时长', _this14.properties.duration, 'duration', {
      precision: 1,
      min: 0,
      max: 60,
      step2: 0.1
    });

    _this14.addProperty('oneStep', 0.01, 'number');

    _this14.oneStepWidget = _this14.addWidget('slider', '动画步长', _this14.properties.oneStep, 'oneStep', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    });

    _this14.addProperty('lookUp', false, 'boolean');

    _this14.addWidget('toggle', '角度跟随路径', _this14.properties.lookUp, 'lookUp');

    _this14.addProperty('startResetT', false, 'boolean');

    _this14.addWidget('toggle', '开始运行时重置', _this14.properties.startResetT, 'startResetT');

    _this14.addProperty('autoRun', false, 'boolean');

    _this14.addWidget('toggle', '是否自动播放', _this14.properties.autoRun, 'autoRun');

    _this14.addWidget('button', '预览动画', "", function () {
      if (_this14.previewTween != null) {
        _this14.realRun(_this14.previewTween, '播放');
      }
    }); //节点配置
    // this.addProperty('nodeConfig',  {
    //     x: this.properties.x, 
    //     y: this.properties.y,
    //     width: this.properties.width,
    //     height: this.properties.height,
    //     anchorX: this.properties.anchorX,
    //     anchorY: this.properties.anchorY,
    //     scaleX: this.properties.scaleX,
    //     scaleY: this.properties.scaleY,
    //     color: this.properties.color,
    //     angle:  this.properties.angle,
    // }, 'object')
    // this.nodeConfigWidget = this.addWidget('ccnode', '节点操控', this.properties.nodeConfig, 'nodeConfig',  { viewWidth: CocosMgr.designViewWidth, viewHeight: CocosMgr.designViewHeight })
    // this.addWidget('button','同步目标物体属性', "", ()=>{
    //     // this.getEnums()
    //     this.syncTargetValue()
    // })
    //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this14;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto5 = bezierCurve.prototype;

  _proto5.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex);

    if (outPutType == 'codeNode') {// if(linkedNode._renderSpine != null){
      //     this._skins.splice(0, this._skins.length, ...linkedNode._renderSpine.skins())
      //     this._animations.splice(0, this._animations.length, ...linkedNode._renderSpine.animations())
      // }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  };

  _proto5.onAdded = function onAdded() {
    this.updateWidght();
    this.sendAddEvent();
  };

  _proto5.onConfigure = function onConfigure() {
    this.updateWidght();
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto5.onSelected = function onSelected() {
    // this.getEnums()
    if (this.previewTween == null) {
      var target = this.getRealLinkNode();

      if (target == null) {
        return;
      }

      if (target.codeNode != null && cc.isValid(target.codeNode.node)) {
        var previewNode = cc.instantiate(target.codeNode.node);
        previewNode.isClone = true;
        previewNode.zIndex = 9999;
        this.previewTween = previewNode.getComponent('CodeNodeLg');
        this.previewTween.init();
        this.previewTween.parent = target.codeNode.parent;
        this.previewTween.curve = new _bezier.Bezier(this.properties.points);
        this.length = this.previewTween.curve.length();
        this.previewTween.t = this.properties.startT; // CocosMgr.syncConfigToCodeNode(this.previewTween, this.properties.nodeConfig)
      }
    }

    this.sendOtherEvent('onSelected');
  };

  _proto5.onDeselected = function onDeselected() {
    if (this.previewTween != null) {
      this.previewTween.destroyNode();
      this.previewTween = null;
    }
  } //当所有创建物体初始化完成后触发
  ;

  _proto5.onStart = function onStart() {
    console.log('animate onStart', this.properties.autoRun);
    this.length = new _bezier.Bezier(this.properties.points).length() * 2;
    this.t = 0;
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }

    _BaseYWNode5.prototype.onStart.call(this);
  };

  _proto5.onStop = function onStop() {
    this.onAction('停止');
  };

  _proto5.updateWidght = function updateWidght() {
    var aniType = this.properties.aniType;
    this.durationWidget.disabled = false;
    this.oneStepWidget.disabled = false;

    if (aniType == '随长度') {
      this.durationWidget.disabled = true;
      this.oneStepWidget.disabled = true;
    } else if (aniType == '随时间') {
      this.oneStepWidget.disabled = true;
    } else if (aniType == '随步长') {
      this.durationWidget.disabled = true;
    }
  };

  _proto5.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {
    var property = widget.options.property; // console.log('onWidgetChanged', name, value, oldValue, property)

    if (property != 'nodeConfig') {//  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      // if(typeof this.nodeConfigWidget.value == 'object'){
      //     if(this.nodeConfigWidget.value[property] != null){
      //         this.nodeConfigWidget.value[property] = value
      //         this.properties.nodeConfig[property] = value
      //         // console.log('修改了nodeCondig的颜色值', this.nodeConfigWidget.value)
      //     }
      // }
    }

    if (name == '动画模式') {
      this.updateWidght();
    }

    if (name == '曲线控制点') {
      this.properties.points = value;
      this.selectCtrl.value = this.curveWidget.selectPoint;

      if (this.previewTween != null) {
        this.previewTween.curve = new _bezier.Bezier(this.properties.points);
        this.length = this.previewTween.curve.length();
        this.previewTween.t = this.properties.startT;
      } else {
        console.log('当前没有previewTween');
      }
    }

    if (name == '起始位置' || name == '终点位置') {
      if (this.previewTween != null) {
        this.previewTween.t = this.properties.startT;
      }
    } // if(this.previewTween != null){
    //     var config = {}
    //     if(property == 'nodeConfig'){
    //         config = {...value}
    //     }else{
    //         config[property] = this.properties[property]
    //     }
    //     // console.log('更新节点配置', config, value)
    //     CocosMgr.syncConfigToCodeNode(this.previewTween, config)
    // }

  } //动态返回卡片显示的title
  // getTitle() {
  //    return this.title
  // };
  //暂不清楚用处
  ;

  _proto5.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto5.realRun = function realRun(codeNode, action) {
    var _this15 = this;

    if (action == '播放') {
      var duration = this.properties.duration;
      var lookUp = this.properties.lookUp;
      var aniType = this.properties.aniType;
      var startResetT = this.properties.startResetT;
      var endT = this.properties.endT; // '随步长','随时间','随长度'

      codeNode.lookUp = lookUp;

      if (codeNode.curve == null) {
        var curve = new _bezier.Bezier(this.properties.points);
        this.length = curve.length();
        codeNode.curve = curve;
      }

      if (aniType == '随长度') {
        var value = this.getInputData(1) || 0;
        var oneStep = value / this.length;
        console.log('输入的value / lenght', value, this.length, oneStep);
        codeNode.t += oneStep;
      } else if (aniType == '随步长') {
        var _oneStep = this.properties.oneStep;
        codeNode.t += _oneStep * 0.01;
      } else if (aniType == '随时间') {
        if (startResetT == true) {
          codeNode.t = this.properties.startT;
        }

        cc.Tween.stopAllByTag(this.tweenTag);
        this.tweenTag = 'curve_' + codeNode.node._id;
        cc.tween(codeNode).tag(this.tweenTag).to(duration, {
          t: endT
        }).call(function () {
          // this.outputHandle('number1', codeNode)
          _this15.triggerSlot(0, codeNode);
        }).start(); // console.log('运行了动画', tween.tag, duration, this.properties.startT, endT)
      }

      this.t = codeNode.t;

      if (codeNode.t == 1) {
        this.triggerSlot(0, codeNode);
      }
    } else if (action == '重置位置') {
      //重置位置
      this.end = false;
      var curve = new _bezier.Bezier(this.properties.points);
      this.length = curve.length();
      codeNode.curve = curve;
      codeNode.t = this.properties.startT * 0.01;
    } else if (action == '停止') {
      cc.Tween.stopAllByTag(this.tweenTag);
    }
  } // 当节点Toggle时调用
  ;

  _proto5.onAction = function onAction(action, param) {
    // console.log("action", action, param)
    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('当前没有关联codeNode');
      return;
    }

    this.realRun(codeNode, action); //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return bezierCurve;
}(_BaseYwNode.BaseYWNode);

bezierCurve.title = '路径动画'; // bezierCurve.easingEnum = ['无','淡入','淡出','淡入淡出','回弹','弹跳']
// bezierCurve.easingConfig = ['none', 'quadIn', 'quadOut', 'quadInOut', 'backOut', 'bounceOut']

bezierCurve.tweenModeEnum = ['随步长', '随时间', '随长度'];

_litegraph.LiteGraph.registerNodeType("objects/animates/bezierCurve", bezierCurve); //自定义脚本组件


var camera = /*#__PURE__*/function (_BaseYWNode6) {
  _inheritsLoose(camera, _BaseYWNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function camera() {
    var _this16;

    _this16 = _BaseYWNode6.call(this) || this; // this.serialize_widgets = true
    // this.mode = LiteGraph.ON_EVENT;     //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.getInputData(0, true)
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this16.title = "镜头";
    _this16.desc = "在绘本中使用镜头位移效果";
    _this16.color = '#3F42EA';
    _this16.priority = -999; //放在最前执行

    _this16.widgets_up = true; // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);

    _this16.addOutput("物体", 'codeNode');

    _this16.addProperty('x', 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget('number', '坐标-x', _this16.properties.x, 'x', {
      precision: 1
    });

    _this16.addProperty("y", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget('number', '坐标-y', _this16.properties.y, 'y', {
      precision: 1
    });

    _this16.addProperty("zoomRatio", 1, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget("number", "镜头缩放", _this16.properties.zoomRatio, "zoomRatio", {
      precision: 1,
      min: 1,
      max: 10,
      step2: 0.01
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    //节点配置


    _this16.addProperty('nodeConfig', {
      x: 0,
      y: 0,
      width: CocosMgr.designViewWidth,
      height: CocosMgr.designViewHeight,
      anchorX: 0.5,
      anchorY: 0.5,
      scaleX: 1,
      scaleY: 1,
      color: '#3F42EA',
      angle: 0
    }, 'object'); ////仅仅绘制边框


    _this16.nodeConfigWidget = _this16.addWidget('ccnode', '节点操控', _this16.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight,
      justDrawBorder: true,
      borderColor: '#3F42EA'
    });

    _this16.addWidget('button', '重置到默认状态', "", function () {
      // console.log("点击了重置属性")
      _this16.setProperty('x', 0);

      _this16.setProperty('y', 0);

      _this16.setProperty('zoomRatio', 1);
    });

    return _this16;
  } //创建一个物体


  var _proto6 = camera.prototype;

  _proto6.createObj = function createObj(loadCb) {
    if (this.codeNode != null) {
      // console.log('我删除了旧的codeNode', this.codeNode.node._id)
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);

      if (this.cameraUi != null) {
        if (cc.isValid(this.cameraUi)) {
          this.cameraUi.destroy();
          this.cameraUi = null;
        }
      }
    }

    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == true) {
        // if(CocosMgr.isInApp == true){
        //不重复生成，仅仅重置所有参数
        var config = _extends({}, this.properties.nodeConfig);

        config.zoomRatio = this.properties.zoomRatio; // console.log('更新节点配置', config, value)

        CocosMgr.syncConfigToCodeNode(this.codeNode, config);

        if (loadCb != null) {
          loadCb();
        }

        this.setOutputData(0, this.codeNode);
        return;
      }

      this.codeNode = null;
      this.setOutputData(0, null);
    }

    var config = _extends({}, this.properties.nodeConfig);

    var rootccNode = this.graph.vars.rootccNode;

    if (rootccNode != null) {
      config['parent'] = rootccNode;
    } // console.log('createObj config', config)  //调用一个创建物体的配置


    this.codeNode = CocosMgr.createObj(config, loadCb);
    this.codeNode.nodeName = 'Camera'; // console.error("是否创建真实camera", CocosMgr.isPreviewMode, rootccNode)

    if (CocosMgr.isPreviewMode == true) {
      var ctx = this.codeNode.checkAddComponent(cc.Graphics);
      this.codeNode.ctx = ctx;
      this.codeNode.zIndex = 99999;
      this.codeNode.updatePreview();
    } else {
      //添加摄像机组件 
      var _camera2 = this.codeNode.checkAddComponent(cc.Camera);

      _camera2.cullingMask = -31; //特殊配置

      _camera2.clearFlags = 6;
      this.codeNode.camera = _camera2;
      this.codeNode.zoomRatio = this.properties.zoomRatio; // camera.enabled = false
      //还要添加ui camera

      if (CocosMgr.isInApp) {
        var node2 = new cc.Node();
        node2.parent = this.codeNode.node.parent;
        node2.name = 'New 2D Camera';
        var cameraUi = node2.addComponent(cc.Camera);
        cameraUi.cullingMask = 24;
        cameraUi.clearFlags = 6;
        cameraUi.depth = 2; // cameraUi.enabled = false

        this.cameraUi = node2;
      }
    } // console.log('我创建了的codeNode',  this.codeNode.node._id)


    this.setOutputData(0, this.codeNode);
    return this.codeNode;
  };

  _proto6.onAdded = function onAdded() {
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      ///只在编辑器中的时候会创建
      this.createObj();
    }

    this.sendAddEvent();
  };

  _proto6.onSelected = function onSelected() {
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      this.createObj();
    }

    this.sendOtherEvent('onSelected');
  };

  _proto6.updateOutputData = function updateOutputData(slot) {
    // console.log('我收到了更新物体的事件', slot)
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      this.createObj();
    }

    this.setOutputData(slot, this.codeNode);
  } // onSelected(){
  //     // this.getEnums()
  //     // if(this.previewTween == null){
  //     //     var config = {...this.properties.nodeConfig}
  //     //     this.previewTween = CocosMgr.createObj(config)
  //     //     this.previewTween.nodeName = '镜头预览'
  //     //     var ctx = this.previewTween.addComponent(cc.Graphics)
  //     //     this.previewTween.ctx = ctx
  //     //     this.previewTween.zIndex = 10000
  //     //     this.previewTween.updatePreview()
  //     // }
  //     if(this.codeNode != null){
  //     }
  // }
  // onDeselected(){
  //     if(this.previewTween != null){
  //         this.previewTween.destroyNode()
  //         this.previewTween = null
  //     }
  // }
  //在不同的蓝图切换，需要查询是否存在预览节点，不存在的话就创建
  //当lagraph attach时此node可能还未创建，所以不能
  // onAttachCanvas(){
  //     console.log('onAttachCanvas', this.properties.customeName )
  //     this.createObj()
  // }
  // onDetachCanvas(){
  //     console.log('onDetachCanvas', this.properties.customeName )
  //     if(this.codeNode != null){
  //         this.codeNode.destroyNode()
  //         this.codeNode = null
  //     }
  // }
  ;

  _proto6.onStartBeforeLoad = function onStartBeforeLoad() {};

  _proto6.onStart = function onStart() {
    this.createObj();
  };

  _proto6.onPause = function onPause() {
    if (this.codeNode != null) {
      cc.director.getActionManager().pauseTarget(this.codeNode);
    }
  };

  _proto6.onResume = function onResume() {
    if (this.codeNode != null) {
      cc.director.getActionManager().resumeTarget(this.codeNode);
    }
  };

  _proto6.onStop = function onStop() {
    //这里不能重制，重置参数的时候截图会闪烁
    if (this.codeNode != null && CocosMgr.isInApp == false) {
      var config = _extends({}, this.properties.nodeConfig);

      config.zoomRatio = this.properties.zoomRatio; // console.log('更新节点配置', config, value)

      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }
  };

  _proto6.onRemoved = function onRemoved() {
    // console.log('我从graph中移除了', this.properties.customeName)
    if (this.codeNode != null) {
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);
    }

    if (this.cameraUi != null) {
      if (cc.isValid(this.cameraUi)) {
        this.cameraUi.destroy();
        this.cameraUi = null;
      }
    }

    this.sendRemoveEvent();
  };

  _proto6.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }

        if (property == 'zoomRatio') {
          if (this.nodeConfigWidget.value['scaleX'] != null) {
            this.nodeConfigWidget.value['scaleX'] = 1 / value;
            this.properties.nodeConfig['scaleX'] = 1 / value;
            this.nodeConfigWidget.value['scaleY'] = 1 / value;
            this.properties.nodeConfig['scaleY'] = 1 / value;
          }
        }
      }
    }

    if (this.codeNode != null) {
      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     var property = widget.options.property
  // }
  // 当节点Toggle时调用
  // onAction(action, param)
  // {
  //    if(action == '修改'){
  //    }
  // }
  ;

  return camera;
}(_BaseYwNode.BaseYWNode);

camera.title = '镜头';

_litegraph.LiteGraph.registerNodeType("objects/camera", camera);

var connection = /*#__PURE__*/function (_BaseYWNode7) {
  _inheritsLoose(connection, _BaseYWNode7);

  // Name to show
  function connection() {
    var _this17;

    _this17 = _BaseYWNode7.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this17.title = "连接零件";
    _this17.desc = "将一个物体设置为另一个物体的子物体";
    _this17.mode = _litegraph.LiteGraph.ON_EVENT;

    _this17.addInput("关联父物体", 'codeNode');

    _this17.addInput("关联子物体", 'codeNode'); // this.addOutput("A", -1);
    // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this17;
  }

  var _proto7 = connection.prototype;

  _proto7.onGetInputs = function onGetInputs() {
    return [["关联子物体", 'codeNode']];
  };

  _proto7.onStart = function onStart() {
    this.onAction();

    _BaseYWNode7.prototype.onStart.call(this);
  };

  _proto7.onSelected = function onSelected() {
    // console.log('connection onSelected')
    this.onAction();
    this.sendOtherEvent('onSelected');
  };

  _proto7.disconnectInput = function disconnectInput(slot, keepReroutes) {
    // console.log('我准备移除输入节点', slot, keepReroutes)
    if (slot >= 1) {
      var codeNode = this.getInputData(slot, true); // console.log("找到了目标节点，移除", slot,codeNode )

      if (codeNode != null) {
        var rootccNode = this.graph.vars.rootccNode;

        if (rootccNode == null) {
          rootccNode = cc.director.getScene().getChildByName('Canvas');
        }

        if (rootccNode != null) {
          codeNode.parent = rootccNode;
        }
      }
    }

    _BaseYWNode7.prototype.disconnectInput.call(this, slot, keepReroutes);
  };

  _proto7.onAction = function onAction() {
    var codeNode = this.getInputData(0, true); // this.linkDatas.cardexSolt[0]

    if (codeNode == null) {
      return;
    }

    var parent = codeNode.node;

    if (parent != null) {
      for (var i = 1; i < this.inputs.length; i++) {
        var _codeNode = this.getInputData(i, true);

        if (_codeNode != null) {
          _codeNode.parent = parent;
        }
      }
    }
  } //   getTitle() {
  //       if (this.flags.collapsed) {
  //           return "发送事件." + this.properties.customeName;
  //       }
  //       return this.title;
  //   };
  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  //   onAction(action, param){
  //     let data = this.getInputData(0)
  //     this.graph.sendEventToAllNodes(this.properties.customeName, data)
  //   }
  ;

  return connection;
}(_BaseYwNode.BaseYWNode);

connection.title = '连接零件'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/group/connection", connection);

var groupMove = /*#__PURE__*/function (_BaseYWNode8) {
  _inheritsLoose(groupMove, _BaseYWNode8);

  function groupMove() {
    var _this18;

    _this18 = _BaseYWNode8.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this18.title = "整体移动";
    _this18.desc = "用于在开发时整体移动所有物体";
    _this18.mode = _litegraph.LiteGraph.ON_EVENT;

    _this18.addProperty('x', 0, 'number');

    _this18.addWidget('number', '坐标-x', _this18.properties.x, 'x', {
      precision: 2
    });

    _this18.addProperty('y', 0, 'number');

    _this18.addWidget('number', '坐标-y', _this18.properties.y, 'y', {
      precision: 2
    });

    return _this18;
  } //变量切换


  var _proto8 = groupMove.prototype;

  _proto8.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    console.log('当前变量切换', property, value, oldValue, value - oldValue);
    var objectNodes = this.graph.findNodesByType('objects/createObject');
    var valueChanged = value - oldValue;
    objectNodes.forEach(function (element) {
      element.setProperty(property, element.properties[property] + valueChanged);
    });
    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  return groupMove;
}(_BaseYwNode.BaseYWNode);

groupMove.title = '整体移动';

_litegraph.LiteGraph.registerNodeType("objects/groupMove", groupMove);

var groupScale = /*#__PURE__*/function (_BaseYWNode9) {
  _inheritsLoose(groupScale, _BaseYWNode9);

  function groupScale() {
    var _this19;

    _this19 = _BaseYWNode9.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this19.title = "分镜预览缩放";
    _this19.desc = "用于在开发时分镜预览缩放，以便看清超出屏幕范围的物体";
    _this19.color = '#FFC082';
    _this19.mode = _litegraph.LiteGraph.ON_EVENT;

    _this19.addProperty('x', 0, 'number');

    _this19.addWidget('number', '位移x', _this19.properties.x, 'x', {
      precision: 2
    });

    _this19.addProperty('y', 0, 'number');

    _this19.addWidget('number', '位移y', _this19.properties.y, 'y', {
      precision: 2
    });

    _this19.addProperty('zoomRatio', 1, 'number');

    _this19.addWidget('slider', '缩放', _this19.properties.zoomRatio, 'zoomRatio', {
      precision: 2,
      min: 0.25,
      max: 1
    }); //节点配置


    _this19.addProperty('nodeConfig', {
      x: 0,
      y: 0,
      width: CocosMgr.designViewWidth,
      height: CocosMgr.designViewHeight,
      anchorX: 0.5,
      anchorY: 0.5,
      scaleX: 1,
      scaleY: 1,
      color: '#FFC082',
      angle: 0
    }, 'object'); ////仅仅绘制边框


    _this19.nodeConfigWidget = _this19.addWidget('ccnode', '节点操控', _this19.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight,
      justDrawBorder: false,
      borderColor: '#FFC082'
    });

    _this19.addWidget('button', '重置到默认状态', "", function () {
      console.log("点击了重置属性");

      _this19.setProperty('x', 0);

      _this19.setProperty('y', 0);

      _this19.setProperty('zoomRatio', 1);
    });

    return _this19;
  } //变量切换


  var _proto9 = groupScale.prototype;

  _proto9.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    // console.log('修改了属性', property, value)
    if (CocosMgr.isInApp == false) {
      var _camera3 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera'); // console.log('修改了属性', , property, value)


      if (property == 'x') {
        _camera3.x = value * -1 / this.properties.zoomRatio;
      } else if (property == 'y') {
        _camera3.y = value * -1 / this.properties.zoomRatio;
      } else if (property == 'zoomRatio') {
        // console.log('设置zoomRatio', 'zoomRatio', value)
        _camera3.getComponent(cc.Camera).zoomRatio = value;
      }

      if (property != 'nodeConfig') {
        //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
        if (typeof this.nodeConfigWidget.value == 'object') {
          if (this.nodeConfigWidget.value[property] != null) {
            this.nodeConfigWidget.value[property] = value;
            this.properties.nodeConfig[property] = value;
          }

          if (property == 'zoomRatio') {
            if (this.nodeConfigWidget.value['scaleX'] != null) {
              this.nodeConfigWidget.value['scaleX'] = value;
              this.properties.nodeConfig['scaleX'] = value;
              this.nodeConfigWidget.value['scaleY'] = value;
              this.properties.nodeConfig['scaleY'] = value;
            }
          }
        }
      }
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     var property = widget.options.property
  // }
  ;

  _proto9.onStop = function onStop() {};

  _proto9.onAttachCanvas = function onAttachCanvas() {};

  _proto9.onConfigure = function onConfigure() {
    if (CocosMgr.isInApp == false) {
      var _camera4 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera');

      _camera4.x = this.properties.x * -1 / this.properties.zoomRatio;
      _camera4.y = this.properties.y * -1 / this.properties.zoomRatio;
      _camera4.getComponent(cc.Camera).zoomRatio = this.properties.zoomRatio;
    }
  };

  _proto9.onRemoved = function onRemoved() {
    this.onAction('重置');
    this.sendRemoveEvent();
  };

  _proto9.onAction = function onAction(name) {
    // console.log('调用的方案', name)
    if (name == '重置') {
      var _camera5 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera');

      _camera5.x = 0;
      _camera5.y = 0;
      _camera5.getComponent(cc.Camera).zoomRatio = 1;
    }
  };

  return groupScale;
}(_BaseYwNode.BaseYWNode);

groupScale.title = '分镜预览缩放';

_litegraph.LiteGraph.registerNodeType("objects/groupScale", groupScale);

cc._RF.pop();