"use strict";
cc._RF.push(module, '6643ayNFuRHd5AMRer5A5lP', 'input');
// Script/Common/LiteGraphCore/nodes/input.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var valueRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(valueRobot, _LGraphNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function valueRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this.title = "value";
    _this.desc = "定义一个数";
    _this.name = '数值';

    _this.addOutput("输出", "number"); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addProperty("value", 1.0); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this.widget = _this.addWidget("number", "值", 1, "value"); //    this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto = valueRobot.prototype;

  _proto.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, parseFloat(this.properties["value"])); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  ;

  _proto.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    this.outputs[0].label = this.properties["value"].toFixed(3);
  };

  return valueRobot;
}(_litegraph.LGraphNode);

// Register the node type
valueRobot.title = '数值'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/value", valueRobot); //第一个是唯一key，同时也是菜单选项路径


var valueStringRobot = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(valueStringRobot, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function valueStringRobot() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this2.title = "文字";
    _this2.desc = "定义文字值";

    _this2.addOutput("输出", "string"); //增加一个输出触点，  输出节点的名称， 值类型


    _this2.addProperty("value", ""); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this2.widget = _this2.addWidget("text", "value", "", "value"); //  this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this2.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this2;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto2 = valueStringRobot.prototype;

  _proto2.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, this.properties["value"]); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto2.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto2.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return valueStringRobot;
}(_litegraph.LGraphNode); // Register the node type


valueStringRobot.title = '文字'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/valueString", valueStringRobot); //第一个是唯一key，同时也是菜单选项路径


var BooleanRobot = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(BooleanRobot, _LGraphNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function BooleanRobot() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this3.title = "布尔值";
    _this3.desc = "定义一个数";

    _this3.addOutput("bool", "boolean"); //增加一个输出触点，  输出节点的名称， 值类型


    _this3.addProperty("value", true); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this3.widget = _this3.addWidget("toggle", "value", true, "value"); //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    // this.size = [140, 30];                                  //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this3;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto3 = BooleanRobot.prototype;

  _proto3.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, parseFloat(this.properties["value"])); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto3.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto3.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  ;

  _proto3.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    this.outputs[0].label = this.properties["value"] ? '真' : '假';
  };

  return BooleanRobot;
}(_litegraph.LGraphNode);

BooleanRobot.title = '布尔值';

_litegraph.LiteGraph.registerNodeType("input/boolean", BooleanRobot);

var gameStartRobot = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(gameStartRobot, _LGraphNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function gameStartRobot() {
    var _this4;

    _this4 = _LGraphNode4.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this4.title = "开始时";
    _this4.desc = "但游戏开始时执行一次";

    _this4.addOutput("游戏开始", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this4.addProperty('modal', '开始时', 'enum');

    _this4.addWidget('combo', '输出时机', _this4.properties.modal, {
      property: "modal",
      values: ['开始前', '开始时', '开始后']
    }); //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this4.widgets_up = true; //设置输入组件在顶部（覆盖input和output）

    _this4.size = [180, 30]; //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this4;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  //这一阶段加载所有资源


  var _proto4 = gameStartRobot.prototype;

  _proto4.onStartBeforeLoad = function onStartBeforeLoad() {
    if (this.properties.modal == '开始前') {
      this.triggerSlot(0, 1);
    }
  } //开始时，在所有onExecute执行之前
  ;

  _proto4.onStart = function onStart() {
    if (this.properties.modal == '开始时') {
      this.triggerSlot(0, 1);
    }
  } //开始后在第一次onExecute执行之后
  ;

  _proto4.onStartAfter = function onStartAfter() {
    if (this.properties.modal == '开始后') {
      this.triggerSlot(0, 1);
    }
  } //动态返回卡片显示的title
  ;

  _proto4.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.modal;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto4.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return gameStartRobot;
}(_litegraph.LGraphNode); // Register the node type


gameStartRobot.title = '开始时'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/gameStart", gameStartRobot); //第一个是唯一key，同时也是菜单选项路径


var customButtonRobot = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(customButtonRobot, _LGraphNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function customButtonRobot() {
    var _this5;

    _this5 = _LGraphNode5.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this5.title = "按钮";
    _this5.desc = "一个可以点击的按钮";
    _this5.font = 'Arial';

    _this5.addOutput("", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this5.addOutput("", "boolean");

    _this5.addProperty("font_size", 30);

    _this5.addProperty("text", "按钮");

    _this5.addProperty("message", ""); // this.addProperty("value", true);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）


    _this5.size = [164, 84]; //设置默认节点尺寸

    _this5.clicked = false; //   this.properties.precision = 1

    return _this5;
  }

  var _proto5 = customButtonRobot.prototype;

  _proto5.onMouseDown = function onMouseDown(e, local_pos) {
    if (local_pos[0] > 1 && local_pos[1] > 1 && local_pos[0] < this.size[0] - 2 && local_pos[1] < this.size[1] - 2) {
      this.clicked = true;
      this.setOutputData(1, this.clicked);
      this.triggerSlot(0, this.properties.message);
      this.clicked = false;
      this.setOutputData(1, this.clicked);
      return true;
    }
  };

  // onMouseUp(e) {
  //     console.log('鼠标离开了')
  //     this.clicked = false;
  //     this.setOutputData(1, this.clicked);
  // };
  // Function to call when the node is executed
  //执行时的方法
  _proto5.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
    this.setOutputData(1, this.clicked);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  ;

  _proto5.onDrawForeground = function onDrawForeground(ctx) {
    if (this.flags.collapsed) {
      return;
    }

    var margin = 10;
    ctx.fillStyle = "black";
    ctx.fillRect(margin + 1, margin + 1, this.size[0] - margin * 2, this.size[1] - margin * 2);
    ctx.fillStyle = "#AAF";
    ctx.fillRect(margin - 1, margin - 1, this.size[0] - margin * 2, this.size[1] - margin * 2);
    ctx.fillStyle = this.clicked ? "white" : this.mouseOver ? "#668" : "#334";
    ctx.fillRect(margin, margin, this.size[0] - margin * 2, this.size[1] - margin * 2);

    if (this.properties.text || this.properties.text === 0) {
      var font_size = this.properties.font_size || 30;
      ctx.textAlign = "center";
      ctx.fillStyle = this.clicked ? "black" : "white";
      ctx.font = font_size + "px " + 'Arial';
      ctx.fillText(this.properties.text, this.size[0] * 0.5, this.size[1] * 0.5 + font_size * 0.3);
      ctx.textAlign = "left";
    }
  };

  return customButtonRobot;
}(_litegraph.LGraphNode);

customButtonRobot.title = '按钮';

_litegraph.LiteGraph.registerNodeType("input/button/customButton", customButtonRobot);

var controllRobot = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(controllRobot, _LGraphNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function controllRobot() {
    var _this6;

    _this6 = _LGraphNode6.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this6.title = "摇杆";
    _this6.desc = "操作杆的x和y的范围：[-1, 1]，当拖动操控杆时\n仅改变时：操控杆移发生位移变化时输出当前操作杆范围\n持续：一直输出操控杆当前值*这一帧的时长";
    _this6.font = 'Arial';

    _this6.addOutput("左右", 'number'); //增加一个输出触点，  输出节点的名称， 值类型


    _this6.addOutput("上下", 'number');

    _this6.addOutput("按下时", _litegraph.LiteGraph.EVENT);

    _this6.addProperty("controllType", 0);

    _this6.addProperty("modal", 0);

    _this6.addProperty("outputScale", 250); // this.addProperty("outputScale", 0);
    // this.addProperty("font_size", 30);
    // this.addProperty("text", "click me");
    // this.addProperty("message", "");
    // this.addProperty("value", true);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）


    _this6.size = [164, 164]; //设置默认节点尺寸

    _this6.clicked = false; //   this.properties.precision = 1

    return _this6;
  }

  var _proto6 = controllRobot.prototype;

  _proto6.freshHandlePos = function freshHandlePos(local_pos) {
    var minLength = Math.min(this.size[0], this.size[1]);
    var maxDistance = minLength * 0.5;
    var deltaX = local_pos[0] - maxDistance;
    var deltaY = local_pos[1] - maxDistance;
    var distance = Math.min(Math.sqrt(deltaX * deltaX + deltaY * deltaY), maxDistance); // 限制在圆形范围内

    var angle = Math.atan2(deltaY, deltaX);
    var limitedX = distance * Math.cos(angle);
    var limitedY = distance * Math.sin(angle);

    if (local_pos[0] > 0 && local_pos[1] > 0 && local_pos[0] < minLength && local_pos[1] < minLength) {
      // this.clicked = true;
      // var halfLength = minLength * 0.5
      this.setOutputData(0, limitedX / maxDistance);
      this.setOutputData(1, limitedY / maxDistance); // this.triggerSlot(0, this.properties.message);
      // this.clicked = false;
      // this.setOutputData(1, this.clicked);
      // console.log('点击了摇杆', local_pos)

      return true;
    }
  };

  _proto6.onMouseDown = function onMouseDown(e, local_pos) {
    this.clicked = true;
    this.freshHandlePos(local_pos);
    this.triggerSlot(2);
  };

  _proto6.onMouseMove = function onMouseMove(e, local_pos) {
    if (this.clicked != true) {
      return;
    }

    this.freshHandlePos(local_pos);
  };

  _proto6.onMouseUp = function onMouseUp(e) {
    // console.log('鼠标离开了')
    this.clicked = false;
    this.setOutputData(0, 0);
    this.setOutputData(1, 0);
  };

  // Function to call when the node is executed
  //执行时的方法
  _proto6.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
    this.setOutputData(1, this.clicked);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  ;

  _proto6.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    if (this.flags.collapsed) {
      return;
    }

    var x = this.getOutputData(0);
    var y = this.getOutputData(1);

    if (x != null && x.toFixed != null) {
      this.outputs[0].label = '左右：' + x.toFixed(3);
    }

    if (y != null && y.toFixed != null) {
      this.outputs[1].label = '上下：' + y.toFixed(3);
    }
  };

  //使用ctx绘制需要显示的内容
  _proto6.onDrawForeground = function onDrawForeground(ctx) {
    if (this.flags.collapsed) {
      return;
    }

    var minLength = Math.min(this.size[0], this.size[1]);
    var base = {
      width: minLength,
      height: minLength
    }; //整体大小

    var handle = {
      width: minLength * 0.25,
      height: minLength * 0.25
    }; //手柄大小

    this.size[0]; // ctx.fillStyle = "black";
    // ctx.clearRect(0, 0, base.width, base.height);
    // 底座渐变

    var gradient = ctx.createRadialGradient(base.width / 2, base.height / 2, 0, base.width / 2, base.height / 2, base.width / 2);
    gradient.addColorStop(0, '#666');
    gradient.addColorStop(1, '#222');
    ctx.beginPath();
    ctx.arc(base.width / 2, base.height / 2, base.width / 2, 0, Math.PI * 2);
    ctx.fillStyle = gradient;
    ctx.fill(); // 底座刻度

    ctx.strokeStyle = 'rgba(255,255,255,0.2)';
    ctx.lineWidth = 2; // 十字线

    ctx.beginPath();
    ctx.moveTo(base.width / 2, 0);
    ctx.lineTo(base.width / 2, base.height);
    ctx.moveTo(0, base.height / 2);
    ctx.lineTo(base.width, base.height / 2);
    ctx.stroke(); // 圆圈刻度

    for (var i = 1; i <= 3; i++) {
      ctx.beginPath();
      ctx.arc(base.width / 2, base.height / 2, i * base.width / 6, 0, Math.PI * 2);
      ctx.stroke();
    } // 绘制摇杆手柄
    // ctx.moveTo(base.width * 0.5, base.height * 0.5)


    var gradient = ctx.createRadialGradient(handle.width / 2, handle.height / 2, 0, handle.width / 2, handle.height / 2, handle.width / 2);
    gradient.addColorStop(0, '#fff');
    gradient.addColorStop(1, '#aaa');
    var dirX = this.getOutputData(0) || 0;
    var dirY = this.getOutputData(1) || 0;
    var xPos = base.width * 0.5 + (0 + dirX) * base.width * 0.5;
    var yPos = base.height * 0.5 + (0 + dirY) * base.height * 0.5;
    ctx.beginPath();
    ctx.arc(xPos, yPos, handle.width / 2, 0, Math.PI * 2);
    ctx.fillStyle = gradient;
    ctx.fill(); // 手柄高光

    ctx.beginPath();
    ctx.arc(xPos, yPos, handle.width / 3, 0, Math.PI * 2);
    ctx.fillStyle = 'rgba(255,255,255,0.3)';
    ctx.fill();
  };

  return controllRobot;
}(_litegraph.LGraphNode);

controllRobot.title = '摇杆';

_litegraph.LiteGraph.registerNodeType("input/button/controll", controllRobot);

var touchStart = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(touchStart, _LGraphNode7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchStart() {
    var _this7;

    _this7 = _LGraphNode7.call(this) || this;
    _this7.title = "触摸开始";
    _this7.desc = "检测物体触摸开始";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this7.addInput("物体", "codeNode");

    _this7.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this7.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this7.addOutput('开始X', 'number');

    _this7.addOutput('开始Y', 'number');

    _this7.addOutput('点击', _litegraph.LiteGraph.EVENT);

    _this7.addProperty('controllObj', false, 'boolean');

    _this7.addWidget('toggle', '控制物体位置', _this7.properties.controllObj, 'controllObj'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this7.useCanvas = false;
    _this7.lastBindCodeNode = null;
    return _this7;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  // onStart(){
  //     // this.triggerSlot(0, 1);
  // }


  var _proto7 = touchStart.prototype;

  _proto7.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      this.useCanvas = false;
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto7.realRun = function realRun(codeNode, isListen) {
    var _this8 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.node.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;
        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        codeNode.targetOff(this);
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          if (_this8.graph.config.pause == 1) {
            return;
          }

          var location = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());

          if (_this8.properties.controllObj == true) {
            codeNode.x = location.x;
            codeNode.y = location.y;
          }

          _this8.setOutputData(0, location.x);

          _this8.setOutputData(1, location.y);

          _this8.triggerSlot(2, 1);
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          canvas = cc.director.getScene().getChildByName('Canvas'); // return
        }

        canvas.targetOff(this);
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          if (_this8.graph.config.pause == 1) {
            return;
          }

          var location = canvas.convertToNodeSpaceAR(event.getLocation());

          _this8.setOutputData(0, location.x);

          _this8.setOutputData(1, location.y);

          _this8.triggerSlot(2, 1);
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas = this.graph.config.rootccNode;

        if (_canvas == null) {
          // console.warn("没有rootccNode")
          _canvas = cc.director.getScene().getChildByName('Canvas');
          return;
        }

        _canvas.targetOff(this);
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto7.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto7.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchStart;
}(_litegraph.LGraphNode); // Register the node type


touchStart.title = '触摸开始'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchStart", touchStart); //第一个是唯一key，同时也是菜单选项路径


var touchMove = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(touchMove, _LGraphNode8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchMove() {
    var _this9;

    _this9 = _LGraphNode8.call(this) || this;
    _this9.title = "触摸移动";
    _this9.desc = "检测物体触摸开始";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this9.addInput("物体", "codeNode");

    _this9.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this9.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this9.addOutput('X轴移动', 'number');

    _this9.addOutput('Y轴移动', 'number');

    _this9.addOutput('移动', _litegraph.LiteGraph.EVENT);

    _this9.addProperty('controllObj', false, 'boolean');

    _this9.addWidget('toggle', '控制物体位置', _this9.properties.controllObj, 'controllObj');

    _this9.addProperty('needCheckIn', false, 'boolean');

    _this9.addWidget('toggle', '碰撞框检测', _this9.properties.needCheckIn, 'needCheckIn');

    _this9.addProperty('mutplayTouch', false, 'boolean');

    _this9.addWidget('toggle', '忽略多点触摸', _this9.properties.mutplayTouch, 'mutplayTouch'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this9.useCanvas = false;
    _this9.lastBindCodeNode = null;
    _this9.touchIds = {};
    return _this9;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  // onStart(){
  //     console.log('toucmove onstart')
  // }
  //停止运行


  var _proto8 = touchMove.prototype;

  _proto8.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      this.useCanvas = false;
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      console.log('停止运行了 lastBindCodeNode', this.lastBindCodeNode);

      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto8.realRun = function realRun(codeNode, isListen) {
    var _this10 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;

        if (codeNode.node != null) {// console.log('realRun lastBindCodeNode id', codeNode._id)
        } else {
          console.log('realRun lastBindCodeNode 节点已经被销毁');
        }

        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        var lastMovePos = null;
        var moveCount = 5;
        var eventId = null;
        codeNode.targetOff(this);
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          lastMovePos = null;
          eventId = event.getID();
          var eventid = event.getID();
          _this10.touchIds[eventid] = 1;
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
          if (Object.keys(_this10.touchIds).length > 1 && _this10.properties.mutplayTouch == true) {
            //多点触摸时不响应
            return;
          }

          if (eventId != event.getID()) {
            return;
          }

          if (_this10.graph.config.pause == 1) {
            return;
          }

          if (_this10.instance != null && moveCount < 5) {
            moveCount += 1;
            return;
          }

          moveCount = 0;

          if (lastMovePos == null) {
            lastMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation());
            return;
          }

          var nowMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation()); //移动的时候检测，只在碰撞框内才出发移动

          var inTouch = true;

          if (_this10.properties.needCheckIn["default"] == 1) {
            var collider = codeNode.getComponent(cc.PolygonCollider);

            if (collider != null) {
              var inNodePos = codeNode.node.convertToNodeSpaceAR(event.getLocation());
              var inTouch = cc.Intersection.pointInPolygon(inNodePos, collider.points);
            }
          }

          var delta = nowMovePos.sub(lastMovePos);

          if (inTouch == true) {
            _this10.setOutputData(0, delta.x);

            _this10.setOutputData(1, delta.y);

            _this10.triggerSlot(2, 1);

            if (_this10.properties.controllObj == true) {
              codeNode.x += delta.x;
              codeNode.y += delta.y;
            }
          }

          lastMovePos = nowMovePos;
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          // return
          canvas = cc.director.getScene().getChildByName('Canvas');
        }

        canvas.targetOff(this);
        var lastMovePos = null;
        var moveCount = 5;
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          lastMovePos = null;
          var eventid = event.getID();
          _this10.touchIds[eventid] = 1;
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
          if (Object.keys(_this10.touchIds).length > 1 && _this10.properties.mutplayTouch == true) {
            //多点触摸时不响应
            return;
          }

          if (_this10.graph.config.pause == 1) {
            return;
          }

          if (moveCount < 5) {
            moveCount += 1;
            return;
          }

          moveCount = 0;

          if (lastMovePos == null) {
            lastMovePos = canvas.parent.convertToNodeSpaceAR(event.getLocation());
            return;
          }

          var nowMovePos = canvas.parent.convertToNodeSpaceAR(event.getLocation());
          var delta = nowMovePos.sub(lastMovePos);

          _this10.setOutputData(0, delta.x);

          _this10.setOutputData(1, delta.y);

          lastMovePos = nowMovePos;
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_END, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas2 = this.graph.config.rootccNode;

        if (_canvas2 == null) {
          // console.warn("没有rootccNode")
          // return
          _canvas2 = cc.director.getScene().getChildByName('Canvas');
        }

        _canvas2.targetOff(this);

        this.useCanvas = false;
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto8.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      console.log('我开始监听移动', codeNode);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto8.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchMove;
}(_litegraph.LGraphNode); // Register the node type


touchMove.title = '触摸移动'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchMove", touchMove); //第一个是唯一key，同时也是菜单选项路径


var touchEnd = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(touchEnd, _LGraphNode9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchEnd() {
    var _this11;

    _this11 = _LGraphNode9.call(this) || this;
    _this11.title = "触摸结束";
    _this11.desc = "检测物体触摸开始";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this11.addInput("物体", "codeNode");

    _this11.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this11.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this11.addOutput('结束X', 'number');

    _this11.addOutput('结束Y', 'number'); //触摸开始到触摸结束时移动的距离小于10，【结束】输出为1，大于10，【结束】输出为2


    _this11.addOutput('结束', _litegraph.LiteGraph.EVENT);

    _this11.addOutput('点击结束', _litegraph.LiteGraph.EVENT); //触摸开始到触摸结束时移动的距离大于10


    _this11.addOutput('移动结束', _litegraph.LiteGraph.EVENT);

    _this11.addProperty('controllObj', false, 'boolean');

    _this11.addWidget('toggle', '控制物体位置', _this11.properties.controllObj, 'controllObj');

    _this11.addProperty('listernTouchCancel', false, 'boolean');

    _this11.addWidget('toggle', '响应触摸取消', _this11.properties.listernTouchCancel, 'listernTouchCancel'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this11.touchIds = {};
    return _this11;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }


  var _proto9 = touchEnd.prototype;

  _proto9.onStart = function onStart() {// this.triggerSlot(0, 1);
  };

  _proto9.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto9.realRun = function realRun(codeNode, isListen) {
    var _this12 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.node.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;
        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        codeNode.targetOff(this);
        var startLocation = null;
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          startLocation = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());
        }, this);

        var onTouchEnd = function onTouchEnd(event) {
          // console.log('点击结束')
          if (_this12.graph.config.pause == 1) {
            return;
          }

          var location = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());

          _this12.setOutputData(0, location.x);

          _this12.setOutputData(1, location.y);

          if (_this12.properties.controllObj == true) {
            codeNode.x = location.x;
            codeNode.y = location.y;
          }

          if (startLocation && location.sub(startLocation).mag() < 10) {
            // this.triggerSlot(2, 1)
            _this12.trigger('结束');

            _this12.trigger('点击结束');
          } else {
            // this.triggerSlot(3, 1)
            _this12.trigger('结束');

            _this12.trigger('移动结束');
          }
        };

        codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
          onTouchEnd(event);
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          if (_this12.properties.listernTouchCancel == true) {
            onTouchEnd(event);
          }
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          // return
          canvas = cc.director.getScene().getChildByName('Canvas');
        }

        canvas.targetOff(this);
        var startLocation = null;
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          startLocation = canvas.convertToNodeSpaceAR(event.getLocation());
        }, this);

        var onTouchEnd = function onTouchEnd(event) {
          if (_this12.graph.config.pause == 1) {
            return;
          }

          var location = canvas.convertToNodeSpaceAR(event.getLocation());

          _this12.setOutputData(0, location.x);

          _this12.setOutputData(1, location.y);

          if (location.sub(startLocation).mag() < 10) {
            _this12.trigger('结束');

            _this12.trigger('点击结束');
          } else {
            _this12.trigger('结束');

            _this12.trigger('移动结束');
          }
        };

        canvas.on(cc.Node.EventType.TOUCH_END, function (event) {
          onTouchEnd(event);
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          if (_this12.properties.listernTouchCancel == true) {
            onTouchEnd(event);
          }
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas3 = this.graph.config.rootccNode;

        if (_canvas3 == null) {
          // console.warn("没有rootccNode")
          // return
          _canvas3 = cc.director.getScene().getChildByName('Canvas');
        }

        _canvas3.targetOff(this);
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto9.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto9.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchEnd;
}(_litegraph.LGraphNode); // Register the node type


touchEnd.title = '触摸结束'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchEnd", touchEnd); //第一个是唯一key，同时也是菜单选项路径


var leftOrRightAct = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(leftOrRightAct, _LGraphNode10);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function leftOrRightAct() {
    var _this13;

    _this13 = _LGraphNode10.call(this) || this; // this.mode = LiteGraph.ON_EVENT;
    // this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    // this.addInput("监听", LiteGraph.ACTION);
    // this.addInput("取消监听", LiteGraph.ACTION);

    _this13.title = "重力感应";
    _this13.desc = "检测设备的陀螺仪";

    _this13.addOutput('x轴', 'number');

    _this13.addOutput('y轴', 'number');

    _this13.addOutput('z轴', 'number'); // this.addProperty('modal', '收到回调输出', 'enum')
    // this.addWidget('combo', '输出模式', this.properties.controllObj, 'controllObj')
    //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    return _this13;
  } //可以新增一个模拟设备方向的输出


  var _proto10 = leftOrRightAct.prototype;

  _proto10.onChangeEvent = function onChangeEvent(event) {
    this.x = event.acc.x;
    this.y = event.acc.y;
    this.z = event.acc.z;
    this.setOutputData(0, this.x);
    this.setOutputData(1, this.y);
    this.setOutputData(2, this.z);
  } // Function to call when the node is executed
  //执行时的方法
  ;

  _proto10.onStart = function onStart() {
    // this.triggerSlot(0, 1);
    cc.systemEvent.setAccelerometerEnabled(true);
    this.curState = 0;
    this.x = 0;
    this.y = 0;
    this.z = 0;
    this.setOutputData(0, this.x);
    this.setOutputData(1, this.y);
    this.setOutputData(2, this.z);
    cc.systemEvent.on(cc.SystemEvent.EventType.DEVICEMOTION, this.onChangeEvent, this);
  };

  _proto10.onStop = function onStop() {
    cc.systemEvent.off(cc.SystemEvent.EventType.DEVICEMOTION, this.onChangeEvent, this);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return leftOrRightAct;
}(_litegraph.LGraphNode); // Register the node type


leftOrRightAct.title = '重力感应'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/leftOrRightAct", leftOrRightAct); //第一个是唯一key，同时也是菜单选项路径

cc._RF.pop();