"use strict";
cc._RF.push(module, '6eb16Fh2EtBn4eRGrzPtnD0', 'BaseYwNode');
// Script/Common/LiteGraphCore/nodes/BaseYwNode.js

"use strict";

exports.__esModule = true;
exports.BaseYWNode = void 0;

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseYWNode = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(BaseYWNode, _LGraphNode);

  function BaseYWNode() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "自定义LGraphNode基础类";
    _this.desc = "其余LGraphNode继承于此";
    return _this;
  }

  var _proto = BaseYWNode.prototype;

  _proto.onAdded = function onAdded() {
    this.sendAddEvent();
  };

  _proto.onRemoved = function onRemoved() {
    this.sendRemoveEvent();
  };

  _proto.onSelected = function onSelected() {
    this.sendOtherEvent('onSelected');
  };

  _proto.onDeselected = function onDeselected() {
    this.sendOtherEvent('onDeselected');
  };

  _proto.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  };

  _proto.disconnectInput = function disconnectInput(slot, keepReroutes) {
    this.sendDisConnectEvent(slot, keepReroutes);

    _LGraphNode.prototype.disconnectInput.call(this, slot, keepReroutes);
  };

  _proto.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    this.sendPropertyChangeEvent(property, value, oldValue);
  } //graph每次直接发布就好了，现在的操作是对cocos节点的操作进行同步
  ;

  _proto.sendPropertyChangeEvent = function sendPropertyChangeEvent(property, value, oldValue) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          property: property,
          value: value
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onPropertyChanged',
          datas: datas
        });
      }
    }
  } //组件的按钮点击时同步事件
  ;

  _proto.sendBtnWidgetClickEvent = function sendBtnWidgetClickEvent(buttonName) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          buttonName: buttonName
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onBtnWidgetClick',
          datas: datas
        });
      }
    }
  } //发送移除事件
  ;

  _proto.sendRemoveEvent = function sendRemoveEvent() {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onRemove',
          datas: datas
        });
      }
    }
  } //发送开始连接
  ;

  _proto.sendConnectEvent = function sendConnectEvent(inputIndex, linkedNode, outputIndex) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          inputIndex: inputIndex,
          linkedNodeId: linkedNode.id,
          outputIndex: outputIndex
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onConnect',
          datas: datas
        });
      }
    }
  } //发送断开连接
  ;

  _proto.sendDisConnectEvent = function sendDisConnectEvent(slot, keepReroutes) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          slot: slot,
          keepReroutes: keepReroutes
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onDisConnect',
          datas: datas
        });
      }
    }
  } //发送添加事件
  ;

  _proto.sendAddEvent = function sendAddEvent() {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // this.widgets
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          type: this.type,
          params: this.properties
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onAdd',
          datas: datas
        });
      }
    }
  } //发送其它的事件
  ;

  _proto.sendOtherEvent = function sendOtherEvent(funcName, params) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送其它事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          funcName: funcName,
          params: params
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'justRunFunc',
          datas: datas
        });
      }
    }
  };

  _proto.onStart = function onStart() {
    this._hasShowTips = false;
  };

  _proto.oneClickCreateTouchTip = function oneClickCreateTouchTip() {
    // console.log('点击了关联触摸提示')
    //直接创建触摸提示节点，并且自动链接
    var tipsNode = _litegraph.LiteGraph.createNode('objects/createObject');

    tipsNode.setProperty('modal', 'spine'); // tipsNode.setProperty('customeName', '1f09b34a/Common_Click')

    tipsNode.setProperty('customeName', 'c7007391/Common_Click');
    tipsNode.setProperty('x', 0);
    tipsNode.setProperty('y', 0);
    tipsNode.setProperty('zIndex', 99);
    tipsNode.setProperty('premulAlpha', false);
    tipsNode.onWidgetChanged('物体类型');
    tipsNode.pos = [this.pos[0], this.pos[1] + this.height + 130];
    this.graph.add(tipsNode);
    var outputs = tipsNode.onGetOutputs();
    var lgraphNodeIndex = outputs.findIndex(function (item) {
      return item[1] == 'lgraphNode';
    });

    if (lgraphNodeIndex != -1) {
      tipsNode.addOutput(outputs[lgraphNodeIndex][0], outputs[lgraphNodeIndex][1]);
    } // this.connect(2, tipsNode, )


    tipsNode.connect(tipsNode.outputs.length - 1, this, 2); //同时创建动画节点

    var animateNode = _litegraph.LiteGraph.createNode('objects/animates/animate');

    animateNode.pos = [tipsNode.pos[0] + tipsNode.width + 3, tipsNode.pos[1]];
    animateNode.setProperty('loop', true);
    animateNode.setProperty('autoRun', true);
    this.graph.add(animateNode);
    tipsNode.connect(0, animateNode, 0);
    setTimeout(function () {
      animateNode.getEnums();
    }, 1000);
  };

  _proto.showClickTip = function showClickTip() {
    if (this._hasShowTips == true) {
      return;
    }

    if (this.properties.tipsJustOnce == true) {
      this._hasShowTips = true;
    }

    if (this.properties.canClickOutLine == true) {
      //可触摸时显示描边
      var codeNode = this.getInputData(0);

      if (codeNode != null) {
        codeNode.outLineWidth = 5;
      }
    }

    var soltIndex = this.findInputSlot('触摸提示');
    console.log('showClickTip', soltIndex);

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex); // console.log('linkTip', linkTip)

    if (linkTip != null) {
      if (linkTip.codeNode != null) {
        linkTip.codeNode.playAnimation('1Open', true);
      }
    }
  };

  _proto.hideClickTip = function hideClickTip() {
    if (this.properties.canClickOutLine == true) {
      //可触摸时显示描边
      var codeNode = this.getInputData(0);

      if (codeNode != null) {
        codeNode.outLineWidth = 0;
      }
    }

    var soltIndex = this.findInputSlot('触摸提示');

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex);

    if (linkTip != null) {
      // console.log('hideClickTip', linkTip.codeNode)
      if (linkTip.codeNode != null) {
        linkTip.codeNode.playAnimation('2Close', false);
      }
    }
  };

  _proto.playLinkSound = function playLinkSound() {
    var soltIndex = this.findInputSlot('关联音频');

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex);

    if (linkTip != null) {
      if (linkTip.onAction != null) {
        linkTip.onAction('播放');
      }
    }
  } //当前是否关联音频
  ;

  _proto.hasLinkSound = function hasLinkSound() {
    var soltIndex = this.findInputSlot('关联音频');

    if (soltIndex == -1) {
      return false;
    }

    return this.getInputLink(soltIndex) != null;
  } //当前是否关联音频是否播放结束
  ;

  _proto.hasLinkIsCanClick = function hasLinkIsCanClick() {
    var soltIndex = this.findInputSlot('isCanClick');

    if (soltIndex == -1) {
      return false;
    }

    return this.getInputLink(soltIndex) != null;
  } //移除一个propaty
  ;

  _proto.removeProperty = function removeProperty(key) {
    // console.log('removeProperty key', key)
    if (this.properties_info == null) {
      this.properties_info = [];
    }

    var index = this.properties_info.findIndex(function (item) {
      return item.name == key;
    });
    this.properties_info.splice(index, 1);

    if (this.properties == null) {
      this.properties = {};
    }

    delete this.properties[key];
  };

  return BaseYWNode;
}(_litegraph.LGraphNode);

exports.BaseYWNode = BaseYWNode;

cc._RF.pop();