
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/Script/Common/Bezier/bezier');
require('./assets/Script/Common/Bezier/bezierUtils');
require('./assets/Script/Common/Bezier/poly-bezier');
require('./assets/Script/Common/LiteGraphCore/AngleCompoment');
require('./assets/Script/Common/LiteGraphCore/AutoTips');
require('./assets/Script/Common/LiteGraphCore/CocosMgr');
require('./assets/Script/Common/LiteGraphCore/CodeNodeLg');
require('./assets/Script/Common/LiteGraphCore/MotionText');
require('./assets/Script/Common/LiteGraphCore/RegisterNodeType');
require('./assets/Script/Common/LiteGraphCore/ScaleObj');
require('./assets/Script/Common/LiteGraphCore/SpinePlusComponent');
require('./assets/Script/Common/LiteGraphCore/nodes/BaseYwNode');
require('./assets/Script/Common/LiteGraphCore/nodes/customComponent');
require('./assets/Script/Common/LiteGraphCore/nodes/dataNode');
require('./assets/Script/Common/LiteGraphCore/nodes/games');
require('./assets/Script/Common/LiteGraphCore/nodes/graphExtension');
require('./assets/Script/Common/LiteGraphCore/nodes/input');
require('./assets/Script/Common/LiteGraphCore/nodes/middle');
require('./assets/Script/Common/LiteGraphCore/nodes/objects');
require('./assets/Script/Common/LiteGraphCore/nodes/output');
require('./assets/Script/Common/LiteGraphCore/nodes/senser');
require('./assets/Script/Common/litegraph/litegraph');
require('./assets/Script/LiteGraphScene');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/litegraph/litegraph.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (process){
"use strict";
cc._RF.push(module, '745aabBaMpCxr953mbUOBfj', 'litegraph');
// Script/Common/litegraph/litegraph.ts

"use strict";
//packer version
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LGraphNode = exports.LGraph = exports.LiteGraph = void 0;
// *************************************************************
//   LiteGraph CLASS                                     *******
// *************************************************************
/**
 * The Global Scope. It contains all the registered node classes.
 *
 * @class LiteGraph
 * @constructor
 */
exports.LiteGraph = {
    VERSION: 0.4,
    CANVAS_GRID_SIZE: 10,
    NODE_TITLE_HEIGHT: 30,
    NODE_TITLE_TEXT_Y: 20,
    NODE_SLOT_HEIGHT: 20,
    NODE_WIDGET_HEIGHT: 20,
    NODE_WIDTH: 140,
    NODE_MIN_WIDTH: 50,
    NODE_COLLAPSED_RADIUS: 10,
    NODE_COLLAPSED_WIDTH: 80,
    NODE_TITLE_COLOR: "#999",
    NODE_SELECTED_TITLE_COLOR: "#FFF",
    NODE_TEXT_SIZE: 14,
    NODE_TEXT_COLOR: "#AAA",
    NODE_SUBTEXT_SIZE: 12,
    NODE_DEFAULT_COLOR: "#333",
    NODE_DEFAULT_BGCOLOR: "#353535",
    NODE_DEFAULT_BOXCOLOR: "#666",
    NODE_DEFAULT_SHAPE: "box",
    NODE_BOX_OUTLINE_COLOR: "#FFF",
    DEFAULT_SHADOW_COLOR: "rgba(0,0,0,0.5)",
    DEFAULT_GROUP_FONT: 24,
    WIDGET_BGCOLOR: "#222",
    WIDGET_OUTLINE_COLOR: "#666",
    WIDGET_TEXT_COLOR: "#DDD",
    WIDGET_SECONDARY_TEXT_COLOR: "#999",
    LINK_COLOR: "#9A9",
    EVENT_LINK_COLOR: "#A86",
    CONNECTING_LINK_COLOR: "#AFA",
    MAX_NUMBER_OF_NODES: 1000,
    DEFAULT_POSITION: [100, 100],
    VALID_SHAPES: ["default", "box", "round", "card"],
    //shapes are used for nodes but also for slots
    BOX_SHAPE: 1,
    ROUND_SHAPE: 2,
    CIRCLE_SHAPE: 3,
    CARD_SHAPE: 4,
    ARROW_SHAPE: 5,
    GRID_SHAPE: 6,
    //enums
    INPUT: 1,
    OUTPUT: 2,
    EVENT: -1,
    ACTION: -1,
    NODE_MODES: ["Always", "On Event", "Never", "On Trigger"],
    NODE_MODES_COLORS: ["#666", "#422", "#333", "#224", "#626"],
    ALWAYS: 0,
    ON_EVENT: 1,
    NEVER: 2,
    ON_TRIGGER: 3,
    UP: 1,
    DOWN: 2,
    LEFT: 3,
    RIGHT: 4,
    CENTER: 5,
    LINK_RENDER_MODES: ["Straight", "Linear", "Spline"],
    STRAIGHT_LINK: 0,
    LINEAR_LINK: 1,
    SPLINE_LINK: 2,
    NORMAL_TITLE: 0,
    NO_TITLE: 1,
    TRANSPARENT_TITLE: 2,
    AUTOHIDE_TITLE: 3,
    VERTICAL_LAYOUT: "vertical",
    proxy: null,
    node_images_path: "",
    debug: true,
    catch_exceptions: true,
    throw_errors: true,
    allow_scripts: false,
    use_deferred_actions: true,
    registered_node_types: {},
    node_types_by_file_extension: {},
    Nodes: {},
    Globals: {},
    searchbox_extras: {},
    auto_sort_node_types: false,
    node_box_coloured_when_on: false,
    node_box_coloured_by_mode: false,
    dialog_close_on_mouse_leave: true,
    dialog_close_on_mouse_leave_delay: 500,
    shift_click_do_break_link_from: false,
    click_do_break_link_to: false,
    search_hide_on_mouse_leave: true,
    search_filter_enabled: false,
    search_show_all_on_open: true,
    auto_load_slot_types: false,
    // set these values if not using auto_load_slot_types
    registered_slot_in_types: {},
    registered_slot_out_types: {},
    slot_types_in: [],
    slot_types_out: [],
    slot_types_default_in: [],
    slot_types_default_out: [],
    alt_drag_do_clone_nodes: false,
    do_add_triggers_slots: false,
    allow_multi_output_for_events: true,
    middle_click_slot_add_default_node: false,
    release_link_on_empty_shows_menu: false,
    pointerevents_method: "mouse",
    // TODO implement pointercancel, gotpointercapture, lostpointercapture, (pointerover, pointerout if necessary)
    ctrl_shift_v_paste_connect_unselected_outputs: false,
    // if true, all newly created nodes/links will use string UUIDs for their id fields instead of integers.
    // use this if you must have node IDs that are unique across all graphs and subgraphs.
    use_uuids: false,
    /**
     * Register a node class so it can be listed when the user wants to create a new one
     * @method registerNodeType
     * @param {String} type name of the node and path
     * @param {Class} base_class class containing the structure of a node
     */
    registerNodeType: function (type, base_class) {
        if (!base_class.prototype) {
            throw "Cannot register a simple object, it must be a class with a prototype";
        }
        base_class.type = type;
        if (exports.LiteGraph.debug) {
            console.log("Node registered: " + type);
        }
        var classname = base_class.name;
        var pos = type.lastIndexOf("/");
        base_class.category = type.substring(0, pos);
        if (!base_class.title) {
            base_class.title = classname;
        }
        //extend class
        for (var i in LGraphNode.prototype) {
            if (!base_class.prototype[i]) {
                base_class.prototype[i] = LGraphNode.prototype[i];
            }
        }
        var prev = this.registered_node_types[type];
        if (prev) {
            console.log("replacing node type: " + type);
        }
        if (!Object.prototype.hasOwnProperty.call(base_class.prototype, "shape")) {
            Object.defineProperty(base_class.prototype, "shape", {
                set: function (v) {
                    switch (v) {
                        case "default":
                            delete this._shape;
                            break;
                        case "box":
                            this._shape = exports.LiteGraph.BOX_SHAPE;
                            break;
                        case "round":
                            this._shape = exports.LiteGraph.ROUND_SHAPE;
                            break;
                        case "circle":
                            this._shape = exports.LiteGraph.CIRCLE_SHAPE;
                            break;
                        case "card":
                            this._shape = exports.LiteGraph.CARD_SHAPE;
                            break;
                        default:
                            this._shape = v;
                    }
                },
                get: function () {
                    return this._shape;
                },
                enumerable: true,
                configurable: true
            });
            //used to know which nodes to create when dragging files to the canvas
            if (base_class.supported_extensions) {
                for (var i_1 in base_class.supported_extensions) {
                    var ext = base_class.supported_extensions[i_1];
                    if (ext && ext.constructor === String) {
                        this.node_types_by_file_extension[ext.toLowerCase()] = base_class;
                    }
                }
            }
        }
        this.registered_node_types[type] = base_class;
        if (base_class.constructor.name) {
            this.Nodes[classname] = base_class;
        }
        if (exports.LiteGraph.onNodeTypeRegistered) {
            exports.LiteGraph.onNodeTypeRegistered(type, base_class);
        }
        if (prev && exports.LiteGraph.onNodeTypeReplaced) {
            exports.LiteGraph.onNodeTypeReplaced(type, base_class, prev);
        }
        //warnings
        if (base_class.prototype.onPropertyChange) {
            console.warn("LiteGraph node class " +
                type +
                " has onPropertyChange method, it must be called onPropertyChanged with d at the end");
        }
        // TODO one would want to know input and ouput :: this would allow through registerNodeAndSlotType to get all the slots types
        if (this.auto_load_slot_types) {
            new base_class(base_class.title || "tmpnode");
        }
    },
    /**
     * removes a node type from the system
     * @method unregisterNodeType
     * @param {String|Object} type name of the node or the node constructor itself
     */
    unregisterNodeType: function (type) {
        var base_class = type.constructor === String
            ? this.registered_node_types[type]
            : type;
        if (!base_class) {
            throw "node type not found: " + type;
        }
        delete this.registered_node_types[base_class.type];
        if (base_class.constructor.name) {
            delete this.Nodes[base_class.constructor.name];
        }
    },
    /**
    * Save a slot type and his node
    * @method registerSlotType
    * @param {String|Object} type name of the node or the node constructor itself
    * @param {String} slot_type name of the slot type (variable type), eg. string, number, array, boolean, ..
    */
    registerNodeAndSlotType: function (type, slot_type, out) {
        out = out || false;
        var base_class = type.constructor === String &&
            this.registered_node_types[type] !== "anonymous"
            ? this.registered_node_types[type]
            : type;
        var class_type = base_class.constructor.type;
        var allTypes = [];
        if (typeof slot_type === "string") {
            allTypes = slot_type.split(",");
        }
        else if (slot_type == this.EVENT || slot_type == this.ACTION) {
            allTypes = ["_event_"];
        }
        else {
            allTypes = ["*"];
        }
        for (var i = 0; i < allTypes.length; ++i) {
            var slotType = allTypes[i];
            if (slotType === "") {
                slotType = "*";
            }
            var registerTo = out
                ? "registered_slot_out_types"
                : "registered_slot_in_types";
            if (this[registerTo][slotType] === undefined) {
                this[registerTo][slotType] = { nodes: [] };
            }
            if (!this[registerTo][slotType].nodes.includes(class_type)) {
                this[registerTo][slotType].nodes.push(class_type);
            }
            // check if is a new type
            if (!out) {
                if (!this.slot_types_in.includes(slotType.toLowerCase())) {
                    this.slot_types_in.push(slotType.toLowerCase());
                    this.slot_types_in.sort();
                }
            }
            else {
                if (!this.slot_types_out.includes(slotType.toLowerCase())) {
                    this.slot_types_out.push(slotType.toLowerCase());
                    this.slot_types_out.sort();
                }
            }
        }
    },
    /**
     * Create a new nodetype by passing an object with some properties
     * like onCreate, inputs:Array, outputs:Array, properties, onExecute
     * @method buildNodeClassFromObject
     * @param {String} name node name with namespace (p.e.: 'math/sum')
     * @param {Object} object methods expected onCreate, inputs, outputs, properties, onExecute
     */
    buildNodeClassFromObject: function (name, object) {
        var ctor_code = "";
        if (object.inputs)
            for (var i = 0; i < object.inputs.length; ++i) {
                var _name = object.inputs[i][0];
                var _type = object.inputs[i][1];
                if (_type && _type.constructor === String)
                    _type = '"' + _type + '"';
                ctor_code += "this.addInput('" + _name + "'," + _type + ");\n";
            }
        if (object.outputs)
            for (var i = 0; i < object.outputs.length; ++i) {
                var _name = object.outputs[i][0];
                var _type = object.outputs[i][1];
                if (_type && _type.constructor === String)
                    _type = '"' + _type + '"';
                ctor_code += "this.addOutput('" + _name + "'," + _type + ");\n";
            }
        if (object.properties)
            for (var i in object.properties) {
                var prop = object.properties[i];
                if (prop && prop.constructor === String)
                    prop = '"' + prop + '"';
                ctor_code += "this.addProperty('" + i + "'," + prop + ");\n";
            }
        ctor_code += "if(this.onCreate)this.onCreate()";
        var classobj = Function(ctor_code);
        for (var i in object)
            if (i != "inputs" && i != "outputs" && i != "properties")
                classobj.prototype[i] = object[i];
        classobj.title = object.title || name.split("/").pop();
        classobj.desc = object.desc || "Generated from object";
        this.registerNodeType(name, classobj);
        return classobj;
    },
    /**
     * Create a new nodetype by passing a function, it wraps it with a proper class and generates inputs according to the parameters of the function.
     * Useful to wrap simple methods that do not require properties, and that only process some input to generate an output.
     * @method wrapFunctionAsNode
     * @param {String} name node name with namespace (p.e.: 'math/sum')
     * @param {Function} func
     * @param {Array} param_types [optional] an array containing the type of every parameter, otherwise parameters will accept any type
     * @param {String} return_type [optional] string with the return type, otherwise it will be generic
     * @param {Object} properties [optional] properties to be configurable
     */
    wrapFunctionAsNode: function (name, func, param_types, return_type, properties) {
        var params = Array(func.length);
        var code = "";
        if (param_types !== null) //null means no inputs
         {
            var names = exports.LiteGraph.getParameterNames(func);
            for (var i = 0; i < names.length; ++i) {
                var type = 0;
                if (param_types) {
                    //type = param_types[i] != null ? "'" + param_types[i] + "'" : "0";
                    if (param_types[i] != null && param_types[i].constructor === String)
                        type = "'" + param_types[i] + "'";
                    else if (param_types[i] != null)
                        type = param_types[i];
                }
                code +=
                    "this.addInput('" +
                        names[i] +
                        "'," +
                        type +
                        ");\n";
            }
        }
        if (return_type !== null) //null means no output
            code +=
                "this.addOutput('out'," +
                    (return_type != null ? (return_type.constructor === String ? "'" + return_type + "'" : return_type) : 0) +
                    ");\n";
        if (properties) {
            code +=
                "this.properties = " + JSON.stringify(properties) + ";\n";
        }
        var classobj = Function(code);
        classobj.title = name.split("/").pop();
        classobj.desc = "Generated from " + func.name;
        classobj.prototype.onExecute = function onExecute() {
            for (var i = 0; i < params.length; ++i) {
                params[i] = this.getInputData(i);
            }
            var r = func.apply(this, params);
            this.setOutputData(0, r);
        };
        this.registerNodeType(name, classobj);
        return classobj;
    },
    /**
     * Removes all previously registered node's types
     */
    clearRegisteredTypes: function () {
        this.registered_node_types = {};
        this.node_types_by_file_extension = {};
        this.Nodes = {};
        this.searchbox_extras = {};
    },
    /**
     * Adds this method to all nodetypes, existing and to be created
     * (You can add it to LGraphNode.prototype but then existing node types wont have it)
     * @method addNodeMethod
     * @param {Function} func
     */
    addNodeMethod: function (name, func) {
        LGraphNode.prototype[name] = func;
        for (var i in this.registered_node_types) {
            var type = this.registered_node_types[i];
            if (type.prototype[name]) {
                type.prototype["_" + name] = type.prototype[name];
            } //keep old in case of replacing
            type.prototype[name] = func;
        }
    },
    /**
     * Create a node of a given type with a name. The node is not attached to any graph yet.
     * @method createNode
     * @param {String} type full name of the node class. p.e. "math/sin"
     * @param {String} name a name to distinguish from other nodes
     * @param {Object} options to set options
     */
    createNode: function (type, title, options) {
        var base_class = this.registered_node_types[type];
        if (!base_class) {
            if (exports.LiteGraph.debug) {
                console.log('GraphNode type "' + type + '" not registered.');
            }
            return null;
        }
        var prototype = base_class.prototype || base_class;
        title = title || base_class.title || type;
        var node = null;
        if (exports.LiteGraph.catch_exceptions) {
            try {
                node = new base_class(title);
            }
            catch (err) {
                console.error(err);
                return null;
            }
        }
        else {
            node = new base_class(title);
        }
        node.type = type;
        if (!node.title && title) {
            node.title = title;
        }
        if (!node.properties) {
            node.properties = {};
        }
        if (!node.properties_info) {
            node.properties_info = [];
        }
        if (!node.flags) {
            node.flags = {};
        }
        if (!node.size) {
            node.size = node.computeSize();
            //call onresize?
        }
        if (!node.pos) {
            node.pos = exports.LiteGraph.DEFAULT_POSITION.concat();
        }
        if (!node.mode) {
            node.mode = exports.LiteGraph.ALWAYS;
        }
        //extra options
        if (options) {
            for (var i in options) {
                node[i] = options[i];
            }
        }
        // callback
        if (node.onNodeCreated) {
            node.onNodeCreated();
        }
        return node;
    },
    /**
     * Returns a registered node type with a given name
     * @method getNodeType
     * @param {String} type full name of the node class. p.e. "math/sin"
     * @return {Class} the node class
     */
    getNodeType: function (type) {
        return this.registered_node_types[type];
    },
    /**
     * Returns a list of node types matching one category
     * @method getNodeType
     * @param {String} category category name
     * @return {Array} array with all the node classes
     */
    getNodeTypesInCategory: function (category, filter) {
        var r = [];
        for (var i in this.registered_node_types) {
            var type = this.registered_node_types[i];
            if (type.filter != filter) {
                continue;
            }
            if (category == "") {
                if (type.category == null) {
                    r.push(type);
                }
            }
            else if (type.category == category) {
                r.push(type);
            }
        }
        if (this.auto_sort_node_types) {
            r.sort(function (a, b) { return a.title.localeCompare(b.title); });
        }
        return r;
    },
    /**
     * Returns a list with all the node type categories
     * @method getNodeTypesCategories
     * @param {String} filter only nodes with ctor.filter equal can be shown
     * @return {Array} array with all the names of the categories
     */
    getNodeTypesCategories: function (filter) {
        var categories = { "": 1 };
        for (var i in this.registered_node_types) {
            var type = this.registered_node_types[i];
            if (type.category && !type.skip_list) {
                if (type.filter != filter)
                    continue;
                categories[type.category] = 1;
            }
        }
        var result = [];
        for (var i in categories) {
            result.push(i);
        }
        return this.auto_sort_node_types ? result.sort() : result;
    },
    //debug purposes: reloads all the js scripts that matches a wildcard
    reloadNodes: function (folder_wildcard) {
        var tmp = document.getElementsByTagName("script");
        //weird, this array changes by its own, so we use a copy
        var script_files = [];
        for (var i = 0; i < tmp.length; i++) {
            script_files.push(tmp[i]);
        }
        var docHeadObj = document.getElementsByTagName("head")[0];
        folder_wildcard = document.location.href + folder_wildcard;
        for (var i = 0; i < script_files.length; i++) {
            var src = script_files[i].src;
            if (!src ||
                src.substr(0, folder_wildcard.length) != folder_wildcard) {
                continue;
            }
            try {
                if (exports.LiteGraph.debug) {
                    console.log("Reloading: " + src);
                }
                var dynamicScript = document.createElement("script");
                dynamicScript.type = "text/javascript";
                dynamicScript.src = src;
                docHeadObj.appendChild(dynamicScript);
                docHeadObj.removeChild(script_files[i]);
            }
            catch (err) {
                if (exports.LiteGraph.throw_errors) {
                    throw err;
                }
                if (exports.LiteGraph.debug) {
                    console.log("Error while reloading " + src);
                }
            }
        }
        if (exports.LiteGraph.debug) {
            console.log("Nodes reloaded");
        }
    },
    //separated just to improve if it doesn't work
    cloneObject: function (obj, target) {
        if (obj == null) {
            return null;
        }
        var r = JSON.parse(JSON.stringify(obj));
        if (!target) {
            return r;
        }
        for (var i in r) {
            target[i] = r[i];
        }
        return target;
    },
    /*
     * https://gist.github.com/jed/982883?permalink_comment_id=852670#gistcomment-852670
     */
    uuidv4: function () {
        return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, function (a) { return (a ^ Math.random() * 16 >> a / 4).toString(16); });
    },
    /**
     * Returns if the types of two slots are compatible (taking into account wildcards, etc)
     * @method isValidConnection
     * @param {String} type_a
     * @param {String} type_b
     * @return {Boolean} true if they can be connected
     */
    isValidConnection: function (type_a, type_b) {
        if (type_a == "" || type_a === "*")
            type_a = 0;
        if (type_b == "" || type_b === "*")
            type_b = 0;
        if (!type_a //generic output
            || !type_b // generic input
            || type_a == type_b //same type (is valid for triggers)
            || (type_a == exports.LiteGraph.EVENT && type_b == exports.LiteGraph.ACTION)) {
            return true;
        }
        // Enforce string type to handle toLowerCase call (-1 number not ok)
        type_a = String(type_a);
        type_b = String(type_b);
        type_a = type_a.toLowerCase();
        type_b = type_b.toLowerCase();
        // For nodes supporting multiple connection types
        if (type_a.indexOf(",") == -1 && type_b.indexOf(",") == -1) {
            return type_a == type_b;
        }
        // Check all permutations to see if one is valid
        var supported_types_a = type_a.split(",");
        var supported_types_b = type_b.split(",");
        for (var i = 0; i < supported_types_a.length; ++i) {
            for (var j = 0; j < supported_types_b.length; ++j) {
                if (this.isValidConnection(supported_types_a[i], supported_types_b[j])) {
                    //if (supported_types_a[i] == supported_types_b[j]) {
                    return true;
                }
            }
        }
        return false;
    },
    /**
     * Register a string in the search box so when the user types it it will recommend this node
     * @method registerSearchboxExtra
     * @param {String} node_type the node recommended
     * @param {String} description text to show next to it
     * @param {Object} data it could contain info of how the node should be configured
     * @return {Boolean} true if they can be connected
     */
    registerSearchboxExtra: function (node_type, description, data) {
        this.searchbox_extras[description.toLowerCase()] = {
            type: node_type,
            desc: description,
            data: data
        };
    },
    /**
     * Wrapper to load files (from url using fetch or from file using FileReader)
     * @method fetchFile
     * @param {String|File|Blob} url the url of the file (or the file itself)
     * @param {String} type an string to know how to fetch it: "text","arraybuffer","json","blob"
     * @param {Function} on_complete callback(data)
     * @param {Function} on_error in case of an error
     * @return {FileReader|Promise} returns the object used to
     */
    fetchFile: function (url, type, on_complete, on_error) {
        var that = this;
        if (!url)
            return null;
        type = type || "text";
        if (url.constructor === String) {
            if (url.substr(0, 4) == "http" && exports.LiteGraph.proxy) {
                url = exports.LiteGraph.proxy + url.substr(url.indexOf(":") + 3);
            }
            return fetch(url)
                .then(function (response) {
                if (!response.ok)
                    throw new Error("File not found"); //it will be catch below
                if (type == "arraybuffer")
                    return response.arrayBuffer();
                else if (type == "text" || type == "string")
                    return response.text();
                else if (type == "json")
                    return response.json();
                else if (type == "blob")
                    return response.blob();
            })
                .then(function (data) {
                if (on_complete)
                    on_complete(data);
            })
                .catch(function (error) {
                console.error("error fetching file:", url);
                if (on_error)
                    on_error(error);
            });
        }
        else if (url.constructor === File || url.constructor === Blob) {
            var reader = new FileReader();
            reader.onload = function (e) {
                var v = e.target.result;
                if (type == "json")
                    v = JSON.parse(v);
                if (on_complete)
                    on_complete(v);
            };
            if (type == "arraybuffer")
                return reader.readAsArrayBuffer(url);
            else if (type == "text" || type == "json")
                return reader.readAsText(url);
            else if (type == "blob")
                return reader.readAsBinaryString(url);
        }
        return null;
    }
};
// (global.LiteGraph = 
//timer that works everywhere
if (typeof performance != "undefined") {
    exports.LiteGraph.getTime = performance.now.bind(performance);
}
else if (typeof Date != "undefined" && Date.now) {
    exports.LiteGraph.getTime = Date.now.bind(Date);
}
else if (typeof process != "undefined") {
    exports.LiteGraph.getTime = function () {
        var t = process.hrtime();
        return t[0] * 0.001 + t[1] * 1e-6;
    };
}
else {
    exports.LiteGraph.getTime = function getTime() {
        return new Date().getTime();
    };
}
//*********************************************************************************
// LGraph CLASS
//*********************************************************************************
/**
 * LGraph is the class that contain a full graph. We instantiate one and add nodes to it, and then we can run the execution loop.
 * supported callbacks:
    + onNodeAdded: when a new node is added to the graph
    + onNodeRemoved: when a node inside this graph is removed
    + onNodeConnectionChange: some connection has changed in the graph (connected or disconnected)
 *
 * @class LGraph
 * @constructor
 * @param {Object} o data from previous serialization [optional]
 */
var LGraph = /** @class */ (function () {
    function LGraph(o) {
        if (exports.LiteGraph.debug) {
            console.log("Graph created");
        }
        this.list_of_graphcanvas = null;
        this.clear();
        if (o) {
            this.configure(o);
        }
    }
    return LGraph;
}());
exports.LGraph = LGraph;
// global.LGraph = LiteGraph.LGraph = LGraph;
//default supported types
LGraph.supported_types = ["number", "string", "boolean"];
//used to know which types of connections support this graph (some graphs do not allow certain types)
LGraph.prototype.getSupportedTypes = function () {
    return this.supported_types || LGraph.supported_types;
};
LGraph.STATUS_STOPPED = 1;
LGraph.STATUS_RUNNING = 2;
/**
 * Removes all nodes from this graph
 * @method clear
 */
LGraph.prototype.clear = function () {
    this.stop();
    this.status = LGraph.STATUS_STOPPED;
    this.last_node_id = 0;
    this.last_link_id = 0;
    this._version = -1; //used to detect changes
    //safe clear
    if (this._nodes) {
        for (var i = 0; i < this._nodes.length; ++i) {
            var node = this._nodes[i];
            if (node.onRemoved) {
                node.onRemoved();
            }
        }
    }
    //nodes
    this._nodes = [];
    this._nodes_by_id = {};
    this._nodes_in_order = []; //nodes sorted in execution order
    this._nodes_executable = null; //nodes that contain onExecute sorted in execution order
    //other scene stuff
    this._groups = [];
    //links
    this.links = {}; //container with all the links
    //iterations
    this.iteration = 0;
    //custom data
    this.config = {};
    this.vars = {};
    this.extra = {}; //to store custom data
    //timing
    this.globaltime = 0;
    this.runningtime = 0;
    this.fixedtime = 0;
    this.fixedtime_lapse = 0.01;
    this.elapsed_time = 0.01;
    this.last_update_time = 0;
    this.starttime = 0;
    this.catch_errors = true;
    this.nodes_executing = [];
    this.nodes_actioning = [];
    this.nodes_executedAction = [];
    //subgraph_data
    this.inputs = {};
    this.outputs = {};
    //notify canvas to redraw
    this.change();
    this.sendActionToCanvas("clear");
};
/**
 * Attach Canvas to this graph
 * @method attachCanvas
 * @param {GraphCanvas} graph_canvas
 */
LGraph.prototype.attachCanvas = function (graphcanvas) {
    if (graphcanvas.constructor != LGraphCanvas) {
        throw "attachCanvas expects a LGraphCanvas instance";
    }
    if (graphcanvas.graph && graphcanvas.graph != this) {
        graphcanvas.graph.detachCanvas(graphcanvas);
    }
    graphcanvas.graph = this;
    if (!this.list_of_graphcanvas) {
        this.list_of_graphcanvas = [];
    }
    this.list_of_graphcanvas.push(graphcanvas);
};
/**
 * Detach Canvas from this graph
 * @method detachCanvas
 * @param {GraphCanvas} graph_canvas
 */
LGraph.prototype.detachCanvas = function (graphcanvas) {
    if (!this.list_of_graphcanvas) {
        return;
    }
    var pos = this.list_of_graphcanvas.indexOf(graphcanvas);
    if (pos == -1) {
        return;
    }
    graphcanvas.graph = null;
    this.list_of_graphcanvas.splice(pos, 1);
};
/**
 * Starts running this graph every interval milliseconds.
 * @method start
 * @param {number} interval amount of milliseconds between executions, if 0 then it renders to the monitor refresh rate
 */
LGraph.prototype.startLoadComplete = function () {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    // var count = 0
                    // var check = ()=>{
                    //     count += 1
                    //     if(this.config.assestTotal == this.config.assestLoaded){
                    //         console.log('所有资源都加载好了', this.config.assestTotal)
                    //         resolve(true)
                    //     }else{
                    //         if(count > 10000){
                    //             reject('等待节点加载资源超时')
                    //         }else{
                    //             setTimeout(check, 10);
                    //         }
                    //     }
                    // }
                    // check()
                    _this.checkAssestLoadComplete = function () {
                        if (_this.config.assestTotal == _this.config.assestLoaded) {
                            console.log('所有资源都加载好了', _this.config.assestTotal);
                            _this.checkAssestLoadComplete = null;
                            resolve(true);
                        }
                    };
                })];
        });
    });
};
LGraph.prototype.init = function (interval) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    this.config.assestTotal = 0; //资源需要加载的数量
                    this.config.assestLoaded = 0; //资源已经加载的数量
                    this.config.audioArray = {}; //当前正在播放的音轨
                    this.config.inPause = false; //当前暂停播放
                    this.sendEventToAllNodes("onStartBeforeLoad");
                    if (!(this.config.assestTotal != this.config.assestLoaded)) return [3 /*break*/, 2];
                    return [4 /*yield*/, this.startLoadComplete()];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2: return [2 /*return*/];
            }
        });
    });
};
LGraph.prototype.start = function (interval) {
    return __awaiter(this, void 0, void 0, function () {
        var that;
        return __generator(this, function (_a) {
            if (this.status == LGraph.STATUS_RUNNING) {
                return [2 /*return*/];
            }
            this.status = LGraph.STATUS_RUNNING;
            // this.config.assestTotal = 0 //资源需要加载的数量
            // this.config.assestLoaded = 0  //资源已经加载的数量
            // this.config.audioArray = {}  //当前正在播放的音轨
            // this.config.inPause = false  //当前暂停播放
            // this.sendEventToAllNodes("onStartBeforeLoad")
            // if(this.config.assestTotal != this.config.assestLoaded){
            //     await this.startLoadComplete()
            // }
            this.sendEventToAllNodes("onStart");
            if (this.onPlayEvent) {
                this.onPlayEvent();
            }
            //launch
            this.starttime = exports.LiteGraph.getTime();
            this.last_update_time = this.starttime;
            interval = interval || 0;
            that = this;
            //execute once per frame
            if (interval == 0 && typeof window != "undefined" && window.requestAnimationFrame) {
                function on_frame() {
                    if (that.execution_timer_id != -1) {
                        return;
                    }
                    if (that.config.inPause == true) {
                        return;
                    }
                    window.requestAnimationFrame(on_frame);
                    if (that.onBeforeStep)
                        that.onBeforeStep();
                    that.runStep(1, !that.catch_errors);
                    if (that.onAfterStep)
                        that.onAfterStep();
                }
                this.execution_timer_id = -1;
                on_frame();
            }
            else { //execute every 'interval' ms
                this.execution_timer_id = setInterval(function () {
                    //execute
                    if (that.config.inPause == true) {
                        return;
                    }
                    if (that.onBeforeStep)
                        that.onBeforeStep();
                    that.runStep(1, !that.catch_errors);
                    if (that.onAfterStep)
                        that.onAfterStep();
                }, interval);
            }
            return [2 /*return*/];
        });
    });
};
//暂停执行
LGraph.prototype.pause = function () {
    this.sendEventToAllNodes("onPause");
};
//恢复执行
LGraph.prototype.resume = function () {
    this.sendEventToAllNodes("onResume");
};
/**
 * Stops the execution loop of the graph
 * @method stop execution
 */
LGraph.prototype.stop = function () {
    if (this.status == LGraph.STATUS_STOPPED) {
        return;
    }
    this.status = LGraph.STATUS_STOPPED;
    if (this.onStopEvent) {
        this.onStopEvent();
    }
    if (this.execution_timer_id != null) {
        if (this.execution_timer_id != -1) {
            clearInterval(this.execution_timer_id);
        }
        this.execution_timer_id = null;
    }
    this.sendEventToAllNodes("onStop");
};
//以下是为cocos新增方法
LGraph.prototype.playSounds = function (arr, cb, yinggui) {
    var firstRobot;
    var robotArr = [];
    for (var i = 0; i < arr.length; i++) {
        // var config = StaticValue.clone(StaticValue.zhilinConfig['sound'])
        var robot = exports.LiteGraph.createNode('output/sound'); // new ['soundRobot'](config)
        this.add(robot);
        // robot.codeProgress = graph
        // robot.config.otherConfig.customeName.default = arr[i]
        robot.setProperty('customeName', arr[i]);
        if (yinggui != null) {
            robot.setProperty('yinggui', yinggui);
        }
        // robot.robotInit()
        if (i == 0) {
            firstRobot = robot;
        }
        robotArr.push(robot);
        // this.robots.push(robot)
    }
    for (var i = 0; i < robotArr.length; i++) {
        var robot = robotArr[i];
        var nextRobot = robotArr[i + 1];
        // if(nextRobot == null){
        //     nextRobot = {inputHandle: cb}
        // }
        if (nextRobot != null) {
            robot.connect(0, nextRobot, 0); //linkDatas = {outputSolt: {'number1': [{robot: nextRobot}]}}
        }
        else {
            robot.playEndCb = cb;
        }
    }
    if (firstRobot != null) {
        firstRobot.onAction('播放');
    }
};
/**
 * Run N steps (cycles) of the graph
 * @method runStep
 * @param {number} num number of steps to run, default is 1
 * @param {Boolean} do_not_catch_errors [optional] if you want to try/catch errors
 * @param {number} limit max number of nodes to execute (used to execute from start to a node)
 */
LGraph.prototype.runStep = function (num, do_not_catch_errors, limit) {
    num = num || 1;
    var start = exports.LiteGraph.getTime();
    this.globaltime = 0.001 * (start - this.starttime);
    //not optimal: executes possible pending actions in node, problem is it is not optimized
    //it is done here as if it was done in the later loop it wont be called in the node missed the onExecute
    //from now on it will iterate only on executable nodes which is faster
    var nodes = this._nodes_executable
        ? this._nodes_executable
        : this._nodes;
    if (!nodes) {
        return;
    }
    limit = limit || nodes.length;
    if (do_not_catch_errors) {
        //iterations
        for (var i = 0; i < num; i++) {
            for (var j = 0; j < limit; ++j) {
                var node = nodes[j];
                if (exports.LiteGraph.use_deferred_actions && node._waiting_actions && node._waiting_actions.length)
                    node.executePendingActions();
                if (node.mode == exports.LiteGraph.ALWAYS && node.onExecute) {
                    //wrap node.onExecute();
                    node.doExecute();
                }
            }
            this.fixedtime += this.fixedtime_lapse;
            if (this.onExecuteStep) {
                this.onExecuteStep();
            }
        }
        if (this.onAfterExecute) {
            this.onAfterExecute();
        }
    }
    else { //catch errors
        try {
            //iterations
            for (var i = 0; i < num; i++) {
                for (var j = 0; j < limit; ++j) {
                    var node = nodes[j];
                    if (exports.LiteGraph.use_deferred_actions && node._waiting_actions && node._waiting_actions.length)
                        node.executePendingActions();
                    if (node.mode == exports.LiteGraph.ALWAYS && node.onExecute) {
                        node.onExecute();
                    }
                }
                this.fixedtime += this.fixedtime_lapse;
                if (this.onExecuteStep) {
                    this.onExecuteStep();
                }
            }
            if (this.onAfterExecute) {
                this.onAfterExecute();
            }
            this.errors_in_execution = false;
        }
        catch (err) {
            this.errors_in_execution = true;
            if (exports.LiteGraph.throw_errors) {
                throw err;
            }
            if (exports.LiteGraph.debug) {
                console.log("Error during execution: " + err);
            }
            this.stop();
        }
    }
    var now = exports.LiteGraph.getTime();
    var elapsed = now - start;
    if (elapsed == 0) {
        elapsed = 1;
    }
    this.execution_time = 0.001 * elapsed;
    this.globaltime += 0.001 * elapsed;
    this.iteration += 1;
    this.elapsed_time = (now - this.last_update_time) * 0.001;
    this.last_update_time = now;
    this.nodes_executing = [];
    this.nodes_actioning = [];
    this.nodes_executedAction = [];
};
/**
 * Updates the graph execution order according to relevance of the nodes (nodes with only outputs have more relevance than
 * nodes with only inputs.
 * @method updateExecutionOrder
 */
LGraph.prototype.updateExecutionOrder = function () {
    this._nodes_in_order = this.computeExecutionOrder(false);
    this._nodes_executable = [];
    for (var i = 0; i < this._nodes_in_order.length; ++i) {
        if (this._nodes_in_order[i].onExecute) {
            this._nodes_executable.push(this._nodes_in_order[i]);
        }
    }
};
//This is more internal, it computes the executable nodes in order and returns it
LGraph.prototype.computeExecutionOrder = function (only_onExecute, set_level) {
    var L = [];
    var S = [];
    var M = {};
    var visited_links = {}; //to avoid repeating links
    var remaining_links = {}; //to a
    //search for the nodes without inputs (starting nodes)
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        var node = this._nodes[i];
        if (only_onExecute && !node.onExecute) {
            continue;
        }
        M[node.id] = node; //add to pending nodes
        var num = 0; //num of input connections
        if (node.inputs) {
            for (var j = 0, l2 = node.inputs.length; j < l2; j++) {
                if (node.inputs[j] && node.inputs[j].link != null) {
                    num += 1;
                }
            }
        }
        if (num == 0) {
            //is a starting node
            S.push(node);
            if (set_level) {
                node._level = 1;
            }
        } //num of input links
        else {
            if (set_level) {
                node._level = 0;
            }
            remaining_links[node.id] = num;
        }
    }
    while (true) {
        if (S.length == 0) {
            break;
        }
        //get an starting node
        var node = S.shift();
        L.push(node); //add to ordered list
        delete M[node.id]; //remove from the pending nodes
        if (!node.outputs) {
            continue;
        }
        //for every output
        for (var i = 0; i < node.outputs.length; i++) {
            var output = node.outputs[i];
            //not connected
            if (output == null ||
                output.links == null ||
                output.links.length == 0) {
                continue;
            }
            //for every connection
            for (var j = 0; j < output.links.length; j++) {
                var link_id = output.links[j];
                var link = this.links[link_id];
                if (!link) {
                    continue;
                }
                //already visited link (ignore it)
                if (visited_links[link.id]) {
                    continue;
                }
                var target_node = this.getNodeById(link.target_id);
                if (target_node == null) {
                    visited_links[link.id] = true;
                    continue;
                }
                if (set_level &&
                    (!target_node._level ||
                        target_node._level <= node._level)) {
                    target_node._level = node._level + 1;
                }
                visited_links[link.id] = true; //mark as visited
                remaining_links[target_node.id] -= 1; //reduce the number of links remaining
                if (remaining_links[target_node.id] == 0) {
                    S.push(target_node);
                } //if no more links, then add to starters array
            }
        }
    }
    //the remaining ones (loops)
    for (var i in M) {
        L.push(M[i]);
    }
    if (L.length != this._nodes.length && exports.LiteGraph.debug) {
        console.warn("something went wrong, nodes missing");
    }
    var l = L.length;
    //save order number in the node
    for (var i = 0; i < l; ++i) {
        L[i].order = i;
    }
    //sort now by priority
    L = L.sort(function (A, B) {
        var Ap = A.constructor.priority || A.priority || 0;
        var Bp = B.constructor.priority || B.priority || 0;
        if (Ap == Bp) {
            //if same priority, sort by order
            return A.order - B.order;
        }
        return Ap - Bp; //sort by priority
    });
    //save order number in the node, again...
    for (var i = 0; i < l; ++i) {
        L[i].order = i;
    }
    return L;
};
/**
 * Returns all the nodes that could affect this one (ancestors) by crawling all the inputs recursively.
 * It doesn't include the node itself
 * @method getAncestors
 * @return {Array} an array with all the LGraphNodes that affect this node, in order of execution
 */
LGraph.prototype.getAncestors = function (node) {
    var ancestors = [];
    var pending = [node];
    var visited = {};
    while (pending.length) {
        var current = pending.shift();
        if (!current.inputs) {
            continue;
        }
        if (!visited[current.id] && current != node) {
            visited[current.id] = true;
            ancestors.push(current);
        }
        for (var i = 0; i < current.inputs.length; ++i) {
            var input = current.getInputNode(i);
            if (input && ancestors.indexOf(input) == -1) {
                pending.push(input);
            }
        }
    }
    ancestors.sort(function (a, b) {
        return a.order - b.order;
    });
    return ancestors;
};
/**
 * Positions every node in a more readable manner
 * @method arrange
 */
LGraph.prototype.arrange = function (margin, layout) {
    margin = margin || 100;
    var nodes = this.computeExecutionOrder(false, true);
    var columns = [];
    for (var i = 0; i < nodes.length; ++i) {
        var node = nodes[i];
        var col = node._level || 1;
        if (!columns[col]) {
            columns[col] = [];
        }
        columns[col].push(node);
    }
    var x = margin;
    for (var i = 0; i < columns.length; ++i) {
        var column = columns[i];
        if (!column) {
            continue;
        }
        var max_size = 100;
        var y = margin + exports.LiteGraph.NODE_TITLE_HEIGHT;
        for (var j = 0; j < column.length; ++j) {
            var node = column[j];
            node.pos[0] = (layout == exports.LiteGraph.VERTICAL_LAYOUT) ? y : x;
            node.pos[1] = (layout == exports.LiteGraph.VERTICAL_LAYOUT) ? x : y;
            var max_size_index = (layout == exports.LiteGraph.VERTICAL_LAYOUT) ? 1 : 0;
            if (node.size[max_size_index] > max_size) {
                max_size = node.size[max_size_index];
            }
            var node_size_index = (layout == exports.LiteGraph.VERTICAL_LAYOUT) ? 0 : 1;
            y += node.size[node_size_index] + margin + exports.LiteGraph.NODE_TITLE_HEIGHT;
        }
        x += max_size + margin;
    }
    this.setDirtyCanvas(true, true);
};
/**
 * Returns the amount of time the graph has been running in milliseconds
 * @method getTime
 * @return {number} number of milliseconds the graph has been running
 */
LGraph.prototype.getTime = function () {
    return this.globaltime;
};
/**
 * Returns the amount of time accumulated using the fixedtime_lapse var. This is used in context where the time increments should be constant
 * @method getFixedTime
 * @return {number} number of milliseconds the graph has been running
 */
LGraph.prototype.getFixedTime = function () {
    return this.fixedtime;
};
/**
 * Returns the amount of time it took to compute the latest iteration. Take into account that this number could be not correct
 * if the nodes are using graphical actions
 * @method getElapsedTime
 * @return {number} number of milliseconds it took the last cycle
 */
LGraph.prototype.getElapsedTime = function () {
    return this.elapsed_time;
};
/**
 * Sends an event to all the nodes, useful to trigger stuff
 * @method sendEventToAllNodes
 * @param {String} eventname the name of the event (function to be called)
 * @param {Array} params parameters in array format
 */
LGraph.prototype.sendEventToAllNodes = function (eventname, params, mode) {
    // mode = mode || LiteGraph.ALWAYS;
    var nodes = this._nodes_in_order ? this._nodes_in_order : this._nodes;
    if (!nodes) {
        return;
    }
    for (var j = 0, l = nodes.length; j < l; ++j) {
        var node = nodes[j];
        if (node.constructor === exports.LiteGraph.Subgraph && eventname != "onExecute") {
            // if (node.mode == mode) {
            node.sendEventToAllNodes(eventname, params, mode);
            // }
            continue;
        }
        if (!node[eventname]) { //|| node.mode != mode
            continue;
        }
        if (params === undefined) {
            node[eventname]();
        }
        else if (params && params.constructor === Array) {
            node[eventname].apply(node, params);
        }
        else {
            node[eventname](params);
        }
    }
};
LGraph.prototype.sendActionToCanvas = function (action, params) {
    if (!this.list_of_graphcanvas) {
        return;
    }
    for (var i = 0; i < this.list_of_graphcanvas.length; ++i) {
        var c = this.list_of_graphcanvas[i];
        if (c[action]) {
            c[action].apply(c, params);
        }
    }
};
/**
 * Adds a new node instance to this graph
 * @method add
 * @param {LGraphNode} node the instance of the node
 */
LGraph.prototype.add = function (node, skip_compute_order) {
    if (!node) {
        return;
    }
    //groups
    if (node.constructor === LGraphGroup) {
        this._groups.push(node);
        this.setDirtyCanvas(true);
        this.change();
        node.graph = this;
        this._version++;
        return;
    }
    //nodes
    if (node.id != -1 && this._nodes_by_id[node.id] != null) {
        console.warn("LiteGraph: there is already a node with this ID, changing it");
        if (exports.LiteGraph.use_uuids) {
            node.id = exports.LiteGraph.uuidv4();
        }
        else {
            node.id = ++this.last_node_id;
        }
    }
    if (this._nodes.length >= exports.LiteGraph.MAX_NUMBER_OF_NODES) {
        throw "LiteGraph: max number of nodes in a graph reached";
    }
    //give him an id
    if (exports.LiteGraph.use_uuids) {
        if (node.id == null || node.id == -1)
            node.id = exports.LiteGraph.uuidv4();
    }
    else {
        if (node.id == null || node.id == -1) {
            node.id = ++this.last_node_id;
        }
        else if (this.last_node_id < node.id) {
            this.last_node_id = node.id;
        }
    }
    node.graph = this;
    this._version++;
    this._nodes.push(node);
    this._nodes_by_id[node.id] = node;
    if (node.onAdded) {
        node.onAdded(this);
    }
    if (this.config.align_to_grid) {
        node.alignToGrid();
    }
    if (!skip_compute_order) {
        this.updateExecutionOrder();
    }
    if (this.onNodeAdded) {
        this.onNodeAdded(node);
    }
    this.setDirtyCanvas(true);
    this.change();
    return node; //to chain actions
};
/**
 * Removes a node from the graph
 * @method remove
 * @param {LGraphNode} node the instance of the node
 */
LGraph.prototype.remove = function (node) {
    if (node.constructor === exports.LiteGraph.LGraphGroup) {
        var index = this._groups.indexOf(node);
        if (index != -1) {
            this._groups.splice(index, 1);
        }
        node.graph = null;
        this._version++;
        this.setDirtyCanvas(true, true);
        this.change();
        return;
    }
    if (this._nodes_by_id[node.id] == null) {
        return;
    } //not found
    if (node.ignore_remove) {
        return;
    } //cannot be removed
    this.beforeChange(); //sure? - almost sure is wrong
    //disconnect inputs
    if (node.inputs) {
        for (var i = 0; i < node.inputs.length; i++) {
            var slot = node.inputs[i];
            if (slot.link != null) {
                node.disconnectInput(i);
            }
        }
    }
    //disconnect outputs
    if (node.outputs) {
        for (var i = 0; i < node.outputs.length; i++) {
            var slot = node.outputs[i];
            if (slot.links != null && slot.links.length) {
                node.disconnectOutput(i);
            }
        }
    }
    //node.id = -1; //why?
    //callback
    if (node.onRemoved) {
        node.onRemoved();
    }
    node.graph = null;
    this._version++;
    //remove from canvas render
    if (this.list_of_graphcanvas) {
        for (var i = 0; i < this.list_of_graphcanvas.length; ++i) {
            var canvas = this.list_of_graphcanvas[i];
            if (canvas.selected_nodes[node.id]) {
                delete canvas.selected_nodes[node.id];
            }
            if (canvas.node_dragged == node) {
                canvas.node_dragged = null;
            }
        }
    }
    //remove from containers
    var pos = this._nodes.indexOf(node);
    if (pos != -1) {
        this._nodes.splice(pos, 1);
    }
    delete this._nodes_by_id[node.id];
    if (this.onNodeRemoved) {
        this.onNodeRemoved(node);
    }
    //close panels
    this.sendActionToCanvas("checkPanels");
    this.setDirtyCanvas(true, true);
    this.afterChange(); //sure? - almost sure is wrong
    this.change();
    this.updateExecutionOrder();
};
/**
 * Returns a node by its id.
 * @method getNodeById
 * @param {Number} id
 */
LGraph.prototype.getNodeById = function (id) {
    if (id == null) {
        return null;
    }
    return this._nodes_by_id[id];
};
/**
 * Returns a list of nodes that matches a class
 * @method findNodesByClass
 * @param {Class} classObject the class itself (not an string)
 * @return {Array} a list with all the nodes of this type
 */
LGraph.prototype.findNodesByClass = function (classObject, result) {
    result = result || [];
    result.length = 0;
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        if (this._nodes[i].constructor === classObject) {
            result.push(this._nodes[i]);
        }
    }
    return result;
};
/**
 * Returns a list of nodes that matches a type
 * @method findNodesByType
 * @param {String} type the name of the node type
 * @return {Array} a list with all the nodes of this type
 */
LGraph.prototype.findNodesByType = function (type, result) {
    var type = type.toLowerCase();
    result = result || [];
    result.length = 0;
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        if (this._nodes[i].type.toLowerCase() == type) {
            result.push(this._nodes[i]);
        }
    }
    return result;
};
/**
 * Returns the first node that matches a name in its title
 * @method findNodeByTitle
 * @param {String} name the name of the node to search
 * @return {Node} the node or null
 */
LGraph.prototype.findNodeByTitle = function (title) {
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        if (this._nodes[i].title == title) {
            return this._nodes[i];
        }
    }
    return null;
};
/**
 * Returns a list of nodes that matches a name
 * @method findNodesByTitle
 * @param {String} name the name of the node to search
 * @return {Array} a list with all the nodes with this name
 */
LGraph.prototype.findNodesByTitle = function (title) {
    var result = [];
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        if (this._nodes[i].title == title) {
            result.push(this._nodes[i]);
        }
    }
    return result;
};
/**
 * Returns the top-most node in this position of the canvas
 * @method getNodeOnPos
 * @param {number} x the x coordinate in canvas space
 * @param {number} y the y coordinate in canvas space
 * @param {Array} nodes_list a list with all the nodes to search from, by default is all the nodes in the graph
 * @return {LGraphNode} the node at this position or null
 */
LGraph.prototype.getNodeOnPos = function (x, y, nodes_list, margin) {
    nodes_list = nodes_list || this._nodes;
    var nRet = null;
    for (var i = nodes_list.length - 1; i >= 0; i--) {
        var n = nodes_list[i];
        if (n.isPointInside(x, y, margin)) {
            // check for lesser interest nodes (TODO check for overlapping, use the top)
            /*if (typeof n == "LGraphGroup"){
                nRet = n;
            }else{*/
            return n;
            /*}*/
        }
    }
    return nRet;
};
/**
 * Returns the top-most group in that position
 * @method getGroupOnPos
 * @param {number} x the x coordinate in canvas space
 * @param {number} y the y coordinate in canvas space
 * @return {LGraphGroup} the group or null
 */
LGraph.prototype.getGroupOnPos = function (x, y) {
    for (var i = this._groups.length - 1; i >= 0; i--) {
        var g = this._groups[i];
        if (g.isPointInside(x, y, 2, true)) {
            return g;
        }
    }
    return null;
};
/**
 * Checks that the node type matches the node type registered, used when replacing a nodetype by a newer version during execution
 * this replaces the ones using the old version with the new version
 * @method checkNodeTypes
 */
LGraph.prototype.checkNodeTypes = function () {
    var changes = false;
    for (var i = 0; i < this._nodes.length; i++) {
        var node = this._nodes[i];
        var ctor = exports.LiteGraph.registered_node_types[node.type];
        if (node.constructor == ctor) {
            continue;
        }
        console.log("node being replaced by newer version: " + node.type);
        var newnode = exports.LiteGraph.createNode(node.type);
        changes = true;
        this._nodes[i] = newnode;
        newnode.configure(node.serialize());
        newnode.graph = this;
        this._nodes_by_id[newnode.id] = newnode;
        if (node.inputs) {
            newnode.inputs = node.inputs.concat();
        }
        if (node.outputs) {
            newnode.outputs = node.outputs.concat();
        }
    }
    this.updateExecutionOrder();
};
// ********** GLOBALS *****************
LGraph.prototype.onAction = function (action, param, options) {
    this._input_nodes = this.findNodesByClass(exports.LiteGraph.GraphInput, this._input_nodes);
    for (var i = 0; i < this._input_nodes.length; ++i) {
        var node = this._input_nodes[i];
        if (node.properties.name != action) {
            continue;
        }
        //wrap node.onAction(action, param);
        node.actionDo(action, param, options);
        break;
    }
};
LGraph.prototype.trigger = function (action, param) {
    if (this.onTrigger) {
        this.onTrigger(action, param);
    }
};
/**
 * Tell this graph it has a global graph input of this type
 * @method addGlobalInput
 * @param {String} name
 * @param {String} type
 * @param {*} value [optional]
 */
LGraph.prototype.addInput = function (name, type, value) {
    var input = this.inputs[name];
    if (input) {
        //already exist
        return;
    }
    this.beforeChange();
    this.inputs[name] = { name: name, type: type, value: value };
    this._version++;
    this.afterChange();
    if (this.onInputAdded) {
        this.onInputAdded(name, type);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
};
/**
 * Assign a data to the global graph input
 * @method setGlobalInputData
 * @param {String} name
 * @param {*} data
 */
LGraph.prototype.setInputData = function (name, data) {
    var input = this.inputs[name];
    if (!input) {
        return;
    }
    input.value = data;
};
/**
 * Returns the current value of a global graph input
 * @method getInputData
 * @param {String} name
 * @return {*} the data
 */
LGraph.prototype.getInputData = function (name) {
    var input = this.inputs[name];
    if (!input) {
        return null;
    }
    return input.value;
};
/**
 * Changes the name of a global graph input
 * @method renameInput
 * @param {String} old_name
 * @param {String} new_name
 */
LGraph.prototype.renameInput = function (old_name, name) {
    if (name == old_name) {
        return;
    }
    if (!this.inputs[old_name]) {
        return false;
    }
    if (this.inputs[name]) {
        console.error("there is already one input with that name");
        return false;
    }
    this.inputs[name] = this.inputs[old_name];
    delete this.inputs[old_name];
    this._version++;
    if (this.onInputRenamed) {
        this.onInputRenamed(old_name, name);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
};
/**
 * Changes the type of a global graph input
 * @method changeInputType
 * @param {String} name
 * @param {String} type
 */
LGraph.prototype.changeInputType = function (name, type) {
    if (!this.inputs[name]) {
        return false;
    }
    if (this.inputs[name].type &&
        String(this.inputs[name].type).toLowerCase() ==
            String(type).toLowerCase()) {
        return;
    }
    this.inputs[name].type = type;
    this._version++;
    if (this.onInputTypeChanged) {
        this.onInputTypeChanged(name, type);
    }
};
/**
 * Removes a global graph input
 * @method removeInput
 * @param {String} name
 * @param {String} type
 */
LGraph.prototype.removeInput = function (name) {
    if (!this.inputs[name]) {
        return false;
    }
    delete this.inputs[name];
    this._version++;
    if (this.onInputRemoved) {
        this.onInputRemoved(name);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
    return true;
};
/**
 * Creates a global graph output
 * @method addOutput
 * @param {String} name
 * @param {String} type
 * @param {*} value
 */
LGraph.prototype.addOutput = function (name, type, value) {
    this.outputs[name] = { name: name, type: type, value: value };
    this._version++;
    if (this.onOutputAdded) {
        this.onOutputAdded(name, type);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
};
/**
 * Assign a data to the global output
 * @method setOutputData
 * @param {String} name
 * @param {String} value
 */
LGraph.prototype.setOutputData = function (name, value) {
    var output = this.outputs[name];
    if (!output) {
        return;
    }
    output.value = value;
};
/**
 * Returns the current value of a global graph output
 * @method getOutputData
 * @param {String} name
 * @return {*} the data
 */
LGraph.prototype.getOutputData = function (name) {
    var output = this.outputs[name];
    if (!output) {
        return null;
    }
    return output.value;
};
/**
 * Renames a global graph output
 * @method renameOutput
 * @param {String} old_name
 * @param {String} new_name
 */
LGraph.prototype.renameOutput = function (old_name, name) {
    if (!this.outputs[old_name]) {
        return false;
    }
    if (this.outputs[name]) {
        console.error("there is already one output with that name");
        return false;
    }
    this.outputs[name] = this.outputs[old_name];
    delete this.outputs[old_name];
    this._version++;
    if (this.onOutputRenamed) {
        this.onOutputRenamed(old_name, name);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
};
/**
 * Changes the type of a global graph output
 * @method changeOutputType
 * @param {String} name
 * @param {String} type
 */
LGraph.prototype.changeOutputType = function (name, type) {
    if (!this.outputs[name]) {
        return false;
    }
    if (this.outputs[name].type &&
        String(this.outputs[name].type).toLowerCase() ==
            String(type).toLowerCase()) {
        return;
    }
    this.outputs[name].type = type;
    this._version++;
    if (this.onOutputTypeChanged) {
        this.onOutputTypeChanged(name, type);
    }
};
/**
 * Removes a global graph output
 * @method removeOutput
 * @param {String} name
 */
LGraph.prototype.removeOutput = function (name) {
    if (!this.outputs[name]) {
        return false;
    }
    delete this.outputs[name];
    this._version++;
    if (this.onOutputRemoved) {
        this.onOutputRemoved(name);
    }
    if (this.onInputsOutputsChange) {
        this.onInputsOutputsChange();
    }
    return true;
};
LGraph.prototype.triggerInput = function (name, value) {
    var nodes = this.findNodesByTitle(name);
    for (var i = 0; i < nodes.length; ++i) {
        nodes[i].onTrigger(value);
    }
};
LGraph.prototype.setCallback = function (name, func) {
    var nodes = this.findNodesByTitle(name);
    for (var i = 0; i < nodes.length; ++i) {
        nodes[i].setTrigger(func);
    }
};
//used for undo, called before any change is made to the graph
LGraph.prototype.beforeChange = function (info) {
    if (this.onBeforeChange) {
        this.onBeforeChange(this, info);
    }
    this.sendActionToCanvas("onBeforeChange", this);
};
//used to resend actions, called after any change is made to the graph
LGraph.prototype.afterChange = function (info) {
    if (this.onAfterChange) {
        this.onAfterChange(this, info);
    }
    this.sendActionToCanvas("onAfterChange", this);
};
LGraph.prototype.connectionChange = function (node, link_info) {
    this.updateExecutionOrder();
    if (this.onConnectionChange) {
        this.onConnectionChange(node);
    }
    this._version++;
    this.sendActionToCanvas("onConnectionChange");
};
/**
 * returns if the graph is in live mode
 * @method isLive
 */
LGraph.prototype.isLive = function () {
    if (!this.list_of_graphcanvas) {
        return false;
    }
    for (var i = 0; i < this.list_of_graphcanvas.length; ++i) {
        var c = this.list_of_graphcanvas[i];
        if (c.live_mode) {
            return true;
        }
    }
    return false;
};
/**
 * clears the triggered slot animation in all links (stop visual animation)
 * @method clearTriggeredSlots
 */
LGraph.prototype.clearTriggeredSlots = function () {
    for (var i in this.links) {
        var link_info = this.links[i];
        if (!link_info) {
            continue;
        }
        if (link_info._last_time) {
            link_info._last_time = 0;
        }
    }
};
/* Called when something visually changed (not the graph!) */
LGraph.prototype.change = function () {
    if (exports.LiteGraph.debug) {
        console.log("Graph changed");
    }
    this.sendActionToCanvas("setDirty", [true, true]);
    if (this.on_change) {
        this.on_change(this);
    }
};
LGraph.prototype.setDirtyCanvas = function (fg, bg) {
    this.sendActionToCanvas("setDirty", [fg, bg]);
};
/**
 * Destroys a link
 * @method removeLink
 * @param {Number} link_id
 */
LGraph.prototype.removeLink = function (link_id) {
    var link = this.links[link_id];
    if (!link) {
        return;
    }
    var node = this.getNodeById(link.target_id);
    if (node) {
        node.disconnectInput(link.target_slot);
    }
};
//save and recover app state ***************************************
/**
 * Creates a Object containing all the info about this graph, it can be serialized
 * @method serialize
 * @return {Object} value of the node
 */
LGraph.prototype.serialize = function () {
    var nodes_info = [];
    for (var i = 0, l = this._nodes.length; i < l; ++i) {
        nodes_info.push(this._nodes[i].serialize());
    }
    //pack link info into a non-verbose format
    var links = [];
    for (var i in this.links) {
        //links is an OBJECT
        var link = this.links[i];
        if (!link.serialize) {
            //weird bug I havent solved yet
            console.warn("weird LLink bug, link info is not a LLink but a regular object");
            var link2 = new LLink();
            for (var j in link) {
                link2[j] = link[j];
            }
            this.links[i] = link2;
            link = link2;
        }
        links.push(link.serialize());
    }
    var groups_info = [];
    for (var i = 0; i < this._groups.length; ++i) {
        groups_info.push(this._groups[i].serialize());
    }
    var data = {
        last_node_id: this.last_node_id,
        last_link_id: this.last_link_id,
        nodes: nodes_info,
        links: links,
        groups: groups_info,
        config: this.config,
        extra: this.extra,
        version: exports.LiteGraph.VERSION
    };
    if (this.onSerialize)
        this.onSerialize(data);
    return data;
};
/**
 * Configure a graph from a JSON string
 * @method configure
 * @param {String} str configure a graph from a JSON string
 * @param {Boolean} returns if there was any error parsing
 */
LGraph.prototype.configure = function (data, keep_old) {
    if (!data) {
        return;
    }
    if (!keep_old) {
        this.clear();
    }
    var nodes = data.nodes;
    //decode links info (they are very verbose)
    if (data.links && data.links.constructor === Array) {
        var links = [];
        for (var i = 0; i < data.links.length; ++i) {
            var link_data = data.links[i];
            if (!link_data) //weird bug
             {
                // console.warn("serialized graph link data contains errors, skipping.");
                continue;
            }
            var link = new LLink();
            link.configure(link_data);
            links[link.id] = link;
        }
        data.links = links;
    }
    //copy all stored fields
    for (var i in data) {
        if (i == "nodes" || i == "groups") //links must be accepted
            continue;
        this[i] = data[i];
    }
    var error = false;
    //create nodes
    this._nodes = [];
    if (nodes) {
        for (var i = 0, l = nodes.length; i < l; ++i) {
            var n_info = nodes[i]; //stored info
            var node = exports.LiteGraph.createNode(n_info.type, n_info.title);
            if (!node) {
                if (exports.LiteGraph.debug) {
                    console.log("Node not found or has errors: " + n_info.type);
                }
                //in case of error we create a replacement node to avoid losing info
                node = new LGraphNode();
                node.last_serialization = n_info;
                node.has_errors = true;
                error = true;
                //continue;
            }
            node.id = n_info.id; //id it or it will create a new id
            this.add(node, true); //add before configure, otherwise configure cannot create links
        }
        //configure nodes afterwards so they can reach each other
        for (var i = 0, l = nodes.length; i < l; ++i) {
            var n_info = nodes[i];
            var node = this.getNodeById(n_info.id);
            if (node) {
                node.configure(n_info);
            }
        }
    }
    //groups
    this._groups.length = 0;
    if (data.groups) {
        for (var i = 0; i < data.groups.length; ++i) {
            var group = new exports.LiteGraph.LGraphGroup();
            group.configure(data.groups[i]);
            this.add(group);
        }
    }
    this.updateExecutionOrder();
    this.extra = data.extra || {};
    if (this.onConfigure)
        this.onConfigure(data);
    this._version++;
    this.setDirtyCanvas(true, true);
    return error;
};
LGraph.prototype.load = function (url, callback) {
    var that = this;
    //from file
    if (url.constructor === File || url.constructor === Blob) {
        var reader = new FileReader();
        reader.addEventListener('load', function (event) {
            var data = JSON.parse(event.target.result);
            that.configure(data);
            if (callback)
                callback();
        });
        reader.readAsText(url);
        return;
    }
    //is a string, then an URL
    var req = new XMLHttpRequest();
    req.open("GET", url, true);
    req.send(null);
    req.onload = function (oEvent) {
        if (req.status !== 200) {
            console.error("Error loading graph:", req.status, req.response);
            return;
        }
        var data = JSON.parse(req.response);
        that.configure(data);
        if (callback)
            callback();
    };
    req.onerror = function (err) {
        console.error("Error loading graph:", err);
    };
};
LGraph.prototype.onNodeTrace = function (node, msg, color) {
    //TODO
};
//this is the class in charge of storing link information
function LLink(id, type, origin_id, origin_slot, target_id, target_slot) {
    this.id = id;
    this.type = type;
    this.origin_id = origin_id;
    this.origin_slot = origin_slot;
    this.target_id = target_id;
    this.target_slot = target_slot;
    this._data = null;
    this._pos = new Float32Array(2); //center
}
LLink.prototype.configure = function (o) {
    if (o.constructor === Array) {
        this.id = o[0];
        this.origin_id = o[1];
        this.origin_slot = o[2];
        this.target_id = o[3];
        this.target_slot = o[4];
        this.type = o[5];
    }
    else {
        this.id = o.id;
        this.type = o.type;
        this.origin_id = o.origin_id;
        this.origin_slot = o.origin_slot;
        this.target_id = o.target_id;
        this.target_slot = o.target_slot;
    }
};
LLink.prototype.serialize = function () {
    return [
        this.id,
        this.origin_id,
        this.origin_slot,
        this.target_id,
        this.target_slot,
        this.type
    ];
};
exports.LiteGraph.LLink = LLink;
// *************************************************************
//   Node CLASS                                          *******
// *************************************************************
/*
title: string
pos: [x,y]
size: [x,y]

input|output: every connection
    +  { name:string, type:string, pos: [x,y]=Optional, direction: "input"|"output", links: Array });

general properties:
    + clip_area: if you render outside the node, it will be clipped
    + unsafe_execution: not allowed for safe execution
    + skip_repeated_outputs: when adding new outputs, it wont show if there is one already connected
    + resizable: if set to false it wont be resizable with the mouse
    + horizontal: slots are distributed horizontally
    + widgets_start_y: widgets start at y distance from the top of the node

flags object:
    + collapsed: if it is collapsed

supported callbacks:
    + onAdded: when added to graph (warning: this is called BEFORE the node is configured when loading)
    + onRemoved: when removed from graph
    + onStart:	when the graph starts playing
    + onStop:	when the graph stops playing
    + onDrawForeground: render the inside widgets inside the node
    + onDrawBackground: render the background area inside the node (only in edit mode)
    + onMouseDown
    + onMouseMove
    + onMouseUp
    + onMouseEnter
    + onMouseLeave
    + onExecute: execute the node
    + onPropertyChanged: when a property is changed in the panel (return true to skip default behaviour)
    + onGetInputs: returns an array of possible inputs
    + onGetOutputs: returns an array of possible outputs
    + onBounding: in case this node has a bigger bounding than the node itself (the callback receives the bounding as [x,y,w,h])
    + onDblClick: double clicked in the node
    + onInputDblClick: input slot double clicked (can be used to automatically create a node connected)
    + onOutputDblClick: output slot double clicked (can be used to automatically create a node connected)
    + onConfigure: called after the node has been configured
    + onSerialize: to add extra info when serializing (the callback receives the object that should be filled with the data)
    + onSelected
    + onDeselected
    + onDropItem : DOM item dropped over the node
    + onDropFile : file dropped over the node
    + onConnectInput : if returns false the incoming connection will be canceled
    + onConnectionsChange : a connection changed (new one or removed) (LiteGraph.INPUT or LiteGraph.OUTPUT, slot, true if connected, link_info, input_info )
    + onAction: action slot triggered
    + getExtraMenuOptions: to add option to context menu
*/
/**
 * Base Class for all the node type classes
 * @class LGraphNode
 * @param {String} name a name for the node
 */
function LGraphNode(title) {
    this._ctor(title);
}
exports.LGraphNode = LGraphNode;
// global.LGraphNode = LiteGraph.LGraphNode = LGraphNode;
LGraphNode.prototype._ctor = function (title) {
    this.title = title || "Unnamed";
    this.size = [exports.LiteGraph.NODE_WIDTH, 60];
    this.graph = null;
    this._pos = new Float32Array(10, 10);
    Object.defineProperty(this, "pos", {
        set: function (v) {
            if (!v || v.length < 2) {
                return;
            }
            this._pos[0] = v[0];
            this._pos[1] = v[1];
        },
        get: function () {
            return this._pos;
        },
        enumerable: true
    });
    if (exports.LiteGraph.use_uuids) {
        this.id = exports.LiteGraph.uuidv4();
    }
    else {
        this.id = -1; //not know till not added
    }
    this.type = null;
    //inputs available: array of inputs
    this.inputs = [];
    this.outputs = [];
    this.connections = [];
    //local data
    this.properties = {}; //for the values
    this.properties_info = []; //for the info
    this.flags = {};
};
//在子蓝图中无法获取到连接的物体，需要多一层查找
LGraphNode.prototype.getRealLinkNode = function () {
    var curLink = this.getInputLink(0);
    if (curLink == null) {
        return null;
    }
    if (this.graph._is_subgraph == true) {
        var inputNode_1 = this.graph.getNodeById(curLink.origin_id);
        var inputIndex = this.graph._subgraph_node.inputs.findIndex(function (solt) {
            return solt.name == inputNode_1.properties.name;
        });
        //    console.log('getRealLinkNode', inputIndex, inputNode.properties.name, this.graph._subgraph_node.inputs)
        if (inputIndex != -1) {
            var exLink = this.graph._subgraph_node.getInputLink(inputIndex);
            if (exLink == null) {
                return null;
            }
            return this.graph._subgraph_node.graph.getNodeById(exLink.origin_id);
        }
    }
    else {
        return this.graph.getNodeById(curLink.origin_id);
    }
};
//获取id，如果当前是在子图下，加上子图节点的id
LGraphNode.prototype.getIdWithGraph = function () {
    if (this.graph == null) {
        return this.id;
    }
    if (this.graph._subgraph_node != null) {
        return this.id + '_' + this.graph._subgraph_node.id;
    }
    return this.id;
};
/**
 * configure a node from an object containing the serialized info
 * @method configure
 */
LGraphNode.prototype.configure = function (info) {
    if (this.graph) {
        this.graph._version++;
    }
    for (var j in info) {
        if (j == "properties") {
            //i don't want to clone properties, I want to reuse the old container
            for (var k in info.properties) {
                this.properties[k] = info.properties[k];
                if (this.onPropertyChanged) {
                    this.onPropertyChanged(k, info.properties[k]);
                }
            }
            continue;
        }
        if (info[j] == null) {
            continue;
        }
        else if (typeof info[j] == "object") {
            //object
            if (this[j] && this[j].configure) {
                this[j].configure(info[j]);
            }
            else {
                this[j] = exports.LiteGraph.cloneObject(info[j], this[j]);
            }
        } //value
        else {
            this[j] = info[j];
        }
    }
    if (!info.title) {
        this.title = this.constructor.title;
    }
    if (this.inputs) {
        for (var i = 0; i < this.inputs.length; ++i) {
            var input = this.inputs[i];
            var link_info = this.graph ? this.graph.links[input.link] : null;
            if (this.onConnectionsChange)
                this.onConnectionsChange(exports.LiteGraph.INPUT, i, true, link_info, input); //link_info has been created now, so its updated
            if (this.onInputAdded)
                this.onInputAdded(input);
        }
    }
    if (this.outputs) {
        for (var i = 0; i < this.outputs.length; ++i) {
            var output = this.outputs[i];
            if (!output.links) {
                continue;
            }
            for (var j = 0; j < output.links.length; ++j) {
                var link_info = this.graph ? this.graph.links[output.links[j]] : null;
                if (this.onConnectionsChange)
                    this.onConnectionsChange(exports.LiteGraph.OUTPUT, i, true, link_info, output); //link_info has been created now, so its updated
            }
            if (this.onOutputAdded)
                this.onOutputAdded(output);
        }
    }
    if (this.widgets) {
        for (var i = 0; i < this.widgets.length; ++i) {
            var w = this.widgets[i];
            if (!w)
                continue;
            if (w.options && w.options.property && (this.properties[w.options.property] != undefined))
                w.value = JSON.parse(JSON.stringify(this.properties[w.options.property]));
        }
        if (info.widgets_values) {
            for (var i = 0; i < info.widgets_values.length; ++i) {
                if (this.widgets[i]) {
                    this.widgets[i].value = info.widgets_values[i];
                }
            }
        }
    }
    if (this.onConfigure) {
        this.onConfigure(info);
    }
};
/**
 * serialize the content
 * @method serialize
 */
LGraphNode.prototype.serialize = function () {
    //create serialization object
    var o = {
        id: this.id,
        type: this.type,
        pos: this.pos,
        size: this.size,
        flags: exports.LiteGraph.cloneObject(this.flags),
        order: this.order,
        mode: this.mode
    };
    //special case for when there were errors
    if (this.constructor === LGraphNode && this.last_serialization) {
        return this.last_serialization;
    }
    if (this.inputs) {
        o.inputs = this.inputs;
    }
    if (this.outputs) {
        //clear outputs last data (because data in connections is never serialized but stored inside the outputs info)
        for (var i = 0; i < this.outputs.length; i++) {
            delete this.outputs[i]._data;
        }
        o.outputs = this.outputs;
    }
    if (this.title && this.title != this.constructor.title) {
        o.title = this.title;
    }
    if (this.properties) {
        o.properties = exports.LiteGraph.cloneObject(this.properties);
    }
    if (this.widgets && this.serialize_widgets) {
        o.widgets_values = [];
        for (var i = 0; i < this.widgets.length; ++i) {
            if (this.widgets[i])
                o.widgets_values[i] = this.widgets[i].value;
            else
                o.widgets_values[i] = null;
        }
    }
    if (!o.type) {
        o.type = this.constructor.type;
    }
    if (this.color) {
        o.color = this.color;
    }
    if (this.bgcolor) {
        o.bgcolor = this.bgcolor;
    }
    if (this.boxcolor) {
        o.boxcolor = this.boxcolor;
    }
    if (this.shape) {
        o.shape = this.shape;
    }
    if (this.onSerialize) {
        if (this.onSerialize(o)) {
            console.warn("node onSerialize shouldnt return anything, data should be stored in the object pass in the first parameter");
        }
    }
    return o;
};
/* Creates a clone of this node */
LGraphNode.prototype.clone = function () {
    var node = exports.LiteGraph.createNode(this.type);
    if (!node) {
        return null;
    }
    //we clone it because serialize returns shared containers
    var data = exports.LiteGraph.cloneObject(this.serialize());
    //remove links
    if (data.inputs) {
        for (var i = 0; i < data.inputs.length; ++i) {
            data.inputs[i].link = null;
        }
    }
    if (data.outputs) {
        for (var i = 0; i < data.outputs.length; ++i) {
            if (data.outputs[i].links) {
                data.outputs[i].links.length = 0;
            }
        }
    }
    delete data["id"];
    if (exports.LiteGraph.use_uuids) {
        data["id"] = exports.LiteGraph.uuidv4();
    }
    //remove links
    node.configure(data);
    return node;
};
/**
 * serialize and stringify
 * @method toString
 */
LGraphNode.prototype.toString = function () {
    return JSON.stringify(this.serialize());
};
//LGraphNode.prototype.deserialize = function(info) {} //this cannot be done from within, must be done in LiteGraph
/**
 * get the title string
 * @method getTitle
 */
LGraphNode.prototype.getTitle = function () {
    return this.title || this.constructor.title;
};
/**
 * sets the value of a property
 * @method setProperty
 * @param {String} name
 * @param {*} value
 */
LGraphNode.prototype.setProperty = function (name, value) {
    if (!this.properties) {
        this.properties = {};
    }
    if (value === this.properties[name])
        return;
    var prev_value = this.properties[name];
    this.properties[name] = value;
    if (this.onPropertyChanged) {
        if (this.onPropertyChanged(name, value, prev_value) === false) //abort change
            this.properties[name] = prev_value;
    }
    if (this.widgets) //widgets could be linked to properties
        for (var i = 0; i < this.widgets.length; ++i) {
            var w = this.widgets[i];
            if (!w)
                continue;
            if (w.options.property == name) {
                w.value = value;
                break;
            }
        }
};
// Execution *************************
/**
 * sets the output data
 * @method setOutputData
 * @param {number} slot
 * @param {*} data
 */
LGraphNode.prototype.setOutputData = function (slot, data) {
    if (!this.outputs) {
        return;
    }
    //this maybe slow and a niche case
    //if(slot && slot.constructor === String)
    //	slot = this.findOutputSlot(slot);
    if (slot == -1 || slot >= this.outputs.length) {
        return;
    }
    var output_info = this.outputs[slot];
    if (!output_info) {
        return;
    }
    //store data in the output itself in case we want to debug
    output_info._data = data;
    //if there are connections, pass the data to the connections
    if (this.outputs[slot].links) {
        for (var i = 0; i < this.outputs[slot].links.length; i++) {
            var link_id = this.outputs[slot].links[i];
            var link = this.graph.links[link_id];
            if (link)
                link.data = data;
        }
    }
};
/**
 * sets the output data type, useful when you want to be able to overwrite the data type
 * @method setOutputDataType
 * @param {number} slot
 * @param {String} datatype
 */
LGraphNode.prototype.setOutputDataType = function (slot, type) {
    if (!this.outputs) {
        return;
    }
    if (slot == -1 || slot >= this.outputs.length) {
        return;
    }
    var output_info = this.outputs[slot];
    if (!output_info) {
        return;
    }
    //store data in the output itself in case we want to debug
    output_info.type = type;
    //if there are connections, pass the data to the connections
    if (this.outputs[slot].links) {
        for (var i = 0; i < this.outputs[slot].links.length; i++) {
            var link_id = this.outputs[slot].links[i];
            this.graph.links[link_id].type = type;
        }
    }
};
/**
 * Retrieves the input data (data traveling through the connection) from one slot
 * @method getInputData
 * @param {number} slot
 * @param {boolean} force_update if set to true it will force the connected node of this slot to output data into this link
 * @return {*} data or if it is not connected returns undefined
 */
LGraphNode.prototype.getInputData = function (slot, force_update) {
    if (!this.inputs) {
        return;
    } //undefined;
    if (slot >= this.inputs.length || this.inputs[slot].link == null) {
        return;
    }
    var link_id = this.inputs[slot].link;
    var link = this.graph.links[link_id];
    if (!link) {
        //bug: weird case but it happens sometimes
        return null;
    }
    if (!force_update) {
        return link.data;
    }
    //special case: used to extract data from the incoming connection before the graph has been executed
    var node = this.graph.getNodeById(link.origin_id);
    if (!node) {
        return link.data;
    }
    if (node.updateOutputData) {
        node.updateOutputData(link.origin_slot);
    }
    else if (node.onExecute) {
        node.onExecute();
    }
    return link.data;
};
/**
 * Retrieves the input data type (in case this supports multiple input types)
 * @method getInputDataType
 * @param {number} slot
 * @return {String} datatype in string format
 */
LGraphNode.prototype.getInputDataType = function (slot) {
    if (!this.inputs) {
        return null;
    } //undefined;
    if (slot >= this.inputs.length || this.inputs[slot].link == null) {
        return null;
    }
    var link_id = this.inputs[slot].link;
    var link = this.graph.links[link_id];
    if (!link) {
        //bug: weird case but it happens sometimes
        return null;
    }
    var node = this.graph.getNodeById(link.origin_id);
    if (!node) {
        return link.type;
    }
    var output_info = node.outputs[link.origin_slot];
    if (output_info) {
        return output_info.type;
    }
    return null;
};
/**
 * Retrieves the input data from one slot using its name instead of slot number
 * @method getInputDataByName
 * @param {String} slot_name
 * @param {boolean} force_update if set to true it will force the connected node of this slot to output data into this link
 * @return {*} data or if it is not connected returns null
 */
LGraphNode.prototype.getInputDataByName = function (slot_name, force_update) {
    var slot = this.findInputSlot(slot_name);
    if (slot == -1) {
        return null;
    }
    return this.getInputData(slot, force_update);
};
/**
 * tells you if there is a connection in one input slot
 * @method isInputConnected
 * @param {number} slot
 * @return {boolean}
 */
LGraphNode.prototype.isInputConnected = function (slot) {
    if (!this.inputs) {
        return false;
    }
    return slot < this.inputs.length && this.inputs[slot].link != null;
};
/**
 * tells you info about an input connection (which node, type, etc)
 * @method getInputInfo
 * @param {number} slot
 * @return {Object} object or null { link: id, name: string, type: string or 0 }
 */
LGraphNode.prototype.getInputInfo = function (slot) {
    if (!this.inputs) {
        return null;
    }
    if (slot < this.inputs.length) {
        return this.inputs[slot];
    }
    return null;
};
/**
 * Returns the link info in the connection of an input slot
 * @method getInputLink
 * @param {number} slot
 * @return {LLink} object or null
 */
LGraphNode.prototype.getInputLink = function (slot) {
    if (!this.inputs) {
        return null;
    }
    if (slot < this.inputs.length) {
        var slot_info = this.inputs[slot];
        return this.graph.links[slot_info.link];
    }
    return null;
};
/**
 * returns the node connected in the input slot
 * @method getInputNode
 * @param {number} slot
 * @return {LGraphNode} node or null
 */
LGraphNode.prototype.getInputNode = function (slot) {
    if (!this.inputs) {
        return null;
    }
    if (slot >= this.inputs.length) {
        return null;
    }
    var input = this.inputs[slot];
    if (!input || input.link === null) {
        return null;
    }
    var link_info = this.graph.links[input.link];
    if (!link_info) {
        return null;
    }
    return this.graph.getNodeById(link_info.origin_id);
};
/**
 * returns the value of an input with this name, otherwise checks if there is a property with that name
 * @method getInputOrProperty
 * @param {string} name
 * @return {*} value
 */
LGraphNode.prototype.getInputOrProperty = function (name) {
    if (!this.inputs || !this.inputs.length) {
        return this.properties ? this.properties[name] : null;
    }
    for (var i = 0, l = this.inputs.length; i < l; ++i) {
        var input_info = this.inputs[i];
        if (name == input_info.name && input_info.link != null) {
            var link = this.graph.links[input_info.link];
            if (link) {
                return link.data;
            }
        }
    }
    return this.properties[name];
};
/**
 * tells you the last output data that went in that slot
 * @method getOutputData
 * @param {number} slot
 * @return {Object}  object or null
 */
LGraphNode.prototype.getOutputData = function (slot) {
    if (!this.outputs) {
        return null;
    }
    if (slot >= this.outputs.length) {
        return null;
    }
    var info = this.outputs[slot];
    return info._data;
};
/**
 * tells you info about an output connection (which node, type, etc)
 * @method getOutputInfo
 * @param {number} slot
 * @return {Object}  object or null { name: string, type: string, links: [ ids of links in number ] }
 */
LGraphNode.prototype.getOutputInfo = function (slot) {
    if (!this.outputs) {
        return null;
    }
    if (slot < this.outputs.length) {
        return this.outputs[slot];
    }
    return null;
};
/**
 * tells you if there is a connection in one output slot
 * @method isOutputConnected
 * @param {number} slot
 * @return {boolean}
 */
LGraphNode.prototype.isOutputConnected = function (slot) {
    if (!this.outputs) {
        return false;
    }
    return (slot < this.outputs.length &&
        this.outputs[slot].links &&
        this.outputs[slot].links.length);
};
/**
 * tells you if there is any connection in the output slots
 * @method isAnyOutputConnected
 * @return {boolean}
 */
LGraphNode.prototype.isAnyOutputConnected = function () {
    if (!this.outputs) {
        return false;
    }
    for (var i = 0; i < this.outputs.length; ++i) {
        if (this.outputs[i].links && this.outputs[i].links.length) {
            return true;
        }
    }
    return false;
};
/**
 * retrieves all the nodes connected to this output slot
 * @method getOutputNodes
 * @param {number} slot
 * @return {array}
 */
LGraphNode.prototype.getOutputNodes = function (slot) {
    if (!this.outputs || this.outputs.length == 0) {
        return null;
    }
    if (slot >= this.outputs.length) {
        return null;
    }
    var output = this.outputs[slot];
    if (!output.links || output.links.length == 0) {
        return null;
    }
    var r = [];
    for (var i = 0; i < output.links.length; i++) {
        var link_id = output.links[i];
        var link = this.graph.links[link_id];
        if (link) {
            var target_node = this.graph.getNodeById(link.target_id);
            if (target_node) {
                r.push(target_node);
            }
        }
    }
    return r;
};
LGraphNode.prototype.addOnTriggerInput = function () {
    var trigS = this.findInputSlot("onTrigger");
    if (trigS == -1) { //!trigS || 
        var input = this.addInput("onTrigger", exports.LiteGraph.EVENT, { optional: true, nameLocked: true });
        return this.findInputSlot("onTrigger");
    }
    return trigS;
};
LGraphNode.prototype.addOnExecutedOutput = function () {
    var trigS = this.findOutputSlot("onExecuted");
    if (trigS == -1) { //!trigS || 
        var output = this.addOutput("onExecuted", exports.LiteGraph.ACTION, { optional: true, nameLocked: true });
        return this.findOutputSlot("onExecuted");
    }
    return trigS;
};
LGraphNode.prototype.onAfterExecuteNode = function (param, options) {
    var trigS = this.findOutputSlot("onExecuted");
    if (trigS != -1) {
        //console.debug(this.id+":"+this.order+" triggering slot onAfterExecute");
        //console.debug(param);
        //console.debug(options);
        this.triggerSlot(trigS, param, null, options);
    }
};
LGraphNode.prototype.changeMode = function (modeTo) {
    switch (modeTo) {
        case exports.LiteGraph.ON_EVENT:
            // this.addOnExecutedOutput();
            break;
        case exports.LiteGraph.ON_TRIGGER:
            this.addOnTriggerInput();
            this.addOnExecutedOutput();
            break;
        case exports.LiteGraph.NEVER:
            break;
        case exports.LiteGraph.ALWAYS:
            break;
        case exports.LiteGraph.ON_REQUEST:
            break;
        default:
            return false;
            break;
    }
    this.mode = modeTo;
    return true;
};
/**
 * Triggers the execution of actions that were deferred when the action was triggered
 * @method executePendingActions
 */
LGraphNode.prototype.executePendingActions = function () {
    if (!this._waiting_actions || !this._waiting_actions.length)
        return;
    for (var i = 0; i < this._waiting_actions.length; ++i) {
        var p = this._waiting_actions[i];
        this.onAction(p[0], p[1], p[2], p[3], p[4]);
    }
    this._waiting_actions.length = 0;
};
/**
 * Triggers the node code execution, place a boolean/counter to mark the node as being executed
 * @method doExecute
 * @param {*} param
 * @param {*} options
 */
LGraphNode.prototype.doExecute = function (param, options) {
    options = options || {};
    if (this.onExecute) {
        // enable this to give the event an ID
        if (!options.action_call)
            options.action_call = this.id + "_exec_" + Math.floor(Math.random() * 9999);
        this.graph.nodes_executing[this.id] = true; //.push(this.id);
        this.onExecute(param, options);
        this.graph.nodes_executing[this.id] = false; //.pop();
        // save execution/action ref
        this.exec_version = this.graph.iteration;
        if (options && options.action_call) {
            this.action_call = options.action_call; // if (param)
            this.graph.nodes_executedAction[this.id] = options.action_call;
        }
    }
    else {
    }
    this.execute_triggered = 2; // the nFrames it will be used (-- each step), means "how old" is the event
    if (this.onAfterExecuteNode)
        this.onAfterExecuteNode(param, options); // callback
};
/**
 * Triggers an action, wrapped by logics to control execution flow
 * @method actionDo
 * @param {String} action name
 * @param {*} param
 */
LGraphNode.prototype.actionDo = function (action, param, options, action_slot) {
    options = options || {};
    if (this.onAction) {
        // enable this to give the event an ID
        if (!options.action_call)
            options.action_call = this.id + "_" + (action ? action : "action") + "_" + Math.floor(Math.random() * 9999);
        this.graph.nodes_actioning[this.id] = (action ? action : "actioning"); //.push(this.id);
        this.onAction(action, param, options, action_slot);
        this.graph.nodes_actioning[this.id] = false; //.pop();
        // save execution/action ref
        if (options && options.action_call) {
            this.action_call = options.action_call; // if (param)
            this.graph.nodes_executedAction[this.id] = options.action_call;
        }
    }
    this.action_triggered = 2; // the nFrames it will be used (-- each step), means "how old" is the event
    if (this.onAfterExecuteNode)
        this.onAfterExecuteNode(param, options);
};
/**
 * Triggers an event in this node, this will trigger any output with the same name
 * @method trigger
 * @param {String} event name ( "on_play", ... ) if action is equivalent to false then the event is send to all
 * @param {*} param
 */
LGraphNode.prototype.trigger = function (action, param, options) {
    if (!this.outputs || !this.outputs.length) {
        return;
    }
    if (this.graph)
        this.graph._last_trigger_time = exports.LiteGraph.getTime();
    for (var i = 0; i < this.outputs.length; ++i) {
        var output = this.outputs[i];
        if (!output || output.type !== exports.LiteGraph.EVENT || (action && output.name != action))
            continue;
        this.triggerSlot(i, param, null, options);
    }
};
/**
 * Triggers a slot event in this node: cycle output slots and launch execute/action on connected nodes
 * @method triggerSlot
 * @param {Number} slot the index of the output slot
 * @param {*} param
 * @param {Number} link_id [optional] in case you want to trigger and specific output link in a slot
 */
LGraphNode.prototype.triggerSlot = function (slot, param, link_id, options) {
    options = options || {};
    if (!this.outputs) {
        return;
    }
    if (slot == null) {
        console.error("slot must be a number");
        return;
    }
    if (slot.constructor !== Number)
        console.warn("slot must be a number, use node.trigger('name') if you want to use a string");
    var output = this.outputs[slot];
    if (!output) {
        return;
    }
    var links = output.links;
    if (!links || !links.length) {
        return;
    }
    if (this.graph) {
        this.graph._last_trigger_time = exports.LiteGraph.getTime();
    }
    //for every link attached here
    for (var k = 0; k < links.length; ++k) {
        var id = links[k];
        if (link_id != null && link_id != id) {
            //to skip links
            continue;
        }
        var link_info = this.graph.links[links[k]];
        if (!link_info) {
            //not connected
            continue;
        }
        link_info._last_time = exports.LiteGraph.getTime();
        var node = this.graph.getNodeById(link_info.target_id);
        if (!node) {
            //node not found?
            continue;
        }
        //used to mark events in graph
        var target_connection = node.inputs[link_info.target_slot];
        if (node.mode === exports.LiteGraph.ON_TRIGGER) {
            // generate unique trigger ID if not present
            if (!options.action_call)
                options.action_call = this.id + "_trigg_" + Math.floor(Math.random() * 9999);
            if (node.onExecute) {
                // -- wrapping node.onExecute(param); --
                node.doExecute(param, options);
            }
        }
        else if (node.onAction) {
            // generate unique action ID if not present
            if (!options.action_call)
                options.action_call = this.id + "_act_" + Math.floor(Math.random() * 9999);
            //pass the action name
            var target_connection = node.inputs[link_info.target_slot];
            //instead of executing them now, it will be executed in the next graph loop, to ensure data flow
            if (exports.LiteGraph.use_deferred_actions && node.onExecute) {
                if (!node._waiting_actions)
                    node._waiting_actions = [];
                node._waiting_actions.push([target_connection.name, param, options, link_info.target_slot]);
            }
            else {
                // wrap node.onAction(target_connection.name, param);
                node.actionDo(target_connection.name, param, options, link_info.target_slot);
            }
        }
    }
};
/**
 * clears the trigger slot animation
 * @method clearTriggeredSlot
 * @param {Number} slot the index of the output slot
 * @param {Number} link_id [optional] in case you want to trigger and specific output link in a slot
 */
LGraphNode.prototype.clearTriggeredSlot = function (slot, link_id) {
    if (!this.outputs) {
        return;
    }
    var output = this.outputs[slot];
    if (!output) {
        return;
    }
    var links = output.links;
    if (!links || !links.length) {
        return;
    }
    //for every link attached here
    for (var k = 0; k < links.length; ++k) {
        var id = links[k];
        if (link_id != null && link_id != id) {
            //to skip links
            continue;
        }
        var link_info = this.graph.links[links[k]];
        if (!link_info) {
            //not connected
            continue;
        }
        link_info._last_time = 0;
    }
};
/**
 * changes node size and triggers callback
 * @method setSize
 * @param {vec2} size
 */
LGraphNode.prototype.setSize = function (size) {
    this.size = size;
    if (this.onResize)
        this.onResize(this.size);
};
/**
 * add a new property to this node
 * @method addProperty
 * @param {string} name
 * @param {*} default_value
 * @param {string} type string defining the output type ("vec3","number",...)
 * @param {Object} extra_info this can be used to have special properties of the property (like values, etc)
 */
LGraphNode.prototype.addProperty = function (name, default_value, type, extra_info) {
    var o = { name: name, type: type, default_value: default_value };
    if (extra_info) {
        for (var i in extra_info) {
            o[i] = extra_info[i];
        }
    }
    if (!this.properties_info) {
        this.properties_info = [];
    }
    this.properties_info.push(o);
    if (!this.properties) {
        this.properties = {};
    }
    this.properties[name] = default_value;
    return o;
};
//connections
/**
 * add a new output slot to use in this node
 * @method addOutput
 * @param {string} name
 * @param {string} type string defining the output type ("vec3","number",...)
 * @param {Object} extra_info this can be used to have special properties of an output (label, special color, position, etc)
 */
LGraphNode.prototype.addOutput = function (name, type, extra_info) {
    var output = { name: name, type: type, links: null };
    if (extra_info) {
        for (var i in extra_info) {
            output[i] = extra_info[i];
        }
    }
    if (!this.outputs) {
        this.outputs = [];
    }
    this.outputs.push(output);
    if (this.onOutputAdded) {
        this.onOutputAdded(output);
    }
    if (exports.LiteGraph.auto_load_slot_types)
        exports.LiteGraph.registerNodeAndSlotType(this, type, true);
    this.setSize(this.computeSize());
    this.setDirtyCanvas(true, true);
    return output;
};
/**
 * add a new output slot to use in this node
 * @method addOutputs
 * @param {Array} array of triplets like [[name,type,extra_info],[...]]
 */
LGraphNode.prototype.addOutputs = function (array) {
    for (var i = 0; i < array.length; ++i) {
        var info = array[i];
        var o = { name: info[0], type: info[1], link: null };
        if (array[2]) {
            for (var j in info[2]) {
                o[j] = info[2][j];
            }
        }
        if (!this.outputs) {
            this.outputs = [];
        }
        this.outputs.push(o);
        if (this.onOutputAdded) {
            this.onOutputAdded(o);
        }
        if (exports.LiteGraph.auto_load_slot_types)
            exports.LiteGraph.registerNodeAndSlotType(this, info[1], true);
    }
    this.setSize(this.computeSize());
    this.setDirtyCanvas(true, true);
};
/**
 * remove an existing output slot
 * @method removeOutput
 * @param {number} slot
 */
LGraphNode.prototype.removeOutput = function (slot) {
    this.disconnectOutput(slot);
    this.outputs.splice(slot, 1);
    for (var i = slot; i < this.outputs.length; ++i) {
        if (!this.outputs[i] || !this.outputs[i].links) {
            continue;
        }
        var links = this.outputs[i].links;
        for (var j = 0; j < links.length; ++j) {
            var link = this.graph.links[links[j]];
            if (!link) {
                continue;
            }
            link.origin_slot -= 1;
        }
    }
    this.setSize(this.computeSize());
    if (this.onOutputRemoved) {
        this.onOutputRemoved(slot);
    }
    this.setDirtyCanvas(true, true);
};
/**
 * add a new input slot to use in this node
 * @method addInput
 * @param {string} name
 * @param {string} type string defining the input type ("vec3","number",...), it its a generic one use 0
 * @param {Object} extra_info this can be used to have special properties of an input (label, color, position, etc)
 */
LGraphNode.prototype.addInput = function (name, type, extra_info) {
    type = type || 0;
    var input = { name: name, type: type, link: null };
    if (extra_info) {
        for (var i in extra_info) {
            input[i] = extra_info[i];
        }
    }
    if (!this.inputs) {
        this.inputs = [];
    }
    this.inputs.push(input);
    this.setSize(this.computeSize());
    if (this.onInputAdded) {
        this.onInputAdded(input);
    }
    exports.LiteGraph.registerNodeAndSlotType(this, type);
    this.setDirtyCanvas(true, true);
    return input;
};
/**
 * add several new input slots in this node
 * @method addInputs
 * @param {Array} array of triplets like [[name,type,extra_info],[...]]
 */
LGraphNode.prototype.addInputs = function (array) {
    for (var i = 0; i < array.length; ++i) {
        var info = array[i];
        var o = { name: info[0], type: info[1], link: null };
        if (array[2]) {
            for (var j in info[2]) {
                o[j] = info[2][j];
            }
        }
        if (!this.inputs) {
            this.inputs = [];
        }
        this.inputs.push(o);
        if (this.onInputAdded) {
            this.onInputAdded(o);
        }
        exports.LiteGraph.registerNodeAndSlotType(this, info[1]);
    }
    this.setSize(this.computeSize());
    this.setDirtyCanvas(true, true);
};
/**
 * remove an existing input slot
 * @method removeInput
 * @param {number} slot
 */
LGraphNode.prototype.removeInput = function (slot) {
    this.disconnectInput(slot);
    var slot_info = this.inputs.splice(slot, 1);
    for (var i = slot; i < this.inputs.length; ++i) {
        if (!this.inputs[i]) {
            continue;
        }
        var link = this.graph.links[this.inputs[i].link];
        if (!link) {
            continue;
        }
        link.target_slot -= 1;
    }
    this.setSize(this.computeSize());
    if (this.onInputRemoved) {
        this.onInputRemoved(slot, slot_info[0]);
    }
    this.setDirtyCanvas(true, true);
};
/**
 * add an special connection to this node (used for special kinds of graphs)
 * @method addConnection
 * @param {string} name
 * @param {string} type string defining the input type ("vec3","number",...)
 * @param {[x,y]} pos position of the connection inside the node
 * @param {string} direction if is input or output
 */
LGraphNode.prototype.addConnection = function (name, type, pos, direction) {
    var o = {
        name: name,
        type: type,
        pos: pos,
        direction: direction,
        links: null
    };
    this.connections.push(o);
    return o;
};
/**
 * computes the minimum size of a node according to its inputs and output slots
 * @method computeSize
 * @param {vec2} minHeight
 * @return {vec2} the total size
 */
LGraphNode.prototype.computeSize = function (out) {
    if (this.constructor.size) {
        return this.constructor.size.concat();
    }
    var rows = Math.max(this.inputs ? this.inputs.length : 1, this.outputs ? this.outputs.length : 1);
    var size = out || new Float32Array([0, 0]);
    rows = Math.max(rows, 1);
    var font_size = exports.LiteGraph.NODE_TEXT_SIZE; //although it should be graphcanvas.inner_text_font size
    var title_width = compute_text_size(this.title);
    var input_width = 0;
    var output_width = 0;
    if (this.inputs) {
        for (var i = 0, l = this.inputs.length; i < l; ++i) {
            var input = this.inputs[i];
            var text = input.label || input.name || "";
            var text_width = compute_text_size(text);
            if (input_width < text_width) {
                input_width = text_width;
            }
        }
    }
    if (this.outputs) {
        for (var i = 0, l = this.outputs.length; i < l; ++i) {
            var output = this.outputs[i];
            var text = output.label || output.name || "";
            var text_width = compute_text_size(text);
            if (output_width < text_width) {
                output_width = text_width;
            }
        }
    }
    size[0] = Math.max(input_width + output_width + 10, title_width);
    size[0] = Math.max(size[0], exports.LiteGraph.NODE_WIDTH);
    if (this.widgets && this.widgets.length) {
        size[0] = Math.max(size[0], exports.LiteGraph.NODE_WIDTH * 1.5);
    }
    size[1] = (this.constructor.slot_start_y || 0) + rows * exports.LiteGraph.NODE_SLOT_HEIGHT;
    var widgets_height = 0;
    if (this.widgets && this.widgets.length) {
        for (var i = 0, l = this.widgets.length; i < l; ++i) {
            if (this.widgets[i].computeSize)
                widgets_height += this.widgets[i].computeSize(size[0])[1] + 4;
            else
                widgets_height += exports.LiteGraph.NODE_WIDGET_HEIGHT + 4;
        }
        widgets_height += 8;
    }
    //compute height using widgets height
    if (this.widgets_up)
        size[1] = Math.max(size[1], widgets_height);
    else if (this.widgets_start_y != null)
        size[1] = Math.max(size[1], widgets_height + this.widgets_start_y);
    else
        size[1] += widgets_height;
    function compute_text_size(text) {
        if (!text) {
            return 0;
        }
        return font_size * text.length * 0.6;
    }
    if (this.constructor.min_height &&
        size[1] < this.constructor.min_height) {
        size[1] = this.constructor.min_height;
    }
    size[1] += 6; //margin
    return size;
};
/**
 * returns all the info available about a property of this node.
 *
 * @method getPropertyInfo
 * @param {String} property name of the property
 * @return {Object} the object with all the available info
*/
LGraphNode.prototype.getPropertyInfo = function (property) {
    var info = null;
    //there are several ways to define info about a property
    //legacy mode
    if (this.properties_info) {
        for (var i = 0; i < this.properties_info.length; ++i) {
            if (this.properties_info[i].name == property) {
                info = this.properties_info[i];
                break;
            }
        }
    }
    //litescene mode using the constructor
    if (this.constructor["@" + property])
        info = this.constructor["@" + property];
    if (this.constructor.widgets_info && this.constructor.widgets_info[property])
        info = this.constructor.widgets_info[property];
    //litescene mode using the constructor
    if (!info && this.onGetPropertyInfo) {
        info = this.onGetPropertyInfo(property);
    }
    if (!info)
        info = {};
    if (!info.type)
        info.type = typeof this.properties[property];
    if (info.widget == "combo")
        info.type = "enum";
    return info;
};
/**
 * Defines a widget inside the node, it will be rendered on top of the node, you can control lots of properties
 *
 * @method addWidget
 * @param {String} type the widget type (could be "number","string","combo"
 * @param {String} name the text to show on the widget
 * @param {String} value the default value
 * @param {Function|String} callback function to call when it changes (optionally, it can be the name of the property to modify)
 * @param {Object} options the object that contains special properties of this widget
 * @return {Object} the created widget object
 */
LGraphNode.prototype.addWidget = function (type, name, value, callback, options) {
    if (!this.widgets) {
        this.widgets = [];
    }
    if (!options && callback && callback.constructor === Object) {
        options = callback;
        callback = null;
    }
    if (options && options.constructor === String) //options can be the property name
        options = { property: options };
    if (callback && callback.constructor === String) //callback can be the property name
     {
        if (!options)
            options = {};
        options.property = callback;
        callback = null;
    }
    if (callback && callback.constructor !== Function) {
        console.warn("addWidget: callback must be a function");
        callback = null;
    }
    var w = {
        type: type.toLowerCase(),
        name: name,
        value: value,
        callback: callback,
        options: options || {}
    };
    if (w.options.y !== undefined) {
        w.y = w.options.y;
    }
    if (!callback && !w.options.callback && !w.options.property) {
        console.warn("LiteGraph addWidget(...) without a callback or property assigned");
    }
    if (type == "combo" && !w.options.values) {
        throw "LiteGraph addWidget('combo',...) requires to pass values in options: { values:['red','blue'] }";
    }
    this.widgets.push(w);
    this.setSize(this.computeSize());
    return w;
};
LGraphNode.prototype.addCustomWidget = function (custom_widget) {
    if (!this.widgets) {
        this.widgets = [];
    }
    this.widgets.push(custom_widget);
    return custom_widget;
};
/**
 * returns the bounding of the object, used for rendering purposes
 * @method getBounding
 * @param out {Float32Array[4]?} [optional] a place to store the output, to free garbage
 * @param compute_outer {boolean?} [optional] set to true to include the shadow and connection points in the bounding calculation
 * @return {Float32Array[4]} the bounding box in format of [topleft_cornerx, topleft_cornery, width, height]
 */
LGraphNode.prototype.getBounding = function (out, compute_outer) {
    out = out || new Float32Array(4);
    var nodePos = this.pos;
    var isCollapsed = this.flags.collapsed;
    var nodeSize = this.size;
    var left_offset = 0;
    // 1 offset due to how nodes are rendered
    var right_offset = 1;
    var top_offset = 0;
    var bottom_offset = 0;
    if (compute_outer) {
        // 4 offset for collapsed node connection points
        left_offset = 4;
        // 6 offset for right shadow and collapsed node connection points
        right_offset = 6 + left_offset;
        // 4 offset for collapsed nodes top connection points
        top_offset = 4;
        // 5 offset for bottom shadow and collapsed node connection points
        bottom_offset = 5 + top_offset;
    }
    out[0] = nodePos[0] - left_offset;
    out[1] = nodePos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT - top_offset;
    out[2] = isCollapsed ?
        (this._collapsed_width || exports.LiteGraph.NODE_COLLAPSED_WIDTH) + right_offset :
        nodeSize[0] + right_offset;
    out[3] = isCollapsed ?
        exports.LiteGraph.NODE_TITLE_HEIGHT + bottom_offset :
        nodeSize[1] + exports.LiteGraph.NODE_TITLE_HEIGHT + bottom_offset;
    if (this.onBounding) {
        this.onBounding(out);
    }
    return out;
};
/**
 * checks if a point is inside the shape of a node
 * @method isPointInside
 * @param {number} x
 * @param {number} y
 * @return {boolean}
 */
LGraphNode.prototype.isPointInside = function (x, y, margin, skip_title) {
    margin = margin || 0;
    var margin_top = this.graph && this.graph.isLive() ? 0 : exports.LiteGraph.NODE_TITLE_HEIGHT;
    if (skip_title) {
        margin_top = 0;
    }
    if (this.flags && this.flags.collapsed) {
        //if ( distance([x,y], [this.pos[0] + this.size[0]*0.5, this.pos[1] + this.size[1]*0.5]) < LiteGraph.NODE_COLLAPSED_RADIUS)
        if (isInsideRectangle(x, y, this.pos[0] - margin, this.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT - margin, (this._collapsed_width || exports.LiteGraph.NODE_COLLAPSED_WIDTH) +
            2 * margin, exports.LiteGraph.NODE_TITLE_HEIGHT + 2 * margin)) {
            return true;
        }
    }
    else if (this.pos[0] - 4 - margin < x &&
        this.pos[0] + this.size[0] + 4 + margin > x &&
        this.pos[1] - margin_top - margin < y &&
        this.pos[1] + this.size[1] + margin > y) {
        return true;
    }
    return false;
};
/**
 * checks if a point is inside a node slot, and returns info about which slot
 * @method getSlotInPosition
 * @param {number} x
 * @param {number} y
 * @return {Object} if found the object contains { input|output: slot object, slot: number, link_pos: [x,y] }
 */
LGraphNode.prototype.getSlotInPosition = function (x, y) {
    //search for inputs
    var link_pos = new Float32Array(2);
    if (this.inputs) {
        for (var i = 0, l = this.inputs.length; i < l; ++i) {
            var input = this.inputs[i];
            this.getConnectionPos(true, i, link_pos);
            if (isInsideRectangle(x, y, link_pos[0] - 10, link_pos[1] - 5, 20, 10)) {
                return { input: input, slot: i, link_pos: link_pos };
            }
        }
    }
    if (this.outputs) {
        for (var i = 0, l = this.outputs.length; i < l; ++i) {
            var output = this.outputs[i];
            this.getConnectionPos(false, i, link_pos);
            if (isInsideRectangle(x, y, link_pos[0] - 10, link_pos[1] - 5, 20, 10)) {
                return { output: output, slot: i, link_pos: link_pos };
            }
        }
    }
    return null;
};
/**
 * returns the input slot with a given name (used for dynamic slots), -1 if not found
 * @method findInputSlot
 * @param {string} name the name of the slot
 * @param {boolean} returnObj if the obj itself wanted
 * @return {number_or_object} the slot (-1 if not found)
 */
LGraphNode.prototype.findInputSlot = function (name, returnObj) {
    if (!this.inputs) {
        return -1;
    }
    for (var i = 0, l = this.inputs.length; i < l; ++i) {
        if (name == this.inputs[i].name) {
            return !returnObj ? i : this.inputs[i];
        }
    }
    return -1;
};
/**
 * returns the output slot with a given name (used for dynamic slots), -1 if not found
 * @method findOutputSlot
 * @param {string} name the name of the slot
 * @param {boolean} returnObj if the obj itself wanted
 * @return {number_or_object} the slot (-1 if not found)
 */
LGraphNode.prototype.findOutputSlot = function (name, returnObj) {
    returnObj = returnObj || false;
    if (!this.outputs) {
        return -1;
    }
    for (var i = 0, l = this.outputs.length; i < l; ++i) {
        if (name == this.outputs[i].name) {
            return !returnObj ? i : this.outputs[i];
        }
    }
    return -1;
};
// TODO refactor: USE SINGLE findInput/findOutput functions! :: merge options
/**
 * returns the first free input slot
 * @method findInputSlotFree
 * @param {object} options
 * @return {number_or_object} the slot (-1 if not found)
 */
LGraphNode.prototype.findInputSlotFree = function (optsIn) {
    var optsIn = optsIn || {};
    var optsDef = { returnObj: false,
        typesNotAccepted: []
    };
    var opts = Object.assign(optsDef, optsIn);
    if (!this.inputs) {
        return -1;
    }
    for (var i = 0, l = this.inputs.length; i < l; ++i) {
        if (this.inputs[i].link && this.inputs[i].link != null) {
            continue;
        }
        if (opts.typesNotAccepted && opts.typesNotAccepted.includes && opts.typesNotAccepted.includes(this.inputs[i].type)) {
            continue;
        }
        return !opts.returnObj ? i : this.inputs[i];
    }
    return -1;
};
/**
 * returns the first output slot free
 * @method findOutputSlotFree
 * @param {object} options
 * @return {number_or_object} the slot (-1 if not found)
 */
LGraphNode.prototype.findOutputSlotFree = function (optsIn) {
    var optsIn = optsIn || {};
    var optsDef = { returnObj: false,
        typesNotAccepted: []
    };
    var opts = Object.assign(optsDef, optsIn);
    if (!this.outputs) {
        return -1;
    }
    for (var i = 0, l = this.outputs.length; i < l; ++i) {
        if (this.outputs[i].links && this.outputs[i].links != null) {
            continue;
        }
        if (opts.typesNotAccepted && opts.typesNotAccepted.includes && opts.typesNotAccepted.includes(this.outputs[i].type)) {
            continue;
        }
        return !opts.returnObj ? i : this.outputs[i];
    }
    return -1;
};
/**
 * findSlotByType for INPUTS
 */
LGraphNode.prototype.findInputSlotByType = function (type, returnObj, preferFreeSlot, doNotUseOccupied) {
    return this.findSlotByType(true, type, returnObj, preferFreeSlot, doNotUseOccupied);
};
/**
 * findSlotByType for OUTPUTS
 */
LGraphNode.prototype.findOutputSlotByType = function (type, returnObj, preferFreeSlot, doNotUseOccupied) {
    return this.findSlotByType(false, type, returnObj, preferFreeSlot, doNotUseOccupied);
};
/**
 * returns the output (or input) slot with a given type, -1 if not found
 * @method findSlotByType
 * @param {boolean} input uise inputs instead of outputs
 * @param {string} type the type of the slot
 * @param {boolean} returnObj if the obj itself wanted
 * @param {boolean} preferFreeSlot if we want a free slot (if not found, will return the first of the type anyway)
 * @return {number_or_object} the slot (-1 if not found)
 */
LGraphNode.prototype.findSlotByType = function (input, type, returnObj, preferFreeSlot, doNotUseOccupied) {
    input = input || false;
    returnObj = returnObj || false;
    preferFreeSlot = preferFreeSlot || false;
    doNotUseOccupied = doNotUseOccupied || false;
    var aSlots = input ? this.inputs : this.outputs;
    if (!aSlots) {
        return -1;
    }
    // !! empty string type is considered 0, * !!
    if (type == "" || type == "*")
        type = 0;
    for (var i = 0, l = aSlots.length; i < l; ++i) {
        var tFound = false;
        var aSource = (type + "").toLowerCase().split(",");
        var aDest = aSlots[i].type == "0" || aSlots[i].type == "*" ? "0" : aSlots[i].type;
        aDest = (aDest + "").toLowerCase().split(",");
        for (var sI = 0; sI < aSource.length; sI++) {
            for (var dI = 0; dI < aDest.length; dI++) {
                if (aSource[sI] == "_event_")
                    aSource[sI] = exports.LiteGraph.EVENT;
                if (aDest[sI] == "_event_")
                    aDest[sI] = exports.LiteGraph.EVENT;
                if (aSource[sI] == "*")
                    aSource[sI] = 0;
                if (aDest[sI] == "*")
                    aDest[sI] = 0;
                if (aSource[sI] == aDest[dI]) {
                    if (preferFreeSlot && aSlots[i].links && aSlots[i].links !== null)
                        continue;
                    return !returnObj ? i : aSlots[i];
                }
            }
        }
    }
    // if didnt find some, stop checking for free slots
    if (preferFreeSlot && !doNotUseOccupied) {
        for (var i = 0, l = aSlots.length; i < l; ++i) {
            var tFound = false;
            var aSource = (type + "").toLowerCase().split(",");
            var aDest = aSlots[i].type == "0" || aSlots[i].type == "*" ? "0" : aSlots[i].type;
            aDest = (aDest + "").toLowerCase().split(",");
            for (var sI = 0; sI < aSource.length; sI++) {
                for (var dI = 0; dI < aDest.length; dI++) {
                    if (aSource[sI] == "*")
                        aSource[sI] = 0;
                    if (aDest[sI] == "*")
                        aDest[sI] = 0;
                    if (aSource[sI] == aDest[dI]) {
                        return !returnObj ? i : aSlots[i];
                    }
                }
            }
        }
    }
    return -1;
};
/**
 * connect this node output to the input of another node BY TYPE
 * @method connectByType
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @param {LGraphNode} node the target node
 * @param {string} target_type the input slot type of the target node
 * @return {Object} the link_info is created, otherwise null
 */
LGraphNode.prototype.connectByType = function (slot, target_node, target_slotType, optsIn) {
    var optsIn = optsIn || {};
    var optsDef = { createEventInCase: true,
        firstFreeIfOutputGeneralInCase: true,
        generalTypeInCase: true
    };
    var opts = Object.assign(optsDef, optsIn);
    if (target_node && target_node.constructor === Number) {
        target_node = this.graph.getNodeById(target_node);
    }
    var target_slot = target_node.findInputSlotByType(target_slotType, false, true);
    if (target_slot >= 0 && target_slot !== null) {
        //console.debug("CONNbyTYPE type "+target_slotType+" for "+target_slot)
        return this.connect(slot, target_node, target_slot);
    }
    else {
        //console.log("type "+target_slotType+" not found or not free?")
        if (opts.createEventInCase && target_slotType == exports.LiteGraph.EVENT) {
            // WILL CREATE THE onTrigger IN SLOT
            //console.debug("connect WILL CREATE THE onTrigger "+target_slotType+" to "+target_node);
            return this.connect(slot, target_node, -1);
        }
        // connect to the first general output slot if not found a specific type and 
        if (opts.generalTypeInCase) {
            var target_slot = target_node.findInputSlotByType(0, false, true, true);
            //console.debug("connect TO a general type (*, 0), if not found the specific type ",target_slotType," to ",target_node,"RES_SLOT:",target_slot);
            if (target_slot >= 0) {
                return this.connect(slot, target_node, target_slot);
            }
        }
        // connect to the first free input slot if not found a specific type and this output is general
        if (opts.firstFreeIfOutputGeneralInCase && (target_slotType == 0 || target_slotType == "*" || target_slotType == "")) {
            var target_slot = target_node.findInputSlotFree({ typesNotAccepted: [exports.LiteGraph.EVENT] });
            //console.debug("connect TO TheFirstFREE ",target_slotType," to ",target_node,"RES_SLOT:",target_slot);
            if (target_slot >= 0) {
                return this.connect(slot, target_node, target_slot);
            }
        }
        console.debug("no way to connect type: ", target_slotType, " to targetNODE ", target_node);
        //TODO filter
        return null;
    }
};
/**
 * connect this node input to the output of another node BY TYPE
 * @method connectByType
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @param {LGraphNode} node the target node
 * @param {string} target_type the output slot type of the target node
 * @return {Object} the link_info is created, otherwise null
 */
LGraphNode.prototype.connectByTypeOutput = function (slot, source_node, source_slotType, optsIn) {
    var optsIn = optsIn || {};
    var optsDef = { createEventInCase: true,
        firstFreeIfInputGeneralInCase: true,
        generalTypeInCase: true
    };
    var opts = Object.assign(optsDef, optsIn);
    if (source_node && source_node.constructor === Number) {
        source_node = this.graph.getNodeById(source_node);
    }
    var source_slot = source_node.findOutputSlotByType(source_slotType, false, true);
    if (source_slot >= 0 && source_slot !== null) {
        //console.debug("CONNbyTYPE OUT! type "+source_slotType+" for "+source_slot)
        return source_node.connect(source_slot, this, slot);
    }
    else {
        // connect to the first general output slot if not found a specific type and 
        if (opts.generalTypeInCase) {
            var source_slot = source_node.findOutputSlotByType(0, false, true, true);
            if (source_slot >= 0) {
                return source_node.connect(source_slot, this, slot);
            }
        }
        if (opts.createEventInCase && source_slotType == exports.LiteGraph.EVENT) {
            // WILL CREATE THE onExecuted OUT SLOT
            if (exports.LiteGraph.do_add_triggers_slots) {
                var source_slot = source_node.addOnExecutedOutput();
                return source_node.connect(source_slot, this, slot);
            }
        }
        // connect to the first free output slot if not found a specific type and this input is general
        if (opts.firstFreeIfInputGeneralInCase && (source_slotType == 0 || source_slotType == "*" || source_slotType == "")) {
            var source_slot = source_node.findOutputSlotFree({ typesNotAccepted: [exports.LiteGraph.EVENT] });
            if (source_slot >= 0) {
                return source_node.connect(source_slot, this, slot);
            }
        }
        console.debug("no way to connect byOUT type: ", source_slotType, " to sourceNODE ", source_node);
        //TODO filter
        //console.log("type OUT! "+source_slotType+" not found or not free?")
        return null;
    }
};
/**
 * connect this node output to the input of another node
 * @method connect
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @param {LGraphNode} node the target node
 * @param {number_or_string} target_slot the input slot of the target node (could be the number of the slot or the string with the name of the slot, or -1 to connect a trigger)
 * @return {Object} the link_info is created, otherwise null
 */
LGraphNode.prototype.connect = function (slot, target_node, target_slot) {
    target_slot = target_slot || 0;
    if (!this.graph) {
        //could be connected before adding it to a graph
        console.log("Connect: Error, node doesn't belong to any graph. Nodes must be added first to a graph before connecting them."); //due to link ids being associated with graphs
        return null;
    }
    //seek for the output slot
    if (slot.constructor === String) {
        slot = this.findOutputSlot(slot);
        if (slot == -1) {
            if (exports.LiteGraph.debug) {
                console.log("Connect: Error, no slot of name " + slot);
            }
            return null;
        }
    }
    else if (!this.outputs || slot >= this.outputs.length) {
        if (exports.LiteGraph.debug) {
            console.log("Connect: Error, slot number not found");
        }
        return null;
    }
    if (target_node && target_node.constructor === Number) {
        target_node = this.graph.getNodeById(target_node);
    }
    if (!target_node) {
        throw "target node is null";
    }
    //avoid loopback
    if (target_node == this) {
        return null;
    }
    //you can specify the slot by name
    if (target_slot.constructor === String) {
        target_slot = target_node.findInputSlot(target_slot);
        if (target_slot == -1) {
            if (exports.LiteGraph.debug) {
                console.log("Connect: Error, no slot of name " + target_slot);
            }
            return null;
        }
    }
    else if (target_slot === exports.LiteGraph.EVENT) {
        if (exports.LiteGraph.do_add_triggers_slots) {
            //search for first slot with event? :: NO this is done outside
            //console.log("Connect: Creating triggerEvent");
            // force mode
            target_node.changeMode(exports.LiteGraph.ON_TRIGGER);
            target_slot = target_node.findInputSlot("onTrigger");
        }
        else {
            return null; // -- break --
        }
    }
    else if (!target_node.inputs ||
        target_slot >= target_node.inputs.length) {
        if (exports.LiteGraph.debug) {
            console.log("Connect: Error, slot number not found");
        }
        return null;
    }
    var changed = false;
    var input = target_node.inputs[target_slot];
    var link_info = null;
    var output = this.outputs[slot];
    if (!this.outputs[slot]) {
        /*console.debug("Invalid slot passed: "+slot);
        console.debug(this.outputs);*/
        return null;
    }
    // allow target node to change slot
    if (target_node.onBeforeConnectInput) {
        // This way node can choose another slot (or make a new one?)
        target_slot = target_node.onBeforeConnectInput(target_slot); //callback
    }
    //check target_slot and check connection types
    if (target_slot === false || target_slot === null || !exports.LiteGraph.isValidConnection(output.type, input.type)) {
        this.setDirtyCanvas(false, true);
        if (changed)
            this.graph.connectionChange(this, link_info);
        return null;
    }
    else {
        //console.debug("valid connection",output.type, input.type);
    }
    //allows nodes to block connection, callback
    if (target_node.onConnectInput) {
        if (target_node.onConnectInput(target_slot, output.type, output, this, slot) === false) {
            return null;
        }
    }
    if (this.onConnectOutput) { // callback
        if (this.onConnectOutput(slot, input.type, input, target_node, target_slot) === false) {
            return null;
        }
    }
    //if there is something already plugged there, disconnect
    if (target_node.inputs[target_slot] && target_node.inputs[target_slot].link != null) {
        this.graph.beforeChange();
        target_node.disconnectInput(target_slot, { doProcessChange: false });
        changed = true;
    }
    if (output.links !== null && output.links.length) {
        switch (output.type) {
            case exports.LiteGraph.EVENT:
                if (!exports.LiteGraph.allow_multi_output_for_events) {
                    this.graph.beforeChange();
                    this.disconnectOutput(slot, false, { doProcessChange: false }); // Input(target_slot, {doProcessChange: false});
                    changed = true;
                }
                break;
            default:
                break;
        }
    }
    var nextId;
    if (exports.LiteGraph.use_uuids)
        nextId = exports.LiteGraph.uuidv4();
    else
        nextId = ++this.graph.last_link_id;
    //create link class
    link_info = new LLink(nextId, input.type || output.type, this.id, slot, target_node.id, target_slot);
    //add to graph links list
    this.graph.links[link_info.id] = link_info;
    //connect in output
    if (output.links == null) {
        output.links = [];
    }
    output.links.push(link_info.id);
    //connect in input
    target_node.inputs[target_slot].link = link_info.id;
    if (this.graph) {
        this.graph._version++;
    }
    if (this.onConnectionsChange) {
        this.onConnectionsChange(exports.LiteGraph.OUTPUT, slot, true, link_info, output);
    } //link_info has been created now, so its updated
    if (target_node.onConnectionsChange) {
        target_node.onConnectionsChange(exports.LiteGraph.INPUT, target_slot, true, link_info, input);
    }
    if (this.graph && this.graph.onNodeConnectionChange) {
        this.graph.onNodeConnectionChange(exports.LiteGraph.INPUT, target_node, target_slot, this, slot);
        this.graph.onNodeConnectionChange(exports.LiteGraph.OUTPUT, this, slot, target_node, target_slot);
    }
    this.setDirtyCanvas(false, true);
    this.graph.afterChange();
    this.graph.connectionChange(this, link_info);
    return link_info;
};
/**
 * disconnect one output to an specific node
 * @method disconnectOutput
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @param {LGraphNode} target_node the target node to which this slot is connected [Optional, if not target_node is specified all nodes will be disconnected]
 * @return {boolean} if it was disconnected successfully
 */
LGraphNode.prototype.disconnectOutput = function (slot, target_node) {
    if (slot.constructor === String) {
        slot = this.findOutputSlot(slot);
        if (slot == -1) {
            if (exports.LiteGraph.debug) {
                console.log("Connect: Error, no slot of name " + slot);
            }
            return false;
        }
    }
    else if (!this.outputs || slot >= this.outputs.length) {
        if (exports.LiteGraph.debug) {
            console.log("Connect: Error, slot number not found");
        }
        return false;
    }
    //get output slot
    var output = this.outputs[slot];
    if (!output || !output.links || output.links.length == 0) {
        return false;
    }
    //one of the output links in this slot
    if (target_node) {
        if (target_node.constructor === Number) {
            target_node = this.graph.getNodeById(target_node);
        }
        if (!target_node) {
            throw "Target Node not found";
        }
        for (var i = 0, l = output.links.length; i < l; i++) {
            var link_id = output.links[i];
            var link_info = this.graph.links[link_id];
            //is the link we are searching for...
            if (link_info.target_id == target_node.id) {
                output.links.splice(i, 1); //remove here
                var input = target_node.inputs[link_info.target_slot];
                input.link = null; //remove there
                delete this.graph.links[link_id]; //remove the link from the links pool
                if (this.graph) {
                    this.graph._version++;
                }
                if (target_node.onConnectionsChange) {
                    target_node.onConnectionsChange(exports.LiteGraph.INPUT, link_info.target_slot, false, link_info, input);
                } //link_info hasn't been modified so its ok
                if (this.onConnectionsChange) {
                    this.onConnectionsChange(exports.LiteGraph.OUTPUT, slot, false, link_info, output);
                }
                if (this.graph && this.graph.onNodeConnectionChange) {
                    this.graph.onNodeConnectionChange(exports.LiteGraph.OUTPUT, this, slot);
                }
                if (this.graph && this.graph.onNodeConnectionChange) {
                    this.graph.onNodeConnectionChange(exports.LiteGraph.OUTPUT, this, slot);
                    this.graph.onNodeConnectionChange(exports.LiteGraph.INPUT, target_node, link_info.target_slot);
                }
                break;
            }
        }
    } //all the links in this output slot
    else {
        for (var i = 0, l = output.links.length; i < l; i++) {
            var link_id = output.links[i];
            var link_info = this.graph.links[link_id];
            if (!link_info) {
                //bug: it happens sometimes
                continue;
            }
            var target_node = this.graph.getNodeById(link_info.target_id);
            var input = null;
            if (this.graph) {
                this.graph._version++;
            }
            if (target_node) {
                input = target_node.inputs[link_info.target_slot];
                input.link = null; //remove other side link
                if (target_node.onConnectionsChange) {
                    target_node.onConnectionsChange(exports.LiteGraph.INPUT, link_info.target_slot, false, link_info, input);
                } //link_info hasn't been modified so its ok
                if (this.graph && this.graph.onNodeConnectionChange) {
                    this.graph.onNodeConnectionChange(exports.LiteGraph.INPUT, target_node, link_info.target_slot);
                }
            }
            delete this.graph.links[link_id]; //remove the link from the links pool
            if (this.onConnectionsChange) {
                this.onConnectionsChange(exports.LiteGraph.OUTPUT, slot, false, link_info, output);
            }
            if (this.graph && this.graph.onNodeConnectionChange) {
                this.graph.onNodeConnectionChange(exports.LiteGraph.OUTPUT, this, slot);
                this.graph.onNodeConnectionChange(exports.LiteGraph.INPUT, target_node, link_info.target_slot);
            }
        }
        output.links = null;
    }
    this.setDirtyCanvas(false, true);
    this.graph.connectionChange(this);
    return true;
};
/**
 * disconnect one input
 * @method disconnectInput
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @return {boolean} if it was disconnected successfully
 */
LGraphNode.prototype.disconnectInput = function (slot) {
    //seek for the output slot
    if (slot.constructor === String) {
        slot = this.findInputSlot(slot);
        if (slot == -1) {
            if (exports.LiteGraph.debug) {
                console.log("Connect: Error, no slot of name " + slot);
            }
            return false;
        }
    }
    else if (!this.inputs || slot >= this.inputs.length) {
        if (exports.LiteGraph.debug) {
            console.log("Connect: Error, slot number not found");
        }
        return false;
    }
    var input = this.inputs[slot];
    if (!input) {
        return false;
    }
    var link_id = this.inputs[slot].link;
    if (link_id != null) {
        this.inputs[slot].link = null;
        //remove other side
        var link_info = this.graph.links[link_id];
        if (link_info) {
            var target_node = this.graph.getNodeById(link_info.origin_id);
            if (!target_node) {
                return false;
            }
            var output = target_node.outputs[link_info.origin_slot];
            if (!output || !output.links || output.links.length == 0) {
                return false;
            }
            //search in the inputs list for this link
            for (var i = 0, l = output.links.length; i < l; i++) {
                if (output.links[i] == link_id) {
                    output.links.splice(i, 1);
                    break;
                }
            }
            delete this.graph.links[link_id]; //remove from the pool
            if (this.graph) {
                this.graph._version++;
            }
            if (this.onConnectionsChange) {
                this.onConnectionsChange(exports.LiteGraph.INPUT, slot, false, link_info, input);
            }
            if (target_node.onConnectionsChange) {
                target_node.onConnectionsChange(exports.LiteGraph.OUTPUT, i, false, link_info, output);
            }
            if (this.graph && this.graph.onNodeConnectionChange) {
                this.graph.onNodeConnectionChange(exports.LiteGraph.OUTPUT, target_node, i);
                this.graph.onNodeConnectionChange(exports.LiteGraph.INPUT, this, slot);
            }
        }
    } //link != null
    this.setDirtyCanvas(false, true);
    if (this.graph)
        this.graph.connectionChange(this);
    return true;
};
/**
 * returns the center of a connection point in canvas coords
 * @method getConnectionPos
 * @param {boolean} is_input true if if a input slot, false if it is an output
 * @param {number_or_string} slot (could be the number of the slot or the string with the name of the slot)
 * @param {vec2} out [optional] a place to store the output, to free garbage
 * @return {[x,y]} the position
 **/
LGraphNode.prototype.getConnectionPos = function (is_input, slot_number, out) {
    out = out || new Float32Array(2);
    var num_slots = 0;
    if (is_input && this.inputs) {
        num_slots = this.inputs.length;
    }
    if (!is_input && this.outputs) {
        num_slots = this.outputs.length;
    }
    var offset = exports.LiteGraph.NODE_SLOT_HEIGHT * 0.5;
    if (this.flags.collapsed) {
        var w = this._collapsed_width || exports.LiteGraph.NODE_COLLAPSED_WIDTH;
        if (this.horizontal) {
            out[0] = this.pos[0] + w * 0.5;
            if (is_input) {
                out[1] = this.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT;
            }
            else {
                out[1] = this.pos[1];
            }
        }
        else {
            if (is_input) {
                out[0] = this.pos[0];
            }
            else {
                out[0] = this.pos[0] + w;
            }
            out[1] = this.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT * 0.5;
        }
        return out;
    }
    //weird feature that never got finished
    if (is_input && slot_number == -1) {
        out[0] = this.pos[0] + exports.LiteGraph.NODE_TITLE_HEIGHT * 0.5;
        out[1] = this.pos[1] + exports.LiteGraph.NODE_TITLE_HEIGHT * 0.5;
        return out;
    }
    //hard-coded pos
    if (is_input &&
        num_slots > slot_number &&
        this.inputs[slot_number].pos) {
        out[0] = this.pos[0] + this.inputs[slot_number].pos[0];
        out[1] = this.pos[1] + this.inputs[slot_number].pos[1];
        return out;
    }
    else if (!is_input &&
        num_slots > slot_number &&
        this.outputs[slot_number].pos) {
        out[0] = this.pos[0] + this.outputs[slot_number].pos[0];
        out[1] = this.pos[1] + this.outputs[slot_number].pos[1];
        return out;
    }
    //horizontal distributed slots
    if (this.horizontal) {
        out[0] =
            this.pos[0] + (slot_number + 0.5) * (this.size[0] / num_slots);
        if (is_input) {
            out[1] = this.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT;
        }
        else {
            out[1] = this.pos[1] + this.size[1];
        }
        return out;
    }
    //default vertical slots
    if (is_input) {
        out[0] = this.pos[0] + offset;
    }
    else {
        out[0] = this.pos[0] + this.size[0] + 1 - offset;
    }
    out[1] =
        this.pos[1] +
            (slot_number + 0.7) * exports.LiteGraph.NODE_SLOT_HEIGHT +
            (this.constructor.slot_start_y || 0);
    return out;
};
/* Force align to grid */
LGraphNode.prototype.alignToGrid = function () {
    this.pos[0] =
        exports.LiteGraph.CANVAS_GRID_SIZE *
            Math.round(this.pos[0] / exports.LiteGraph.CANVAS_GRID_SIZE);
    this.pos[1] =
        exports.LiteGraph.CANVAS_GRID_SIZE *
            Math.round(this.pos[1] / exports.LiteGraph.CANVAS_GRID_SIZE);
};
/* Console output */
LGraphNode.prototype.trace = function (msg) {
    if (!this.console) {
        this.console = [];
    }
    this.console.push(msg);
    if (this.console.length > LGraphNode.MAX_CONSOLE) {
        this.console.shift();
    }
    if (this.graph.onNodeTrace)
        this.graph.onNodeTrace(this, msg);
};
/* Forces to redraw or the main canvas (LGraphNode) or the bg canvas (links) */
LGraphNode.prototype.setDirtyCanvas = function (dirty_foreground, dirty_background) {
    if (!this.graph) {
        return;
    }
    this.graph.sendActionToCanvas("setDirty", [
        dirty_foreground,
        dirty_background
    ]);
};
LGraphNode.prototype.loadImage = function (url) {
    var img = new Image();
    img.src = exports.LiteGraph.node_images_path + url;
    img.ready = false;
    var that = this;
    img.onload = function () {
        this.ready = true;
        that.setDirtyCanvas(true);
    };
    return img;
};
//safe LGraphNode action execution (not sure if safe)
/*
LGraphNode.prototype.executeAction = function(action)
{
if(action == "") return false;

if( action.indexOf(";") != -1 || action.indexOf("}") != -1)
{
    this.trace("Error: Action contains unsafe characters");
    return false;
}

var tokens = action.split("(");
var func_name = tokens[0];
if( typeof(this[func_name]) != "function")
{
    this.trace("Error: Action not found on node: " + func_name);
    return false;
}

var code = action;

try
{
    var _foo = eval;
    eval = null;
    (new Function("with(this) { " + code + "}")).call(this);
    eval = _foo;
}
catch (err)
{
    this.trace("Error executing action {" + action + "} :" + err);
    return false;
}

return true;
}
*/
/* Allows to get onMouseMove and onMouseUp events even if the mouse is out of focus */
LGraphNode.prototype.captureInput = function (v) {
    if (!this.graph || !this.graph.list_of_graphcanvas) {
        return;
    }
    var list = this.graph.list_of_graphcanvas;
    for (var i = 0; i < list.length; ++i) {
        var c = list[i];
        //releasing somebody elses capture?!
        if (!v && c.node_capturing_input != this) {
            continue;
        }
        //change
        c.node_capturing_input = v ? this : null;
    }
};
/**
 * Collapse the node to make it smaller on the canvas
 * @method collapse
 **/
LGraphNode.prototype.collapse = function (force) {
    this.graph._version++;
    if (this.constructor.collapsable === false && !force) {
        return;
    }
    if (!this.flags.collapsed) {
        this.flags.collapsed = true;
    }
    else {
        this.flags.collapsed = false;
    }
    this.setDirtyCanvas(true, true);
};
/**
 * Forces the node to do not move or realign on Z
 * @method pin
 **/
LGraphNode.prototype.pin = function (v) {
    this.graph._version++;
    if (v === undefined) {
        this.flags.pinned = !this.flags.pinned;
    }
    else {
        this.flags.pinned = v;
    }
};
LGraphNode.prototype.localToScreen = function (x, y, graphcanvas) {
    return [
        (x + this.pos[0]) * graphcanvas.scale + graphcanvas.offset[0],
        (y + this.pos[1]) * graphcanvas.scale + graphcanvas.offset[1]
    ];
};
function LGraphGroup(title) {
    this._ctor(title);
}
// global.LGraphGroup = LiteGraph.LGraphGroup = LGraphGroup;
exports.LiteGraph.LGraphGroup = LGraphGroup;
LGraphGroup.prototype._ctor = function (title) {
    this.title = title || "Group";
    this.font_size = 24;
    this.color = LGraphCanvas.node_colors.pale_blue
        ? LGraphCanvas.node_colors.pale_blue.groupcolor
        : "#AAA";
    this._bounding = new Float32Array([10, 10, 140, 80]);
    this._pos = this._bounding.subarray(0, 2);
    this._size = this._bounding.subarray(2, 4);
    this._nodes = [];
    this.graph = null;
    Object.defineProperty(this, "pos", {
        set: function (v) {
            if (!v || v.length < 2) {
                return;
            }
            this._pos[0] = v[0];
            this._pos[1] = v[1];
        },
        get: function () {
            return this._pos;
        },
        enumerable: true
    });
    Object.defineProperty(this, "size", {
        set: function (v) {
            if (!v || v.length < 2) {
                return;
            }
            this._size[0] = Math.max(140, v[0]);
            this._size[1] = Math.max(80, v[1]);
        },
        get: function () {
            return this._size;
        },
        enumerable: true
    });
};
LGraphGroup.prototype.configure = function (o) {
    this.title = o.title;
    this._bounding.set(o.bounding);
    this.color = o.color;
    this.font_size = o.font_size;
};
LGraphGroup.prototype.serialize = function () {
    var b = this._bounding;
    return {
        title: this.title,
        bounding: [
            Math.round(b[0]),
            Math.round(b[1]),
            Math.round(b[2]),
            Math.round(b[3])
        ],
        color: this.color,
        font_size: this.font_size
    };
};
LGraphGroup.prototype.move = function (deltax, deltay, ignore_nodes) {
    this._pos[0] += deltax;
    this._pos[1] += deltay;
    if (ignore_nodes) {
        return;
    }
    for (var i = 0; i < this._nodes.length; ++i) {
        var node = this._nodes[i];
        node.pos[0] += deltax;
        node.pos[1] += deltay;
    }
};
LGraphGroup.prototype.recomputeInsideNodes = function () {
    this._nodes.length = 0;
    var nodes = this.graph._nodes;
    var node_bounding = new Float32Array(4);
    for (var i = 0; i < nodes.length; ++i) {
        var node = nodes[i];
        node.getBounding(node_bounding);
        if (!overlapBounding(this._bounding, node_bounding)) {
            continue;
        } //out of the visible area
        this._nodes.push(node);
    }
};
LGraphGroup.prototype.isPointInside = LGraphNode.prototype.isPointInside;
LGraphGroup.prototype.setDirtyCanvas = LGraphNode.prototype.setDirtyCanvas;
//****************************************
//Scale and Offset
function DragAndScale(element, skip_events) {
    this.offset = new Float32Array([0, 0]);
    this.scale = 1;
    this.max_scale = 10;
    this.min_scale = 0.1;
    this.onredraw = null;
    this.enabled = true;
    this.last_mouse = [0, 0];
    this.element = null;
    this.visible_area = new Float32Array(4);
    if (element) {
        this.element = element;
        if (!skip_events) {
            this.bindEvents(element);
        }
    }
}
exports.LiteGraph.DragAndScale = DragAndScale;
DragAndScale.prototype.bindEvents = function (element) {
    this.last_mouse = new Float32Array(2);
    this._binded_mouse_callback = this.onMouse.bind(this);
    exports.LiteGraph.pointerListenerAdd(element, "down", this._binded_mouse_callback);
    exports.LiteGraph.pointerListenerAdd(element, "move", this._binded_mouse_callback);
    exports.LiteGraph.pointerListenerAdd(element, "up", this._binded_mouse_callback);
    element.addEventListener("mousewheel", this._binded_mouse_callback, false);
    element.addEventListener("wheel", this._binded_mouse_callback, false);
};
DragAndScale.prototype.computeVisibleArea = function (viewport) {
    if (!this.element) {
        this.visible_area[0] = this.visible_area[1] = this.visible_area[2] = this.visible_area[3] = 0;
        return;
    }
    var width = this.element.width;
    var height = this.element.height;
    var startx = -this.offset[0];
    var starty = -this.offset[1];
    if (viewport) {
        startx += viewport[0] / this.scale;
        starty += viewport[1] / this.scale;
        width = viewport[2];
        height = viewport[3];
    }
    var endx = startx + width / this.scale;
    var endy = starty + height / this.scale;
    this.visible_area[0] = startx;
    this.visible_area[1] = starty;
    this.visible_area[2] = endx - startx;
    this.visible_area[3] = endy - starty;
};
DragAndScale.prototype.onMouse = function (e) {
    if (!this.enabled) {
        return;
    }
    var canvas = this.element;
    var rect = canvas.getBoundingClientRect();
    var x = e.clientX - rect.left;
    var y = e.clientY - rect.top;
    e.canvasx = x;
    e.canvasy = y;
    e.dragging = this.dragging;
    var is_inside = !this.viewport || (this.viewport && x >= this.viewport[0] && x < (this.viewport[0] + this.viewport[2]) && y >= this.viewport[1] && y < (this.viewport[1] + this.viewport[3]));
    //console.log("pointerevents: DragAndScale onMouse "+e.type+" "+is_inside);
    var ignore = false;
    if (this.onmouse) {
        ignore = this.onmouse(e);
    }
    if (e.type == exports.LiteGraph.pointerevents_method + "down" && is_inside) {
        this.dragging = true;
        exports.LiteGraph.pointerListenerRemove(canvas, "move", this._binded_mouse_callback);
        exports.LiteGraph.pointerListenerAdd(document, "move", this._binded_mouse_callback);
        exports.LiteGraph.pointerListenerAdd(document, "up", this._binded_mouse_callback);
    }
    else if (e.type == exports.LiteGraph.pointerevents_method + "move") {
        if (!ignore) {
            var deltax = x - this.last_mouse[0];
            var deltay = y - this.last_mouse[1];
            if (this.dragging) {
                this.mouseDrag(deltax, deltay);
            }
        }
    }
    else if (e.type == exports.LiteGraph.pointerevents_method + "up") {
        this.dragging = false;
        exports.LiteGraph.pointerListenerRemove(document, "move", this._binded_mouse_callback);
        exports.LiteGraph.pointerListenerRemove(document, "up", this._binded_mouse_callback);
        exports.LiteGraph.pointerListenerAdd(canvas, "move", this._binded_mouse_callback);
    }
    else if (is_inside &&
        (e.type == "mousewheel" ||
            e.type == "wheel" ||
            e.type == "DOMMouseScroll")) {
        e.eventType = "mousewheel";
        if (e.type == "wheel") {
            e.wheel = -e.deltaY;
        }
        else {
            e.wheel =
                e.wheelDeltaY != null ? e.wheelDeltaY : e.detail * -60;
        }
        //from stack overflow
        e.delta = e.wheelDelta
            ? e.wheelDelta / 40
            : e.deltaY
                ? -e.deltaY / 3
                : 0;
        this.changeDeltaScale(1.0 + e.delta * 0.05);
    }
    this.last_mouse[0] = x;
    this.last_mouse[1] = y;
    if (is_inside) {
        e.preventDefault();
        e.stopPropagation();
        return false;
    }
};
DragAndScale.prototype.toCanvasContext = function (ctx) {
    ctx.scale(this.scale, this.scale);
    ctx.translate(this.offset[0], this.offset[1]);
};
DragAndScale.prototype.convertOffsetToCanvas = function (pos) {
    //return [pos[0] / this.scale - this.offset[0], pos[1] / this.scale - this.offset[1]];
    return [
        (pos[0] + this.offset[0]) * this.scale,
        (pos[1] + this.offset[1]) * this.scale
    ];
};
DragAndScale.prototype.convertCanvasToOffset = function (pos, out) {
    out = out || [0, 0];
    out[0] = pos[0] / this.scale - this.offset[0];
    out[1] = pos[1] / this.scale - this.offset[1];
    return out;
};
DragAndScale.prototype.mouseDrag = function (x, y) {
    this.offset[0] += x / this.scale;
    this.offset[1] += y / this.scale;
    if (this.onredraw) {
        this.onredraw(this);
    }
};
DragAndScale.prototype.changeScale = function (value, zooming_center) {
    if (value < this.min_scale) {
        value = this.min_scale;
    }
    else if (value > this.max_scale) {
        value = this.max_scale;
    }
    if (value == this.scale) {
        return;
    }
    if (!this.element) {
        return;
    }
    var rect = this.element.getBoundingClientRect();
    if (!rect) {
        return;
    }
    zooming_center = zooming_center || [
        rect.width * 0.5,
        rect.height * 0.5
    ];
    var center = this.convertCanvasToOffset(zooming_center);
    this.scale = value;
    if (Math.abs(this.scale - 1) < 0.01) {
        this.scale = 1;
    }
    var new_center = this.convertCanvasToOffset(zooming_center);
    var delta_offset = [
        new_center[0] - center[0],
        new_center[1] - center[1]
    ];
    this.offset[0] += delta_offset[0];
    this.offset[1] += delta_offset[1];
    if (this.onredraw) {
        this.onredraw(this);
    }
};
DragAndScale.prototype.changeDeltaScale = function (value, zooming_center) {
    this.changeScale(this.scale * value, zooming_center);
};
DragAndScale.prototype.reset = function () {
    this.scale = 1;
    this.offset[0] = 0;
    this.offset[1] = 0;
};
//*********************************************************************************
// LGraphCanvas: LGraph renderer CLASS
//*********************************************************************************
/**
 * This class is in charge of rendering one graph inside a canvas. And provides all the interaction required.
 * Valid callbacks are: onNodeSelected, onNodeDeselected, onShowNodePanel, onNodeDblClicked
 *
 * @class LGraphCanvas
 * @constructor
 * @param {HTMLCanvas} canvas the canvas where you want to render (it accepts a selector in string format or the canvas element itself)
 * @param {LGraph} graph [optional]
 * @param {Object} options [optional] { skip_rendering, autoresize, viewport }
 */
function LGraphCanvas(canvas, graph, options) {
    this.options = options = options || {};
    //if(graph === undefined)
    //	throw ("No graph assigned");
    this.background_image = LGraphCanvas.DEFAULT_BACKGROUND_IMAGE;
    if (canvas && canvas.constructor === String) {
        canvas = document.querySelector(canvas);
    }
    this.ds = new DragAndScale();
    this.zoom_modify_alpha = true; //otherwise it generates ugly patterns when scaling down too much
    this.title_text_font = "" + exports.LiteGraph.NODE_TEXT_SIZE + "px Arial";
    this.inner_text_font =
        "normal " + exports.LiteGraph.NODE_SUBTEXT_SIZE + "px Arial";
    this.node_title_color = exports.LiteGraph.NODE_TITLE_COLOR;
    this.default_link_color = exports.LiteGraph.LINK_COLOR;
    this.default_connection_color = {
        input_off: "#778",
        input_on: "#7F7",
        output_off: "#778",
        output_on: "#7F7" //"#BBD"
    };
    this.default_connection_color_byType = {
    /*number: "#7F7",
    string: "#77F",
    boolean: "#F77",*/
    };
    this.default_connection_color_byTypeOff = {
    /*number: "#474",
    string: "#447",
    boolean: "#744",*/
    };
    this.highquality_render = true;
    this.use_gradients = false; //set to true to render titlebar with gradients
    this.editor_alpha = 1; //used for transition
    this.pause_rendering = false;
    this.clear_background = true;
    this.clear_background_color = "#222";
    this.read_only = false; //if set to true users cannot modify the graph
    this.render_only_selected = true;
    this.live_mode = false;
    this.show_info = true;
    this.allow_dragcanvas = true;
    this.allow_dragnodes = true;
    this.allow_interaction = true; //allow to control widgets, buttons, collapse, etc
    this.multi_select = false; //allow selecting multi nodes without pressing extra keys
    this.allow_searchbox = true;
    this.allow_reconnect_links = true; //allows to change a connection with having to redo it again
    this.align_to_grid = false; //snap to grid
    this.drag_mode = false;
    this.dragging_rectangle = null;
    this.filter = null; //allows to filter to only accept some type of nodes in a graph
    this.set_canvas_dirty_on_mouse_event = true; //forces to redraw the canvas if the mouse does anything
    this.always_render_background = false;
    this.render_shadows = true;
    this.render_canvas_border = true;
    this.render_connections_shadows = false; //too much cpu
    this.render_connections_border = true;
    this.render_curved_connections = false;
    this.render_connection_arrows = false;
    this.render_collapsed_slots = true;
    this.render_execution_order = false;
    this.render_title_colored = true;
    this.render_link_tooltip = true;
    this.links_render_mode = exports.LiteGraph.SPLINE_LINK;
    this.mouse = [0, 0]; //mouse in canvas coordinates, where 0,0 is the top-left corner of the blue rectangle
    this.graph_mouse = [0, 0]; //mouse in graph coordinates, where 0,0 is the top-left corner of the blue rectangle
    this.canvas_mouse = this.graph_mouse; //LEGACY: REMOVE THIS, USE GRAPH_MOUSE INSTEAD
    //to personalize the search box
    this.onSearchBox = null;
    this.onSearchBoxSelection = null;
    //callbacks
    this.onMouse = null;
    this.onDrawBackground = null; //to render background objects (behind nodes and connections) in the canvas affected by transform
    this.onDrawForeground = null; //to render foreground objects (above nodes and connections) in the canvas affected by transform
    this.onDrawOverlay = null; //to render foreground objects not affected by transform (for GUIs)
    this.onDrawLinkTooltip = null; //called when rendering a tooltip
    this.onNodeMoved = null; //called after moving a node
    this.onSelectionChange = null; //called if the selection changes
    this.onConnectingChange = null; //called before any link changes
    this.onBeforeChange = null; //called before modifying the graph
    this.onAfterChange = null; //called after modifying the graph
    this.connections_width = 3;
    this.round_radius = 8;
    this.current_node = null;
    this.node_widget = null; //used for widgets
    this.over_link_center = null;
    this.last_mouse_position = [0, 0];
    this.visible_area = this.ds.visible_area;
    this.visible_links = [];
    this.viewport = options.viewport || null; //to constraint render area to a portion of the canvas
    //link canvas and graph
    if (graph) {
        graph.attachCanvas(this);
    }
    this.setCanvas(canvas, options.skip_events);
    this.clear();
    if (!options.skip_render) {
        this.startRendering();
    }
    this.autoresize = options.autoresize;
}
// global.LGraphCanvas = LiteGraph.LGraphCanvas = LGraphCanvas;
LGraphCanvas.DEFAULT_BACKGROUND_IMAGE = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAIAAAD/gAIDAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAQBJREFUeNrs1rEKwjAUhlETUkj3vP9rdmr1Ysammk2w5wdxuLgcMHyptfawuZX4pJSWZTnfnu/lnIe/jNNxHHGNn//HNbbv+4dr6V+11uF527arU7+u63qfa/bnmh8sWLBgwYJlqRf8MEptXPBXJXa37BSl3ixYsGDBMliwFLyCV/DeLIMFCxYsWLBMwSt4Be/NggXLYMGCBUvBK3iNruC9WbBgwYJlsGApeAWv4L1ZBgsWLFiwYJmCV/AK3psFC5bBggULloJX8BpdwXuzYMGCBctgwVLwCl7Be7MMFixYsGDBsu8FH1FaSmExVfAxBa/gvVmwYMGCZbBg/W4vAQYA5tRF9QYlv/QAAAAASUVORK5CYII=";
LGraphCanvas.link_type_colors = {
    "-1": exports.LiteGraph.EVENT_LINK_COLOR,
    number: "#AAA",
    node: "#DCA"
};
LGraphCanvas.gradients = {}; //cache of gradients
/**
 * clears all the data inside
 *
 * @method clear
 */
LGraphCanvas.prototype.clear = function () {
    this.frame = 0;
    this.last_draw_time = 0;
    this.render_time = 0;
    this.fps = 0;
    //this.scale = 1;
    //this.offset = [0,0];
    this.dragging_rectangle = null;
    this.selected_nodes = {};
    this.selected_group = null;
    this.visible_nodes = [];
    this.node_dragged = null;
    this.node_over = null;
    this.node_capturing_input = null;
    this.connecting_node = null;
    this.highlighted_links = {};
    this.dragging_canvas = false;
    this.dirty_canvas = true;
    this.dirty_bgcanvas = true;
    this.dirty_area = null;
    this.node_in_panel = null;
    this.node_widget = null;
    this.last_mouse = [0, 0];
    this.last_mouseclick = 0;
    this.pointer_is_down = false;
    this.pointer_is_double = false;
    this.visible_area.set([0, 0, 0, 0]);
    if (this.onClear) {
        this.onClear();
    }
};
/**
 * assigns a graph, you can reassign graphs to the same canvas
 *
 * @method setGraph
 * @param {LGraph} graph
 */
LGraphCanvas.prototype.setGraph = function (graph, skip_clear) {
    if (this.graph == graph) {
        return;
    }
    if (!skip_clear) {
        this.clear();
    }
    if (!graph && this.graph) {
        this.graph.detachCanvas(this);
        return;
    }
    graph.attachCanvas(this);
    //remove the graph stack in case a subgraph was open
    if (this._graph_stack)
        this._graph_stack = null;
    this.setDirty(true, true);
};
/**
 * returns the top level graph (in case there are subgraphs open on the canvas)
 *
 * @method getTopGraph
 * @return {LGraph} graph
 */
LGraphCanvas.prototype.getTopGraph = function () {
    if (this._graph_stack.length)
        return this._graph_stack[0];
    return this.graph;
};
/**
 * opens a graph contained inside a node in the current graph
 *
 * @method openSubgraph
 * @param {LGraph} graph
 */
LGraphCanvas.prototype.openSubgraph = function (graph) {
    if (!graph) {
        throw "graph cannot be null";
    }
    if (this.graph == graph) {
        throw "graph cannot be the same";
    }
    this.clear();
    if (this.graph) {
        if (!this._graph_stack) {
            this._graph_stack = [];
        }
        this._graph_stack.push(this.graph);
    }
    graph.attachCanvas(this);
    this.checkPanels();
    this.setDirty(true, true);
};
/**
 * closes a subgraph contained inside a node
 *
 * @method closeSubgraph
 * @param {LGraph} assigns a graph
 */
LGraphCanvas.prototype.closeSubgraph = function () {
    if (!this._graph_stack || this._graph_stack.length == 0) {
        return;
    }
    var subgraph_node = this.graph._subgraph_node;
    var graph = this._graph_stack.pop();
    this.selected_nodes = {};
    this.highlighted_links = {};
    graph.attachCanvas(this);
    this.setDirty(true, true);
    if (subgraph_node) {
        this.centerOnNode(subgraph_node);
        this.selectNodes([subgraph_node]);
    }
    // when close sub graph back to offset [0, 0] scale 1
    this.ds.offset = [0, 0];
    this.ds.scale = 1;
};
/**
 * returns the visually active graph (in case there are more in the stack)
 * @method getCurrentGraph
 * @return {LGraph} the active graph
 */
LGraphCanvas.prototype.getCurrentGraph = function () {
    return this.graph;
};
/**
 * assigns a canvas
 *
 * @method setCanvas
 * @param {Canvas} assigns a canvas (also accepts the ID of the element (not a selector)
 */
LGraphCanvas.prototype.setCanvas = function (canvas, skip_events) {
    var that = this;
    if (canvas) {
        if (canvas.constructor === String) {
            canvas = document.getElementById(canvas);
            if (!canvas) {
                throw "Error creating LiteGraph canvas: Canvas not found";
            }
        }
    }
    if (canvas === this.canvas) {
        return;
    }
    if (!canvas && this.canvas) {
        //maybe detach events from old_canvas
        if (!skip_events) {
            this.unbindEvents();
        }
    }
    this.canvas = canvas;
    this.ds.element = canvas;
    if (!canvas) {
        return;
    }
    //this.canvas.tabindex = "1000";
    canvas.className += " lgraphcanvas";
    canvas.data = this;
    canvas.tabindex = "1"; //to allow key events
    //bg canvas: used for non changing stuff
    this.bgcanvas = null;
    if (!this.bgcanvas) {
        this.bgcanvas = document.createElement("canvas");
        this.bgcanvas.width = this.canvas.width;
        this.bgcanvas.height = this.canvas.height;
    }
    if (canvas.getContext == null) {
        if (canvas.localName != "canvas") {
            throw "Element supplied for LGraphCanvas must be a <canvas> element, you passed a " +
                canvas.localName;
        }
        throw "This browser doesn't support Canvas";
    }
    var ctx = (this.ctx = canvas.getContext("2d"));
    if (ctx == null) {
        if (!canvas.webgl_enabled) {
            console.warn("This canvas seems to be WebGL, enabling WebGL renderer");
        }
        this.enableWebGL();
    }
    //input:  (move and up could be unbinded)
    // why here? this._mousemove_callback = this.processMouseMove.bind(this);
    // why here? this._mouseup_callback = this.processMouseUp.bind(this);
    if (!skip_events) {
        this.bindEvents();
    }
};
//used in some events to capture them
LGraphCanvas.prototype._doNothing = function doNothing(e) {
    //console.log("pointerevents: _doNothing "+e.type);
    e.preventDefault();
    return false;
};
LGraphCanvas.prototype._doReturnTrue = function doNothing(e) {
    e.preventDefault();
    return true;
};
/**
 * binds mouse, keyboard, touch and drag events to the canvas
 * @method bindEvents
 **/
LGraphCanvas.prototype.bindEvents = function () {
    if (this._events_binded) {
        console.warn("LGraphCanvas: events already binded");
        return;
    }
    //console.log("pointerevents: bindEvents");
    var canvas = this.canvas;
    var ref_window = this.getCanvasWindow();
    var document = ref_window.document; //hack used when moving canvas between windows
    this._mousedown_callback = this.processMouseDown.bind(this);
    this._mousewheel_callback = this.processMouseWheel.bind(this);
    // why mousemove and mouseup were not binded here?
    this._mousemove_callback = this.processMouseMove.bind(this);
    this._mouseup_callback = this.processMouseUp.bind(this);
    //touch events -- TODO IMPLEMENT
    //this._touch_callback = this.touchHandler.bind(this);
    exports.LiteGraph.pointerListenerAdd(canvas, "down", this._mousedown_callback, true); //down do not need to store the binded
    canvas.addEventListener("mousewheel", this._mousewheel_callback, false);
    exports.LiteGraph.pointerListenerAdd(canvas, "up", this._mouseup_callback, true); // CHECK: ??? binded or not
    exports.LiteGraph.pointerListenerAdd(canvas, "move", this._mousemove_callback);
    canvas.addEventListener("contextmenu", this._doNothing);
    canvas.addEventListener("DOMMouseScroll", this._mousewheel_callback, false);
    //touch events -- THIS WAY DOES NOT WORK, finish implementing pointerevents, than clean the touchevents
    /*if( 'touchstart' in document.documentElement )
    {
        canvas.addEventListener("touchstart", this._touch_callback, true);
        canvas.addEventListener("touchmove", this._touch_callback, true);
        canvas.addEventListener("touchend", this._touch_callback, true);
        canvas.addEventListener("touchcancel", this._touch_callback, true);
    }*/
    //Keyboard ******************
    this._key_callback = this.processKey.bind(this);
    canvas.setAttribute("tabindex", 1); //otherwise key events are ignored
    canvas.addEventListener("keydown", this._key_callback, true);
    document.addEventListener("keyup", this._key_callback, true); //in document, otherwise it doesn't fire keyup
    //Dropping Stuff over nodes ************************************
    this._ondrop_callback = this.processDrop.bind(this);
    canvas.addEventListener("dragover", this._doNothing, false);
    canvas.addEventListener("dragend", this._doNothing, false);
    canvas.addEventListener("drop", this._ondrop_callback, false);
    canvas.addEventListener("dragenter", this._doReturnTrue, false);
    this._events_binded = true;
};
/**
 * unbinds mouse events from the canvas
 * @method unbindEvents
 **/
LGraphCanvas.prototype.unbindEvents = function () {
    if (!this._events_binded) {
        console.warn("LGraphCanvas: no events binded");
        return;
    }
    //console.log("pointerevents: unbindEvents");
    var ref_window = this.getCanvasWindow();
    var document = ref_window.document;
    exports.LiteGraph.pointerListenerRemove(this.canvas, "move", this._mousedown_callback);
    exports.LiteGraph.pointerListenerRemove(this.canvas, "up", this._mousedown_callback);
    exports.LiteGraph.pointerListenerRemove(this.canvas, "down", this._mousedown_callback);
    this.canvas.removeEventListener("mousewheel", this._mousewheel_callback);
    this.canvas.removeEventListener("DOMMouseScroll", this._mousewheel_callback);
    this.canvas.removeEventListener("keydown", this._key_callback);
    document.removeEventListener("keyup", this._key_callback);
    this.canvas.removeEventListener("contextmenu", this._doNothing);
    this.canvas.removeEventListener("drop", this._ondrop_callback);
    this.canvas.removeEventListener("dragenter", this._doReturnTrue);
    //touch events -- THIS WAY DOES NOT WORK, finish implementing pointerevents, than clean the touchevents
    /*this.canvas.removeEventListener("touchstart", this._touch_callback );
    this.canvas.removeEventListener("touchmove", this._touch_callback );
    this.canvas.removeEventListener("touchend", this._touch_callback );
    this.canvas.removeEventListener("touchcancel", this._touch_callback );*/
    this._mousedown_callback = null;
    this._mousewheel_callback = null;
    this._key_callback = null;
    this._ondrop_callback = null;
    this._events_binded = false;
};
LGraphCanvas.getFileExtension = function (url) {
    var question = url.indexOf("?");
    if (question != -1) {
        url = url.substr(0, question);
    }
    var point = url.lastIndexOf(".");
    if (point == -1) {
        return "";
    }
    return url.substr(point + 1).toLowerCase();
};
/**
 * this function allows to render the canvas using WebGL instead of Canvas2D
 * this is useful if you plant to render 3D objects inside your nodes, it uses litegl.js for webgl and canvas2DtoWebGL to emulate the Canvas2D calls in webGL
 * @method enableWebGL
 **/
LGraphCanvas.prototype.enableWebGL = function () {
    if (typeof GL === "undefined") {
        throw "litegl.js must be included to use a WebGL canvas";
    }
    if (typeof enableWebGLCanvas === "undefined") {
        throw "webglCanvas.js must be included to use this feature";
    }
    this.gl = this.ctx = enableWebGLCanvas(this.canvas);
    this.ctx.webgl = true;
    this.bgcanvas = this.canvas;
    this.bgctx = this.gl;
    this.canvas.webgl_enabled = true;
    /*
GL.create({ canvas: this.bgcanvas });
this.bgctx = enableWebGLCanvas( this.bgcanvas );
window.gl = this.gl;
*/
};
/**
 * marks as dirty the canvas, this way it will be rendered again
 *
 * @class LGraphCanvas
 * @method setDirty
 * @param {bool} fgcanvas if the foreground canvas is dirty (the one containing the nodes)
 * @param {bool} bgcanvas if the background canvas is dirty (the one containing the wires)
 */
LGraphCanvas.prototype.setDirty = function (fgcanvas, bgcanvas) {
    if (fgcanvas) {
        this.dirty_canvas = true;
    }
    if (bgcanvas) {
        this.dirty_bgcanvas = true;
    }
};
/**
 * Used to attach the canvas in a popup
 *
 * @method getCanvasWindow
 * @return {window} returns the window where the canvas is attached (the DOM root node)
 */
LGraphCanvas.prototype.getCanvasWindow = function () {
    if (!this.canvas) {
        return window;
    }
    var doc = this.canvas.ownerDocument;
    return doc.defaultView || doc.parentWindow;
};
/**
 * starts rendering the content of the canvas when needed
 *
 * @method startRendering
 */
LGraphCanvas.prototype.startRendering = function () {
    if (this.is_rendering) {
        return;
    } //already rendering
    this.is_rendering = true;
    renderFrame.call(this);
    function renderFrame() {
        if (!this.pause_rendering) {
            this.draw();
        }
        var window = this.getCanvasWindow();
        if (this.is_rendering) {
            window.requestAnimationFrame(renderFrame.bind(this));
        }
    }
};
/**
 * stops rendering the content of the canvas (to save resources)
 *
 * @method stopRendering
 */
LGraphCanvas.prototype.stopRendering = function () {
    this.is_rendering = false;
    /*
if(this.rendering_timer_id)
{
    clearInterval(this.rendering_timer_id);
    this.rendering_timer_id = null;
}
*/
};
/* LiteGraphCanvas input */
//used to block future mouse events (because of im gui)
LGraphCanvas.prototype.blockClick = function () {
    this.block_click = true;
    this.last_mouseclick = 0;
};
LGraphCanvas.prototype.processMouseDown = function (e) {
    if (this.set_canvas_dirty_on_mouse_event)
        this.dirty_canvas = true;
    if (!this.graph) {
        return;
    }
    this.adjustMouseEvent(e);
    var ref_window = this.getCanvasWindow();
    var document = ref_window.document;
    LGraphCanvas.active_canvas = this;
    var that = this;
    var x = e.clientX;
    var y = e.clientY;
    //console.log(y,this.viewport);
    //console.log("pointerevents: processMouseDown pointerId:"+e.pointerId+" which:"+e.which+" isPrimary:"+e.isPrimary+" :: x y "+x+" "+y);
    this.ds.viewport = this.viewport;
    var is_inside = !this.viewport || (this.viewport && x >= this.viewport[0] && x < (this.viewport[0] + this.viewport[2]) && y >= this.viewport[1] && y < (this.viewport[1] + this.viewport[3]));
    //move mouse move event to the window in case it drags outside of the canvas
    if (!this.options.skip_events) {
        exports.LiteGraph.pointerListenerRemove(this.canvas, "move", this._mousemove_callback);
        exports.LiteGraph.pointerListenerAdd(ref_window.document, "move", this._mousemove_callback, true); //catch for the entire window
        exports.LiteGraph.pointerListenerAdd(ref_window.document, "up", this._mouseup_callback, true);
    }
    if (!is_inside) {
        return;
    }
    var node = this.graph.getNodeOnPos(e.canvasX, e.canvasY, this.visible_nodes, 5);
    var skip_dragging = false;
    var skip_action = false;
    var now = exports.LiteGraph.getTime();
    var is_primary = (e.isPrimary === undefined || !e.isPrimary);
    var is_double_click = (now - this.last_mouseclick < 300) && is_primary;
    this.mouse[0] = e.clientX;
    this.mouse[1] = e.clientY;
    this.graph_mouse[0] = e.canvasX;
    this.graph_mouse[1] = e.canvasY;
    this.last_click_position = [this.mouse[0], this.mouse[1]];
    if (this.pointer_is_down && is_primary) {
        this.pointer_is_double = true;
        //console.log("pointerevents: pointer_is_double start");
    }
    else {
        this.pointer_is_double = false;
    }
    this.pointer_is_down = true;
    this.canvas.focus();
    exports.LiteGraph.closeAllContextMenus(ref_window);
    if (this.onMouse) {
        if (this.onMouse(e) == true)
            return;
    }
    //left button mouse / single finger
    if (e.which == 1 && !this.pointer_is_double) {
        if (e.ctrlKey) {
            this.dragging_rectangle = new Float32Array(4);
            this.dragging_rectangle[0] = e.canvasX;
            this.dragging_rectangle[1] = e.canvasY;
            this.dragging_rectangle[2] = 1;
            this.dragging_rectangle[3] = 1;
            skip_action = true;
        }
        // clone node ALT dragging
        if (exports.LiteGraph.alt_drag_do_clone_nodes && e.altKey && node && this.allow_interaction && !skip_action && !this.read_only) {
            if (cloned = node.clone()) {
                cloned.pos[0] += 5;
                cloned.pos[1] += 5;
                this.graph.add(cloned, false, { doCalcSize: false });
                node = cloned;
                skip_action = true;
                if (!block_drag_node) {
                    if (this.allow_dragnodes) {
                        this.graph.beforeChange();
                        this.node_dragged = node;
                    }
                    if (!this.selected_nodes[node.id]) {
                        this.processNodeSelected(node, e);
                    }
                }
            }
        }
        var clicking_canvas_bg = false;
        //when clicked on top of a node
        //and it is not interactive
        if (node && (this.allow_interaction || node.flags.allow_interaction) && !skip_action && !this.read_only) {
            if (!this.live_mode && !node.flags.pinned) {
                this.bringToFront(node);
            } //if it wasn't selected?
            //not dragging mouse to connect two slots
            if (this.allow_interaction && !this.connecting_node && !node.flags.collapsed && !this.live_mode) {
                //Search for corner for resize
                if (!skip_action &&
                    node.resizable !== false &&
                    isInsideRectangle(e.canvasX, e.canvasY, node.pos[0] + node.size[0] - 5, node.pos[1] + node.size[1] - 5, 10, 10)) {
                    this.graph.beforeChange();
                    this.resizing_node = node;
                    this.canvas.style.cursor = "se-resize";
                    skip_action = true;
                }
                else {
                    //search for outputs
                    if (node.outputs) {
                        for (var i = 0, l = node.outputs.length; i < l; ++i) {
                            var output = node.outputs[i];
                            var link_pos = node.getConnectionPos(false, i);
                            if (isInsideRectangle(e.canvasX, e.canvasY, link_pos[0] - 15, link_pos[1] - 10, 30, 20)) {
                                this.connecting_node = node;
                                this.connecting_output = output;
                                this.connecting_output.slot_index = i;
                                this.connecting_pos = node.getConnectionPos(false, i);
                                this.connecting_slot = i;
                                if (exports.LiteGraph.shift_click_do_break_link_from) {
                                    if (e.shiftKey) {
                                        node.disconnectOutput(i);
                                    }
                                }
                                if (is_double_click) {
                                    if (node.onOutputDblClick) {
                                        node.onOutputDblClick(i, e);
                                    }
                                }
                                else {
                                    if (node.onOutputClick) {
                                        node.onOutputClick(i, e);
                                    }
                                }
                                skip_action = true;
                                break;
                            }
                        }
                    }
                    //search for inputs
                    if (node.inputs) {
                        for (var i = 0, l = node.inputs.length; i < l; ++i) {
                            var input = node.inputs[i];
                            var link_pos = node.getConnectionPos(true, i);
                            if (isInsideRectangle(e.canvasX, e.canvasY, link_pos[0] - 15, link_pos[1] - 10, 30, 20)) {
                                if (is_double_click) {
                                    if (node.onInputDblClick) {
                                        node.onInputDblClick(i, e);
                                    }
                                }
                                else {
                                    if (node.onInputClick) {
                                        node.onInputClick(i, e);
                                    }
                                }
                                if (input.link !== null) {
                                    var link_info = this.graph.links[input.link]; //before disconnecting
                                    if (exports.LiteGraph.click_do_break_link_to) {
                                        node.disconnectInput(i);
                                        this.dirty_bgcanvas = true;
                                        skip_action = true;
                                    }
                                    else {
                                        // do same action as has not node ?
                                    }
                                    if (this.allow_reconnect_links ||
                                        //this.move_destination_link_without_shift ||
                                        e.shiftKey) {
                                        if (!exports.LiteGraph.click_do_break_link_to) {
                                            node.disconnectInput(i);
                                        }
                                        this.connecting_node = this.graph._nodes_by_id[link_info.origin_id];
                                        this.connecting_slot =
                                            link_info.origin_slot;
                                        this.connecting_output = this.connecting_node.outputs[this.connecting_slot];
                                        this.connecting_pos = this.connecting_node.getConnectionPos(false, this.connecting_slot);
                                        this.dirty_bgcanvas = true;
                                        skip_action = true;
                                    }
                                }
                                else {
                                    // has not node
                                }
                                if (!skip_action) {
                                    // connect from in to out, from to to from
                                    this.connecting_node = node;
                                    this.connecting_input = input;
                                    this.connecting_input.slot_index = i;
                                    this.connecting_pos = node.getConnectionPos(true, i);
                                    this.connecting_slot = i;
                                    this.dirty_bgcanvas = true;
                                    skip_action = true;
                                }
                            }
                        }
                    }
                } //not resizing
            }
            //it wasn't clicked on the links boxes
            if (!skip_action) {
                var block_drag_node = false;
                var pos = [e.canvasX - node.pos[0], e.canvasY - node.pos[1]];
                //widgets
                var widget = this.processNodeWidgets(node, this.graph_mouse, e);
                if (widget) {
                    block_drag_node = true;
                    this.node_widget = [node, widget];
                }
                //double clicking
                if (this.allow_interaction && is_double_click && this.selected_nodes[node.id]) {
                    //double click node
                    if (node.onDblClick) {
                        node.onDblClick(e, pos, this);
                    }
                    this.processNodeDblClicked(node);
                    block_drag_node = true;
                }
                //if do not capture mouse
                if (node.onMouseDown && node.onMouseDown(e, pos, this)) {
                    block_drag_node = true;
                }
                else {
                    //open subgraph button
                    if (node.subgraph && !node.skip_subgraph_button) {
                        if (!node.flags.collapsed && pos[0] > node.size[0] - exports.LiteGraph.NODE_TITLE_HEIGHT && pos[1] < 0) {
                            var that = this;
                            setTimeout(function () {
                                that.openSubgraph(node.subgraph);
                            }, 10);
                        }
                    }
                    if (this.live_mode) {
                        clicking_canvas_bg = true;
                        block_drag_node = true;
                    }
                }
                if (!block_drag_node) {
                    if (this.allow_dragnodes) {
                        this.graph.beforeChange();
                        this.node_dragged = node;
                    }
                    this.processNodeSelected(node, e);
                }
                else { // double-click
                    /**
                     * Don't call the function if the block is already selected.
                     * Otherwise, it could cause the block to be unselected while its panel is open.
                     */
                    if (!node.is_selected)
                        this.processNodeSelected(node, e);
                }
                this.dirty_canvas = true;
            }
        } //clicked outside of nodes
        else {
            if (!skip_action) {
                //search for link connector
                if (!this.read_only) {
                    for (var i = 0; i < this.visible_links.length; ++i) {
                        var link = this.visible_links[i];
                        var center = link._pos;
                        if (!center ||
                            e.canvasX < center[0] - 4 ||
                            e.canvasX > center[0] + 4 ||
                            e.canvasY < center[1] - 4 ||
                            e.canvasY > center[1] + 4) {
                            continue;
                        }
                        //link clicked
                        this.showLinkMenu(link, e);
                        this.over_link_center = null; //clear tooltip
                        break;
                    }
                }
                this.selected_group = this.graph.getGroupOnPos(e.canvasX, e.canvasY);
                this.selected_group_resizing = false;
                if (this.selected_group && !this.read_only) {
                    if (e.ctrlKey) {
                        this.dragging_rectangle = null;
                    }
                    var dist = distance([e.canvasX, e.canvasY], [this.selected_group.pos[0] + this.selected_group.size[0], this.selected_group.pos[1] + this.selected_group.size[1]]);
                    if (dist * this.ds.scale < 10) {
                        this.selected_group_resizing = true;
                    }
                    else {
                        this.selected_group.recomputeInsideNodes();
                    }
                }
                if (is_double_click && !this.read_only && this.allow_searchbox) {
                    this.showSearchBox(e);
                    e.preventDefault();
                    e.stopPropagation();
                }
                clicking_canvas_bg = true;
            }
        }
        if (!skip_action && clicking_canvas_bg && this.allow_dragcanvas) {
            //console.log("pointerevents: dragging_canvas start");
            this.dragging_canvas = true;
        }
    }
    else if (e.which == 2) {
        //middle button
        if (exports.LiteGraph.middle_click_slot_add_default_node) {
            if (node && this.allow_interaction && !skip_action && !this.read_only) {
                //not dragging mouse to connect two slots
                if (!this.connecting_node &&
                    !node.flags.collapsed &&
                    !this.live_mode) {
                    var mClikSlot = false;
                    var mClikSlot_index = false;
                    var mClikSlot_isOut = false;
                    //search for outputs
                    if (node.outputs) {
                        for (var i = 0, l = node.outputs.length; i < l; ++i) {
                            var output = node.outputs[i];
                            var link_pos = node.getConnectionPos(false, i);
                            if (isInsideRectangle(e.canvasX, e.canvasY, link_pos[0] - 15, link_pos[1] - 10, 30, 20)) {
                                mClikSlot = output;
                                mClikSlot_index = i;
                                mClikSlot_isOut = true;
                                break;
                            }
                        }
                    }
                    //search for inputs
                    if (node.inputs) {
                        for (var i = 0, l = node.inputs.length; i < l; ++i) {
                            var input = node.inputs[i];
                            var link_pos = node.getConnectionPos(true, i);
                            if (isInsideRectangle(e.canvasX, e.canvasY, link_pos[0] - 15, link_pos[1] - 10, 30, 20)) {
                                mClikSlot = input;
                                mClikSlot_index = i;
                                mClikSlot_isOut = false;
                                break;
                            }
                        }
                    }
                    //console.log("middleClickSlots? "+mClikSlot+" & "+(mClikSlot_index!==false));
                    if (mClikSlot && mClikSlot_index !== false) {
                        var alphaPosY = 0.5 - ((mClikSlot_index + 1) / ((mClikSlot_isOut ? node.outputs.length : node.inputs.length)));
                        var node_bounding = node.getBounding();
                        // estimate a position: this is a bad semi-bad-working mess .. REFACTOR with a correct autoplacement that knows about the others slots and nodes
                        var posRef = [(!mClikSlot_isOut ? node_bounding[0] : node_bounding[0] + node_bounding[2]) // + node_bounding[0]/this.canvas.width*150
                            ,
                            e.canvasY - 80 // + node_bounding[0]/this.canvas.width*66 // vertical "derive"
                        ];
                        var nodeCreated = this.createDefaultNodeForSlot({ nodeFrom: !mClikSlot_isOut ? null : node,
                            slotFrom: !mClikSlot_isOut ? null : mClikSlot_index,
                            nodeTo: !mClikSlot_isOut ? node : null,
                            slotTo: !mClikSlot_isOut ? mClikSlot_index : null,
                            position: posRef //,e: e
                            ,
                            nodeType: "AUTO" //nodeNewType
                            ,
                            posAdd: [!mClikSlot_isOut ? -30 : 30, -alphaPosY * 130] //-alphaPosY*30]
                            ,
                            posSizeFix: [!mClikSlot_isOut ? -1 : 0, 0] //-alphaPosY*2*/
                        });
                    }
                }
            }
        }
        else if (!skip_action && this.allow_dragcanvas) {
            //console.log("pointerevents: dragging_canvas start from middle button");
            this.dragging_canvas = true;
        }
    }
    else if (e.which == 3 || this.pointer_is_double) {
        //right button
        if (this.allow_interaction && !skip_action && !this.read_only) {
            // is it hover a node ?
            if (node) {
                if (Object.keys(this.selected_nodes).length
                    && (this.selected_nodes[node.id] || e.shiftKey || e.ctrlKey || e.metaKey)) {
                    // is multiselected or using shift to include the now node
                    if (!this.selected_nodes[node.id])
                        this.selectNodes([node], true); // add this if not present
                }
                else {
                    // update selection
                    this.selectNodes([node]);
                }
            }
            // show menu on this node
            this.processContextMenu(node, e);
        }
    }
    //TODO
    //if(this.node_selected != prev_selected)
    //	this.onNodeSelectionChange(this.node_selected);
    this.last_mouse[0] = e.clientX;
    this.last_mouse[1] = e.clientY;
    this.last_mouseclick = exports.LiteGraph.getTime();
    this.last_mouse_dragging = true;
    /*
if( (this.dirty_canvas || this.dirty_bgcanvas) && this.rendering_timer_id == null)
    this.draw();
*/
    this.graph.change();
    //this is to ensure to defocus(blur) if a text input element is on focus
    if (!ref_window.document.activeElement ||
        (ref_window.document.activeElement.nodeName.toLowerCase() !=
            "input" &&
            ref_window.document.activeElement.nodeName.toLowerCase() !=
                "textarea")) {
        e.preventDefault();
    }
    e.stopPropagation();
    if (this.onMouseDown) {
        this.onMouseDown(e);
    }
    return false;
};
/**
 * Called when a mouse move event has to be processed
 * @method processMouseMove
 **/
LGraphCanvas.prototype.processMouseMove = function (e) {
    if (this.autoresize) {
        this.resize();
    }
    if (this.set_canvas_dirty_on_mouse_event)
        this.dirty_canvas = true;
    if (!this.graph) {
        return;
    }
    LGraphCanvas.active_canvas = this;
    this.adjustMouseEvent(e);
    var mouse = [e.clientX, e.clientY];
    this.mouse[0] = mouse[0];
    this.mouse[1] = mouse[1];
    var delta = [
        mouse[0] - this.last_mouse[0],
        mouse[1] - this.last_mouse[1]
    ];
    this.last_mouse = mouse;
    this.graph_mouse[0] = e.canvasX;
    this.graph_mouse[1] = e.canvasY;
    //console.log("pointerevents: processMouseMove "+e.pointerId+" "+e.isPrimary);
    if (this.block_click) {
        //console.log("pointerevents: processMouseMove block_click");
        e.preventDefault();
        return false;
    }
    e.dragging = this.last_mouse_dragging;
    if (this.node_widget) {
        this.processNodeWidgets(this.node_widget[0], this.graph_mouse, e, this.node_widget[1]);
        this.dirty_canvas = true;
    }
    //get node over
    var node = this.graph.getNodeOnPos(e.canvasX, e.canvasY, this.visible_nodes);
    if (this.dragging_rectangle) {
        this.dragging_rectangle[2] = e.canvasX - this.dragging_rectangle[0];
        this.dragging_rectangle[3] = e.canvasY - this.dragging_rectangle[1];
        this.dirty_canvas = true;
    }
    else if (this.selected_group && !this.read_only) {
        //moving/resizing a group
        if (this.selected_group_resizing) {
            this.selected_group.size = [
                e.canvasX - this.selected_group.pos[0],
                e.canvasY - this.selected_group.pos[1]
            ];
        }
        else {
            var deltax = delta[0] / this.ds.scale;
            var deltay = delta[1] / this.ds.scale;
            this.selected_group.move(deltax, deltay, e.ctrlKey);
            if (this.selected_group._nodes.length) {
                this.dirty_canvas = true;
            }
        }
        this.dirty_bgcanvas = true;
    }
    else if (this.dragging_canvas) {
        ////console.log("pointerevents: processMouseMove is dragging_canvas");
        this.ds.offset[0] += delta[0] / this.ds.scale;
        this.ds.offset[1] += delta[1] / this.ds.scale;
        this.dirty_canvas = true;
        this.dirty_bgcanvas = true;
    }
    else if ((this.allow_interaction || (node && node.flags.allow_interaction)) && !this.read_only) {
        if (this.connecting_node) {
            this.dirty_canvas = true;
        }
        //remove mouseover flag
        for (var i = 0, l = this.graph._nodes.length; i < l; ++i) {
            if (this.graph._nodes[i].mouseOver && node != this.graph._nodes[i]) {
                //mouse leave
                this.graph._nodes[i].mouseOver = false;
                if (this.node_over && this.node_over.onMouseLeave) {
                    this.node_over.onMouseLeave(e);
                }
                this.node_over = null;
                this.dirty_canvas = true;
            }
        }
        //mouse over a node
        if (node) {
            if (node.redraw_on_mouse)
                this.dirty_canvas = true;
            //this.canvas.style.cursor = "move";
            if (!node.mouseOver) {
                //mouse enter
                node.mouseOver = true;
                this.node_over = node;
                this.dirty_canvas = true;
                if (node.onMouseEnter) {
                    node.onMouseEnter(e);
                }
            }
            //in case the node wants to do something
            if (node.onMouseMove) {
                node.onMouseMove(e, [e.canvasX - node.pos[0], e.canvasY - node.pos[1]], this);
            }
            //if dragging a link
            if (this.connecting_node) {
                if (this.connecting_output) {
                    var pos = this._highlight_input || [0, 0]; //to store the output of isOverNodeInput
                    //on top of input
                    if (this.isOverNodeBox(node, e.canvasX, e.canvasY)) {
                        //mouse on top of the corner box, don't know what to do
                    }
                    else {
                        //check if I have a slot below de mouse
                        var slot = this.isOverNodeInput(node, e.canvasX, e.canvasY, pos);
                        if (slot != -1 && node.inputs[slot]) {
                            var slot_type = node.inputs[slot].type;
                            if (exports.LiteGraph.isValidConnection(this.connecting_output.type, slot_type)) {
                                this._highlight_input = pos;
                                this._highlight_input_slot = node.inputs[slot]; // XXX CHECK THIS
                            }
                        }
                        else {
                            this._highlight_input = null;
                            this._highlight_input_slot = null; // XXX CHECK THIS
                        }
                    }
                }
                else if (this.connecting_input) {
                    var pos = this._highlight_output || [0, 0]; //to store the output of isOverNodeOutput
                    //on top of output
                    if (this.isOverNodeBox(node, e.canvasX, e.canvasY)) {
                        //mouse on top of the corner box, don't know what to do
                    }
                    else {
                        //check if I have a slot below de mouse
                        var slot = this.isOverNodeOutput(node, e.canvasX, e.canvasY, pos);
                        if (slot != -1 && node.outputs[slot]) {
                            var slot_type = node.outputs[slot].type;
                            if (exports.LiteGraph.isValidConnection(this.connecting_input.type, slot_type)) {
                                this._highlight_output = pos;
                            }
                        }
                        else {
                            this._highlight_output = null;
                        }
                    }
                }
            }
            //Search for corner
            if (this.canvas) {
                if (isInsideRectangle(e.canvasX, e.canvasY, node.pos[0] + node.size[0] - 5, node.pos[1] + node.size[1] - 5, 5, 5)) {
                    this.canvas.style.cursor = "se-resize";
                }
                else {
                    this.canvas.style.cursor = "crosshair";
                }
            }
        }
        else { //not over a node
            //search for link connector
            var over_link = null;
            for (var i = 0; i < this.visible_links.length; ++i) {
                var link = this.visible_links[i];
                var center = link._pos;
                if (!center ||
                    e.canvasX < center[0] - 4 ||
                    e.canvasX > center[0] + 4 ||
                    e.canvasY < center[1] - 4 ||
                    e.canvasY > center[1] + 4) {
                    continue;
                }
                over_link = link;
                break;
            }
            if (over_link != this.over_link_center) {
                this.over_link_center = over_link;
                this.dirty_canvas = true;
            }
            if (this.canvas) {
                this.canvas.style.cursor = "";
            }
        } //end
        //send event to node if capturing input (used with widgets that allow drag outside of the area of the node)
        if (this.node_capturing_input && this.node_capturing_input != node && this.node_capturing_input.onMouseMove) {
            this.node_capturing_input.onMouseMove(e, [e.canvasX - this.node_capturing_input.pos[0], e.canvasY - this.node_capturing_input.pos[1]], this);
        }
        //node being dragged
        if (this.node_dragged && !this.live_mode) {
            //console.log("draggin!",this.selected_nodes);
            for (var i in this.selected_nodes) {
                var n = this.selected_nodes[i];
                n.pos[0] += delta[0] / this.ds.scale;
                n.pos[1] += delta[1] / this.ds.scale;
                if (!n.is_selected)
                    this.processNodeSelected(n, e); /*
                 * Don't call the function if the block is already selected.
                 * Otherwise, it could cause the block to be unselected while dragging.
                 */
            }
            this.dirty_canvas = true;
            this.dirty_bgcanvas = true;
        }
        if (this.resizing_node && !this.live_mode) {
            //convert mouse to node space
            var desired_size = [e.canvasX - this.resizing_node.pos[0], e.canvasY - this.resizing_node.pos[1]];
            var min_size = this.resizing_node.computeSize();
            desired_size[0] = Math.max(min_size[0], desired_size[0]);
            desired_size[1] = Math.max(min_size[1], desired_size[1]);
            this.resizing_node.setSize(desired_size);
            this.canvas.style.cursor = "se-resize";
            this.dirty_canvas = true;
            this.dirty_bgcanvas = true;
        }
    }
    e.preventDefault();
    return false;
};
/**
 * Called when a mouse up event has to be processed
 * @method processMouseUp
 **/
LGraphCanvas.prototype.processMouseUp = function (e) {
    var is_primary = (e.isPrimary === undefined || e.isPrimary);
    //early exit for extra pointer
    if (!is_primary) {
        /*e.stopPropagation();
        e.preventDefault();*/
        //console.log("pointerevents: processMouseUp pointerN_stop "+e.pointerId+" "+e.isPrimary);
        return false;
    }
    //console.log("pointerevents: processMouseUp "+e.pointerId+" "+e.isPrimary+" :: "+e.clientX+" "+e.clientY);
    if (this.set_canvas_dirty_on_mouse_event)
        this.dirty_canvas = true;
    if (!this.graph)
        return;
    var window = this.getCanvasWindow();
    var document = window.document;
    LGraphCanvas.active_canvas = this;
    //restore the mousemove event back to the canvas
    if (!this.options.skip_events) {
        //console.log("pointerevents: processMouseUp adjustEventListener");
        exports.LiteGraph.pointerListenerRemove(document, "move", this._mousemove_callback, true);
        exports.LiteGraph.pointerListenerAdd(this.canvas, "move", this._mousemove_callback, true);
        exports.LiteGraph.pointerListenerRemove(document, "up", this._mouseup_callback, true);
    }
    this.adjustMouseEvent(e);
    var now = exports.LiteGraph.getTime();
    e.click_time = now - this.last_mouseclick;
    this.last_mouse_dragging = false;
    this.last_click_position = null;
    if (this.block_click) {
        //console.log("pointerevents: processMouseUp block_clicks");
        this.block_click = false; //used to avoid sending twice a click in a immediate button
    }
    //console.log("pointerevents: processMouseUp which: "+e.which);
    if (e.which == 1) {
        if (this.node_widget) {
            this.processNodeWidgets(this.node_widget[0], this.graph_mouse, e);
        }
        //left button
        this.node_widget = null;
        if (this.selected_group) {
            var diffx = this.selected_group.pos[0] -
                Math.round(this.selected_group.pos[0]);
            var diffy = this.selected_group.pos[1] -
                Math.round(this.selected_group.pos[1]);
            this.selected_group.move(diffx, diffy, e.ctrlKey);
            this.selected_group.pos[0] = Math.round(this.selected_group.pos[0]);
            this.selected_group.pos[1] = Math.round(this.selected_group.pos[1]);
            if (this.selected_group._nodes.length) {
                this.dirty_canvas = true;
            }
            this.selected_group = null;
        }
        this.selected_group_resizing = false;
        var node = this.graph.getNodeOnPos(e.canvasX, e.canvasY, this.visible_nodes);
        if (this.dragging_rectangle) {
            if (this.graph) {
                var nodes = this.graph._nodes;
                var node_bounding = new Float32Array(4);
                //compute bounding and flip if left to right
                var w = Math.abs(this.dragging_rectangle[2]);
                var h = Math.abs(this.dragging_rectangle[3]);
                var startx = this.dragging_rectangle[2] < 0
                    ? this.dragging_rectangle[0] - w
                    : this.dragging_rectangle[0];
                var starty = this.dragging_rectangle[3] < 0
                    ? this.dragging_rectangle[1] - h
                    : this.dragging_rectangle[1];
                this.dragging_rectangle[0] = startx;
                this.dragging_rectangle[1] = starty;
                this.dragging_rectangle[2] = w;
                this.dragging_rectangle[3] = h;
                // test dragging rect size, if minimun simulate a click
                if (!node || (w > 10 && h > 10)) {
                    //test against all nodes (not visible because the rectangle maybe start outside
                    var to_select = [];
                    for (var i = 0; i < nodes.length; ++i) {
                        var nodeX = nodes[i];
                        nodeX.getBounding(node_bounding);
                        if (!overlapBounding(this.dragging_rectangle, node_bounding)) {
                            continue;
                        } //out of the visible area
                        to_select.push(nodeX);
                    }
                    if (to_select.length) {
                        this.selectNodes(to_select, e.shiftKey); // add to selection with shift
                    }
                }
                else {
                    // will select of update selection
                    this.selectNodes([node], e.shiftKey || e.ctrlKey); // add to selection add to selection with ctrlKey or shiftKey
                }
            }
            this.dragging_rectangle = null;
        }
        else if (this.connecting_node) {
            //dragging a connection
            this.dirty_canvas = true;
            this.dirty_bgcanvas = true;
            var connInOrOut = this.connecting_output || this.connecting_input;
            var connType = connInOrOut.type;
            //node below mouse
            if (node) {
                /* no need to condition on event type.. just another type
                if (
                    connType == LiteGraph.EVENT &&
                    this.isOverNodeBox(node, e.canvasX, e.canvasY)
                ) {
                    
                    this.connecting_node.connect(
                        this.connecting_slot,
                        node,
                        LiteGraph.EVENT
                    );
                    
                } else {*/
                //slot below mouse? connect
                if (this.connecting_output) {
                    var slot = this.isOverNodeInput(node, e.canvasX, e.canvasY);
                    if (slot != -1) {
                        this.connecting_node.connect(this.connecting_slot, node, slot);
                    }
                    else {
                        //not on top of an input
                        // look for a good slot
                        this.connecting_node.connectByType(this.connecting_slot, node, connType);
                    }
                }
                else if (this.connecting_input) {
                    var slot = this.isOverNodeOutput(node, e.canvasX, e.canvasY);
                    if (slot != -1) {
                        node.connect(slot, this.connecting_node, this.connecting_slot); // this is inverted has output-input nature like
                    }
                    else {
                        //not on top of an input
                        // look for a good slot
                        this.connecting_node.connectByTypeOutput(this.connecting_slot, node, connType);
                    }
                }
                //}
            }
            else {
                // add menu when releasing link in empty space
                if (exports.LiteGraph.release_link_on_empty_shows_menu) {
                    if (e.shiftKey && this.allow_searchbox) {
                        if (this.connecting_output) {
                            this.showSearchBox(e, { node_from: this.connecting_node, slot_from: this.connecting_output, type_filter_in: this.connecting_output.type });
                        }
                        else if (this.connecting_input) {
                            this.showSearchBox(e, { node_to: this.connecting_node, slot_from: this.connecting_input, type_filter_out: this.connecting_input.type });
                        }
                    }
                    else {
                        if (this.connecting_output) {
                            this.showConnectionMenu({ nodeFrom: this.connecting_node, slotFrom: this.connecting_output, e: e });
                        }
                        else if (this.connecting_input) {
                            this.showConnectionMenu({ nodeTo: this.connecting_node, slotTo: this.connecting_input, e: e });
                        }
                    }
                }
            }
            this.connecting_output = null;
            this.connecting_input = null;
            this.connecting_pos = null;
            this.connecting_node = null;
            this.connecting_slot = -1;
        } //not dragging connection
        else if (this.resizing_node) {
            this.dirty_canvas = true;
            this.dirty_bgcanvas = true;
            this.graph.afterChange(this.resizing_node);
            this.resizing_node = null;
        }
        else if (this.node_dragged) {
            //node being dragged?
            var node = this.node_dragged;
            if (node &&
                e.click_time < 300 &&
                isInsideRectangle(e.canvasX, e.canvasY, node.pos[0], node.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT, exports.LiteGraph.NODE_TITLE_HEIGHT, exports.LiteGraph.NODE_TITLE_HEIGHT)) {
                node.collapse();
            }
            this.dirty_canvas = true;
            this.dirty_bgcanvas = true;
            this.node_dragged.pos[0] = Math.round(this.node_dragged.pos[0]);
            this.node_dragged.pos[1] = Math.round(this.node_dragged.pos[1]);
            if (this.graph.config.align_to_grid || this.align_to_grid) {
                this.node_dragged.alignToGrid();
            }
            if (this.onNodeMoved)
                this.onNodeMoved(this.node_dragged);
            this.graph.afterChange(this.node_dragged);
            this.node_dragged = null;
        } //no node being dragged
        else {
            //get node over
            var node = this.graph.getNodeOnPos(e.canvasX, e.canvasY, this.visible_nodes);
            if (!node && e.click_time < 300) {
                this.deselectAllNodes();
            }
            this.dirty_canvas = true;
            this.dragging_canvas = false;
            if (this.node_over && this.node_over.onMouseUp) {
                this.node_over.onMouseUp(e, [e.canvasX - this.node_over.pos[0], e.canvasY - this.node_over.pos[1]], this);
            }
            if (this.node_capturing_input &&
                this.node_capturing_input.onMouseUp) {
                this.node_capturing_input.onMouseUp(e, [
                    e.canvasX - this.node_capturing_input.pos[0],
                    e.canvasY - this.node_capturing_input.pos[1]
                ]);
            }
        }
    }
    else if (e.which == 2) {
        //middle button
        //trace("middle");
        this.dirty_canvas = true;
        this.dragging_canvas = false;
    }
    else if (e.which == 3) {
        //right button
        //trace("right");
        this.dirty_canvas = true;
        this.dragging_canvas = false;
    }
    /*
    if((this.dirty_canvas || this.dirty_bgcanvas) && this.rendering_timer_id == null)
        this.draw();
    */
    if (is_primary) {
        this.pointer_is_down = false;
        this.pointer_is_double = false;
    }
    this.graph.change();
    //console.log("pointerevents: processMouseUp stopPropagation");
    e.stopPropagation();
    e.preventDefault();
    return false;
};
/**
 * Called when a mouse wheel event has to be processed
 * @method processMouseWheel
 **/
LGraphCanvas.prototype.processMouseWheel = function (e) {
    if (!this.graph || !this.allow_dragcanvas) {
        return;
    }
    var delta = e.wheelDeltaY != null ? e.wheelDeltaY : e.detail * -60;
    this.adjustMouseEvent(e);
    var x = e.clientX;
    var y = e.clientY;
    var is_inside = !this.viewport || (this.viewport && x >= this.viewport[0] && x < (this.viewport[0] + this.viewport[2]) && y >= this.viewport[1] && y < (this.viewport[1] + this.viewport[3]));
    if (!is_inside)
        return;
    var scale = this.ds.scale;
    if (delta > 0) {
        scale *= 1.1;
    }
    else if (delta < 0) {
        scale *= 1 / 1.1;
    }
    //this.setZoom( scale, [ e.clientX, e.clientY ] );
    this.ds.changeScale(scale, [e.clientX, e.clientY]);
    this.graph.change();
    e.preventDefault();
    return false; // prevent default
};
/**
 * returns true if a position (in graph space) is on top of a node little corner box
 * @method isOverNodeBox
 **/
LGraphCanvas.prototype.isOverNodeBox = function (node, canvasx, canvasy) {
    var title_height = exports.LiteGraph.NODE_TITLE_HEIGHT;
    if (isInsideRectangle(canvasx, canvasy, node.pos[0] + 2, node.pos[1] + 2 - title_height, title_height - 4, title_height - 4)) {
        return true;
    }
    return false;
};
/**
 * returns the INDEX if a position (in graph space) is on top of a node input slot
 * @method isOverNodeInput
 **/
LGraphCanvas.prototype.isOverNodeInput = function (node, canvasx, canvasy, slot_pos) {
    if (node.inputs) {
        for (var i = 0, l = node.inputs.length; i < l; ++i) {
            var input = node.inputs[i];
            var link_pos = node.getConnectionPos(true, i);
            var is_inside = false;
            if (node.horizontal) {
                is_inside = isInsideRectangle(canvasx, canvasy, link_pos[0] - 5, link_pos[1] - 10, 10, 20);
            }
            else {
                is_inside = isInsideRectangle(canvasx, canvasy, link_pos[0] - 10, link_pos[1] - 5, 40, 10);
            }
            if (is_inside) {
                if (slot_pos) {
                    slot_pos[0] = link_pos[0];
                    slot_pos[1] = link_pos[1];
                }
                return i;
            }
        }
    }
    return -1;
};
/**
 * returns the INDEX if a position (in graph space) is on top of a node output slot
 * @method isOverNodeOuput
 **/
LGraphCanvas.prototype.isOverNodeOutput = function (node, canvasx, canvasy, slot_pos) {
    if (node.outputs) {
        for (var i = 0, l = node.outputs.length; i < l; ++i) {
            var output = node.outputs[i];
            var link_pos = node.getConnectionPos(false, i);
            var is_inside = false;
            if (node.horizontal) {
                is_inside = isInsideRectangle(canvasx, canvasy, link_pos[0] - 5, link_pos[1] - 10, 10, 20);
            }
            else {
                is_inside = isInsideRectangle(canvasx, canvasy, link_pos[0] - 10, link_pos[1] - 5, 40, 10);
            }
            if (is_inside) {
                if (slot_pos) {
                    slot_pos[0] = link_pos[0];
                    slot_pos[1] = link_pos[1];
                }
                return i;
            }
        }
    }
    return -1;
};
/**
 * process a key event
 * @method processKey
 **/
LGraphCanvas.prototype.processKey = function (e) {
    if (!this.graph) {
        return;
    }
    var block_default = false;
    //console.log(e); //debug
    if (e.target.localName == "input") {
        return;
    }
    if (e.type == "keydown") {
        if (e.keyCode == 32) {
            //space
            this.dragging_canvas = true;
            block_default = true;
        }
        if (e.keyCode == 27) {
            //esc
            if (this.node_panel)
                this.node_panel.close();
            if (this.options_panel)
                this.options_panel.close();
            block_default = true;
        }
        //select all Control A
        if (e.keyCode == 65 && e.ctrlKey) {
            this.selectNodes();
            block_default = true;
        }
        if ((e.keyCode === 67) && (e.metaKey || e.ctrlKey) && !e.shiftKey) {
            //copy
            if (this.selected_nodes) {
                this.copyToClipboard();
                block_default = true;
            }
        }
        if ((e.keyCode === 86) && (e.metaKey || e.ctrlKey)) {
            //paste
            this.pasteFromClipboard(e.shiftKey);
        }
        //delete or backspace
        if (e.keyCode == 46 || e.keyCode == 8) {
            if (e.target.localName != "input" &&
                e.target.localName != "textarea") {
                this.deleteSelectedNodes();
                block_default = true;
            }
        }
        //collapse
        //...
        //TODO
        if (this.selected_nodes) {
            for (var i in this.selected_nodes) {
                if (this.selected_nodes[i].onKeyDown) {
                    this.selected_nodes[i].onKeyDown(e);
                }
            }
        }
    }
    else if (e.type == "keyup") {
        if (e.keyCode == 32) {
            // space
            this.dragging_canvas = false;
        }
        if (this.selected_nodes) {
            for (var i in this.selected_nodes) {
                if (this.selected_nodes[i].onKeyUp) {
                    this.selected_nodes[i].onKeyUp(e);
                }
            }
        }
    }
    this.graph.change();
    if (block_default) {
        e.preventDefault();
        e.stopImmediatePropagation();
        return false;
    }
};
LGraphCanvas.prototype.copyToClipboard = function () {
    var clipboard_info = {
        nodes: [],
        links: []
    };
    var index = 0;
    var selected_nodes_array = [];
    for (var i in this.selected_nodes) {
        var node = this.selected_nodes[i];
        if (node.clonable === false)
            continue;
        node._relative_id = index;
        selected_nodes_array.push(node);
        index += 1;
    }
    for (var i = 0; i < selected_nodes_array.length; ++i) {
        var node = selected_nodes_array[i];
        if (node.clonable === false)
            continue;
        var cloned = node.clone();
        if (!cloned) {
            console.warn("node type not found: " + node.type);
            continue;
        }
        clipboard_info.nodes.push(cloned.serialize());
        if (node.inputs && node.inputs.length) {
            for (var j = 0; j < node.inputs.length; ++j) {
                var input = node.inputs[j];
                if (!input || input.link == null) {
                    continue;
                }
                var link_info = this.graph.links[input.link];
                if (!link_info) {
                    continue;
                }
                var target_node = this.graph.getNodeById(link_info.origin_id);
                if (!target_node) {
                    continue;
                }
                clipboard_info.links.push([
                    target_node._relative_id,
                    link_info.origin_slot,
                    node._relative_id,
                    link_info.target_slot,
                    target_node.id
                ]);
            }
        }
    }
    localStorage.setItem("litegrapheditor_clipboard", JSON.stringify(clipboard_info));
};
LGraphCanvas.prototype.pasteFromClipboard = function (isConnectUnselected) {
    if (isConnectUnselected === void 0) { isConnectUnselected = false; }
    // if ctrl + shift + v is off, return when isConnectUnselected is true (shift is pressed) to maintain old behavior
    if (!exports.LiteGraph.ctrl_shift_v_paste_connect_unselected_outputs && isConnectUnselected) {
        return;
    }
    var data = localStorage.getItem("litegrapheditor_clipboard");
    if (!data) {
        return;
    }
    this.graph.beforeChange();
    //create nodes
    var clipboard_info = JSON.parse(data);
    // calculate top-left node, could work without this processing but using diff with last node pos :: clipboard_info.nodes[clipboard_info.nodes.length-1].pos
    var posMin = false;
    var posMinIndexes = false;
    for (var i = 0; i < clipboard_info.nodes.length; ++i) {
        if (posMin) {
            if (posMin[0] > clipboard_info.nodes[i].pos[0]) {
                posMin[0] = clipboard_info.nodes[i].pos[0];
                posMinIndexes[0] = i;
            }
            if (posMin[1] > clipboard_info.nodes[i].pos[1]) {
                posMin[1] = clipboard_info.nodes[i].pos[1];
                posMinIndexes[1] = i;
            }
        }
        else {
            posMin = [clipboard_info.nodes[i].pos[0], clipboard_info.nodes[i].pos[1]];
            posMinIndexes = [i, i];
        }
    }
    var nodes = [];
    for (var i = 0; i < clipboard_info.nodes.length; ++i) {
        var node_data = clipboard_info.nodes[i];
        var node = exports.LiteGraph.createNode(node_data.type);
        if (node) {
            node.configure(node_data);
            //paste in last known mouse position
            node.pos[0] += this.graph_mouse[0] - posMin[0]; //+= 5;
            node.pos[1] += this.graph_mouse[1] - posMin[1]; //+= 5;
            this.graph.add(node, { doProcessChange: false });
            nodes.push(node);
        }
    }
    //create links
    for (var i = 0; i < clipboard_info.links.length; ++i) {
        var link_info = clipboard_info.links[i];
        var origin_node;
        var origin_node_relative_id = link_info[0];
        if (origin_node_relative_id != null) {
            origin_node = nodes[origin_node_relative_id];
        }
        else if (exports.LiteGraph.ctrl_shift_v_paste_connect_unselected_outputs && isConnectUnselected) {
            var origin_node_id = link_info[4];
            if (origin_node_id) {
                origin_node = this.graph.getNodeById(origin_node_id);
            }
        }
        var target_node = nodes[link_info[2]];
        if (origin_node && target_node)
            origin_node.connect(link_info[1], target_node, link_info[3]);
        else
            console.warn("Warning, nodes missing on pasting");
    }
    this.selectNodes(nodes);
    this.graph.afterChange();
};
/**
 * process a item drop event on top the canvas
 * @method processDrop
 **/
LGraphCanvas.prototype.processDrop = function (e) {
    e.preventDefault();
    this.adjustMouseEvent(e);
    var x = e.clientX;
    var y = e.clientY;
    var is_inside = !this.viewport || (this.viewport && x >= this.viewport[0] && x < (this.viewport[0] + this.viewport[2]) && y >= this.viewport[1] && y < (this.viewport[1] + this.viewport[3]));
    if (!is_inside) {
        return;
        // --- BREAK ---
    }
    var pos = [e.canvasX, e.canvasY];
    var node = this.graph ? this.graph.getNodeOnPos(pos[0], pos[1]) : null;
    if (!node) {
        var r = null;
        if (this.onDropItem) {
            r = this.onDropItem(event);
        }
        if (!r) {
            this.checkDropItem(e);
        }
        return;
    }
    if (node.onDropFile || node.onDropData) {
        var files = e.dataTransfer.files;
        if (files && files.length) {
            for (var i = 0; i < files.length; i++) {
                var file = e.dataTransfer.files[0];
                var filename = file.name;
                var ext = LGraphCanvas.getFileExtension(filename);
                //console.log(file);
                if (node.onDropFile) {
                    node.onDropFile(file);
                }
                if (node.onDropData) {
                    //prepare reader
                    var reader = new FileReader();
                    reader.onload = function (event) {
                        //console.log(event.target);
                        var data = event.target.result;
                        node.onDropData(data, filename, file);
                    };
                    //read data
                    var type = file.type.split("/")[0];
                    if (type == "text" || type == "") {
                        reader.readAsText(file);
                    }
                    else if (type == "image") {
                        reader.readAsDataURL(file);
                    }
                    else {
                        reader.readAsArrayBuffer(file);
                    }
                }
            }
        }
    }
    if (node.onDropItem) {
        if (node.onDropItem(event)) {
            return true;
        }
    }
    if (this.onDropItem) {
        return this.onDropItem(event);
    }
    return false;
};
//called if the graph doesn't have a default drop item behaviour
LGraphCanvas.prototype.checkDropItem = function (e) {
    if (e.dataTransfer.files.length) {
        var file = e.dataTransfer.files[0];
        var ext = LGraphCanvas.getFileExtension(file.name).toLowerCase();
        var nodetype = exports.LiteGraph.node_types_by_file_extension[ext];
        if (nodetype) {
            this.graph.beforeChange();
            var node = exports.LiteGraph.createNode(nodetype.type);
            node.pos = [e.canvasX, e.canvasY];
            this.graph.add(node);
            if (node.onDropFile) {
                node.onDropFile(file);
            }
            this.graph.afterChange();
        }
    }
};
LGraphCanvas.prototype.processNodeDblClicked = function (n) {
    if (this.onShowNodePanel) {
        this.onShowNodePanel(n);
    }
    else {
        this.showShowNodePanel(n);
    }
    if (this.onNodeDblClicked) {
        this.onNodeDblClicked(n);
    }
    this.setDirty(true);
};
LGraphCanvas.prototype.processNodeSelected = function (node, e) {
    this.selectNode(node, e && (e.shiftKey || e.ctrlKey || this.multi_select));
    if (this.onNodeSelected) {
        this.onNodeSelected(node);
    }
};
/**
 * selects a given node (or adds it to the current selection)
 * @method selectNode
 **/
LGraphCanvas.prototype.selectNode = function (node, add_to_current_selection) {
    if (node == null) {
        this.deselectAllNodes();
    }
    else {
        this.selectNodes([node], add_to_current_selection);
    }
};
/**
 * selects several nodes (or adds them to the current selection)
 * @method selectNodes
 **/
LGraphCanvas.prototype.selectNodes = function (nodes, add_to_current_selection) {
    if (!add_to_current_selection) {
        this.deselectAllNodes();
    }
    nodes = nodes || this.graph._nodes;
    if (typeof nodes == "string")
        nodes = [nodes];
    for (var i in nodes) {
        var node = nodes[i];
        if (node.is_selected) {
            this.deselectNode(node);
            continue;
        }
        if (!node.is_selected && node.onSelected) {
            node.onSelected();
        }
        node.is_selected = true;
        this.selected_nodes[node.id] = node;
        if (node.inputs) {
            for (var j = 0; j < node.inputs.length; ++j) {
                this.highlighted_links[node.inputs[j].link] = true;
            }
        }
        if (node.outputs) {
            for (var j = 0; j < node.outputs.length; ++j) {
                var out = node.outputs[j];
                if (out.links) {
                    for (var k = 0; k < out.links.length; ++k) {
                        this.highlighted_links[out.links[k]] = true;
                    }
                }
            }
        }
    }
    if (this.onSelectionChange)
        this.onSelectionChange(this.selected_nodes);
    this.setDirty(true);
};
/**
 * removes a node from the current selection
 * @method deselectNode
 **/
LGraphCanvas.prototype.deselectNode = function (node) {
    if (!node.is_selected) {
        return;
    }
    if (node.onDeselected) {
        node.onDeselected();
    }
    node.is_selected = false;
    if (this.onNodeDeselected) {
        this.onNodeDeselected(node);
    }
    //remove highlighted
    if (node.inputs) {
        for (var i = 0; i < node.inputs.length; ++i) {
            delete this.highlighted_links[node.inputs[i].link];
        }
    }
    if (node.outputs) {
        for (var i = 0; i < node.outputs.length; ++i) {
            var out = node.outputs[i];
            if (out.links) {
                for (var j = 0; j < out.links.length; ++j) {
                    delete this.highlighted_links[out.links[j]];
                }
            }
        }
    }
};
/**
 * removes all nodes from the current selection
 * @method deselectAllNodes
 **/
LGraphCanvas.prototype.deselectAllNodes = function () {
    if (!this.graph) {
        return;
    }
    var nodes = this.graph._nodes;
    for (var i = 0, l = nodes.length; i < l; ++i) {
        var node = nodes[i];
        if (!node.is_selected) {
            continue;
        }
        if (node.onDeselected) {
            node.onDeselected();
        }
        node.is_selected = false;
        if (this.onNodeDeselected) {
            this.onNodeDeselected(node);
        }
    }
    this.selected_nodes = {};
    this.current_node = null;
    this.highlighted_links = {};
    if (this.onSelectionChange)
        this.onSelectionChange(this.selected_nodes);
    this.setDirty(true);
};
/**
 * deletes all nodes in the current selection from the graph
 * @method deleteSelectedNodes
 **/
LGraphCanvas.prototype.deleteSelectedNodes = function () {
    this.graph.beforeChange();
    for (var i in this.selected_nodes) {
        var node = this.selected_nodes[i];
        if (node.block_delete)
            continue;
        //autoconnect when possible (very basic, only takes into account first input-output)
        if (node.inputs && node.inputs.length && node.outputs && node.outputs.length && exports.LiteGraph.isValidConnection(node.inputs[0].type, node.outputs[0].type) && node.inputs[0].link && node.outputs[0].links && node.outputs[0].links.length) {
            var input_link = node.graph.links[node.inputs[0].link];
            var output_link = node.graph.links[node.outputs[0].links[0]];
            var input_node = node.getInputNode(0);
            var output_node = node.getOutputNodes(0)[0];
            if (input_node && output_node)
                input_node.connect(input_link.origin_slot, output_node, output_link.target_slot);
        }
        this.graph.remove(node);
        if (this.onNodeDeselected) {
            this.onNodeDeselected(node);
        }
    }
    this.selected_nodes = {};
    this.current_node = null;
    this.highlighted_links = {};
    this.setDirty(true);
    this.graph.afterChange();
};
/**
 * centers the camera on a given node
 * @method centerOnNode
 **/
LGraphCanvas.prototype.centerOnNode = function (node) {
    this.ds.offset[0] =
        -node.pos[0] -
            node.size[0] * 0.5 +
            (this.canvas.width * 0.5) / this.ds.scale;
    this.ds.offset[1] =
        -node.pos[1] -
            node.size[1] * 0.5 +
            (this.canvas.height * 0.5) / this.ds.scale;
    this.setDirty(true, true);
};
/**
 * adds some useful properties to a mouse event, like the position in graph coordinates
 * @method adjustMouseEvent
 **/
LGraphCanvas.prototype.adjustMouseEvent = function (e) {
    var clientX_rel = 0;
    var clientY_rel = 0;
    if (this.canvas) {
        var b = this.canvas.getBoundingClientRect();
        clientX_rel = e.clientX - b.left;
        clientY_rel = e.clientY - b.top;
    }
    else {
        clientX_rel = e.clientX;
        clientY_rel = e.clientY;
    }
    // e.deltaX = clientX_rel - this.last_mouse_position[0];
    // e.deltaY = clientY_rel- this.last_mouse_position[1];
    this.last_mouse_position[0] = clientX_rel;
    this.last_mouse_position[1] = clientY_rel;
    e.canvasX = clientX_rel / this.ds.scale - this.ds.offset[0];
    e.canvasY = clientY_rel / this.ds.scale - this.ds.offset[1];
    //console.log("pointerevents: adjustMouseEvent "+e.clientX+":"+e.clientY+" "+clientX_rel+":"+clientY_rel+" "+e.canvasX+":"+e.canvasY);
};
/**
 * changes the zoom level of the graph (default is 1), you can pass also a place used to pivot the zoom
 * @method setZoom
 **/
LGraphCanvas.prototype.setZoom = function (value, zooming_center) {
    this.ds.changeScale(value, zooming_center);
    /*
if(!zooming_center && this.canvas)
    zooming_center = [this.canvas.width * 0.5,this.canvas.height * 0.5];

var center = this.convertOffsetToCanvas( zooming_center );

this.ds.scale = value;

if(this.scale > this.max_zoom)
    this.scale = this.max_zoom;
else if(this.scale < this.min_zoom)
    this.scale = this.min_zoom;

var new_center = this.convertOffsetToCanvas( zooming_center );
var delta_offset = [new_center[0] - center[0], new_center[1] - center[1]];

this.offset[0] += delta_offset[0];
this.offset[1] += delta_offset[1];
*/
    this.dirty_canvas = true;
    this.dirty_bgcanvas = true;
};
/**
 * converts a coordinate from graph coordinates to canvas2D coordinates
 * @method convertOffsetToCanvas
 **/
LGraphCanvas.prototype.convertOffsetToCanvas = function (pos, out) {
    return this.ds.convertOffsetToCanvas(pos, out);
};
/**
 * converts a coordinate from Canvas2D coordinates to graph space
 * @method convertCanvasToOffset
 **/
LGraphCanvas.prototype.convertCanvasToOffset = function (pos, out) {
    return this.ds.convertCanvasToOffset(pos, out);
};
//converts event coordinates from canvas2D to graph coordinates
LGraphCanvas.prototype.convertEventToCanvasOffset = function (e) {
    var rect = this.canvas.getBoundingClientRect();
    return this.convertCanvasToOffset([
        e.clientX - rect.left,
        e.clientY - rect.top
    ]);
};
/**
 * brings a node to front (above all other nodes)
 * @method bringToFront
 **/
LGraphCanvas.prototype.bringToFront = function (node) {
    var i = this.graph._nodes.indexOf(node);
    if (i == -1) {
        return;
    }
    this.graph._nodes.splice(i, 1);
    this.graph._nodes.push(node);
};
/**
 * sends a node to the back (below all other nodes)
 * @method sendToBack
 **/
LGraphCanvas.prototype.sendToBack = function (node) {
    var i = this.graph._nodes.indexOf(node);
    if (i == -1) {
        return;
    }
    this.graph._nodes.splice(i, 1);
    this.graph._nodes.unshift(node);
};
/* Interaction */
/* LGraphCanvas render */
var temp = new Float32Array(4);
/**
 * checks which nodes are visible (inside the camera area)
 * @method computeVisibleNodes
 **/
LGraphCanvas.prototype.computeVisibleNodes = function (nodes, out) {
    var visible_nodes = out || [];
    visible_nodes.length = 0;
    nodes = nodes || this.graph._nodes;
    for (var i = 0, l = nodes.length; i < l; ++i) {
        var n = nodes[i];
        //skip rendering nodes in live mode
        if (this.live_mode && !n.onDrawBackground && !n.onDrawForeground) {
            continue;
        }
        if (!overlapBounding(this.visible_area, n.getBounding(temp, true))) {
            continue;
        } //out of the visible area
        visible_nodes.push(n);
    }
    return visible_nodes;
};
/**
 * renders the whole canvas content, by rendering in two separated canvas, one containing the background grid and the connections, and one containing the nodes)
 * @method draw
 **/
LGraphCanvas.prototype.draw = function (force_canvas, force_bgcanvas) {
    if (!this.canvas || this.canvas.width == 0 || this.canvas.height == 0) {
        return;
    }
    //fps counting
    var now = exports.LiteGraph.getTime();
    this.render_time = (now - this.last_draw_time) * 0.001;
    this.last_draw_time = now;
    if (this.graph) {
        this.ds.computeVisibleArea(this.viewport);
    }
    if (this.dirty_bgcanvas ||
        force_bgcanvas ||
        this.always_render_background ||
        (this.graph &&
            this.graph._last_trigger_time &&
            now - this.graph._last_trigger_time < 1000)) {
        this.drawBackCanvas();
    }
    if (this.dirty_canvas || force_canvas) {
        this.drawFrontCanvas();
    }
    this.fps = this.render_time ? 1.0 / this.render_time : 0;
    this.frame += 1;
};
/**
 * draws the front canvas (the one containing all the nodes)
 * @method drawFrontCanvas
 **/
LGraphCanvas.prototype.drawFrontCanvas = function () {
    this.dirty_canvas = false;
    if (!this.ctx) {
        this.ctx = this.bgcanvas.getContext("2d");
    }
    var ctx = this.ctx;
    if (!ctx) {
        //maybe is using webgl...
        return;
    }
    var canvas = this.canvas;
    if (ctx.start2D && !this.viewport) {
        ctx.start2D();
        ctx.restore();
        ctx.setTransform(1, 0, 0, 1, 0, 0);
    }
    //clip dirty area if there is one, otherwise work in full canvas
    var area = this.viewport || this.dirty_area;
    if (area) {
        ctx.save();
        ctx.beginPath();
        ctx.rect(area[0], area[1], area[2], area[3]);
        ctx.clip();
    }
    //clear
    //canvas.width = canvas.width;
    if (this.clear_background) {
        if (area)
            ctx.clearRect(area[0], area[1], area[2], area[3]);
        else
            ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
    //draw bg canvas
    if (this.bgcanvas == this.canvas) {
        this.drawBackCanvas();
    }
    else {
        ctx.drawImage(this.bgcanvas, 0, 0);
    }
    //rendering
    if (this.onRender) {
        this.onRender(canvas, ctx);
    }
    //info widget
    if (this.show_info) {
        this.renderInfo(ctx, area ? area[0] : 0, area ? area[1] : 0);
    }
    if (this.graph) {
        //apply transformations
        ctx.save();
        this.ds.toCanvasContext(ctx);
        //draw nodes
        var drawn_nodes = 0;
        var visible_nodes = this.computeVisibleNodes(null, this.visible_nodes);
        for (var i = 0; i < visible_nodes.length; ++i) {
            var node = visible_nodes[i];
            //transform coords system
            ctx.save();
            ctx.translate(node.pos[0], node.pos[1]);
            //Draw
            this.drawNode(node, ctx);
            drawn_nodes += 1;
            //Restore
            ctx.restore();
        }
        //on top (debug)
        if (this.render_execution_order) {
            this.drawExecutionOrder(ctx);
        }
        //connections ontop?
        if (this.graph.config.links_ontop) {
            if (!this.live_mode) {
                this.drawConnections(ctx);
            }
        }
        //current connection (the one being dragged by the mouse)
        if (this.connecting_pos != null) {
            ctx.lineWidth = this.connections_width;
            var link_color = null;
            var connInOrOut = this.connecting_output || this.connecting_input;
            var connType = connInOrOut.type;
            var connDir = connInOrOut.dir;
            if (connDir == null) {
                if (this.connecting_output)
                    connDir = this.connecting_node.horizontal ? exports.LiteGraph.DOWN : exports.LiteGraph.RIGHT;
                else
                    connDir = this.connecting_node.horizontal ? exports.LiteGraph.UP : exports.LiteGraph.LEFT;
            }
            var connShape = connInOrOut.shape;
            switch (connType) {
                case exports.LiteGraph.EVENT:
                    link_color = exports.LiteGraph.EVENT_LINK_COLOR;
                    break;
                default:
                    link_color = exports.LiteGraph.CONNECTING_LINK_COLOR;
            }
            //the connection being dragged by the mouse
            this.renderLink(ctx, this.connecting_pos, [this.graph_mouse[0], this.graph_mouse[1]], null, false, null, link_color, connDir, exports.LiteGraph.CENTER);
            ctx.beginPath();
            if (connType === exports.LiteGraph.EVENT ||
                connShape === exports.LiteGraph.BOX_SHAPE) {
                ctx.rect(this.connecting_pos[0] - 6 + 0.5, this.connecting_pos[1] - 5 + 0.5, 14, 10);
                ctx.fill();
                ctx.beginPath();
                ctx.rect(this.graph_mouse[0] - 6 + 0.5, this.graph_mouse[1] - 5 + 0.5, 14, 10);
            }
            else if (connShape === exports.LiteGraph.ARROW_SHAPE) {
                ctx.moveTo(this.connecting_pos[0] + 8, this.connecting_pos[1] + 0.5);
                ctx.lineTo(this.connecting_pos[0] - 4, this.connecting_pos[1] + 6 + 0.5);
                ctx.lineTo(this.connecting_pos[0] - 4, this.connecting_pos[1] - 6 + 0.5);
                ctx.closePath();
            }
            else {
                ctx.arc(this.connecting_pos[0], this.connecting_pos[1], 4, 0, Math.PI * 2);
                ctx.fill();
                ctx.beginPath();
                ctx.arc(this.graph_mouse[0], this.graph_mouse[1], 4, 0, Math.PI * 2);
            }
            ctx.fill();
            ctx.fillStyle = "#ffcc00";
            if (this._highlight_input) {
                ctx.beginPath();
                var shape = this._highlight_input_slot.shape;
                if (shape === exports.LiteGraph.ARROW_SHAPE) {
                    ctx.moveTo(this._highlight_input[0] + 8, this._highlight_input[1] + 0.5);
                    ctx.lineTo(this._highlight_input[0] - 4, this._highlight_input[1] + 6 + 0.5);
                    ctx.lineTo(this._highlight_input[0] - 4, this._highlight_input[1] - 6 + 0.5);
                    ctx.closePath();
                }
                else {
                    ctx.arc(this._highlight_input[0], this._highlight_input[1], 6, 0, Math.PI * 2);
                }
                ctx.fill();
            }
            if (this._highlight_output) {
                ctx.beginPath();
                if (shape === exports.LiteGraph.ARROW_SHAPE) {
                    ctx.moveTo(this._highlight_output[0] + 8, this._highlight_output[1] + 0.5);
                    ctx.lineTo(this._highlight_output[0] - 4, this._highlight_output[1] + 6 + 0.5);
                    ctx.lineTo(this._highlight_output[0] - 4, this._highlight_output[1] - 6 + 0.5);
                    ctx.closePath();
                }
                else {
                    ctx.arc(this._highlight_output[0], this._highlight_output[1], 6, 0, Math.PI * 2);
                }
                ctx.fill();
            }
        }
        //the selection rectangle
        if (this.dragging_rectangle) {
            ctx.strokeStyle = "#FFF";
            ctx.strokeRect(this.dragging_rectangle[0], this.dragging_rectangle[1], this.dragging_rectangle[2], this.dragging_rectangle[3]);
        }
        //on top of link center
        if (this.over_link_center && this.render_link_tooltip)
            this.drawLinkTooltip(ctx, this.over_link_center);
        else if (this.onDrawLinkTooltip) //to remove
            this.onDrawLinkTooltip(ctx, null);
        //custom info
        if (this.onDrawForeground) {
            this.onDrawForeground(ctx, this.visible_rect);
        }
        ctx.restore();
    }
    //draws panel in the corner 
    if (this._graph_stack && this._graph_stack.length) {
        this.drawSubgraphPanel(ctx);
    }
    if (this.onDrawOverlay) {
        this.onDrawOverlay(ctx);
    }
    if (area) {
        ctx.restore();
    }
    if (ctx.finish2D) {
        //this is a function I use in webgl renderer
        ctx.finish2D();
    }
};
/**
 * draws the panel in the corner that shows subgraph properties
 * @method drawSubgraphPanel
 **/
LGraphCanvas.prototype.drawSubgraphPanel = function (ctx) {
    var subgraph = this.graph;
    var subnode = subgraph._subgraph_node;
    if (!subnode) {
        console.warn("subgraph without subnode");
        return;
    }
    this.drawSubgraphPanelLeft(subgraph, subnode, ctx);
    this.drawSubgraphPanelRight(subgraph, subnode, ctx);
};
LGraphCanvas.prototype.drawSubgraphPanelLeft = function (subgraph, subnode, ctx) {
    var num = subnode.inputs ? subnode.inputs.length : 0;
    var w = 200;
    var h = Math.floor(exports.LiteGraph.NODE_SLOT_HEIGHT * 1.6);
    ctx.fillStyle = "#111";
    ctx.globalAlpha = 0.8;
    ctx.beginPath();
    ctx.roundRect(10, 10, w, (num + 1) * h + 50, [8]);
    ctx.fill();
    ctx.globalAlpha = 1;
    ctx.fillStyle = "#888";
    ctx.font = "14px Arial";
    ctx.textAlign = "left";
    ctx.fillText("Graph Inputs", 20, 34);
    // var pos = this.mouse;
    if (this.drawButton(w - 20, 20, 20, 20, "X", "#151515")) {
        this.closeSubgraph();
        return;
    }
    var y = 50;
    ctx.font = "14px Arial";
    if (subnode.inputs)
        for (var i = 0; i < subnode.inputs.length; ++i) {
            var input = subnode.inputs[i];
            if (input.not_subgraph_input)
                continue;
            //input button clicked
            if (this.drawButton(20, y + 2, w - 20, h - 2)) {
                var type = subnode.constructor.input_node_type || "graph/input";
                this.graph.beforeChange();
                var newnode = exports.LiteGraph.createNode(type);
                if (newnode) {
                    subgraph.add(newnode);
                    this.block_click = false;
                    this.last_click_position = null;
                    this.selectNodes([newnode]);
                    this.node_dragged = newnode;
                    this.dragging_canvas = false;
                    newnode.setProperty("name", input.name);
                    newnode.setProperty("type", input.type);
                    this.node_dragged.pos[0] = this.graph_mouse[0] - 5;
                    this.node_dragged.pos[1] = this.graph_mouse[1] - 5;
                    this.graph.afterChange();
                }
                else
                    console.error("graph input node not found:", type);
            }
            ctx.fillStyle = "#9C9";
            ctx.beginPath();
            ctx.arc(w - 16, y + h * 0.5, 5, 0, 2 * Math.PI);
            ctx.fill();
            ctx.fillStyle = "#AAA";
            ctx.fillText(input.name, 30, y + h * 0.75);
            // var tw = ctx.measureText(input.name);
            ctx.fillStyle = "#777";
            ctx.fillText(input.type, 130, y + h * 0.75);
            y += h;
        }
    //add + button
    if (this.drawButton(20, y + 2, w - 20, h - 2, "+", "#151515", "#222")) {
        this.showSubgraphPropertiesDialog(subnode);
    }
};
LGraphCanvas.prototype.drawSubgraphPanelRight = function (subgraph, subnode, ctx) {
    var num = subnode.outputs ? subnode.outputs.length : 0;
    var canvas_w = this.bgcanvas.width;
    var w = 200;
    var h = Math.floor(exports.LiteGraph.NODE_SLOT_HEIGHT * 1.6);
    ctx.fillStyle = "#111";
    ctx.globalAlpha = 0.8;
    ctx.beginPath();
    ctx.roundRect(canvas_w - w - 10, 10, w, (num + 1) * h + 50, [8]);
    ctx.fill();
    ctx.globalAlpha = 1;
    ctx.fillStyle = "#888";
    ctx.font = "14px Arial";
    ctx.textAlign = "left";
    var title_text = "Graph Outputs";
    var tw = ctx.measureText(title_text).width;
    ctx.fillText(title_text, (canvas_w - tw) - 20, 34);
    // var pos = this.mouse;
    if (this.drawButton(canvas_w - w, 20, 20, 20, "X", "#151515")) {
        this.closeSubgraph();
        return;
    }
    var y = 50;
    ctx.font = "14px Arial";
    if (subnode.outputs)
        for (var i = 0; i < subnode.outputs.length; ++i) {
            var output = subnode.outputs[i];
            if (output.not_subgraph_input)
                continue;
            //output button clicked
            if (this.drawButton(canvas_w - w, y + 2, w - 20, h - 2)) {
                var type = subnode.constructor.output_node_type || "graph/output";
                this.graph.beforeChange();
                var newnode = exports.LiteGraph.createNode(type);
                if (newnode) {
                    subgraph.add(newnode);
                    this.block_click = false;
                    this.last_click_position = null;
                    this.selectNodes([newnode]);
                    this.node_dragged = newnode;
                    this.dragging_canvas = false;
                    newnode.setProperty("name", output.name);
                    newnode.setProperty("type", output.type);
                    this.node_dragged.pos[0] = this.graph_mouse[0] - 5;
                    this.node_dragged.pos[1] = this.graph_mouse[1] - 5;
                    this.graph.afterChange();
                }
                else
                    console.error("graph input node not found:", type);
            }
            ctx.fillStyle = "#9C9";
            ctx.beginPath();
            ctx.arc(canvas_w - w + 16, y + h * 0.5, 5, 0, 2 * Math.PI);
            ctx.fill();
            ctx.fillStyle = "#AAA";
            ctx.fillText(output.name, canvas_w - w + 30, y + h * 0.75);
            // var tw = ctx.measureText(input.name);
            ctx.fillStyle = "#777";
            ctx.fillText(output.type, canvas_w - w + 130, y + h * 0.75);
            y += h;
        }
    //add + button
    if (this.drawButton(canvas_w - w, y + 2, w - 20, h - 2, "+", "#151515", "#222")) {
        this.showSubgraphPropertiesDialogRight(subnode);
    }
};
//Draws a button into the canvas overlay and computes if it was clicked using the immediate gui paradigm
LGraphCanvas.prototype.drawButton = function (x, y, w, h, text, bgcolor, hovercolor, textcolor) {
    var ctx = this.ctx;
    bgcolor = bgcolor || exports.LiteGraph.NODE_DEFAULT_COLOR;
    hovercolor = hovercolor || "#555";
    textcolor = textcolor || exports.LiteGraph.NODE_TEXT_COLOR;
    var pos = this.ds.convertOffsetToCanvas(this.graph_mouse);
    var hover = exports.LiteGraph.isInsideRectangle(pos[0], pos[1], x, y, w, h);
    pos = this.last_click_position ? [this.last_click_position[0], this.last_click_position[1]] : null;
    if (pos) {
        var rect = this.canvas.getBoundingClientRect();
        pos[0] -= rect.left;
        pos[1] -= rect.top;
    }
    var clicked = pos && exports.LiteGraph.isInsideRectangle(pos[0], pos[1], x, y, w, h);
    ctx.fillStyle = hover ? hovercolor : bgcolor;
    if (clicked)
        ctx.fillStyle = "#AAA";
    ctx.beginPath();
    ctx.roundRect(x, y, w, h, [4]);
    ctx.fill();
    if (text != null) {
        if (text.constructor == String) {
            ctx.fillStyle = textcolor;
            ctx.textAlign = "center";
            ctx.font = ((h * 0.65) | 0) + "px Arial";
            ctx.fillText(text, x + w * 0.5, y + h * 0.75);
            ctx.textAlign = "left";
        }
    }
    var was_clicked = clicked && !this.block_click;
    if (clicked)
        this.blockClick();
    return was_clicked;
};
LGraphCanvas.prototype.isAreaClicked = function (x, y, w, h, hold_click) {
    var pos = this.mouse;
    var hover = exports.LiteGraph.isInsideRectangle(pos[0], pos[1], x, y, w, h);
    pos = this.last_click_position;
    var clicked = pos && exports.LiteGraph.isInsideRectangle(pos[0], pos[1], x, y, w, h);
    var was_clicked = clicked && !this.block_click;
    if (clicked && hold_click)
        this.blockClick();
    return was_clicked;
};
/**
 * draws some useful stats in the corner of the canvas
 * @method renderInfo
 **/
LGraphCanvas.prototype.renderInfo = function (ctx, x, y) {
    x = x || 10;
    y = y || this.canvas.height - 80;
    ctx.save();
    ctx.translate(x, y);
    ctx.font = "10px Arial";
    ctx.fillStyle = "#888";
    ctx.textAlign = "left";
    if (this.graph) {
        ctx.fillText("T: " + this.graph.globaltime.toFixed(2) + "s", 5, 13 * 1);
        ctx.fillText("I: " + this.graph.iteration, 5, 13 * 2);
        ctx.fillText("N: " + this.graph._nodes.length + " [" + this.visible_nodes.length + "]", 5, 13 * 3);
        ctx.fillText("V: " + this.graph._version, 5, 13 * 4);
        ctx.fillText("FPS:" + this.fps.toFixed(2), 5, 13 * 5);
    }
    else {
        ctx.fillText("No graph selected", 5, 13 * 1);
    }
    ctx.restore();
};
/**
 * draws the back canvas (the one containing the background and the connections)
 * @method drawBackCanvas
 **/
LGraphCanvas.prototype.drawBackCanvas = function () {
    var canvas = this.bgcanvas;
    if (canvas.width != this.canvas.width ||
        canvas.height != this.canvas.height) {
        canvas.width = this.canvas.width;
        canvas.height = this.canvas.height;
    }
    if (!this.bgctx) {
        this.bgctx = this.bgcanvas.getContext("2d");
    }
    var ctx = this.bgctx;
    if (ctx.start) {
        ctx.start();
    }
    var viewport = this.viewport || [0, 0, ctx.canvas.width, ctx.canvas.height];
    //clear
    if (this.clear_background) {
        ctx.clearRect(viewport[0], viewport[1], viewport[2], viewport[3]);
    }
    //show subgraph stack header
    if (this._graph_stack && this._graph_stack.length) {
        ctx.save();
        var parent_graph = this._graph_stack[this._graph_stack.length - 1];
        var subgraph_node = this.graph._subgraph_node;
        ctx.strokeStyle = subgraph_node.bgcolor;
        ctx.lineWidth = 10;
        ctx.strokeRect(1, 1, canvas.width - 2, canvas.height - 2);
        ctx.lineWidth = 1;
        ctx.font = "40px Arial";
        ctx.textAlign = "center";
        ctx.fillStyle = subgraph_node.bgcolor || "#AAA";
        var title = "";
        for (var i = 1; i < this._graph_stack.length; ++i) {
            title +=
                this._graph_stack[i]._subgraph_node.getTitle() + " >> ";
        }
        ctx.fillText(title + subgraph_node.getTitle(), canvas.width * 0.5, 40);
        ctx.restore();
    }
    var bg_already_painted = false;
    if (this.onRenderBackground) {
        bg_already_painted = this.onRenderBackground(canvas, ctx);
    }
    //reset in case of error
    if (!this.viewport) {
        ctx.restore();
        ctx.setTransform(1, 0, 0, 1, 0, 0);
    }
    this.visible_links.length = 0;
    if (this.graph) {
        //apply transformations
        ctx.save();
        this.ds.toCanvasContext(ctx);
        //render BG
        if (this.ds.scale < 1.5 && !bg_already_painted && this.clear_background_color) {
            ctx.fillStyle = this.clear_background_color;
            ctx.fillRect(this.visible_area[0], this.visible_area[1], this.visible_area[2], this.visible_area[3]);
        }
        if (this.background_image &&
            this.ds.scale > 0.5 &&
            !bg_already_painted) {
            if (this.zoom_modify_alpha) {
                ctx.globalAlpha =
                    (1.0 - 0.5 / this.ds.scale) * this.editor_alpha;
            }
            else {
                ctx.globalAlpha = this.editor_alpha;
            }
            ctx.imageSmoothingEnabled = ctx.imageSmoothingEnabled = false; // ctx.mozImageSmoothingEnabled = 
            if (!this._bg_img ||
                this._bg_img.name != this.background_image) {
                this._bg_img = new Image();
                this._bg_img.name = this.background_image;
                this._bg_img.src = this.background_image;
                var that = this;
                this._bg_img.onload = function () {
                    that.draw(true, true);
                };
            }
            var pattern = null;
            if (this._pattern == null && this._bg_img.width > 0) {
                pattern = ctx.createPattern(this._bg_img, "repeat");
                this._pattern_img = this._bg_img;
                this._pattern = pattern;
            }
            else {
                pattern = this._pattern;
            }
            if (pattern) {
                ctx.fillStyle = pattern;
                ctx.fillRect(this.visible_area[0], this.visible_area[1], this.visible_area[2], this.visible_area[3]);
                ctx.fillStyle = "transparent";
            }
            ctx.globalAlpha = 1.0;
            ctx.imageSmoothingEnabled = ctx.imageSmoothingEnabled = true; //= ctx.mozImageSmoothingEnabled
        }
        //groups
        if (this.graph._groups.length && !this.live_mode) {
            this.drawGroups(canvas, ctx);
        }
        if (this.onDrawBackground) {
            this.onDrawBackground(ctx, this.visible_area);
        }
        if (this.onBackgroundRender) {
            //LEGACY
            console.error("WARNING! onBackgroundRender deprecated, now is named onDrawBackground ");
            this.onBackgroundRender = null;
        }
        //DEBUG: show clipping area
        //ctx.fillStyle = "red";
        //ctx.fillRect( this.visible_area[0] + 10, this.visible_area[1] + 10, this.visible_area[2] - 20, this.visible_area[3] - 20);
        //bg
        if (this.render_canvas_border) {
            ctx.strokeStyle = "#235";
            ctx.strokeRect(0, 0, canvas.width, canvas.height);
        }
        if (this.render_connections_shadows) {
            ctx.shadowColor = "#000";
            ctx.shadowOffsetX = 0;
            ctx.shadowOffsetY = 0;
            ctx.shadowBlur = 6;
        }
        else {
            ctx.shadowColor = "rgba(0,0,0,0)";
        }
        //draw connections
        if (!this.live_mode) {
            this.drawConnections(ctx);
        }
        ctx.shadowColor = "rgba(0,0,0,0)";
        //restore state
        ctx.restore();
    }
    if (ctx.finish) {
        ctx.finish();
    }
    this.dirty_bgcanvas = false;
    this.dirty_canvas = true; //to force to repaint the front canvas with the bgcanvas
};
var temp_vec2 = new Float32Array(2);
/**
 * draws the given node inside the canvas
 * @method drawNode
 **/
LGraphCanvas.prototype.drawNode = function (node, ctx) {
    var glow = false;
    this.current_node = node;
    var color = node.color || node.constructor.color || exports.LiteGraph.NODE_DEFAULT_COLOR;
    var bgcolor = node.bgcolor || node.constructor.bgcolor || exports.LiteGraph.NODE_DEFAULT_BGCOLOR;
    //shadow and glow
    if (node.mouseOver) {
        glow = true;
    }
    var low_quality = this.ds.scale < 0.6; //zoomed out
    //only render if it forces it to do it
    if (this.live_mode) {
        if (!node.flags.collapsed) {
            ctx.shadowColor = "transparent";
            if (node.onDrawForeground) {
                node.onDrawForeground(ctx, this, this.canvas);
            }
        }
        return;
    }
    var editor_alpha = this.editor_alpha;
    ctx.globalAlpha = editor_alpha;
    if (this.render_shadows && !low_quality) {
        ctx.shadowColor = exports.LiteGraph.DEFAULT_SHADOW_COLOR;
        ctx.shadowOffsetX = 2 * this.ds.scale;
        ctx.shadowOffsetY = 2 * this.ds.scale;
        ctx.shadowBlur = 3 * this.ds.scale;
    }
    else {
        ctx.shadowColor = "transparent";
    }
    //custom draw collapsed method (draw after shadows because they are affected)
    if (node.flags.collapsed &&
        node.onDrawCollapsed &&
        node.onDrawCollapsed(ctx, this) == true) {
        return;
    }
    //clip if required (mask)
    var shape = node._shape || exports.LiteGraph.BOX_SHAPE;
    var size = temp_vec2;
    temp_vec2.set(node.size);
    var horizontal = node.horizontal; // || node.flags.horizontal;
    if (node.flags.collapsed) {
        ctx.font = this.inner_text_font;
        var title = node.getTitle ? node.getTitle() : node.title;
        if (title != null) {
            node._collapsed_width = Math.min(node.size[0], ctx.measureText(title).width +
                exports.LiteGraph.NODE_TITLE_HEIGHT * 2); //LiteGraph.NODE_COLLAPSED_WIDTH;
            size[0] = node._collapsed_width;
            size[1] = 0;
        }
    }
    if (node.clip_area) {
        //Start clipping
        ctx.save();
        ctx.beginPath();
        if (shape == exports.LiteGraph.BOX_SHAPE) {
            ctx.rect(0, 0, size[0], size[1]);
        }
        else if (shape == exports.LiteGraph.ROUND_SHAPE) {
            ctx.roundRect(0, 0, size[0], size[1], [10]);
        }
        else if (shape == exports.LiteGraph.CIRCLE_SHAPE) {
            ctx.arc(size[0] * 0.5, size[1] * 0.5, size[0] * 0.5, 0, Math.PI * 2);
        }
        ctx.clip();
    }
    //draw shape
    if (node.has_errors) {
        bgcolor = "red";
    }
    this.drawNodeShape(node, ctx, size, color, bgcolor, node.is_selected, node.mouseOver);
    ctx.shadowColor = "transparent";
    //draw foreground
    if (node.onDrawForeground) {
        node.onDrawForeground(ctx, this, this.canvas);
    }
    //connection slots
    ctx.textAlign = horizontal ? "center" : "left";
    ctx.font = this.inner_text_font;
    var render_text = !low_quality;
    var out_slot = this.connecting_output;
    var in_slot = this.connecting_input;
    ctx.lineWidth = 1;
    var max_y = 0;
    var slot_pos = new Float32Array(2); //to reuse
    //render inputs and outputs
    if (!node.flags.collapsed) {
        //input connection slots
        if (node.inputs) {
            for (var i = 0; i < node.inputs.length; i++) {
                var slot = node.inputs[i];
                var slot_type = slot.type;
                var slot_shape = slot.shape;
                ctx.globalAlpha = editor_alpha;
                //change opacity of incompatible slots when dragging a connection
                if (this.connecting_output && !exports.LiteGraph.isValidConnection(slot.type, out_slot.type)) {
                    ctx.globalAlpha = 0.4 * editor_alpha;
                }
                ctx.fillStyle =
                    slot.link != null
                        ? slot.color_on ||
                            this.default_connection_color_byType[slot_type] ||
                            this.default_connection_color.input_on
                        : slot.color_off ||
                            this.default_connection_color_byTypeOff[slot_type] ||
                            this.default_connection_color_byType[slot_type] ||
                            this.default_connection_color.input_off;
                var pos = node.getConnectionPos(true, i, slot_pos);
                pos[0] -= node.pos[0];
                pos[1] -= node.pos[1];
                if (max_y < pos[1] + exports.LiteGraph.NODE_SLOT_HEIGHT * 0.5) {
                    max_y = pos[1] + exports.LiteGraph.NODE_SLOT_HEIGHT * 0.5;
                }
                ctx.beginPath();
                if (slot_type == "array") {
                    slot_shape = exports.LiteGraph.GRID_SHAPE; // place in addInput? addOutput instead?
                }
                var doStroke = true;
                if (slot.type === exports.LiteGraph.EVENT ||
                    slot.shape === exports.LiteGraph.BOX_SHAPE) {
                    if (horizontal) {
                        ctx.rect(pos[0] - 5 + 0.5, pos[1] - 8 + 0.5, 10, 14);
                    }
                    else {
                        ctx.rect(pos[0] - 6 + 0.5, pos[1] - 5 + 0.5, 14, 10);
                    }
                }
                else if (slot_shape === exports.LiteGraph.ARROW_SHAPE) {
                    ctx.moveTo(pos[0] + 8, pos[1] + 0.5);
                    ctx.lineTo(pos[0] - 4, pos[1] + 6 + 0.5);
                    ctx.lineTo(pos[0] - 4, pos[1] - 6 + 0.5);
                    ctx.closePath();
                }
                else if (slot_shape === exports.LiteGraph.GRID_SHAPE) {
                    ctx.rect(pos[0] - 4, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] - 4, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] - 4, pos[1] + 2, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] + 2, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] + 2, 2, 2);
                    doStroke = false;
                }
                else {
                    if (low_quality)
                        ctx.rect(pos[0] - 4, pos[1] - 4, 8, 8); //faster
                    else
                        ctx.arc(pos[0], pos[1], 4, 0, Math.PI * 2);
                }
                ctx.fill();
                //render name
                if (render_text) {
                    var text = slot.label != null ? slot.label : slot.name;
                    if (text) {
                        ctx.fillStyle = exports.LiteGraph.NODE_TEXT_COLOR;
                        if (horizontal || slot.dir == exports.LiteGraph.UP) {
                            ctx.fillText(text, pos[0], pos[1] - 10);
                        }
                        else {
                            ctx.fillText(text, pos[0] + 10, pos[1] + 5);
                        }
                    }
                }
            }
        }
        //output connection slots
        ctx.textAlign = horizontal ? "center" : "right";
        ctx.strokeStyle = "black";
        if (node.outputs) {
            for (var i = 0; i < node.outputs.length; i++) {
                var slot = node.outputs[i];
                var slot_type = slot.type;
                var slot_shape = slot.shape;
                //change opacity of incompatible slots when dragging a connection
                if (this.connecting_input && !exports.LiteGraph.isValidConnection(slot_type, in_slot.type)) {
                    ctx.globalAlpha = 0.4 * editor_alpha;
                }
                var pos = node.getConnectionPos(false, i, slot_pos);
                pos[0] -= node.pos[0];
                pos[1] -= node.pos[1];
                if (max_y < pos[1] + exports.LiteGraph.NODE_SLOT_HEIGHT * 0.5) {
                    max_y = pos[1] + exports.LiteGraph.NODE_SLOT_HEIGHT * 0.5;
                }
                ctx.fillStyle =
                    slot.links && slot.links.length
                        ? slot.color_on ||
                            this.default_connection_color_byType[slot_type] ||
                            this.default_connection_color.output_on
                        : slot.color_off ||
                            this.default_connection_color_byTypeOff[slot_type] ||
                            this.default_connection_color_byType[slot_type] ||
                            this.default_connection_color.output_off;
                ctx.beginPath();
                //ctx.rect( node.size[0] - 14,i*14,10,10);
                if (slot_type == "array") {
                    slot_shape = exports.LiteGraph.GRID_SHAPE;
                }
                var doStroke = true;
                if (slot_type === exports.LiteGraph.EVENT ||
                    slot_shape === exports.LiteGraph.BOX_SHAPE) {
                    if (horizontal) {
                        ctx.rect(pos[0] - 5 + 0.5, pos[1] - 8 + 0.5, 10, 14);
                    }
                    else {
                        ctx.rect(pos[0] - 6 + 0.5, pos[1] - 5 + 0.5, 14, 10);
                    }
                }
                else if (slot_shape === exports.LiteGraph.ARROW_SHAPE) {
                    ctx.moveTo(pos[0] + 8, pos[1] + 0.5);
                    ctx.lineTo(pos[0] - 4, pos[1] + 6 + 0.5);
                    ctx.lineTo(pos[0] - 4, pos[1] - 6 + 0.5);
                    ctx.closePath();
                }
                else if (slot_shape === exports.LiteGraph.GRID_SHAPE) {
                    ctx.rect(pos[0] - 4, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] - 4, 2, 2);
                    ctx.rect(pos[0] - 4, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] - 1, 2, 2);
                    ctx.rect(pos[0] - 4, pos[1] + 2, 2, 2);
                    ctx.rect(pos[0] - 1, pos[1] + 2, 2, 2);
                    ctx.rect(pos[0] + 2, pos[1] + 2, 2, 2);
                    doStroke = false;
                }
                else {
                    if (low_quality)
                        ctx.rect(pos[0] - 4, pos[1] - 4, 8, 8);
                    else
                        ctx.arc(pos[0], pos[1], 4, 0, Math.PI * 2);
                }
                //trigger
                //if(slot.node_id != null && slot.slot == -1)
                //	ctx.fillStyle = "#F85";
                //if(slot.links != null && slot.links.length)
                ctx.fill();
                if (!low_quality && doStroke)
                    ctx.stroke();
                //render output name
                if (render_text) {
                    var text = slot.label != null ? slot.label : slot.name;
                    if (text) {
                        ctx.fillStyle = exports.LiteGraph.NODE_TEXT_COLOR;
                        if (horizontal || slot.dir == exports.LiteGraph.DOWN) {
                            ctx.fillText(text, pos[0], pos[1] - 8);
                        }
                        else {
                            ctx.fillText(text, pos[0] - 10, pos[1] + 5);
                        }
                    }
                }
            }
        }
        ctx.textAlign = "left";
        ctx.globalAlpha = 1;
        if (node.widgets) {
            var widgets_y = max_y;
            if (horizontal || node.widgets_up) {
                widgets_y = 2;
            }
            if (node.widgets_start_y != null)
                widgets_y = node.widgets_start_y;
            this.drawNodeWidgets(node, widgets_y, ctx, this.node_widget && this.node_widget[0] == node
                ? this.node_widget[1]
                : null);
        }
    }
    else if (this.render_collapsed_slots) {
        //if collapsed
        var input_slot = null;
        var output_slot = null;
        //get first connected slot to render
        if (node.inputs) {
            for (var i = 0; i < node.inputs.length; i++) {
                var slot = node.inputs[i];
                if (slot.link == null) {
                    continue;
                }
                input_slot = slot;
                break;
            }
        }
        if (node.outputs) {
            for (var i = 0; i < node.outputs.length; i++) {
                var slot = node.outputs[i];
                if (!slot.links || !slot.links.length) {
                    continue;
                }
                output_slot = slot;
            }
        }
        if (input_slot) {
            var x = 0;
            var y = exports.LiteGraph.NODE_TITLE_HEIGHT * -0.5; //center
            if (horizontal) {
                x = node._collapsed_width * 0.5;
                y = -exports.LiteGraph.NODE_TITLE_HEIGHT;
            }
            ctx.fillStyle = "#686";
            ctx.beginPath();
            if (slot.type === exports.LiteGraph.EVENT ||
                slot.shape === exports.LiteGraph.BOX_SHAPE) {
                ctx.rect(x - 7 + 0.5, y - 4, 14, 8);
            }
            else if (slot.shape === exports.LiteGraph.ARROW_SHAPE) {
                ctx.moveTo(x + 8, y);
                ctx.lineTo(x + -4, y - 4);
                ctx.lineTo(x + -4, y + 4);
                ctx.closePath();
            }
            else {
                ctx.arc(x, y, 4, 0, Math.PI * 2);
            }
            ctx.fill();
        }
        if (output_slot) {
            var x = node._collapsed_width;
            var y = exports.LiteGraph.NODE_TITLE_HEIGHT * -0.5; //center
            if (horizontal) {
                x = node._collapsed_width * 0.5;
                y = 0;
            }
            ctx.fillStyle = "#686";
            ctx.strokeStyle = "black";
            ctx.beginPath();
            if (slot.type === exports.LiteGraph.EVENT ||
                slot.shape === exports.LiteGraph.BOX_SHAPE) {
                ctx.rect(x - 7 + 0.5, y - 4, 14, 8);
            }
            else if (slot.shape === exports.LiteGraph.ARROW_SHAPE) {
                ctx.moveTo(x + 6, y);
                ctx.lineTo(x - 6, y - 4);
                ctx.lineTo(x - 6, y + 4);
                ctx.closePath();
            }
            else {
                ctx.arc(x, y, 4, 0, Math.PI * 2);
            }
            ctx.fill();
            //ctx.stroke();
        }
    }
    if (node.clip_area) {
        ctx.restore();
    }
    ctx.globalAlpha = 1.0;
};
//used by this.over_link_center
LGraphCanvas.prototype.drawLinkTooltip = function (ctx, link) {
    var pos = link._pos;
    ctx.fillStyle = "black";
    ctx.beginPath();
    ctx.arc(pos[0], pos[1], 3, 0, Math.PI * 2);
    ctx.fill();
    if (link.data == null)
        return;
    if (this.onDrawLinkTooltip)
        if (this.onDrawLinkTooltip(ctx, link, this) == true)
            return;
    var data = link.data;
    var text = null;
    if (data.constructor === Number)
        text = data.toFixed(2);
    else if (data.constructor === String)
        text = "\"" + data + "\"";
    else if (data.constructor === Boolean)
        text = String(data);
    else if (data.toToolTip)
        text = data.toToolTip();
    else
        text = "[" + data.constructor.name + "]";
    if (text == null)
        return;
    text = text.substr(0, 30); //avoid weird
    ctx.font = "14px Courier New";
    var info = ctx.measureText(text);
    var w = info.width + 20;
    var h = 24;
    ctx.shadowColor = "black";
    ctx.shadowOffsetX = 2;
    ctx.shadowOffsetY = 2;
    ctx.shadowBlur = 3;
    ctx.fillStyle = "#454";
    ctx.beginPath();
    ctx.roundRect(pos[0] - w * 0.5, pos[1] - 15 - h, w, h, [3]);
    ctx.moveTo(pos[0] - 10, pos[1] - 15);
    ctx.lineTo(pos[0] + 10, pos[1] - 15);
    ctx.lineTo(pos[0], pos[1] - 5);
    ctx.fill();
    ctx.shadowColor = "transparent";
    ctx.textAlign = "center";
    ctx.fillStyle = "#CEC";
    ctx.fillText(text, pos[0], pos[1] - 15 - h * 0.3);
};
/**
 * draws the shape of the given node in the canvas
 * @method drawNodeShape
 **/
var tmp_area = new Float32Array(4);
LGraphCanvas.prototype.drawNodeShape = function (node, ctx, size, fgcolor, bgcolor, selected, mouse_over) {
    //bg rect
    ctx.strokeStyle = fgcolor;
    ctx.fillStyle = bgcolor;
    var title_height = exports.LiteGraph.NODE_TITLE_HEIGHT;
    var low_quality = this.ds.scale < 0.5;
    //render node area depending on shape
    var shape = node._shape || node.constructor.shape || exports.LiteGraph.ROUND_SHAPE;
    var title_mode = node.constructor.title_mode;
    var render_title = true;
    if (title_mode == exports.LiteGraph.TRANSPARENT_TITLE || title_mode == exports.LiteGraph.NO_TITLE) {
        render_title = false;
    }
    else if (title_mode == exports.LiteGraph.AUTOHIDE_TITLE && mouse_over) {
        render_title = true;
    }
    var area = tmp_area;
    area[0] = 0; //x
    area[1] = render_title ? -title_height : 0; //y
    area[2] = size[0] + 1; //w
    area[3] = render_title ? size[1] + title_height : size[1]; //h
    var old_alpha = ctx.globalAlpha;
    //full node shape
    //if(node.flags.collapsed)
    {
        ctx.beginPath();
        if (shape == exports.LiteGraph.BOX_SHAPE || low_quality) {
            ctx.fillRect(area[0], area[1], area[2], area[3]);
        }
        else if (shape == exports.LiteGraph.ROUND_SHAPE ||
            shape == exports.LiteGraph.CARD_SHAPE) {
            ctx.roundRect(area[0], area[1], area[2], area[3], shape == exports.LiteGraph.CARD_SHAPE ? [this.round_radius, this.round_radius, 0, 0] : [this.round_radius]);
        }
        else if (shape == exports.LiteGraph.CIRCLE_SHAPE) {
            ctx.arc(size[0] * 0.5, size[1] * 0.5, size[0] * 0.5, 0, Math.PI * 2);
        }
        ctx.fill();
        //separator
        if (!node.flags.collapsed && render_title) {
            ctx.shadowColor = "transparent";
            ctx.fillStyle = "rgba(0,0,0,0.2)";
            ctx.fillRect(0, -1, area[2], 2);
        }
    }
    ctx.shadowColor = "transparent";
    if (node.onDrawBackground) {
        node.onDrawBackground(ctx, this, this.canvas, this.graph_mouse);
    }
    //title bg (remember, it is rendered ABOVE the node)
    if (render_title || title_mode == exports.LiteGraph.TRANSPARENT_TITLE) {
        //title bar
        if (node.onDrawTitleBar) {
            node.onDrawTitleBar(ctx, title_height, size, this.ds.scale, fgcolor);
        }
        else if (title_mode != exports.LiteGraph.TRANSPARENT_TITLE &&
            (node.constructor.title_color || this.render_title_colored)) {
            var title_color = node.constructor.title_color || fgcolor;
            if (node.flags.collapsed) {
                ctx.shadowColor = exports.LiteGraph.DEFAULT_SHADOW_COLOR;
            }
            //* gradient test
            if (this.use_gradients) {
                var grad = LGraphCanvas.gradients[title_color];
                if (!grad) {
                    grad = LGraphCanvas.gradients[title_color] = ctx.createLinearGradient(0, 0, 400, 0);
                    grad.addColorStop(0, title_color); // TODO refactor: validate color !! prevent DOMException
                    grad.addColorStop(1, "#000");
                }
                ctx.fillStyle = grad;
            }
            else {
                ctx.fillStyle = title_color;
            }
            //ctx.globalAlpha = 0.5 * old_alpha;
            ctx.beginPath();
            if (shape == exports.LiteGraph.BOX_SHAPE || low_quality) {
                ctx.rect(0, -title_height, size[0] + 1, title_height);
            }
            else if (shape == exports.LiteGraph.ROUND_SHAPE || shape == exports.LiteGraph.CARD_SHAPE) {
                ctx.roundRect(0, -title_height, size[0] + 1, title_height, node.flags.collapsed ? [this.round_radius] : [this.round_radius, this.round_radius, 0, 0]);
            }
            ctx.fill();
            ctx.shadowColor = "transparent";
        }
        var colState = false;
        if (exports.LiteGraph.node_box_coloured_by_mode) {
            if (exports.LiteGraph.NODE_MODES_COLORS[node.mode]) {
                colState = exports.LiteGraph.NODE_MODES_COLORS[node.mode];
            }
        }
        if (exports.LiteGraph.node_box_coloured_when_on) {
            colState = node.action_triggered ? "#FFF" : (node.execute_triggered ? "#AAA" : colState);
        }
        //title box
        var box_size = 10;
        if (node.onDrawTitleBox) {
            node.onDrawTitleBox(ctx, title_height, size, this.ds.scale);
        }
        else if (shape == exports.LiteGraph.ROUND_SHAPE ||
            shape == exports.LiteGraph.CIRCLE_SHAPE ||
            shape == exports.LiteGraph.CARD_SHAPE) {
            if (low_quality) {
                ctx.fillStyle = "black";
                ctx.beginPath();
                ctx.arc(title_height * 0.5, title_height * -0.5, box_size * 0.5 + 1, 0, Math.PI * 2);
                ctx.fill();
            }
            ctx.fillStyle = node.boxcolor || colState || exports.LiteGraph.NODE_DEFAULT_BOXCOLOR;
            if (low_quality)
                ctx.fillRect(title_height * 0.5 - box_size * 0.5, title_height * -0.5 - box_size * 0.5, box_size, box_size);
            else {
                ctx.beginPath();
                ctx.arc(title_height * 0.5, title_height * -0.5, box_size * 0.5, 0, Math.PI * 2);
                ctx.fill();
            }
        }
        else {
            if (low_quality) {
                ctx.fillStyle = "black";
                ctx.fillRect((title_height - box_size) * 0.5 - 1, (title_height + box_size) * -0.5 - 1, box_size + 2, box_size + 2);
            }
            ctx.fillStyle = node.boxcolor || colState || exports.LiteGraph.NODE_DEFAULT_BOXCOLOR;
            ctx.fillRect((title_height - box_size) * 0.5, (title_height + box_size) * -0.5, box_size, box_size);
        }
        ctx.globalAlpha = old_alpha;
        //title text
        if (node.onDrawTitleText) {
            node.onDrawTitleText(ctx, title_height, size, this.ds.scale, this.title_text_font, selected);
        }
        if (!low_quality) {
            ctx.font = this.title_text_font;
            var title = String(node.getTitle());
            if (title) {
                if (selected) {
                    ctx.fillStyle = exports.LiteGraph.NODE_SELECTED_TITLE_COLOR;
                }
                else {
                    ctx.fillStyle =
                        node.constructor.title_text_color ||
                            this.node_title_color;
                }
                if (node.flags.collapsed) {
                    ctx.textAlign = "left";
                    var measure = ctx.measureText(title);
                    ctx.fillText(title.substr(0, 20), //avoid urls too long
                    title_height, // + measure.width * 0.5,
                    exports.LiteGraph.NODE_TITLE_TEXT_Y - title_height);
                    ctx.textAlign = "left";
                }
                else {
                    ctx.textAlign = "left";
                    ctx.fillText(title, title_height, exports.LiteGraph.NODE_TITLE_TEXT_Y - title_height);
                }
            }
        }
        //subgraph box
        if (!node.flags.collapsed && node.subgraph && !node.skip_subgraph_button) {
            var w = exports.LiteGraph.NODE_TITLE_HEIGHT;
            var x = node.size[0] - w;
            var over = exports.LiteGraph.isInsideRectangle(this.graph_mouse[0] - node.pos[0], this.graph_mouse[1] - node.pos[1], x + 2, -w + 2, w - 4, w - 4);
            ctx.fillStyle = over ? "#888" : "#555";
            if (shape == exports.LiteGraph.BOX_SHAPE || low_quality)
                ctx.fillRect(x + 2, -w + 2, w - 4, w - 4);
            else {
                ctx.beginPath();
                ctx.roundRect(x + 2, -w + 2, w - 4, w - 4, [4]);
                ctx.fill();
            }
            ctx.fillStyle = "#333";
            ctx.beginPath();
            ctx.moveTo(x + w * 0.2, -w * 0.6);
            ctx.lineTo(x + w * 0.8, -w * 0.6);
            ctx.lineTo(x + w * 0.5, -w * 0.3);
            ctx.fill();
        }
        //custom title render
        if (node.onDrawTitle) {
            node.onDrawTitle(ctx);
        }
    }
    //render selection marker
    if (selected) {
        if (node.onBounding) {
            node.onBounding(area);
        }
        if (title_mode == exports.LiteGraph.TRANSPARENT_TITLE) {
            area[1] -= title_height;
            area[3] += title_height;
        }
        ctx.lineWidth = 1;
        ctx.globalAlpha = 0.8;
        ctx.beginPath();
        if (shape == exports.LiteGraph.BOX_SHAPE) {
            ctx.rect(-6 + area[0], -6 + area[1], 12 + area[2], 12 + area[3]);
        }
        else if (shape == exports.LiteGraph.ROUND_SHAPE ||
            (shape == exports.LiteGraph.CARD_SHAPE && node.flags.collapsed)) {
            ctx.roundRect(-6 + area[0], -6 + area[1], 12 + area[2], 12 + area[3], [this.round_radius * 2]);
        }
        else if (shape == exports.LiteGraph.CARD_SHAPE) {
            ctx.roundRect(-6 + area[0], -6 + area[1], 12 + area[2], 12 + area[3], [this.round_radius * 2, 2, this.round_radius * 2, 2]);
        }
        else if (shape == exports.LiteGraph.CIRCLE_SHAPE) {
            ctx.arc(size[0] * 0.5, size[1] * 0.5, size[0] * 0.5 + 6, 0, Math.PI * 2);
        }
        ctx.strokeStyle = exports.LiteGraph.NODE_BOX_OUTLINE_COLOR;
        ctx.stroke();
        ctx.strokeStyle = fgcolor;
        ctx.globalAlpha = 1;
    }
    // these counter helps in conditioning drawing based on if the node has been executed or an action occurred
    if (node.execute_triggered > 0)
        node.execute_triggered--;
    if (node.action_triggered > 0)
        node.action_triggered--;
};
var margin_area = new Float32Array(4);
var link_bounding = new Float32Array(4);
var tempA = new Float32Array(2);
var tempB = new Float32Array(2);
/**
 * draws every connection visible in the canvas
 * OPTIMIZE THIS: pre-catch connections position instead of recomputing them every time
 * @method drawConnections
 **/
LGraphCanvas.prototype.drawConnections = function (ctx) {
    var now = exports.LiteGraph.getTime();
    var visible_area = this.visible_area;
    margin_area[0] = visible_area[0] - 20;
    margin_area[1] = visible_area[1] - 20;
    margin_area[2] = visible_area[2] + 40;
    margin_area[3] = visible_area[3] + 40;
    //draw connections
    ctx.lineWidth = this.connections_width;
    ctx.fillStyle = "#AAA";
    ctx.strokeStyle = "#AAA";
    ctx.globalAlpha = this.editor_alpha;
    //for every node
    var nodes = this.graph._nodes;
    for (var n = 0, l = nodes.length; n < l; ++n) {
        var node = nodes[n];
        //for every input (we render just inputs because it is easier as every slot can only have one input)
        if (!node.inputs || !node.inputs.length) {
            continue;
        }
        for (var i = 0; i < node.inputs.length; ++i) {
            var input = node.inputs[i];
            if (!input || input.link == null) {
                continue;
            }
            var link_id = input.link;
            var link = this.graph.links[link_id];
            if (!link) {
                continue;
            }
            //find link info
            var start_node = this.graph.getNodeById(link.origin_id);
            if (start_node == null) {
                continue;
            }
            var start_node_slot = link.origin_slot;
            var start_node_slotpos = null;
            if (start_node_slot == -1) {
                start_node_slotpos = [
                    start_node.pos[0] + 10,
                    start_node.pos[1] + 10
                ];
            }
            else {
                start_node_slotpos = start_node.getConnectionPos(false, start_node_slot, tempA);
            }
            var end_node_slotpos = node.getConnectionPos(true, i, tempB);
            //compute link bounding
            link_bounding[0] = start_node_slotpos[0];
            link_bounding[1] = start_node_slotpos[1];
            link_bounding[2] = end_node_slotpos[0] - start_node_slotpos[0];
            link_bounding[3] = end_node_slotpos[1] - start_node_slotpos[1];
            if (link_bounding[2] < 0) {
                link_bounding[0] += link_bounding[2];
                link_bounding[2] = Math.abs(link_bounding[2]);
            }
            if (link_bounding[3] < 0) {
                link_bounding[1] += link_bounding[3];
                link_bounding[3] = Math.abs(link_bounding[3]);
            }
            //skip links outside of the visible area of the canvas
            if (!overlapBounding(link_bounding, margin_area)) {
                continue;
            }
            var start_slot = start_node.outputs[start_node_slot];
            var end_slot = node.inputs[i];
            if (!start_slot || !end_slot) {
                continue;
            }
            var start_dir = start_slot.dir ||
                (start_node.horizontal ? exports.LiteGraph.DOWN : exports.LiteGraph.RIGHT);
            var end_dir = end_slot.dir ||
                (node.horizontal ? exports.LiteGraph.UP : exports.LiteGraph.LEFT);
            this.renderLink(ctx, start_node_slotpos, end_node_slotpos, link, false, 0, null, start_dir, end_dir);
            //event triggered rendered on top
            if (link && link._last_time && now - link._last_time < 1000) {
                var f = 2.0 - (now - link._last_time) * 0.002;
                var tmp = ctx.globalAlpha;
                ctx.globalAlpha = tmp * f;
                this.renderLink(ctx, start_node_slotpos, end_node_slotpos, link, true, f, "white", start_dir, end_dir);
                ctx.globalAlpha = tmp;
            }
        }
    }
    ctx.globalAlpha = 1;
};
/**
 * draws a link between two points
 * @method renderLink
 * @param {vec2} a start pos
 * @param {vec2} b end pos
 * @param {Object} link the link object with all the link info
 * @param {boolean} skip_border ignore the shadow of the link
 * @param {boolean} flow show flow animation (for events)
 * @param {string} color the color for the link
 * @param {number} start_dir the direction enum
 * @param {number} end_dir the direction enum
 * @param {number} num_sublines number of sublines (useful to represent vec3 or rgb)
 **/
LGraphCanvas.prototype.renderLink = function (ctx, a, b, link, skip_border, flow, color, start_dir, end_dir, num_sublines) {
    if (link) {
        this.visible_links.push(link);
    }
    //choose color
    if (!color && link) {
        color = link.color || LGraphCanvas.link_type_colors[link.type];
    }
    if (!color) {
        color = this.default_link_color;
    }
    if (link != null && this.highlighted_links[link.id]) {
        color = "#FFF";
    }
    start_dir = start_dir || exports.LiteGraph.RIGHT;
    end_dir = end_dir || exports.LiteGraph.LEFT;
    var dist = distance(a, b);
    if (this.render_connections_border && this.ds.scale > 0.6) {
        ctx.lineWidth = this.connections_width + 4;
    }
    ctx.lineJoin = "round";
    num_sublines = num_sublines || 1;
    if (num_sublines > 1) {
        ctx.lineWidth = 0.5;
    }
    //begin line shape
    ctx.beginPath();
    for (var i = 0; i < num_sublines; i += 1) {
        var offsety = (i - (num_sublines - 1) * 0.5) * 5;
        if (this.links_render_mode == exports.LiteGraph.SPLINE_LINK) {
            ctx.moveTo(a[0], a[1] + offsety);
            var start_offset_x = 0;
            var start_offset_y = 0;
            var end_offset_x = 0;
            var end_offset_y = 0;
            switch (start_dir) {
                case exports.LiteGraph.LEFT:
                    start_offset_x = dist * -0.25;
                    break;
                case exports.LiteGraph.RIGHT:
                    start_offset_x = dist * 0.25;
                    break;
                case exports.LiteGraph.UP:
                    start_offset_y = dist * -0.25;
                    break;
                case exports.LiteGraph.DOWN:
                    start_offset_y = dist * 0.25;
                    break;
            }
            switch (end_dir) {
                case exports.LiteGraph.LEFT:
                    end_offset_x = dist * -0.25;
                    break;
                case exports.LiteGraph.RIGHT:
                    end_offset_x = dist * 0.25;
                    break;
                case exports.LiteGraph.UP:
                    end_offset_y = dist * -0.25;
                    break;
                case exports.LiteGraph.DOWN:
                    end_offset_y = dist * 0.25;
                    break;
            }
            ctx.bezierCurveTo(a[0] + start_offset_x, a[1] + start_offset_y + offsety, b[0] + end_offset_x, b[1] + end_offset_y + offsety, b[0], b[1] + offsety);
        }
        else if (this.links_render_mode == exports.LiteGraph.LINEAR_LINK) {
            ctx.moveTo(a[0], a[1] + offsety);
            var start_offset_x = 0;
            var start_offset_y = 0;
            var end_offset_x = 0;
            var end_offset_y = 0;
            switch (start_dir) {
                case exports.LiteGraph.LEFT:
                    start_offset_x = -1;
                    break;
                case exports.LiteGraph.RIGHT:
                    start_offset_x = 1;
                    break;
                case exports.LiteGraph.UP:
                    start_offset_y = -1;
                    break;
                case exports.LiteGraph.DOWN:
                    start_offset_y = 1;
                    break;
            }
            switch (end_dir) {
                case exports.LiteGraph.LEFT:
                    end_offset_x = -1;
                    break;
                case exports.LiteGraph.RIGHT:
                    end_offset_x = 1;
                    break;
                case exports.LiteGraph.UP:
                    end_offset_y = -1;
                    break;
                case exports.LiteGraph.DOWN:
                    end_offset_y = 1;
                    break;
            }
            var l = 15;
            ctx.lineTo(a[0] + start_offset_x * l, a[1] + start_offset_y * l + offsety);
            ctx.lineTo(b[0] + end_offset_x * l, b[1] + end_offset_y * l + offsety);
            ctx.lineTo(b[0], b[1] + offsety);
        }
        else if (this.links_render_mode == exports.LiteGraph.STRAIGHT_LINK) {
            ctx.moveTo(a[0], a[1]);
            var start_x = a[0];
            var start_y = a[1];
            var end_x = b[0];
            var end_y = b[1];
            if (start_dir == exports.LiteGraph.RIGHT) {
                start_x += 10;
            }
            else {
                start_y += 10;
            }
            if (end_dir == exports.LiteGraph.LEFT) {
                end_x -= 10;
            }
            else {
                end_y -= 10;
            }
            ctx.lineTo(start_x, start_y);
            ctx.lineTo((start_x + end_x) * 0.5, start_y);
            ctx.lineTo((start_x + end_x) * 0.5, end_y);
            ctx.lineTo(end_x, end_y);
            ctx.lineTo(b[0], b[1]);
        }
        else {
            return;
        } //unknown
    }
    //rendering the outline of the connection can be a little bit slow
    if (this.render_connections_border &&
        this.ds.scale > 0.6 &&
        !skip_border) {
        ctx.strokeStyle = "rgba(0,0,0,0.5)";
        ctx.stroke();
    }
    ctx.lineWidth = this.connections_width;
    ctx.fillStyle = ctx.strokeStyle = color;
    ctx.stroke();
    //end line shape
    var pos = this.computeConnectionPoint(a, b, 0.5, start_dir, end_dir);
    if (link && link._pos) {
        link._pos[0] = pos[0];
        link._pos[1] = pos[1];
    }
    //render arrow in the middle
    if (this.ds.scale >= 0.6 &&
        this.highquality_render &&
        end_dir != exports.LiteGraph.CENTER) {
        //render arrow
        if (this.render_connection_arrows) {
            //compute two points in the connection
            var posA = this.computeConnectionPoint(a, b, 0.25, start_dir, end_dir);
            var posB = this.computeConnectionPoint(a, b, 0.26, start_dir, end_dir);
            var posC = this.computeConnectionPoint(a, b, 0.75, start_dir, end_dir);
            var posD = this.computeConnectionPoint(a, b, 0.76, start_dir, end_dir);
            //compute the angle between them so the arrow points in the right direction
            var angleA = 0;
            var angleB = 0;
            if (this.render_curved_connections) {
                angleA = -Math.atan2(posB[0] - posA[0], posB[1] - posA[1]);
                angleB = -Math.atan2(posD[0] - posC[0], posD[1] - posC[1]);
            }
            else {
                angleB = angleA = b[1] > a[1] ? 0 : Math.PI;
            }
            //render arrow
            ctx.save();
            ctx.translate(posA[0], posA[1]);
            ctx.rotate(angleA);
            ctx.beginPath();
            ctx.moveTo(-5, -3);
            ctx.lineTo(0, +7);
            ctx.lineTo(+5, -3);
            ctx.fill();
            ctx.restore();
            ctx.save();
            ctx.translate(posC[0], posC[1]);
            ctx.rotate(angleB);
            ctx.beginPath();
            ctx.moveTo(-5, -3);
            ctx.lineTo(0, +7);
            ctx.lineTo(+5, -3);
            ctx.fill();
            ctx.restore();
        }
        //circle
        ctx.beginPath();
        ctx.arc(pos[0], pos[1], 5, 0, Math.PI * 2);
        ctx.fill();
    }
    //render flowing points
    if (flow) {
        ctx.fillStyle = color;
        for (var i = 0; i < 5; ++i) {
            var f = (exports.LiteGraph.getTime() * 0.001 + i * 0.2) % 1;
            var pos = this.computeConnectionPoint(a, b, f, start_dir, end_dir);
            ctx.beginPath();
            ctx.arc(pos[0], pos[1], 5, 0, 2 * Math.PI);
            ctx.fill();
        }
    }
};
//returns the link center point based on curvature
LGraphCanvas.prototype.computeConnectionPoint = function (a, b, t, start_dir, end_dir) {
    start_dir = start_dir || exports.LiteGraph.RIGHT;
    end_dir = end_dir || exports.LiteGraph.LEFT;
    var dist = distance(a, b);
    var p0 = a;
    var p1 = [a[0], a[1]];
    var p2 = [b[0], b[1]];
    var p3 = b;
    switch (start_dir) {
        case exports.LiteGraph.LEFT:
            p1[0] += dist * -0.25;
            break;
        case exports.LiteGraph.RIGHT:
            p1[0] += dist * 0.25;
            break;
        case exports.LiteGraph.UP:
            p1[1] += dist * -0.25;
            break;
        case exports.LiteGraph.DOWN:
            p1[1] += dist * 0.25;
            break;
    }
    switch (end_dir) {
        case exports.LiteGraph.LEFT:
            p2[0] += dist * -0.25;
            break;
        case exports.LiteGraph.RIGHT:
            p2[0] += dist * 0.25;
            break;
        case exports.LiteGraph.UP:
            p2[1] += dist * -0.25;
            break;
        case exports.LiteGraph.DOWN:
            p2[1] += dist * 0.25;
            break;
    }
    var c1 = (1 - t) * (1 - t) * (1 - t);
    var c2 = 3 * ((1 - t) * (1 - t)) * t;
    var c3 = 3 * (1 - t) * (t * t);
    var c4 = t * t * t;
    var x = c1 * p0[0] + c2 * p1[0] + c3 * p2[0] + c4 * p3[0];
    var y = c1 * p0[1] + c2 * p1[1] + c3 * p2[1] + c4 * p3[1];
    return [x, y];
};
LGraphCanvas.prototype.drawExecutionOrder = function (ctx) {
    ctx.shadowColor = "transparent";
    ctx.globalAlpha = 0.25;
    ctx.textAlign = "center";
    ctx.strokeStyle = "white";
    ctx.globalAlpha = 0.75;
    var visible_nodes = this.visible_nodes;
    for (var i = 0; i < visible_nodes.length; ++i) {
        var node = visible_nodes[i];
        ctx.fillStyle = "black";
        ctx.fillRect(node.pos[0] - exports.LiteGraph.NODE_TITLE_HEIGHT, node.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT, exports.LiteGraph.NODE_TITLE_HEIGHT, exports.LiteGraph.NODE_TITLE_HEIGHT);
        if (node.order == 0) {
            ctx.strokeRect(node.pos[0] - exports.LiteGraph.NODE_TITLE_HEIGHT + 0.5, node.pos[1] - exports.LiteGraph.NODE_TITLE_HEIGHT + 0.5, exports.LiteGraph.NODE_TITLE_HEIGHT, exports.LiteGraph.NODE_TITLE_HEIGHT);
        }
        ctx.fillStyle = "#FFF";
        ctx.fillText(node.order, node.pos[0] + exports.LiteGraph.NODE_TITLE_HEIGHT * -0.5, node.pos[1] - 6);
    }
    ctx.globalAlpha = 1;
};
/**
 * draws the widgets stored inside a node
 * @method drawNodeWidgets
 **/
LGraphCanvas.prototype.drawNodeWidgets = function (node, posY, ctx, active_widget) {
    if (!node.widgets || !node.widgets.length) {
        return 0;
    }
    var width = node.size[0];
    var widgets = node.widgets;
    posY += 2;
    var H = exports.LiteGraph.NODE_WIDGET_HEIGHT;
    var show_text = this.ds.scale > 0.5;
    ctx.save();
    ctx.globalAlpha = this.editor_alpha;
    var outline_color = exports.LiteGraph.WIDGET_OUTLINE_COLOR;
    var background_color = exports.LiteGraph.WIDGET_BGCOLOR;
    var text_color = exports.LiteGraph.WIDGET_TEXT_COLOR;
    var secondary_text_color = exports.LiteGraph.WIDGET_SECONDARY_TEXT_COLOR;
    var margin = 15;
    for (var i = 0; i < widgets.length; ++i) {
        var w = widgets[i];
        var y = posY;
        if (w.y) {
            y = w.y;
        }
        w.last_y = y;
        ctx.strokeStyle = outline_color;
        ctx.fillStyle = "#222";
        ctx.textAlign = "left";
        //ctx.lineWidth = 2;
        if (w.disabled)
            ctx.globalAlpha *= 0.5;
        var widget_width = w.width || width;
        switch (w.type) {
            case "button":
                if (w.clicked) {
                    ctx.fillStyle = "#AAA";
                    w.clicked = false;
                    this.dirty_canvas = true;
                }
                ctx.fillRect(margin, y, widget_width - margin * 2, H);
                if (show_text && !w.disabled)
                    ctx.strokeRect(margin, y, widget_width - margin * 2, H);
                if (show_text) {
                    ctx.textAlign = "center";
                    ctx.fillStyle = text_color;
                    ctx.fillText(w.label || w.name, widget_width * 0.5, y + H * 0.7);
                }
                break;
            case "toggle":
                ctx.textAlign = "left";
                ctx.strokeStyle = outline_color;
                ctx.fillStyle = background_color;
                ctx.beginPath();
                if (show_text)
                    ctx.roundRect(margin, y, widget_width - margin * 2, H, [H * 0.5]);
                else
                    ctx.rect(margin, y, widget_width - margin * 2, H);
                ctx.fill();
                if (show_text && !w.disabled)
                    ctx.stroke();
                ctx.fillStyle = w.value ? "#89A" : "#333";
                ctx.beginPath();
                ctx.arc(widget_width - margin * 2, y + H * 0.5, H * 0.36, 0, Math.PI * 2);
                ctx.fill();
                if (show_text) {
                    ctx.fillStyle = secondary_text_color;
                    var label = w.label || w.name;
                    if (label != null) {
                        ctx.fillText(label, margin * 2, y + H * 0.7);
                    }
                    ctx.fillStyle = w.value ? text_color : secondary_text_color;
                    ctx.textAlign = "right";
                    ctx.fillText(w.value
                        ? w.options.on || "true"
                        : w.options.off || "false", widget_width - 40, y + H * 0.7);
                }
                break;
            case "slider":
                ctx.fillStyle = background_color;
                ctx.fillRect(margin, y, widget_width - margin * 2, H);
                var range = w.options.max - w.options.min;
                var nvalue = (w.value - w.options.min) / range;
                if (nvalue < 0.0)
                    nvalue = 0.0;
                if (nvalue > 1.0)
                    nvalue = 1.0;
                ctx.fillStyle = w.options.hasOwnProperty("slider_color") ? w.options.slider_color : (active_widget == w ? "#89A" : "#678");
                ctx.fillRect(margin, y, nvalue * (widget_width - margin * 2), H);
                if (show_text && !w.disabled)
                    ctx.strokeRect(margin, y, widget_width - margin * 2, H);
                if (w.marker) {
                    var marker_nvalue = (w.marker - w.options.min) / range;
                    if (marker_nvalue < 0.0)
                        marker_nvalue = 0.0;
                    if (marker_nvalue > 1.0)
                        marker_nvalue = 1.0;
                    ctx.fillStyle = w.options.hasOwnProperty("marker_color") ? w.options.marker_color : "#AA9";
                    ctx.fillRect(margin + marker_nvalue * (widget_width - margin * 2), y, 2, H);
                }
                if (show_text) {
                    ctx.textAlign = "center";
                    ctx.fillStyle = text_color;
                    ctx.fillText(w.label || w.name + "  " + Number(w.value).toFixed(w.options.precision != null
                        ? w.options.precision
                        : 3), widget_width * 0.5, y + H * 0.7);
                }
                break;
            case "number":
            case "combo":
                ctx.textAlign = "left";
                ctx.strokeStyle = outline_color;
                ctx.fillStyle = background_color;
                ctx.beginPath();
                if (show_text)
                    ctx.roundRect(margin, y, widget_width - margin * 2, H, [H * 0.5]);
                else
                    ctx.rect(margin, y, widget_width - margin * 2, H);
                ctx.fill();
                if (show_text) {
                    if (!w.disabled)
                        ctx.stroke();
                    ctx.fillStyle = text_color;
                    if (!w.disabled) {
                        ctx.beginPath();
                        ctx.moveTo(margin + 16, y + 5);
                        ctx.lineTo(margin + 6, y + H * 0.5);
                        ctx.lineTo(margin + 16, y + H - 5);
                        ctx.fill();
                        ctx.beginPath();
                        ctx.moveTo(widget_width - margin - 16, y + 5);
                        ctx.lineTo(widget_width - margin - 6, y + H * 0.5);
                        ctx.lineTo(widget_width - margin - 16, y + H - 5);
                        ctx.fill();
                    }
                    ctx.fillStyle = secondary_text_color;
                    ctx.fillText(w.label || w.name, margin * 2 + 5, y + H * 0.7);
                    ctx.fillStyle = text_color;
                    ctx.textAlign = "right";
                    if (w.type == "number") {
                        ctx.fillText(Number(w.value).toFixed(w.options.precision !== undefined
                            ? w.options.precision
                            : 3), widget_width - margin * 2 - 20, y + H * 0.7);
                    }
                    else {
                        var v = w.value;
                        if (w.options.values) {
                            var values = w.options.values;
                            if (values.constructor === Function)
                                values = values();
                            if (values && values.constructor !== Array)
                                v = values[w.value];
                        }
                        ctx.fillText(v, widget_width - margin * 2 - 20, y + H * 0.7);
                    }
                }
                break;
            case "string":
            case "text":
                ctx.textAlign = "left";
                ctx.strokeStyle = outline_color;
                ctx.fillStyle = background_color;
                ctx.beginPath();
                if (show_text)
                    ctx.roundRect(margin, y, widget_width - margin * 2, H, [H * 0.5]);
                else
                    ctx.rect(margin, y, widget_width - margin * 2, H);
                ctx.fill();
                if (show_text) {
                    if (!w.disabled)
                        ctx.stroke();
                    ctx.save();
                    ctx.beginPath();
                    ctx.rect(margin, y, widget_width - margin * 2, H);
                    ctx.clip();
                    //ctx.stroke();
                    ctx.fillStyle = secondary_text_color;
                    var label = w.label || w.name;
                    if (label != null) {
                        ctx.fillText(label, margin * 2, y + H * 0.7);
                    }
                    ctx.fillStyle = text_color;
                    ctx.textAlign = "right";
                    ctx.fillText(String(w.value).substr(0, 30), widget_width - margin * 2, y + H * 0.7); //30 chars max
                    ctx.restore();
                }
                break;
            default:
                if (w.draw) {
                    w.draw(ctx, node, widget_width, y, H);
                }
                break;
        }
        posY += (w.computeSize ? w.computeSize(widget_width)[1] : H) + 4;
        ctx.globalAlpha = this.editor_alpha;
    }
    ctx.restore();
    ctx.textAlign = "left";
};
/**
 * process an event on widgets
 * @method processNodeWidgets
 **/
LGraphCanvas.prototype.processNodeWidgets = function (node, pos, event, active_widget) {
    if (!node.widgets || !node.widgets.length || (!this.allow_interaction && !node.flags.allow_interaction)) {
        return null;
    }
    var x = pos[0] - node.pos[0];
    var y = pos[1] - node.pos[1];
    var width = node.size[0];
    var deltaX = event.deltaX || event.deltax || 0;
    var that = this;
    var ref_window = this.getCanvasWindow();
    for (var i = 0; i < node.widgets.length; ++i) {
        var w = node.widgets[i];
        if (!w || w.disabled)
            continue;
        var widget_height = w.computeSize ? w.computeSize(width)[1] : exports.LiteGraph.NODE_WIDGET_HEIGHT;
        var widget_width = w.width || width;
        //outside
        if (w != active_widget &&
            (x < 6 || x > widget_width - 12 || y < w.last_y || y > w.last_y + widget_height || w.last_y === undefined))
            continue;
        var old_value = w.value;
        //if ( w == active_widget || (x > 6 && x < widget_width - 12 && y > w.last_y && y < w.last_y + widget_height) ) {
        //inside widget
        switch (w.type) {
            case "button":
                if (event.type === exports.LiteGraph.pointerevents_method + "down") {
                    if (w.callback) {
                        setTimeout(function () {
                            w.callback(w, that, node, pos, event);
                        }, 20);
                    }
                    w.clicked = true;
                    this.dirty_canvas = true;
                }
                break;
            case "slider":
                var old_value = w.value;
                var nvalue = clamp((x - 15) / (widget_width - 30), 0, 1);
                if (w.options.read_only)
                    break;
                w.value = w.options.min + (w.options.max - w.options.min) * nvalue;
                if (old_value != w.value) {
                    setTimeout(function () {
                        inner_value_change(w, w.value);
                    }, 20);
                }
                this.dirty_canvas = true;
                break;
            case "number":
            case "combo":
                var old_value = w.value;
                if (event.type == exports.LiteGraph.pointerevents_method + "move" && w.type == "number") {
                    if (deltaX)
                        w.value += deltaX * 0.1 * (w.options.step || 1);
                    if (w.options.min != null && w.value < w.options.min) {
                        w.value = w.options.min;
                    }
                    if (w.options.max != null && w.value > w.options.max) {
                        w.value = w.options.max;
                    }
                }
                else if (event.type == exports.LiteGraph.pointerevents_method + "down") {
                    var values = w.options.values;
                    if (values && values.constructor === Function) {
                        values = w.options.values(w, node);
                    }
                    var values_list = null;
                    if (w.type != "number")
                        values_list = values.constructor === Array ? values : Object.keys(values);
                    var delta = x < 40 ? -1 : x > widget_width - 40 ? 1 : 0;
                    if (w.type == "number") {
                        w.value += delta * 0.1 * (w.options.step || 1);
                        if (w.options.min != null && w.value < w.options.min) {
                            w.value = w.options.min;
                        }
                        if (w.options.max != null && w.value > w.options.max) {
                            w.value = w.options.max;
                        }
                    }
                    else if (delta) { //clicked in arrow, used for combos 
                        var index = -1;
                        this.last_mouseclick = 0; //avoids dobl click event
                        if (values.constructor === Object)
                            index = values_list.indexOf(String(w.value)) + delta;
                        else
                            index = values_list.indexOf(w.value) + delta;
                        if (index >= values_list.length) {
                            index = values_list.length - 1;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        if (values.constructor === Array)
                            w.value = values[index];
                        else
                            w.value = index;
                    }
                    else { //combo clicked 
                        var text_values = values != values_list ? Object.values(values) : values;
                        var menu = new exports.LiteGraph.ContextMenu(text_values, {
                            scale: Math.max(1, this.ds.scale),
                            event: event,
                            className: "dark",
                            callback: inner_clicked.bind(w)
                        }, ref_window);
                        function inner_clicked(v, option, event) {
                            if (values != values_list)
                                v = text_values.indexOf(v);
                            this.value = v;
                            inner_value_change(this, v);
                            that.dirty_canvas = true;
                            return false;
                        }
                    }
                } //end mousedown
                else if (event.type == exports.LiteGraph.pointerevents_method + "up" && w.type == "number") {
                    var delta = x < 40 ? -1 : x > widget_width - 40 ? 1 : 0;
                    if (event.click_time < 200 && delta == 0) {
                        this.prompt("Value", w.value, function (v) {
                            // check if v is a valid equation or a number
                            if (/^[0-9+\-*/()\s]+|\d+\.\d+$/.test(v)) {
                                try { //solve the equation if possible
                                    v = eval(v);
                                }
                                catch (e) { }
                            }
                            this.value = Number(v);
                            inner_value_change(this, this.value);
                        }.bind(w), event);
                    }
                }
                if (old_value != w.value)
                    setTimeout(function () {
                        inner_value_change(this, this.value);
                    }.bind(w), 20);
                this.dirty_canvas = true;
                break;
            case "toggle":
                if (event.type == exports.LiteGraph.pointerevents_method + "down") {
                    w.value = !w.value;
                    setTimeout(function () {
                        inner_value_change(w, w.value);
                    }, 20);
                }
                break;
            case "string":
            case "text":
                if (event.type == exports.LiteGraph.pointerevents_method + "down") {
                    this.prompt("Value", w.value, function (v) {
                        inner_value_change(this, v);
                    }.bind(w), event, w.options ? w.options.multiline : false);
                }
                break;
            default:
                if (w.mouse) {
                    this.dirty_canvas = w.mouse(event, [x, y], node);
                }
                break;
        } //end switch
        //value changed
        if (old_value != w.value) {
            if (node.onWidgetChanged)
                node.onWidgetChanged(w.name, w.value, old_value, w);
            node.graph._version++;
        }
        return w;
    } //end for
    function inner_value_change(widget, value) {
        if (widget.type == "number") {
            value = Number(value);
        }
        widget.value = value;
        if (widget.options && widget.options.property && node.properties[widget.options.property] !== undefined) {
            node.setProperty(widget.options.property, value);
        }
        if (widget.callback) {
            widget.callback(widget.value, that, node, pos, event);
        }
    }
    return null;
};
/**
 * draws every group area in the background
 * @method drawGroups
 **/
LGraphCanvas.prototype.drawGroups = function (canvas, ctx) {
    if (!this.graph) {
        return;
    }
    var groups = this.graph._groups;
    ctx.save();
    ctx.globalAlpha = 0.5 * this.editor_alpha;
    for (var i = 0; i < groups.length; ++i) {
        var group = groups[i];
        if (!overlapBounding(this.visible_area, group._bounding)) {
            continue;
        } //out of the visible area
        ctx.fillStyle = group.color || "#335";
        ctx.strokeStyle = group.color || "#335";
        var pos = group._pos;
        var size = group._size;
        ctx.globalAlpha = 0.25 * this.editor_alpha;
        ctx.beginPath();
        ctx.rect(pos[0] + 0.5, pos[1] + 0.5, size[0], size[1]);
        ctx.fill();
        ctx.globalAlpha = this.editor_alpha;
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(pos[0] + size[0], pos[1] + size[1]);
        ctx.lineTo(pos[0] + size[0] - 10, pos[1] + size[1]);
        ctx.lineTo(pos[0] + size[0], pos[1] + size[1] - 10);
        ctx.fill();
        var font_size = group.font_size || exports.LiteGraph.DEFAULT_GROUP_FONT_SIZE;
        ctx.font = font_size + "px Arial";
        ctx.textAlign = "left";
        ctx.fillText(group.title, pos[0] + 4, pos[1] + font_size);
    }
    ctx.restore();
};
LGraphCanvas.prototype.adjustNodesSize = function () {
    var nodes = this.graph._nodes;
    for (var i = 0; i < nodes.length; ++i) {
        nodes[i].size = nodes[i].computeSize();
    }
    this.setDirty(true, true);
};
/**
 * resizes the canvas to a given size, if no size is passed, then it tries to fill the parentNode
 * @method resize
 **/
LGraphCanvas.prototype.resize = function (width, height) {
    if (!width && !height) {
        var parent = this.canvas.parentNode;
        width = parent.offsetWidth;
        height = parent.offsetHeight;
    }
    if (this.canvas.width == width && this.canvas.height == height) {
        return;
    }
    this.canvas.width = width;
    this.canvas.height = height;
    this.bgcanvas.width = this.canvas.width;
    this.bgcanvas.height = this.canvas.height;
    this.setDirty(true, true);
};
/**
 * switches to live mode (node shapes are not rendered, only the content)
 * this feature was designed when graphs where meant to create user interfaces
 * @method switchLiveMode
 **/
LGraphCanvas.prototype.switchLiveMode = function (transition) {
    if (!transition) {
        this.live_mode = !this.live_mode;
        this.dirty_canvas = true;
        this.dirty_bgcanvas = true;
        return;
    }
    var self = this;
    var delta = this.live_mode ? 1.1 : 0.9;
    if (this.live_mode) {
        this.live_mode = false;
        this.editor_alpha = 0.1;
    }
    var t = setInterval(function () {
        self.editor_alpha *= delta;
        self.dirty_canvas = true;
        self.dirty_bgcanvas = true;
        if (delta < 1 && self.editor_alpha < 0.01) {
            clearInterval(t);
            if (delta < 1) {
                self.live_mode = true;
            }
        }
        if (delta > 1 && self.editor_alpha > 0.99) {
            clearInterval(t);
            self.editor_alpha = 1;
        }
    }, 1);
};
LGraphCanvas.prototype.onNodeSelectionChange = function (node) {
    return; //disabled
};
/* this is an implementation for touch not in production and not ready
 */
/*LGraphCanvas.prototype.touchHandler = function(event) {
    //alert("foo");
    var touches = event.changedTouches,
        first = touches[0],
        type = "";

    switch (event.type) {
        case "touchstart":
            type = "mousedown";
            break;
        case "touchmove":
            type = "mousemove";
            break;
        case "touchend":
            type = "mouseup";
            break;
        default:
            return;
    }

    //initMouseEvent(type, canBubble, cancelable, view, clickCount,
    //           screenX, screenY, clientX, clientY, ctrlKey,
    //           altKey, shiftKey, metaKey, button, relatedTarget);

    // this is eventually a Dom object, get the LGraphCanvas back
    if(typeof this.getCanvasWindow == "undefined"){
        var window = this.lgraphcanvas.getCanvasWindow();
    }else{
        var window = this.getCanvasWindow();
    }
    
    var document = window.document;

    var simulatedEvent = document.createEvent("MouseEvent");
    simulatedEvent.initMouseEvent(
        type,
        true,
        true,
        window,
        1,
        first.screenX,
        first.screenY,
        first.clientX,
        first.clientY,
        false,
        false,
        false,
        false,
        0, //left
        null
    );
    first.target.dispatchEvent(simulatedEvent);
    event.preventDefault();
};*/
/* CONTEXT MENU ********************/
LGraphCanvas.onGroupAdd = function (info, entry, mouse_event) {
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var group = new exports.LiteGraph.LGraphGroup();
    group.pos = canvas.convertEventToCanvasOffset(mouse_event);
    canvas.graph.add(group);
};
/**
 * Determines the furthest nodes in each direction
 * @param nodes {LGraphNode[]} the nodes to from which boundary nodes will be extracted
 * @return {{left: LGraphNode, top: LGraphNode, right: LGraphNode, bottom: LGraphNode}}
 */
LGraphCanvas.getBoundaryNodes = function (nodes) {
    var top = null;
    var right = null;
    var bottom = null;
    var left = null;
    for (var nID in nodes) {
        var node = nodes[nID];
        var _a = node.pos, x = _a[0], y = _a[1];
        var _b = node.size, width = _b[0], height = _b[1];
        if (top === null || y < top.pos[1]) {
            top = node;
        }
        if (right === null || x + width > right.pos[0] + right.size[0]) {
            right = node;
        }
        if (bottom === null || y + height > bottom.pos[1] + bottom.size[1]) {
            bottom = node;
        }
        if (left === null || x < left.pos[0]) {
            left = node;
        }
    }
    return {
        "top": top,
        "right": right,
        "bottom": bottom,
        "left": left
    };
};
/**
 * Determines the furthest nodes in each direction for the currently selected nodes
 * @return {{left: LGraphNode, top: LGraphNode, right: LGraphNode, bottom: LGraphNode}}
 */
LGraphCanvas.prototype.boundaryNodesForSelection = function () {
    return LGraphCanvas.getBoundaryNodes(Object.values(this.selected_nodes));
};
/**
 *
 * @param {LGraphNode[]} nodes a list of nodes
 * @param {"top"|"bottom"|"left"|"right"} direction Direction to align the nodes
 * @param {LGraphNode?} align_to Node to align to (if null, align to the furthest node in the given direction)
 */
LGraphCanvas.alignNodes = function (nodes, direction, align_to) {
    if (!nodes) {
        return;
    }
    var canvas = LGraphCanvas.active_canvas;
    var boundaryNodes = [];
    if (align_to === undefined) {
        boundaryNodes = LGraphCanvas.getBoundaryNodes(nodes);
    }
    else {
        boundaryNodes = {
            "top": align_to,
            "right": align_to,
            "bottom": align_to,
            "left": align_to
        };
    }
    for (var _i = 0, _a = Object.entries(canvas.selected_nodes); _i < _a.length; _i++) {
        var _b = _a[_i], _ = _b[0], node = _b[1];
        switch (direction) {
            case "right":
                node.pos[0] = boundaryNodes["right"].pos[0] + boundaryNodes["right"].size[0] - node.size[0];
                break;
            case "left":
                node.pos[0] = boundaryNodes["left"].pos[0];
                break;
            case "top":
                node.pos[1] = boundaryNodes["top"].pos[1];
                break;
            case "bottom":
                node.pos[1] = boundaryNodes["bottom"].pos[1] + boundaryNodes["bottom"].size[1] - node.size[1];
                break;
        }
    }
    canvas.dirty_canvas = true;
    canvas.dirty_bgcanvas = true;
};
LGraphCanvas.onNodeAlign = function (value, options, event, prev_menu, node) {
    new exports.LiteGraph.ContextMenu(["Top", "Bottom", "Left", "Right"], {
        event: event,
        callback: inner_clicked,
        parentMenu: prev_menu,
    });
    function inner_clicked(value) {
        LGraphCanvas.alignNodes(LGraphCanvas.active_canvas.selected_nodes, value.toLowerCase(), node);
    }
};
LGraphCanvas.onGroupAlign = function (value, options, event, prev_menu) {
    new exports.LiteGraph.ContextMenu(["Top", "Bottom", "Left", "Right"], {
        event: event,
        callback: inner_clicked,
        parentMenu: prev_menu,
    });
    function inner_clicked(value) {
        LGraphCanvas.alignNodes(LGraphCanvas.active_canvas.selected_nodes, value.toLowerCase());
    }
};
LGraphCanvas.onMenuAdd = function (node, options, e, prev_menu, callback) {
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var graph = canvas.graph;
    if (!graph)
        return;
    function inner_onMenuAdded(base_category, prev_menu) {
        var categories = exports.LiteGraph.getNodeTypesCategories(canvas.filter || graph.filter).filter(function (category) { return category.startsWith(base_category); });
        var entries = [];
        categories.map(function (category) {
            if (!category)
                return;
            var base_category_regex = new RegExp('^(' + base_category + ')');
            var category_name = category.replace(base_category_regex, "").split('/')[0];
            var category_path = base_category === '' ? category_name + '/' : base_category + category_name + '/';
            var name = category_name;
            if (name.indexOf("::") != -1) //in case it has a namespace like "shader::math/rand" it hides the namespace
                name = name.split("::")[1];
            var index = entries.findIndex(function (entry) { return entry.value === category_path; });
            if (index === -1) {
                entries.push({ value: category_path, content: name, has_submenu: true, callback: function (value, event, mouseEvent, contextMenu) {
                        inner_onMenuAdded(value.value, contextMenu);
                    } });
            }
        });
        var nodes = exports.LiteGraph.getNodeTypesInCategory(base_category.slice(0, -1), canvas.filter || graph.filter);
        nodes.map(function (node) {
            if (node.skip_list)
                return;
            var entry = { value: node.type, content: node.title, has_submenu: false, callback: function (value, event, mouseEvent, contextMenu) {
                    var first_event = contextMenu.getFirstEvent();
                    canvas.graph.beforeChange();
                    var node = exports.LiteGraph.createNode(value.value);
                    if (node) {
                        node.pos = canvas.convertEventToCanvasOffset(first_event);
                        canvas.graph.add(node);
                    }
                    if (callback)
                        callback(node);
                    canvas.graph.afterChange();
                }
            };
            entries.push(entry);
        });
        new exports.LiteGraph.ContextMenu(entries, { event: e, parentMenu: prev_menu }, ref_window);
    }
    inner_onMenuAdded('', prev_menu);
    return false;
};
LGraphCanvas.onMenuCollapseAll = function () { };
LGraphCanvas.onMenuNodeEdit = function () { };
LGraphCanvas.showMenuNodeOptionalInputs = function (v, options, e, prev_menu, node) {
    if (!node) {
        return;
    }
    var that = this;
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var options = node.optional_inputs;
    if (node.onGetInputs) {
        options = node.onGetInputs();
    }
    var entries = [];
    if (options) {
        for (var i = 0; i < options.length; i++) {
            var entry = options[i];
            if (!entry) {
                entries.push(null);
                continue;
            }
            var label = entry[0];
            if (!entry[2])
                entry[2] = {};
            if (entry[2].label) {
                label = entry[2].label;
            }
            entry[2].removable = true;
            var data = { content: label, value: entry };
            if (entry[1] == exports.LiteGraph.ACTION) {
                data.className = "event";
            }
            entries.push(data);
        }
    }
    if (node.onMenuNodeInputs) {
        var retEntries = node.onMenuNodeInputs(entries);
        if (retEntries)
            entries = retEntries;
    }
    if (!entries.length) {
        console.log("no input entries");
        return;
    }
    var menu = new exports.LiteGraph.ContextMenu(entries, {
        event: e,
        callback: inner_clicked,
        parentMenu: prev_menu,
        node: node
    }, ref_window);
    function inner_clicked(v, e, prev) {
        if (!node) {
            return;
        }
        if (v.callback) {
            v.callback.call(that, node, v, e, prev);
        }
        if (v.value) {
            node.graph.beforeChange();
            node.addInput(v.value[0], v.value[1], v.value[2]);
            if (node.onNodeInputAdd) { // callback to the node when adding a slot
                node.onNodeInputAdd(v.value);
            }
            node.setDirtyCanvas(true, true);
            node.graph.afterChange();
        }
    }
    return false;
};
LGraphCanvas.showMenuNodeOptionalOutputs = function (v, options, e, prev_menu, node) {
    if (!node) {
        return;
    }
    var that = this;
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var options = node.optional_outputs;
    if (node.onGetOutputs) {
        options = node.onGetOutputs();
    }
    var entries = [];
    if (options) {
        for (var i = 0; i < options.length; i++) {
            var entry = options[i];
            if (!entry) {
                //separator?
                entries.push(null);
                continue;
            }
            if (node.flags &&
                node.flags.skip_repeated_outputs &&
                node.findOutputSlot(entry[0]) != -1) {
                continue;
            } //skip the ones already on
            var label = entry[0];
            if (!entry[2])
                entry[2] = {};
            if (entry[2].label) {
                label = entry[2].label;
            }
            entry[2].removable = true;
            var data = { content: label, value: entry };
            if (entry[1] == exports.LiteGraph.EVENT) {
                data.className = "event";
            }
            entries.push(data);
        }
    }
    if (this.onMenuNodeOutputs) {
        entries = this.onMenuNodeOutputs(entries);
    }
    if (exports.LiteGraph.do_add_triggers_slots) { //canvas.allow_addOutSlot_onExecuted
        if (node.findOutputSlot("onExecuted") == -1) {
            entries.push({ content: "On Executed", value: ["onExecuted", exports.LiteGraph.EVENT, { nameLocked: true }], className: "event" }); //, opts: {}
        }
    }
    // add callback for modifing the menu elements onMenuNodeOutputs
    if (node.onMenuNodeOutputs) {
        var retEntries = node.onMenuNodeOutputs(entries);
        if (retEntries)
            entries = retEntries;
    }
    if (!entries.length) {
        return;
    }
    var menu = new exports.LiteGraph.ContextMenu(entries, {
        event: e,
        callback: inner_clicked,
        parentMenu: prev_menu,
        node: node
    }, ref_window);
    function inner_clicked(v, e, prev) {
        if (!node) {
            return;
        }
        if (v.callback) {
            v.callback.call(that, node, v, e, prev);
        }
        if (!v.value) {
            return;
        }
        var value = v.value[1];
        if (value &&
            (value.constructor === Object || value.constructor === Array)) {
            //submenu why?
            var entries = [];
            for (var i in value) {
                entries.push({ content: i, value: value[i] });
            }
            new exports.LiteGraph.ContextMenu(entries, {
                event: e,
                callback: inner_clicked,
                parentMenu: prev_menu,
                node: node
            });
            return false;
        }
        else {
            node.graph.beforeChange();
            node.addOutput(v.value[0], v.value[1], v.value[2]);
            if (node.onNodeOutputAdd) { // a callback to the node when adding a slot
                node.onNodeOutputAdd(v.value);
            }
            node.setDirtyCanvas(true, true);
            node.graph.afterChange();
        }
    }
    return false;
};
LGraphCanvas.onShowMenuNodeProperties = function (value, options, e, prev_menu, node) {
    if (!node || !node.properties) {
        return;
    }
    var that = this;
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var entries = [];
    for (var i in node.properties) {
        var value = node.properties[i] !== undefined ? node.properties[i] : " ";
        if (typeof value == "object")
            value = JSON.stringify(value);
        var info = node.getPropertyInfo(i);
        if (info.type == "enum" || info.type == "combo")
            value = LGraphCanvas.getPropertyPrintableValue(value, info.values);
        //value could contain invalid html characters, clean that
        value = LGraphCanvas.decodeHTML(value);
        entries.push({
            content: "<span class='property_name'>" +
                (info.label ? info.label : i) +
                "</span>" +
                "<span class='property_value'>" +
                value +
                "</span>",
            value: i
        });
    }
    if (!entries.length) {
        return;
    }
    var menu = new exports.LiteGraph.ContextMenu(entries, {
        event: e,
        callback: inner_clicked,
        parentMenu: prev_menu,
        allow_html: true,
        node: node
    }, ref_window);
    function inner_clicked(v, options, e, prev) {
        if (!node) {
            return;
        }
        var rect = this.getBoundingClientRect();
        canvas.showEditPropertyValue(node, v.value, {
            position: [rect.left, rect.top]
        });
    }
    return false;
};
LGraphCanvas.decodeHTML = function (str) {
    var e = document.createElement("div");
    e.innerText = str;
    return e.innerHTML;
};
LGraphCanvas.onMenuResizeNode = function (value, options, e, menu, node) {
    if (!node) {
        return;
    }
    var fApplyMultiNode = function (node) {
        node.size = node.computeSize();
        if (node.onResize)
            node.onResize(node.size);
    };
    var graphcanvas = LGraphCanvas.active_canvas;
    if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
        fApplyMultiNode(node);
    }
    else {
        for (var i in graphcanvas.selected_nodes) {
            fApplyMultiNode(graphcanvas.selected_nodes[i]);
        }
    }
    node.setDirtyCanvas(true, true);
};
LGraphCanvas.prototype.showLinkMenu = function (link, e) {
    var that = this;
    // console.log(link);
    var node_left = that.graph.getNodeById(link.origin_id);
    var node_right = that.graph.getNodeById(link.target_id);
    var fromType = false;
    if (node_left && node_left.outputs && node_left.outputs[link.origin_slot])
        fromType = node_left.outputs[link.origin_slot].type;
    var destType = false;
    if (node_right && node_right.outputs && node_right.outputs[link.target_slot])
        destType = node_right.inputs[link.target_slot].type;
    var options = ["Add Node", null, "Delete", null];
    var menu = new exports.LiteGraph.ContextMenu(options, {
        event: e,
        title: link.data != null ? link.data.constructor.name : null,
        callback: inner_clicked
    });
    function inner_clicked(v, options, e) {
        switch (v) {
            case "Add Node":
                LGraphCanvas.onMenuAdd(null, null, e, menu, function (node) {
                    // console.debug("node autoconnect");
                    if (!node.inputs || !node.inputs.length || !node.outputs || !node.outputs.length) {
                        return;
                    }
                    // leave the connection type checking inside connectByType
                    if (node_left.connectByType(link.origin_slot, node, fromType)) {
                        node.connectByType(link.target_slot, node_right, destType);
                        node.pos[0] -= node.size[0] * 0.5;
                    }
                });
                break;
            case "Delete":
                that.graph.removeLink(link.id);
                break;
            default:
            /*var nodeCreated = createDefaultNodeForSlot({   nodeFrom: node_left
                                                            ,slotFrom: link.origin_slot
                                                            ,nodeTo: node
                                                            ,slotTo: link.target_slot
                                                            ,e: e
                                                            ,nodeType: "AUTO"
                                                        });
            if(nodeCreated) console.log("new node in beetween "+v+" created");*/
        }
    }
    return false;
};
LGraphCanvas.prototype.createDefaultNodeForSlot = function (optPass) {
    var optPass = optPass || {};
    var opts = Object.assign({ nodeFrom: null // input
        ,
        slotFrom: null // input
        ,
        nodeTo: null // output
        ,
        slotTo: null // output
        ,
        position: [] // pass the event coords
        ,
        nodeType: null // choose a nodetype to add, AUTO to set at first good
        ,
        posAdd: [0, 0] // adjust x,y
        ,
        posSizeFix: [0, 0] // alpha, adjust the position x,y based on the new node size w,h
    }, optPass);
    var that = this;
    var isFrom = opts.nodeFrom && opts.slotFrom !== null;
    var isTo = !isFrom && opts.nodeTo && opts.slotTo !== null;
    if (!isFrom && !isTo) {
        console.warn("No data passed to createDefaultNodeForSlot " + opts.nodeFrom + " " + opts.slotFrom + " " + opts.nodeTo + " " + opts.slotTo);
        return false;
    }
    if (!opts.nodeType) {
        console.warn("No type to createDefaultNodeForSlot");
        return false;
    }
    var nodeX = isFrom ? opts.nodeFrom : opts.nodeTo;
    var slotX = isFrom ? opts.slotFrom : opts.slotTo;
    var iSlotConn = false;
    switch (typeof slotX) {
        case "string":
            iSlotConn = isFrom ? nodeX.findOutputSlot(slotX, false) : nodeX.findInputSlot(slotX, false);
            slotX = isFrom ? nodeX.outputs[slotX] : nodeX.inputs[slotX];
            break;
        case "object":
            // ok slotX
            iSlotConn = isFrom ? nodeX.findOutputSlot(slotX.name) : nodeX.findInputSlot(slotX.name);
            break;
        case "number":
            iSlotConn = slotX;
            slotX = isFrom ? nodeX.outputs[slotX] : nodeX.inputs[slotX];
            break;
        case "undefined":
        default:
            // bad ?
            //iSlotConn = 0;
            console.warn("Cant get slot information " + slotX);
            return false;
    }
    if (slotX === false || iSlotConn === false) {
        console.warn("createDefaultNodeForSlot bad slotX " + slotX + " " + iSlotConn);
    }
    // check for defaults nodes for this slottype
    var fromSlotType = slotX.type == exports.LiteGraph.EVENT ? "_event_" : slotX.type;
    var slotTypesDefault = isFrom ? exports.LiteGraph.slot_types_default_out : exports.LiteGraph.slot_types_default_in;
    if (slotTypesDefault && slotTypesDefault[fromSlotType]) {
        if (slotX.link !== null) {
            // is connected
        }
        else {
            // is not not connected
        }
        nodeNewType = false;
        if (typeof slotTypesDefault[fromSlotType] == "object" || typeof slotTypesDefault[fromSlotType] == "array") {
            for (var typeX in slotTypesDefault[fromSlotType]) {
                if (opts.nodeType == slotTypesDefault[fromSlotType][typeX] || opts.nodeType == "AUTO") {
                    nodeNewType = slotTypesDefault[fromSlotType][typeX];
                    // console.log("opts.nodeType == slotTypesDefault[fromSlotType][typeX] :: "+opts.nodeType);
                    break; // --------
                }
            }
        }
        else {
            if (opts.nodeType == slotTypesDefault[fromSlotType] || opts.nodeType == "AUTO")
                nodeNewType = slotTypesDefault[fromSlotType];
        }
        if (nodeNewType) {
            var nodeNewOpts = false;
            if (typeof nodeNewType == "object" && nodeNewType.node) {
                nodeNewOpts = nodeNewType;
                nodeNewType = nodeNewType.node;
            }
            //that.graph.beforeChange();
            var newNode = exports.LiteGraph.createNode(nodeNewType);
            if (newNode) {
                // if is object pass options
                if (nodeNewOpts) {
                    if (nodeNewOpts.properties) {
                        for (var i in nodeNewOpts.properties) {
                            newNode.addProperty(i, nodeNewOpts.properties[i]);
                        }
                    }
                    if (nodeNewOpts.inputs) {
                        newNode.inputs = [];
                        for (var i in nodeNewOpts.inputs) {
                            newNode.addOutput(nodeNewOpts.inputs[i][0], nodeNewOpts.inputs[i][1]);
                        }
                    }
                    if (nodeNewOpts.outputs) {
                        newNode.outputs = [];
                        for (var i in nodeNewOpts.outputs) {
                            newNode.addOutput(nodeNewOpts.outputs[i][0], nodeNewOpts.outputs[i][1]);
                        }
                    }
                    if (nodeNewOpts.title) {
                        newNode.title = nodeNewOpts.title;
                    }
                    if (nodeNewOpts.json) {
                        newNode.configure(nodeNewOpts.json);
                    }
                }
                // add the node
                that.graph.add(newNode);
                newNode.pos = [opts.position[0] + opts.posAdd[0] + (opts.posSizeFix[0] ? opts.posSizeFix[0] * newNode.size[0] : 0),
                    opts.position[1] + opts.posAdd[1] + (opts.posSizeFix[1] ? opts.posSizeFix[1] * newNode.size[1] : 0)]; //that.last_click_position; //[e.canvasX+30, e.canvasX+5];*/
                //that.graph.afterChange();
                // connect the two!
                if (isFrom) {
                    opts.nodeFrom.connectByType(iSlotConn, newNode, fromSlotType);
                }
                else {
                    opts.nodeTo.connectByTypeOutput(iSlotConn, newNode, fromSlotType);
                }
                // if connecting in between
                if (isFrom && isTo) {
                    // TODO
                }
                return true;
            }
            else {
                console.log("failed creating " + nodeNewType);
            }
        }
    }
    return false;
};
LGraphCanvas.prototype.showConnectionMenu = function (optPass) {
    var optPass = optPass || {};
    var opts = Object.assign({ nodeFrom: null // input
        ,
        slotFrom: null // input
        ,
        nodeTo: null // output
        ,
        slotTo: null // output
        ,
        e: null
    }, optPass);
    var that = this;
    var isFrom = opts.nodeFrom && opts.slotFrom;
    var isTo = !isFrom && opts.nodeTo && opts.slotTo;
    if (!isFrom && !isTo) {
        console.warn("No data passed to showConnectionMenu");
        return false;
    }
    var nodeX = isFrom ? opts.nodeFrom : opts.nodeTo;
    var slotX = isFrom ? opts.slotFrom : opts.slotTo;
    var iSlotConn = false;
    switch (typeof slotX) {
        case "string":
            iSlotConn = isFrom ? nodeX.findOutputSlot(slotX, false) : nodeX.findInputSlot(slotX, false);
            slotX = isFrom ? nodeX.outputs[slotX] : nodeX.inputs[slotX];
            break;
        case "object":
            // ok slotX
            iSlotConn = isFrom ? nodeX.findOutputSlot(slotX.name) : nodeX.findInputSlot(slotX.name);
            break;
        case "number":
            iSlotConn = slotX;
            slotX = isFrom ? nodeX.outputs[slotX] : nodeX.inputs[slotX];
            break;
        default:
            // bad ?
            //iSlotConn = 0;
            console.warn("Cant get slot information " + slotX);
            return false;
    }
    var options = ["Add Node", null];
    if (that.allow_searchbox) {
        options.push("Search");
        options.push(null);
    }
    // get defaults nodes for this slottype
    var fromSlotType = slotX.type == exports.LiteGraph.EVENT ? "_event_" : slotX.type;
    var slotTypesDefault = isFrom ? exports.LiteGraph.slot_types_default_out : exports.LiteGraph.slot_types_default_in;
    if (slotTypesDefault && slotTypesDefault[fromSlotType]) {
        if (typeof slotTypesDefault[fromSlotType] == "object" || typeof slotTypesDefault[fromSlotType] == "array") {
            for (var typeX in slotTypesDefault[fromSlotType]) {
                options.push(slotTypesDefault[fromSlotType][typeX]);
            }
        }
        else {
            options.push(slotTypesDefault[fromSlotType]);
        }
    }
    // build menu
    var menu = new exports.LiteGraph.ContextMenu(options, {
        event: opts.e,
        title: (slotX && slotX.name != "" ? (slotX.name + (fromSlotType ? " | " : "")) : "") + (slotX && fromSlotType ? fromSlotType : ""),
        callback: inner_clicked
    });
    // callback
    function inner_clicked(v, options, e) {
        //console.log("Process showConnectionMenu selection");
        switch (v) {
            case "Add Node":
                LGraphCanvas.onMenuAdd(null, null, e, menu, function (node) {
                    if (isFrom) {
                        opts.nodeFrom.connectByType(iSlotConn, node, fromSlotType);
                    }
                    else {
                        opts.nodeTo.connectByTypeOutput(iSlotConn, node, fromSlotType);
                    }
                });
                break;
            case "Search":
                if (isFrom) {
                    that.showSearchBox(e, { node_from: opts.nodeFrom, slot_from: slotX, type_filter_in: fromSlotType });
                }
                else {
                    that.showSearchBox(e, { node_to: opts.nodeTo, slot_from: slotX, type_filter_out: fromSlotType });
                }
                break;
            default:
                // check for defaults nodes for this slottype
                var nodeCreated = that.createDefaultNodeForSlot(Object.assign(opts, { position: [opts.e.canvasX, opts.e.canvasY],
                    nodeType: v
                }));
                if (nodeCreated) {
                    // new node created
                    //console.log("node "+v+" created")
                }
                else {
                    // failed or v is not in defaults
                }
                break;
        }
    }
    return false;
};
// TODO refactor :: this is used fot title but not for properties!
LGraphCanvas.onShowPropertyEditor = function (item, options, e, menu, node) {
    var input_html = "";
    var property = item.property || "title";
    var value = node[property];
    // TODO refactor :: use createDialog ?
    var dialog = document.createElement("div");
    dialog.is_modified = false;
    dialog.className = "graphdialog";
    dialog.innerHTML =
        "<span class='name'></span><input autofocus type='text' class='value'/><button>OK</button>";
    dialog.close = function () {
        if (dialog.parentNode) {
            dialog.parentNode.removeChild(dialog);
        }
    };
    var title = dialog.querySelector(".name");
    title.innerText = property;
    var input = dialog.querySelector(".value");
    if (input) {
        input.value = value;
        input.addEventListener("blur", function (e) {
            this.focus();
        });
        input.addEventListener("keydown", function (e) {
            dialog.is_modified = true;
            if (e.keyCode == 27) {
                //ESC
                dialog.close();
            }
            else if (e.keyCode == 13) {
                inner(); // save
            }
            else if (e.keyCode != 13 && e.target.localName != "textarea") {
                return;
            }
            e.preventDefault();
            e.stopPropagation();
        });
    }
    var graphcanvas = LGraphCanvas.active_canvas;
    var canvas = graphcanvas.canvas;
    var rect = canvas.getBoundingClientRect();
    var offsetx = -20;
    var offsety = -20;
    if (rect) {
        offsetx -= rect.left;
        offsety -= rect.top;
    }
    if (event) {
        dialog.style.left = event.clientX + offsetx + "px";
        dialog.style.top = event.clientY + offsety + "px";
    }
    else {
        dialog.style.left = canvas.width * 0.5 + offsetx + "px";
        dialog.style.top = canvas.height * 0.5 + offsety + "px";
    }
    var button = dialog.querySelector("button");
    button.addEventListener("click", inner);
    canvas.parentNode.appendChild(dialog);
    if (input)
        input.focus();
    var dialogCloseTimer = null;
    dialog.addEventListener("mouseleave", function (e) {
        if (exports.LiteGraph.dialog_close_on_mouse_leave)
            if (!dialog.is_modified && exports.LiteGraph.dialog_close_on_mouse_leave)
                dialogCloseTimer = setTimeout(dialog.close, exports.LiteGraph.dialog_close_on_mouse_leave_delay); //dialog.close();
    });
    dialog.addEventListener("mouseenter", function (e) {
        if (exports.LiteGraph.dialog_close_on_mouse_leave)
            if (dialogCloseTimer)
                clearTimeout(dialogCloseTimer);
    });
    function inner() {
        if (input)
            setValue(input.value);
    }
    function setValue(value) {
        if (item.type == "Number") {
            value = Number(value);
        }
        else if (item.type == "Boolean") {
            value = Boolean(value);
        }
        node[property] = value;
        if (dialog.parentNode) {
            dialog.parentNode.removeChild(dialog);
        }
        node.setDirtyCanvas(true, true);
    }
};
// refactor: there are different dialogs, some uses createDialog some dont
LGraphCanvas.prototype.prompt = function (title, value, callback, event, multiline) {
    var that = this;
    var input_html = "";
    title = title || "";
    var dialog = document.createElement("div");
    dialog.is_modified = false;
    dialog.className = "graphdialog rounded";
    if (multiline)
        dialog.innerHTML = "<span class='name'></span> <textarea autofocus class='value'></textarea><button class='rounded'>OK</button>";
    else
        dialog.innerHTML = "<span class='name'></span> <input autofocus type='text' class='value'/><button class='rounded'>OK</button>";
    dialog.close = function () {
        that.prompt_box = null;
        if (dialog.parentNode) {
            dialog.parentNode.removeChild(dialog);
        }
    };
    var graphcanvas = LGraphCanvas.active_canvas;
    var canvas = graphcanvas.canvas;
    canvas.parentNode.appendChild(dialog);
    if (this.ds.scale > 1) {
        dialog.style.transform = "scale(" + this.ds.scale + ")";
    }
    var dialogCloseTimer = null;
    var prevent_timeout = false;
    exports.LiteGraph.pointerListenerAdd(dialog, "leave", function (e) {
        if (prevent_timeout)
            return;
        if (exports.LiteGraph.dialog_close_on_mouse_leave)
            if (!dialog.is_modified && exports.LiteGraph.dialog_close_on_mouse_leave)
                dialogCloseTimer = setTimeout(dialog.close, exports.LiteGraph.dialog_close_on_mouse_leave_delay); //dialog.close();
    });
    exports.LiteGraph.pointerListenerAdd(dialog, "enter", function (e) {
        if (exports.LiteGraph.dialog_close_on_mouse_leave)
            if (dialogCloseTimer)
                clearTimeout(dialogCloseTimer);
    });
    var selInDia = dialog.querySelectorAll("select");
    if (selInDia) {
        // if filtering, check focus changed to comboboxes and prevent closing
        selInDia.forEach(function (selIn) {
            selIn.addEventListener("click", function (e) {
                prevent_timeout++;
            });
            selIn.addEventListener("blur", function (e) {
                prevent_timeout = 0;
            });
            selIn.addEventListener("change", function (e) {
                prevent_timeout = -1;
            });
        });
    }
    if (that.prompt_box) {
        that.prompt_box.close();
    }
    that.prompt_box = dialog;
    var first = null;
    var timeout = null;
    var selected = null;
    var name_element = dialog.querySelector(".name");
    name_element.innerText = title;
    var value_element = dialog.querySelector(".value");
    value_element.value = value;
    var input = value_element;
    input.addEventListener("keydown", function (e) {
        dialog.is_modified = true;
        if (e.keyCode == 27) {
            //ESC
            dialog.close();
        }
        else if (e.keyCode == 13 && e.target.localName != "textarea") {
            if (callback) {
                callback(this.value);
            }
            dialog.close();
        }
        else {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
    });
    var button = dialog.querySelector("button");
    button.addEventListener("click", function (e) {
        if (callback) {
            callback(input.value);
        }
        that.setDirty(true);
        dialog.close();
    });
    var rect = canvas.getBoundingClientRect();
    var offsetx = -20;
    var offsety = -20;
    if (rect) {
        offsetx -= rect.left;
        offsety -= rect.top;
    }
    if (event) {
        dialog.style.left = event.clientX + offsetx + "px";
        dialog.style.top = event.clientY + offsety + "px";
    }
    else {
        dialog.style.left = canvas.width * 0.5 + offsetx + "px";
        dialog.style.top = canvas.height * 0.5 + offsety + "px";
    }
    setTimeout(function () {
        input.focus();
    }, 10);
    return dialog;
};
LGraphCanvas.search_limit = -1;
LGraphCanvas.prototype.showSearchBox = function (event, options) {
    // proposed defaults
    var def_options = { slot_from: null,
        node_from: null,
        node_to: null,
        do_type_filter: exports.LiteGraph.search_filter_enabled // TODO check for registered_slot_[in/out]_types not empty // this will be checked for functionality enabled : filter on slot type, in and out
        ,
        type_filter_in: false // these are default: pass to set initially set values
        ,
        type_filter_out: false,
        show_general_if_none_on_typefilter: true,
        show_general_after_typefiltered: true,
        hide_on_mouse_leave: exports.LiteGraph.search_hide_on_mouse_leave,
        show_all_if_empty: true,
        show_all_on_open: exports.LiteGraph.search_show_all_on_open
    };
    options = Object.assign(def_options, options || {});
    //console.log(options);
    var that = this;
    var input_html = "";
    var graphcanvas = LGraphCanvas.active_canvas;
    var canvas = graphcanvas.canvas;
    var root_document = canvas.ownerDocument || document;
    var dialog = document.createElement("div");
    dialog.className = "litegraph litesearchbox graphdialog rounded";
    dialog.innerHTML = "<span class='name'>Search</span> <input autofocus type='text' class='value rounded'/>";
    if (options.do_type_filter) {
        dialog.innerHTML += "<select class='slot_in_type_filter'><option value=''></option></select>";
        dialog.innerHTML += "<select class='slot_out_type_filter'><option value=''></option></select>";
    }
    dialog.innerHTML += "<div class='helper'></div>";
    if (root_document.fullscreenElement)
        root_document.fullscreenElement.appendChild(dialog);
    else {
        root_document.body.appendChild(dialog);
        root_document.body.style.overflow = "hidden";
    }
    // dialog element has been appended
    if (options.do_type_filter) {
        var selIn = dialog.querySelector(".slot_in_type_filter");
        var selOut = dialog.querySelector(".slot_out_type_filter");
    }
    dialog.close = function () {
        that.search_box = null;
        this.blur();
        canvas.focus();
        root_document.body.style.overflow = "";
        setTimeout(function () {
            that.canvas.focus();
        }, 20); //important, if canvas loses focus keys wont be captured
        if (dialog.parentNode) {
            dialog.parentNode.removeChild(dialog);
        }
    };
    if (this.ds.scale > 1) {
        dialog.style.transform = "scale(" + this.ds.scale + ")";
    }
    // hide on mouse leave
    if (options.hide_on_mouse_leave) {
        var prevent_timeout = false;
        var timeout_close = null;
        exports.LiteGraph.pointerListenerAdd(dialog, "enter", function (e) {
            if (timeout_close) {
                clearTimeout(timeout_close);
                timeout_close = null;
            }
        });
        exports.LiteGraph.pointerListenerAdd(dialog, "leave", function (e) {
            if (prevent_timeout) {
                return;
            }
            timeout_close = setTimeout(function () {
                dialog.close();
            }, 500);
        });
        // if filtering, check focus changed to comboboxes and prevent closing
        if (options.do_type_filter) {
            selIn.addEventListener("click", function (e) {
                prevent_timeout++;
            });
            selIn.addEventListener("blur", function (e) {
                prevent_timeout = 0;
            });
            selIn.addEventListener("change", function (e) {
                prevent_timeout = -1;
            });
            selOut.addEventListener("click", function (e) {
                prevent_timeout++;
            });
            selOut.addEventListener("blur", function (e) {
                prevent_timeout = 0;
            });
            selOut.addEventListener("change", function (e) {
                prevent_timeout = -1;
            });
        }
    }
    if (that.search_box) {
        that.search_box.close();
    }
    that.search_box = dialog;
    var helper = dialog.querySelector(".helper");
    var first = null;
    var timeout = null;
    var selected = null;
    var input = dialog.querySelector("input");
    if (input) {
        input.addEventListener("blur", function (e) {
            if (that.search_box)
                this.focus();
        });
        input.addEventListener("keydown", function (e) {
            if (e.keyCode == 38) {
                //UP
                changeSelection(false);
            }
            else if (e.keyCode == 40) {
                //DOWN
                changeSelection(true);
            }
            else if (e.keyCode == 27) {
                //ESC
                dialog.close();
            }
            else if (e.keyCode == 13) {
                refreshHelper();
                if (selected) {
                    select(selected.innerHTML);
                }
                else if (first) {
                    select(first);
                }
                else {
                    dialog.close();
                }
            }
            else {
                if (timeout) {
                    clearInterval(timeout);
                }
                timeout = setTimeout(refreshHelper, 250);
                return;
            }
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            return true;
        });
    }
    // if should filter on type, load and fill selected and choose elements if passed
    if (options.do_type_filter) {
        if (selIn) {
            var aSlots = exports.LiteGraph.slot_types_in;
            var nSlots = aSlots.length; // this for object :: Object.keys(aSlots).length;
            if (options.type_filter_in == exports.LiteGraph.EVENT || options.type_filter_in == exports.LiteGraph.ACTION)
                options.type_filter_in = "_event_";
            /* this will filter on * .. but better do it manually in case
            else if(options.type_filter_in === "" || options.type_filter_in === 0)
                options.type_filter_in = "*";*/
            for (var iK = 0; iK < nSlots; iK++) {
                var opt = document.createElement('option');
                opt.value = aSlots[iK];
                opt.innerHTML = aSlots[iK];
                selIn.appendChild(opt);
                if (options.type_filter_in !== false && (options.type_filter_in + "").toLowerCase() == (aSlots[iK] + "").toLowerCase()) {
                    //selIn.selectedIndex ..
                    opt.selected = true;
                    //console.log("comparing IN "+options.type_filter_in+" :: "+aSlots[iK]);
                }
                else {
                    //console.log("comparing OUT "+options.type_filter_in+" :: "+aSlots[iK]);
                }
            }
            selIn.addEventListener("change", function () {
                refreshHelper();
            });
        }
        if (selOut) {
            var aSlots = exports.LiteGraph.slot_types_out;
            var nSlots = aSlots.length; // this for object :: Object.keys(aSlots).length; 
            if (options.type_filter_out == exports.LiteGraph.EVENT || options.type_filter_out == exports.LiteGraph.ACTION)
                options.type_filter_out = "_event_";
            /* this will filter on * .. but better do it manually in case
            else if(options.type_filter_out === "" || options.type_filter_out === 0)
                options.type_filter_out = "*";*/
            for (var iK = 0; iK < nSlots; iK++) {
                var opt = document.createElement('option');
                opt.value = aSlots[iK];
                opt.innerHTML = aSlots[iK];
                selOut.appendChild(opt);
                if (options.type_filter_out !== false && (options.type_filter_out + "").toLowerCase() == (aSlots[iK] + "").toLowerCase()) {
                    //selOut.selectedIndex ..
                    opt.selected = true;
                }
            }
            selOut.addEventListener("change", function () {
                refreshHelper();
            });
        }
    }
    //compute best position
    var rect = canvas.getBoundingClientRect();
    var left = (event ? event.clientX : (rect.left + rect.width * 0.5)) - 80;
    var top = (event ? event.clientY : (rect.top + rect.height * 0.5)) - 20;
    dialog.style.left = left + "px";
    dialog.style.top = top + "px";
    //To avoid out of screen problems
    if (event.layerY > (rect.height - 200))
        helper.style.maxHeight = (rect.height - event.layerY - 20) + "px";
    /*
    var offsetx = -20;
    var offsety = -20;
    if (rect) {
        offsetx -= rect.left;
        offsety -= rect.top;
    }

    if (event) {
        dialog.style.left = event.clientX + offsetx + "px";
        dialog.style.top = event.clientY + offsety + "px";
    } else {
        dialog.style.left = canvas.width * 0.5 + offsetx + "px";
        dialog.style.top = canvas.height * 0.5 + offsety + "px";
    }
    canvas.parentNode.appendChild(dialog);
    */
    input.focus();
    if (options.show_all_on_open)
        refreshHelper();
    function select(name) {
        if (name) {
            if (that.onSearchBoxSelection) {
                that.onSearchBoxSelection(name, event, graphcanvas);
            }
            else {
                var extra = exports.LiteGraph.searchbox_extras[name.toLowerCase()];
                if (extra) {
                    name = extra.type;
                }
                graphcanvas.graph.beforeChange();
                var node = exports.LiteGraph.createNode(name);
                if (node) {
                    node.pos = graphcanvas.convertEventToCanvasOffset(event);
                    graphcanvas.graph.add(node, false);
                }
                if (extra && extra.data) {
                    if (extra.data.properties) {
                        for (var i in extra.data.properties) {
                            node.addProperty(i, extra.data.properties[i]);
                        }
                    }
                    if (extra.data.inputs) {
                        node.inputs = [];
                        for (var i in extra.data.inputs) {
                            node.addOutput(extra.data.inputs[i][0], extra.data.inputs[i][1]);
                        }
                    }
                    if (extra.data.outputs) {
                        node.outputs = [];
                        for (var i in extra.data.outputs) {
                            node.addOutput(extra.data.outputs[i][0], extra.data.outputs[i][1]);
                        }
                    }
                    if (extra.data.title) {
                        node.title = extra.data.title;
                    }
                    if (extra.data.json) {
                        node.configure(extra.data.json);
                    }
                }
                // join node after inserting
                if (options.node_from) {
                    var iS = false;
                    switch (typeof options.slot_from) {
                        case "string":
                            iS = options.node_from.findOutputSlot(options.slot_from);
                            break;
                        case "object":
                            if (options.slot_from.name) {
                                iS = options.node_from.findOutputSlot(options.slot_from.name);
                            }
                            else {
                                iS = -1;
                            }
                            if (iS == -1 && typeof options.slot_from.slot_index !== "undefined")
                                iS = options.slot_from.slot_index;
                            break;
                        case "number":
                            iS = options.slot_from;
                            break;
                        default:
                            iS = 0; // try with first if no name set
                    }
                    if (typeof options.node_from.outputs[iS] !== "undefined") {
                        if (iS !== false && iS > -1) {
                            options.node_from.connectByType(iS, node, options.node_from.outputs[iS].type);
                        }
                    }
                    else {
                        // console.warn("cant find slot " + options.slot_from);
                    }
                }
                if (options.node_to) {
                    var iS = false;
                    switch (typeof options.slot_from) {
                        case "string":
                            iS = options.node_to.findInputSlot(options.slot_from);
                            break;
                        case "object":
                            if (options.slot_from.name) {
                                iS = options.node_to.findInputSlot(options.slot_from.name);
                            }
                            else {
                                iS = -1;
                            }
                            if (iS == -1 && typeof options.slot_from.slot_index !== "undefined")
                                iS = options.slot_from.slot_index;
                            break;
                        case "number":
                            iS = options.slot_from;
                            break;
                        default:
                            iS = 0; // try with first if no name set
                    }
                    if (typeof options.node_to.inputs[iS] !== "undefined") {
                        if (iS !== false && iS > -1) {
                            // try connection
                            options.node_to.connectByTypeOutput(iS, node, options.node_to.inputs[iS].type);
                        }
                    }
                    else {
                        // console.warn("cant find slot_nodeTO " + options.slot_from);
                    }
                }
                graphcanvas.graph.afterChange();
            }
        }
        dialog.close();
    }
    function changeSelection(forward) {
        var prev = selected;
        if (selected) {
            selected.classList.remove("selected");
        }
        if (!selected) {
            selected = forward
                ? helper.childNodes[0]
                : helper.childNodes[helper.childNodes.length];
        }
        else {
            selected = forward
                ? selected.nextSibling
                : selected.previousSibling;
            if (!selected) {
                selected = prev;
            }
        }
        if (!selected) {
            return;
        }
        selected.classList.add("selected");
        selected.scrollIntoView({ block: "end", behavior: "smooth" });
    }
    function refreshHelper() {
        timeout = null;
        var str = input.value;
        first = null;
        helper.innerHTML = "";
        if (!str && !options.show_all_if_empty) {
            return;
        }
        if (that.onSearchBox) {
            var list = that.onSearchBox(helper, str, graphcanvas);
            if (list) {
                for (var i = 0; i < list.length; ++i) {
                    addResult(list[i]);
                }
            }
        }
        else {
            var c = 0;
            str = str.toLowerCase();
            var filter = graphcanvas.filter || graphcanvas.graph.filter;
            // filter by type preprocess
            if (options.do_type_filter && that.search_box) {
                var sIn = that.search_box.querySelector(".slot_in_type_filter");
                var sOut = that.search_box.querySelector(".slot_out_type_filter");
            }
            else {
                var sIn = false;
                var sOut = false;
            }
            //extras
            for (var i in exports.LiteGraph.searchbox_extras) {
                var extra = exports.LiteGraph.searchbox_extras[i];
                if ((!options.show_all_if_empty || str) && extra.desc.toLowerCase().indexOf(str) === -1) {
                    continue;
                }
                var ctor = exports.LiteGraph.registered_node_types[extra.type];
                if (ctor && ctor.filter != filter)
                    continue;
                if (!inner_test_filter(extra.type))
                    continue;
                addResult(extra.desc, "searchbox_extra");
                if (LGraphCanvas.search_limit !== -1 && c++ > LGraphCanvas.search_limit) {
                    break;
                }
            }
            var filtered = null;
            if (Array.prototype.filter) { //filter supported
                var keys = Object.keys(exports.LiteGraph.registered_node_types); //types
                var filtered = keys.filter(inner_test_filter);
            }
            else {
                filtered = [];
                for (var i in exports.LiteGraph.registered_node_types) {
                    if (inner_test_filter(i))
                        filtered.push(i);
                }
            }
            for (var i = 0; i < filtered.length; i++) {
                addResult(filtered[i]);
                if (LGraphCanvas.search_limit !== -1 && c++ > LGraphCanvas.search_limit) {
                    break;
                }
            }
            // add general type if filtering
            if (options.show_general_after_typefiltered
                && (sIn.value || sOut.value)) {
                filtered_extra = [];
                for (var i in exports.LiteGraph.registered_node_types) {
                    if (inner_test_filter(i, { inTypeOverride: sIn && sIn.value ? "*" : false, outTypeOverride: sOut && sOut.value ? "*" : false }))
                        filtered_extra.push(i);
                }
                for (var i = 0; i < filtered_extra.length; i++) {
                    addResult(filtered_extra[i], "generic_type");
                    if (LGraphCanvas.search_limit !== -1 && c++ > LGraphCanvas.search_limit) {
                        break;
                    }
                }
            }
            // check il filtering gave no results
            if ((sIn.value || sOut.value) &&
                ((helper.childNodes.length == 0 && options.show_general_if_none_on_typefilter))) {
                filtered_extra = [];
                for (var i in exports.LiteGraph.registered_node_types) {
                    if (inner_test_filter(i, { skipFilter: true }))
                        filtered_extra.push(i);
                }
                for (var i = 0; i < filtered_extra.length; i++) {
                    addResult(filtered_extra[i], "not_in_filter");
                    if (LGraphCanvas.search_limit !== -1 && c++ > LGraphCanvas.search_limit) {
                        break;
                    }
                }
            }
            function inner_test_filter(type, optsIn) {
                var optsIn = optsIn || {};
                var optsDef = { skipFilter: false,
                    inTypeOverride: false,
                    outTypeOverride: false
                };
                var opts = Object.assign(optsDef, optsIn);
                var ctor = exports.LiteGraph.registered_node_types[type];
                if (filter && ctor.filter != filter)
                    return false;
                if ((!options.show_all_if_empty || str) && type.toLowerCase().indexOf(str) === -1)
                    return false;
                // filter by slot IN, OUT types
                if (options.do_type_filter && !opts.skipFilter) {
                    var sType = type;
                    var sV = sIn.value;
                    if (opts.inTypeOverride !== false)
                        sV = opts.inTypeOverride;
                    //if (sV.toLowerCase() == "_event_") sV = LiteGraph.EVENT; // -1
                    if (sIn && sV) {
                        //console.log("will check filter against "+sV);
                        if (exports.LiteGraph.registered_slot_in_types[sV] && exports.LiteGraph.registered_slot_in_types[sV].nodes) { // type is stored
                            //console.debug("check "+sType+" in "+LiteGraph.registered_slot_in_types[sV].nodes);
                            var doesInc = exports.LiteGraph.registered_slot_in_types[sV].nodes.includes(sType);
                            if (doesInc !== false) {
                                //console.log(sType+" HAS "+sV);
                            }
                            else {
                                /*console.debug(LiteGraph.registered_slot_in_types[sV]);
                                console.log(+" DONT includes "+type);*/
                                return false;
                            }
                        }
                    }
                    var sV = sOut.value;
                    if (opts.outTypeOverride !== false)
                        sV = opts.outTypeOverride;
                    //if (sV.toLowerCase() == "_event_") sV = LiteGraph.EVENT; // -1
                    if (sOut && sV) {
                        //console.log("search will check filter against "+sV);
                        if (exports.LiteGraph.registered_slot_out_types[sV] && exports.LiteGraph.registered_slot_out_types[sV].nodes) { // type is stored
                            //console.debug("check "+sType+" in "+LiteGraph.registered_slot_out_types[sV].nodes);
                            var doesInc = exports.LiteGraph.registered_slot_out_types[sV].nodes.includes(sType);
                            if (doesInc !== false) {
                                //console.log(sType+" HAS "+sV);
                            }
                            else {
                                /*console.debug(LiteGraph.registered_slot_out_types[sV]);
                                console.log(+" DONT includes "+type);*/
                                return false;
                            }
                        }
                    }
                }
                return true;
            }
        }
        function addResult(type, className) {
            var help = document.createElement("div");
            if (!first) {
                first = type;
            }
            help.innerText = type;
            help.dataset["type"] = escape(type);
            help.className = "litegraph lite-search-item";
            if (className) {
                help.className += " " + className;
            }
            help.addEventListener("click", function (e) {
                select(unescape(this.dataset["type"]));
            });
            helper.appendChild(help);
        }
    }
    return dialog;
};
LGraphCanvas.prototype.showEditPropertyValue = function (node, property, options) {
    if (!node || node.properties[property] === undefined) {
        return;
    }
    options = options || {};
    var that = this;
    var info = node.getPropertyInfo(property);
    var type = info.type;
    var input_html = "";
    if (type == "string" || type == "number" || type == "array" || type == "object") {
        input_html = "<input autofocus type='text' class='value'/>";
    }
    else if ((type == "enum" || type == "combo") && info.values) {
        input_html = "<select autofocus type='text' class='value'>";
        for (var i in info.values) {
            var v = i;
            if (info.values.constructor === Array)
                v = info.values[i];
            input_html +=
                "<option value='" +
                    v +
                    "' " +
                    (v == node.properties[property] ? "selected" : "") +
                    ">" +
                    info.values[i] +
                    "</option>";
        }
        input_html += "</select>";
    }
    else if (type == "boolean" || type == "toggle") {
        input_html =
            "<input autofocus type='checkbox' class='value' " +
                (node.properties[property] ? "checked" : "") +
                "/>";
    }
    else {
        console.warn("unknown type: " + type);
        return;
    }
    var dialog = this.createDialog("<span class='name'>" +
        (info.label ? info.label : property) +
        "</span>" +
        input_html +
        "<button>OK</button>", options);
    var input = false;
    if ((type == "enum" || type == "combo") && info.values) {
        input = dialog.querySelector("select");
        input.addEventListener("change", function (e) {
            dialog.modified();
            setValue(e.target.value);
            //var index = e.target.value;
            //setValue( e.options[e.selectedIndex].value );
        });
    }
    else if (type == "boolean" || type == "toggle") {
        input = dialog.querySelector("input");
        if (input) {
            input.addEventListener("click", function (e) {
                dialog.modified();
                setValue(!!input.checked);
            });
        }
    }
    else {
        input = dialog.querySelector("input");
        if (input) {
            input.addEventListener("blur", function (e) {
                this.focus();
            });
            var v = node.properties[property] !== undefined ? node.properties[property] : "";
            if (type !== 'string') {
                v = JSON.stringify(v);
            }
            input.value = v;
            input.addEventListener("keydown", function (e) {
                if (e.keyCode == 27) {
                    //ESC
                    dialog.close();
                }
                else if (e.keyCode == 13) {
                    // ENTER
                    inner(); // save
                }
                else if (e.keyCode != 13) {
                    dialog.modified();
                    return;
                }
                e.preventDefault();
                e.stopPropagation();
            });
        }
    }
    if (input)
        input.focus();
    var button = dialog.querySelector("button");
    button.addEventListener("click", inner);
    function inner() {
        setValue(input.value);
    }
    function setValue(value) {
        if (info && info.values && info.values.constructor === Object && info.values[value] != undefined)
            value = info.values[value];
        if (typeof node.properties[property] == "number") {
            value = Number(value);
        }
        if (type == "array" || type == "object") {
            value = JSON.parse(value);
        }
        node.properties[property] = value;
        if (node.graph) {
            node.graph._version++;
        }
        if (node.onPropertyChanged) {
            node.onPropertyChanged(property, value);
        }
        if (options.onclose)
            options.onclose();
        dialog.close();
        node.setDirtyCanvas(true, true);
    }
    return dialog;
};
// TODO refactor, theer are different dialog, some uses createDialog, some dont
LGraphCanvas.prototype.createDialog = function (html, options) {
    var def_options = { checkForInput: false, closeOnLeave: true, closeOnLeave_checkModified: true };
    options = Object.assign(def_options, options || {});
    var dialog = document.createElement("div");
    dialog.className = "graphdialog";
    dialog.innerHTML = html;
    dialog.is_modified = false;
    var rect = this.canvas.getBoundingClientRect();
    var offsetx = -20;
    var offsety = -20;
    if (rect) {
        offsetx -= rect.left;
        offsety -= rect.top;
    }
    if (options.position) {
        offsetx += options.position[0];
        offsety += options.position[1];
    }
    else if (options.event) {
        offsetx += options.event.clientX;
        offsety += options.event.clientY;
    } //centered
    else {
        offsetx += this.canvas.width * 0.5;
        offsety += this.canvas.height * 0.5;
    }
    dialog.style.left = offsetx + "px";
    dialog.style.top = offsety + "px";
    this.canvas.parentNode.appendChild(dialog);
    // acheck for input and use default behaviour: save on enter, close on esc
    if (options.checkForInput) {
        var aI = [];
        var focused = false;
        if (aI = dialog.querySelectorAll("input")) {
            aI.forEach(function (iX) {
                iX.addEventListener("keydown", function (e) {
                    dialog.modified();
                    if (e.keyCode == 27) {
                        dialog.close();
                    }
                    else if (e.keyCode != 13) {
                        return;
                    }
                    // set value ?
                    e.preventDefault();
                    e.stopPropagation();
                });
                if (!focused)
                    iX.focus();
            });
        }
    }
    dialog.modified = function () {
        dialog.is_modified = true;
    };
    dialog.close = function () {
        if (dialog.parentNode) {
            dialog.parentNode.removeChild(dialog);
        }
    };
    var dialogCloseTimer = null;
    var prevent_timeout = false;
    dialog.addEventListener("mouseleave", function (e) {
        if (prevent_timeout)
            return;
        if (options.closeOnLeave || exports.LiteGraph.dialog_close_on_mouse_leave)
            if (!dialog.is_modified && exports.LiteGraph.dialog_close_on_mouse_leave)
                dialogCloseTimer = setTimeout(dialog.close, exports.LiteGraph.dialog_close_on_mouse_leave_delay); //dialog.close();
    });
    dialog.addEventListener("mouseenter", function (e) {
        if (options.closeOnLeave || exports.LiteGraph.dialog_close_on_mouse_leave)
            if (dialogCloseTimer)
                clearTimeout(dialogCloseTimer);
    });
    var selInDia = dialog.querySelectorAll("select");
    if (selInDia) {
        // if filtering, check focus changed to comboboxes and prevent closing
        selInDia.forEach(function (selIn) {
            selIn.addEventListener("click", function (e) {
                prevent_timeout++;
            });
            selIn.addEventListener("blur", function (e) {
                prevent_timeout = 0;
            });
            selIn.addEventListener("change", function (e) {
                prevent_timeout = -1;
            });
        });
    }
    return dialog;
};
LGraphCanvas.prototype.createPanel = function (title, options) {
    options = options || {};
    var ref_window = options.window || window;
    var root = document.createElement("div");
    root.className = "litegraph dialog";
    root.innerHTML = "<div class='dialog-header'><span class='dialog-title'></span></div><div class='dialog-content'></div><div style='display:none;' class='dialog-alt-content'></div><div class='dialog-footer'></div>";
    root.header = root.querySelector(".dialog-header");
    if (options.width)
        root.style.width = options.width + (options.width.constructor === Number ? "px" : "");
    if (options.height)
        root.style.height = options.height + (options.height.constructor === Number ? "px" : "");
    if (options.closable) {
        var close = document.createElement("span");
        close.innerHTML = "&#10005;";
        close.classList.add("close");
        close.addEventListener("click", function () {
            root.close();
        });
        root.header.appendChild(close);
    }
    root.title_element = root.querySelector(".dialog-title");
    root.title_element.innerText = title;
    root.content = root.querySelector(".dialog-content");
    root.alt_content = root.querySelector(".dialog-alt-content");
    root.footer = root.querySelector(".dialog-footer");
    root.close = function () {
        if (root.onClose && typeof root.onClose == "function") {
            root.onClose();
        }
        if (root.parentNode)
            root.parentNode.removeChild(root);
        /* XXX CHECK THIS */
        if (this.parentNode) {
            this.parentNode.removeChild(this);
        }
        /* XXX this was not working, was fixed with an IF, check this */
    };
    // function to swap panel content
    root.toggleAltContent = function (force) {
        if (typeof force != "undefined") {
            var vTo = force ? "block" : "none";
            var vAlt = force ? "none" : "block";
        }
        else {
            var vTo = root.alt_content.style.display != "block" ? "block" : "none";
            var vAlt = root.alt_content.style.display != "block" ? "none" : "block";
        }
        root.alt_content.style.display = vTo;
        root.content.style.display = vAlt;
    };
    root.toggleFooterVisibility = function (force) {
        if (typeof force != "undefined") {
            var vTo = force ? "block" : "none";
        }
        else {
            var vTo = root.footer.style.display != "block" ? "block" : "none";
        }
        root.footer.style.display = vTo;
    };
    root.clear = function () {
        this.content.innerHTML = "";
    };
    root.addHTML = function (code, classname, on_footer) {
        var elem = document.createElement("div");
        if (classname)
            elem.className = classname;
        elem.innerHTML = code;
        if (on_footer)
            root.footer.appendChild(elem);
        else
            root.content.appendChild(elem);
        return elem;
    };
    root.addButton = function (name, callback, options) {
        var elem = document.createElement("button");
        elem.innerText = name;
        elem.options = options;
        elem.classList.add("btn");
        elem.addEventListener("click", callback);
        root.footer.appendChild(elem);
        return elem;
    };
    root.addSeparator = function () {
        var elem = document.createElement("div");
        elem.className = "separator";
        root.content.appendChild(elem);
    };
    root.addWidget = function (type, name, value, options, callback) {
        options = options || {};
        var str_value = String(value);
        type = type.toLowerCase();
        if (type == "number")
            str_value = value.toFixed(3);
        var elem = document.createElement("div");
        elem.className = "property";
        elem.innerHTML = "<span class='property_name'></span><span class='property_value'></span>";
        elem.querySelector(".property_name").innerText = options.label || name;
        var value_element = elem.querySelector(".property_value");
        value_element.innerText = str_value;
        elem.dataset["property"] = name;
        elem.dataset["type"] = options.type || type;
        elem.options = options;
        elem.value = value;
        if (type == "code")
            elem.addEventListener("click", function (e) { root.inner_showCodePad(this.dataset["property"]); });
        else if (type == "boolean") {
            elem.classList.add("boolean");
            if (value)
                elem.classList.add("bool-on");
            elem.addEventListener("click", function () {
                //var v = node.properties[this.dataset["property"]]; 
                //node.setProperty(this.dataset["property"],!v); this.innerText = v ? "true" : "false"; 
                var propname = this.dataset["property"];
                this.value = !this.value;
                this.classList.toggle("bool-on");
                this.querySelector(".property_value").innerText = this.value ? "true" : "false";
                innerChange(propname, this.value);
            });
        }
        else if (type == "string" || type == "number") {
            value_element.setAttribute("contenteditable", true);
            value_element.addEventListener("keydown", function (e) {
                if (e.code == "Enter" && (type != "string" || !e.shiftKey)) // allow for multiline
                 {
                    e.preventDefault();
                    this.blur();
                }
            });
            value_element.addEventListener("blur", function () {
                var v = this.innerText;
                var propname = this.parentNode.dataset["property"];
                var proptype = this.parentNode.dataset["type"];
                if (proptype == "number")
                    v = Number(v);
                innerChange(propname, v);
            });
        }
        else if (type == "enum" || type == "combo") {
            var str_value = LGraphCanvas.getPropertyPrintableValue(value, options.values);
            value_element.innerText = str_value;
            value_element.addEventListener("click", function (event) {
                var values = options.values || [];
                var propname = this.parentNode.dataset["property"];
                var elem_that = this;
                var menu = new exports.LiteGraph.ContextMenu(values, {
                    event: event,
                    className: "dark",
                    callback: inner_clicked
                }, ref_window);
                function inner_clicked(v, option, event) {
                    //node.setProperty(propname,v); 
                    //graphcanvas.dirty_canvas = true;
                    elem_that.innerText = v;
                    innerChange(propname, v);
                    return false;
                }
            });
        }
        root.content.appendChild(elem);
        function innerChange(name, value) {
            //console.log("change",name,value);
            //that.dirty_canvas = true;
            if (options.callback)
                options.callback(name, value, options);
            if (callback)
                callback(name, value, options);
        }
        return elem;
    };
    if (root.onOpen && typeof root.onOpen == "function")
        root.onOpen();
    return root;
};
LGraphCanvas.getPropertyPrintableValue = function (value, values) {
    if (!values)
        return String(value);
    if (values.constructor === Array) {
        return String(value);
    }
    if (values.constructor === Object) {
        var desc_value = "";
        for (var k in values) {
            if (values[k] != value)
                continue;
            desc_value = k;
            break;
        }
        return String(value) + " (" + desc_value + ")";
    }
};
LGraphCanvas.prototype.closePanels = function () {
    var panel = document.querySelector("#node-panel");
    if (panel)
        panel.close();
    var panel = document.querySelector("#option-panel");
    if (panel)
        panel.close();
};
LGraphCanvas.prototype.showShowGraphOptionsPanel = function (refOpts, obEv, refMenu, refMenu2) {
    if (this.constructor && this.constructor.name == "HTMLDivElement") {
        // assume coming from the menu event click
        if (!obEv || !obEv.event || !obEv.event.target || !obEv.event.target.lgraphcanvas) {
            console.warn("Canvas not found"); // need a ref to canvas obj
            /*console.debug(event);
            console.debug(event.target);*/
            return;
        }
        var graphcanvas = obEv.event.target.lgraphcanvas;
    }
    else {
        // assume called internally
        var graphcanvas = this;
    }
    graphcanvas.closePanels();
    var ref_window = graphcanvas.getCanvasWindow();
    panel = graphcanvas.createPanel("Options", {
        closable: true,
        window: ref_window,
        onOpen: function () {
            graphcanvas.OPTIONPANEL_IS_OPEN = true;
        },
        onClose: function () {
            graphcanvas.OPTIONPANEL_IS_OPEN = false;
            graphcanvas.options_panel = null;
        }
    });
    graphcanvas.options_panel = panel;
    panel.id = "option-panel";
    panel.classList.add("settings");
    function inner_refresh() {
        panel.content.innerHTML = ""; //clear
        var fUpdate = function (name, value, options) {
            switch (name) {
                /*case "Render mode":
                    // Case ""..
                    if (options.values && options.key){
                        var kV = Object.values(options.values).indexOf(value);
                        if (kV>=0 && options.values[kV]){
                            console.debug("update graph options: "+options.key+": "+kV);
                            graphcanvas[options.key] = kV;
                            //console.debug(graphcanvas);
                            break;
                        }
                    }
                    console.warn("unexpected options");
                    console.debug(options);
                    break;*/
                default:
                    //console.debug("want to update graph options: "+name+": "+value);
                    if (options && options.key) {
                        name = options.key;
                    }
                    if (options.values) {
                        value = Object.values(options.values).indexOf(value);
                    }
                    //console.debug("update graph option: "+name+": "+value);
                    graphcanvas[name] = value;
                    break;
            }
        };
        // panel.addWidget( "string", "Graph name", "", {}, fUpdate); // implement
        var aProps = exports.LiteGraph.availableCanvasOptions;
        aProps.sort();
        for (var pI in aProps) {
            var pX = aProps[pI];
            panel.addWidget("boolean", pX, graphcanvas[pX], { key: pX, on: "True", off: "False" }, fUpdate);
        }
        var aLinks = [graphcanvas.links_render_mode];
        panel.addWidget("combo", "Render mode", exports.LiteGraph.LINK_RENDER_MODES[graphcanvas.links_render_mode], { key: "links_render_mode", values: exports.LiteGraph.LINK_RENDER_MODES }, fUpdate);
        panel.addSeparator();
        panel.footer.innerHTML = ""; // clear
    }
    inner_refresh();
    graphcanvas.canvas.parentNode.appendChild(panel);
};
LGraphCanvas.prototype.showShowNodePanel = function (node) {
    this.SELECTED_NODE = node;
    this.closePanels();
    var ref_window = this.getCanvasWindow();
    var that = this;
    var graphcanvas = this;
    var panel = this.createPanel(node.title || "", {
        closable: true,
        window: ref_window,
        onOpen: function () {
            graphcanvas.NODEPANEL_IS_OPEN = true;
        },
        onClose: function () {
            graphcanvas.NODEPANEL_IS_OPEN = false;
            graphcanvas.node_panel = null;
        }
    });
    graphcanvas.node_panel = panel;
    panel.id = "node-panel";
    panel.node = node;
    panel.classList.add("settings");
    function inner_refresh() {
        panel.content.innerHTML = ""; //clear
        panel.addHTML("<span class='node_type'>" + node.type + "</span><span class='node_desc'>" + (node.constructor.desc || "") + "</span><span class='separator'></span>");
        panel.addHTML("<h3>Properties</h3>");
        var fUpdate = function (name, value) {
            graphcanvas.graph.beforeChange(node);
            switch (name) {
                case "Title":
                    node.title = value;
                    break;
                case "Mode":
                    var kV = Object.values(exports.LiteGraph.NODE_MODES).indexOf(value);
                    if (kV >= 0 && exports.LiteGraph.NODE_MODES[kV]) {
                        node.changeMode(kV);
                    }
                    else {
                        console.warn("unexpected mode: " + value);
                    }
                    break;
                case "Color":
                    if (LGraphCanvas.node_colors[value]) {
                        node.color = LGraphCanvas.node_colors[value].color;
                        node.bgcolor = LGraphCanvas.node_colors[value].bgcolor;
                    }
                    else {
                        console.warn("unexpected color: " + value);
                    }
                    break;
                default:
                    node.setProperty(name, value);
                    break;
            }
            graphcanvas.graph.afterChange();
            graphcanvas.dirty_canvas = true;
        };
        panel.addWidget("string", "Title", node.title, {}, fUpdate);
        panel.addWidget("combo", "Mode", exports.LiteGraph.NODE_MODES[node.mode], { values: exports.LiteGraph.NODE_MODES }, fUpdate);
        var nodeCol = "";
        if (node.color !== undefined) {
            nodeCol = Object.keys(LGraphCanvas.node_colors).filter(function (nK) { return LGraphCanvas.node_colors[nK].color == node.color; });
        }
        panel.addWidget("combo", "Color", nodeCol, { values: Object.keys(LGraphCanvas.node_colors) }, fUpdate);
        for (var pName in node.properties) {
            var value = node.properties[pName];
            var info = node.getPropertyInfo(pName);
            var type = info.type || "string";
            //in case the user wants control over the side panel widget
            if (node.onAddPropertyToPanel && node.onAddPropertyToPanel(pName, panel))
                continue;
            panel.addWidget(info.widget || info.type, pName, value, info, fUpdate);
        }
        panel.addSeparator();
        if (node.onShowCustomPanelInfo)
            node.onShowCustomPanelInfo(panel);
        panel.footer.innerHTML = ""; // clear
        panel.addButton("Delete", function () {
            if (node.block_delete)
                return;
            node.graph.remove(node);
            panel.close();
        }).classList.add("delete");
    }
    panel.inner_showCodePad = function (propname) {
        panel.classList.remove("settings");
        panel.classList.add("centered");
        /*if(window.CodeFlask) //disabled for now
        {
            panel.content.innerHTML = "<div class='code'></div>";
            var flask = new CodeFlask( "div.code", { language: 'js' });
            flask.updateCode(node.properties[propname]);
            flask.onUpdate( function(code) {
                node.setProperty(propname, code);
            });
        }
        else
        {*/
        panel.alt_content.innerHTML = "<textarea class='code'></textarea>";
        var textarea = panel.alt_content.querySelector("textarea");
        var fDoneWith = function () {
            panel.toggleAltContent(false); //if(node_prop_div) node_prop_div.style.display = "block"; // panel.close();
            panel.toggleFooterVisibility(true);
            textarea.parentNode.removeChild(textarea);
            panel.classList.add("settings");
            panel.classList.remove("centered");
            inner_refresh();
        };
        textarea.value = node.properties[propname];
        textarea.addEventListener("keydown", function (e) {
            if (e.code == "Enter" && e.ctrlKey) {
                node.setProperty(propname, textarea.value);
                fDoneWith();
            }
        });
        panel.toggleAltContent(true);
        panel.toggleFooterVisibility(false);
        textarea.style.height = "calc(100% - 40px)";
        /*}*/
        var assign = panel.addButton("Assign", function () {
            node.setProperty(propname, textarea.value);
            fDoneWith();
        });
        panel.alt_content.appendChild(assign); //panel.content.appendChild(assign);
        var button = panel.addButton("Close", fDoneWith);
        button.style.float = "right";
        panel.alt_content.appendChild(button); // panel.content.appendChild(button);
    };
    inner_refresh();
    this.canvas.parentNode.appendChild(panel);
};
LGraphCanvas.prototype.showSubgraphPropertiesDialog = function (node) {
    console.log("showing subgraph properties dialog");
    var old_panel = this.canvas.parentNode.querySelector(".subgraph_dialog");
    if (old_panel)
        old_panel.close();
    var panel = this.createPanel("Subgraph Inputs", { closable: true, width: 500 });
    panel.node = node;
    panel.classList.add("subgraph_dialog");
    function inner_refresh() {
        panel.clear();
        //show currents
        if (node.inputs)
            for (var i = 0; i < node.inputs.length; ++i) {
                var input = node.inputs[i];
                if (input.not_subgraph_input)
                    continue;
                var html = "<button>&#10005;</button> <span class='bullet_icon'></span><span class='name'></span><span class='type'></span>";
                var elem = panel.addHTML(html, "subgraph_property");
                elem.dataset["name"] = input.name;
                elem.dataset["slot"] = i;
                elem.querySelector(".name").innerText = input.name;
                elem.querySelector(".type").innerText = input.type;
                elem.querySelector("button").addEventListener("click", function (e) {
                    node.removeInput(Number(this.parentNode.dataset["slot"]));
                    inner_refresh();
                });
            }
    }
    //add extra
    var html = " + <span class='label'>Name</span><input class='name'/><span class='label'>Type</span><input class='type'></input><button>+</button>";
    var elem = panel.addHTML(html, "subgraph_property extra", true);
    elem.querySelector("button").addEventListener("click", function (e) {
        var elem = this.parentNode;
        var name = elem.querySelector(".name").value;
        var type = elem.querySelector(".type").value;
        if (!name || node.findInputSlot(name) != -1)
            return;
        node.addInput(name, type);
        elem.querySelector(".name").value = "";
        elem.querySelector(".type").value = "";
        inner_refresh();
    });
    inner_refresh();
    this.canvas.parentNode.appendChild(panel);
    return panel;
};
LGraphCanvas.prototype.showSubgraphPropertiesDialogRight = function (node) {
    // console.log("showing subgraph properties dialog");
    var that = this;
    // old_panel if old_panel is exist close it
    var old_panel = this.canvas.parentNode.querySelector(".subgraph_dialog");
    if (old_panel)
        old_panel.close();
    // new panel
    var panel = this.createPanel("Subgraph Outputs", { closable: true, width: 500 });
    panel.node = node;
    panel.classList.add("subgraph_dialog");
    function inner_refresh() {
        panel.clear();
        //show currents
        if (node.outputs)
            for (var i = 0; i < node.outputs.length; ++i) {
                var input = node.outputs[i];
                if (input.not_subgraph_output)
                    continue;
                var html = "<button>&#10005;</button> <span class='bullet_icon'></span><span class='name'></span><span class='type'></span>";
                var elem = panel.addHTML(html, "subgraph_property");
                elem.dataset["name"] = input.name;
                elem.dataset["slot"] = i;
                elem.querySelector(".name").innerText = input.name;
                elem.querySelector(".type").innerText = input.type;
                elem.querySelector("button").addEventListener("click", function (e) {
                    node.removeOutput(Number(this.parentNode.dataset["slot"]));
                    inner_refresh();
                });
            }
    }
    //add extra
    var html = " + <span class='label'>Name</span><input class='name'/><span class='label'>Type</span><input class='type'></input><button>+</button>";
    var elem = panel.addHTML(html, "subgraph_property extra", true);
    elem.querySelector(".name").addEventListener("keydown", function (e) {
        if (e.keyCode == 13) {
            addOutput.apply(this);
        }
    });
    elem.querySelector("button").addEventListener("click", function (e) {
        addOutput.apply(this);
    });
    function addOutput() {
        var elem = this.parentNode;
        var name = elem.querySelector(".name").value;
        var type = elem.querySelector(".type").value;
        if (!name || node.findOutputSlot(name) != -1)
            return;
        node.addOutput(name, type);
        elem.querySelector(".name").value = "";
        elem.querySelector(".type").value = "";
        inner_refresh();
    }
    inner_refresh();
    this.canvas.parentNode.appendChild(panel);
    return panel;
};
LGraphCanvas.prototype.checkPanels = function () {
    if (!this.canvas)
        return;
    var panels = this.canvas.parentNode.querySelectorAll(".litegraph.dialog");
    for (var i = 0; i < panels.length; ++i) {
        var panel = panels[i];
        if (!panel.node)
            continue;
        if (!panel.node.graph || panel.graph != this.graph)
            panel.close();
    }
};
LGraphCanvas.onMenuNodeCollapse = function (value, options, e, menu, node) {
    node.graph.beforeChange( /*?*/);
    var fApplyMultiNode = function (node) {
        node.collapse();
    };
    var graphcanvas = LGraphCanvas.active_canvas;
    if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
        fApplyMultiNode(node);
    }
    else {
        for (var i in graphcanvas.selected_nodes) {
            fApplyMultiNode(graphcanvas.selected_nodes[i]);
        }
    }
    node.graph.afterChange( /*?*/);
};
LGraphCanvas.onMenuNodePin = function (value, options, e, menu, node) {
    node.pin();
};
LGraphCanvas.onMenuNodeMode = function (value, options, e, menu, node) {
    new exports.LiteGraph.ContextMenu(exports.LiteGraph.NODE_MODES, { event: e, callback: inner_clicked, parentMenu: menu, node: node });
    function inner_clicked(v) {
        if (!node) {
            return;
        }
        var kV = Object.values(exports.LiteGraph.NODE_MODES).indexOf(v);
        var fApplyMultiNode = function (node) {
            if (kV >= 0 && exports.LiteGraph.NODE_MODES[kV])
                node.changeMode(kV);
            else {
                console.warn("unexpected mode: " + v);
                node.changeMode(exports.LiteGraph.ALWAYS);
            }
        };
        var graphcanvas = LGraphCanvas.active_canvas;
        if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
            fApplyMultiNode(node);
        }
        else {
            for (var i in graphcanvas.selected_nodes) {
                fApplyMultiNode(graphcanvas.selected_nodes[i]);
            }
        }
    }
    return false;
};
LGraphCanvas.onMenuNodeColors = function (value, options, e, menu, node) {
    if (!node) {
        throw "no node for color";
    }
    var values = [];
    values.push({
        value: null,
        content: "<span style='display: block; padding-left: 4px;'>No color</span>"
    });
    for (var i in LGraphCanvas.node_colors) {
        var color = LGraphCanvas.node_colors[i];
        var value = {
            value: i,
            content: "<span style='display: block; color: #999; padding-left: 4px; border-left: 8px solid " +
                color.color +
                "; background-color:" +
                color.bgcolor +
                "'>" +
                i +
                "</span>"
        };
        values.push(value);
    }
    new exports.LiteGraph.ContextMenu(values, {
        event: e,
        callback: inner_clicked,
        parentMenu: menu,
        node: node
    });
    function inner_clicked(v) {
        if (!node) {
            return;
        }
        var color = v.value ? LGraphCanvas.node_colors[v.value] : null;
        var fApplyColor = function (node) {
            if (color) {
                if (node.constructor === exports.LiteGraph.LGraphGroup) {
                    node.color = color.groupcolor;
                }
                else {
                    node.color = color.color;
                    node.bgcolor = color.bgcolor;
                }
            }
            else {
                delete node.color;
                delete node.bgcolor;
            }
        };
        var graphcanvas = LGraphCanvas.active_canvas;
        if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
            fApplyColor(node);
        }
        else {
            for (var i in graphcanvas.selected_nodes) {
                fApplyColor(graphcanvas.selected_nodes[i]);
            }
        }
        node.setDirtyCanvas(true, true);
    }
    return false;
};
LGraphCanvas.onMenuNodeShapes = function (value, options, e, menu, node) {
    if (!node) {
        throw "no node passed";
    }
    new exports.LiteGraph.ContextMenu(exports.LiteGraph.VALID_SHAPES, {
        event: e,
        callback: inner_clicked,
        parentMenu: menu,
        node: node
    });
    function inner_clicked(v) {
        if (!node) {
            return;
        }
        node.graph.beforeChange( /*?*/); //node
        var fApplyMultiNode = function (node) {
            node.shape = v;
        };
        var graphcanvas = LGraphCanvas.active_canvas;
        if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
            fApplyMultiNode(node);
        }
        else {
            for (var i in graphcanvas.selected_nodes) {
                fApplyMultiNode(graphcanvas.selected_nodes[i]);
            }
        }
        node.graph.afterChange( /*?*/); //node
        node.setDirtyCanvas(true);
    }
    return false;
};
LGraphCanvas.onMenuNodeRemove = function (value, options, e, menu, node) {
    if (!node) {
        throw "no node passed";
    }
    var graph = node.graph;
    graph.beforeChange();
    var fApplyMultiNode = function (node) {
        if (node.removable === false) {
            return;
        }
        graph.remove(node);
    };
    var graphcanvas = LGraphCanvas.active_canvas;
    if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
        fApplyMultiNode(node);
    }
    else {
        for (var i in graphcanvas.selected_nodes) {
            fApplyMultiNode(graphcanvas.selected_nodes[i]);
        }
    }
    graph.afterChange();
    node.setDirtyCanvas(true, true);
};
LGraphCanvas.onMenuNodeToSubgraph = function (value, options, e, menu, node) {
    var graph = node.graph;
    var graphcanvas = LGraphCanvas.active_canvas;
    if (!graphcanvas) //??
        return;
    var nodes_list = Object.values(graphcanvas.selected_nodes || {});
    if (!nodes_list.length)
        nodes_list = [node];
    var subgraph_node = exports.LiteGraph.createNode("graph/subgraph");
    subgraph_node.pos = node.pos.concat();
    graph.add(subgraph_node);
    subgraph_node.buildFromNodes(nodes_list);
    graphcanvas.deselectAllNodes();
    node.setDirtyCanvas(true, true);
};
LGraphCanvas.onMenuNodeClone = function (value, options, e, menu, node) {
    node.graph.beforeChange();
    var newSelected = {};
    var fApplyMultiNode = function (node) {
        if (node.clonable === false) {
            return;
        }
        var newnode = node.clone();
        if (!newnode) {
            return;
        }
        newnode.pos = [node.pos[0] + 5, node.pos[1] + 5];
        node.graph.add(newnode);
        newSelected[newnode.id] = newnode;
    };
    var graphcanvas = LGraphCanvas.active_canvas;
    if (!graphcanvas.selected_nodes || Object.keys(graphcanvas.selected_nodes).length <= 1) {
        fApplyMultiNode(node);
    }
    else {
        for (var i in graphcanvas.selected_nodes) {
            fApplyMultiNode(graphcanvas.selected_nodes[i]);
        }
    }
    if (Object.keys(newSelected).length) {
        graphcanvas.selectNodes(newSelected);
    }
    node.graph.afterChange();
    node.setDirtyCanvas(true, true);
};
LGraphCanvas.node_colors = {
    red: { color: "#322", bgcolor: "#533", groupcolor: "#A88" },
    brown: { color: "#332922", bgcolor: "#593930", groupcolor: "#b06634" },
    green: { color: "#232", bgcolor: "#353", groupcolor: "#8A8" },
    blue: { color: "#223", bgcolor: "#335", groupcolor: "#88A" },
    pale_blue: {
        color: "#2a363b",
        bgcolor: "#3f5159",
        groupcolor: "#3f789e"
    },
    cyan: { color: "#233", bgcolor: "#355", groupcolor: "#8AA" },
    purple: { color: "#323", bgcolor: "#535", groupcolor: "#a1309b" },
    yellow: { color: "#432", bgcolor: "#653", groupcolor: "#b58b2a" },
    black: { color: "#222", bgcolor: "#000", groupcolor: "#444" }
};
LGraphCanvas.prototype.getCanvasMenuOptions = function () {
    var options = null;
    var that = this;
    if (this.getMenuOptions) {
        options = this.getMenuOptions();
    }
    else {
        options = [
            {
                content: "Add Node",
                has_submenu: true,
                callback: LGraphCanvas.onMenuAdd
            },
            { content: "Add Group", callback: LGraphCanvas.onGroupAdd },
        ];
        /*if (LiteGraph.showCanvasOptions){
            options.push({ content: "Options", callback: that.showShowGraphOptionsPanel });
        }*/
        if (Object.keys(this.selected_nodes).length > 1) {
            options.push({
                content: "Align",
                has_submenu: true,
                callback: LGraphCanvas.onGroupAlign,
            });
        }
        if (this._graph_stack && this._graph_stack.length > 0) {
            options.push(null, {
                content: "Close subgraph",
                callback: this.closeSubgraph.bind(this)
            });
        }
    }
    if (this.getExtraMenuOptions) {
        var extra = this.getExtraMenuOptions(this, options);
        if (extra) {
            options = options.concat(extra);
        }
    }
    return options;
};
//called by processContextMenu to extract the menu list
LGraphCanvas.prototype.getNodeMenuOptions = function (node) {
    var options = null;
    if (node.getMenuOptions) {
        options = node.getMenuOptions(this);
    }
    else {
        options = [
            {
                content: "Inputs",
                has_submenu: true,
                disabled: true,
                callback: LGraphCanvas.showMenuNodeOptionalInputs
            },
            {
                content: "Outputs",
                has_submenu: true,
                disabled: true,
                callback: LGraphCanvas.showMenuNodeOptionalOutputs
            },
            null,
            {
                content: "Properties",
                has_submenu: true,
                callback: LGraphCanvas.onShowMenuNodeProperties
            },
            null,
            {
                content: "Title",
                callback: LGraphCanvas.onShowPropertyEditor
            },
            {
                content: "Mode",
                has_submenu: true,
                callback: LGraphCanvas.onMenuNodeMode
            }
        ];
        if (node.resizable !== false) {
            options.push({
                content: "Resize", callback: LGraphCanvas.onMenuResizeNode
            });
        }
        options.push({
            content: "Collapse",
            callback: LGraphCanvas.onMenuNodeCollapse
        }, { content: "Pin", callback: LGraphCanvas.onMenuNodePin }, {
            content: "Colors",
            has_submenu: true,
            callback: LGraphCanvas.onMenuNodeColors
        }, {
            content: "Shapes",
            has_submenu: true,
            callback: LGraphCanvas.onMenuNodeShapes
        }, null);
    }
    if (node.onGetInputs) {
        var inputs = node.onGetInputs();
        if (inputs && inputs.length) {
            options[0].disabled = false;
        }
    }
    if (node.onGetOutputs) {
        var outputs = node.onGetOutputs();
        if (outputs && outputs.length) {
            options[1].disabled = false;
        }
    }
    if (node.getExtraMenuOptions) {
        var extra = node.getExtraMenuOptions(this, options);
        if (extra) {
            extra.push(null);
            options = extra.concat(options);
        }
    }
    if (node.clonable !== false) {
        options.push({
            content: "Clone",
            callback: LGraphCanvas.onMenuNodeClone
        });
    }
    if (0) //TODO
        options.push({
            content: "To Subgraph",
            callback: LGraphCanvas.onMenuNodeToSubgraph
        });
    if (Object.keys(this.selected_nodes).length > 1) {
        options.push({
            content: "Align Selected To",
            has_submenu: true,
            callback: LGraphCanvas.onNodeAlign,
        });
    }
    options.push(null, {
        content: "Remove",
        disabled: !(node.removable !== false && !node.block_delete),
        callback: LGraphCanvas.onMenuNodeRemove
    });
    if (node.graph && node.graph.onGetNodeMenuOptions) {
        node.graph.onGetNodeMenuOptions(options, node);
    }
    return options;
};
LGraphCanvas.prototype.getGroupMenuOptions = function (node) {
    var o = [
        { content: "Title", callback: LGraphCanvas.onShowPropertyEditor },
        {
            content: "Color",
            has_submenu: true,
            callback: LGraphCanvas.onMenuNodeColors
        },
        {
            content: "Font size",
            property: "font_size",
            type: "Number",
            callback: LGraphCanvas.onShowPropertyEditor
        },
        null,
        { content: "Remove", callback: LGraphCanvas.onMenuNodeRemove }
    ];
    return o;
};
LGraphCanvas.prototype.processContextMenu = function (node, event) {
    var that = this;
    var canvas = LGraphCanvas.active_canvas;
    var ref_window = canvas.getCanvasWindow();
    var menu_info = null;
    var options = {
        event: event,
        callback: inner_option_clicked,
        extra: node
    };
    if (node)
        options.title = node.type;
    //check if mouse is in input
    var slot = null;
    if (node) {
        slot = node.getSlotInPosition(event.canvasX, event.canvasY);
        LGraphCanvas.active_node = node;
    }
    if (slot) {
        //on slot
        menu_info = [];
        if (node.getSlotMenuOptions) {
            menu_info = node.getSlotMenuOptions(slot);
        }
        else {
            if (slot &&
                slot.output &&
                slot.output.links &&
                slot.output.links.length) {
                menu_info.push({ content: "Disconnect Links", slot: slot });
            }
            var _slot = slot.input || slot.output;
            if (_slot.removable) {
                menu_info.push(_slot.locked
                    ? "Cannot remove"
                    : { content: "Remove Slot", slot: slot });
            }
            if (!_slot.nameLocked) {
                menu_info.push({ content: "Rename Slot", slot: slot });
            }
        }
        options.title =
            (slot.input ? slot.input.type : slot.output.type) || "*";
        if (slot.input && slot.input.type == exports.LiteGraph.ACTION) {
            options.title = "Action";
        }
        if (slot.output && slot.output.type == exports.LiteGraph.EVENT) {
            options.title = "Event";
        }
    }
    else {
        if (node) {
            //on node
            menu_info = this.getNodeMenuOptions(node);
        }
        else {
            menu_info = this.getCanvasMenuOptions();
            var group = this.graph.getGroupOnPos(event.canvasX, event.canvasY);
            if (group) {
                //on group
                menu_info.push(null, {
                    content: "Edit Group",
                    has_submenu: true,
                    submenu: {
                        title: "Group",
                        extra: group,
                        options: this.getGroupMenuOptions(group)
                    }
                });
            }
        }
    }
    //show menu
    if (!menu_info) {
        return;
    }
    var menu = new exports.LiteGraph.ContextMenu(menu_info, options, ref_window);
    function inner_option_clicked(v, options, e) {
        if (!v) {
            return;
        }
        if (v.content == "Remove Slot") {
            var info = v.slot;
            node.graph.beforeChange();
            if (info.input) {
                node.removeInput(info.slot);
            }
            else if (info.output) {
                node.removeOutput(info.slot);
            }
            node.graph.afterChange();
            return;
        }
        else if (v.content == "Disconnect Links") {
            var info = v.slot;
            node.graph.beforeChange();
            if (info.output) {
                node.disconnectOutput(info.slot);
            }
            else if (info.input) {
                node.disconnectInput(info.slot);
            }
            node.graph.afterChange();
            return;
        }
        else if (v.content == "Rename Slot") {
            var info = v.slot;
            var slot_info = info.input
                ? node.getInputInfo(info.slot)
                : node.getOutputInfo(info.slot);
            var dialog = that.createDialog("<span class='name'>Name</span><input autofocus type='text'/><button>OK</button>", options);
            var input = dialog.querySelector("input");
            if (input && slot_info) {
                input.value = slot_info.label || "";
            }
            var inner = function () {
                node.graph.beforeChange();
                if (input.value) {
                    if (slot_info) {
                        slot_info.label = input.value;
                    }
                    that.setDirty(true);
                }
                dialog.close();
                node.graph.afterChange();
            };
            dialog.querySelector("button").addEventListener("click", inner);
            input.addEventListener("keydown", function (e) {
                dialog.is_modified = true;
                if (e.keyCode == 27) {
                    //ESC
                    dialog.close();
                }
                else if (e.keyCode == 13) {
                    inner(); // save
                }
                else if (e.keyCode != 13 && e.target.localName != "textarea") {
                    return;
                }
                e.preventDefault();
                e.stopPropagation();
            });
            input.focus();
        }
        //if(v.callback)
        //	return v.callback.call(that, node, options, e, menu, that, event );
    }
};
//API *************************************************
function compareObjects(a, b) {
    for (var i in a) {
        if (a[i] != b[i]) {
            return false;
        }
    }
    return true;
}
exports.LiteGraph.compareObjects = compareObjects;
function distance(a, b) {
    return Math.sqrt((b[0] - a[0]) * (b[0] - a[0]) + (b[1] - a[1]) * (b[1] - a[1]));
}
exports.LiteGraph.distance = distance;
function colorToString(c) {
    return ("rgba(" +
        Math.round(c[0] * 255).toFixed() +
        "," +
        Math.round(c[1] * 255).toFixed() +
        "," +
        Math.round(c[2] * 255).toFixed() +
        "," +
        (c.length == 4 ? c[3].toFixed(2) : "1.0") +
        ")");
}
exports.LiteGraph.colorToString = colorToString;
function isInsideRectangle(x, y, left, top, width, height) {
    if (left < x && left + width > x && top < y && top + height > y) {
        return true;
    }
    return false;
}
exports.LiteGraph.isInsideRectangle = isInsideRectangle;
//[minx,miny,maxx,maxy]
function growBounding(bounding, x, y) {
    if (x < bounding[0]) {
        bounding[0] = x;
    }
    else if (x > bounding[2]) {
        bounding[2] = x;
    }
    if (y < bounding[1]) {
        bounding[1] = y;
    }
    else if (y > bounding[3]) {
        bounding[3] = y;
    }
}
exports.LiteGraph.growBounding = growBounding;
//point inside bounding box
function isInsideBounding(p, bb) {
    if (p[0] < bb[0][0] ||
        p[1] < bb[0][1] ||
        p[0] > bb[1][0] ||
        p[1] > bb[1][1]) {
        return false;
    }
    return true;
}
exports.LiteGraph.isInsideBounding = isInsideBounding;
//bounding overlap, format: [ startx, starty, width, height ]
function overlapBounding(a, b) {
    var A_end_x = a[0] + a[2];
    var A_end_y = a[1] + a[3];
    var B_end_x = b[0] + b[2];
    var B_end_y = b[1] + b[3];
    if (a[0] > B_end_x ||
        a[1] > B_end_y ||
        A_end_x < b[0] ||
        A_end_y < b[1]) {
        return false;
    }
    return true;
}
exports.LiteGraph.overlapBounding = overlapBounding;
//Convert a hex value to its decimal value - the inputted hex must be in the
//	format of a hex triplet - the kind we use for HTML colours. The function
//	will return an array with three values.
function hex2num(hex) {
    if (hex.charAt(0) == "#") {
        hex = hex.slice(1);
    } //Remove the '#' char - if there is one.
    hex = hex.toUpperCase();
    var hex_alphabets = "0123456789ABCDEF";
    var value = new Array(3);
    var k = 0;
    var int1, int2;
    for (var i = 0; i < 6; i += 2) {
        int1 = hex_alphabets.indexOf(hex.charAt(i));
        int2 = hex_alphabets.indexOf(hex.charAt(i + 1));
        value[k] = int1 * 16 + int2;
        k++;
    }
    return value;
}
exports.LiteGraph.hex2num = hex2num;
//Give a array with three values as the argument and the function will return
//	the corresponding hex triplet.
function num2hex(triplet) {
    var hex_alphabets = "0123456789ABCDEF";
    var hex = "#";
    var int1, int2;
    for (var i = 0; i < 3; i++) {
        int1 = triplet[i] / 16;
        int2 = triplet[i] % 16;
        hex += hex_alphabets.charAt(int1) + hex_alphabets.charAt(int2);
    }
    return hex;
}
exports.LiteGraph.num2hex = num2hex;
/* LiteGraph GUI elements used for canvas editing *************************************/
/**
 * ContextMenu from LiteGUI
 *
 * @class ContextMenu
 * @constructor
 * @param {Array} values (allows object { title: "Nice text", callback: function ... })
 * @param {Object} options [optional] Some options:\
 * - title: title to show on top of the menu
 * - callback: function to call when an option is clicked, it receives the item information
 * - ignore_item_callbacks: ignores the callback inside the item, it just calls the options.callback
 * - event: you can pass a MouseEvent, this way the ContextMenu appears in that position
 */
function ContextMenu(values, options) {
    options = options || {};
    this.options = options;
    var that = this;
    //to link a menu with its parent
    if (options.parentMenu) {
        if (options.parentMenu.constructor !== this.constructor) {
            console.error("parentMenu must be of class ContextMenu, ignoring it");
            options.parentMenu = null;
        }
        else {
            this.parentMenu = options.parentMenu;
            this.parentMenu.lock = true;
            this.parentMenu.current_submenu = this;
        }
    }
    var eventClass = null;
    if (options.event) //use strings because comparing classes between windows doesnt work
        eventClass = options.event.constructor.name;
    if (eventClass !== "MouseEvent" &&
        eventClass !== "CustomEvent" &&
        eventClass !== "PointerEvent") {
        console.error("Event passed to ContextMenu is not of type MouseEvent or CustomEvent. Ignoring it. (" + eventClass + ")");
        options.event = null;
    }
    var root = document.createElement("div");
    root.className = "litegraph litecontextmenu litemenubar-panel";
    if (options.className) {
        root.className += " " + options.className;
    }
    root.style.minWidth = 100;
    root.style.minHeight = 100;
    root.style.pointerEvents = "none";
    setTimeout(function () {
        root.style.pointerEvents = "auto";
    }, 100); //delay so the mouse up event is not caught by this element
    //this prevents the default context browser menu to open in case this menu was created when pressing right button
    exports.LiteGraph.pointerListenerAdd(root, "up", function (e) {
        //console.log("pointerevents: ContextMenu up root prevent");
        e.preventDefault();
        return true;
    }, true);
    root.addEventListener("contextmenu", function (e) {
        if (e.button != 2) {
            //right button
            return false;
        }
        e.preventDefault();
        return false;
    }, true);
    exports.LiteGraph.pointerListenerAdd(root, "down", function (e) {
        //console.log("pointerevents: ContextMenu down");
        if (e.button == 2) {
            that.close();
            e.preventDefault();
            return true;
        }
    }, true);
    function on_mouse_wheel(e) {
        var pos = parseInt(root.style.top);
        root.style.top =
            (pos + e.deltaY * options.scroll_speed).toFixed() + "px";
        e.preventDefault();
        return true;
    }
    if (!options.scroll_speed) {
        options.scroll_speed = 0.1;
    }
    root.addEventListener("wheel", on_mouse_wheel, true);
    root.addEventListener("mousewheel", on_mouse_wheel, true);
    this.root = root;
    //title
    if (options.title) {
        var element = document.createElement("div");
        element.className = "litemenu-title";
        element.innerHTML = options.title;
        root.appendChild(element);
    }
    //entries
    var num = 0;
    for (var i = 0; i < values.length; i++) {
        var name = values.constructor == Array ? values[i] : i;
        if (name != null && name.constructor !== String) {
            name = name.content === undefined ? String(name) : name.content;
        }
        var value = values[i];
        this.addItem(name, value, options);
        num++;
    }
    //close on leave? touch enabled devices won't work TODO use a global device detector and condition on that
    /*LiteGraph.pointerListenerAdd(root,"leave", function(e) {
        console.log("pointerevents: ContextMenu leave");
        if (that.lock) {
            return;
        }
        if (root.closing_timer) {
            clearTimeout(root.closing_timer);
        }
        root.closing_timer = setTimeout(that.close.bind(that, e), 500);
        //that.close(e);
    });*/
    exports.LiteGraph.pointerListenerAdd(root, "enter", function (e) {
        //console.log("pointerevents: ContextMenu enter");
        if (root.closing_timer) {
            clearTimeout(root.closing_timer);
        }
    });
    //insert before checking position
    var root_document = document;
    if (options.event) {
        root_document = options.event.target.ownerDocument;
    }
    if (!root_document) {
        root_document = document;
    }
    if (root_document.fullscreenElement)
        root_document.fullscreenElement.appendChild(root);
    else
        root_document.body.appendChild(root);
    //compute best position
    var left = options.left || 0;
    var top = options.top || 0;
    if (options.event) {
        left = options.event.clientX - 10;
        top = options.event.clientY - 10;
        if (options.title) {
            top -= 20;
        }
        if (options.parentMenu) {
            var rect = options.parentMenu.root.getBoundingClientRect();
            left = rect.left + rect.width;
        }
        var body_rect = document.body.getBoundingClientRect();
        var root_rect = root.getBoundingClientRect();
        if (body_rect.height == 0)
            console.error("document.body height is 0. That is dangerous, set html,body { height: 100%; }");
        if (body_rect.width && left > body_rect.width - root_rect.width - 10) {
            left = body_rect.width - root_rect.width - 10;
        }
        if (body_rect.height && top > body_rect.height - root_rect.height - 10) {
            top = body_rect.height - root_rect.height - 10;
        }
    }
    root.style.left = left + "px";
    root.style.top = top + "px";
    if (options.scale) {
        root.style.transform = "scale(" + options.scale + ")";
    }
}
ContextMenu.prototype.addItem = function (name, value, options) {
    var that = this;
    options = options || {};
    var element = document.createElement("div");
    element.className = "litemenu-entry submenu";
    var disabled = false;
    if (value === null) {
        element.classList.add("separator");
        //element.innerHTML = "<hr/>"
        //continue;
    }
    else {
        element.innerHTML = value && value.title ? value.title : name;
        element.value = value;
        if (value) {
            if (value.disabled) {
                disabled = true;
                element.classList.add("disabled");
            }
            if (value.submenu || value.has_submenu) {
                element.classList.add("has_submenu");
            }
        }
        if (typeof value == "function") {
            element.dataset["value"] = name;
            element.onclick_callback = value;
        }
        else {
            element.dataset["value"] = value;
        }
        if (value.className) {
            element.className += " " + value.className;
        }
    }
    this.root.appendChild(element);
    if (!disabled) {
        element.addEventListener("click", inner_onclick);
    }
    if (!disabled && options.autoopen) {
        exports.LiteGraph.pointerListenerAdd(element, "enter", inner_over);
    }
    function inner_over(e) {
        var value = this.value;
        if (!value || !value.has_submenu) {
            return;
        }
        //if it is a submenu, autoopen like the item was clicked
        inner_onclick.call(this, e);
    }
    //menu option clicked
    function inner_onclick(e) {
        var value = this.value;
        var close_parent = true;
        if (that.current_submenu) {
            that.current_submenu.close(e);
        }
        //global callback
        if (options.callback) {
            var r = options.callback.call(this, value, options, e, that, options.node);
            if (r === true) {
                close_parent = false;
            }
        }
        //special cases
        if (value) {
            if (value.callback &&
                !options.ignore_item_callbacks &&
                value.disabled !== true) {
                //item callback
                var r = value.callback.call(this, value, options, e, that, options.extra);
                if (r === true) {
                    close_parent = false;
                }
            }
            if (value.submenu) {
                if (!value.submenu.options) {
                    throw "ContextMenu submenu needs options";
                }
                var submenu = new that.constructor(value.submenu.options, {
                    callback: value.submenu.callback,
                    event: e,
                    parentMenu: that,
                    ignore_item_callbacks: value.submenu.ignore_item_callbacks,
                    title: value.submenu.title,
                    extra: value.submenu.extra,
                    autoopen: options.autoopen
                });
                close_parent = false;
            }
        }
        if (close_parent && !that.lock) {
            that.close();
        }
    }
    return element;
};
ContextMenu.prototype.close = function (e, ignore_parent_menu) {
    if (this.root.parentNode) {
        this.root.parentNode.removeChild(this.root);
    }
    if (this.parentMenu && !ignore_parent_menu) {
        this.parentMenu.lock = false;
        this.parentMenu.current_submenu = null;
        if (e === undefined) {
            this.parentMenu.close();
        }
        else if (e &&
            !ContextMenu.isCursorOverElement(e, this.parentMenu.root)) {
            ContextMenu.trigger(this.parentMenu.root, exports.LiteGraph.pointerevents_method + "leave", e);
        }
    }
    if (this.current_submenu) {
        this.current_submenu.close(e, true);
    }
    if (this.root.closing_timer) {
        clearTimeout(this.root.closing_timer);
    }
    // TODO implement : LiteGraph.contextMenuClosed(); :: keep track of opened / closed / current ContextMenu
    // on key press, allow filtering/selecting the context menu elements
};
//this code is used to trigger events easily (used in the context menu mouseleave
ContextMenu.trigger = function (element, event_name, params, origin) {
    var evt = document.createEvent("CustomEvent");
    evt.initCustomEvent(event_name, true, true, params); //canBubble, cancelable, detail
    evt.srcElement = origin;
    if (element.dispatchEvent) {
        element.dispatchEvent(evt);
    }
    else if (element.__events) {
        element.__events.dispatchEvent(evt);
    }
    //else nothing seems binded here so nothing to do
    return evt;
};
//returns the top most menu
ContextMenu.prototype.getTopMenu = function () {
    if (this.options.parentMenu) {
        return this.options.parentMenu.getTopMenu();
    }
    return this;
};
ContextMenu.prototype.getFirstEvent = function () {
    if (this.options.parentMenu) {
        return this.options.parentMenu.getFirstEvent();
    }
    return this.options.event;
};
ContextMenu.isCursorOverElement = function (event, element) {
    var left = event.clientX;
    var top = event.clientY;
    var rect = element.getBoundingClientRect();
    if (!rect) {
        return false;
    }
    if (top > rect.top &&
        top < rect.top + rect.height &&
        left > rect.left &&
        left < rect.left + rect.width) {
        return true;
    }
    return false;
};
exports.LiteGraph.ContextMenu = ContextMenu;
exports.LiteGraph.closeAllContextMenus = function (ref_window) {
    ref_window = ref_window || window;
    var elements = ref_window.document.querySelectorAll(".litecontextmenu");
    if (!elements.length) {
        return;
    }
    var result = [];
    for (var i = 0; i < elements.length; i++) {
        result.push(elements[i]);
    }
    for (var i = 0; i < result.length; i++) {
        if (result[i].close) {
            result[i].close();
        }
        else if (result[i].parentNode) {
            result[i].parentNode.removeChild(result[i]);
        }
    }
};
exports.LiteGraph.extendClass = function (target, origin) {
    for (var i in origin) {
        //copy class properties
        if (target.hasOwnProperty(i)) {
            continue;
        }
        target[i] = origin[i];
    }
    if (origin.prototype) {
        //copy prototype properties
        for (var i in origin.prototype) {
            //only enumerable
            if (!origin.prototype.hasOwnProperty(i)) {
                continue;
            }
            if (target.prototype.hasOwnProperty(i)) {
                //avoid overwriting existing ones
                continue;
            }
            //copy getters
            if (origin.prototype.__lookupGetter__(i)) {
                target.prototype.__defineGetter__(i, origin.prototype.__lookupGetter__(i));
            }
            else {
                target.prototype[i] = origin.prototype[i];
            }
            //and setters
            if (origin.prototype.__lookupSetter__(i)) {
                target.prototype.__defineSetter__(i, origin.prototype.__lookupSetter__(i));
            }
        }
    }
};
//used by some widgets to render a curve editor
function CurveEditor(points) {
    this.points = points;
    this.selected = -1;
    this.nearest = -1;
    this.size = null; //stores last size used
    this.must_update = true;
    this.margin = 5;
}
CurveEditor.sampleCurve = function (f, points) {
    if (!points)
        return;
    for (var i = 0; i < points.length - 1; ++i) {
        var p = points[i];
        var pn = points[i + 1];
        if (pn[0] < f)
            continue;
        var r = (pn[0] - p[0]);
        if (Math.abs(r) < 0.00001)
            return p[1];
        var local_f = (f - p[0]) / r;
        return p[1] * (1.0 - local_f) + pn[1] * local_f;
    }
    return 0;
};
CurveEditor.prototype.draw = function (ctx, size, graphcanvas, background_color, line_color, inactive) {
    var points = this.points;
    if (!points)
        return;
    this.size = size;
    var w = size[0] - this.margin * 2;
    var h = size[1] - this.margin * 2;
    line_color = line_color || "#666";
    ctx.save();
    ctx.translate(this.margin, this.margin);
    if (background_color) {
        ctx.fillStyle = "#111";
        ctx.fillRect(0, 0, w, h);
        ctx.fillStyle = "#222";
        ctx.fillRect(w * 0.5, 0, 1, h);
        ctx.strokeStyle = "#333";
        ctx.strokeRect(0, 0, w, h);
    }
    ctx.strokeStyle = line_color;
    if (inactive)
        ctx.globalAlpha = 0.5;
    ctx.beginPath();
    for (var i = 0; i < points.length; ++i) {
        var p = points[i];
        ctx.lineTo(p[0] * w, (1.0 - p[1]) * h);
    }
    ctx.stroke();
    ctx.globalAlpha = 1;
    if (!inactive)
        for (var i = 0; i < points.length; ++i) {
            var p = points[i];
            ctx.fillStyle = this.selected == i ? "#FFF" : (this.nearest == i ? "#DDD" : "#AAA");
            ctx.beginPath();
            ctx.arc(p[0] * w, (1.0 - p[1]) * h, 2, 0, Math.PI * 2);
            ctx.fill();
        }
    ctx.restore();
};
//localpos is mouse in curve editor space
CurveEditor.prototype.onMouseDown = function (localpos, graphcanvas) {
    var points = this.points;
    if (!points)
        return;
    if (localpos[1] < 0)
        return;
    //this.captureInput(true);
    var w = this.size[0] - this.margin * 2;
    var h = this.size[1] - this.margin * 2;
    var x = localpos[0] - this.margin;
    var y = localpos[1] - this.margin;
    var pos = [x, y];
    var max_dist = 30 / graphcanvas.ds.scale;
    //search closer one
    this.selected = this.getCloserPoint(pos, max_dist);
    //create one
    if (this.selected == -1) {
        var point = [x / w, 1 - y / h];
        points.push(point);
        points.sort(function (a, b) { return a[0] - b[0]; });
        this.selected = points.indexOf(point);
        this.must_update = true;
    }
    if (this.selected != -1)
        return true;
};
CurveEditor.prototype.onMouseMove = function (localpos, graphcanvas) {
    var points = this.points;
    if (!points)
        return;
    var s = this.selected;
    if (s < 0)
        return;
    var x = (localpos[0] - this.margin) / (this.size[0] - this.margin * 2);
    var y = (localpos[1] - this.margin) / (this.size[1] - this.margin * 2);
    var curvepos = [(localpos[0] - this.margin), (localpos[1] - this.margin)];
    var max_dist = 30 / graphcanvas.ds.scale;
    this._nearest = this.getCloserPoint(curvepos, max_dist);
    var point = points[s];
    if (point) {
        var is_edge_point = s == 0 || s == points.length - 1;
        if (!is_edge_point && (localpos[0] < -10 || localpos[0] > this.size[0] + 10 || localpos[1] < -10 || localpos[1] > this.size[1] + 10)) {
            points.splice(s, 1);
            this.selected = -1;
            return;
        }
        if (!is_edge_point) //not edges
            point[0] = clamp(x, 0, 1);
        else
            point[0] = s == 0 ? 0 : 1;
        point[1] = 1.0 - clamp(y, 0, 1);
        points.sort(function (a, b) { return a[0] - b[0]; });
        this.selected = points.indexOf(point);
        this.must_update = true;
    }
};
CurveEditor.prototype.onMouseUp = function (localpos, graphcanvas) {
    this.selected = -1;
    return false;
};
CurveEditor.prototype.getCloserPoint = function (pos, max_dist) {
    var points = this.points;
    if (!points)
        return -1;
    max_dist = max_dist || 30;
    var w = (this.size[0] - this.margin * 2);
    var h = (this.size[1] - this.margin * 2);
    var num = points.length;
    var p2 = [0, 0];
    var min_dist = 1000000;
    var closest = -1;
    var last_valid = -1;
    for (var i = 0; i < num; ++i) {
        var p = points[i];
        p2[0] = p[0] * w;
        p2[1] = (1.0 - p[1]) * h;
        if (p2[0] < pos[0])
            last_valid = i;
        var dist = vec2.distance(pos, p2);
        if (dist > min_dist || dist > max_dist)
            continue;
        closest = i;
        min_dist = dist;
    }
    return closest;
};
exports.LiteGraph.CurveEditor = CurveEditor;
//used to create nodes from wrapping functions
exports.LiteGraph.getParameterNames = function (func) {
    return (func + "")
        .replace(/[/][/].*$/gm, "") // strip single-line comments
        .replace(/\s+/g, "") // strip white space
        .replace(/[/][*][^/*]*[*][/]/g, "") // strip multi-line comments  /**/
        .split("){", 1)[0]
        .replace(/^[^(]*[(]/, "") // extract the parameters
        .replace(/=[^,]+/g, "") // strip any ES6 defaults
        .split(",")
        .filter(Boolean); // split & filter [""]
};
/* helper for interaction: pointer, touch, mouse Listeners
used by LGraphCanvas DragAndScale ContextMenu*/
exports.LiteGraph.pointerListenerAdd = function (oDOM, sEvIn, fCall, capture) {
    if (capture === void 0) { capture = false; }
    if (!oDOM || !oDOM.addEventListener || !sEvIn || typeof fCall !== "function") {
        //console.log("cant pointerListenerAdd "+oDOM+", "+sEvent+", "+fCall);
        return; // -- break --
    }
    var sMethod = exports.LiteGraph.pointerevents_method;
    var sEvent = sEvIn;
    // UNDER CONSTRUCTION
    // convert pointerevents to touch event when not available
    if (sMethod == "pointer" && !window.PointerEvent) {
        console.warn("sMethod=='pointer' && !window.PointerEvent");
        console.log("Converting pointer[" + sEvent + "] : down move up cancel enter TO touchstart touchmove touchend, etc ..");
        switch (sEvent) {
            case "down": {
                sMethod = "touch";
                sEvent = "start";
                break;
            }
            case "move": {
                sMethod = "touch";
                //sEvent = "move";
                break;
            }
            case "up": {
                sMethod = "touch";
                sEvent = "end";
                break;
            }
            case "cancel": {
                sMethod = "touch";
                //sEvent = "cancel";
                break;
            }
            case "enter": {
                console.log("debug: Should I send a move event?"); // ???
                break;
            }
            // case "over": case "out": not used at now
            default: {
                console.warn("PointerEvent not available in this browser ? The event " + sEvent + " would not be called");
            }
        }
    }
    switch (sEvent) {
        //both pointer and move events
        case "down":
        case "up":
        case "move":
        case "over":
        case "out":
        case "enter":
            {
                oDOM.addEventListener(sMethod + sEvent, fCall, capture);
            }
        // only pointerevents
        case "leave":
        case "cancel":
        case "gotpointercapture":
        case "lostpointercapture":
            {
                if (sMethod != "mouse") {
                    return oDOM.addEventListener(sMethod + sEvent, fCall, capture);
                }
            }
        // not "pointer" || "mouse"
        default:
            return oDOM.addEventListener(sEvent, fCall, capture);
    }
};
exports.LiteGraph.pointerListenerRemove = function (oDOM, sEvent, fCall, capture) {
    if (capture === void 0) { capture = false; }
    if (!oDOM || !oDOM.removeEventListener || !sEvent || typeof fCall !== "function") {
        //console.log("cant pointerListenerRemove "+oDOM+", "+sEvent+", "+fCall);
        return; // -- break --
    }
    switch (sEvent) {
        //both pointer and move events
        case "down":
        case "up":
        case "move":
        case "over":
        case "out":
        case "enter":
            {
                if (exports.LiteGraph.pointerevents_method == "pointer" || exports.LiteGraph.pointerevents_method == "mouse") {
                    oDOM.removeEventListener(exports.LiteGraph.pointerevents_method + sEvent, fCall, capture);
                }
            }
        // only pointerevents
        case "leave":
        case "cancel":
        case "gotpointercapture":
        case "lostpointercapture":
            {
                if (exports.LiteGraph.pointerevents_method == "pointer") {
                    return oDOM.removeEventListener(exports.LiteGraph.pointerevents_method + sEvent, fCall, capture);
                }
            }
        // not "pointer" || "mouse"
        default:
            return oDOM.removeEventListener(sEvent, fCall, capture);
    }
};
function clamp(v, a, b) {
    return a > v ? a : b < v ? b : v;
}
;
// global.clamp = clamp;
if (typeof window != "undefined" && !window["requestAnimationFrame"]) {
    window.requestAnimationFrame =
        window.webkitRequestAnimationFrame ||
            window.mozRequestAnimationFrame ||
            function (callback) {
                window.setTimeout(callback, 1000 / 60);
            };
}
// if (typeof exports != "undefined") {
//     exports.LiteGraph = LiteGraph;
//     exports.LGraph = LGraph;
//     exports.LLink = LLink;
//     exports.LGraphNode = LGraphNode;
//     exports.LGraphGroup = LGraphGroup;
//     exports.DragAndScale = DragAndScale;
//     exports.LGraphCanvas = LGraphCanvas;
//     exports.ContextMenu = ContextMenu;
// }
// module.exports = {
//     'LiteGraph': LiteGraph,
//     'LGraph': LGraph
// }
window.LiteGraph = exports.LiteGraph;

cc._RF.pop();

}).call(this,require("../../../../../../../../../../../../Applications/Cocos/Creator/2.4.6/CocosCreator.app/Contents/Resources/app.asar/node_modules/process/browser.js"))
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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