
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/Bezier/bezier.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'f3758ThLp5LMLWC8tV4c74a', 'bezier');
// Script/Common/Bezier/bezier.js

"use strict";

exports.__esModule = true;
exports.Bezier = void 0;

var _bezierUtils = require("./bezierUtils.js");

var _polyBezier = require("./poly-bezier.js");

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// math-inlining.
var abs = Math.abs,
    min = Math.min,
    max = Math.max,
    cos = Math.cos,
    sin = Math.sin,
    acos = Math.acos,
    sqrt = Math.sqrt;
var pi = Math.PI; // a zero coordinate, which is surprisingly useful

var ZERO = {
  x: 0,
  y: 0,
  z: 0
};
/**
 * Bezier curve constructor.
 *
 * ...docs pending...
 */

var Bezier = /*#__PURE__*/function () {
  function Bezier(coords) {
    var args = coords && coords.forEach ? coords : Array.from(arguments).slice();
    var coordlen = false;

    if (typeof args[0] === "object") {
      coordlen = args.length;
      var newargs = [];
      args.forEach(function (point) {
        ["x", "y", "z"].forEach(function (d) {
          if (typeof point[d] !== "undefined") {
            newargs.push(point[d]);
          }
        });
      });
      args = newargs;
    }

    var higher = false;
    var len = args.length;

    if (coordlen) {
      if (coordlen > 4) {
        if (arguments.length !== 1) {
          throw new Error("Only new Bezier(point[]) is accepted for 4th and higher order curves");
        }

        higher = true;
      }
    } else {
      if (len !== 6 && len !== 8 && len !== 9 && len !== 12) {
        if (arguments.length !== 1) {
          throw new Error("Only new Bezier(point[]) is accepted for 4th and higher order curves");
        }
      }
    }

    var _3d = this._3d = !higher && (len === 9 || len === 12) || coords && coords[0] && typeof coords[0].z !== "undefined";

    var points = this.points = [];

    for (var idx = 0, step = _3d ? 3 : 2; idx < len; idx += step) {
      var point = {
        x: args[idx],
        y: args[idx + 1]
      };

      if (_3d) {
        point.z = args[idx + 2];
      }

      points.push(point);
    }

    var order = this.order = points.length - 1;
    var dims = this.dims = ["x", "y"];
    if (_3d) dims.push("z");
    this.dimlen = dims.length; // is this curve, practically speaking, a straight line?

    var aligned = _bezierUtils.utils.align(points, {
      p1: points[0],
      p2: points[order]
    });

    var baselength = _bezierUtils.utils.dist(points[0], points[order]);

    this._linear = aligned.reduce(function (t, p) {
      return t + abs(p.y);
    }, 0) < baselength / 50;
    this._lut = [];
    this._t1 = 0;
    this._t2 = 1;
    this.update();
  }

  Bezier.quadraticFromPoints = function quadraticFromPoints(p1, p2, p3, t) {
    if (typeof t === "undefined") {
      t = 0.5;
    } // shortcuts, although they're really dumb


    if (t === 0) {
      return new Bezier(p2, p2, p3);
    }

    if (t === 1) {
      return new Bezier(p1, p2, p2);
    } // real fitting.


    var abc = Bezier.getABC(2, p1, p2, p3, t);
    return new Bezier(p1, abc.A, p3);
  };

  Bezier.cubicFromPoints = function cubicFromPoints(S, B, E, t, d1) {
    if (typeof t === "undefined") {
      t = 0.5;
    }

    var abc = Bezier.getABC(3, S, B, E, t);

    if (typeof d1 === "undefined") {
      d1 = _bezierUtils.utils.dist(B, abc.C);
    }

    var d2 = d1 * (1 - t) / t;

    var selen = _bezierUtils.utils.dist(S, E),
        lx = (E.x - S.x) / selen,
        ly = (E.y - S.y) / selen,
        bx1 = d1 * lx,
        by1 = d1 * ly,
        bx2 = d2 * lx,
        by2 = d2 * ly; // derivation of new hull coordinates


    var e1 = {
      x: B.x - bx1,
      y: B.y - by1
    },
        e2 = {
      x: B.x + bx2,
      y: B.y + by2
    },
        A = abc.A,
        v1 = {
      x: A.x + (e1.x - A.x) / (1 - t),
      y: A.y + (e1.y - A.y) / (1 - t)
    },
        v2 = {
      x: A.x + (e2.x - A.x) / t,
      y: A.y + (e2.y - A.y) / t
    },
        nc1 = {
      x: S.x + (v1.x - S.x) / t,
      y: S.y + (v1.y - S.y) / t
    },
        nc2 = {
      x: E.x + (v2.x - E.x) / (1 - t),
      y: E.y + (v2.y - E.y) / (1 - t)
    }; // ...done

    return new Bezier(S, nc1, nc2, E);
  };

  Bezier.getUtils = function getUtils() {
    return _bezierUtils.utils;
  };

  var _proto = Bezier.prototype;

  _proto.getUtils = function getUtils() {
    return Bezier.getUtils();
  };

  _proto.valueOf = function valueOf() {
    return this.toString();
  };

  _proto.toString = function toString() {
    return _bezierUtils.utils.pointsToString(this.points);
  };

  _proto.toSVG = function toSVG() {
    if (this._3d) return false;
    var p = this.points,
        x = p[0].x,
        y = p[0].y,
        s = ["M", x, y, this.order === 2 ? "Q" : "C"];

    for (var i = 1, last = p.length; i < last; i++) {
      s.push(p[i].x);
      s.push(p[i].y);
    }

    return s.join(" ");
  };

  _proto.setRatios = function setRatios(ratios) {
    if (ratios.length !== this.points.length) {
      throw new Error("incorrect number of ratio values");
    }

    this.ratios = ratios;
    this._lut = []; //  invalidate any precomputed LUT
  };

  _proto.verify = function verify() {
    var print = this.coordDigest();

    if (print !== this._print) {
      this._print = print;
      this.update();
    }
  };

  _proto.coordDigest = function coordDigest() {
    return this.points.map(function (c, pos) {
      return "" + pos + c.x + c.y + (c.z ? c.z : 0);
    }).join("");
  };

  _proto.update = function update() {
    // invalidate any precomputed LUT
    this._lut = [];
    this.dpoints = _bezierUtils.utils.derive(this.points, this._3d);
    this.computedirection();
  };

  _proto.computedirection = function computedirection() {
    var points = this.points;

    var angle = _bezierUtils.utils.angle(points[0], points[this.order], points[1]);

    this.clockwise = angle > 0;
  };

  _proto.length = function length() {
    return _bezierUtils.utils.length(this.derivative.bind(this));
  };

  Bezier.getABC = function getABC(order, S, B, E, t) {
    if (order === void 0) {
      order = 2;
    }

    if (t === void 0) {
      t = 0.5;
    }

    var u = _bezierUtils.utils.projectionratio(t, order),
        um = 1 - u,
        C = {
      x: u * S.x + um * E.x,
      y: u * S.y + um * E.y
    },
        s = _bezierUtils.utils.abcratio(t, order),
        A = {
      x: B.x + (B.x - C.x) / s,
      y: B.y + (B.y - C.y) / s
    };

    return {
      A: A,
      B: B,
      C: C,
      S: S,
      E: E
    };
  };

  _proto.getABC = function getABC(t, B) {
    B = B || this.get(t);
    var S = this.points[0];
    var E = this.points[this.order];
    return Bezier.getABC(this.order, S, B, E, t);
  };

  _proto.getLUT = function getLUT(steps) {
    this.verify();
    steps = steps || 100;

    if (this._lut.length === steps + 1) {
      return this._lut;
    }

    this._lut = []; // n steps means n+1 points

    steps++;
    this._lut = [];

    for (var i = 0, p, _t; i < steps; i++) {
      _t = i / (steps - 1);
      p = this.compute(_t);
      p.t = _t;

      this._lut.push(p);
    }

    return this._lut;
  };

  _proto.on = function on(point, error) {
    error = error || 5;
    var lut = this.getLUT(),
        hits = [];

    for (var i = 0, c, _t2 = 0; i < lut.length; i++) {
      c = lut[i];

      if (_bezierUtils.utils.dist(c, point) < error) {
        hits.push(c);
        _t2 += i / lut.length;
      }
    }

    if (!hits.length) return false;
    return t /= hits.length;
  };

  _proto.project = function project(point) {
    // step 1: coarse check
    var LUT = this.getLUT(),
        l = LUT.length - 1,
        closest = _bezierUtils.utils.closest(LUT, point),
        mpos = closest.mpos,
        t1 = (mpos - 1) / l,
        t2 = (mpos + 1) / l,
        step = 0.1 / l; // step 2: fine check


    var mdist = closest.mdist,
        t = t1,
        ft = t,
        p;
    mdist += 1;

    for (var d; t < t2 + step; t += step) {
      p = this.compute(t);
      d = _bezierUtils.utils.dist(point, p);

      if (d < mdist) {
        mdist = d;
        ft = t;
      }
    }

    ft = ft < 0 ? 0 : ft > 1 ? 1 : ft;
    p = this.compute(ft);
    p.t = ft;
    p.d = mdist;
    return p;
  };

  _proto.get = function get(t) {
    return this.compute(t);
  };

  _proto.point = function point(idx) {
    return this.points[idx];
  };

  _proto.compute = function compute(t) {
    if (this.ratios) {
      return _bezierUtils.utils.computeWithRatios(t, this.points, this.ratios, this._3d);
    }

    return _bezierUtils.utils.compute(t, this.points, this._3d, this.ratios);
  };

  _proto.raise = function raise() {
    var p = this.points,
        np = [p[0]],
        k = p.length;

    for (var i = 1, _pi, pim; i < k; i++) {
      _pi = p[i];
      pim = p[i - 1];
      np[i] = {
        x: (k - i) / k * _pi.x + i / k * pim.x,
        y: (k - i) / k * _pi.y + i / k * pim.y
      };
    }

    np[k] = p[k - 1];
    return new Bezier(np);
  };

  _proto.derivative = function derivative(t) {
    return _bezierUtils.utils.compute(t, this.dpoints[0], this._3d);
  };

  _proto.dderivative = function dderivative(t) {
    return _bezierUtils.utils.compute(t, this.dpoints[1], this._3d);
  };

  _proto.align = function align() {
    var p = this.points;
    return new Bezier(_bezierUtils.utils.align(p, {
      p1: p[0],
      p2: p[p.length - 1]
    }));
  };

  _proto.curvature = function curvature(t) {
    return _bezierUtils.utils.curvature(t, this.dpoints[0], this.dpoints[1], this._3d);
  };

  _proto.inflections = function inflections() {
    return _bezierUtils.utils.inflections(this.points);
  };

  _proto.normal = function normal(t) {
    return this._3d ? this.__normal3(t) : this.__normal2(t);
  };

  _proto.__normal2 = function __normal2(t) {
    var d = this.derivative(t);
    var q = sqrt(d.x * d.x + d.y * d.y);
    return {
      t: t,
      x: -d.y / q,
      y: d.x / q
    };
  };

  _proto.__normal3 = function __normal3(t) {
    // see http://stackoverflow.com/questions/25453159
    var r1 = this.derivative(t),
        r2 = this.derivative(t + 0.01),
        q1 = sqrt(r1.x * r1.x + r1.y * r1.y + r1.z * r1.z),
        q2 = sqrt(r2.x * r2.x + r2.y * r2.y + r2.z * r2.z);
    r1.x /= q1;
    r1.y /= q1;
    r1.z /= q1;
    r2.x /= q2;
    r2.y /= q2;
    r2.z /= q2; // cross product

    var c = {
      x: r2.y * r1.z - r2.z * r1.y,
      y: r2.z * r1.x - r2.x * r1.z,
      z: r2.x * r1.y - r2.y * r1.x
    };
    var m = sqrt(c.x * c.x + c.y * c.y + c.z * c.z);
    c.x /= m;
    c.y /= m;
    c.z /= m; // rotation matrix

    var R = [c.x * c.x, c.x * c.y - c.z, c.x * c.z + c.y, c.x * c.y + c.z, c.y * c.y, c.y * c.z - c.x, c.x * c.z - c.y, c.y * c.z + c.x, c.z * c.z]; // normal vector:

    var n = {
      t: t,
      x: R[0] * r1.x + R[1] * r1.y + R[2] * r1.z,
      y: R[3] * r1.x + R[4] * r1.y + R[5] * r1.z,
      z: R[6] * r1.x + R[7] * r1.y + R[8] * r1.z
    };
    return n;
  };

  _proto.hull = function hull(t) {
    var p = this.points,
        _p = [],
        q = [],
        idx = 0;
    q[idx++] = p[0];
    q[idx++] = p[1];
    q[idx++] = p[2];

    if (this.order === 3) {
      q[idx++] = p[3];
    } // we lerp between all points at each iteration, until we have 1 point left.


    while (p.length > 1) {
      _p = [];

      for (var i = 0, pt, l = p.length - 1; i < l; i++) {
        pt = _bezierUtils.utils.lerp(t, p[i], p[i + 1]);
        q[idx++] = pt;

        _p.push(pt);
      }

      p = _p;
    }

    return q;
  };

  _proto.split = function split(t1, t2) {
    // shortcuts
    if (t1 === 0 && !!t2) {
      return this.split(t2).left;
    }

    if (t2 === 1) {
      return this.split(t1).right;
    } // no shortcut: use "de Casteljau" iteration.


    var q = this.hull(t1);
    var result = {
      left: this.order === 2 ? new Bezier([q[0], q[3], q[5]]) : new Bezier([q[0], q[4], q[7], q[9]]),
      right: this.order === 2 ? new Bezier([q[5], q[4], q[2]]) : new Bezier([q[9], q[8], q[6], q[3]]),
      span: q
    }; // make sure we bind _t1/_t2 information!

    result.left._t1 = _bezierUtils.utils.map(0, 0, 1, this._t1, this._t2);
    result.left._t2 = _bezierUtils.utils.map(t1, 0, 1, this._t1, this._t2);
    result.right._t1 = _bezierUtils.utils.map(t1, 0, 1, this._t1, this._t2);
    result.right._t2 = _bezierUtils.utils.map(1, 0, 1, this._t1, this._t2); // if we have no t2, we're done

    if (!t2) {
      return result;
    } // if we have a t2, split again:


    t2 = _bezierUtils.utils.map(t2, t1, 1, 0, 1);
    return result.right.split(t2).left;
  };

  _proto.extrema = function extrema() {
    var result = {};
    var roots = [];
    this.dims.forEach(function (dim) {
      var mfn = function mfn(v) {
        return v[dim];
      };

      var p = this.dpoints[0].map(mfn);
      result[dim] = _bezierUtils.utils.droots(p);

      if (this.order === 3) {
        p = this.dpoints[1].map(mfn);
        result[dim] = result[dim].concat(_bezierUtils.utils.droots(p));
      }

      result[dim] = result[dim].filter(function (t) {
        return t >= 0 && t <= 1;
      });
      roots = roots.concat(result[dim].sort(_bezierUtils.utils.numberSort));
    }.bind(this));
    result.values = roots.sort(_bezierUtils.utils.numberSort).filter(function (v, idx) {
      return roots.indexOf(v) === idx;
    });
    return result;
  };

  _proto.bbox = function bbox() {
    var extrema = this.extrema(),
        result = {};
    this.dims.forEach(function (d) {
      result[d] = _bezierUtils.utils.getminmax(this, d, extrema[d]);
    }.bind(this));
    return result;
  };

  _proto.overlaps = function overlaps(curve) {
    var lbbox = this.bbox(),
        tbbox = curve.bbox();
    return _bezierUtils.utils.bboxoverlap(lbbox, tbbox);
  };

  _proto.offset = function offset(t, d) {
    if (typeof d !== "undefined") {
      var c = this.get(t),
          n = this.normal(t);
      var ret = {
        c: c,
        n: n,
        x: c.x + n.x * d,
        y: c.y + n.y * d
      };

      if (this._3d) {
        ret.z = c.z + n.z * d;
      }

      return ret;
    }

    if (this._linear) {
      var nv = this.normal(0),
          coords = this.points.map(function (p) {
        var ret = {
          x: p.x + t * nv.x,
          y: p.y + t * nv.y
        };

        if (p.z && nv.z) {
          ret.z = p.z + t * nv.z;
        }

        return ret;
      });
      return [new Bezier(coords)];
    }

    return this.reduce().map(function (s) {
      if (s._linear) {
        return s.offset(t)[0];
      }

      return s.scale(t);
    });
  };

  _proto.simple = function simple() {
    if (this.order === 3) {
      var a1 = _bezierUtils.utils.angle(this.points[0], this.points[3], this.points[1]);

      var a2 = _bezierUtils.utils.angle(this.points[0], this.points[3], this.points[2]);

      if (a1 > 0 && a2 < 0 || a1 < 0 && a2 > 0) return false;
    }

    var n1 = this.normal(0);
    var n2 = this.normal(1);
    var s = n1.x * n2.x + n1.y * n2.y;

    if (this._3d) {
      s += n1.z * n2.z;
    }

    return abs(acos(s)) < pi / 3;
  };

  _proto.reduce = function reduce() {
    // TODO: examine these var types in more detail...
    var i,
        t1 = 0,
        t2 = 0,
        step = 0.01,
        segment,
        pass1 = [],
        pass2 = []; // first pass: split on extrema

    var extrema = this.extrema().values;

    if (extrema.indexOf(0) === -1) {
      extrema = [0].concat(extrema);
    }

    if (extrema.indexOf(1) === -1) {
      extrema.push(1);
    }

    for (t1 = extrema[0], i = 1; i < extrema.length; i++) {
      t2 = extrema[i];
      segment = this.split(t1, t2);
      segment._t1 = t1;
      segment._t2 = t2;
      pass1.push(segment);
      t1 = t2;
    } // second pass: further reduce these segments to simple segments


    pass1.forEach(function (p1) {
      t1 = 0;
      t2 = 0;

      while (t2 <= 1) {
        for (t2 = t1 + step; t2 <= 1 + step; t2 += step) {
          segment = p1.split(t1, t2);

          if (!segment.simple()) {
            t2 -= step;

            if (abs(t1 - t2) < step) {
              // we can never form a reduction
              return [];
            }

            segment = p1.split(t1, t2);
            segment._t1 = _bezierUtils.utils.map(t1, 0, 1, p1._t1, p1._t2);
            segment._t2 = _bezierUtils.utils.map(t2, 0, 1, p1._t1, p1._t2);
            pass2.push(segment);
            t1 = t2;
            break;
          }
        }
      }

      if (t1 < 1) {
        segment = p1.split(t1, 1);
        segment._t1 = _bezierUtils.utils.map(t1, 0, 1, p1._t1, p1._t2);
        segment._t2 = p1._t2;
        pass2.push(segment);
      }
    });
    return pass2;
  };

  _proto.translate = function translate(v, d1, d2) {
    d2 = typeof d2 === "number" ? d2 : d1; // TODO: make this take curves with control points outside
    //       of the start-end interval into account

    var o = this.order;
    var d = this.points.map(function (_, i) {
      return (1 - i / o) * d1 + i / o * d2;
    });
    return new Bezier(this.points.map(function (p, i) {
      return {
        x: p.x + v.x * d[i],
        y: p.y + v.y * d[i]
      };
    }));
  };

  _proto.scale = function scale(d) {
    var _this = this;

    var order = this.order;
    var distanceFn = false;

    if (typeof d === "function") {
      distanceFn = d;
    }

    if (distanceFn && order === 2) {
      return this.raise().scale(distanceFn);
    } // TODO: add special handling for non-linear degenerate curves.


    var clockwise = this.clockwise;
    var points = this.points;

    if (this._linear) {
      return this.translate(this.normal(0), distanceFn ? distanceFn(0) : d, distanceFn ? distanceFn(1) : d);
    }

    var r1 = distanceFn ? distanceFn(0) : d;
    var r2 = distanceFn ? distanceFn(1) : d;
    var v = [this.offset(0, 10), this.offset(1, 10)];
    var np = [];

    var o = _bezierUtils.utils.lli4(v[0], v[0].c, v[1], v[1].c);

    if (!o) {
      throw new Error("cannot scale this curve. Try reducing it first.");
    } // move all points by distance 'd' wrt the origin 'o',
    // and move end points by fixed distance along normal.


    [0, 1].forEach(function (t) {
      var p = np[t * order] = _bezierUtils.utils.copy(points[t * order]);

      p.x += (t ? r2 : r1) * v[t].n.x;
      p.y += (t ? r2 : r1) * v[t].n.y;
    });

    if (!distanceFn) {
      // move control points to lie on the intersection of the offset
      // derivative vector, and the origin-through-control vector
      [0, 1].forEach(function (t) {
        if (order === 2 && !!t) return;
        var p = np[t * order];

        var d = _this.derivative(t);

        var p2 = {
          x: p.x + d.x,
          y: p.y + d.y
        };
        np[t + 1] = _bezierUtils.utils.lli4(p, p2, o, points[t + 1]);
      });
      return new Bezier(np);
    } // move control points by "however much necessary to
    // ensure the correct tangent to endpoint".


    [0, 1].forEach(function (t) {
      if (order === 2 && !!t) return;
      var p = points[t + 1];
      var ov = {
        x: p.x - o.x,
        y: p.y - o.y
      };
      var rc = distanceFn ? distanceFn((t + 1) / order) : d;
      if (distanceFn && !clockwise) rc = -rc;
      var m = sqrt(ov.x * ov.x + ov.y * ov.y);
      ov.x /= m;
      ov.y /= m;
      np[t + 1] = {
        x: p.x + rc * ov.x,
        y: p.y + rc * ov.y
      };
    });
    return new Bezier(np);
  };

  _proto.outline = function outline(d1, d2, d3, d4) {
    d2 = d2 === undefined ? d1 : d2;

    if (this._linear) {
      // TODO: find the actual extrema, because they might
      //       be before the start, or past the end.
      var n = this.normal(0);
      var start = this.points[0];
      var end = this.points[this.points.length - 1];
      var s, mid, e;

      if (d3 === undefined) {
        d3 = d1;
        d4 = d2;
      }

      s = {
        x: start.x + n.x * d1,
        y: start.y + n.y * d1
      };
      e = {
        x: end.x + n.x * d3,
        y: end.y + n.y * d3
      };
      mid = {
        x: (s.x + e.x) / 2,
        y: (s.y + e.y) / 2
      };
      var fline = [s, mid, e];
      s = {
        x: start.x - n.x * d2,
        y: start.y - n.y * d2
      };
      e = {
        x: end.x - n.x * d4,
        y: end.y - n.y * d4
      };
      mid = {
        x: (s.x + e.x) / 2,
        y: (s.y + e.y) / 2
      };
      var bline = [e, mid, s];

      var _ls = _bezierUtils.utils.makeline(bline[2], fline[0]);

      var _le = _bezierUtils.utils.makeline(fline[2], bline[0]);

      var _segments = [_ls, new Bezier(fline), _le, new Bezier(bline)];
      return new _polyBezier.PolyBezier(_segments);
    }

    var reduced = this.reduce(),
        len = reduced.length,
        fcurves = [];
    var bcurves = [],
        p,
        alen = 0,
        tlen = this.length();
    var graduated = typeof d3 !== "undefined" && typeof d4 !== "undefined";

    function linearDistanceFunction(s, e, tlen, alen, slen) {
      return function (v) {
        var f1 = alen / tlen,
            f2 = (alen + slen) / tlen,
            d = e - s;
        return _bezierUtils.utils.map(v, 0, 1, s + f1 * d, s + f2 * d);
      };
    } // form curve oulines


    reduced.forEach(function (segment) {
      var slen = segment.length();

      if (graduated) {
        fcurves.push(segment.scale(linearDistanceFunction(d1, d3, tlen, alen, slen)));
        bcurves.push(segment.scale(linearDistanceFunction(-d2, -d4, tlen, alen, slen)));
      } else {
        fcurves.push(segment.scale(d1));
        bcurves.push(segment.scale(-d2));
      }

      alen += slen;
    }); // reverse the "return" outline

    bcurves = bcurves.map(function (s) {
      p = s.points;

      if (p[3]) {
        s.points = [p[3], p[2], p[1], p[0]];
      } else {
        s.points = [p[2], p[1], p[0]];
      }

      return s;
    }).reverse(); // form the endcaps as lines

    var fs = fcurves[0].points[0],
        fe = fcurves[len - 1].points[fcurves[len - 1].points.length - 1],
        bs = bcurves[len - 1].points[bcurves[len - 1].points.length - 1],
        be = bcurves[0].points[0],
        ls = _bezierUtils.utils.makeline(bs, fs),
        le = _bezierUtils.utils.makeline(fe, be),
        segments = [ls].concat(fcurves).concat([le]).concat(bcurves);

    return new _polyBezier.PolyBezier(segments);
  };

  _proto.outlineshapes = function outlineshapes(d1, d2, curveIntersectionThreshold) {
    d2 = d2 || d1;
    var outline = this.outline(d1, d2).curves;
    var shapes = [];

    for (var i = 1, len = outline.length; i < len / 2; i++) {
      var shape = _bezierUtils.utils.makeshape(outline[i], outline[len - i], curveIntersectionThreshold);

      shape.startcap.virtual = i > 1;
      shape.endcap.virtual = i < len / 2 - 1;
      shapes.push(shape);
    }

    return shapes;
  };

  _proto.intersects = function intersects(curve, curveIntersectionThreshold) {
    if (!curve) return this.selfintersects(curveIntersectionThreshold);

    if (curve.p1 && curve.p2) {
      return this.lineIntersects(curve);
    }

    if (curve instanceof Bezier) {
      curve = curve.reduce();
    }

    return this.curveintersects(this.reduce(), curve, curveIntersectionThreshold);
  };

  _proto.lineIntersects = function lineIntersects(line) {
    var _this2 = this;

    var mx = min(line.p1.x, line.p2.x),
        my = min(line.p1.y, line.p2.y),
        MX = max(line.p1.x, line.p2.x),
        MY = max(line.p1.y, line.p2.y);
    return _bezierUtils.utils.roots(this.points, line).filter(function (t) {
      var p = _this2.get(t);

      return _bezierUtils.utils.between(p.x, mx, MX) && _bezierUtils.utils.between(p.y, my, MY);
    });
  };

  _proto.selfintersects = function selfintersects(curveIntersectionThreshold) {
    // "simple" curves cannot intersect with their direct
    // neighbour, so for each segment X we check whether
    // it intersects [0:x-2][x+2:last].
    var reduced = this.reduce(),
        len = reduced.length - 2,
        results = [];

    for (var i = 0, result, left, right; i < len; i++) {
      left = reduced.slice(i, i + 1);
      right = reduced.slice(i + 2);
      result = this.curveintersects(left, right, curveIntersectionThreshold);
      results.push.apply(results, result);
    }

    return results;
  };

  _proto.curveintersects = function curveintersects(c1, c2, curveIntersectionThreshold) {
    var pairs = []; // step 1: pair off any overlapping segments

    c1.forEach(function (l) {
      c2.forEach(function (r) {
        if (l.overlaps(r)) {
          pairs.push({
            left: l,
            right: r
          });
        }
      });
    }); // step 2: for each pairing, run through the convergence algorithm.

    var intersections = [];
    pairs.forEach(function (pair) {
      var result = _bezierUtils.utils.pairiteration(pair.left, pair.right, curveIntersectionThreshold);

      if (result.length > 0) {
        intersections = intersections.concat(result);
      }
    });
    return intersections;
  };

  _proto.arcs = function arcs(errorThreshold) {
    errorThreshold = errorThreshold || 0.5;
    return this._iterate(errorThreshold, []);
  };

  _proto._error = function _error(pc, np1, s, e) {
    var q = (e - s) / 4,
        c1 = this.get(s + q),
        c2 = this.get(e - q),
        ref = _bezierUtils.utils.dist(pc, np1),
        d1 = _bezierUtils.utils.dist(pc, c1),
        d2 = _bezierUtils.utils.dist(pc, c2);

    return abs(d1 - ref) + abs(d2 - ref);
  };

  _proto._iterate = function _iterate(errorThreshold, circles) {
    var t_s = 0,
        t_e = 1,
        safety; // we do a binary search to find the "good `t` closest to no-longer-good"

    do {
      safety = 0; // step 1: start with the maximum possible arc

      t_e = 1; // points:

      var np1 = this.get(t_s),
          np2 = void 0,
          np3 = void 0,
          arc = void 0,
          prev_arc = void 0; // booleans:

      var curr_good = false,
          prev_good = false,
          done = void 0; // numbers:

      var t_m = t_e,
          prev_e = 1,
          step = 0; // step 2: find the best possible arc

      do {
        prev_good = curr_good;
        prev_arc = arc;
        t_m = (t_s + t_e) / 2;
        step++;
        np2 = this.get(t_m);
        np3 = this.get(t_e);
        arc = _bezierUtils.utils.getccenter(np1, np2, np3); //also save the t values

        arc.interval = {
          start: t_s,
          end: t_e
        };

        var error = this._error(arc, np1, t_s, t_e);

        curr_good = error <= errorThreshold;
        done = prev_good && !curr_good;
        if (!done) prev_e = t_e; // this arc is fine: we can move 'e' up to see if we can find a wider arc

        if (curr_good) {
          // if e is already at max, then we're done for this arc.
          if (t_e >= 1) {
            // make sure we cap at t=1
            arc.interval.end = prev_e = 1;
            prev_arc = arc; // if we capped the arc segment to t=1 we also need to make sure that
            // the arc's end angle is correct with respect to the bezier end point.

            if (t_e > 1) {
              var d = {
                x: arc.x + arc.r * cos(arc.e),
                y: arc.y + arc.r * sin(arc.e)
              };
              arc.e += _bezierUtils.utils.angle({
                x: arc.x,
                y: arc.y
              }, d, this.get(1));
            }

            break;
          } // if not, move it up by half the iteration distance


          t_e = t_e + (t_e - t_s) / 2;
        } else {
          // this is a bad arc: we need to move 'e' down to find a good arc
          t_e = t_m;
        }
      } while (!done && safety++ < 100);

      if (safety >= 100) {
        break;
      } // console.log("L835: [F] arc found", t_s, prev_e, prev_arc.x, prev_arc.y, prev_arc.s, prev_arc.e);


      prev_arc = prev_arc ? prev_arc : arc;
      circles.push(prev_arc);
      t_s = prev_e;
    } while (t_e < 1);

    return circles;
  };

  _createClass(Bezier, null, [{
    key: "PolyBezier",
    get: function get() {
      return _polyBezier.PolyBezier;
    }
  }]);

  return Bezier;
}();

exports.Bezier = Bezier;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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