
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/Bezier/poly-bezier.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'fa2f1s0twBD4Z7k+7chbDmg', 'poly-bezier');
// Script/Common/Bezier/poly-bezier.js

"use strict";

exports.__esModule = true;
exports.PolyBezier = void 0;

var _bezierUtils = require("./bezierUtils.js");

/**
 * Poly Bezier
 * @param {[type]} curves [description]
 */
var PolyBezier = /*#__PURE__*/function () {
  function PolyBezier(curves) {
    this.curves = [];
    this._3d = false;

    if (!!curves) {
      this.curves = curves;
      this._3d = this.curves[0]._3d;
    }
  }

  var _proto = PolyBezier.prototype;

  _proto.valueOf = function valueOf() {
    return this.toString();
  };

  _proto.toString = function toString() {
    return "[" + this.curves.map(function (curve) {
      return _bezierUtils.utils.pointsToString(curve.points);
    }).join(", ") + "]";
  };

  _proto.addCurve = function addCurve(curve) {
    this.curves.push(curve);
    this._3d = this._3d || curve._3d;
  };

  _proto.length = function length() {
    return this.curves.map(function (v) {
      return v.length();
    }).reduce(function (a, b) {
      return a + b;
    });
  };

  _proto.curve = function curve(idx) {
    return this.curves[idx];
  };

  _proto.bbox = function bbox() {
    var c = this.curves;
    var bbox = c[0].bbox();

    for (var i = 1; i < c.length; i++) {
      _bezierUtils.utils.expandbox(bbox, c[i].bbox());
    }

    return bbox;
  };

  _proto.offset = function offset(d) {
    var offset = [];
    this.curves.forEach(function (v) {
      offset.push.apply(offset, v.offset(d));
    });
    return new PolyBezier(offset);
  };

  return PolyBezier;
}();

exports.PolyBezier = PolyBezier;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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