
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/CocosMgr.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '4c950V6+0dKVbXAbbiuy4ZL', 'CocosMgr');
// Script/Common/LiteGraphCore/CocosMgr.js

"use strict";

exports.__esModule = true;
exports.changeRunInmportState = changeRunInmportState;
exports.changeIsSinglePreview = changeIsSinglePreview;
exports.realBoot = realBoot;
exports.waitCocosInit = waitCocosInit;
exports.init = init;
exports.addNodeToScene = addNodeToScene;
exports.updateCanvasSize = updateCanvasSize;
exports.showOrHideFPS = showOrHideFPS;
exports.showOrHideColiderBox = showOrHideColiderBox;
exports.clearScene = clearScene;
exports.getNodeById = getNodeById;
exports.getChildren = getChildren;
exports.getHasChildrenNodeId = getHasChildrenNodeId;
exports.refreshTree = refreshTree;
exports.changePreviewMode = changePreviewMode;
exports.drawNodeRect = drawNodeRect;
exports.openCacheDialog = openCacheDialog;
exports.outputComponentHandler = outputComponentHandler;
exports.loadResHandle = loadResHandle;
exports.getFileType = getFileType;
exports.getExName = getExName;
exports.getName = getName;
exports.getBaseName = getBaseName;
exports.setValueByKey = setValueByKey;
exports.syncConfigToCodeNode = syncConfigToCodeNode;
exports.xorConfig = xorConfig;
exports.xorConfigZeroValue = xorConfigZeroValue;
exports.blockTouch = blockTouch;
exports.createObj = createObj;
exports.preLoadGraphAssest = preLoadGraphAssest;
exports.showConfirm = showConfirm;
exports.showAlert = showAlert;
exports.preLoad = preLoad;
exports.loadNetSpine = loadNetSpine;
exports.vibrate = vibrate;
exports.changeGraph = changeGraph;
exports.typeColorEnum = exports.robotNodeEnum = exports.objectTypes = exports.ObjectTypeEnum = exports.designViewHeight = exports.designViewWidth = exports.isSinglePreview = exports.isInImport = exports.isInApp = exports.isPreviewMode = exports.rootHost = exports.treeData = exports.selectedNode = exports.intervalId = exports.hasLoadScene = exports.hasInit = void 0;

var _CodeNodeLg = require("./CodeNodeLg");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var hasInit = false;
exports.hasInit = hasInit;
var hasLoadScene = false; //在游戏中直接设置为true

exports.hasLoadScene = hasLoadScene;
var intervalId = -1;
exports.intervalId = intervalId;
var selectedNode = null;
exports.selectedNode = selectedNode;
var treeData = [];
exports.treeData = treeData;
var rootHost = 'https://ywserver.oss-cn-shanghai.aliyuncs.com/bookEdit';
exports.rootHost = rootHost;
var isPreviewMode = false; //不显示摄像机

exports.isPreviewMode = isPreviewMode;
var isInApp = true; //是否在App中

exports.isInApp = isInApp;
var isInImport = false; //是否在导入中

exports.isInImport = isInImport;
var isSinglePreview = false; //单独的预览环境

exports.isSinglePreview = isSinglePreview;
var designViewWidth = 2560;
exports.designViewWidth = designViewWidth;
var designViewHeight = 1500;
exports.designViewHeight = designViewHeight;

function changeRunInmportState(state) {
  exports.isInImport = isInImport = state;
}

function changeIsSinglePreview(state) {
  exports.isSinglePreview = isSinglePreview = state;
}

if (isInApp == true) {
  exports.hasLoadScene = hasLoadScene = true;
}

var ObjectTypeEnum = {
  'empty': '空物体',
  'sprite': '图片',
  'graph': '绘制',
  'spine': 'spine',
  'text': '文本'
};
exports.ObjectTypeEnum = ObjectTypeEnum;
var objectTypes = [ObjectTypeEnum.empty, ObjectTypeEnum.sprite, ObjectTypeEnum.graph, ObjectTypeEnum.spine, ObjectTypeEnum.text];
exports.objectTypes = objectTypes;
var robotNodeEnum = {
  value: 'input/value',
  valueString: 'input/valueString',
  "boolean": 'input/boolean',
  gameStart: 'input/gameStart',
  customButton: 'input/button/customButton',
  controll: 'input/button/controll',
  touchStart: 'input/screen/touchStart',
  touchMove: 'input/screen/touchMove',
  touchEnd: 'input/screen/touchEnd',
  leftOrRightAct: 'input/leftOrRightAct',
  customData: 'input/getData/customData',
  systemData: 'input/getData/systemData',
  screenSize: 'input/screenSize',
  showTextTip: 'output/tips/showTextTip',
  showConfirm: 'output/tips/showConfirm',
  showHandTip: 'output/tips/showHandTip',
  blockTouch: 'output/blockTouch',
  consoleInfo: 'output/tips/consoleInfo',
  restartGame: 'output/game/restartGame',
  changeGame: 'output/game/changeGame',
  endGame: 'output/game/endGame',
  sound: 'output/sound',
  vibrate: 'output/vibrate',
  stopTime: 'output/time/stopTime',
  timeScale: 'output/time/timeScale',
  createObject: 'objects/createObject',
  animate: 'objects/animates/animate',
  tween: 'objects/animates/tween',
  bezierCurve: 'objects/animates/bezierCurve',
  camera: 'objects/camera',
  MotionText: 'output/customComponent/MotionText',
  CaiDanComponent: 'output/customComponent/CaiDanComponent',
  CaiDanComponent2: 'output/customComponent/CaiDanComponent2',
  ChatComponent: 'output/customComponent/ChatComponent',
  VoiceCheck: 'output/customComponent/VoiceCheck',
  AngleCompoment: 'output/customComponent/AngleCompoment',
  ScaleObj: 'output/customComponent/ScaleObj',
  ProgressCompoment: 'output/customComponent/ProgressCompoment',
  'cc.Mask': 'output/customComponent/ccMask',
  angleConvertVector: 'middle/angleCalculate/angleConvertVector',
  angleDifference: 'middle/angleCalculate/angleDifference',
  vectorToAngel: 'middle/angleCalculate/vectorToAngel',
  add: 'middle/calculate/add',
  chu: 'middle/calculate/chu',
  del: 'middle/calculate/del',
  length: 'middle/calculate/length',
  x: 'middle/calculate/x',
  checkTag: 'middle/change/checkTag',
  dataObject: 'middle/change/dataObject',
  getArrayValue: 'middle/change/getArrayValue',
  getKeyValue: 'middle/change/getKeyValue',
  randomNum: 'middle/change/randomNum',
  timeDown: 'middle/change/timeDown',
  timeDownCycle: 'middle/change/timeDownCycle',
  upCount: 'middle/change/upCount',
  bigger: 'middle/compare/bigger',
  equire: 'middle/compare/equire',
  inRange: 'middle/compare/inRange',
  litter: 'middle/compare/litter',
  abs: 'middle/covert/abs',
  revertNegative: 'middle/covert/revertNegative',
  squareRoot: 'middle/covert/squareRoot',
  toint: 'middle/covert/toint',
  input: 'middle/graph/input',
  output: 'middle/graph/output',
  subgraph: 'middle/graph/subgraph',
  allRight: 'middle/logic/allRight',
  allToggle: 'middle/logic/allToggle',
  notRight: 'middle/logic/notRight',
  orRight: 'middle/logic/orRight',
  orToggle: 'middle/logic/orToggle',
  acceptData: 'middle/tool/acceptData',
  lighting: 'middle/tool/lighting',
  lightingOut: 'middle/tool/lightingOut',
  outputLine: 'middle/tool/outputLine',
  sendData: 'middle/tool/sendData',
  textCode: 'middle/tool/textCode',
  contact: 'objects/objectSensor/contact',
  position: 'objects/objectSensor/position',
  speed: 'objects/objectSensor/publicListen',
  connection: 'objects/group/connection'
};
exports.robotNodeEnum = robotNodeEnum;
var typeColorEnum = {
  'input': 'green',
  'middle': 'cyan',
  'output': 'pink',
  'objects': 'orange'
};
exports.typeColorEnum = typeColorEnum;

function realBoot() {
  return _realBoot.apply(this, arguments);
}

function _realBoot() {
  _realBoot = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", new Promise(function (resolve, reject) {
              var settings = window._CCSettings; // if(settings == null){
              //     return
              // }
              // window._CCSettings = undefined;

              // if(settings == null){
              //     return
              // }
              // window._CCSettings = undefined;
              var onProgress = null;
              var RESOURCES = cc.AssetManager.BuiltinBundleName.RESOURCES;
              var INTERNAL = cc.AssetManager.BuiltinBundleName.INTERNAL;
              var MAIN = cc.AssetManager.BuiltinBundleName.MAIN;

              function setLoadingDisplay() {
                // Loading splash scene
                var splash = document.getElementById('splash');

                if (splash == null) {
                  return;
                }

                var progressBar = splash.querySelector('.progress-bar span');

                onProgress = function onProgress(finish, total) {
                  var percent = 100 * finish / total;

                  if (progressBar) {
                    progressBar.style.width = percent.toFixed(2) + '%';
                  }
                };

                splash.style.display = 'block';
                progressBar.style.width = '0%';
                cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
                  splash.style.display = 'none';
                });
              }

              var onStart = function onStart() {
                cc.view.enableRetina(true); // cc.view.resizeWithBrowserSize(true);

                // cc.view.resizeWithBrowserSize(true);
                if (cc.sys.isBrowser) {
                  setLoadingDisplay();
                } // Limit downloading max concurrent task to 2,
                // more tasks simultaneously may cause performance draw back on some android system / browsers.
                // You can adjust the number based on your own test result, you have to set it before any loading process to take effect.


                // Limit downloading max concurrent task to 2,
                // more tasks simultaneously may cause performance draw back on some android system / browsers.
                // You can adjust the number based on your own test result, you have to set it before any loading process to take effect.
                if (cc.sys.isBrowser && cc.sys.os === cc.sys.OS_ANDROID) {
                  cc.assetManager.downloader.maxConcurrency = 2;
                  cc.assetManager.downloader.maxRequestsPerFrame = 2;
                }

                var launchScene = settings.launchScene;
                var bundle = cc.assetManager.bundles.find(function (b) {
                  return b.getSceneInfo(launchScene);
                });
                bundle.loadScene(launchScene, null, onProgress, function (err, scene) {
                  if (!err) {
                    cc.director.runSceneImmediate(scene);

                    if (cc.sys.isBrowser) {
                      // show canvas
                      // var canvas = document.getElementById('GameCanvas');
                      // canvas.style.visibility = '';
                      // var div = document.getElementById('GameDiv');
                      // if (div) {
                      //     div.style.backgroundImage = '';
                      // }
                      console.log('Success to load scene: ' + launchScene);
                    } // console.log('hasRead', )
                    //设置canvas design分辨率
                    // var canvas = cc.director.getScene().getChildByName('Canvas').getComponent(cc.Canvas)
                    // console.log('canvas', canvas)


                    // console.log('hasRead', )
                    //设置canvas design分辨率
                    // var canvas = cc.director.getScene().getChildByName('Canvas').getComponent(cc.Canvas)
                    // console.log('canvas', canvas)
                    cc.Canvas.instance.designResolution = cc.size(designViewWidth, designViewHeight);
                    exports.hasLoadScene = hasLoadScene = true;
                    clearScene();
                    resolve(true);
                  } else {
                    reject(err);
                  }
                });
              };

              var canvas = document.getElementById('GameCanvas');

              if (canvas == null) {
                console.warn('没有找到GameCanvas');
                reject('没有找到渲染画布GameCanvas');
                return;
              }

              var option = {
                id: 'GameCanvas',
                debugMode: settings.debug ? cc.debug.DebugMode.INFO : cc.debug.DebugMode.ERROR,
                showFPS: settings.debug,
                frameRate: 60,
                groupList: settings.groupList,
                collisionMatrix: settings.collisionMatrix
              };
              cc.assetManager.init({
                bundleVers: settings.bundleVers,
                remoteBundles: settings.remoteBundles,
                server: settings.server
              });
              var bundleRoot = [INTERNAL];
              settings.hasResourcesBundle && bundleRoot.push(RESOURCES);
              var count = 0;

              function cb(err) {
                if (err) return console.error(err.message, err.stack);
                count++;

                if (count === bundleRoot.length + 1) {
                  cc.assetManager.loadBundle(MAIN, function (err) {
                    if (!err) {
                      cc.game.run(option, onStart);
                    } else {
                      reject(err);
                    }
                  });
                }
              }

              console.log('需要加载的settings.jsList', settings.jsList);
              cc.assetManager.loadScript(settings.jsList.map(function (x) {
                return 'src/' + x;
              }), cb);
              console.log('需要加载的bundleRoot', bundleRoot);

              for (var i = 0; i < bundleRoot.length; i++) {
                cc.assetManager.loadBundle(bundleRoot[i], cb);
              }
            }));

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _realBoot.apply(this, arguments);
}

function initConsoleUtil() {
  if (cc.tree) return;

  cc.tree = function (key) {
    var index = key || 0;

    var treeNode = function treeNode(node) {
      var nameStyle = "color: " + (node.parent === null || node.activeInHierarchy ? 'green' : 'grey') + "; font-size: 14px;font-weight:bold";
      var propStyle = "color: black; background: lightgrey;margin-left: 5px;border-radius:3px;padding: 0 3px;font-size: 10px;font-weight:bold";
      var indexStyle = "color: orange; background: black;margin-left: 5px;border-radius:3px;padding:0 3px;fonrt-size: 10px;font-weight:bold;";
      var nameValue = "%c" + node.name;
      var propValue = "%c" + (node.x.toFixed(0) + ',' + node.y.toFixed(0) + ',' + node.width.toFixed(0) + ',' + node.height.toFixed(0) + ',' + node.scale.toFixed(1));
      var indexValue = "%c" + index++;

      if (node.childrenCount > 0) {
        console.groupCollapsed(nameValue + propValue + indexValue, nameStyle, propStyle, indexStyle);

        for (var i = 0; i < node.childrenCount; i++) {
          treeNode(node.children[i]);
        }

        console.groupEnd();
      } else {
        console.log(nameValue + propValue + indexValue, nameStyle, propStyle, indexStyle);
      }
    };

    if (key) {
      var node = cc.cat(key);
      index = node['tempIndex'];
      treeNode(node);
    } else {
      var scene = cc.director.getScene();
      treeNode(scene);
    }

    return '属性依次为x,y,width,height,scale.使用cc.cat(id)查看详细属性.';
  };

  cc.cat = function (key) {
    var index = 0;
    var target;

    var sortId = function sortId(node) {
      if (target) return;

      if (cc.js.isNumber(key)) {
        if (key === index++) {
          target = node;
          return;
        }
      } else {
        if (key.toLowerCase() === node.name.toLowerCase()) {
          target = node;
          return;
        } else {
          index++;
        }
      }

      if (node.childrenCount > 0) {
        for (var i = 0; i < node.childrenCount; i++) {
          sortId(node.children[i]);
        }
      }
    };

    var scene = cc.director.getScene();
    sortId(scene);
    target['tempIndex'] = cc.js.isNumber(key) ? key : index;
    return target;
  };

  cc.list = function (key) {
    var targets = [];

    var step = function step(node) {
      if (node.name.toLowerCase().indexOf(key.toLowerCase()) > -1) {
        targets.push(node);
      }

      if (node.childrenCount > 0) {
        for (var i = 0; i < node.childrenCount; i++) {
          step(node.children[i]);
        }
      }
    };

    var scene = cc.director.getScene();
    step(scene);

    if (targets.length === 1) {
      return targets[0];
    } else {
      return targets;
    }
  };

  cc.where = function (key) {
    var target = key.name ? key : cc.cat(key);

    if (!target) {
      return null;
    }

    var rect = target.getBoundingBoxToWorld();
    var bgNode = new cc.Node();
    var graphics = bgNode.addComponent(cc.Graphics);
    var scene = cc.director.getScene();
    scene.addChild(bgNode);
    bgNode.position = rect.center;
    bgNode.group = target.group;
    bgNode.zIndex = cc.macro.MAX_ZINDEX;
    var isZeroSize = rect.width === 0 || rect.height === 0;

    if (isZeroSize) {
      graphics.circle(0, 0, 100);
      graphics.fillColor = cc.Color.GREEN;
      graphics.fill();
    } else {
      bgNode.width = rect.width;
      bgNode.height = rect.height;
      graphics.rect(-bgNode.width / 2, -bgNode.height / 2, bgNode.width, bgNode.height);
      graphics.fillColor = new cc.Color().fromHEX('#E91E6390');
      graphics.fill();
    }

    setTimeout(function () {
      if (cc.isValid(bgNode)) {
        bgNode.destroy();
      }
    }, 2000);
    return target;
  };

  cc.cache = function () {
    var rawCacheData = cc.assetManager.assets._map;
    var cacheData = [];
    var totalTextureSize = 0;

    for (var k in rawCacheData) {
      var item = rawCacheData[k];

      if (item.type !== 'js' && item.type !== 'json') {
        var itemName = '_';
        var preview = '';
        var content = item.__classname__;
        var formatSize = -1;

        if (item.type === 'png' || item.type === 'jpg') {
          var texture = rawCacheData[k.replace('.' + item.type, '.json')];

          if (texture && texture._owner && texture._owner._name) {
            itemName = texture._owner._name;
            preview = texture.content.url;
          }
        } else {
          if (item.name) {
            itemName = item.name;
          } else if (item._owner) {
            itemName = item._owner && item._owner.name || '_';
          }

          if (content === 'cc.Texture2D') {
            preview = item.nativeUrl;
            var textureSize = item.width * item.height * ((item._native === '.jpg' ? 3 : 4) / 1024 / 1024);
            totalTextureSize += textureSize; // sizeStr = textureSize.toFixed(3) + 'M';

            formatSize = Math.round(textureSize * 1000) / 1000;
          } else if (content === 'cc.SpriteFrame') {
            preview = item._texture.nativeUrl;
          }
        }

        cacheData.push({
          queueId: item.queueId,
          type: content,
          name: itemName,
          preview: preview,
          id: item._uuid,
          size: formatSize
        });
      }
    }

    var cacheTitle = "\u7F13\u5B58 [\u6587\u4EF6\u603B\u6570:" + cacheData.length + "][\u7EB9\u7406\u7F13\u5B58:" + (totalTextureSize.toFixed(2) + 'M') + "]";
    return [cacheData, cacheTitle];
  };

  cc.loopAllNode = function (handle, node) {
    var loop = function loop(node) {
      // console.log('grayNode', node.name)
      if (cc.isValid(node)) {
        handle(node);

        for (var i = 0; i < node.children.length; i++) {
          loop(node.children[i]);
        }
      }
    };

    if (node == null) {
      node = cc.director.getScene();

      if (cc.isValid(node) == true) {
        for (var i = 0; i < node.children.length; i++) {
          loop(node.children[i]);
        }
      }
    } else {
      loop(node);
    }
  };
}

function waitCocosInit() {
  return _waitCocosInit.apply(this, arguments);
}

function _waitCocosInit() {
  _waitCocosInit = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", new Promise(function (resolve, reject) {
              var count = 0;

              var check = function check() {
                count += 1;

                if (hasLoadScene == true) {
                  resolve(true);
                } else {
                  if (count > 100) {
                    reject('等待cocos加载场景超时');
                  } else {
                    setTimeout(check, 100);
                  }
                }
              };

              check();
            }));

          case 1:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _waitCocosInit.apply(this, arguments);
}

function init() {
  return _init.apply(this, arguments);
}

function _init() {
  _init = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (!(hasInit == true)) {
              _context3.next = 3;
              break;
            }

            console.log('CocosMgr已经初始化了');
            return _context3.abrupt("return", true);

          case 3:
            exports.hasInit = hasInit = true;

            if (typeof VConsole !== 'undefined') {
              window.vConsole = new VConsole();
            } // var debug = window._CCSettings.debug;
            // var physics = 'physics.js'


            console.log('window._CCSettings.debug', window._CCSettings);
            console.log('window.vConsole', window.vConsole);

            if (!(window.cc != null)) {
              _context3.next = 14;
              break;
            }

            console.log('cocos加载成功ENGINE_VERSION', window.cc.ENGINE_VERSION);
            _context3.next = 11;
            return realBoot();

          case 11:
            initConsoleUtil();
            _context3.next = 16;
            break;

          case 14:
            console.warn('cocos引擎没有被加载');
            return _context3.abrupt("return", false);

          case 16:
            exports.hasInit = hasInit = true;

          case 17:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _init.apply(this, arguments);
}

function addNodeToScene() {
  if (hasLoadScene == false) {
    return;
  }

  var canvas = cc.director.getScene().getChildByName('Canvas');
  var node = new cc.Node();
  node.addComponent(cc.Label).string = '这是新增节点';
  node.parent = canvas;
}

function updateCanvasSize(width, height) {
  if (hasLoadScene == false) {
    return;
  } // var canvas = cc.director.getScene().getChildByName('Canvas');
  // console.log(canvas.getComponent(cc.Canvas), cc.winSize)


  if (width == null || height == null) {
    //直接查询canvas元素获取
    var canvas = document.getElementById('GameCanvas');
    width = canvas.clientWidth;
    height = canvas.clientHeight;
    console.log('自动获取了canvas尺寸并更新', width, height);
  }

  cc.view.setCanvasSize(width, height); // var manager = cc.director.getCollisionManager();
  // if(manager._debugDrawer != null){
  //     manager._debugDrawer.lineWidth = 2 * (1 / cc.view.getScaleX())
  // }
  // console.log('dpi', cc.view.getScaleX(), cc.view.getScaleY())
}

function showOrHideFPS() {
  var show = !cc.debug.isDisplayStats();
  cc.debug.setDisplayStats(show);
  return show;
}

function showOrHideColiderBox() {
  var manager = cc.director.getCollisionManager();

  if (manager == null) {
    console.warn('getCollisionManager == null');
    return;
  } // manager.enabled = true;
  // this.lastDebugDrawState = manager.enabledDebugDraw 


  manager.enabledDebugDraw = !manager.enabledDebugDraw; // console.log('_debugDrawer', manager._debugDrawer)

  if (manager._debugDrawer != null) {
    manager._debugDrawer.lineWidth = 3 * (1 / cc.view.getScaleX());
  } // if(manager.enabledDebugDraw == false){
  //     manager._debugDrawer.node.destroy()
  // }
  // manager.enabledDrawBoundingBox = manager.enabledDebugDraw;


  return manager.enabledDebugDraw;
} //清空当前场景，只留下Canvas节点和Canvas下的摄像机


function clearScene() {
  if (hasLoadScene == false) {
    return;
  }

  var scene = cc.director.getScene();

  for (var i = 0; i < scene.children.length; i++) {
    var node = scene.children[i];

    if (node.name != 'Canvas') {
      node.destroy();
    } else {
      for (var j = 0; j < node.children.length; j++) {
        var node2 = node.children[j];

        if (node2.name != 'Main Camera') {
          node2.destroy();
        }
      }
    }
  }
}

function getNodeById(id) {
  var target;

  var search = function search(node) {
    if (node._id === id) {
      target = node;
      return;
    }

    if (node.childrenCount) {
      for (var i = 0; i < node.childrenCount; i++) {
        if (!target) {
          search(node.children[i]);
        }
      }
    }
  };

  var scene = cc.director.getScene();
  search(scene);
  return target;
}

function getChildren(node) {
  return node.children.map(function (child) {
    var children = child.children && child.children.length > 0 ? getChildren(child) : [];
    return {
      id: child._id,
      name: child.name,
      active: child.activeInHierarchy,
      children: children
    };
  });
}

function getHasChildrenNodeId() {
  if (hasLoadScene == false) {
    return [];
  }

  var nodeIds = [];
  cc.loopAllNode(function (node) {
    if (node.children.length > 0) {
      nodeIds.push(node._id);
    }
  }, cc.director.getScene());
  return nodeIds;
}

function refreshTree() {
  exports.treeData = treeData = getChildren(cc.director.getScene());
}

function changePreviewMode() {
  exports.isPreviewMode = isPreviewMode = !isPreviewMode;
} // export function startUpdateTree() {
//     stopUpdateTree()
//     intervalId = setInterval(() => {
//         refreshTree();
//     }, 200);
// }
// export function stopUpdateTree() {
//     clearInterval(intervalId);
// }


function drawNodeRect(node) {
  if (node != null) {
    exports.selectedNode = selectedNode = node;
    cc.where(node);
  } else {
    cc.where(selectedNode);
  }
}

function openCacheDialog() {
  // cc.where(selectedNode);
  var cacheInfo = cc.cache();
  console.log('cacheInfo', cacheInfo);
}

function outputComponentHandler(componentName) {
  var component = this.selectedNode.getComponent(componentName);
  console.log(component);
} //所有资源都不用Cocos打包翻到目录下了，应该采用加载网络资源的方案，不使用加载AssestBundle的方案，或者看看是否可以脱离引擎构建AssestBundle
//加载一个资源


function loadResHandle(name, type, cb, customBundle) {} //获取文件类型，一种文件类型可能有多个后缀，比如图片音频


function getFileType(fileEx) {
  if (fileEx == 'png' || fileEx == 'jpg' || fileEx == 'jpeg') {
    return '图片';
  } else if (fileEx == 'mp3' || fileEx == 'wav') {
    return '音频';
  } else if (fileEx == 'json') {
    return 'json';
  } else if (fileEx == 'atlas') {
    return '图集';
  } else if (fileEx == 'spine') {
    return 'spine';
  }

  return '空物体';
} //获取文件后缀名称


function getExName(fileName, withDot) {
  var fileEx = '';

  if (fileName.indexOf('.') != -1) {
    fileName = fileName.split('.');
    fileEx = fileName[fileName.length - 1];
  }

  if (withDot == true) {
    return '.' + fileEx;
  }

  return fileEx;
}

function getName(fileName) {
  if (fileName.indexOf('/') != -1) {
    fileName = fileName.split('/');
    fileName = fileName[fileName.length - 1];
  }

  return fileName;
} //获取文件不带后缀的名称


function getBaseName(fileName) {
  fileName = getName(fileName);
  return fileName.split('.')[0];
}

function setValueByKey(codeNode, config, key) {
  if (config[key] != null) {
    codeNode[key] = config[key];
  }
} //同步配置和节点


function syncConfigToCodeNode(codeNode, config) {
  setValueByKey(codeNode, config, 'modal');
  setValueByKey(codeNode, config, 'customeName');
  setValueByKey(codeNode, config, 'anchorX');
  setValueByKey(codeNode, config, 'anchorY');
  setValueByKey(codeNode, config, 'x');
  setValueByKey(codeNode, config, 'y');

  if (codeNode.useCenterMode) {
    if (config.x != null && config.y != null) {
      codeNode.center = [config.x, config.y];
    }
  }

  setValueByKey(codeNode, config, 'angle');
  setValueByKey(codeNode, config, 'color');
  setValueByKey(codeNode, config, 'zIndex');
  setValueByKey(codeNode, config, 'dynamiczIndex');
  setValueByKey(codeNode, config, 'group');
  setValueByKey(codeNode, config, 'overflow');
  setValueByKey(codeNode, config, 'height');
  setValueByKey(codeNode, config, 'width');
  setValueByKey(codeNode, config, 'opacity');
  setValueByKey(codeNode, config, 'outLineColor');
  setValueByKey(codeNode, config, 'outLineWidth');
  setValueByKey(codeNode, config, 'premulAlpha');
  setValueByKey(codeNode, config, 'scaleX');
  setValueByKey(codeNode, config, 'scaleY');
  setValueByKey(codeNode, config, 'string');
  setValueByKey(codeNode, config, 'zoomRatio');
  setValueByKey(codeNode, config, 'colliderValue'); // codeNode.modal = config.modal   //首先设置，涉及到增减组件
  // codeNode.customeName = config.customeName
  // codeNode.anchorX = config.anchorX
  // codeNode.anchorY = config.anchorY
  // codeNode.x = config.x
  // codeNode.y = config.y
  // codeNode.angle = config.angle
  // codeNode.color = config.color
  // codeNode.zIndex = config.zIndex
  // codeNode.dynamiczIndex = config.dynamiczIndex
  // codeNode.group = config.group
  // codeNode.height = config.height
  // codeNode.width = config.width
  // codeNode.opacity = config.opacity
  // codeNode.outLineColor = config.outLineColor
  // codeNode.outLineWidth = config.outLineWidth
  // codeNode.premulAlpha = config.premulAlpha
  // codeNode.scaleX = config.scaleX
  // codeNode.scaleY = config.scaleY
  // codeNode.string = config.string
} //剔除掉和节点一直的属性配置，多个tween修改不同的值互不影响


function xorConfig(codeNode, config) {
  for (var key in config) {
    if (codeNode[key] == config[key] || null == config[key]) {
      delete config[key];
    }
  }
} //剔除掉值为0的属性


function xorConfigZeroValue(config) {
  for (var key in config) {
    if (0 == config[key] || null == config[key]) {
      delete config[key];
    }
  }
}

function blockTouch(isBlock) {
  if (hasLoadScene == false) {
    console.warn('调用createObj时场景还未加载成功');
    return;
  }

  var scene = cc.director.getScene();
  var blockNode = scene.getChildByName('blockNode');

  if (blockNode == null) {
    blockNode = new cc.Node();
    blockNode.name = 'blockNode';
    blockNode.parent = scene;
    blockNode.width = cc.winSize.width;
    blockNode.height = cc.winSize.height;
    blockNode.addComponent(cc.BlockInputEvents);
    blockNode.x = cc.winSize.width * 0.5;
    blockNode.y = cc.winSize.height * 0.5;
  }

  blockNode.active = isBlock;
}

function createObj(config, cb) {
  // console.log('调用了创建物体', config)
  if (hasLoadScene == false) {
    console.warn('调用createObj时场景还未加载成功');
    return;
  }

  var parentNode = null;

  if (config.parent != null) {
    parentNode = config.parent;
  } else {
    parentNode = cc.director.getScene().getChildByName('Canvas');
  }

  if (parentNode == null) {
    return;
  }

  if (cc.isValid(parentNode) == false) {
    return;
  }

  var node = new cc.Node();
  node.parent = parentNode;
  var codeNode = node.addComponent(_CodeNodeLg.CodeNodeLg);
  codeNode.onAssstLoadCb = cb; // node.x = 0
  // node.y = 0

  syncConfigToCodeNode(codeNode, config); // node.x = -1621.984
  // node.y = -655
  // anchorX: 0
  // anchorY: 0
  // angle: 0
  // colliderValue: Proxy {}
  // color: "#ffffff"
  // customeName: "title8.5c395126.png"
  // dynamiczIndex: false
  // group: false
  // height: 50
  // modal: "图片"
  // opacity: 255
  // outLineColor: "#ffffff"
  // outLineWidth: 0
  // premulAlpha: false
  // scaleX: 0
  // scaleY: 0
  // showTime: "初始化时"
  // string: ""
  // width: 50
  // x: 0
  // y: 0
  // zIndex: 1
  // var modal = config.modal
  // node.addComponent(cc.Label).string = '我是新的节点'

  return codeNode;
} //预下载一个蓝图需要用到的资源


function preLoadGraphAssest(graph) {}

function showConfirm(_x, _x2) {
  return _showConfirm.apply(this, arguments);
}

function _showConfirm() {
  _showConfirm = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(msg, cb) {
    var result;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            if (isInApp == true) {// await 
            } else {
              result = confirm(msg);
              cb(result);
            }

          case 1:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _showConfirm.apply(this, arguments);
}

function showAlert(_x3) {
  return _showAlert.apply(this, arguments);
} //预下载


function _showAlert() {
  _showAlert = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(msg) {
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            if (isInApp == true) {// await 
            } else {
              // alert(msg)
              if (window.antAleart != null) {
                window.antAleart(msg);
              }
            }

          case 1:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _showAlert.apply(this, arguments);
}

function preLoad(groupFile) {
  var urls = [];

  for (var i = 0; i < groupFile.length; i++) {
    var oneGroup = groupFile[i];

    if (oneGroup.modal == ObjectTypeEnum.spine) {
      //目前只有spine资源是多个文件加载
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.png',
        ext: '.png'
      });
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.json',
        ext: '.json'
      });
      urls.push({
        url: rootHost + '/' + oneGroup.customeName + '.atlas',
        ext: '.atlas'
      });
    } else {
      //音频图片等都是单文件加载
      urls.push({
        url: rootHost + '/' + oneGroup.customeName,
        ext: getExName(oneGroup.customeName, true)
      });
    }
  }

  cc.assetManager.preloadAny(urls, function (finished, total, item) {
    console.log('预加载进度', finished, total);
  }, function (err, items) {
    console.log('预加载结束', items);
  });
}

function loadNetSpine(spineName, cb) {
  var image = rootHost + '/' + spineName + '.png';
  var ske = rootHost + '/' + spineName + '.json';
  var atlas = rootHost + '/' + spineName + '.atlas';
  var arr = image.split('/');
  var textureNames = arr[arr.length - 1];
  cc.assetManager.loadAny([{
    url: atlas,
    ext: '.atlas'
  }, {
    url: ske,
    ext: '.json'
  }], function (error, assets) {
    // let png = Utils.formatPng(url);
    cc.assetManager.loadRemote(image, function (error, texture) {
      var asset = new sp.SkeletonData();
      asset.skeletonJson = assets[1];
      asset.atlasText = assets[0];
      asset.textures = [texture];
      asset.textureNames = [textureNames]; // skeleton.skeletonData = asset;

      cb && cb(asset);
    });
  });
}

function vibrate(_long) {
  console.log('震动长短', _long);
}

function changeGraph(gamePath, orPageIndex) {
  //gamePath 的路径应该是怎么样的呢？
  //bundle, jsonName
  if (isInApp) {//在应用内的切换逻辑
    // UIManager.getInstance()._showingForms[UIManager.getInstance().currentScene].realJumpScene(orPageIndex)
  } else {
    //在编辑器中的切换逻辑
    if (window.onChangeGraph != null) {
      window.onChangeGraph(gamePath, orPageIndex, true);
    }
  }
}

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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