
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/CodeNodeLg.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1f191m9itRAqI0yIZFFqwEz', 'CodeNodeLg');
// Script/Common/LiteGraphCore/CodeNodeLg.js

"use strict";

exports.__esModule = true;
exports.CodeNodeLg = void 0;

var CocosMgr = _interopRequireWildcard(require("./CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var CodeNodeLg = cc.Class({
  "extends": cc.Component,
  properties: {
    // x: {
    //     // ATTRIBUTES:
    //     default: null,        // The default value will be used only when the component attaching
    //                           // to a node for the first time
    //     type: cc.SpriteFrame, // optional, default is typeof default
    //     serializable: true,   // optional, default is true
    // },
    //贝塞尔曲线变量t
    curve: null,
    onAssstLoadCb: null,
    bezierScale: 1,
    assestLoaded: true,
    t: {
      get: function get() {
        return this._t;
      },
      set: function set(value) {
        //不能超过曲线设置
        if (value > 1) {
          value = 1;
        }

        if (value < 0) {
          value = 0;
        }

        this._t = value;

        if (this.curve != null) {
          var pt = this.curve.get(value);
          this.x = pt.x * this.bezierScale; //因为基础数据是0.5倍，所以在常规未缩放页面需要X2

          this.y = pt.y * this.bezierScale;

          if (this.lookUp == 1) {
            //跟随当前运行的方向
            //当角度为0度时，图片素材中的箭头朝向为 ->
            var dv = this.curve.derivative(value); // var xdir = dv.x - pt.x
            // var ydir = dv.y - pt.y

            var radian = Math.atan2(dv.y, dv.x);
            var angle = radian * (180 / Math.PI); // console.log('节点旋转角度angle', angle, pt, dv)

            this.angle = angle;
          }
        }
      }
    },
    _t: 0,
    nodeName: {
      get: function get() {
        return this.node.name;
      },
      set: function set(value) {
        this.node.name = value;
      }
    },
    src: {
      get: function get() {
        if (this.modal == 4) {
          return this.string;
        } else {
          return this.customeName;
        }
      },
      set: function set(value) {
        this.node.name = value;
      }
    },
    _modal: '',
    modal: {
      get: function get() {
        return this._modal;
      },
      set: function set(value) {
        var _this = this;

        //spine，label，sprite，Graph，这几种渲染组件同时只能存在一个
        if (this._modal != value) {
          this._modal = value;

          if (this.sprite != null) {
            this.node.removeComponent(cc.Sprite);
            this.sprite = null;
          } else if (this.spineCom != null) {
            this.node.removeComponent(sp.Skeleton);
            this.spineCom = null;
          } else if (this.label != null) {
            this.node.removeComponent(cc.Label);
            this.label = null;
          }

          if (value == CocosMgr.ObjectTypeEnum.spine) {
            this.spineCom = this.node.addComponent(sp.Skeleton);
          } else if (value == CocosMgr.ObjectTypeEnum.text) {
            this.label = this.node.addComponent(cc.Label);

            if (CocosMgr.isInApp) {
              cc.resources.load('app/font/wowfont', cc.Font, function (err, asset) {
                if (err) {
                  cc.error("wowfont[\u8D44\u6E90\u52A0\u8F7D] \u9519\u8BEF " + err);
                } else {
                  if (cc.isValid(_this.node) == true && _this.label != null) {
                    _this.label.font = asset;
                  }
                }
              });
            }
          } else if (value == CocosMgr.ObjectTypeEnum.sprite) {
            this.sprite = this.node.addComponent(cc.Sprite);
          } // console.log('设置了modal', this.modal, this.spineCom, this.label, this.sprite)

        }
      }
    },
    customeName: {
      get: function get() {
        return this._customeName;
      },
      set: function set(value) {
        var _this2 = this;

        // if(this._customeName == ''){
        //     //首次赋值，不触发自动切换资源
        //     this._customeName = value
        //     return
        // }
        if (this._customeName != value) {
          var name = value;

          if (name.indexOf('/') != -1) {
            name = name.split('/');
            name = name[name.length - 1];
          }

          if (name.indexOf('.') != -1) {
            name = name.split('.')[0];
          }

          this.node.name = name; // console.log('设置了customeName', value, this.modal, this.sprite)

          if (this.modal == CocosMgr.ObjectTypeEnum.sprite) {
            if (this.sprite != null) {
              this.assestLoaded = false;
              cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + value, function (err, texture) {
                if (cc.isValid(_this2.node) == true && texture != null && _this2.sprite != null) {
                  _this2.sprite.spriteFrame = new cc.SpriteFrame(texture);
                }

                _this2.assestLoaded = true;

                if (_this2.onAssstLoadCb != null) {
                  _this2.onAssstLoadCb();
                }
              });
            }
          } else if (this.modal == CocosMgr.ObjectTypeEnum.spine) {
            // var curAnimation = 'std'
            // var isLoop = false
            if (this.spineCom != null) {
              this.assestLoaded = false;
              CocosMgr.loadNetSpine(value, function (data) {
                if (data != null && cc.isValid(_this2.node) && _this2.spineCom != null) {
                  _this2.spineCom.skeletonData = data;

                  _this2.checkAddComponent('SpinePlusComponent');
                }

                _this2.assestLoaded = true; //spine加载成功后spinplusComponent才能获取到碰撞框

                if (_this2.onAssstLoadCb != null) {
                  _this2.onAssstLoadCb();
                }
              });
            } // this.codeProgress.codeRobotConfig.loadResHandle(value, sp.SkeletonData, (res)=>{
            //     if(res != null && this.spineCom != null){
            //         this.spineCom.skeletonData = res
            //         this.spineCom.setAnimation(0, curAnimation, isLoop)
            //     }
            // })

          } else if (this.modal == CocosMgr.ObjectTypeEnum.text) {
            if (this.onAssstLoadCb != null) {
              this.onAssstLoadCb();
            }
          } else {
            if (this.onAssstLoadCb != null) {
              this.onAssstLoadCb();
            }
          }

          this._customeName = value;
        }

        if (value == '') {
          //没有设置值，那也直接返回吧
          if (this.onAssstLoadCb != null) {
            this.onAssstLoadCb();
          }
        }
      }
    },
    premulAlpha: {
      get: function get() {
        if (this.spineCom != null) {
          return this.spineCom.premultipliedAlpha == true ? 1 : 0;
        }

        if (this.sprite != null) {
          return this.sprite.srcBlendFactor == cc.macro.BlendFactor.ONE ? 1 : 0;
        }

        return 0;
      },
      set: function set(value) {
        if (this.spineCom != null) {
          return this.spineCom.premultipliedAlpha = value == 0 ? false : true;
        }

        if (this.sprite != null) {
          return this.sprite.srcBlendFactor = value == true ? cc.macro.BlendFactor.ONE : cc.macro.BlendFactor.SRC_ALPHA;
        }
      }
    },
    x: {
      get: function get() {
        return this.node.x + this.offsetx;
      },
      set: function set(value) {
        this.node.x = value - this.offsetx;
        this.dispatchListener('x', this.node.x);
      }
    },
    y: {
      get: function get() {
        return this.node.y + this.offsety;
      },
      set: function set(value) {
        this.node.y = value - this.offsety;

        if (this.dynamiczIndex) {
          this.zIndex = 6000 - Math.round(this.node.y + 1500) * 2; // console.log('this。zindex', this.zIndex)
        }

        this.dispatchListener('y', this.node.y);
      }
    },
    realX: {
      get: function get() {
        return this.node.x;
      },
      set: function set(value) {
        this.node.x = value;
        this.dispatchListener('x', this.node.x);
      }
    },
    realY: {
      get: function get() {
        return this.node.y;
      },
      set: function set(value) {
        this.node.y = value;

        if (this.dynamiczIndex) {
          this.zIndex = 6000 - Math.round(this.node.y + 1500) * 2; // console.log('this。zindex', this.zIndex)
        }

        this.dispatchListener('y', this.node.y);
      }
    },
    scaleX: {
      get: function get() {
        return this.node.scaleX;
      },
      set: function set(value) {
        this.node.scaleX = value;
        this.dispatchListener('scaleX', value);
      }
    },
    scaleY: {
      get: function get() {
        return this.node.scaleY;
      },
      set: function set(value) {
        this.node.scaleY = value;
        this.dispatchListener('scaleY', value);
      }
    },
    width: {
      get: function get() {
        return this.node.width;
      },
      set: function set(value) {
        this.node.width = value;
        this.dispatchListener('width', value);
        this.updatePreview();
      }
    },
    height: {
      get: function get() {
        return this.node.height;
      },
      set: function set(value) {
        this.node.height = value;
        this.dispatchListener('height', value);
        this.updatePreview();
      }
    },
    opacity: {
      get: function get() {
        return this.node.opacity;
      },
      set: function set(value) {
        this.node.opacity = value;
        this.dispatchListener('opacity', value);
      }
    },
    angle: {
      get: function get() {
        return this.node.angle;
      },
      set: function set(value) {
        this.node.angle = value;
        this.dispatchListener('angle', value);
      }
    },
    angleToPos: {
      get: function get() {
        return this._angleToPos;
      },
      set: function set(value) {
        this._angleToPos = value;
        this.realX = this.center[0] + Math.sin(this._angleToPos * (Math.PI / 180)) * this.radius;
        this.realY = this.center[1] + Math.cos(this._angleToPos * (Math.PI / 180)) * this.radius;
      }
    },
    //当设置angleToPos时，以此值为半径计算位置
    radius: {
      get: function get() {
        return this._radius;
      },
      set: function set(value) {
        this._radius = value;
        this.realX = this.center[0] + Math.sin(this._angleToPos * (Math.PI / 180)) * this.radius;
        this.realY = this.center[1] + Math.cos(this._angleToPos * (Math.PI / 180)) * this.radius;
      }
    },
    //当设置angleToPos时，以此值为圆心计算位置[0,0]
    center: {
      get: function get() {
        return this._center;
      },
      set: function set(value) {
        this._center = value;
        this.realX = this.center[0] + Math.sin(this._angleToPos * (Math.PI / 180)) * this.radius;
        this.realY = this.center[1] + Math.cos(this._angleToPos * (Math.PI / 180)) * this.radius;
      }
    },
    zIndex: {
      get: function get() {
        return this.node.zIndex;
      },
      set: function set(value) {
        this.node.zIndex = value;
        this.dispatchListener('zIndex', value);
      }
    },
    active: {
      get: function get() {
        return this.node.active == true ? 1 : 0;
      },
      set: function set(value) {
        this.node.active = value != 0;
        this.dispatchListener('active', value);
      }
    },
    parent: {
      get: function get() {
        return this.node.parent;
      },
      set: function set(value) {
        this.node.parent = value;
      }
    },
    group: {
      get: function get() {
        return this.node.group;
      },
      set: function set(value) {
        if (CocosMgr.isInApp) {
          this.node.group = value == true ? 'storyui' : 'default';
        }
      }
    },
    zoomRatio: {
      get: function get() {
        if (this.camera != null) {
          return this.camera.zoomRatio;
        }

        return 0;
      },
      set: function set(value) {
        // console.log('codenode 更新了zoomRatio', value ,this.camera)
        if (this.camera != null) {
          this.camera.zoomRatio = value;
        } else {
          this.scaleX = 1 / value;
          this.scaleY = 1 / value;
          this.updatePreview();
        }
      }
    },
    fontSize: {
      get: function get() {
        if (this.label == null) {
          return 0;
        }

        return this.label.fontSize;
      },
      set: function set(value) {
        if (this.label != null) {
          this.label.fontSize = value;
          this.label.lineHeight = value + 10;
        }
      }
    },
    overflow: {
      get: function get() {
        if (this.label == null) {
          return -1;
        }

        return this.label.overflow;
      },
      set: function set(value) {
        if (this.label != null) {
          this.label.overflow = value;
        }
      }
    },
    string: {
      get: function get() {
        if (this.label == null) {
          return '';
        }

        return this.label.string;
      },
      set: function set(value) {
        if (this.label != null) {
          this.label.string = value;
          this.dispatchListener('string', value);
        }
      }
    },
    anchorX: {
      get: function get() {
        return this.node.anchorX;
      },
      set: function set(value) {
        this.node.anchorX = value;
        this.updatePreview();
      }
    },
    anchorY: {
      get: function get() {
        return this.node.anchorY;
      },
      set: function set(value) {
        this.node.anchorY = value;
        this.updatePreview();
      }
    },
    color: {
      get: function get() {
        return this.node.color.toHEX("#rrggbb");
      },
      set: function set(value) {
        if (this._color != value) {
          this._color = value;
        }

        this.node.color = cc.Color.WHITE.fromHEX(value);
      }
    },
    ccColor: {
      get: function get() {
        return this.node.color;
      },
      set: function set(value) {}
    },
    r: {
      get: function get() {
        return this.node.color.r;
      },
      set: function set(value) {
        this.node.color = this.node.color.setR(value);
      }
    },
    g: {
      get: function get() {
        return this.node.color.r;
      },
      set: function set(value) {
        this.node.color = this.node.color.setG(value); // console.log("设置了节点的g值", value, this.node.color.getG())
      }
    },
    b: {
      get: function get() {
        return this.node.color.b;
      },
      set: function set(value) {
        this.node.color = this.node.color.setB(value);
      }
    },
    outLineColor: {
      get: function get() {
        return this._outLineColor;
      },
      set: function set(value) {
        if (this._outLineColor != value) {
          this._outLineColor = value;
        }

        if (this.outLineComp != null) {
          this.outLineComp.color = cc.Color.WHITE.fromHEX(value);
        }
      }
    },
    outLineWidth: {
      get: function get() {
        return this._outLineWidth;
      },
      set: function set(value) {
        var oldValue = this._outLineWidth;

        if (this._outLineWidth != value) {
          this._outLineWidth = value;
        }

        if (this._outLineWidth < 0) {
          this._outLineWidth = 0;
        }

        if (this._outLineWidth > 0) {
          if (this.modal == CocosMgr.ObjectTypeEnum.text) {
            if (this.outLineComp == null) {
              this.outLineComp = this.addComponent(cc.LabelOutline);
              this.outLineComp.color = cc.Color.WHITE.fromHEX(this.outLineColor);
            }

            this.outLineComp.width = value;
          } else if (this.spineCom != null || this.sprite != null) {
            if (oldValue == 0) {
              this.setOutLine(true);
            }
          }
        } else {
          if (this.outLineComp != null) {
            this.outLineComp.width = 0;
          } else if (this.spineCom != null || this.sprite != null) {
            if (oldValue > 0) {
              this.setOutLine(false);
            }
          }
        }
      }
    },
    //设置碰撞框
    _colliderValue: null,
    colliderValue: {
      get: function get() {
        return this._colliderValue;
      },
      set: function set(value) {
        //暂时碰撞框一旦生成不能再变动
        // console.log('设置碰撞框', this.node.name, value)
        if (Object.keys(value).length != 0 && value.pointArr != null && value.pointArr.length != 0 && this._colliderValue == null) {
          // console.log('我显示了碰撞框', this.node.name,  value)
          var comp = this.checkAddComponent('SpinePlusComponent');
          this._colliderValue = value;
          comp.customCollider = true;
          var scale = value.scale || 1;
          var colliderArr = [];

          for (var z = 0; z < value.pointArr.length; z++) {
            var collider = this.addComponent(cc.PolygonCollider);
            colliderArr.push(collider); // let offset = value[z].offset

            var points = value.pointArr[z]; // collider.offset = cc.v2(value.offsetX, value.offsetY)    //不可以使用offset，无法影响点击触碰判断

            for (var i = 0; i < points.length; i++) {
              var v2 = collider.points[i];
              if (!v2) collider.points.push(cc.v2());
              collider.points[i].x = (points[i].x - this.anchorX) * value.baseWidth / scale + value.offsetX; //+  value.offsetX //- colliderValue.offsetX) / colliderValue.scale 

              collider.points[i].y = (points[i].y - this.anchorY) * value.baseHeight / scale * -1 + value.offsetY; //+ value.offsetY //* colliderValue.baseWidth - colliderValue.offsetY) / colliderValue.scale 
            }
          }

          comp.polygonColliderArr = colliderArr;
        } else {//不能修改，会影响spine动画自带的碰撞框
          // let comp = this.checkAddComponent('SpinePlusComponent')
          // comp.customCollider = false
          // comp.polygonColliderArr = []
          // this._colliderValue = null
          // while(this.getComponent(cc.PolygonCollider) != null){
          //     let collider = this.getComponent(cc.PolygonCollider)
          //     this.removeComponent(collider)
          // }
        }
      }
    },
    _outLineWidth: 0,
    _outLineColor: 'ffffff',
    _color: 'ffffff',
    offsetx: 0,
    offsety: 0,
    _radius: 0,
    _angleToPos: 0,
    _center: [0, 0],
    _customeName: '',
    useCenterMode: false,
    inMapMap: 0,
    //是否在地图中
    girdX: 0,
    //x坐标，如果该物品尺寸大于1格子，以最小的x作为起点
    girdY: 0,
    //y坐标，如果该物品尺寸大于1格子，以最小的y作为起点
    widthGird: 1,
    //作为格子，占用几个格子宽
    heightGird: 1,
    //作为格子物品，占用几个格子高
    girdTypeArr: [],
    //可以放置的格子类型
    dynamiczIndex: false
  },
  //设置描边
  setOutLine: function setOutLine(isOutLine) {
    var _this3 = this;

    if (isOutLine == true) {
      cc.resources.load('sharder/RenderOutLine', cc.Material, function (err, mat) {
        if (mat != null) {
          // console.log('mat', mat)
          if (_this3.spineCom != null) {
            _this3.spineCom.setMaterial(0, mat);
          } else if (_this3.sprite != null) {
            _this3.sprite.setMaterial(0, mat);
          }
        }
      });
    } else {
      if (this.spineCom != null) {
        this.spineCom.setMaterial(0, cc.Material.getBuiltinMaterial('2d-spine'));
      } else if (this.sprite != null) {
        this.sprite.setMaterial(0, cc.Material.getBuiltinMaterial('2d-sprite'));
      }
    }
  },
  onLoad: function onLoad() {
    // console.log('所有节点的通用脚本加载了')
    this.init();
  },
  // LIFE-CYCLE CALLBACKS:
  init: function init() {
    if (cc.isValid(this.node) == false) {
      return;
    }

    this.robotListenerCount = {};
    this.camera = this.node.getComponent(cc.Camera);
    this.sprite = this.node.getComponent(cc.Sprite);
    this.spineCom = this.node.getComponent(sp.Skeleton);
    this.label = this.node.getComponent(cc.Label);
    this.outLineComp = this.node.getComponent(cc.LabelOutline);
    this.ctx = this.node.getComponent(cc.Graphics); // if(this.ctx != null){
    // this.updatePreview()
    // }
    // if(this.node.isClone == true){
    //     if(this.spineCom && this.spineCom.skeletonData != null){
    //         this.spineCom.skeletonData.addRef()
    //     }
    //     if(this.sprite && this.sprite.spriteFrame != null){
    //         this.sprite.spriteFrame.addRef()
    //     }
    // }
    // console.log("codeNode.init")
  },
  addComponent: function addComponent(com) {
    if (typeof com == 'string') {
      if (cc.js.getClassByName(com) == null) {
        console.warn('组件' + com + '不存在');
        return;
      }
    }

    var comPonent = this.node.addComponent(com);
    return comPonent;
  },
  //删除所有子节点
  clearChildren: function clearChildren() {
    if (cc.isValid(this.node)) {
      for (var i = 0; i < this.node.children.length; i++) {
        this.node.children[i].destroy(); // i--
      }
    }
  },
  checkAddComponent: function checkAddComponent(com) {
    var _this4 = this;

    if (typeof com == 'string') {
      if (cc.js.getClassByName(com) == null) {
        console.warn('组件' + com + '不存在');
        return;
      }
    }

    var comPonent = this.node.getComponent(com);

    if (comPonent == null) {
      comPonent = this.addComponent(com);
    }

    this.scheduleOnce(function () {
      // if(com == 'SpinePlusComponent'){
      //     console.log('添加了SpinePlusComponent，此时是否有graph', this.graph)
      // }
      if (com == 'SpinePlusComponent' && _this4.graph != null) {
        var rootccNode = _this4.graph.vars.rootccNode;

        if (rootccNode == null) {
          rootccNode = cc.director.getScene().getChildByName('Canvas');
        }

        var cameraNode = rootccNode.getChildByName('Camera'); // console.log('添加SpinePlusComponent的时候是否有cameraa', cameraNode)

        if (cameraNode != null) {
          comPonent.camera = cameraNode.getComponent(cc.Camera);

          if (comPonent.camera == null) {
            if (CocosMgr.isInApp == false) {
              cameraNode = rootccNode.getChildByName('Main Camera');
              comPonent.camera = cameraNode.getComponent(cc.Camera);
            }
          }
        } else {
          if (CocosMgr.isInApp == false) {
            cameraNode = rootccNode.getChildByName('Main Camera');
            comPonent.camera = cameraNode.getComponent(cc.Camera);
          }
        }
      }
    }, 0);
    return comPonent;
  },
  removeComponent: function removeComponent(com) {
    if (cc.isValid(this.node)) {
      this.node.removeComponent(com);
    }
  },
  //更新视图
  updatePreview: function updatePreview() {
    // console.log('updatePreview', this.ctx)
    if (this.ctx == null) {
      return;
    }

    if (this.disableUpdatePreview == true) {
      return;
    }

    this.ctx.clear();
    var camera = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera');
    var zoomRatio = 1;

    if (camera != null) {
      zoomRatio = camera.getComponent(cc.Camera).zoomRatio;
    }

    this.ctx.lineWidth = 4 * (1 / this.scaleX) * (1 / cc.view.getScaleX()) * (1 / zoomRatio);
    console.log('绘制了preview ' + this.nodeName, this.scaleX);
    this.ctx.strokeColor = cc.Color.BLUE.fromHEX('#3F42EA');
    this.ctx.rect(-this.width * this.anchorX, -this.height * this.anchorY, this.width, this.height);
    this.ctx.stroke();
  },
  getComponent: function getComponent(com) {
    return this.node.getComponent(com);
  },
  getChildByName: function getChildByName(name) {
    return this.node.getChildByName(name);
  },
  on: function on(event, func, target) {
    if (cc.isValid(this.node)) {
      if (target != null) {
        this.node.on(event, func, target);
      } else {
        this.node.on(event, func, this);
      }
    }
  },
  targetOff: function targetOff(target) {
    if (cc.isValid(this.node)) {
      if (target != null) {
        this.node.targetOff(target);
      } else {
        this.node.targetOff(this);
        this.node.off(cc.Node.EventType.TOUCH_START);
        this.node.off(cc.Node.EventType.TOUCH_MOVE);
        this.node.off(cc.Node.EventType.TOUCH_END);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL);
      }
    }
  },
  destroyNode: function destroyNode() {
    if (cc.isValid(this.node)) {
      this.node.destroy();
    }

    this.robotListener = {};
  },
  // destroy(){
  //     console.log('code node destroy')
  //     super.destroy()
  // },
  onDestroy: function onDestroy() {
    //在这里释放掉引用的资源吗？
    if (this.spineCom && this.spineCom.skeletonData != null) {
      // console.log('释放引用资源', this.spineCom.skeletonData)
      // cc.assetManager.releaseAsset(this.spineCom.skeletonData)
      // this.spineCom.skeletonData.decRef()
      this.spineCom.skeletonData = null;
    }

    if (this.sprite && this.sprite.spriteFrame != null) {
      // cc.assetManager.releaseAsset(this.sprite.spriteFrame)
      // this.sprite.spriteFrame.decRef()
      this.sprite.spriteFrame = null;
    }

    this.graph = null;
    cc.Tween.stopAllByTarget(this.codeNode);
  },
  addRobotListener: function addRobotListener(key, bindId, func) {
    if (this.robotListener == null) {
      this.robotListener = {};
    }

    if (this.robotListener[key] == null) {
      this.robotListener[key] = {};
    }

    this.robotListener[key][bindId] = func;
  },
  removeRobotListener: function removeRobotListener(key, bindId) {
    if (this.robotListener == null) {
      this.robotListener = {};
    }

    if (this.robotListener[key] != null) {
      delete this.robotListener[key][bindId];
    }
  },
  dispatchListener: function dispatchListener(key, data) {
    if (this.robotListener == null) {
      return;
    } // if(cc.codeJsonDevConfig.curIsdebugMode == true){
    //     if(this.robotListenerCount[key] == null){
    //         this.robotListenerCount[key] = 0
    //     }
    //     if(this.robotListenerCount[key] < 5){
    //         this.robotListenerCount[key] += 1
    //         return
    //     }
    //     this.robotListenerCount[key] = 0
    // }


    if (this.robotListener[key] != null) {
      for (var keyid in this.robotListener[key]) {
        this.robotListener[key][keyid](data);
      }
    }
  },
  onCollisionEnter: function onCollisionEnter(other, self) {
    var codeNode = other.node.getComponent('CodeNodeLg'); // console.log('onCollisionEnter', other, self, codeNode,  other.node.getComponent('CodeNode'))

    this.dispatchListener('contact', codeNode);
  },
  onCollisionExit: function onCollisionExit(other, self) {
    var codeNode = other.node.getComponent('CodeNodeLg');
    this.dispatchListener('uncontact', codeNode);
  },
  getWorldPos: function getWorldPos() {
    return this.node.parent.convertToWorldSpaceAR(this.node.position);
  },
  //设置皮肤
  setSkin: function setSkin(skin) {
    if (cc.isValid(this.node) == false) {
      return;
    }

    if (this.spineCom == null) {
      this.spineCom = this.node.getComponent(sp.Skeleton);
    }

    if (this.spineCom == null) {
      return;
    }

    try {
      this.spineCom.setSkin(skin);
    } catch (error) {}
  },
  //设置播放动画
  playAnimation: function playAnimation(aniName, loop, softChange, onEvent, onEnd) {
    if (cc.isValid(this.node) == false) {
      return;
    }

    if (this.spineCom == null) {
      this.spineCom = this.node.getComponent(sp.Skeleton);
    }

    if (this.spineCom == null) {
      return;
    }

    if (aniName == '') {
      console.warn('输入了无效的aniName'); // return
    }

    this.spineCom.paused = false;

    if (onEvent != null) {
      this.spineCom.setEventListener(onEvent);
    } // this.spineCom.setEventListener((trackEntry, event)=>{
    //     // cc.log('spineCom event.data', event.data)
    //     if(event.intValue < 0){
    //         return
    //     }
    //     console.log("TODO: 这里应该播放spine事件声音", event.data.name, this.node.name + ':' + trackEntry.animation.name)
    //     //查找是否有音频节点的资源名称为 event.data.name，如果有就可以直接播放音频了
    //     //this.codeProgress.playSound(event.data.name ,spineCom.node.name + ':' + trackEntry.animation.name)
    // });


    if (onEnd != null) {
      this.spineCom.setCompleteListener(function (trackEntry) {
        var ccompleteName = trackEntry.animation.name;

        if (ccompleteName == aniName) {
          if (onEnd != null) {
            onEnd();
          }
        }
      });
    }

    if (softChange == true) {
      this.spineCom.loop = false;
      this.spineCom.addAnimation(0, aniName, loop);
    } else {
      this.spineCom.setAnimation(0, aniName, loop);
    } // if(onClick != null){
    //     this.on(cc.Node.EventType.TOUCH_END, ()=>{
    //     })
    // }

  },
  pauseAnimation: function pauseAnimation(isPause) {
    if (cc.isValid(this.node) == false) {
      return;
    }

    if (this.spineCom == null) {
      this.spineCom = this.node.getComponent(sp.Skeleton);
    }

    if (this.spineCom == null) {
      return;
    }

    if (isPause == null) {
      isPause = true;
    }

    this.spineCom.paused = isPause;
  },
  //设置spine组件的相关属性
  setAnimationProb: function setAnimationProb(key, value) {
    if (cc.isValid(this.node) == false) {
      return;
    }

    if (this.spineCom == null) {
      this.spineCom = this.node.getComponent(sp.Skeleton);
    }

    if (this.spineCom == null) {
      return;
    }

    this.spineCom[key] = value;
  } // start () {
  // },
  // update (dt) {},

});
exports.CodeNodeLg = CodeNodeLg;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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