
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/MotionText.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'caee6I4BiBPq4CtEWmQrOX1', 'MotionText');
// Script/Common/LiteGraphCore/MotionText.ts

"use strict";
// import BaseStoryScene from "../../../script/story/BaseStoryScene";
// import { EventCenter } from "../../../script/UIFrame/EventCenter";
// import { EventConst } from "../../../script/logic/EventConst";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// import GlobalConfig from "../../../script/logic/GlobalConfig";
// const {ccclass, property, menu} = cc._decorator;
//使用方式
//该脚本挂载到页面prefab根结点上，并且物体类型设置为Label，或者Node节点需要添加Label
//为0时关闭并恢复到motionText
//this.node.getComponent('MotionText').inputHandle({data: 0})
//为1时播放（如果已经在播放状态则为重新播放）
//this.node.getComponent('MotionText').inputHandle({data: 1})
// @ccclass
// @menu('自定义组件/MotionText')
var MotionText = /** @class */ (function (_super) {
    __extends(MotionText, _super);
    function MotionText() {
        // LIFE-CYCLE CALLBACKS:
        var _this = _super !== null && _super.apply(this, arguments) || this;
        //初始化完成后自动bof
        // @property({ type: Boolean })
        _this.autoRun = false;
        // @property({ type: Boolean })
        _this.pause = false;
        // @property({ type: Number })
        _this.curTime = 0;
        // @property({ type: Boolean })
        _this.isActive = false;
        // @property({ type: String })
        _this.position = '0,0.6,1';
        // @property({ type: String })
        _this.positionTime = '0,1.4,2';
        // @property({ type: Boolean })
        _this.hideBaseLabel = false;
        // @property({ type: Boolean })
        _this.hideBeforRun = false;
        // @property({ type: Boolean })
        _this.hideAfterRun = false;
        _this.positionTimeArr = [];
        _this.positionArr = [];
        // @property({ type: Number })
        _this.dotIndex = 1;
        // @property({ type: Number })
        _this.delay = 0;
        // @property({ type: String })
        _this.maskColor = '88BF3D';
        // @property({ type: Boolean })
        _this.stopIsPlayEnd = false;
        //方向
        // @property({ type: Number })
        _this.dir = 0;
        _this.oriOpacity = 255;
        _this.hasInit = false;
        return _this;
    }
    MotionText.prototype.onLoad = function () {
        // console.log('motionText onLoad')
        // if(GlobalConfig.recordMode == true){
        //     //录音模式不开启字幕
        //     this.node.active = false
        // }
        if (this.node.getComponent('CodeNode') == null && this.node.getComponent('CodeNodeLg') == null) {
            //常规脚本OnLoad时候即可初始化
            // console.log('motionText在onload就初始化了')
            this.init();
            this.addEventListener();
        }
    };
    MotionText.prototype.init = function () {
        var _this = this;
        if (this.hasInit == true) {
            // console.log('motionText 已经初始化，不重复init')
            return;
        }
        // console.log('motionText init', this.node.name + ':' + this.node.opacity)
        this.oriOpacity = this.node.opacity;
        this.node.anchorX = 0;
        var childLabel = new cc.Node();
        var childLabelCom = childLabel.addComponent(cc.Label);
        var selfLabel = this.node.getComponent(cc.Label);
        childLabelCom.font = selfLabel.font;
        childLabelCom.fontSize = selfLabel.fontSize;
        // childLabel.anchorX = selfLabel.node.anchorX
        // childLabel.anchorY = selfLabel.node.anchorY
        childLabelCom.string = selfLabel.string;
        childLabelCom.lineHeight = selfLabel.lineHeight;
        childLabelCom.overflow = selfLabel.overflow;
        childLabelCom.enableBold = selfLabel.enableBold;
        childLabelCom.enableItalic = selfLabel.enableItalic;
        childLabelCom.enableUnderline = selfLabel.enableUnderline;
        childLabelCom.horizontalAlign = selfLabel.horizontalAlign;
        childLabelCom.verticalAlign = selfLabel.verticalAlign;
        if (this.hideBaseLabel == true) {
            this.scheduleOnce(function () {
                selfLabel.enabled = false;
            }, 0);
        }
        var selfLabelOutLine = this.node.getComponent(cc.LabelOutline);
        if (selfLabelOutLine != null) {
            var labelOutLine = childLabel.addComponent(cc.LabelOutline);
            labelOutLine.width = selfLabelOutLine.width;
            labelOutLine.color = selfLabelOutLine.color;
        }
        var maskNode = new cc.Node();
        // maskNode.anchorX = this.node.anchorX
        // maskNode.anchorY = this.node.anchorY
        //maskNode是颜色过渡方向，
        //横向文本固定从左到右
        //竖线文本固定从上到下
        if (this.dir == 0) {
            maskNode.anchorX = 0;
            maskNode.anchorY = 0.5;
        }
        else {
            maskNode.anchorX = 0.5;
            maskNode.anchorY = 1;
        }
        var mask = maskNode.addComponent(cc.Mask);
        maskNode.parent = this.node;
        childLabel.parent = maskNode;
        // maskNode.x = 0
        // maskNode.y = 0
        maskNode.width = this.node.width;
        maskNode.height = this.node.height;
        //有时候高度不会立马更新
        this.scheduleOnce(function () {
            childLabel.width = _this.node.width;
            childLabel.height = _this.node.height;
            //mask节点根据上一个节点的anchor设置位置
            if (_this.dir == 0) {
                maskNode.width = 0;
                maskNode.height = _this.node.height;
                //如果出现左右没对齐，大概率是这里的问题
                maskNode.x = -1 * _this.node.width * _this.node.anchorX;
                //如果出现上下没对齐，大概率是这里的问题
                maskNode.y = _this.node.height * (0.5 - _this.node.anchorY);
            }
            else {
                maskNode.y = _this.node.height * (1 - _this.node.anchorY);
                //如果出现上下没对齐，大概率是这里的问题
                maskNode.x = 0;
                maskNode.width = _this.node.width;
                maskNode.height = 0;
            }
        }, 0);
        childLabel.anchorX = maskNode.anchorX;
        childLabel.anchorY = maskNode.anchorY;
        childLabel.y = 0;
        childLabel.x = 0;
        this.positionTimeArr = this.positionTime.split(',');
        this.positionArr = this.position.split(',');
        // console.log('positionTimeArr', this.positionTimeArr, this.positionArr)
        if (this.dir == 0) {
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
        }
        if (this.hideBeforRun == true) {
            this.node.opacity = 1;
        }
        childLabel.color = cc.Color.WHITE.fromHEX(this.maskColor);
        // setTimeout(() => {
        //     console.log('当前label尺寸', this.node.width, this.node.height)
        //     console.log('生成的蒙皮尺寸', maskNode.width, maskNode.height)
        //     console.log('生成的过渡label尺寸', childLabel.width, childLabel.height)
        // }, 1000);
        if (this.autoRun == true) {
            this.inputHandle({ data: 1 });
        }
        this.hasInit = true;
    };
    //重置时间
    // this.node.getComponent('AutoTips').inputHandle({data: 1, targetSolt: 'resetTime'})
    MotionText.prototype.inputHandle = function (inputData) {
        var _this = this;
        //接收输入的参数，输入0时关闭，不为0时开启
        // console.log('motionText inputHandle', inputData)
        if (inputData.targetSolt == 'hide') {
            this.hide();
            return;
        }
        if (inputData.data == 0) {
            // console.log("关闭字幕")
            this.isActive = false;
            this.stopRun();
            return;
        }
        // console.log("激活字幕", this.positionTime, this.positionTimeArr, this.position, this.positionArr)
        this.isActive = true;
        this.curTime = 0;
        this.dotIndex = 1;
        if (this.dir == 0) {
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
        }
        cc.Tween.stopAllByTarget(this.node);
        if (this.hideBeforRun == true) {
            this.node.opacity = 1;
            cc.tween(this.node).to(0.4, { opacity: this.oriOpacity }).start();
        }
        this.scheduleOnce(function () {
            // console.log('开始播放字幕', this.node.getComponent(cc.Label).string)
            _this.startRun();
        }, 0);
    };
    // public outputHandle = (key , data)=>{
    //     // this.outputHandle('onclick', 1)
    // }
    MotionText.prototype.stopRun = function () {
        // console.log('motionText this.hasInit', this.hasInit, this.oriOpacity)
        if (this.hasInit == false) {
            // console.log("motionText 都没有初始化，不要继续执行了 stopRun")
            return;
        }
        cc.Tween.stopAllByTarget(this.node.children[0]);
        if (this.dir == 0) {
            // if(this.stopIsPlayEnd != true){
            // }else{
            //     this.node.children[0].width = this.node.width
            // }
            this.node.children[0].width = Number(this.positionArr[0]);
        }
        else {
            this.node.children[0].height = Number(this.positionArr[0]);
            // if(this.stopIsPlayEnd != true){
            // }else{
            //     this.node.children[0].height = this.node.height
            // }
        }
        if (this.stopIsPlayEnd == true) {
            if (this.node.oriColor == null) {
                this.node.oriColor = this.node.color.toHEX("#rrggbb");
            }
            this.node.color = cc.Color.WHITE.fromHEX(this.maskColor);
        }
        // console.log('motionText this.stopIsPlayEnd', this.stopIsPlayEnd, this.positionArr)
        if (this.hideBeforRun == true) {
            cc.Tween.stopAllByTarget(this.node);
            this.node.opacity = 1;
        }
        // console.log('字幕stopRun', this.node.getComponent(cc.Label).string)
    };
    MotionText.prototype.hide = function () {
        cc.Tween.stopAllByTarget(this.node);
        cc.tween(this.node).to(0.4, { opacity: 0 }).start();
    };
    MotionText.prototype.startRun = function () {
        var _this = this;
        if (this.node.oriColor != null) {
            this.node.color = cc.Color.WHITE.fromHEX(this.node.oriColor);
        }
        var width = this.positionArr[this.dotIndex];
        var obj = {};
        if (this.dir == 0) {
            obj = { width: width * this.node.width };
        }
        else {
            obj = { height: width * this.node.height };
        }
        var time = this.positionTimeArr[this.dotIndex] - this.positionTimeArr[this.dotIndex - 1];
        console.log('motionText startRun', this.dotIndex, this.node.width, this.delay, this.positionArr.join(','), obj);
        if (time < 0) {
            //时间不应该为0了吧
            time = 0.1;
            console.warn('时间点错误，后面的时间点小于前面的，自动设置为0.1', time);
        }
        cc.Tween.stopAllByTarget(this.node.children[0]);
        cc.tween(this.node.children[0]).delay(this.delay).to(time, obj).call(function () {
            if (_this.positionArr[_this.dotIndex + 1] != null) {
                _this.dotIndex += 1;
                _this.startRun();
            }
            else {
                //正常播放结束的话
                if (_this.outputHandle != null) {
                    _this.outputHandle('onend', 1);
                }
                // console.log('是否播放结束了', this.node.getComponent(cc.Label).string, this.hideAfterRun)
                if (_this.hideAfterRun == true) {
                    cc.tween(_this.node).to(0.4, { opacity: 0 }).start();
                }
            }
        }).start();
    };
    MotionText.prototype.addEventListener = function () {
        var _this = this;
        cc.game.targetOff(this);
        cc.game.on('replayPage', function () {
            if (_this.dir == 0) {
                _this.node.children[0].width = Number(_this.positionArr[0]);
            }
            else {
                _this.node.children[0].height = Number(_this.positionArr[0]);
            }
            if (_this.hideBeforRun == true) {
                _this.node.opacity = 1;
            }
            else {
                _this.node.opacity = _this.oriOpacity;
            }
            if (_this.autoRun == true) {
                _this.inputHandle({ data: 1 });
            }
        }, this);
        cc.game.on('pause', function () {
            _this.robotPause();
        }, this);
        cc.game.on('resume', function () {
            _this.robotResume();
        }, this);
    };
    MotionText.prototype.robotStart = function () {
        if (this.node == null) {
            console.warn('当前没有node', this);
            return;
        }
        if (this.node.children[0] == null) {
            this.init();
        }
        else {
            this.stopRun();
            if (this.autoRun == true) {
                this.inputHandle({ data: 1 });
            }
        }
        this.addEventListener();
    };
    MotionText.prototype.robotRelease = function () {
        this.pause = false;
        cc.game.targetOff(this);
        if (cc.isValid(this.node)) {
            cc.Tween.stopAllByTarget(this.node.children[0]);
            cc.Tween.stopAllByTarget(this.node);
        }
    };
    MotionText.prototype.robotPause = function () {
        this.pause = true;
        cc.director.getActionManager().pauseTarget(this.node.children[0]);
    };
    MotionText.prototype.robotResume = function () {
        this.pause = false;
        cc.director.getActionManager().resumeTarget(this.node.children[0]);
    };
    // update (dt) {
    //     if(this.pause == true){
    //         return
    //     }
    //     if(this.isActive == false){
    //         return
    //     }
    // }
    MotionText.prototype.onDestroy = function () {
        cc.game.targetOff(this);
        // EventCenter.targetOff(this);
    };
    return MotionText;
}(cc.Component));
exports.default = MotionText;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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