
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/ScaleObj.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'c1831oKwtBEmaKfum7AMie0', 'ScaleObj');
// Script/Common/LiteGraphCore/ScaleObj.js

"use strict";

exports.__esModule = true;
exports.ScaleObj = void 0;
var ScaleObj = cc.Class({
  "extends": cc.Component,
  properties: {
    //debugLabel:cc.Label
    scaleMin: 0.5,
    scaleMax: 2,
    dynimicCenter: 0
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    this.addTouchEvent();
  },
  addTouchEvent: function addTouchEvent() {
    this.node.targetOff(this);
    this.touchIds = {};
    this.node.on(cc.Node.EventType.TOUCH_START, this.touchStart, this);
    this.node.on(cc.Node.EventType.TOUCH_MOVE, this.moveFun, this);
    this.node.on(cc.Node.EventType.TOUCH_END, this.cancelFun, this);
    this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.cancelFun, this);
    this.node.on(cc.Node.EventType.MOUSE_WHEEL, this.mouseWheel, this);
    console.log('我开启了缩放监听');
  },
  mouseWheel: function mouseWheel(event) {
    if (this.dynimicCenter == 1) {
      this.startScale = this.node.scale;
      this.startPos = this.node.convertToNodeSpaceAR(cc.v2(this.node.width * 0.5, this.node.height * 0.5));
    }

    var scaleDel = event.getScrollY() / 2000;
    this.node.scale += scaleDel;

    if (this.node.scale > this.scaleMax) {
      this.node.scale = this.scaleMax;
    }

    if (this.node.scale < this.scaleMin) {
      this.node.scale = this.scaleMin;
    }

    if (this.dynimicCenter == 1) {
      this.node.x += this.startPos.x * this.startScale - this.node.scale * this.startPos.x;
      this.node.y += this.startPos.y * this.startScale - this.node.scale * this.startPos.y;
    }

    if (this.outputHandle != null) {
      this.outputHandle('onScale', this.node.scale);
    }
  },
  inputHandle: function inputHandle(inputData) {
    if (inputData.data == 0) {
      this.touchIds = {};
      this.node.targetOff(this);
    } else {
      this.addTouchEvent();
    }
  },
  touchStart: function touchStart(event) {
    var eventid = event.getID();

    if (Object.keys(this.touchIds).length >= 2) {
      return;
    }

    this.touchIds[eventid] = {
      start: event.getLocation(),
      move: event.getLocation()
    };

    if (Object.keys(this.touchIds).length == 2) {
      this.scaleNow = this.node.scale; // if(this.dynimicCenter == 1){
      //     this.startScale = this.node.scale
      //     this.startPos = this.node.convertToNodeSpaceAR(cc.v2(this.node.width * 0.5, this.node.height * 0.5))
      // }
    }
  },
  moveFun: function moveFun(event) {
    var eventid = event.getID();
    var touchKeys = Object.keys(this.touchIds);

    if (touchKeys.length < 2) {
      //在开始缩放之前，先记录第一个触摸到屏幕的手指的位置
      this.touchIds[eventid].start = event.getLocation();
      this.touchIds[eventid].move = event.getLocation();
      return;
    }

    if (this.dynimicCenter == 1) {
      this.startScale = this.node.scale;
      this.startPos = this.node.convertToNodeSpaceAR(cc.v2(this.node.width * 0.5, this.node.height * 0.5));
    }

    this.touchIds[eventid].move = event.getLocation();
    var key1 = touchKeys[0];
    var key2 = touchKeys[1];
    var lengthStart = this.touchIds[key1].start.sub(this.touchIds[key2].start).mag();
    var lengthNow = this.touchIds[key1].move.sub(this.touchIds[key2].move).mag();
    var scale = lengthNow / lengthStart;
    this.node.scale = this.scaleNow * scale;

    if (this.node.scale > this.scaleMax) {
      this.node.scale = this.scaleMax;
    }

    if (this.node.scale < this.scaleMin) {
      this.node.scale = this.scaleMin;
    }

    if (this.dynimicCenter == 1 && this.startPos != null) {
      this.node.x += this.startPos.x * this.startScale - this.node.scale * this.startPos.x;
      this.node.y += this.startPos.y * this.startScale - this.node.scale * this.startPos.y;
    }

    if (this.outputHandle != null) {
      this.outputHandle('onScale', this.node.scale);
    } // if(this.debugLabel != null){
    //     this.debugLabel.string = lengthNow + ',' + lengthStart + ',' + this.scaleNow
    // }

  },
  cancelFun: function cancelFun(event) {
    var eventid = event.getID();
    delete this.touchIds[eventid];
    var self = this;
    self.startTouch = false;

    if (self.canMove == false) {
      return;
    } // if(self.gameCtrl.inEnterDoor == true){return}
    // chectPlayerMove()


    if (self.touchEndHandle != null) {
      self.touchEndHandle();
    }
  },
  //删除要取消监听事件
  onDestroy: function onDestroy() {
    if (cc.isValid(this.node)) {
      this.node.targetOff(this);
    } // this.node.off(cc.Node.EventType.TOUCH_START, this.touchStart, this)
    // this.node.off(cc.Node.EventType.TOUCH_MOVE, this.moveFun, this)
    // this.node.off(cc.Node.EventType.TOUCH_END, this.cancelFun, this)
    // this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.cancelFun, this)

  },
  robotRelease: function robotRelease() {
    this.touchIds = {};

    if (cc.isValid(this.node)) {
      this.node.targetOff(this);
    }
  } // start () {},
  // update (dt) {},

});
exports.ScaleObj = ScaleObj;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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