
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/SpinePlusComponent.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1d5edQd7+dIoa/K+a6IRaJf', 'SpinePlusComponent');
// Script/Common/LiteGraphCore/SpinePlusComponent.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
// const { ccclass, property, menu } = cc._decorator;
var SpinePlusComponent = /** @class */ (function (_super) {
    __extends(SpinePlusComponent, _super);
    function SpinePlusComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.customCollider = false;
        _this.actions = '';
        _this.camera = null;
        _this.clickEvent = [];
        _this.completeEvent = [];
        _this.polygonColliderArr = [];
        // @property({
        //     tooltip: CC_DEV && '是否为动态区域'
        // })
        _this.isDynamic = false;
        return _this;
    }
    Object.defineProperty(SpinePlusComponent.prototype, "spine", {
        get: function () {
            return this._spine;
        },
        set: function (spine) {
            this._spine = spine;
        },
        enumerable: false,
        configurable: true
    });
    SpinePlusComponent.prototype.onLoad = function () {
        this._spine = this.node.getComponent(sp.Skeleton);
        if (this._spine != null) {
            this._colliderSlot = this._spine.findSlot('Collider');
        }
        else {
            this.customCollider = true;
        }
    };
    SpinePlusComponent.prototype.update = function () {
        if (!this._polygonCollider || !this._colliderSlot || !this.isDynamic)
            return;
        //console.log('this._colliderSlot.bone.worldX', this._colliderSlot.bone.worldX)
        this._polygonCollider.offset.x = this._colliderSlot.bone.worldX;
        this._polygonCollider.offset.y = this._colliderSlot.bone.worldY;
        this._polygonCollider.points = [];
        for (var index = 0; index < this._colliderSlot.deform.length / 2; index++) {
            var v2 = this._polygonCollider.points[index];
            if (!v2)
                this._polygonCollider.points.push(cc.v2());
            this._polygonCollider.points[index].x = this._colliderSlot.deform[index * 2];
            this._polygonCollider.points[index].y = this._colliderSlot.deform[index * 2 + 1];
        }
    };
    SpinePlusComponent.prototype.refreshCollider = function () {
        this._colliderSlot = this._spine.findSlot('Collider');
        var attachement = this._colliderSlot.getAttachment(); //this._spine.getAttachment('Collider', 'Collider');
        //console.log(this._spine, attachement);
        // if (!this._attachment) {
        //     console.log('未获取碰撞边界组件', this.node.name);
        //     return;
        // }
        // this._polygonCollider.points = [];
        // for (let index = 0; index < this._attachment.vertices.length / 2; index++) {
        //     let v2: cc.Vec2 = this._polygonCollider.points[index];
        //     if (!v2) this._polygonCollider.points.push(cc.v2());
        //     this._polygonCollider.points[index].x = this._attachment.vertices[index * 2];
        //     this._polygonCollider.points[index].y = this._attachment.vertices[index * 2 + 1];
        // }
    };
    SpinePlusComponent.prototype.start = function () {
        // console.log('spinePlusComponent start')
        if (this.customCollider == true) {
            this.polygonColliderArr = this.node.getComponents(cc.PolygonCollider);
            if (this.polygonColliderArr.length > 0) {
                this.node['_hitTest'] = this.hitTest.bind(this);
            }
            this.addTouchEvent();
            // console.log('使用了spinePlusComponent customCollider')
            return;
        }
        this._attachment = this._spine.getAttachment('Collider', 'Collider');
        // console.log(this.node.name, this._spine);
        if (!this._attachment) {
            // console.log('spinePlusComponent 未获取碰撞边界组件', this.node.name);
            return;
        }
        this._polygonCollider = this.node.addComponent(cc.PolygonCollider);
        for (var index = 0; index < this._attachment.vertices.length / 2; index++) {
            var v2 = this._polygonCollider.points[index];
            if (!v2)
                this._polygonCollider.points.push(cc.v2());
            this._polygonCollider.points[index].x = this._attachment.vertices[index * 2];
            this._polygonCollider.points[index].y = this._attachment.vertices[index * 2 + 1];
        }
        // console.log('spinePlusComponent _polygonCollider_' + this.node.name, this._polygonCollider)
        this.node['_hitTest'] = this.hitTest.bind(this);
        this.addTouchEvent();
        if (this.actions.length > 0) {
            this.actionList = this.actions.split(',');
        }
        // this._spine.setEventListener((trackEntry: sp.spine.TrackEntry, event: sp.spine.Event) => {
        //     //待优化
        //     this.node.emit('SpineEvent', event.data.name);
        // });
    };
    Object.defineProperty(SpinePlusComponent.prototype, "actionList", {
        get: function () {
            return this._actionList;
        },
        set: function (actionList) {
            this._actionList = actionList;
        },
        enumerable: false,
        configurable: true
    });
    //添加触摸事件
    SpinePlusComponent.prototype.addTouchEvent = function () {
        if (this.node.hasEventListener(cc.Node.EventType.TOUCH_END)) {
            return;
        }
        this.node.on(cc.Node.EventType.TOUCH_END, this.spineClick.bind(this), this);
    };
    //移除触摸事件
    SpinePlusComponent.prototype.removeTouchEvent = function () {
        this.actionList = [];
        this.clickEvent = [];
        this.node.off(cc.Node.EventType.TOUCH_END, this.spineClick.bind(this), this);
    };
    SpinePlusComponent.prototype.playSpineAnimation = function () {
        var _this = this;
        if (!this._actionList)
            return;
        this.node.pauseSystemEvents(true);
        var aList = this._actionList.concat();
        var actName = this._endActName = aList.shift();
        var loopName = aList.pop();
        this._spine.setAnimation(0, actName, false);
        for (var index = 0; index < aList.length; index++) {
            var element = this._endActName = aList[index];
            this._spine.addAnimation(0, element, false);
        }
        this._spine.addAnimation(0, loopName, true);
        this._spine.setCompleteListener(function (trackEntry, loopCount) {
            var cAct = trackEntry.animation.name;
            //console.log(cAct, this._endActName);
            if (cAct == _this._endActName) {
                _this.node.resumeSystemEvents(true);
                _this._spine.setCompleteListener(null);
                cc.Component.EventHandler.emitEvents(_this.completeEvent, _this._spine);
            }
        });
    };
    SpinePlusComponent.prototype.spineClick = function () {
        this.playSpineAnimation();
        //console.log('click spine');
        cc.Component.EventHandler.emitEvents(this.clickEvent, this._spine);
    };
    SpinePlusComponent.prototype.hitTest = function (point) {
        // 坐标转换 //convertToNodeSpaceAR
        // let hitPos: cc.Vec2 = this.node.convertToNodeSpaceAR(point);
        var hitPos;
        if (this.camera) {
            var cpoint = this.camera.getScreenToWorldPoint(point);
            hitPos = this.node.convertToNodeSpaceAR(cpoint);
        }
        else {
            hitPos = this.node.convertToNodeSpaceAR(point);
        }
        if (this.polygonColliderArr != null && this.polygonColliderArr.length > 0) {
            var hasHit = false;
            for (var i = 0; i < this.polygonColliderArr.length; i++) {
                hasHit = cc.Intersection.pointInPolygon(cc.v2(hitPos), this.polygonColliderArr[i].points);
                if (hasHit == true) {
                    break;
                }
            }
            // console.log('碰撞组件的点击测试1', this.node.name, hasHit, this.polygonColliderArr, hitPos, '当前是否有camera：' + this.camera)
            return hasHit;
        }
        else {
            if (this._polygonCollider) {
                var bhit = cc.Intersection.pointInPolygon(cc.v2(hitPos), this._polygonCollider.points);
                // console.log("碰撞组件的点击测试2",  this.node.name, bhit)
                return bhit;
            }
        }
    };
    return SpinePlusComponent;
}(cc.Component));
exports.default = SpinePlusComponent;
cc.js.setClassName('SpinePlusComponent', SpinePlusComponent);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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