
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/BaseYwNode.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6eb16Fh2EtBn4eRGrzPtnD0', 'BaseYwNode');
// Script/Common/LiteGraphCore/nodes/BaseYwNode.js

"use strict";

exports.__esModule = true;
exports.BaseYWNode = void 0;

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseYWNode = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(BaseYWNode, _LGraphNode);

  function BaseYWNode() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "自定义LGraphNode基础类";
    _this.desc = "其余LGraphNode继承于此";
    return _this;
  }

  var _proto = BaseYWNode.prototype;

  _proto.onAdded = function onAdded() {
    this.sendAddEvent();
  };

  _proto.onRemoved = function onRemoved() {
    this.sendRemoveEvent();
  };

  _proto.onSelected = function onSelected() {
    this.sendOtherEvent('onSelected');
  };

  _proto.onDeselected = function onDeselected() {
    this.sendOtherEvent('onDeselected');
  };

  _proto.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  };

  _proto.disconnectInput = function disconnectInput(slot, keepReroutes) {
    this.sendDisConnectEvent(slot, keepReroutes);

    _LGraphNode.prototype.disconnectInput.call(this, slot, keepReroutes);
  };

  _proto.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    this.sendPropertyChangeEvent(property, value, oldValue);
  } //graph每次直接发布就好了，现在的操作是对cocos节点的操作进行同步
  ;

  _proto.sendPropertyChangeEvent = function sendPropertyChangeEvent(property, value, oldValue) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          property: property,
          value: value
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onPropertyChanged',
          datas: datas
        });
      }
    }
  } //组件的按钮点击时同步事件
  ;

  _proto.sendBtnWidgetClickEvent = function sendBtnWidgetClickEvent(buttonName) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          buttonName: buttonName
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onBtnWidgetClick',
          datas: datas
        });
      }
    }
  } //发送移除事件
  ;

  _proto.sendRemoveEvent = function sendRemoveEvent() {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onRemove',
          datas: datas
        });
      }
    }
  } //发送开始连接
  ;

  _proto.sendConnectEvent = function sendConnectEvent(inputIndex, linkedNode, outputIndex) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          inputIndex: inputIndex,
          linkedNodeId: linkedNode.id,
          outputIndex: outputIndex
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onConnect',
          datas: datas
        });
      }
    }
  } //发送断开连接
  ;

  _proto.sendDisConnectEvent = function sendDisConnectEvent(slot, keepReroutes) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          slot: slot,
          keepReroutes: keepReroutes
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onDisConnect',
          datas: datas
        });
      }
    }
  } //发送添加事件
  ;

  _proto.sendAddEvent = function sendAddEvent() {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // this.widgets
      // 发送数据变化事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          type: this.type,
          params: this.properties
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'onAdd',
          datas: datas
        });
      }
    }
  } //发送其它的事件
  ;

  _proto.sendOtherEvent = function sendOtherEvent(funcName, params) {
    if (this.graph == null) {
      return;
    }

    if (CocosMgr.isSinglePreview != true) {
      // 发送其它事件
      if (window.channel != null) {
        var datas = JSON.parse(JSON.stringify({
          id: this.id,
          funcName: funcName,
          params: params
        }));
        window.channel.postMessage({
          type: 'nodeEvent',
          func: 'justRunFunc',
          datas: datas
        });
      }
    }
  };

  _proto.onStart = function onStart() {
    this._hasShowTips = false;
  };

  _proto.oneClickCreateTouchTip = function oneClickCreateTouchTip() {
    // console.log('点击了关联触摸提示')
    //直接创建触摸提示节点，并且自动链接
    var tipsNode = _litegraph.LiteGraph.createNode('objects/createObject');

    tipsNode.setProperty('modal', 'spine'); // tipsNode.setProperty('customeName', '1f09b34a/Common_Click')

    tipsNode.setProperty('customeName', 'c7007391/Common_Click');
    tipsNode.setProperty('x', 0);
    tipsNode.setProperty('y', 0);
    tipsNode.setProperty('zIndex', 99);
    tipsNode.setProperty('premulAlpha', false);
    tipsNode.onWidgetChanged('物体类型');
    tipsNode.pos = [this.pos[0], this.pos[1] + this.height + 130];
    this.graph.add(tipsNode);
    var outputs = tipsNode.onGetOutputs();
    var lgraphNodeIndex = outputs.findIndex(function (item) {
      return item[1] == 'lgraphNode';
    });

    if (lgraphNodeIndex != -1) {
      tipsNode.addOutput(outputs[lgraphNodeIndex][0], outputs[lgraphNodeIndex][1]);
    } // this.connect(2, tipsNode, )


    tipsNode.connect(tipsNode.outputs.length - 1, this, 2); //同时创建动画节点

    var animateNode = _litegraph.LiteGraph.createNode('objects/animates/animate');

    animateNode.pos = [tipsNode.pos[0] + tipsNode.width + 3, tipsNode.pos[1]];
    animateNode.setProperty('loop', true);
    animateNode.setProperty('autoRun', true);
    this.graph.add(animateNode);
    tipsNode.connect(0, animateNode, 0);
    setTimeout(function () {
      animateNode.getEnums();
    }, 1000);
  };

  _proto.showClickTip = function showClickTip() {
    if (this._hasShowTips == true) {
      return;
    }

    if (this.properties.tipsJustOnce == true) {
      this._hasShowTips = true;
    }

    if (this.properties.canClickOutLine == true) {
      //可触摸时显示描边
      var codeNode = this.getInputData(0);

      if (codeNode != null) {
        codeNode.outLineWidth = 5;
      }
    }

    var soltIndex = this.findInputSlot('触摸提示');
    console.log('showClickTip', soltIndex);

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex); // console.log('linkTip', linkTip)

    if (linkTip != null) {
      if (linkTip.codeNode != null) {
        linkTip.codeNode.playAnimation('1Open', true);
      }
    }
  };

  _proto.hideClickTip = function hideClickTip() {
    if (this.properties.canClickOutLine == true) {
      //可触摸时显示描边
      var codeNode = this.getInputData(0);

      if (codeNode != null) {
        codeNode.outLineWidth = 0;
      }
    }

    var soltIndex = this.findInputSlot('触摸提示');

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex);

    if (linkTip != null) {
      // console.log('hideClickTip', linkTip.codeNode)
      if (linkTip.codeNode != null) {
        linkTip.codeNode.playAnimation('2Close', false);
      }
    }
  };

  _proto.playLinkSound = function playLinkSound() {
    var soltIndex = this.findInputSlot('关联音频');

    if (soltIndex == -1) {
      return;
    }

    var linkTip = this.getInputNode(soltIndex);

    if (linkTip != null) {
      if (linkTip.onAction != null) {
        linkTip.onAction('播放');
      }
    }
  } //当前是否关联音频
  ;

  _proto.hasLinkSound = function hasLinkSound() {
    var soltIndex = this.findInputSlot('关联音频');

    if (soltIndex == -1) {
      return false;
    }

    return this.getInputLink(soltIndex) != null;
  } //当前是否关联音频是否播放结束
  ;

  _proto.hasLinkIsCanClick = function hasLinkIsCanClick() {
    var soltIndex = this.findInputSlot('isCanClick');

    if (soltIndex == -1) {
      return false;
    }

    return this.getInputLink(soltIndex) != null;
  } //移除一个propaty
  ;

  _proto.removeProperty = function removeProperty(key) {
    // console.log('removeProperty key', key)
    if (this.properties_info == null) {
      this.properties_info = [];
    }

    var index = this.properties_info.findIndex(function (item) {
      return item.name == key;
    });
    this.properties_info.splice(index, 1);

    if (this.properties == null) {
      this.properties = {};
    }

    delete this.properties[key];
  };

  return BaseYWNode;
}(_litegraph.LGraphNode);

exports.BaseYWNode = BaseYWNode;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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