
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/customComponent.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5d355uaGNlIcbBoWitdX/Sj', 'customComponent');
// Script/Common/LiteGraphCore/nodes/customComponent.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var BaseScriptRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(BaseScriptRobot, _LGraphNode);

  function BaseScriptRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "自定义脚本基础类";
    _this.desc = "直接挂载游戏中的脚本的指令继承于此";
    return _this;
  }

  var _proto = BaseScriptRobot.prototype;

  _proto.getCom = function getCom() {
    var configKey = this.properties.configKey;

    if (configKey.indexOf('cc.') != -1) {
      //使用cc内置组件
      return new cc[configKey.split('.')[1]]();
    }

    var comClass = cc.js.getClassByName(configKey);

    if (comClass == null) {
      console.warn('找不到脚本组件' + configKey + '请在App中测试真实运行效果');
      return null;
    }

    return new comClass();
  };

  _proto.onStart = function onStart() {
    var bindNode = this.getInputNode(0);

    if (bindNode != null && bindNode.codeNode != null) {
      //已经绑定到某个节点中
      this.hasRunRobotStart = true;

      if (this.component && this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    } else {
      var component = null;

      if (this.properties.isSingleClass == true) {
        component = this.getCom();
      } else {
        var rootccNode = this.graph.vars.rootccNode;

        if (rootccNode == null) {
          // 
          if (CocosMgr.isInApp == false) {
            var canvas = cc.director.getScene().getChildByName('Canvas');
            rootccNode = canvas.getChildByName('_componentsNode');

            if (rootccNode == null) {
              rootccNode = new cc.Node();
              rootccNode.name = '_componentsNode';
              rootccNode.parent = canvas;
            }
          } else {
            console.warn("没有rootccNode");
            return;
          }
        }

        component = this.getCom();
        rootccNode.addComponent(component);
      }

      if (component == null) {
        return;
      } //将变量同步到脚本中去


      for (var key in this.properties) {
        var value = null;
        var probInfo = this.getPropertyInfo(key);

        if (probInfo.type == 'robot') {
          value = this.graph.getNodeById(this.properties[key]);
        } else {
          // if(probInfo.type == 'enum' && this.properties[key].choosesKey != null){
          //     // console.log('应该动态赋值', this.properties[key].choosesKey[this.properties[key]])
          //     value = this.properties[key].choosesKey[this.properties[key]]
          // }else{
          // }
          value = this.properties[key];
        }

        if (component[key] != value) {
          component[key] = value;
        }
      }

      this.component = component;
      this.component.outputHandle = this.outputHandle;
      this.component.codeProgress = this.graph;

      if (this.component && this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    }

    if (this.getInputDataType(0) == 'codeNode') {
      if (this.getInputData(0) != null) {
        this.onBindCodeNode(this.getInputData(0));
      }
    }
  };

  _proto.onBindCodeNode = function onBindCodeNode(codeNode) {
    var _this2 = this;

    var comClass = cc.js.getClassByName(this.properties.configKey);

    if (comClass == null) {
      console.warn('找不到脚本组件' + this.properties.configKey + '请在App中测试真实运行效果');
      return;
    }

    var component = codeNode.getComponent(this.properties.configKey);

    if (component == null) {
      component = codeNode.addComponent(this.properties.configKey);
    }

    if (this.properties.configKey == 'cc.Mask') {
      //特殊处理一下
      if (this.properties.radius != 0) {
        var roundRectMask = codeNode.getComponent('RoundRectMask');

        if (roundRectMask == null) {
          roundRectMask = codeNode.addComponent('RoundRectMask');
        }

        roundRectMask._radius = this.properties.radius;
      } else {
        codeNode.removeComponent('RoundRectMask');
      }
    }

    var initKey = function initKey(key) {
      var value = null;

      var probInfo = _this2.getPropertyInfo(key);

      if (probInfo.type == 'robot') {
        value = _this2.graph.getNodeById(_this2.properties[key]);
      } else if (probInfo.type == 'spriteFrame') {
        _this2.codeProgress.codeRobotConfig.loadResHandle(_this2.properties[key], cc.SpriteFrame, function (res) {
          value = res;

          if (component[key] != value && value != null) {
            component[key] = value;
          }
        });
      } else {
        // if(probInfo.type == 'toggleGroup' && this.properties.otherConfig[key].choosesKey != null){
        //     // console.log('应该动态赋值', this.properties.otherConfig[key].choosesKey[this.properties.otherConfig[key]])
        //     value = this.properties.otherConfig[key].choosesKey[this.properties.otherConfig[key]]
        // }else{
        //     value = this.properties.otherConfig[key]
        // }
        value = _this2.properties[key];
      }

      if (component[key] != value && value != null) {
        component[key] = value;
      }
    }; // console.log('给component设置值的时候是否已经init了', component.hasInit)


    for (var key in this.properties) {
      initKey(key);
    }

    this.component = component;
    this.component.outputHandle = this.outputHandle.bind(this);
    this.component.codeProgress = this.graph; // console.log(this.properties.configKey,'this.hasRunRobotStart' ,this.hasRunRobotStart)

    if (this.hasRunRobotStart == true) {
      if (this.component.robotStart != null) {
        this.component.robotStart(this);
      }
    }
  };

  _proto.inputHandle = function inputHandle(inputData) {
    if (this.component == null) {
      if (CocosMgr.isInApp == false) {
        CocosMgr.showAlert(this.properties.configKey + '还未初始化就输入了');
      } else {
        console.warn(this.properties.configKey + '还未初始化就输入了');
      }
    } else {
      if (this.component.inputHandle != null) {
        this.component.inputHandle(inputData);
      }
    }
  } //适配output handle的输出
  ;

  _proto.outputHandle = function outputHandle(key, value) {
    var index = this.findOutputSlot(key);

    if (index != -1) {
      var info = this.getOutputInfo(index);

      if (info.type == _litegraph.LiteGraph.EVENT) {
        this.triggerSlot(index, value);
      } else {
        this.setOutputData(index, value);
      }
    }
  };

  _proto.onPause = function onPause() {
    if (this.component && this.component.robotPause != null) {
      this.component.robotPause();
    }
  };

  _proto.onResume = function onResume() {
    if (this.component && this.component.robotResume != null) {
      this.component.robotResume();
    }
  } //运行时刷新配置
  ;

  _proto.inRunFreshConfig = function inRunFreshConfig(key) {
    if (this.component != null) {
      this.component[key] = this.properties.otherConfig[key];

      if (this.component.inRunFreshConfig != null) {
        this.component.inRunFreshConfig(key);
      }
    }
  } //停止运行
  ;

  _proto.onStop = function onStop() {
    this.hasRunRobotStart = false;

    if (this.component && this.component.robotRelease != null) {
      this.component.robotRelease();
    } // if(this.component != null){
    //     if(cc.isValid(this.component.node)){
    //         this.component.node.removeComponent(this.component)
    //     }
    //     this.component.codeProgress = null
    //     this.component = null
    // }

  };

  return BaseScriptRobot;
}(_litegraph.LGraphNode); //自定义脚本组件


var MotionText = /*#__PURE__*/function (_BaseScriptRobot) {
  _inheritsLoose(MotionText, _BaseScriptRobot);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function MotionText() {
    var _this3;

    _this3 = _BaseScriptRobot.call(this) || this; // this.serialize_widgets = true

    _this3.title = "字幕";
    _this3.desc = "在绘本中添加字幕";
    _this3.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this3.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this3.addInput("物体", 'codeNode');

    _this3.addInput("启用", _litegraph.LiteGraph.ACTION);

    _this3.addInput("隐藏", _litegraph.LiteGraph.ACTION);

    _this3.addOutput("onend", _litegraph.LiteGraph.EVENT);

    _this3.addProperty('autoRun', false, 'boolean');

    _this3.addWidget('toggle', '自动播放', _this3.properties.autoRun, 'autoRun');

    _this3.addProperty('dir', false, 'boolean');

    _this3.addWidget('toggle', '文本竖向排列', _this3.properties.dir, 'dir');

    _this3.addProperty('hideBeforRun', true, 'boolean');

    _this3.addWidget('toggle', '运行前隐藏', _this3.properties.hideBeforRun, 'hideBeforRun');

    _this3.addProperty('hideAfterRun', false, 'boolean');

    _this3.addWidget('toggle', '运行结束隐藏', _this3.properties.hideAfterRun, 'hideAfterRun');

    _this3.addProperty('hideBaseLabel', false, 'boolean');

    _this3.addWidget('toggle', '隐藏底层文字', _this3.properties.hideBaseLabel, 'hideBaseLabel');

    _this3.addProperty('position', '0,1', 'string');

    _this3.addWidget('string', '分段位置', _this3.properties.position, 'position');

    _this3.addProperty('positionTime', '0,2', 'string');

    _this3.addWidget('string', '分段时间', _this3.properties.positionTime, 'positionTime');

    _this3.addProperty('maskColor', '#88BF3D', 'string');

    _this3.addWidget('string', '过渡颜色', _this3.properties.maskColor, 'maskColor');

    _this3.addProperty('configKey', 'MotionText', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this3;
  }

  var _proto2 = MotionText.prototype;

  _proto2.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    console.log('MotionText onConnectInput', inputIndex, outPutType);

    if (inputIndex == 0 && outPutType == 'codeNode') {
      //将文本的anchorX设置为0
      linkedNode.setProperty('anchorX', 0);
    }
  } // 当节点Toggle时调用
  ;

  _proto2.onAction = function onAction(action, param) {
    if (this.component == null) {
      return;
    }

    if (this.component.inputHandle == null) {
      console.warn('inputHandle == null');
      return;
    }

    if (action == '启用') {
      this.component.inputHandle({
        targetSolt: 'show'
      });
    } else if (action == '隐藏') {
      this.component.inputHandle({
        targetSolt: 'hide'
      });
    }
  };

  return MotionText;
}(BaseScriptRobot);

MotionText.title = '字幕';

_litegraph.LiteGraph.registerNodeType("output/customComponent/MotionText", MotionText); //
//自定义脚本组件


var CaiDanComponent = /*#__PURE__*/function (_BaseScriptRobot2) {
  _inheritsLoose(CaiDanComponent, _BaseScriptRobot2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function CaiDanComponent() {
    var _this4;

    _this4 = _BaseScriptRobot2.call(this) || this; // this.serialize_widgets = true

    _this4.title = "桃桃彩蛋";
    _this4.desc = "在绘本中添加桃桃彩蛋";
    _this4.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this4.size = [80, 20]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this4.addInput("物体", 'codeNode'); // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);


    _this4.addOutput("onclick", _litegraph.LiteGraph.EVENT);

    _this4.addProperty('caidanYuyin', '', 'string');

    _this4.addWidget('string', '彩蛋语音', _this4.properties.caidanYuyin, 'caidanYuyin');

    _this4.addProperty('startSound', '', 'string');

    _this4.addWidget('string', '出现语音', _this4.properties.startSound, 'startSound');

    _this4.addProperty("caidanId", 0, "number");

    _this4.addWidget("slider", '彩蛋Id', _this4.properties.caidanId, "caidanId", {
      min: 0,
      max: 10,
      precision: 0
    });

    _this4.addProperty("caidanPosX", 0, "number");

    _this4.addWidget("number", '桃桃动画位置X', _this4.properties.caidanPosX, "caidanPosX", {
      precision: 1
    });

    _this4.addProperty("caidanPosY", 0, "number");

    _this4.addWidget("number", '桃桃动画位置Y', _this4.properties.caidanPosY, "caidanPosY", {
      precision: 1
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')


    _this4.addProperty('playSound', true, 'boolean');

    _this4.addWidget('toggle', '播放声音', _this4.properties.playSound, 'playSound'); // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')


    _this4.addProperty('configKey', 'CaiDanComponent', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this4;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return CaiDanComponent;
}(BaseScriptRobot);

CaiDanComponent.title = '桃桃彩蛋';

_litegraph.LiteGraph.registerNodeType("output/customComponent/CaiDanComponent", CaiDanComponent); //自定义脚本组件


var CaiDanComponent2 = /*#__PURE__*/function (_BaseScriptRobot3) {
  _inheritsLoose(CaiDanComponent2, _BaseScriptRobot3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function CaiDanComponent2() {
    var _this5;

    _this5 = _BaseScriptRobot3.call(this) || this; // this.serialize_widgets = true

    _this5.title = "收藏品彩蛋";
    _this5.desc = "在绘本中添加收藏品彩蛋";
    _this5.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this5.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this5.addInput("物体", 'codeNode'); // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);
    // this.addOutput("onclick", LiteGraph.EVENT)


    _this5.addProperty("caidanId", 0, "number");

    _this5.addWidget("slider", '彩蛋Id', _this5.properties.caidanId, "caidanId", {
      min: 0,
      max: 10,
      precision: 0
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')


    _this5.addProperty('configKey', 'CaiDanComponent2', 'string'); // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this5;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return CaiDanComponent2;
}(BaseScriptRobot);

CaiDanComponent2.title = '收藏品彩蛋';

_litegraph.LiteGraph.registerNodeType("output/customComponent/CaiDanComponent2", CaiDanComponent2); //剧情气泡
//自定义脚本组件


var ChatComponent = /*#__PURE__*/function (_BaseScriptRobot4) {
  _inheritsLoose(ChatComponent, _BaseScriptRobot4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ChatComponent() {
    var _this6;

    _this6 = _BaseScriptRobot4.call(this) || this; // this.serialize_widgets = true

    _this6.title = "对话提示气泡";
    _this6.desc = "在绘本中添加对话提示气泡";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this6.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this6.addInput("物体", 'codeNode');

    _this6.addInput("输入", _litegraph.LiteGraph.ACTION);

    _this6.addInput("更新", _litegraph.LiteGraph.ACTION);

    _this6.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this6.addProperty("key", '', "string");

    _this6.addWidget("string", '点击标记', _this6.properties.key, "key");

    _this6.addProperty('configKey', 'ChatComponent', 'string');

    _this6.addProperty('dirType', '左下', 'enum');

    _this6.addWidget('combo', '气泡箭头方向', _this6.properties.dirType, {
      property: "dirType",
      values: ['左下', '右下', '右上', '左上']
    }); // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this6;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ChatComponent;
}(BaseScriptRobot);

ChatComponent.title = '对话提示气泡';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ChatComponent", ChatComponent);

var VoiceCheck = /*#__PURE__*/function (_BaseScriptRobot5) {
  _inheritsLoose(VoiceCheck, _BaseScriptRobot5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function VoiceCheck() {
    var _this7;

    _this7 = _BaseScriptRobot5.call(this) || this; // this.serialize_widgets = true

    _this7.title = "声音检测";
    _this7.desc = "在绘本中添加声音检测";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this7.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    // this.addInput("物体", 'codeNode');

    _this7.addInput("开始", _litegraph.LiteGraph.ACTION);

    _this7.addInput("停止", _litegraph.LiteGraph.ACTION);

    _this7.addOutput("输出", _litegraph.LiteGraph.EVENT);

    _this7.addProperty("testStr", '', "string");

    _this7.addWidget("string", '检测的字符', _this7.properties.testStr, "testStr");

    _this7.addProperty("testStrGroup", '', "string");

    _this7.addWidget("string", '检测的词组（用,分割）', _this7.properties.testStrGroup, "testStrGroup");

    _this7.addProperty('checkType', '左下', 'enum');

    _this7.addWidget('combo', '检测模式', _this7.properties.checkType, {
      property: "checkType",
      values: ['跟读', '关键字模式']
    });

    _this7.addProperty('configKey', 'VoiceCheck', 'string');

    _this7.addProperty('isSingleClass', true, 'boolean'); // this.addProperty("key", 0, "string");
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this7;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return VoiceCheck;
}(BaseScriptRobot);

VoiceCheck.title = '声音检测';

_litegraph.LiteGraph.registerNodeType("output/customComponent/VoiceCheck", VoiceCheck);

var AngleCompoment = /*#__PURE__*/function (_BaseScriptRobot6) {
  _inheritsLoose(AngleCompoment, _BaseScriptRobot6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function AngleCompoment() {
    var _this8;

    _this8 = _BaseScriptRobot6.call(this) || this; // this.serialize_widgets = true

    _this8.title = "角度定位";
    _this8.desc = "在绘本中添加物让其根据输入的角度定位";
    _this8.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this8.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this8.addInput("物体", 'codeNode');

    _this8.addInput("开启监听", _litegraph.LiteGraph.ACTION);

    _this8.addInput("重置", _litegraph.LiteGraph.ACTION);

    _this8.addOutput("number1", 'number'); // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this8.addProperty('configKey', 'AngleCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideBeforRun', false, 'boolean')
    // this.addWidget('toggle', '运行前隐藏', this.properties.hideBeforRun, 'hideBeforRun')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this8;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return AngleCompoment;
}(BaseScriptRobot);

AngleCompoment.title = '角度定位';

_litegraph.LiteGraph.registerNodeType("output/customComponent/AngleCompoment", AngleCompoment);

var ScaleObj = /*#__PURE__*/function (_BaseScriptRobot7) {
  _inheritsLoose(ScaleObj, _BaseScriptRobot7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ScaleObj() {
    var _this9;

    _this9 = _BaseScriptRobot7.call(this) || this; // this.serialize_widgets = true

    _this9.title = "双指缩放";
    _this9.desc = "在绘本中添加双指缩放手势";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this9.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this9.addInput("物体", 'codeNode');

    _this9.addInput("启用", _litegraph.LiteGraph.ACTION);

    _this9.addInput("关闭", _litegraph.LiteGraph.ACTION);

    _this9.addOutput("onScale", _litegraph.LiteGraph.EVENT); // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this9.addProperty('configKey', 'AngleCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')


    _this9.addProperty("scaleMin", 0.5, "number");

    _this9.addWidget('number', '最小缩放', _this9.properties.scaleMin, "scaleMin", {
      precision: 1
    });

    _this9.addProperty("scaleMax", 2, "number");

    _this9.addWidget('number', '最大缩放', _this9.properties.scaleMax, "scaleMax", {
      precision: 1
    });

    _this9.addProperty('dynimicCenter', false, 'boolean');

    _this9.addWidget('toggle', '是否以当前中心缩放', _this9.properties.dynimicCenter, 'dynimicCenter'); //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ScaleObj;
}(BaseScriptRobot);

ScaleObj.title = '双指缩放';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ScaleObj", ScaleObj);

var ProgressCompoment = /*#__PURE__*/function (_BaseScriptRobot8) {
  _inheritsLoose(ProgressCompoment, _BaseScriptRobot8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ProgressCompoment() {
    var _this10;

    _this10 = _BaseScriptRobot8.call(this) || this; // this.serialize_widgets = true

    _this10.title = "进度条";
    _this10.desc = "发送绘本页面进度事件，关联图片类型的物体使用";
    _this10.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式

    _this10.size = [80, 30]; //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this10.addInput("物体", 'codeNode');

    _this10.addInput("进度", 'number');

    _this10.addInput("更新", _litegraph.LiteGraph.ACTION); // this.addOutput("增量", LiteGraph.EVENT)
    // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");


    _this10.addProperty('configKey', 'ProgressCompoment', 'string'); // this.addProperty('dirType', '左下', 'enum')
    // this.addWidget('combo', '气泡箭头方向', this.properties.dirType, {property: "dirType", values: ['左下','右下','右上','左上']} )
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')
    // this.addProperty('playSound', true, 'boolean')
    // this.addWidget('toggle', '播放声音', this.properties.playSound, 'playSound')
    // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('positionTime', '0,2', 'string')
    // this.addWidget('string', '分段时间', this.properties.positionTime, 'positionTime')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("scaleMin", 0.5, "number");
    // this.addWidget('number', '最小缩放', this.properties.scaleMin, "scaleMin", {precision: 1});
    // this.addProperty("scaleMax", 2, "number");
    // this.addWidget('number', '最大缩放', this.properties.scaleMax, "scaleMax", {precision: 1});
    // this.addProperty('dynimicCenter', false, 'boolean')
    // this.addWidget('toggle', '是否以当前中心缩放', this.properties.dynimicCenter, 'dynimicCenter')
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this10;
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }


  return ProgressCompoment;
}(BaseScriptRobot);

ProgressCompoment.title = '进度条';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ProgressCompoment", ProgressCompoment);

var ccMask = /*#__PURE__*/function (_BaseScriptRobot9) {
  _inheritsLoose(ccMask, _BaseScriptRobot9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function ccMask() {
    var _this11;

    _this11 = _BaseScriptRobot9.call(this) || this; // this.serialize_widgets = true

    _this11.title = "蒙版";
    _this11.desc = "给节点添加蒙版效果";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this11.addInput("物体", 'codeNode'); // this.addInput("进度", 'number');
    // this.addInput("更新", LiteGraph.ACTION);
    // this.addOutput("增量", LiteGraph.EVENT)
    // this.addProperty("key", '', "string");
    // this.addWidget("string", '点击标记', this.properties.key, "key");
    // console.log('cc.Mask Name', cc.Mask)


    _this11.addProperty('configKey', 'cc.Mask', 'string');

    _this11.addProperty('type', 0, 'number');

    _this11.addWidget('combo', '遮罩类型', _this11.properties.type, {
      property: "type",
      values: {
        0: '矩形',
        1: '圆形',
        2: '图片'
      }
    }); // let arr = [cc.Mask.Type.RECT,cc.Mask.Type.ELLIPSE,cc.Mask.Type.IMAGE_STENCIL]
    // console.log('这招类型', arr)
    // this.addProperty('autoRun', false, 'boolean')
    // this.addWidget('toggle', '自动播放', this.properties.autoRun, 'autoRun')


    _this11.addProperty('inverted', false, 'boolean');

    _this11.addWidget('toggle', '反向遮罩', _this11.properties.inverted, 'inverted'); // this.addProperty('hideAfterRun', false, 'boolean')
    // this.addWidget('toggle', '运行结束隐藏', this.properties.hideAfterRun, 'hideAfterRun')
    // this.addProperty('hideBaseLabel', false, 'boolean')
    // this.addWidget('toggle', '隐藏底层文字', this.properties.hideBaseLabel, 'hideBaseLabel')
    // this.addProperty('maskColor', '#88BF3D', 'string')
    // this.addWidget('string', '过渡颜色', this.properties.maskColor, 'maskColor')
    // this.addProperty('key', 'MotionText', 'string')
    // this.addProperty("scaleMin", 0.5, "number");
    // this.addWidget('number', '最小缩放', this.properties.scaleMin, "scaleMin", {precision: 1});


    _this11.addProperty("alphaThreshold", 0.5, "number");

    _this11.addWidget('number', '透明度阀值', _this11.properties.alphaThreshold, "alphaThreshold", {
      precision: 2,
      min: 0,
      max: 1
    });

    _this11.addProperty("segements", 50, "number");

    _this11.addWidget('number', '椭圆遮罩曲线数', _this11.properties.segements, "segements", {
      precision: 2,
      min: 1,
      max: 100
    });

    _this11.addProperty("radius", 0, "number");

    _this11.addWidget('number', '矩形圆角曲线数', _this11.properties.radius, "radius", {
      precision: 1,
      min: 0,
      max: 100
    });

    _this11.addProperty('spriteFrame', '', 'string');

    _this11.addWidget('string', '图片路径', _this11.properties.spriteFrame, 'spriteFrame'); // this.addProperty('dynimicCenter', false, 'boolean')
    // this.addWidget('toggle', '是否以当前中心缩放', this.properties.dynimicCenter, 'dynimicCenter')
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this11;
  }

  var _proto3 = ccMask.prototype;

  _proto3.updateWidght = function updateWidght() {
    var type = this.properties.type;
    this.widgets.map(function (widget) {
      if (widget.name == '矩形圆角曲线数') {
        widget.disabled = type != 0;
      } else if (widget.name == '椭圆遮罩曲线数') {
        widget.disabled = type != 1;
      }
    }); // this.expandToFitContent()
  };

  _proto3.onWidgetChanged = function onWidgetChanged(name) {
    console.log('当前这招类型', this.properties.type);

    if (name == '遮罩类型') {
      this.updateWidght();
    }
  } // 当节点Toggle时调用
  // onAction(action, param)
  // {
  // }
  ;

  return ccMask;
}(BaseScriptRobot);

ccMask.title = '蒙版';

_litegraph.LiteGraph.registerNodeType("output/customComponent/ccMask", ccMask);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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