
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/dataNode.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5b04apR0FtGT5NG2oiEy/6Y', 'dataNode');
// Script/Common/LiteGraphCore/nodes/dataNode.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var systemData = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(systemData, _LGraphNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function systemData() {
    var _this;

    _this = _LGraphNode.call(this) || this; //   this.serialize_widgets  = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this.title = "系统数据";
    _this.desc = "获取系统数据";

    _this.addOutput("值", 'number,string,boolean,object,array'); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addProperty('modal', '时间戳-秒', 'enum');

    _this.addWidget('combo', '类型', _this.properties.modal, {
      property: "modal",
      values: systemData.valueTypes
    });

    _this.addProperty('fileName', '');

    _this.addWidget('string', '表名称', _this.properties.fileName, 'fileName'); //'输出空间的x轴范围，是一个数组，如[-1280,1280]，表示该空间最左侧x坐标为-1280，最右侧坐标为1280'},
    //   this.addProperty('fileName', '')
    //   this.addWidget('string', '配置表名称', this.properties.fileName, 'fileName')
    //   this.addProperty("value", 1.0);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this.widgets_up = true; //设置输入组件在顶部（覆盖input和output）

    _this.size = [180, 40]; //                                   //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  //动态返回卡片显示的title


  var _proto = systemData.prototype;

  _proto.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      if (this.properties.modal == '配置表') {
        return this.properties.modal + ':' + this.properties.fileName;
      } else {
        return this.properties.modal;
      }
    }

    return this.title;
  };

  _proto.onAdded = function onAdded() {
    // console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal)
    //如果是拖拽资源的话，这里也是需要触发的
    this.updateWidght();
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto.onConfigure = function onConfigure() {
    // console.log('节点配置了', this.properties.customeName, this.properties.modal)
    this.updateWidght();
  };

  _proto.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      if (widget.name == '表名称') {
        widget.disabled = value != '配置表';
      }
    }); // this.expandToFitContent()
  };

  _proto.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {
    if (name == '类型') {
      this.updateWidght();
    }
  };

  _proto.onStart = function onStart() {
    this.onExecute();
  };

  _proto.getLinkData = function getLinkData() {
    var value = null;
    var modalIndex = systemData.valueTypes.indexOf(this.properties.modal);

    if (modalIndex == 0) {
      value = Math.floor(new Date().getTime() / 1000);
    } else if (modalIndex == 1) {
      var date = new Date();
      var month = date.getMonth() + 1;

      if (month < 10) {
        month = "0" + month;
      }

      var day = date.getDate();

      if (day < 10) {
        day = "0" + day;
      }

      value = date.getFullYear() + '/' + month + '/' + day;
    } else if (modalIndex == 2) {
      var date = new Date();
      var hours = date.getHours();
      var minutes = date.getMinutes();
      var seconds = date.getSeconds();

      if (hours < 10) {
        hours = "0" + hours;
      }

      if (minutes < 10) {
        minutes = "0" + minutes;
      }

      if (seconds < 10) {
        seconds = "0" + seconds;
      }

      value = hours + ':' + minutes + ':' + seconds;
    } else if (modalIndex == 3) {
      var date = new Date();
      var hours = date.getHours();
      var minutes = date.getMinutes();
      var seconds = date.getSeconds();

      if (hours < 10) {
        hours = "0" + hours;
      }

      if (minutes < 10) {
        minutes = "0" + minutes;
      }

      value = hours + ':' + minutes;
    } else if (modalIndex == 4) {
      value = cc.sys.os;
    } else if (modalIndex == 5) {
      value = 1.0;
    } else if (modalIndex == 6) {//读取配置表
      // var fileName = this.config.otherConfig.fileName.default
      // value = this.codeProgress.getConfigData(fileName)
    } else if (modalIndex == 7) {
      // var fileName = this.config.otherConfig.fileName.default
      value = {};
    } else if (modalIndex == 8) {
      value = [];
    } else if (modalIndex == 9) {
      //其实这里应该返回设计分辨率
      value = cc.winSize.width;
    } else if (modalIndex == 10) {
      value = cc.winSize.height; //其实这里应该返回设计分辨率
    } else if (modalIndex == 11) {
      // 空间X轴范围
      value = cc.winSize.width * 0.5;
      value = [-value, value];
    } else if (modalIndex == 12) {
      // 空间Y轴范围
      value = cc.winSize.height * 0.5;
      value = [-value, value];
    }

    return value;
  } //可以每帧触发，也可以onStart触发，还可以手动调用触发刷新值
  ;

  _proto.onExecute = function onExecute() {
    var data = this.getLinkData();
    this.setOutputData(0, data);
  } //暂不清楚用处
  // setValue(v){
  //     this.setProperty("value",v);
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return systemData;
}(_litegraph.LGraphNode); // Register the node type


systemData.title = '系统数据'; //设置中文名称标题，是否需要实现多语言？

systemData.valueTypes = ['时间戳-秒', '年:月:日', '时:分:秒', '时:分', '系统', '版本', '配置表', 'Object', 'Array', '空间宽度', '空间高度', '空间X轴范围', '空间Y轴范围'];

_litegraph.LiteGraph.registerNodeType("input/getData/systemData", systemData); //第一个是唯一key，同时也是菜单选项路径


var customData = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(customData, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function customData() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "自定义数据";
    _this2.desc = "获取自定义数据";
    _this2.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets  = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this2.addOutput("值", 'number,string,boolean,object,array'); //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty('modal', '时间戳-秒', 'enum')
    //   this.addWidget('combo', '类型', this.properties.modal, {property: "modal", values: systemData.valueTypes} )


    _this2.addProperty('saveKey', '', 'string');

    _this2.addWidget('string', '数据key', _this2.properties.saveKey, 'saveKey');

    _this2.addProperty('ifEmpty', '', 'enum');

    _this2.addWidget('combo', '默认类型', _this2.properties.ifEmpty, {
      property: "ifEmpty",
      values: customData.valueTypes
    });

    _this2.addProperty('defaultValue', '', 'string');

    _this2.addWidget('text', '默认值', _this2.properties.defaultValue, 'defaultValue'); //'输出空间的x轴范围，是一个数组，如[-1280,1280]，表示该空间最左侧x坐标为-1280，最右侧坐标为1280'},
    //   this.addProperty('fileName', '')
    //   this.addWidget('string', '配置表名称', this.properties.fileName, 'fileName')
    //   this.addProperty("value", 1.0);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this2.widgets_up = true; //设置输入组件在顶部（覆盖input和output）

    _this2.size = [180, 30]; //                                   //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this2;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  //动态返回卡片显示的title


  var _proto2 = customData.prototype;

  _proto2.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.title + ':' + this.properties.saveKey;
    }

    return this.title;
  };

  _proto2.onAdded = function onAdded() {// console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal)
    //如果是拖拽资源的话，这里也是需要触发的
    // this.updateWidght()
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto2.onConfigure = function onConfigure() {// console.log('节点配置了', this.properties.customeName, this.properties.modal)
    // this.updateWidght()
  };

  _proto2.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {// if(widget.name == '表名称'){
      //     widget.disabled = value != '配置表'
      // }
    }); // this.expandToFitContent()
  } // onWidgetChanged(name, value, oldValue, widget){
  //     if(name == '类型'){
  //         this.updateWidght()
  //     }
  // }
  ;

  _proto2.onStart = function onStart() {
    this.onExecute();
  } //可以每帧触发，也可以onStart触发，还可以手动调用触发刷新值
  ;

  _proto2.onExecute = function onExecute() {
    var codeJsonData = cc.sys.localStorage.getItem('codeJsonData');

    if (codeJsonData == null || codeJsonData == '') {
      codeJsonData = {};
    } else {
      codeJsonData = JSON.parse(codeJsonData);
    }

    var value = codeJsonData[this.properties.saveKey];

    if (value == null) {
      var ifEmpty = this.properties.ifEmpty;

      if (ifEmpty == '数值') {
        value = Number(this.properties.defaultValue);

        if (isNaN(value)) {
          value = 0;
        }
      } else if (ifEmpty == '文字') {
        value = this.properties.defaultValue;
      } else if (ifEmpty == '字典' || '数组') {
        try {
          value = JSON.parse(this.properties.defaultValue);
        } catch (error) {
          value = ifEmpty == '字典' ? {} : [];
        }
      }
    }

    this.setOutputData(0, value);
  } //暂不清楚用处
  // setValue(v){
  //     this.setProperty("value",v);
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return customData;
}(_litegraph.LGraphNode); // Register the node type


customData.title = '自定义数据'; //设置中文名称标题，是否需要实现多语言？

customData.valueTypes = ['数值', '文字', '字典', '数组'];

_litegraph.LiteGraph.registerNodeType("input/getData/customData", customData); //第一个是唯一key，同时也是菜单选项路径


var screenSize = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(screenSize, _LGraphNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function screenSize() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this;
    _this3.title = "屏幕适配";
    _this3.desc = "获取屏幕适配数据";
    _this3.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets  = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this3.addOutput("4:3", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this3.addOutput("16:9", _litegraph.LiteGraph.EVENT);

    _this3.addOutput("18:9", _litegraph.LiteGraph.EVENT); //   this.addProperty('modal', '时间戳-秒', 'enum')
    //   this.addWidget('combo', '类型', this.properties.modal, {property: "modal", values: systemData.valueTypes} )
    //   this.addProperty('saveKey', '', 'string')
    //   this.addWidget('string', '数据key', this.properties.saveKey, 'saveKey')
    //   this.addProperty('ifEmpty', '', 'enum')
    //   this.addWidget('combo', '默认类型', this.properties.ifEmpty, {property: "ifEmpty", values: customData.valueTypes} )
    //   this.addProperty('defaultValue', '', 'string')
    //   this.addWidget('text', '默认值', this.properties.defaultValue, 'defaultValue' )
    //'输出空间的x轴范围，是一个数组，如[-1280,1280]，表示该空间最左侧x坐标为-1280，最右侧坐标为1280'},
    //   this.addProperty('fileName', '')
    //   this.addWidget('string', '配置表名称', this.properties.fileName, 'fileName')
    //   this.addProperty("value", 1.0);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                      //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];   
    //                                   //设置默认节点尺寸
    //   this.properties.precision = 1


    return _this3;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.title + ':' + this.properties.saveKey;
  //     }
  //     return this.title;
  // };


  var _proto3 = screenSize.prototype;

  _proto3.onAdded = function onAdded() {// console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal)
    //如果是拖拽资源的话，这里也是需要触发的
    // this.updateWidght()
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto3.onConfigure = function onConfigure() {// console.log('节点配置了', this.properties.customeName, this.properties.modal)
    // this.updateWidght()
  };

  _proto3.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {// if(widget.name == '表名称'){
      //     widget.disabled = value != '配置表'
      // }
    }); // this.expandToFitContent()
  } // onWidgetChanged(name, value, oldValue, widget){
  //     if(name == '类型'){
  //         this.updateWidght()
  //     }
  // }
  ;

  _proto3.onStart = function onStart() {
    this.onExecute();
  } //可以每帧触发，也可以onStart触发，还可以手动调用触发刷新值
  ;

  _proto3.onExecute = function onExecute() {
    var value = Math.max(cc.winSize.width, cc.winSize.height) / Math.min(cc.winSize.width, cc.winSize.height); //这里要加上以节点为准的适配规则
    // console.log('计算屏幕尺寸', cc.winSize.width,  cc.winSize.height)

    if (value < 1.6) {
      this.triggerSlot(0);
    } else if (value < 1.9) {
      this.triggerSlot(1);
    } else {
      this.triggerSlot(2);
    }
  } //暂不清楚用处
  // setValue(v){
  //     this.setProperty("value",v);
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return screenSize;
}(_litegraph.LGraphNode); // Register the node type


screenSize.title = '屏幕适配'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screenSize", screenSize); //第一个是唯一key，同时也是菜单选项路径


var setData = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(setData, _LGraphNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function setData() {
    var _this4;

    _this4 = _LGraphNode4.call(this) || this;
    _this4.title = "保存自定义数据";
    _this4.desc = "保存自定义数据";
    _this4.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets  = true

    _this4.addInput("值", 'number,string,boolean,object,array');

    _this4.addInput("保存", _litegraph.LiteGraph.ACTION); //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")
    //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty('modal', '时间戳-秒', 'enum')
    //   this.addWidget('combo', '类型', this.properties.modal, {property: "modal", values: systemData.valueTypes} )


    _this4.addProperty('saveKey', '', 'string');

    _this4.addWidget('string', '数据key', _this4.properties.saveKey, 'saveKey'); //   this.addProperty('ifEmpty', '', 'enum')
    //   this.addWidget('combo', '默认类型', this.properties.ifEmpty, {property: "ifEmpty", values: customData.valueTypes} )
    //   this.addProperty('defaultValue', '', 'string')
    //   this.addWidget('text', '默认值', this.properties.defaultValue, 'defaultValue' )
    //'输出空间的x轴范围，是一个数组，如[-1280,1280]，表示该空间最左侧x坐标为-1280，最右侧坐标为1280'},
    //   this.addProperty('fileName', '')
    //   this.addWidget('string', '配置表名称', this.properties.fileName, 'fileName')
    //   this.addProperty("value", 1.0);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                      //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];   
    //                                   //设置默认节点尺寸
    //   this.properties.precision = 1


    return _this4;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  //动态返回卡片显示的title


  var _proto4 = setData.prototype;

  _proto4.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.title + ':' + this.properties.saveKey;
    }

    return this.title;
  };

  _proto4.onAdded = function onAdded() {// console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal)
    //如果是拖拽资源的话，这里也是需要触发的
    // this.updateWidght()
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto4.onConfigure = function onConfigure() {// console.log('节点配置了', this.properties.customeName, this.properties.modal)
    // this.updateWidght()
  };

  _proto4.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {// if(widget.name == '表名称'){
      //     widget.disabled = value != '配置表'
      // }
    }); // this.expandToFitContent()
  } // onWidgetChanged(name, value, oldValue, widget){
  //     if(name == '类型'){
  //         this.updateWidght()
  //     }
  // }
  // onStart(){
  //     this.onExecute()
  // }
  //可以每帧触发，也可以onStart触发，还可以手动调用触发刷新值
  ;

  _proto4.onAction = function onAction(name) {
    var data = this.getInputData(0);

    if (data == undefined) {
      return;
    }

    var codeJsonData = cc.sys.localStorage.getItem('codeJsonData');

    if (codeJsonData == null || codeJsonData == '') {
      codeJsonData = {};
    } else {
      codeJsonData = JSON.parse(codeJsonData);
    }

    codeJsonData[this.properties.saveKey] = data;
    cc.sys.localStorage.setItem('codeJsonData', JSON.stringify(codeJsonData));
  } //暂不清楚用处
  // setValue(v){
  //     this.setProperty("value",v);
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return setData;
}(_litegraph.LGraphNode); // Register the node type


setData.title = '保存自定义数据'; //设置中文名称标题，是否需要实现多语言？
// setData.valueTypes = ['数值', '文字', '字典', '数组']

_litegraph.LiteGraph.registerNodeType("output/setData", setData); //第一个是唯一key，同时也是菜单选项路径

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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