
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/games.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '75d97i2bTxLYqFTXEgwqTAC', 'games');
// Script/Common/LiteGraphCore/nodes/games.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

var _BaseYwNode = require("./BaseYwNode");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var dragNumGame = /*#__PURE__*/function (_BaseYWNode) {
  _inheritsLoose(dragNumGame, _BaseYWNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function dragNumGame() {
    var _this;

    _this = _BaseYWNode.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this.title = "value";
    _this.desc = "这是一个拖拽数数游戏的模型";
    _this.name = '拖拽数数游戏控制器';

    _this.addInput("物体", "codeNode");

    _this.addOutput("播放问题", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addOutput("当前正确数量", 'number'); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addOutput("输出正确反馈", _litegraph.LiteGraph.EVENT);

    _this.addOutput("输出错误反馈", _litegraph.LiteGraph.EVENT);

    _this.addOutput("输出结束反馈", _litegraph.LiteGraph.EVENT);

    _this.addProperty("rightCount", 5); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this.widget = _this.addWidget("number", "正确选项数量", 5, "rightCount", {
      precision: 0,
      step2: 1
    }); //    this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this;
  }

  var _proto = dragNumGame.prototype;

  _proto.onStart = function onStart() {
    this.trigger('播放问题');
    this.curRightCount = 0;
  };

  _proto.onAction = function onAction(state) {
    if (state == 'right') {
      this.curRightCount += 1;
      this.setOutputData(1, this.curRightCount);
      this.trigger('输出正确反馈');

      if (this.curRightCount == this.properties.rightCount) {
        this.trigger('输出结束反馈');
      }
    } else if (state == 'error') {
      this.trigger('输出错误反馈');
    }
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  //   var A = this.getInputData(0)
  //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  // }
  ;

  return dragNumGame;
}(_BaseYwNode.BaseYWNode); // Register the node type


dragNumGame.title = '拖拽数数游戏控制器'; //设置中文名称标题，是否需要实现多语言？

dragNumGame.nodeType = "output/tatagame/dragGame/dragGameControl";

_litegraph.LiteGraph.registerNodeType(dragNumGame.nodeType, dragNumGame); //第一个是唯一key，同时也是菜单选项路径


var dragNumObj = /*#__PURE__*/function (_BaseYWNode2) {
  _inheritsLoose(dragNumObj, _BaseYWNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function dragNumObj() {
    var _this2;

    _this2 = _BaseYWNode2.call(this) || this;
    _this2.title = "value";
    _this2.desc = "这是一个拖拽数数游戏的选项，关联到选项上";
    _this2.name = '拖拽数数游戏选项';

    _this2.addInput("物体", "codeNode"); //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //this.addInput("B", "number")


    _this2.addProperty("isRight", true); //增加一个变量，    变量名称， 变量名称


    _this2.widget = _this2.addWidget("toggle", "是否为正确选项", true, "isRight"); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.widget = this.addWidget("number","值",1,"value");
    //   this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this2.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this2;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto2 = dragNumObj.prototype;

  _proto2.onExecute = function onExecute() {//   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
  };

  _proto2.onStart = function onStart() {
    var _this3 = this;

    _BaseYWNode2.prototype.onStart.call(this);

    var codeNode = this.getInputData(0); // let linkObjectNode = this.getInputNode(0)
    // if(linkObjectNode == null){
    //     console.log('当前没有连接节点', linkObjectNode)
    //     return
    // }

    this.touchIds = {};

    if (codeNode != null) {
      if (this.startPos == null) {
        this.startPos = cc.v2(codeNode.x, codeNode.y);
        this.startZIndex = codeNode.zIndex;
      }

      var lastMovePos = null;
      var moveCount = 5;
      var eventId = null;
      codeNode.targetOff(this);
      codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        lastMovePos = null;
        eventId = event.getID();
        var eventid = event.getID();
        _this3.touchIds[eventid] = 1;
        codeNode.zIndex = 1999;
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
        if (Object.keys(_this3.touchIds).length > 1) {
          //多点触摸时不响应
          return;
        }

        if (eventId != event.getID()) {
          return;
        }

        if (_this3.graph.config.pause == 1) {
          return;
        }

        if (_this3.inAni == true) {
          return;
        }

        if (_this3.instance != null && moveCount < 5) {
          moveCount += 1;
          return;
        }

        moveCount = 0;

        if (lastMovePos == null) {
          lastMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation());
          return;
        }

        var nowMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation()); //移动的时候检测，只在碰撞框内才出发移动

        var inTouch = true; // if(this.properties.needCheckIn.default == 1){
        //     var collider = codeNode.getComponent(cc.PolygonCollider)
        //     if(collider != null){
        //         var inNodePos = codeNode.node.convertToNodeSpaceAR(event.getLocation())
        //         var inTouch = cc.Intersection.pointInPolygon(inNodePos, collider.points)
        //     }
        // }

        var delta = nowMovePos.sub(lastMovePos);

        if (inTouch == true) {
          // this.setOutputData(0, delta.x)
          // this.setOutputData(1, delta.y)
          // this.triggerSlot(2, 1)
          // if(this.properties.controllObj == true){
          codeNode.x += delta.x;
          codeNode.y += delta.y; // }
        }

        lastMovePos = nowMovePos;
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        var eventid = event.getID();
        delete _this3.touchIds[eventid]; //判断是否

        _this3.checkIsInTarget(codeNode, event);
      }, this);
      codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
        if (_this3.inAni == true) {
          return;
        }

        var eventid = event.getID();
        delete _this3.touchIds[eventid];

        _this3.checkIsInTarget(codeNode, event);
      }, this);
    } // if(this.touchEndNode == null){
    //     let touchEndNode = LiteGraph.createNode('input/screen/touchEnd')
    //     linkObjectNode.connect(0, touchEndNode, 0)
    //     touchEndNode.onAction('监听')
    //     this.touchEndNode = touchEndNode
    // }else{
    //     this.touchEndNode.onAction('监听')
    // }

  };

  _proto2.checkIsInTarget = function checkIsInTarget(codeNode, event) {
    var _this4 = this;

    var isIn = false;
    var dragNumGameControll = this.graph.findNodesByType(dragNumGame.nodeType)[0];

    if (dragNumGameControll == null) {
      return;
    }

    var targetNode = dragNumGameControll.getInputData(0, true);

    if (targetNode != null) {
      var collider = targetNode.getComponent(cc.PolygonCollider);

      if (collider != null) {
        var inNodePos = targetNode.node.convertToNodeSpaceAR(event.getLocation());
        isIn = cc.Intersection.pointInPolygon(inNodePos, collider.points);
        console.log('判断是否处于碰撞框内', isIn);
      } else {
        //没有添加碰撞框
        console.warn("目标对象没有添加碰撞框");

        if (CocosMgr.isInApp == false) {
          if (window.antAleart != null) {
            window.antAleart('目标对象没有添加碰撞框');
          }
        }
      }
    }

    if (isIn == false) {
      //如果没有拖到目标位置，不管正确错误都回到原来位置
      this.inAni = true;
      cc.tween(codeNode).to(0.5, {
        x: this.startPos.x,
        y: this.startPos.y
      }).call(function () {
        codeNode.zIndex = _this4.startZIndex;
        _this4.inAni = false;
      }).start();
    } else {
      //通知游戏控制器
      if (this.properties.isRight == true) {
        dragNumGameControll.onAction('right');
        codeNode.targetOff(this);
        cc.tween(codeNode).to(0.5, {
          opacity: 0
        }).start();
      } else {
        dragNumGameControll.onAction('error'); //错误选项回到原来位置

        this.inAni = true;
        cc.tween(codeNode).to(0.5, {
          x: this.startPos.x,
          y: this.startPos.y
        }).call(function () {
          codeNode.zIndex = _this4.startZIndex;
          _this4.inAni = false;
        }).start();
      }
    }
  };

  return dragNumObj;
}(_BaseYwNode.BaseYWNode); // Register the node type


dragNumObj.title = '拖拽数数游戏选项'; //设置中文名称标题，是否需要实现多语言？

dragNumObj.nodeType = "output/tatagame/dragGame/dragNumObj";

_litegraph.LiteGraph.registerNodeType(dragNumObj.nodeType, dragNumObj); //第一个是唯一key，同时也是菜单选项路径

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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