
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/graphExtension.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5c619rDtAhDWbgv0Gd78o1O', 'graphExtension');
// Script/Common/LiteGraphCore/nodes/graphExtension.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

//Subgraph: a node that contains a graph
var Subgraph = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(Subgraph, _LGraphNode);

  function Subgraph() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "分支蓝图";
    _this.desc = "Graph inside a node";
    _this.color = "#334";

    _this.onResize = function (size) {
      size[1] += 20;
    };

    _this.serialize = function () {
      var data = _litegraph.LiteGraph.LGraphNode.prototype.serialize.call(this);

      data.subgraph = this.subgraph.serialize();
      return data;
    };

    _this.addProperty('enabled', true, 'boolean');

    _this.enabled = true; // this.addInput('触发', LiteGraph.ACTION)
    //create inner graph

    _this.subgraph = new _litegraph.LiteGraph.LGraph();
    _this.subgraph._subgraph_node = _assertThisInitialized(_this);
    _this.subgraph._is_subgraph = true;
    _this.subgraph.onTrigger = _this.onSubgraphTrigger.bind(_assertThisInitialized(_this)); //nodes input node added inside

    _this.subgraph.onInputAdded = _this.onSubgraphNewInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputRenamed = _this.onSubgraphRenamedInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputTypeChanged = _this.onSubgraphTypeChangeInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onInputRemoved = _this.onSubgraphRemovedInput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputAdded = _this.onSubgraphNewOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputRenamed = _this.onSubgraphRenamedOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputTypeChanged = _this.onSubgraphTypeChangeOutput.bind(_assertThisInitialized(_this));
    _this.subgraph.onOutputRemoved = _this.onSubgraphRemovedOutput.bind(_assertThisInitialized(_this));
    return _this;
  }

  var _proto = Subgraph.prototype;

  _proto.onGetInputs = function onGetInputs() {
    // console.log('subgraph获取了可以添加的输入')
    return [["enabled", "boolean"], ["触发", _litegraph.LiteGraph.ACTION]];
  };

  _proto.onGetOutputs = function onGetOutputs() {
    // console.log('subgraph获取了可以添加的输入')
    return [["结束", _litegraph.LiteGraph.EVENT], ['被引用', 'lgraphNode']];
  } // onGetInputs = function() {
  //     return [
  //         ["and", "boolean"]
  //     ];
  // };
  ;

  _proto.onDblClick = function onDblClick(e, pos, graphcanvas) {
    var that = this;
    setTimeout(function () {
      graphcanvas.openSubgraph(that.subgraph);
    }, 10);
  };

  _proto.onDrawTitle = function onDrawTitle(ctx, graph_mouse) {
    var node = this;

    if (!node.flags.collapsed && node.subgraph && !node.skip_subgraph_button) {
      var w = _litegraph.LiteGraph.NODE_TITLE_HEIGHT;
      var x = node.size[0] - w;

      var over = _litegraph.LiteGraph.isInsideRectangle(graph_mouse[0] - node.pos[0], graph_mouse[1] - node.pos[1], x + 2, -w + 2, w - 4, w - 4);

      ctx.fillStyle = over ? "#888" : "#555";
      if (this.renderingShape == _litegraph.LiteGraph.BOX_SHAPE) ctx.fillRect(x + 2, -w + 2, w - 4, w - 4);else {
        ctx.beginPath();
        ctx.roundRect(x + 2, -w + 2, w - 4, w - 4, [4]);
        ctx.fill();
      }
      ctx.fillStyle = "#333";
      ctx.beginPath();
      ctx.moveTo(x + w * 0.2, -w * 0.6);
      ctx.lineTo(x + w * 0.8, -w * 0.6);
      ctx.lineTo(x + w * 0.5, -w * 0.3);
      ctx.fill();
    }
  } //onToggle执行的是onExecute，其它事件在onAction中执行
  ;

  _proto.onAction = function onAction(action, param) {
    // console.log('Subgraph onAction',  action, param)
    this.subgraph.onAction(action, param);
  };

  _proto.onExecute = function onExecute() {
    // console.log('Subgraph onExecute')
    this.enabled = this.getInputOrProperty("enabled");

    if (!this.enabled) {
      return;
    } //send inputs to subgraph global inputs


    if (this.inputs) {
      for (var i = 0; i < this.inputs.length; i++) {
        var input = this.inputs[i];
        var value = this.getInputData(i);
        this.subgraph.setInputData(input.name, value);
      }
    } //execute


    this.subgraph.runStep(); //send subgraph global outputs to outputs

    if (this.outputs) {
      for (var i = 0; i < this.outputs.length; i++) {
        var output = this.outputs[i];
        var value = this.subgraph.getOutputData(output.name);
        this.setOutputData(i, value);
      }
    }
  };

  _proto.sendEventToAllNodes = function sendEventToAllNodes(eventname, param, mode) {
    console.log('sendEventToAllNodes', eventname, param, mode);

    if (this.enabled) {
      this.subgraph.sendEventToAllNodes(eventname, param, mode);
    }
  };

  _proto.onDrawBackground = function onDrawBackground(ctx, graphcanvas, canvas, pos) {
    if (this.flags.collapsed) return;
    var y = this.size[1] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT + 0.5; // button

    var over = _litegraph.LiteGraph.isInsideRectangle(pos[0], pos[1], this.pos[0], this.pos[1] + y, this.size[0], _litegraph.LiteGraph.NODE_TITLE_HEIGHT);

    var overleft = _litegraph.LiteGraph.isInsideRectangle(pos[0], pos[1], this.pos[0], this.pos[1] + y, this.size[0] / 2, _litegraph.LiteGraph.NODE_TITLE_HEIGHT); // let over = true
    // let overleft = false


    ctx.fillStyle = over ? "#555" : "#222";
    ctx.beginPath();

    if (this._shape == _litegraph.LiteGraph.BOX_SHAPE) {
      if (overleft) {
        ctx.rect(0, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
      } else {
        ctx.rect(this.size[0] / 2, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
      }
    } else {
      if (overleft) {
        ctx.roundRect(0, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT, [0, 0, 8, 8]);
      } else {
        ctx.roundRect(this.size[0] / 2, y, this.size[0] / 2 + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT, [0, 0, 8, 8]);
      }
    }

    if (over) {
      ctx.fill();
    } else {
      ctx.fillRect(0, y, this.size[0] + 1, _litegraph.LiteGraph.NODE_TITLE_HEIGHT);
    } // button


    ctx.textAlign = "center";
    ctx.font = "24px Arial";
    ctx.fillStyle = over ? "#DDD" : "#999";
    ctx.fillText("+", this.size[0] * 0.25, y + 24);
    ctx.fillText("+", this.size[0] * 0.75, y + 24);
  } // onMouseDown(e, pos, graphcanvas) {
  //     if (
  //         !this.flags.collapsed &&
  //         pos[0] > this.size[0] - LiteGraph.NODE_TITLE_HEIGHT &&
  //         pos[1] < 0
  //     ) {
  //         var that = this;
  //         setTimeout(function() {
  //             graphcanvas.openSubgraph(that.subgraph);
  //         }, 10);
  //     }
  // };
  ;

  _proto.onMouseDown = function onMouseDown(e, localpos, graphcanvas) {
    if (!this.flags.collapsed && localpos[0] > this.size[0] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT && localpos[1] < 0) {
      var that = this;
      setTimeout(function () {
        graphcanvas.openSubgraph(that.subgraph);
      }, 10);
    }

    var y = this.size[1] - _litegraph.LiteGraph.NODE_TITLE_HEIGHT + 0.5;
    console.log(0);

    if (localpos[1] > y) {
      if (localpos[0] < this.size[0] / 2) {
        console.log(1);
        graphcanvas.showSubgraphPropertiesDialog(this);
      } else {
        console.log(2);
        graphcanvas.showSubgraphPropertiesDialogRight(this);
      }
    }
  };

  _proto.computeSize = function computeSize() {
    var num_inputs = this.inputs ? this.inputs.length : 0;
    var num_outputs = this.outputs ? this.outputs.length : 0;
    return [200, Math.max(num_inputs, num_outputs) * _litegraph.LiteGraph.NODE_SLOT_HEIGHT + _litegraph.LiteGraph.NODE_TITLE_HEIGHT];
  } //**** INPUTS ***********************************
  ;

  _proto.onSubgraphTrigger = function onSubgraphTrigger(event, param) {
    console.log('onSubgraphTrigger', event, param);
    var slot = this.findOutputSlot(event);

    if (slot != -1) {
      this.triggerSlot(slot);
    }
  };

  _proto.onSubgraphNewInput = function onSubgraphNewInput(name, type) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      //add input to the node
      this.addInput(name, type);
    }
  };

  _proto.onSubgraphRenamedInput = function onSubgraphRenamedInput(oldname, name) {
    var slot = this.findInputSlot(oldname);

    if (slot == -1) {
      return;
    }

    var info = this.getInputInfo(slot);
    info.name = name;
  };

  _proto.onSubgraphTypeChangeInput = function onSubgraphTypeChangeInput(name, type) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      return;
    }

    var info = this.getInputInfo(slot);
    info.type = type;
  };

  _proto.onSubgraphRemovedInput = function onSubgraphRemovedInput(name) {
    var slot = this.findInputSlot(name);

    if (slot == -1) {
      return;
    }

    this.removeInput(slot);
  };

  //**** OUTPUTS ***********************************
  _proto.onSubgraphNewOutput = function onSubgraphNewOutput(name, type) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      this.addOutput(name, type);
    }
  };

  _proto.onSubgraphRenamedOutput = function onSubgraphRenamedOutput(oldname, name) {
    var slot = this.findOutputSlot(oldname);

    if (slot == -1) {
      return;
    }

    var info = this.getOutputInfo(slot);
    info.name = name;
  };

  _proto.onSubgraphTypeChangeOutput = function onSubgraphTypeChangeOutput(name, type) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      return;
    }

    var info = this.getOutputInfo(slot);
    info.type = type;
  };

  _proto.onSubgraphRemovedOutput = function onSubgraphRemovedOutput(name) {
    var slot = this.findOutputSlot(name);

    if (slot == -1) {
      return;
    }

    this.removeOutput(slot);
  };

  // *****************************************************
  _proto.getExtraMenuOptions = function getExtraMenuOptions(graphcanvas) {
    var that = this;
    return [{
      content: "Open",
      callback: function callback() {
        graphcanvas.openSubgraph(that.subgraph);
      }
    }];
  };

  //no need to define node.configure, the default method detects node.subgraph and passes the object to node.subgraph.configure()
  _proto.reassignSubgraphUUIDs = function reassignSubgraphUUIDs(graph) {
    var idMap = {
      nodeIDs: {},
      linkIDs: {}
    };

    for (var _iterator = _createForOfIteratorHelperLoose(graph.nodes), _step; !(_step = _iterator()).done;) {
      var node = _step.value;
      var oldID = node.id;

      var newID = _litegraph.LiteGraph.uuidv4();

      node.id = newID;

      if (idMap.nodeIDs[oldID] || idMap.nodeIDs[newID]) {
        throw new Error("New/old node UUID wasn't unique in changed map! " + oldID + " " + newID);
      }

      idMap.nodeIDs[oldID] = newID;
      idMap.nodeIDs[newID] = oldID;
    }

    for (var _iterator2 = _createForOfIteratorHelperLoose(graph.links), _step2; !(_step2 = _iterator2()).done;) {
      var link = _step2.value;
      var _oldID = link[0];

      var _newID = _litegraph.LiteGraph.uuidv4();

      link[0] = _newID;

      if (idMap.linkIDs[_oldID] || idMap.linkIDs[_newID]) {
        throw new Error("New/old link UUID wasn't unique in changed map! " + _oldID + " " + _newID);
      }

      idMap.linkIDs[_oldID] = _newID;
      idMap.linkIDs[_newID] = _oldID;
      var nodeFrom = link[1];
      var nodeTo = link[3];

      if (!idMap.nodeIDs[nodeFrom]) {
        throw new Error("Old node UUID not found in mapping! " + nodeFrom);
      }

      link[1] = idMap.nodeIDs[nodeFrom];

      if (!idMap.nodeIDs[nodeTo]) {
        throw new Error("Old node UUID not found in mapping! " + nodeTo);
      }

      link[3] = idMap.nodeIDs[nodeTo];
    } // Reconnect links


    for (var _iterator3 = _createForOfIteratorHelperLoose(graph.nodes), _step3; !(_step3 = _iterator3()).done;) {
      var _node = _step3.value;

      if (_node.inputs) {
        for (var _iterator5 = _createForOfIteratorHelperLoose(_node.inputs), _step5; !(_step5 = _iterator5()).done;) {
          var input = _step5.value;

          if (input.link) {
            input.link = idMap.linkIDs[input.link];
          }
        }
      }

      if (_node.outputs) {
        for (var _iterator6 = _createForOfIteratorHelperLoose(_node.outputs), _step6; !(_step6 = _iterator6()).done;) {
          var output = _step6.value;

          if (output.links) {
            output.links = output.links.map(function (l) {
              return idMap.linkIDs[l];
            });
          }
        }
      }
    } // Recurse!


    for (var _iterator4 = _createForOfIteratorHelperLoose(graph.nodes), _step4; !(_step4 = _iterator4()).done;) {
      var _node2 = _step4.value;

      if (_node2.type === "middle/graph/subgraph") {
        var merge = reassignGraphUUIDs(_node2.subgraph);
        idMap.nodeIDs.assign(merge.nodeIDs);
        idMap.linkIDs.assign(merge.linkIDs);
      }
    }
  };

  _proto.clone = function clone() {
    var node = _litegraph.LiteGraph.createNode(this.type);

    var data = this.serialize();

    if (_litegraph.LiteGraph.use_uuids) {
      // LGraph.serialize() seems to reuse objects in the original graph. But we
      // need to change node IDs here, so clone it first.
      var subgraph = _litegraph.LiteGraph.cloneObject(data.subgraph);

      this.reassignSubgraphUUIDs(subgraph);
      data.subgraph = subgraph;
    }

    delete data["id"];
    delete data["inputs"];
    delete data["outputs"];
    node.configure(data);
    return node;
  };

  _proto.buildFromNodes = function buildFromNodes(nodes) {
    //clear all?
    //TODO
    //nodes that connect data between parent graph and subgraph
    var subgraph_inputs = [];
    var subgraph_outputs = []; //mark inner nodes

    var ids = {};
    var min_x = 0;
    var max_x = 0;

    for (var i = 0; i < nodes.length; ++i) {
      var node = nodes[i];
      ids[node.id] = node;
      min_x = Math.min(node.pos[0], min_x);
      max_x = Math.max(node.pos[0], min_x);
    }

    var last_input_y = 0;
    var last_output_y = 0;

    for (var i = 0; i < nodes.length; ++i) {
      var node = nodes[i]; //check inputs

      if (node.inputs) for (var j = 0; j < node.inputs.length; ++j) {
        var input = node.inputs[j];
        if (!input || !input.link) continue;
        var link = node.graph.links[input.link];
        if (!link) continue;
        if (ids[link.origin_id]) continue; //this.addInput(input.name,link.type);

        this.subgraph.addInput(input.name, link.type);
        /*
        var input_node = LiteGraph.createNode("graph/input");
        this.subgraph.add( input_node );
        input_node.pos = [min_x - 200, last_input_y ];
        last_input_y += 100;
        */
      } //check outputs

      if (node.outputs) for (var j = 0; j < node.outputs.length; ++j) {
        var output = node.outputs[j];
        if (!output || !output.links || !output.links.length) continue;
        var is_external = false;

        for (var k = 0; k < output.links.length; ++k) {
          var link = node.graph.links[output.links[k]];
          if (!link) continue;
          if (ids[link.target_id]) continue;
          is_external = true;
          break;
        }

        if (!is_external) continue; //this.addOutput(output.name,output.type);

        /*
        var output_node = LiteGraph.createNode("graph/output");
        this.subgraph.add( output_node );
        output_node.pos = [max_x + 50, last_output_y ];
        last_output_y += 100;
        */
      }
    } //detect inputs and outputs
    //split every connection in two data_connection nodes
    //keep track of internal connections
    //connect external connections
    //clone nodes inside subgraph and try to reconnect them
    //connect edge subgraph nodes to extarnal connections nodes

  };

  return Subgraph;
}(_litegraph.LGraphNode);

Subgraph.title = '分支蓝图';
Subgraph.input_node_type = "middle/graph/input";
Subgraph.output_node_type = "middle/graph/output";
_litegraph.LiteGraph.Subgraph = Subgraph;

_litegraph.LiteGraph.registerNodeType("middle/graph/subgraph", Subgraph);

var GraphInput = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(GraphInput, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function GraphInput() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "输入";
    _this2.desc = "用于对子蓝图输入参数";

    _this2.addOutput("", "number");

    _this2.name_in_graph = "";
    _this2.properties = {
      name: "",
      type: "number",
      value: 0
    };

    var that = _assertThisInitialized(_this2);

    _this2.name_widget = _this2.addWidget("text", "Name", _this2.properties.name, function (v) {
      if (!v) {
        return;
      }

      that.setProperty("name", v);
    });
    _this2.type_widget = _this2.addWidget("text", "Type", _this2.properties.type, function (v) {
      that.setProperty("type", v);
    });
    _this2.value_widget = _this2.addWidget("number", "Value", _this2.properties.value, function (v) {
      that.setProperty("value", v);
    });
    _this2.widgets_up = true;
    _this2.size = [180, 90];
    return _this2;
  }

  var _proto2 = GraphInput.prototype;

  _proto2.onConfigure = function onConfigure() {
    this.updateType();
  } //ensures the type in the node output and the type in the associated graph input are the same
  ;

  _proto2.updateType = function updateType() {
    var type = this.properties.type;
    this.type_widget.value = type; //update output

    if (this.outputs[0].type != type) {
      if (!_litegraph.LiteGraph.isValidConnection(this.outputs[0].type, type)) this.disconnectOutput(0);
      this.outputs[0].type = type;
    } //update widget


    if (type == "number") {
      this.value_widget.type = "number";
      this.value_widget.value = 0;
    } else if (type == "boolean") {
      this.value_widget.type = "toggle";
      this.value_widget.value = true;
    } else if (type == "string") {
      this.value_widget.type = "text";
      this.value_widget.value = "";
    } else {
      this.value_widget.type = null;
      this.value_widget.value = null;
    }

    this.properties.value = this.value_widget.value; //update graph

    if (this.graph && this.name_in_graph) {
      this.graph.changeInputType(this.name_in_graph, type);
    }
  } //this is executed AFTER the property has changed
  ;

  _proto2.onPropertyChanged = function onPropertyChanged(name, v) {
    if (name == "name") {
      if (v == "" || v == this.name_in_graph || v == "enabled") {
        return false;
      }

      if (this.graph) {
        if (this.name_in_graph) {
          //already added
          this.graph.renameInput(this.name_in_graph, v);
        } else {
          this.graph.addInput(v, this.properties.type);
        }
      } //what if not?!


      this.name_widget.value = v;
      this.name_in_graph = v;
    } else if (name == "type") {
      this.updateType();
    } else if (name == "value") {}
  } //
  ;

  _proto2.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.name;
    }

    return this.title;
  };

  _proto2.onAction = function onAction(action, param) {
    console.log('graph input 收到了action', action, param);

    if (this.properties.type == _litegraph.LiteGraph.EVENT) {
      this.triggerSlot(0, param);
    }
  };

  //不同的子graph中的nodeid会出现相同的情况，cctween绑定了nodeid，会导致不同的子graph出现执行动画干扰的情况
  //需要处理这个问题
  _proto2.onExecute = function onExecute() {
    // console.log('this.graph.inputs', this.graph.inputs)
    var name = this.properties.name; //read from global input

    var data = this.graph.inputs[name];

    if (!data) {
      this.setOutputData(0, this.properties.value);
      return;
    }

    this.setOutputData(0, data.value !== undefined ? data.value : this.properties.value);
  };

  _proto2.onRemoved = function onRemoved() {
    if (this.name_in_graph) {
      this.graph.removeInput(this.name_in_graph);
    }
  };

  return GraphInput;
}(_litegraph.LGraphNode);

GraphInput.title = '输入';
_litegraph.LiteGraph.GraphInput = GraphInput;

_litegraph.LiteGraph.registerNodeType("middle/graph/input", GraphInput); //这是一个输出界面


var GraphOutput = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(GraphOutput, _LGraphNode3);

  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function GraphOutput() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this;
    _this3.title = "输出";
    _this3.desc = "用于对子蓝图输出参数";

    _this3.addInput("", "");

    _this3.name_in_graph = "";
    _this3.properties = {
      name: "",
      type: ""
    };
    _this3.name_widget = _this3.addWidget("text", "Name", _this3.properties.name, "name");
    _this3.type_widget = _this3.addWidget("text", "Type", _this3.properties.type, "type");
    _this3.widgets_up = true;
    _this3.size = [180, 60];
    return _this3;
  }

  var _proto3 = GraphOutput.prototype;

  _proto3.onPropertyChanged = function onPropertyChanged(name, v) {
    if (name == "name") {
      if (v == "" || v == this.name_in_graph || v == "enabled") {
        return false;
      }

      if (this.graph) {
        if (this.name_in_graph) {
          //already added
          this.graph.renameOutput(this.name_in_graph, v);
        } else {
          this.graph.addOutput(v, this.properties.type);
        }
      } //what if not?!


      this.name_widget.value = v;
      this.name_in_graph = v;
    } else if (name == "type") {
      this.updateType();
    } else if (name == "value") {}
  };

  _proto3.updateType = function updateType() {
    var type = this.properties.type;
    if (this.type_widget) this.type_widget.value = type; //update output

    if (this.inputs[0].type != type) {
      if (type == "action" || type == "event") type = _litegraph.LiteGraph.EVENT;
      if (!_litegraph.LiteGraph.isValidConnection(this.inputs[0].type, type)) this.disconnectInput(0);
      this.inputs[0].type = type;
    } //update graph


    if (this.graph && this.name_in_graph) {
      this.graph.changeOutputType(this.name_in_graph, type);
    }
  };

  _proto3.onExecute = function onExecute() {
    this._value = this.getInputData(0);
    this.graph.setOutputData(this.properties.name, this._value);
  };

  _proto3.onAction = function onAction(action, param) {
    if (this.properties.type == _litegraph.LiteGraph.ACTION) {
      this.graph.trigger(this.properties.name, param);
    }
  };

  _proto3.onRemoved = function onRemoved() {
    if (this.name_in_graph) {
      this.graph.removeOutput(this.name_in_graph);
    }
  };

  _proto3.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.name;
    }

    return this.title;
  };

  return GraphOutput;
}(_litegraph.LGraphNode);

GraphOutput.title = '输出';
_litegraph.LiteGraph.GraphOutput = GraphOutput;

_litegraph.LiteGraph.registerNodeType("middle/graph/output", GraphOutput);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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