
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/input.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6643ayNFuRHd5AMRer5A5lP', 'input');
// Script/Common/LiteGraphCore/nodes/input.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var valueRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(valueRobot, _LGraphNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function valueRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this.title = "value";
    _this.desc = "定义一个数";
    _this.name = '数值';

    _this.addOutput("输出", "number"); //增加一个输出触点，  输出节点的名称， 值类型


    _this.addProperty("value", 1.0); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this.widget = _this.addWidget("number", "值", 1, "value"); //    this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto = valueRobot.prototype;

  _proto.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, parseFloat(this.properties["value"])); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  ;

  _proto.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    this.outputs[0].label = this.properties["value"].toFixed(3);
  };

  return valueRobot;
}(_litegraph.LGraphNode);

// Register the node type
valueRobot.title = '数值'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/value", valueRobot); //第一个是唯一key，同时也是菜单选项路径


var valueStringRobot = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(valueStringRobot, _LGraphNode2);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function valueStringRobot() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this2.title = "文字";
    _this2.desc = "定义文字值";

    _this2.addOutput("输出", "string"); //增加一个输出触点，  输出节点的名称， 值类型


    _this2.addProperty("value", ""); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this2.widget = _this2.addWidget("text", "value", "", "value"); //  this.serialize_widgets = true;
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称

    _this2.widgets_up = true; //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this2;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto2 = valueStringRobot.prototype;

  _proto2.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, this.properties["value"]); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto2.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto2.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return valueStringRobot;
}(_litegraph.LGraphNode); // Register the node type


valueStringRobot.title = '文字'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/valueString", valueStringRobot); //第一个是唯一key，同时也是菜单选项路径


var BooleanRobot = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(BooleanRobot, _LGraphNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function BooleanRobot() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this3.title = "布尔值";
    _this3.desc = "定义一个数";

    _this3.addOutput("bool", "boolean"); //增加一个输出触点，  输出节点的名称， 值类型


    _this3.addProperty("value", true); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this3.widget = _this3.addWidget("toggle", "value", true, "value"); //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    // this.size = [140, 30];                                  //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this3;
  } // Function to call when the node is executed
  //执行时的方法


  var _proto3 = BooleanRobot.prototype;

  _proto3.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    this.setOutputData(0, parseFloat(this.properties["value"])); //发送一个参数出去
  } //动态返回卡片显示的title
  ;

  _proto3.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.value;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto3.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  ;

  _proto3.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    this.outputs[0].label = this.properties["value"] ? '真' : '假';
  };

  return BooleanRobot;
}(_litegraph.LGraphNode);

BooleanRobot.title = '布尔值';

_litegraph.LiteGraph.registerNodeType("input/boolean", BooleanRobot);

var gameStartRobot = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(gameStartRobot, _LGraphNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function gameStartRobot() {
    var _this4;

    _this4 = _LGraphNode4.call(this) || this; //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    //   this.addInput("B", "number")

    _this4.title = "开始时";
    _this4.desc = "但游戏开始时执行一次";

    _this4.addOutput("游戏开始", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this4.addProperty('modal', '开始时', 'enum');

    _this4.addWidget('combo', '输出时机', _this4.properties.modal, {
      property: "modal",
      values: ['开始前', '开始时', '开始后']
    }); //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称


    _this4.widgets_up = true; //设置输入组件在顶部（覆盖input和output）

    _this4.size = [180, 30]; //设置默认节点尺寸
    //   this.properties.precision = 1

    return _this4;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  //这一阶段加载所有资源


  var _proto4 = gameStartRobot.prototype;

  _proto4.onStartBeforeLoad = function onStartBeforeLoad() {
    if (this.properties.modal == '开始前') {
      this.triggerSlot(0, 1);
    }
  } //开始时，在所有onExecute执行之前
  ;

  _proto4.onStart = function onStart() {
    if (this.properties.modal == '开始时') {
      this.triggerSlot(0, 1);
    }
  } //开始后在第一次onExecute执行之后
  ;

  _proto4.onStartAfter = function onStartAfter() {
    if (this.properties.modal == '开始后') {
      this.triggerSlot(0, 1);
    }
  } //动态返回卡片显示的title
  ;

  _proto4.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return this.properties.modal;
    }

    return this.title;
  };

  //暂不清楚用处
  _proto4.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return gameStartRobot;
}(_litegraph.LGraphNode); // Register the node type


gameStartRobot.title = '开始时'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/gameStart", gameStartRobot); //第一个是唯一key，同时也是菜单选项路径


var customButtonRobot = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(customButtonRobot, _LGraphNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function customButtonRobot() {
    var _this5;

    _this5 = _LGraphNode5.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this5.title = "按钮";
    _this5.desc = "一个可以点击的按钮";
    _this5.font = 'Arial';

    _this5.addOutput("", _litegraph.LiteGraph.EVENT); //增加一个输出触点，  输出节点的名称， 值类型


    _this5.addOutput("", "boolean");

    _this5.addProperty("font_size", 30);

    _this5.addProperty("text", "按钮");

    _this5.addProperty("message", ""); // this.addProperty("value", true);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）


    _this5.size = [164, 84]; //设置默认节点尺寸

    _this5.clicked = false; //   this.properties.precision = 1

    return _this5;
  }

  var _proto5 = customButtonRobot.prototype;

  _proto5.onMouseDown = function onMouseDown(e, local_pos) {
    if (local_pos[0] > 1 && local_pos[1] > 1 && local_pos[0] < this.size[0] - 2 && local_pos[1] < this.size[1] - 2) {
      this.clicked = true;
      this.setOutputData(1, this.clicked);
      this.triggerSlot(0, this.properties.message);
      this.clicked = false;
      this.setOutputData(1, this.clicked);
      return true;
    }
  };

  // onMouseUp(e) {
  //     console.log('鼠标离开了')
  //     this.clicked = false;
  //     this.setOutputData(1, this.clicked);
  // };
  // Function to call when the node is executed
  //执行时的方法
  _proto5.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
    this.setOutputData(1, this.clicked);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  ;

  _proto5.onDrawForeground = function onDrawForeground(ctx) {
    if (this.flags.collapsed) {
      return;
    }

    var margin = 10;
    ctx.fillStyle = "black";
    ctx.fillRect(margin + 1, margin + 1, this.size[0] - margin * 2, this.size[1] - margin * 2);
    ctx.fillStyle = "#AAF";
    ctx.fillRect(margin - 1, margin - 1, this.size[0] - margin * 2, this.size[1] - margin * 2);
    ctx.fillStyle = this.clicked ? "white" : this.mouseOver ? "#668" : "#334";
    ctx.fillRect(margin, margin, this.size[0] - margin * 2, this.size[1] - margin * 2);

    if (this.properties.text || this.properties.text === 0) {
      var font_size = this.properties.font_size || 30;
      ctx.textAlign = "center";
      ctx.fillStyle = this.clicked ? "black" : "white";
      ctx.font = font_size + "px " + 'Arial';
      ctx.fillText(this.properties.text, this.size[0] * 0.5, this.size[1] * 0.5 + font_size * 0.3);
      ctx.textAlign = "left";
    }
  };

  return customButtonRobot;
}(_litegraph.LGraphNode);

customButtonRobot.title = '按钮';

_litegraph.LiteGraph.registerNodeType("input/button/customButton", customButtonRobot);

var controllRobot = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(controllRobot, _LGraphNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function controllRobot() {
    var _this6;

    _this6 = _LGraphNode6.call(this) || this; // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")

    _this6.title = "摇杆";
    _this6.desc = "操作杆的x和y的范围：[-1, 1]，当拖动操控杆时\n仅改变时：操控杆移发生位移变化时输出当前操作杆范围\n持续：一直输出操控杆当前值*这一帧的时长";
    _this6.font = 'Arial';

    _this6.addOutput("左右", 'number'); //增加一个输出触点，  输出节点的名称， 值类型


    _this6.addOutput("上下", 'number');

    _this6.addOutput("按下时", _litegraph.LiteGraph.EVENT);

    _this6.addProperty("controllType", 0);

    _this6.addProperty("modal", 0);

    _this6.addProperty("outputScale", 250); // this.addProperty("outputScale", 0);
    // this.addProperty("font_size", 30);
    // this.addProperty("text", "click me");
    // this.addProperty("message", "");
    // this.addProperty("value", true);   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）


    _this6.size = [164, 164]; //设置默认节点尺寸

    _this6.clicked = false; //   this.properties.precision = 1

    return _this6;
  }

  var _proto6 = controllRobot.prototype;

  _proto6.freshHandlePos = function freshHandlePos(local_pos) {
    var minLength = Math.min(this.size[0], this.size[1]);
    var maxDistance = minLength * 0.5;
    var deltaX = local_pos[0] - maxDistance;
    var deltaY = local_pos[1] - maxDistance;
    var distance = Math.min(Math.sqrt(deltaX * deltaX + deltaY * deltaY), maxDistance); // 限制在圆形范围内

    var angle = Math.atan2(deltaY, deltaX);
    var limitedX = distance * Math.cos(angle);
    var limitedY = distance * Math.sin(angle);

    if (local_pos[0] > 0 && local_pos[1] > 0 && local_pos[0] < minLength && local_pos[1] < minLength) {
      // this.clicked = true;
      // var halfLength = minLength * 0.5
      this.setOutputData(0, limitedX / maxDistance);
      this.setOutputData(1, limitedY / maxDistance); // this.triggerSlot(0, this.properties.message);
      // this.clicked = false;
      // this.setOutputData(1, this.clicked);
      // console.log('点击了摇杆', local_pos)

      return true;
    }
  };

  _proto6.onMouseDown = function onMouseDown(e, local_pos) {
    this.clicked = true;
    this.freshHandlePos(local_pos);
    this.triggerSlot(2);
  };

  _proto6.onMouseMove = function onMouseMove(e, local_pos) {
    if (this.clicked != true) {
      return;
    }

    this.freshHandlePos(local_pos);
  };

  _proto6.onMouseUp = function onMouseUp(e) {
    // console.log('鼠标离开了')
    this.clicked = false;
    this.setOutputData(0, 0);
    this.setOutputData(1, 0);
  };

  // Function to call when the node is executed
  //执行时的方法
  _proto6.onExecute = function onExecute() {
    //   var A = this.getInputData(0)
    //   this.setOutputData(0, parseFloat(this.properties["value"])) //发送一个参数出去
    this.setOutputData(1, this.clicked);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  // setValue(v){
  // 	this.setProperty("value",v);
  // }
  // 获取可以接受的输出
  // onGetInputs() {
  // 	return [["toggle", LiteGraph.ACTION]];
  // };
  // 当节点Toggle时调用
  // onAction(action)
  // {
  // 	this.setValue( !this.properties.value );
  // }
  //自定义触点显示的文字
  ;

  _proto6.onDrawBackground = function onDrawBackground(ctx) {
    //show the current value
    if (this.flags.collapsed) {
      return;
    }

    var x = this.getOutputData(0);
    var y = this.getOutputData(1);

    if (x != null && x.toFixed != null) {
      this.outputs[0].label = '左右：' + x.toFixed(3);
    }

    if (y != null && y.toFixed != null) {
      this.outputs[1].label = '上下：' + y.toFixed(3);
    }
  };

  //使用ctx绘制需要显示的内容
  _proto6.onDrawForeground = function onDrawForeground(ctx) {
    if (this.flags.collapsed) {
      return;
    }

    var minLength = Math.min(this.size[0], this.size[1]);
    var base = {
      width: minLength,
      height: minLength
    }; //整体大小

    var handle = {
      width: minLength * 0.25,
      height: minLength * 0.25
    }; //手柄大小

    this.size[0]; // ctx.fillStyle = "black";
    // ctx.clearRect(0, 0, base.width, base.height);
    // 底座渐变

    var gradient = ctx.createRadialGradient(base.width / 2, base.height / 2, 0, base.width / 2, base.height / 2, base.width / 2);
    gradient.addColorStop(0, '#666');
    gradient.addColorStop(1, '#222');
    ctx.beginPath();
    ctx.arc(base.width / 2, base.height / 2, base.width / 2, 0, Math.PI * 2);
    ctx.fillStyle = gradient;
    ctx.fill(); // 底座刻度

    ctx.strokeStyle = 'rgba(255,255,255,0.2)';
    ctx.lineWidth = 2; // 十字线

    ctx.beginPath();
    ctx.moveTo(base.width / 2, 0);
    ctx.lineTo(base.width / 2, base.height);
    ctx.moveTo(0, base.height / 2);
    ctx.lineTo(base.width, base.height / 2);
    ctx.stroke(); // 圆圈刻度

    for (var i = 1; i <= 3; i++) {
      ctx.beginPath();
      ctx.arc(base.width / 2, base.height / 2, i * base.width / 6, 0, Math.PI * 2);
      ctx.stroke();
    } // 绘制摇杆手柄
    // ctx.moveTo(base.width * 0.5, base.height * 0.5)


    var gradient = ctx.createRadialGradient(handle.width / 2, handle.height / 2, 0, handle.width / 2, handle.height / 2, handle.width / 2);
    gradient.addColorStop(0, '#fff');
    gradient.addColorStop(1, '#aaa');
    var dirX = this.getOutputData(0) || 0;
    var dirY = this.getOutputData(1) || 0;
    var xPos = base.width * 0.5 + (0 + dirX) * base.width * 0.5;
    var yPos = base.height * 0.5 + (0 + dirY) * base.height * 0.5;
    ctx.beginPath();
    ctx.arc(xPos, yPos, handle.width / 2, 0, Math.PI * 2);
    ctx.fillStyle = gradient;
    ctx.fill(); // 手柄高光

    ctx.beginPath();
    ctx.arc(xPos, yPos, handle.width / 3, 0, Math.PI * 2);
    ctx.fillStyle = 'rgba(255,255,255,0.3)';
    ctx.fill();
  };

  return controllRobot;
}(_litegraph.LGraphNode);

controllRobot.title = '摇杆';

_litegraph.LiteGraph.registerNodeType("input/button/controll", controllRobot);

var touchStart = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(touchStart, _LGraphNode7);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchStart() {
    var _this7;

    _this7 = _LGraphNode7.call(this) || this;
    _this7.title = "触摸开始";
    _this7.desc = "检测物体触摸开始";
    _this7.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this7.addInput("物体", "codeNode");

    _this7.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this7.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this7.addOutput('开始X', 'number');

    _this7.addOutput('开始Y', 'number');

    _this7.addOutput('点击', _litegraph.LiteGraph.EVENT);

    _this7.addProperty('controllObj', false, 'boolean');

    _this7.addWidget('toggle', '控制物体位置', _this7.properties.controllObj, 'controllObj'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this7.useCanvas = false;
    _this7.lastBindCodeNode = null;
    return _this7;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  // onStart(){
  //     // this.triggerSlot(0, 1);
  // }


  var _proto7 = touchStart.prototype;

  _proto7.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      this.useCanvas = false;
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto7.realRun = function realRun(codeNode, isListen) {
    var _this8 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.node.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;
        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        codeNode.targetOff(this);
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          if (_this8.graph.config.pause == 1) {
            return;
          }

          var location = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());

          if (_this8.properties.controllObj == true) {
            codeNode.x = location.x;
            codeNode.y = location.y;
          }

          _this8.setOutputData(0, location.x);

          _this8.setOutputData(1, location.y);

          _this8.triggerSlot(2, 1);
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          canvas = cc.director.getScene().getChildByName('Canvas'); // return
        }

        canvas.targetOff(this);
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          if (_this8.graph.config.pause == 1) {
            return;
          }

          var location = canvas.convertToNodeSpaceAR(event.getLocation());

          _this8.setOutputData(0, location.x);

          _this8.setOutputData(1, location.y);

          _this8.triggerSlot(2, 1);
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas = this.graph.config.rootccNode;

        if (_canvas == null) {
          // console.warn("没有rootccNode")
          _canvas = cc.director.getScene().getChildByName('Canvas');
          return;
        }

        _canvas.targetOff(this);
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto7.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto7.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchStart;
}(_litegraph.LGraphNode); // Register the node type


touchStart.title = '触摸开始'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchStart", touchStart); //第一个是唯一key，同时也是菜单选项路径


var touchMove = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(touchMove, _LGraphNode8);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchMove() {
    var _this9;

    _this9 = _LGraphNode8.call(this) || this;
    _this9.title = "触摸移动";
    _this9.desc = "检测物体触摸开始";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this9.addInput("物体", "codeNode");

    _this9.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this9.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this9.addOutput('X轴移动', 'number');

    _this9.addOutput('Y轴移动', 'number');

    _this9.addOutput('移动', _litegraph.LiteGraph.EVENT);

    _this9.addProperty('controllObj', false, 'boolean');

    _this9.addWidget('toggle', '控制物体位置', _this9.properties.controllObj, 'controllObj');

    _this9.addProperty('needCheckIn', false, 'boolean');

    _this9.addWidget('toggle', '碰撞框检测', _this9.properties.needCheckIn, 'needCheckIn');

    _this9.addProperty('mutplayTouch', false, 'boolean');

    _this9.addWidget('toggle', '忽略多点触摸', _this9.properties.mutplayTouch, 'mutplayTouch'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this9.useCanvas = false;
    _this9.lastBindCodeNode = null;
    _this9.touchIds = {};
    return _this9;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }
  // onStart(){
  //     console.log('toucmove onstart')
  // }
  //停止运行


  var _proto8 = touchMove.prototype;

  _proto8.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      this.useCanvas = false;
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      console.log('停止运行了 lastBindCodeNode', this.lastBindCodeNode);

      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto8.realRun = function realRun(codeNode, isListen) {
    var _this10 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;

        if (codeNode.node != null) {// console.log('realRun lastBindCodeNode id', codeNode._id)
        } else {
          console.log('realRun lastBindCodeNode 节点已经被销毁');
        }

        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        var lastMovePos = null;
        var moveCount = 5;
        var eventId = null;
        codeNode.targetOff(this);
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          lastMovePos = null;
          eventId = event.getID();
          var eventid = event.getID();
          _this10.touchIds[eventid] = 1;
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
          if (Object.keys(_this10.touchIds).length > 1 && _this10.properties.mutplayTouch == true) {
            //多点触摸时不响应
            return;
          }

          if (eventId != event.getID()) {
            return;
          }

          if (_this10.graph.config.pause == 1) {
            return;
          }

          if (_this10.instance != null && moveCount < 5) {
            moveCount += 1;
            return;
          }

          moveCount = 0;

          if (lastMovePos == null) {
            lastMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation());
            return;
          }

          var nowMovePos = codeNode.parent.convertToNodeSpaceAR(event.getLocation()); //移动的时候检测，只在碰撞框内才出发移动

          var inTouch = true;

          if (_this10.properties.needCheckIn["default"] == 1) {
            var collider = codeNode.getComponent(cc.PolygonCollider);

            if (collider != null) {
              var inNodePos = codeNode.node.convertToNodeSpaceAR(event.getLocation());
              var inTouch = cc.Intersection.pointInPolygon(inNodePos, collider.points);
            }
          }

          var delta = nowMovePos.sub(lastMovePos);

          if (inTouch == true) {
            _this10.setOutputData(0, delta.x);

            _this10.setOutputData(1, delta.y);

            _this10.triggerSlot(2, 1);

            if (_this10.properties.controllObj == true) {
              codeNode.x += delta.x;
              codeNode.y += delta.y;
            }
          }

          lastMovePos = nowMovePos;
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          // return
          canvas = cc.director.getScene().getChildByName('Canvas');
        }

        canvas.targetOff(this);
        var lastMovePos = null;
        var moveCount = 5;
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          lastMovePos = null;
          var eventid = event.getID();
          _this10.touchIds[eventid] = 1;
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
          if (Object.keys(_this10.touchIds).length > 1 && _this10.properties.mutplayTouch == true) {
            //多点触摸时不响应
            return;
          }

          if (_this10.graph.config.pause == 1) {
            return;
          }

          if (moveCount < 5) {
            moveCount += 1;
            return;
          }

          moveCount = 0;

          if (lastMovePos == null) {
            lastMovePos = canvas.parent.convertToNodeSpaceAR(event.getLocation());
            return;
          }

          var nowMovePos = canvas.parent.convertToNodeSpaceAR(event.getLocation());
          var delta = nowMovePos.sub(lastMovePos);

          _this10.setOutputData(0, delta.x);

          _this10.setOutputData(1, delta.y);

          lastMovePos = nowMovePos;
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_END, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          var eventid = event.getID();
          delete _this10.touchIds[eventid];
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas2 = this.graph.config.rootccNode;

        if (_canvas2 == null) {
          // console.warn("没有rootccNode")
          // return
          _canvas2 = cc.director.getScene().getChildByName('Canvas');
        }

        _canvas2.targetOff(this);

        this.useCanvas = false;
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto8.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      console.log('我开始监听移动', codeNode);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto8.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchMove;
}(_litegraph.LGraphNode); // Register the node type


touchMove.title = '触摸移动'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchMove", touchMove); //第一个是唯一key，同时也是菜单选项路径


var touchEnd = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(touchEnd, _LGraphNode9);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function touchEnd() {
    var _this11;

    _this11 = _LGraphNode9.call(this) || this;
    _this11.title = "触摸结束";
    _this11.desc = "检测物体触摸开始";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //   this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了

    _this11.addInput("物体", "codeNode");

    _this11.addInput("监听", _litegraph.LiteGraph.ACTION);

    _this11.addInput("取消监听", _litegraph.LiteGraph.ACTION);

    _this11.addOutput('结束X', 'number');

    _this11.addOutput('结束Y', 'number'); //触摸开始到触摸结束时移动的距离小于10，【结束】输出为1，大于10，【结束】输出为2


    _this11.addOutput('结束', _litegraph.LiteGraph.EVENT);

    _this11.addOutput('点击结束', _litegraph.LiteGraph.EVENT); //触摸开始到触摸结束时移动的距离大于10


    _this11.addOutput('移动结束', _litegraph.LiteGraph.EVENT);

    _this11.addProperty('controllObj', false, 'boolean');

    _this11.addWidget('toggle', '控制物体位置', _this11.properties.controllObj, 'controllObj');

    _this11.addProperty('listernTouchCancel', false, 'boolean');

    _this11.addWidget('toggle', '响应触摸取消', _this11.properties.listernTouchCancel, 'listernTouchCancel'); //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    _this11.touchIds = {};
    return _this11;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // //   var A = this.getInputData(0)
  // //   this.setOutputData(0, this.properties["value"]) //发送一个参数出去
  //     this.triggerSlot(0, 1);
  // }


  var _proto9 = touchEnd.prototype;

  _proto9.onStart = function onStart() {// this.triggerSlot(0, 1);
  };

  _proto9.onStop = function onStop() {
    this.touchIds = {};

    if (this.useCanvas == true) {
      var canvas = this.graph.config.rootccNode;

      if (canvas == null) {
        // console.warn("没有rootccNode")
        // return
        canvas = cc.director.getScene().getChildByName('Canvas');
      }

      canvas.targetOff(this);
    } else {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.targetOff(this);
        this.lastBindCodeNode = null;
      }
    }
  };

  _proto9.realRun = function realRun(codeNode, isListen) {
    var _this12 = this;

    if (isListen != 0) {
      if (this.lastBindCodeNode != null) {
        this.lastBindCodeNode.node.targetOff(this);
      }

      if (codeNode != null) {
        this.useCanvas = false;
        this.lastBindCodeNode = codeNode;
        codeNode.checkAddComponent('SpinePlusComponent'); // var result = cc.js.getClassByName('SpinePlusComponent')
        // console.log('是否存在', result)

        codeNode.targetOff(this);
        var startLocation = null;
        codeNode.on(cc.Node.EventType.TOUCH_START, function (event) {
          startLocation = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());
        }, this);

        var onTouchEnd = function onTouchEnd(event) {
          // console.log('点击结束')
          if (_this12.graph.config.pause == 1) {
            return;
          }

          var location = codeNode.node.parent.convertToNodeSpaceAR(event.getLocation());

          _this12.setOutputData(0, location.x);

          _this12.setOutputData(1, location.y);

          if (_this12.properties.controllObj == true) {
            codeNode.x = location.x;
            codeNode.y = location.y;
          }

          if (startLocation && location.sub(startLocation).mag() < 10) {
            // this.triggerSlot(2, 1)
            _this12.trigger('结束');

            _this12.trigger('点击结束');
          } else {
            // this.triggerSlot(3, 1)
            _this12.trigger('结束');

            _this12.trigger('移动结束');
          }
        };

        codeNode.on(cc.Node.EventType.TOUCH_END, function (event) {
          onTouchEnd(event);
        }, this);
        codeNode.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          if (_this12.properties.listernTouchCancel == true) {
            onTouchEnd(event);
          }
        }, this);
      } else {
        this.useCanvas = true;
        var canvas = this.graph.config.rootccNode;

        if (canvas == null) {
          // console.warn("没有rootccNode")
          // return
          canvas = cc.director.getScene().getChildByName('Canvas');
        }

        canvas.targetOff(this);
        var startLocation = null;
        canvas.on(cc.Node.EventType.TOUCH_START, function (event) {
          startLocation = canvas.convertToNodeSpaceAR(event.getLocation());
        }, this);

        var onTouchEnd = function onTouchEnd(event) {
          if (_this12.graph.config.pause == 1) {
            return;
          }

          var location = canvas.convertToNodeSpaceAR(event.getLocation());

          _this12.setOutputData(0, location.x);

          _this12.setOutputData(1, location.y);

          if (location.sub(startLocation).mag() < 10) {
            _this12.trigger('结束');

            _this12.trigger('点击结束');
          } else {
            _this12.trigger('结束');

            _this12.trigger('移动结束');
          }
        };

        canvas.on(cc.Node.EventType.TOUCH_END, function (event) {
          onTouchEnd(event);
        }, this);
        canvas.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
          if (_this12.properties.listernTouchCancel == true) {
            onTouchEnd(event);
          }
        }, this);
      }
    } else {
      if (this.useCanvas == true) {
        var _canvas3 = this.graph.config.rootccNode;

        if (_canvas3 == null) {
          // console.warn("没有rootccNode")
          // return
          _canvas3 = cc.director.getScene().getChildByName('Canvas');
        }

        _canvas3.targetOff(this);
      } else {
        if (this.lastBindCodeNode != null) {
          this.lastBindCodeNode.targetOff(this);
        }
      }
    }
  };

  _proto9.onAction = function onAction(action, param) {
    if (action == '监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode);
    } else if (action == '取消监听') {
      var codeNode = this.getInputData(0);
      this.realRun(codeNode, false);
    }
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //暂不清楚用处
  ;

  _proto9.setValue = function setValue(v) {
    this.setProperty("value", v);
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return touchEnd;
}(_litegraph.LGraphNode); // Register the node type


touchEnd.title = '触摸结束'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/screen/touchEnd", touchEnd); //第一个是唯一key，同时也是菜单选项路径


var leftOrRightAct = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(leftOrRightAct, _LGraphNode10);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  function leftOrRightAct() {
    var _this13;

    _this13 = _LGraphNode10.call(this) || this; // this.mode = LiteGraph.ON_EVENT;
    // this.serialize_widgets = true
    //   this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型    //不需要触发了
    // this.addInput("监听", LiteGraph.ACTION);
    // this.addInput("取消监听", LiteGraph.ACTION);

    _this13.title = "重力感应";
    _this13.desc = "检测设备的陀螺仪";

    _this13.addOutput('x轴', 'number');

    _this13.addOutput('y轴', 'number');

    _this13.addOutput('z轴', 'number'); // this.addProperty('modal', '收到回调输出', 'enum')
    // this.addWidget('combo', '输出模式', this.properties.controllObj, 'controllObj')
    //   this.addOutput("游戏开始", LiteGraph.EVENT)   //增加一个输出触点，  输出节点的名称， 值类型
    //   this.addProperty("value", "");   //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("text","value","","value"); 
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //   this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.size = [180, 30];                                     //设置默认节点尺寸
    //   this.properties.precision = 1


    return _this13;
  } //可以新增一个模拟设备方向的输出


  var _proto10 = leftOrRightAct.prototype;

  _proto10.onChangeEvent = function onChangeEvent(event) {
    this.x = event.acc.x;
    this.y = event.acc.y;
    this.z = event.acc.z;
    this.setOutputData(0, this.x);
    this.setOutputData(1, this.y);
    this.setOutputData(2, this.z);
  } // Function to call when the node is executed
  //执行时的方法
  ;

  _proto10.onStart = function onStart() {
    // this.triggerSlot(0, 1);
    cc.systemEvent.setAccelerometerEnabled(true);
    this.curState = 0;
    this.x = 0;
    this.y = 0;
    this.z = 0;
    this.setOutputData(0, this.x);
    this.setOutputData(1, this.y);
    this.setOutputData(2, this.z);
    cc.systemEvent.on(cc.SystemEvent.EventType.DEVICEMOTION, this.onChangeEvent, this);
  };

  _proto10.onStop = function onStop() {
    cc.systemEvent.off(cc.SystemEvent.EventType.DEVICEMOTION, this.onChangeEvent, this);
  } //动态返回卡片显示的title
  // getTitle() {
  //     if (this.flags.collapsed) {
  //         return this.properties.value;
  //     }
  //     return this.title;
  // };
  //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"].toFixed(3);
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return leftOrRightAct;
}(_litegraph.LGraphNode); // Register the node type


leftOrRightAct.title = '重力感应'; //设置中文名称标题，是否需要实现多语言？

_litegraph.LiteGraph.registerNodeType("input/leftOrRightAct", leftOrRightAct); //第一个是唯一key，同时也是菜单选项路径

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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