
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/middle.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '493eeWdicRJNYQZtEIAhQxP', 'middle');
// Script/Common/LiteGraphCore/nodes/middle.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

//将viewCode中的robot创建映射到litegraph
var AddRobot = /*#__PURE__*/function (_LGraphNode) {
  _inheritsLoose(AddRobot, _LGraphNode);

  // Name to show
  function AddRobot() {
    var _this;

    _this = _LGraphNode.call(this) || this;
    _this.title = "加";

    _this.addInput("A", "number");

    _this.addInput("B", "number");

    _this.addOutput("A + B", "number"); // this.properties.precision = 1


    return _this;
  } // Function to call when the node is executed


  var _proto = AddRobot.prototype;

  _proto.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A + B); // console.log('AddRobot onExecute', A + B)
  };

  return AddRobot;
}(_litegraph.LGraphNode);

AddRobot.title = '加'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/add", AddRobot);

var delRobot = /*#__PURE__*/function (_LGraphNode2) {
  _inheritsLoose(delRobot, _LGraphNode2);

  // Name to show
  function delRobot() {
    var _this2;

    _this2 = _LGraphNode2.call(this) || this;
    _this2.title = "减";

    _this2.addInput("A", "number");

    _this2.addInput("B", "number");

    _this2.addOutput("A - B", "number"); // this.properties.precision = 1


    return _this2;
  } // Function to call when the node is executed


  var _proto2 = delRobot.prototype;

  _proto2.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A - B); // console.log('AddRobot onExecute', A - B)
  };

  return delRobot;
}(_litegraph.LGraphNode);

delRobot.title = '减'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/del", delRobot);

var xRobot = /*#__PURE__*/function (_LGraphNode3) {
  _inheritsLoose(xRobot, _LGraphNode3);

  // Name to show
  function xRobot() {
    var _this3;

    _this3 = _LGraphNode3.call(this) || this;
    _this3.title = "乘";

    _this3.addInput("A", "number");

    _this3.addInput("B", "number");

    _this3.addOutput("A x B", "number"); // this.properties.precision = 1


    return _this3;
  } // Function to call when the node is executed


  var _proto3 = xRobot.prototype;

  _proto3.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A * B); // console.log('xRobot onExecute', A * B)
  };

  return xRobot;
}(_litegraph.LGraphNode);

xRobot.title = '乘'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/x", xRobot);

var chuRobot = /*#__PURE__*/function (_LGraphNode4) {
  _inheritsLoose(chuRobot, _LGraphNode4);

  // Name to show
  function chuRobot() {
    var _this4;

    _this4 = _LGraphNode4.call(this) || this;
    _this4.title = "除";

    _this4.addInput("A", "number");

    _this4.addInput("B", "number");

    _this4.addOutput("A ÷ B", "number"); // this.properties.precision = 1


    return _this4;
  } // Function to call when the node is executed


  var _proto4 = chuRobot.prototype;

  _proto4.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    this.setOutputData(0, A / B); // console.log('chuRobot onExecute', A / B)
  };

  return chuRobot;
}(_litegraph.LGraphNode);

chuRobot.title = '除'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/chu", chuRobot);

var lengthRobot = /*#__PURE__*/function (_LGraphNode5) {
  _inheritsLoose(lengthRobot, _LGraphNode5);

  // Name to show
  function lengthRobot() {
    var _this5;

    _this5 = _LGraphNode5.call(this) || this;
    _this5.title = "向量长度";

    _this5.addInput("x", "number");

    _this5.addInput("y", "number");

    _this5.addOutput("长度", "number"); // this.properties.precision = 1


    return _this5;
  } // Function to call when the node is executed


  var _proto5 = lengthRobot.prototype;

  _proto5.onExecute = function onExecute() {
    var A = this.getInputData(0);
    if (A === undefined) A = 0;
    var B = this.getInputData(1);
    if (B === undefined) B = 0;
    var result = Math.sqrt(A * A + B * B);
    this.setOutputData(0, result); // console.log('lengthRobot onExecute', result)
  };

  return lengthRobot;
}(_litegraph.LGraphNode);

lengthRobot.title = '长度'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/calculate/length", lengthRobot); ///covert 系列的方法
// 没有任何地方用到，暂时关闭
// class mappingRobot extends LGraphNode {
//     // Name to show
//     title = "映射"
//     constructor() {
//       super()
//       this.addInput("目标数值", "number")
//       this.addInput("范围左", "number")
//       this.addInput("范围右", "number")
//       this.addOutput("结果", "number")
//       // this.properties.precision = 1
//     }
//     // Function to call when the node is executed
//     onExecute() {
//       var A = this.getInputData(0)
//       if (A === undefined) A = 0
//       var B = this.getInputData(1)
//       if (B === undefined) B = 0
//       var C = this.getInputData(2)
//       if (C === undefined) C = 0
//       var result = C - (A) % (C - B)
//       this.setOutputData(0, result)
//       // console.log('mappingRobot onExecute', result)
//     }
// }
// mappingRobot.title = '映射'
// // Register the node type
// LiteGraph.registerNodeType("middle/covert/mapping", mappingRobot)


var tointRobot = /*#__PURE__*/function (_LGraphNode6) {
  _inheritsLoose(tointRobot, _LGraphNode6);

  // Name to show
  function tointRobot() {
    var _this6;

    _this6 = _LGraphNode6.call(this) || this;
    _this6.title = "取整数";

    _this6.addInput("向下取整", "number");

    _this6.addInput("向上取整", "number");

    _this6.addInput("四舍五入", "number");

    _this6.addOutput("输出", "number"); // this.properties.precision = 1


    return _this6;
  } // Function to call when the node is executed


  var _proto6 = tointRobot.prototype;

  _proto6.onExecute = function onExecute() {
    var A = this.getInputData(0);
    var B = this.getInputData(1);
    var C = this.getInputData(2);

    if (A !== undefined) {
      this.setOutputData(0, Math.floor(A));
    } else if (B !== undefined) {
      this.setOutputData(0, Math.ceil(B));
    } else if (C !== undefined) {
      this.setOutputData(0, Math.round(C));
    } // console.log('tointRobot onExecute', A, B, C)

  };

  return tointRobot;
}(_litegraph.LGraphNode);

tointRobot.title = '取整数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/toint", tointRobot);

var squareRootRobot = /*#__PURE__*/function (_LGraphNode7) {
  _inheritsLoose(squareRootRobot, _LGraphNode7);

  // Name to show
  function squareRootRobot() {
    var _this7;

    _this7 = _LGraphNode7.call(this) || this;
    _this7.title = "平方根";

    _this7.addInput("输入", "number");

    _this7.addOutput("开平方", "number"); // this.properties.precision = 1


    return _this7;
  } // Function to call when the node is executed


  var _proto7 = squareRootRobot.prototype;

  _proto7.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, Math.sqrt(A)); // console.log('squareRootRobot onExecute', Math.sqrt(A))
    }
  };

  return squareRootRobot;
}(_litegraph.LGraphNode);

squareRootRobot.title = '平方根'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/squareRoot", squareRootRobot);

var absRobot = /*#__PURE__*/function (_LGraphNode8) {
  _inheritsLoose(absRobot, _LGraphNode8);

  // Name to show
  function absRobot() {
    var _this8;

    _this8 = _LGraphNode8.call(this) || this;
    _this8.title = "绝对值";

    _this8.addInput("输入", "number");

    _this8.addOutput("绝对值", "number"); // this.properties.precision = 1


    return _this8;
  } // Function to call when the node is executed


  var _proto8 = absRobot.prototype;

  _proto8.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, Math.abs(A)); // console.log('absRobot onExecute', Math.abs(A))
    }
  };

  return absRobot;
}(_litegraph.LGraphNode);

absRobot.title = '绝对值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/abs", absRobot);

var revertNegativeRobot = /*#__PURE__*/function (_LGraphNode9) {
  _inheritsLoose(revertNegativeRobot, _LGraphNode9);

  // Name to show
  function revertNegativeRobot() {
    var _this9;

    _this9 = _LGraphNode9.call(this) || this;
    _this9.title = "正负反转";

    _this9.addInput("输入", "number");

    _this9.addOutput("输出", "number"); // this.properties.precision = 1


    return _this9;
  } // Function to call when the node is executed


  var _proto9 = revertNegativeRobot.prototype;

  _proto9.onExecute = function onExecute() {
    var A = this.getInputData(0);

    if (A !== undefined) {
      this.setOutputData(0, A * -1); // console.log('revertNegativeRobot onExecute', A * -1)
    }
  };

  return revertNegativeRobot;
}(_litegraph.LGraphNode);

revertNegativeRobot.title = '正负反转'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/covert/revertNegative", revertNegativeRobot); ///angleCalculate


var angleDifferenceRobot = /*#__PURE__*/function (_LGraphNode10) {
  _inheritsLoose(angleDifferenceRobot, _LGraphNode10);

  // Name to show
  function angleDifferenceRobot() {
    var _this10;

    _this10 = _LGraphNode10.call(this) || this;
    _this10.title = "角度差";

    _this10.addInput("角度A", "number");

    _this10.addInput("角度B", "number");

    _this10.addOutput("输出", "number");

    _this10.addProperty("inputType", '角度', 'enum', {
      values: ['角度', '向量']
    }); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this10.addWidget("combo", "输入的类型", _this10.properties.inputType, {
      property: "inputType",
      values: ['角度', '向量']
    }); // this.properties.precision = 1


    return _this10;
  } // Function to call when the node is executed


  var _proto10 = angleDifferenceRobot.prototype;

  _proto10.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var result = 0;

      if (this.properties.inputType == 0 || this.properties.inputType == '角度') {
        var number = Math.max(number1, number2) - Math.min(number1, number2);
        result = Math.min(360 - number, number);
      } else {
        //输入向量求夹角
        var x1 = number1.x;
        var y1 = number1.y;
        var x2 = number2.x;
        var y2 = number2.y; // 与v1起始向量方向相反
        // const _v1 = {x: -x1, y: -y1}

        var cosRadian = (Math.pow(x1, 2) + Math.pow(y1, 2) + Math.pow(x2, 2) + Math.pow(y2, 2) - (Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2))) / (2 * Math.sqrt(Math.pow(x1, 2) + Math.pow(y1, 2)) * Math.sqrt(Math.pow(x2, 2) + Math.pow(y2, 2)));
        result = Math.acos(cosRadian) * (180 / Math.PI);
      }

      this.setOutputData(0, result); // console.log('angleDifferenceRobot onExecute', result)
    }
  };

  return angleDifferenceRobot;
}(_litegraph.LGraphNode);

angleDifferenceRobot.title = '角度差'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/angleDifference", angleDifferenceRobot);

var vectorToAngelRobot = /*#__PURE__*/function (_LGraphNode11) {
  _inheritsLoose(vectorToAngelRobot, _LGraphNode11);

  // Name to show
  function vectorToAngelRobot() {
    var _this11;

    _this11 = _LGraphNode11.call(this) || this;
    _this11.title = "将位置转换为角度";

    _this11.addInput("x坐标", "number");

    _this11.addInput("y坐标", "number");

    _this11.addOutput("角度", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this11;
  } // Function to call when the node is executed


  var _proto11 = vectorToAngelRobot.prototype;

  _proto11.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var result = Math.atan2(this.number2, this.number1) * (180 / Math.PI);
      this.setOutputData(0, result); // console.log('vectorToAngelRobot onExecute', result)
    }
  };

  return vectorToAngelRobot;
}(_litegraph.LGraphNode);

vectorToAngelRobot.title = '将位置转换为角度'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/vectorToAngel", vectorToAngelRobot);

var angleConvertVectorRobot = /*#__PURE__*/function (_LGraphNode12) {
  _inheritsLoose(angleConvertVectorRobot, _LGraphNode12);

  // Name to show
  function angleConvertVectorRobot() {
    var _this12;

    _this12 = _LGraphNode12.call(this) || this;
    _this12.title = "将角度转换为位置";

    _this12.addInput("角度", "number");

    _this12.addInput("斜边长", "number");

    _this12.addOutput("x长", "number");

    _this12.addOutput("y长", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this12;
  } // Function to call when the node is executed


  var _proto12 = angleConvertVectorRobot.prototype;

  _proto12.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);

    if (number1 !== undefined && number2 !== undefined) {
      var angle = 180 / Math.PI * number1;
      var x = Math.cos(angle) * number2;
      var y = Math.sin(angle) * number2;
      this.setOutputData(0, x);
      this.setOutputData(1, y); // console.log('angleConvertVectorRobot onExecute', x, y)
    }
  };

  return angleConvertVectorRobot;
}(_litegraph.LGraphNode);

angleConvertVectorRobot.title = '将角度转换为位置'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/angleCalculate/angleConvertVector", angleConvertVectorRobot); ///compare


var equireRobot = /*#__PURE__*/function (_LGraphNode13) {
  _inheritsLoose(equireRobot, _LGraphNode13);

  // Name to show
  function equireRobot() {
    var _this13;

    _this13 = _LGraphNode13.call(this) || this;
    _this13.title = "等于";

    _this13.addInput("A", "number");

    _this13.addInput("B", "number");

    _this13.addOutput("A == B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this13;
  } // Function to call when the node is executed


  var _proto13 = equireRobot.prototype;

  _proto13.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 == number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('equireRobot onExecute', result)
  };

  return equireRobot;
}(_litegraph.LGraphNode);

equireRobot.title = '等于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/equire", equireRobot);

var litterRobot = /*#__PURE__*/function (_LGraphNode14) {
  _inheritsLoose(litterRobot, _LGraphNode14);

  // Name to show
  function litterRobot() {
    var _this14;

    _this14 = _LGraphNode14.call(this) || this;
    _this14.title = "小于";

    _this14.addInput("A", "number");

    _this14.addInput("B", "number");

    _this14.addOutput("A < B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this14;
  } // Function to call when the node is executed


  var _proto14 = litterRobot.prototype;

  _proto14.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 < number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('litterRobot onExecute', result)
  };

  return litterRobot;
}(_litegraph.LGraphNode);

litterRobot.title = '小于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/litter", litterRobot);

var biggerRobot = /*#__PURE__*/function (_LGraphNode15) {
  _inheritsLoose(biggerRobot, _LGraphNode15);

  // Name to show
  function biggerRobot() {
    var _this15;

    _this15 = _LGraphNode15.call(this) || this;
    _this15.title = "大于";

    _this15.addInput("A", "number");

    _this15.addInput("B", "number");

    _this15.addOutput("A > B?", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this15;
  } // Function to call when the node is executed


  var _proto15 = biggerRobot.prototype;

  _proto15.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 > number2) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('biggerRobot onExecute', result)
  };

  return biggerRobot;
}(_litegraph.LGraphNode);

biggerRobot.title = '大于'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/bigger", biggerRobot);

var inRangeRobot = /*#__PURE__*/function (_LGraphNode16) {
  _inheritsLoose(inRangeRobot, _LGraphNode16);

  // Name to show
  function inRangeRobot() {
    var _this16;

    _this16 = _LGraphNode16.call(this) || this;
    _this16.title = "范围内";

    _this16.addInput("A", "number");

    _this16.addInput("B", "number");

    _this16.addInput("C", "number");

    _this16.addOutput("结果", "number");

    _this16.addProperty("A", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("C", 10, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("firstCompire", '<', 'enum', {
      values: ['<', '<=']
    }); //增加一个变量，    变量名称， 变量名称


    _this16.addProperty("secCompire", '<', 'enum', {
      values: ['<', '<=']
    });

    _this16.addWidget("number", '最小值A', 0, 'A', {
      precision: 0
    }); // this.addWidget("number", '比较值', 5, 'B')


    _this16.addWidget("number", '最大值C', 10, 'C', {
      precision: 0
    }); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this16.addWidget("combo", "A和B比较", _this16.properties.firstCompire, {
      property: "firstCompire",
      values: inRangeRobot.compireType
    });

    _this16.addWidget("combo", "B和C比较", _this16.properties.secCompire, {
      property: "secCompire",
      values: inRangeRobot.compireType
    }); // this.serialize_widgets = true;
    // this.properties.precision = 1


    return _this16;
  }

  var _proto16 = inRangeRobot.prototype;

  _proto16.getTitle = function getTitle() {
    var firstCompire = this.properties['firstCompire'];
    var secCompire = this.properties['secCompire'];
    return 'A' + firstCompire + 'B' + secCompire + 'C';
  } // Function to call when the node is executed
  ;

  _proto16.onExecute = function onExecute() {
    var number1 = this.getInputOrProperty('A');
    var number2 = this.getInputData(1);
    var number3 = this.getInputOrProperty('C');
    var result = 0;
    var firstCompire = this.properties['firstCompire'];
    var secCompire = this.properties['secCompire'];

    if (firstCompire == '<') {
      result = number1 < number2;
    }

    if (firstCompire == '<=') {
      result = number1 <= number2;
    }

    if (secCompire == '<') {
      result = number2 < number3;
    }

    if (secCompire == '<=') {
      result = number2 <= number3;
    }

    if (result == true) {
      result = 1;
    }

    this.setOutputData(0, result); // console.log('inRangeRobot onExecute', result)
  };

  return inRangeRobot;
}(_litegraph.LGraphNode);

inRangeRobot.title = '范围内';
inRangeRobot.compireType = ['<', '<=']; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/compare/inRange", inRangeRobot); //和上面的功能重复，暂时屏蔽
// class inRangeEquireRobot extends LGraphNode {
//     // Name to show
//     title = "闭区间范围内"
//     constructor() {
//       super()
//       this.addInput("A", "number")
//       this.addInput("B", "number")
//       this.addInput("C", "number")
//       this.addOutput("A <= B <= C?", "number")
//       this.addProperty("A和B对比", '<', 'enum', {values: ['<', '<=']});   //增加一个变量，    变量名称， 变量名称
//       this.addProperty("B和C对比", '<', 'enum', {values: ['<', '<=']});   //增加一个变量，    变量名称， 变量名称
//     //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
//     // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
// 		//   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
//       // this.properties.precision = 1
//     }
//     // Function to call when the node is executed
//     onExecute() {
//       var number1 = this.getInputData(0)
//       var number2 = this.getInputData(1)
//       var number3 = this.getInputData(2)
//       var result = 0
//       if(number2 >= number1 && number2 <= number3){
//         result = 1
//       }
//       this.setOutputData(0, result)
//       // console.log('inRangeEquireRobot onExecute', result)
//     }
// }
// inRangeEquireRobot.title = '闭区间范围内'
// // Register the node type
// LiteGraph.registerNodeType("middle/compare/inRangeEquire", inRangeEquireRobot)
//logic


var allRightRobot = /*#__PURE__*/function (_LGraphNode17) {
  _inheritsLoose(allRightRobot, _LGraphNode17);

  // Name to show
  function allRightRobot() {
    var _this17;

    _this17 = _LGraphNode17.call(this) || this;
    _this17.title = "全部正确";

    _this17.addInput("A", "number");

    _this17.addInput("B", "number");

    _this17.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this17;
  } // Function to call when the node is executed


  var _proto17 = allRightRobot.prototype;

  _proto17.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var result = 0;

    if (number1 == 0 || number1 === undefined) {
      result = 0;
    }

    if (number2 == 0 || number2 === undefined) {
      result = 0;
    }

    this.setOutputData(0, result); // console.log('allRightRobot onExecute', result)
  };

  return allRightRobot;
}(_litegraph.LGraphNode);

allRightRobot.title = '全部正确'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/allRight", allRightRobot);

var orRightRobot = /*#__PURE__*/function (_LGraphNode18) {
  _inheritsLoose(orRightRobot, _LGraphNode18);

  // Name to show
  function orRightRobot() {
    var _this18;

    _this18 = _LGraphNode18.call(this) || this;
    _this18.title = "任意一个正确";

    _this18.addInput("A", "number");

    _this18.addInput("B", "number");

    _this18.addInput("C", "number");

    _this18.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this18;
  } // Function to call when the node is executed


  var _proto18 = orRightRobot.prototype;

  _proto18.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var number2 = this.getInputData(1);
    var number3 = this.getInputData(2);
    var result = 0;

    if (number1 !== undefined) {
      if (number1 != 0) {
        result = 1;
      }
    }

    if (number2 !== undefined) {
      if (number2 != 0) {
        result = 1;
      }
    }

    if (number3 !== undefined) {
      if (number3 != 0) {
        result = 1;
      }
    }

    this.setOutputData(0, result); // console.log('orRightRobot onExecute', result)
  };

  return orRightRobot;
}(_litegraph.LGraphNode);

orRightRobot.title = '任意一个正确'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/orRight", orRightRobot);

var allToggle = /*#__PURE__*/function (_LGraphNode19) {
  _inheritsLoose(allToggle, _LGraphNode19);

  // Name to show
  function allToggle() {
    var _this19;

    _this19 = _LGraphNode19.call(this) || this;
    _this19.title = "全部触发";
    _this19.mode = _litegraph.LiteGraph.ON_EVENT;

    _this19.addInput("触发_0", _litegraph.LiteGraph.ACTION);

    _this19.addInput("触发_1", _litegraph.LiteGraph.ACTION);

    _this19.addOutput("触发", _litegraph.LiteGraph.EVENT);

    _this19.addProperty('resetWhenToggle', false, 'boolean');

    _this19.addWidget('toggle', '触发后重置', _this19.properties.resetWhenToggle, 'resetWhenToggle'); // this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    _this19.toggleFlag = {};
    return _this19;
  }

  var _proto19 = allToggle.prototype;

  _proto19.onStop = function onStop() {
    this.toggleFlag = {};
  };

  _proto19.onGetInputs = function onGetInputs() {
    return [["触发_" + this.inputs.length, _litegraph.LiteGraph.ACTION]];
  };

  _proto19.onAction = function onAction(action, param, options) {
    // console.log('allToggle', action, param, options)
    this.toggleFlag[action] = 1;

    if (Object.keys(this.toggleFlag).length == this.inputs.length) {
      this.triggerSlot(0);

      if (this.properties.resetWhenToggle == true) {
        this.toggleFlag = {};
      }
    }
  } // Function to call when the node is executed
  // onExecute() {
  //   var number1 = this.getInputData(0)
  //   var number2 = this.getInputData(1)
  //   var result = 0
  //   if(number1 == 0 || number1 === undefined){
  //       result = 0
  //   }
  //   if(number2 == 0 || number2 === undefined){
  //       result = 0
  //   }
  //   this.setOutputData(0, result)
  //   // console.log('allToggle onExecute', result)
  // }
  ;

  return allToggle;
}(_litegraph.LGraphNode);

allToggle.title = '全部触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/allToggle", allToggle);

var orToggle = /*#__PURE__*/function (_LGraphNode20) {
  _inheritsLoose(orToggle, _LGraphNode20);

  // Name to show
  function orToggle() {
    var _this20;

    _this20 = _LGraphNode20.call(this) || this;
    _this20.title = "任意触发";
    _this20.mode = _litegraph.LiteGraph.ON_EVENT;

    _this20.addInput("触发_0", _litegraph.LiteGraph.ACTION);

    _this20.addInput("触发_1", _litegraph.LiteGraph.ACTION);

    _this20.addOutput("触发", _litegraph.LiteGraph.EVENT); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1
    // this.findInputSlotFree({typesNotAccepted: []})
    // this.findInputByType(LiteGraph.ACTION)
    // this.getInputNode()
    // this.getInputNode()
    // this.findSlotByType(true, LiteGraph.ACTION, false, true, true)
    // let oldLink = this.getInputLink(0)
    // oldLink.origin_slot


    return _this20;
  }

  var _proto20 = orToggle.prototype;

  _proto20.getFreeSoltIndex = function getFreeSoltIndex() {
    var soltIndex = this.findSlotByType(true, _litegraph.LiteGraph.ACTION, false, true, true);

    if (soltIndex == -1) {
      this.addInput('触发_' + this.inputs.length, _litegraph.LiteGraph.ACTION);
      soltIndex = this.inputs.length - 1;
    }

    return soltIndex;
  } //检查一个节点是否已经连接我的node了
  ;

  _proto20.checkHasConnectMyInput = function checkHasConnectMyInput(node) {
    var hasConnect = false;

    for (var i = 0; i < this.inputs.length; i++) {
      var connectNode = this.getInputNode(i);

      if (connectNode != null) {
        if (connectNode.id == node.id) {
          hasConnect = true;
          break;
        }
      }
    }

    return hasConnect;
  };

  _proto20.findConnectSoltIndex = function findConnectSoltIndex(nodeId) {
    var index = -1;

    for (var i = 0; i < this.inputs.length; i++) {
      var connectNode = this.getInputNode(i);

      if (connectNode != null) {
        if (connectNode.id == nodeId) {
          index = i;
          break;
        }
      }
    }

    return index;
  } // onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex){
  //     // console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
  // }
  ;

  _proto20.onGetInputs = function onGetInputs() {
    return [["触发_" + this.inputs.length, _litegraph.LiteGraph.ACTION]];
  };

  _proto20.onAction = function onAction(action, param, options) {
    // console.log('allToggle', action, param, options)
    this.triggerSlot(0);
  };

  return orToggle;
}(_litegraph.LGraphNode);

orToggle.title = '任意触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/orToggle", orToggle);

var notRightRobot = /*#__PURE__*/function (_LGraphNode21) {
  _inheritsLoose(notRightRobot, _LGraphNode21);

  // Name to show
  function notRightRobot() {
    var _this21;

    _this21 = _LGraphNode21.call(this) || this;
    _this21.title = "反转结果";

    _this21.addInput("A", "number");

    _this21.addOutput("结果", "number"); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this21;
  } // Function to call when the node is executed


  var _proto21 = notRightRobot.prototype;

  _proto21.onExecute = function onExecute() {
    var number1 = this.getInputData(0);
    var result = !number1 ? 1 : 0;
    this.setOutputData(0, result); // console.log('notRightRobot onExecute', result)
  };

  return notRightRobot;
}(_litegraph.LGraphNode);

notRightRobot.title = '反转结果'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/logic/notRight", notRightRobot); // change randomNum


var randomNumRobot = /*#__PURE__*/function (_LGraphNode22) {
  _inheritsLoose(randomNumRobot, _LGraphNode22);

  // Name to show
  function randomNumRobot() {
    var _this22;

    _this22 = _LGraphNode22.call(this) || this;
    _this22.title = "随机整数";
    _this22.des = '如果没有输入值，返回一个大于0的随机整数';

    _this22.addInput("随机范围", "number");

    _this22.addOutput("结果", "number");

    _this22.addProperty("modal", '每次随机', 'enum', {
      values: ['仅一次', '每次随机']
    }); //增加一个变量，    变量名称， 变量名称
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置


    _this22.addWidget("combo", "", _this22.properties.modal, {
      property: "modal",
      values: ['仅一次', '每次随机']
    }); // this.serialize_widgets = true;
    //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this22;
  } // Function to call when the node is executed


  var _proto22 = randomNumRobot.prototype;

  _proto22.onExecute = function onExecute() {
    var number1 = this.getInputData(0);

    if (number1 === undefined) {
      number1 = 10000000;
    }

    if (this.properties.modal == '每次随机') {
      var random = Math.floor(Math.random() * number1); // [0,输入值-1]

      this.setOutputData(0, random);
    } else {
      if (this.random == null) {
        this.random = Math.floor(Math.random() * number1);
        this.setOutputData(0, this.random);
      }
    } // console.log('randomNumRobot onExecute', random)

  };

  return randomNumRobot;
}(_litegraph.LGraphNode);

randomNumRobot.title = '随机整数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/randomNum", randomNumRobot);

var timeDownRobot = /*#__PURE__*/function (_LGraphNode23) {
  _inheritsLoose(timeDownRobot, _LGraphNode23);

  // Name to show
  function timeDownRobot() {
    var _this23;

    _this23 = _LGraphNode23.call(this) || this;
    _this23.title = "延迟触发";
    _this23.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";

    _this23.addProperty("time_in_s", 1);

    _this23.widget = _this23.addWidget("number", "秒", 1, "time_in_s", {
      precision: 2,
      min: 0,
      step: 0.1
    }); // this.serialize_widgets = true;

    _this23.addInput("开始", _litegraph.LiteGraph.ACTION);

    _this23.addOutput("结束时", _litegraph.LiteGraph.EVENT);

    _this23._pending = []; //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1

    return _this23;
  } // Function to call when the node is executed


  var _proto23 = timeDownRobot.prototype;

  _proto23.onAction = function onAction(action, param, options) {
    var time = this.properties.time_in_s;

    if (time <= 0) {
      // this.trigger(null, param, options);
      this.triggerSlot(0);
    } else {
      this._pending.push([time, param]);
    }
  };

  _proto23.onExecute = function onExecute() {
    var dt = this.graph.elapsed_time; //in ms

    if (this.isInputConnected(1)) {
      this.properties.time_in_s = this.getInputData(1);
    }

    for (var i = 0; i < this._pending.length; ++i) {
      var actionPass = this._pending[i];
      actionPass[0] -= dt;

      if (actionPass[0] > 0) {
        continue;
      } //remove


      this._pending.splice(i, 1);

      --i; //trigger
      // this.trigger(null, actionPass[1], options);

      this.triggerSlot(0);
    }
  };

  _proto23.onGetInputs = function onGetInputs() {
    return [["time_in_s", "number"]];
  };

  _proto23.onStop = function onStop() {
    //清空等待延迟触发的列队
    this._pending = [];
  };

  return timeDownRobot;
}(_litegraph.LGraphNode);

timeDownRobot.title = '延迟触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/timeDown", timeDownRobot);

var timerRobot = /*#__PURE__*/function (_LGraphNode24) {
  _inheritsLoose(timerRobot, _LGraphNode24);

  // Name to show
  function timerRobot() {
    var _this24;

    _this24 = _LGraphNode24.call(this) || this;
    _this24.title = "间隔触发";
    _this24.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";

    _this24.addProperty("interval", 1000);

    _this24.addProperty("event", "tick");

    _this24.widget = _this24.addWidget("number", "毫秒", 1000, "interval", {
      precision: 0
    }); // this.serialize_widgets = true;

    _this24.addOutput("触发", _litegraph.LiteGraph.EVENT);

    _this24.time = 0;
    _this24.last_interval = 1000;
    _this24.triggered = false; //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1

    return _this24;
  }

  var _proto24 = timerRobot.prototype;

  _proto24.getTitle = function getTitle() {
    if (this.graph.state == _litegraph.LGraph.STATUS_RUNNING) {
      return "每隔" + this.last_interval.toString() + "ms";
    } else {
      return timerRobot.title;
    }
  };

  //node也是有开始事件的
  _proto24.onStart = function onStart() {
    this.time = 0;
  };

  // Function to call when the node is executed
  _proto24.onAction = function onAction(action, param, options) {
    var time = this.properties.interval;

    if (time <= 0) {
      this.trigger(null, param, options);
    } else {
      this._pending.push([time, param]);
    }
  };

  _proto24.onExecute = function onExecute() {
    var dt = this.graph.elapsed_time * 1000; //in ms

    var trigger = this.time == 0;
    this.time += dt;
    this.last_interval = Math.max(1, this.getInputOrProperty("interval") | 0);

    if (!trigger && (this.time < this.last_interval || isNaN(this.last_interval))) {
      if (this.inputs && this.inputs.length > 1 && this.inputs[1]) {
        this.setOutputData(1, false);
      }

      return;
    }

    this.triggered = true;
    this.time = this.time % this.last_interval; // this.trigger("on_tick", this.properties.event);

    this.triggerSlot(0, this.properties.event);

    if (this.inputs && this.inputs.length > 1 && this.inputs[1]) {
      this.setOutputData(1, true);
    }
  };

  _proto24.onDrawBackground = function onDrawBackground() {
    this.boxcolor = this.triggered ? timerRobot.on_color : timerRobot.off_color;
    this.triggered = false;
  };

  _proto24.onGetInputs = function onGetInputs() {
    return [["interval", "number"]];
  };

  return timerRobot;
}(_litegraph.LGraphNode);

timerRobot.on_color = "#AAA";
timerRobot.off_color = "#222";
timerRobot.title = '间隔触发'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/timeDownCycle", timerRobot);

var upCountRobot = /*#__PURE__*/function (_LGraphNode25) {
  _inheritsLoose(upCountRobot, _LGraphNode25);

  // Name to show
  function upCountRobot() {
    var _this25;

    _this25 = _LGraphNode25.call(this) || this; // this.serialize_widgets = true;

    _this25.title = "计数";
    _this25.desc = "等待时间如果为0的话表示等待1帧。输入的值不为0时即执行倒计时，输入值为0时停止倒计时，输出的值为当前输出帧和上一帧的时间差";
    _this25.mode = _litegraph.LiteGraph.ON_EVENT;

    _this25.addInput("开始值", 'number');

    _this25.addInput("增加", _litegraph.LiteGraph.ACTION);

    _this25.addInput("减少", _litegraph.LiteGraph.ACTION);

    _this25.addInput("重置", _litegraph.LiteGraph.ACTION);

    _this25.addOutput("数值", 'number');

    _this25.addOutput("变化", _litegraph.LiteGraph.EVENT);

    _this25.addProperty("开始值", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("number", "开始值", 0, "开始值", {
      precision: 0
    });

    _this25.addProperty("modal", '无限制', 'enum', {
      values: ['无限制', '范围限制', '循环', '来回']
    }); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("combo", "模式", _this25.properties.modal, {
      property: "modal",
      values: ['无限制', '范围限制', '循环', '来回']
    });

    _this25.addProperty("min", 1, 'number');

    _this25.addWidget("number", "最小值", 1, "min", {
      precision: 0
    });

    _this25.addProperty("max", 10, 'number');

    _this25.addWidget("number", "最大值", 10, "max", {
      precision: 0
    });

    _this25.addProperty("upStepmodal", '不乘以时间', 'enum', {
      values: ['乘以时间', '不乘以时间']
    }); //增加一个变量，    变量名称， 变量名称


    _this25.addWidget("combo", "步进模式", _this25.properties.upStepmodal, {
      property: "upStepmodal",
      values: ['乘以时间', '不乘以时间']
    });

    _this25.addProperty("stepValue", 1, 'number');

    _this25.addWidget("number", "步进数值", 1, "stepValue", {
      precision: 0
    });

    _this25.updateWidght(); // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    return _this25;
  }

  var _proto25 = upCountRobot.prototype;

  _proto25.onStart = function onStart() {
    this.repetDir = 1;
    this.value = this.getInputOrProperty("开始值") | 0;
  };

  _proto25.updateWidght = function updateWidght() {
    var value = this.properties.modal;

    if (value != '无限制') {
      this.widgets.map(function (widget) {
        if (widget.name == '最大值' || widget.name == '最小值') {
          widget.disabled = false;
        }
      });
    } else {
      this.widgets.map(function (widget) {
        if (widget.name == '最大值' || widget.name == '最小值') {
          widget.disabled = true;
        }
      });
    }
  };

  _proto25.onWidgetChanged = function onWidgetChanged(name, value, old_value, widget) {
    // console.log('onWidgetChanged', node, name, value, old_value)
    // this.isWidgetVisible
    if (name == '模式') {
      this.updateWidght();
    }
  } // Function to call when the node is executed
  ;

  _proto25.onAction = function onAction(action, param, options) {
    var startValue = this.getInputOrProperty("开始值") || 0;

    if (this.value == null) {
      this.value = startValue;
    } // var stepValue = this.properties.stepValue
    // console.log('action', action, param)  


    if (action == "增加") {
      this.upCount(1);
    } else if (action == '减少') {
      this.upCount(-1);
    } else if (action == '重置') {
      this.value = startValue;
      this.setOutputData(0, this.value);
    }
  };

  _proto25.upCount = function upCount(baseDir) {
    var stepValue = this.properties.stepValue;
    var min = this.properties.min;
    var max = this.properties.max; // var dt = this.graph.elapsed_time * 1000; //in ms

    var time = this.properties.upStepmodal == '不乘以时间' ? 1 : this.graph.elapsed_time * 1000; //in ms

    var modal = this.properties.modal; // console.log('增加的值', this.repetDir * time * stepValue * baseDir)
    // console.log('增加前的值', this.value)

    this.value += this.repetDir * time * stepValue * baseDir; // console.log('增加后的值', this.value, modal, max, min)
    // ['无限制', '范围限制', '循环', '来回']

    if (modal == '范围限制') {
      if (this.value > max) {
        this.value = max;
      }
    } else if (modal == '循环') {
      if (this.value > max) {
        this.value = min;
      }
    } else if (modal == '来回') {
      if (this.number >= max) {
        this.repetDir = -1;
      } else if (this.number <= min) {
        this.repetDir = 1;
      }
    } // console.log('当前技数值', this.value)


    this.setOutputData(0, this.value);
    this.triggerSlot(1);
  };

  _proto25.onExecute = function onExecute() {
    this.upCount(1);
  };

  return upCountRobot;
}(_litegraph.LGraphNode);

upCountRobot.title = '计数'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/upCount", upCountRobot);

var checkTagRobot = /*#__PURE__*/function (_LGraphNode26) {
  _inheritsLoose(checkTagRobot, _LGraphNode26);

  // Name to show
  function checkTagRobot() {
    var _this26;

    _this26 = _LGraphNode26.call(this) || this;
    _this26.title = "标记状态";
    _this26.des = '用于标记一个执行中的状态';

    _this26.addInput("值", 'number');

    _this26.addInput("修改", _litegraph.LiteGraph.ACTION);

    _this26.addOutput("输出", "number");

    _this26.addProperty("customeName", "", 'string');

    _this26.addWidget('text', '状态名称', "", 'customeName');

    _this26.addProperty("customeValue", "", 'string');

    _this26.addWidget('text', '初始值', "", 'customeValue');

    _this26.addProperty("container", checkTagRobot.GRAPH, 'enum', {
      values: checkTagRobot.containerEnum
    }); //增加一个变量，    变量名称， 变量名称


    _this26.addWidget("combo", "状态权限", _this26.properties.container, {
      property: "container",
      values: checkTagRobot.containerEnum
    });

    _this26.addProperty("modal", '自定义', 'enum', {
      values: checkTagRobot.modalEnum
    }); //增加一个变量，    变量名称， 变量名称


    _this26.addWidget("combo", "", _this26.properties.modal, {
      property: "modal",
      values: checkTagRobot.modalEnum
    });

    _this26.addProperty('initWithValue', false, 'boolean');

    _this26.addWidget('toggle', '初始化时将自定义状态值赋值', _this26.properties.initWithValue, 'initWithValue'); //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.serialize_widgets = true;


    _this26.updateWidght(); //   this.addProperty("inputType", '角度', 'enum', {values: ['角度', '向量']});   //增加一个变量，    变量名称， 变量名称
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    //   this.addWidget("combo","输入的类型",this.properties.inputType,{ property: "inputType", values:['角度', '向量'] } );
    // this.properties.precision = 1


    return _this26;
  }

  var _proto26 = checkTagRobot.prototype;

  _proto26.updateWidght = function updateWidght() {
    var value = this.properties.modal;

    if (value == '自定义') {
      this.widgets.map(function (widget) {
        if (widget.name == '状态名称') {
          widget.disabled = false;
        }
      });
    } else {
      this.widgets.map(function (widget) {
        if (widget.name == '状态名称') {
          widget.disabled = true;
        }
      });
    }
  };

  _proto26.onWidgetChanged = function onWidgetChanged(name, value, old_value, widget) {
    console.log('onWidgetChanged', name, value, old_value); // this.isWidgetVisible

    if (name == '') {
      this.updateWidght();
    }
  } //获取存放变量的位置，
  ;

  _proto26.getContainer = function getContainer() {
    switch (this.properties.container) {
      case checkTagRobot.GRAPH:
        if (this.graph) return this.graph.vars;
        return {};
        break;

      case checkTagRobot.GLOBALSCOPE:
        return window;
        break;

      case checkTagRobot.LITEGRAPH:
      default:
        return _litegraph.LiteGraph.Globals;
        break;
    }
  };

  _proto26.getVarName = function getVarName() {
    if (this.properties.modal != '自定义') {
      return this.properties.modal;
    } else {
      return this.properties.customeName;
    }
  };

  _proto26.getTitle = function getTitle() {
    return this.getVarName();
  };

  _proto26.onStart = function onStart() {
    var container = this.getContainer();
    var varName = this.getVarName();

    if (this.properties.customeValue != '') {
      //如果设置了初始值，就会在启动的时候设置初始化值
      this.value = this.properties.customeValue;
      container[varName] = this.value;
      this.setOutputData(0, this.value);
    }
  };

  _proto26.onAction = function onAction(action, param, options) {
    if (action == '修改') {
      var container = this.getContainer();
      var varName = this.getVarName(); //将状态修改为输入值，如果没有连接输入值，将状态修改为初始值(即使初始值为空)

      if (this.isInputConnected(0)) {
        this.value = this.getInputData(0);
      } else {
        this.value = this.properties.customeValue;
      }

      container[varName] = this.value;
      this.setOutputData(0, this.value);
    }
  } // Function to call when the node is executed
  ;

  _proto26.onExecute = function onExecute() {
    var container = this.getContainer();
    var varName = this.getVarName(); //只有Action会修改值。普通执行仅仅返回值
    // if(this.isInputConnected(0))
    // {
    //   this.value = this.getInputData(0);
    //   container[varName] = this.value;
    //   this.setOutputData(0, this.value );
    //   return;
    // }

    this.setOutputData(0, container[varName]);
  };

  return checkTagRobot;
}(_litegraph.LGraphNode);

checkTagRobot.modalEnum = ['自定义', '动画是否播放中', '是否不可交互', '游戏是否开始', '游戏是否结束', '引导是否显示', '当前执行逻辑', '逻辑A是否触发', '逻辑B是否触发', '逻辑C是否触发', '逻辑D是否触发'];
checkTagRobot.LITEGRAPH = '所有分镜'; //between all graphs

checkTagRobot.GRAPH = '仅当前分镜'; //only inside this graph

checkTagRobot.GLOBALSCOPE = 'Window'; //attached to Window

checkTagRobot.containerEnum = [checkTagRobot.GRAPH, checkTagRobot.LITEGRAPH, checkTagRobot.GLOBALSCOPE];
checkTagRobot.title = '标记状态'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/checkTag", checkTagRobot);

var dataObjectRobot = /*#__PURE__*/function (_LGraphNode27) {
  _inheritsLoose(dataObjectRobot, _LGraphNode27);

  // Name to show
  function dataObjectRobot() {
    var _this27;

    _this27 = _LGraphNode27.call(this) || this; // this.serialize_widgets = true;
    // this.serialize_widgets = true;

    _this27.title = "数据结构";
    _this27.desc = "输出对象的key和values，如果挂载的是对象，循环对象中每个key，如果是数组，循环数组每个i，每每次循环都会触发toggle事件";

    _this27.addInput("挂载", 'object'); // this.addInput("触发",  LiteGraph.ACTION)
    // this.addInput("减少",  LiteGraph.ACTION)
    // this.addInput("重置",  LiteGraph.ACTION)


    _this27.addOutput("key", 0); // this.addOutput("index", 'number') 


    _this27.addOutput("value", 0);

    _this27.addOutput("触发", _litegraph.LiteGraph.EVENT); // this.addProperty("开始值", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","开始值", 0, "开始值", {precision: 0});
    // this.addProperty("modal", '无限制', 'enum', {values: ['无限制', '范围限制', '循环', '来回']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","模式",this.properties.modal,{ property: "modal", values:['无限制', '范围限制', '循环', '来回'] } );
    // this.addProperty("min", 1,  'number')
    // this.addWidget("number","最小值", 1, "min", {precision: 0});
    // this.addProperty("max", 10,  'number')
    // this.addWidget("number","最大值", 10, "max", {precision: 0});
    // this.addProperty("upStepmodal", '不乘以时间', 'enum', {values: ['乘以时间', '不乘以时间']});   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("combo","步进模式",this.properties.upStepmodal,{ property: "upStepmodal", values:['乘以时间', '不乘以时间'] } );
    // this.addProperty("stepValue", 1,  'number')
    // this.addWidget("number","步进数值", 1, "stepValue", {precision: 0});
    // this.updateWidght()
    // //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // 
    // this.properties.precision = 1


    return _this27;
  }

  var _proto27 = dataObjectRobot.prototype;

  _proto27.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto27.onStart = function onStart() {// this.repetDir = 1
    // this.value = this.getInputOrProperty("开始值") | 0
  } // updateWidght(){
  //   var value = this.properties.modal
  //   if(value != '无限制'){
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = false
  //         }
  //       })
  //     }else{
  //       this.widgets.map((widget)=>{
  //         if(widget.name == '最大值' || widget.name == '最小值'){
  //             widget.disabled = true
  //         }
  //       })
  //     }
  // }
  // onWidgetChanged(name, value, old_value, widget){
  //   // console.log('onWidgetChanged', node, name, value, old_value)
  //   // this.isWidgetVisible
  //   if(name == '模式'){
  //       this.updateWidght()
  //   }
  // }
  // Function to call when the node is executed
  // onAction(action, param, options) {
  // };
  ;

  _proto27.onExecute = function onExecute() {
    var data = this.getInputData(0);

    if (data !== undefined) {
      if (data instanceof Array) {
        for (var i = 0; i < data.length; i++) {
          this.setOutputData(0, i);
          this.setOutputData(1, data[i]);
          this.triggerSlot(2);
        }
      } else if (data instanceof Object) {
        for (var key in data) {
          this.setOutputData(0, key);
          this.setOutputData(1, data[key]);
          this.triggerSlot(2);
        }
      }
    }
  };

  return dataObjectRobot;
}(_litegraph.LGraphNode);

dataObjectRobot.title = '数据结构'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/dataObject", dataObjectRobot);

var getKeyValueRobot = /*#__PURE__*/function (_LGraphNode28) {
  _inheritsLoose(getKeyValueRobot, _LGraphNode28);

  // Name to show
  function getKeyValueRobot() {
    var _this28;

    _this28 = _LGraphNode28.call(this) || this; // this.serialize_widgets = true;

    _this28.title = "对象取值";
    _this28.desc = "和数据结构不同的是，这里取出特定的某个值";

    _this28.addInput("obj", "object"); // this.addInput("key", 'string')
    // this.addOutput("触发", LiteGraph.EVENT)
    // this.addOutput("value", 0)


    _this28.addOutput("property", 0);

    _this28.addProperty("value", 0);

    _this28.addWidget("text", "输入key", "", 'value');

    _this28.widgets_up = true;
    _this28.size = [140, 30];
    _this28._value = null;
    return _this28;
  }

  var _proto28 = getKeyValueRobot.prototype;

  _proto28.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "获取." + this.properties.value;
    }

    return this.title;
  };

  _proto28.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto28.onExecute = function onExecute() {
    var data = this.getInputData(0);

    if (data != null) {
      this.setOutputData(0, data[this.properties.value]);
    }
  };

  return getKeyValueRobot;
}(_litegraph.LGraphNode);

getKeyValueRobot.title = '对象取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/getKeyValue", getKeyValueRobot);

var getArrayValueRobot = /*#__PURE__*/function (_LGraphNode29) {
  _inheritsLoose(getArrayValueRobot, _LGraphNode29);

  // Name to show
  function getArrayValueRobot() {
    var _this29;

    _this29 = _LGraphNode29.call(this) || this; // this.serialize_widgets = true;

    _this29.title = "数组取值";
    _this29.desc = "和数据结构不同的是，这里取出特定的某个值";

    _this29.addInput("array", "array,table,string");

    _this29.addInput("index", "number");

    _this29.addOutput("value", "");

    _this29.addProperty("index", 0);

    _this29.addWidget('number', 'index', 0, 'index', {
      precision: 0
    });

    return _this29;
  }

  var _proto29 = getArrayValueRobot.prototype;

  _proto29.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "获取." + this.properties.index;
    }

    return this.title; // this.getOutputNodes()
    // this.isInputConnected()
    // this.outputs[0].links
    // this.disconnectInput()
    // this.onGetOutputs()
    // this.addInput()
    // this.removeInput()
  };

  _proto29.onGetOutputs = function onGetOutputs() {
    console.log('我调用了onGetOutputs');
    return [["number", "string"], ['被引用', 'lgraphNode']];
  };

  _proto29.onExecute = function onExecute() {
    var array = this.getInputData(0);
    var index = this.getInputData(1);

    if (index == null) {
      index = this.properties.index;
    }

    if (array == null || index == null) {
      return;
    }

    this.setOutputData(0, array[Math.floor(Number(index))]);
  };

  return getArrayValueRobot;
}(_litegraph.LGraphNode);

getArrayValueRobot.title = '数组取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/change/getArrayValue", getArrayValueRobot);

var sendData = /*#__PURE__*/function (_LGraphNode30) {
  _inheritsLoose(sendData, _LGraphNode30);

  // Name to show
  function sendData() {
    var _this30;

    _this30 = _LGraphNode30.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this30.title = "无线传送发射";
    _this30.desc = "用于无线连接节点";

    _this30.addInput("附带值", 0);

    _this30.addInput("发送", _litegraph.LiteGraph.ACTION); // this.addOutput("A", -1);


    _this30.addProperty("customeName", 'A', 'string');

    _this30.addWidget('string', '发送事件', _this30.properties.customeName, 'customeName'); // this.widgets_up = true


    return _this30;
  }

  var _proto30 = sendData.prototype;

  _proto30.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "发送事件." + this.properties.customeName;
    }

    return this.title;
  };

  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  _proto30.onAction = function onAction(action, param) {
    var data = this.getInputData(0);
    this.graph.sendEventToAllNodes(this.properties.customeName, data);
  };

  return sendData;
}(_litegraph.LGraphNode);

sendData.title = '无线传送发射'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/sendData", sendData);

var acceptData = /*#__PURE__*/function (_LGraphNode31) {
  _inheritsLoose(acceptData, _LGraphNode31);

  // Name to show
  function acceptData() {
    var _this31;

    _this31 = _LGraphNode31.call(this) || this; // this.widgets_up = true
    // this.serialize_widgets = true;
    // this.height = 

    _this31.title = "无线传送接收";
    _this31.desc = "用于无线连接节点";
    _this31.size = [140, 30]; // this.addInput("输入", -1);
    // this.addInput("index", "number");

    _this31.addOutput("接收值", 0);

    _this31.addOutput("接收", _litegraph.LiteGraph.EVENT);

    _this31.addProperty("customeName", 'A', 'string');

    _this31.addWidget('string', '接收事件', _this31.properties.customeName, 'customeName');

    return _this31;
  }

  var _proto31 = acceptData.prototype;

  _proto31.onStart = function onStart() {
    this[this.properties.customeName] = this.onEvent;
  };

  _proto31.getTitle = function getTitle() {
    if (this.flags.collapsed) {
      return "接收事件." + this.properties.customeName;
    }

    return this.title;
  };

  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  _proto31.onEvent = function onEvent(param) {
    console.log('我接收到了事件', param);
    this.setOutputData(0, param);
    this.triggerSlot(1, param);
  } // onAction(action, param){
  //   console.log('我接收到了事件', action)
  //   this.setOutputData(0, param)
  //   this.triggerSlot(0, param)
  // }
  ;

  return acceptData;
}(_litegraph.LGraphNode);

acceptData.title = '无线传送接收'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/acceptData", acceptData);

var outputLine = /*#__PURE__*/function (_LGraphNode32) {
  _inheritsLoose(outputLine, _LGraphNode32);

  // Name to show
  function outputLine() {
    var _this32;

    _this32 = _LGraphNode32.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this32.title = "输出逻辑线";
    _this32.desc = "根据输入值，触发不同的输出";

    _this32.addInput("输入值", 'number');

    _this32.addInput("触发", _litegraph.LiteGraph.ACTION);

    _this32.addOutput("output_0", _litegraph.LiteGraph.EVENT);

    _this32.addOutput("output_1", _litegraph.LiteGraph.EVENT); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this32;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto32 = outputLine.prototype;

  _proto32.onGetOutputs = function onGetOutputs() {
    // console.log('我调用了onGetOutputs')
    return [["output_" + this.outputs.length, _litegraph.LiteGraph.EVENT], ['被引用', 'lgraphNode']];
  };

  _proto32.onAction = function onAction(action, param) {
    var data = Number(this.getInputData(0)); // let soltName = 'output_' + data
    // this.graph.sendEventToAllNodes(this.properties.customeName, data)

    console.log('当前outputLine输入的值', data);

    if (this.outputs[data] != null) {
      this.triggerSlot(data);
    }
  };

  return outputLine;
}(_litegraph.LGraphNode);

outputLine.title = '输出逻辑线'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/outputLine", outputLine);

var lightingOut = /*#__PURE__*/function (_LGraphNode33) {
  _inheritsLoose(lightingOut, _LGraphNode33);

  // Name to show
  function lightingOut() {
    var _this33;

    _this33 = _LGraphNode33.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this33.title = "动态取值";
    _this33.desc = "动态输出需要的值";

    _this33.addInput("引用节点", 'lgraphNode'); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this33;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto33 = lightingOut.prototype;

  _proto33.onGetOutputs = function onGetOutputs() {
    // console.log('我调用了onGetOutputs')
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return [];
    } else {
      var alreadyAddDit = {};

      for (var i = 0; i < this.outputs.length; i++) {
        var output = this.outputs[i];
        alreadyAddDit[output.name] = 1;
      }

      var arr = [];

      for (var key in inputNode.properties) {
        if (alreadyAddDit[key] == null) {
          arr.push([key, 0]);
        }
      }

      return arr;
    }
  };

  _proto33.onExecute = function onExecute() {
    var inputNode = this.getInputNode(0);

    for (var i = 0; i < this.outputs.length; i++) {
      var output = this.outputs[i];
      this.setOutputData(i, inputNode.properties[output.name]);
    }
  } // onAction(action, param){
  //   let data = this.getInputData(0)
  //   // this.graph.sendEventToAllNodes(this.properties.customeName, data)
  //   if(this.outputs[data] != null){
  //     this.triggerSlot(data)
  //   }
  // }
  ;

  return lightingOut;
}(_litegraph.LGraphNode);

lightingOut.title = '动态取值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/lightingOut", lightingOut);

var lighting = /*#__PURE__*/function (_LGraphNode34) {
  _inheritsLoose(lighting, _LGraphNode34);

  // Name to show
  function lighting() {
    var _this34;

    _this34 = _LGraphNode34.call(this) || this; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this34.title = "动态赋值";
    _this34.desc = "动态设置引用节点的值";

    _this34.addInput("引用节点", 'lgraphNode');

    _this34.addInput("触发赋值", _litegraph.LiteGraph.ACTION); // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this34;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };


  var _proto34 = lighting.prototype;

  _proto34.onGetInputs = function onGetInputs() {
    // console.log('我调用了onGetOutputs')
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return [];
    } else {
      var alreadyAddDit = {};

      for (var i = 0; i < this.inputs.length; i++) {
        var output = this.inputs[i];
        alreadyAddDit[output.name] = 1;
      }

      var arr = [];

      for (var key in inputNode.properties) {
        if (alreadyAddDit[key] == null) {
          arr.push([key, 0]);
        }
      }

      return arr;
    }
  };

  // onExecute(){
  //   let inputNode = this.getInputNode(0)
  //   for(var i = 0; i < this.outputs.length; i++){
  //     let output = this.outputs[i]
  //     this.setOutputData(i, inputNode.properties[output.name])
  //   }
  // }
  _proto34.onAction = function onAction(action, param) {
    var inputNode = this.getInputNode(0);

    if (inputNode == null) {
      return;
    }

    if (this.inputs.length < 2) {
      return;
    }

    for (var i = 2; i < this.inputs.length; i++) {
      var input = this.inputs[i];
      var value = this.getInputData(i);

      if (inputNode.properties[input.name] != null && value != null) {
        inputNode.setProperty(input.name, value);
      }
    }
  };

  return lighting;
}(_litegraph.LGraphNode);

lighting.title = '动态赋值'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/lighting", lighting);

var textCode = /*#__PURE__*/function (_LGraphNode35) {
  _inheritsLoose(textCode, _LGraphNode35);

  // Name to show
  function textCode() {
    var _this35;

    _this35 = _LGraphNode35.call(this) || this;
    _this35.title = "js文本";
    _this35.desc = "直接运行代码片段";
    _this35.mode = _litegraph.LiteGraph.ON_TRIGGER; // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this35.addInput("输入参数", 0); // this.addInput("触发赋值", LiteGraph.ACTION);


    _this35.addOutput('输出结果', 0);

    _this35.addProperty("codeString", '', 'string');

    _this35.addWidget("text", '执行代码片段', _this35.properties.codeString, 'codeString', {
      multiline: true
    }); // this.widgets_up = true


    return _this35;
  } // getTitle() {
  //     if (this.flags.collapsed) {
  //         return "发送事件." + this.properties.customeName;
  //     }
  //     return this.title;
  // };
  // onExecute(){
  //   let inputNode = this.getInputNode(0)
  //   for(var i = 0; i < this.outputs.length; i++){
  //     let output = this.outputs[i]
  //     this.setOutputData(i, inputNode.properties[output.name])
  //   }
  // }


  var _proto35 = textCode.prototype;

  _proto35.onExecute = function onExecute() {
    var valueA = this.getInputData(0);
    var valueB = 0;
    var codeString = this.properties.codeString;

    try {
      eval(codeString);
    } catch (error) {
      console.warn('文本代码执行失败', error);
    }

    this.setOutputData(0, valueB);
  };

  return textCode;
}(_litegraph.LGraphNode);

textCode.title = 'js文本'; // Register the node type

_litegraph.LiteGraph.registerNodeType("middle/tool/textCode", textCode);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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