
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Common/LiteGraphCore/nodes/objects.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '658f49F0xBEM7Yr/NJxLROE', 'objects');
// Script/Common/LiteGraphCore/nodes/objects.js

"use strict";

var _litegraph = require("../../litegraph/litegraph");

var CocosMgr = _interopRequireWildcard(require("../CocosMgr"));

var _bezier = require("../../Bezier/bezier");

var _BaseYwNode = require("./BaseYwNode");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var soundFxs = ['无', 'popOut.mp3'];

var createObject = /*#__PURE__*/function (_BaseYWNode) {
  _inheritsLoose(createObject, _BaseYWNode);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function createObject() {
    var _this;

    _this = _BaseYWNode.call(this) || this; // this.serialize_widgets = true

    _this.title = "物体";
    _this.desc = "在界面中创建一个物体";
    _this.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this.addInput("创建", _litegraph.LiteGraph.ACTION); // this.addInput("触发", LiteGraph.ACTION);


    _this.addOutput("物体", 'codeNode');

    _this.addProperty('group', false, 'boolean');

    _this.addWidget('toggle', '是否作为UI', _this.properties.group, 'group');

    _this.addProperty('modal', '空物体', 'enum');

    _this.addWidget('combo', '物体类型', _this.properties.modal, {
      property: "modal",
      values: CocosMgr.objectTypes
    });

    _this.addProperty('customeName', '', 'string');

    _this.addWidget('string', '资源', _this.properties.customeName, 'customeName');

    _this.addProperty('showTime', 0, 'number');

    _this.addWidget('combo', '加载时机', _this.properties.showTime, {
      property: "showTime",
      values: {
        0: '初始化时',
        1: '输入时'
      }
    });

    _this.addProperty('premulAlpha', false, 'boolean');

    _this.addWidget('toggle', '是否预乘', _this.properties.premulAlpha, 'premulAlpha');

    _this.addProperty('zIndex', 1, 'number');

    _this.addWidget('number', '层级', _this.properties.zIndex, 'zIndex', {
      precision: 0
    });

    _this.addProperty('dynamiczIndex', false, 'boolean');

    _this.addWidget('toggle', '以y轴动态计算层级', _this.properties.dynamiczIndex, 'dynamiczIndex');

    _this.addProperty('x', -1280, 'number');

    _this.addWidget('number', '坐标-x', _this.properties.x, 'x', {
      precision: 2
    });

    _this.addProperty('y', -750, 'number');

    _this.addWidget('number', '坐标-y', _this.properties.y, 'y', {
      precision: 2
    });

    _this.addProperty('scaleX', 1, 'number');

    _this.addWidget('number', '缩放-x', _this.properties.scaleX, 'scaleX', {
      precision: 2
    });

    _this.addProperty('scaleY', 1, 'number');

    _this.addWidget('number', '缩放-y', _this.properties.scaleY, 'scaleY', {
      precision: 2
    });

    _this.addProperty('opacity', 255, 'number');

    _this.addWidget('slider', '透明度', _this.properties.opacity, 'opacity', {
      min: 0,
      max: 255,
      precision: 0
    });

    _this.addProperty('angle', 0, 'number');

    _this.addWidget('number', '角度', _this.properties.angle, 'angle', {
      min: -360,
      max: 360,
      precision: 0
    });

    _this.addProperty('anchorX', 0.5, 'number');

    _this.addWidget('number', '锚点x', _this.properties.anchorX, 'anchorX', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this.addProperty('anchorY', 0.5, 'number');

    _this.addWidget('number', '锚点y', _this.properties.anchorY, 'anchorY', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this.addProperty('width', 50, 'number');

    _this.widthWidget = _this.addWidget('number', '宽度', _this.properties.width, 'width', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this.addProperty('height', 50, 'number');

    _this.heightWidget = _this.addWidget('number', '高度', _this.properties.height, 'height', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this.addWidget('button', '重置为资源尺寸', "", function () {
      console.log('点击了重置按钮');

      _this.resetSizeConfig();
    });

    _this.addProperty('color', '#ffffff', 'string');

    _this.addWidget('string', '物体颜色', _this.properties.color, 'color');

    _this._hasToggleAssestLoad = false; //节点配置

    _this.addProperty('nodeConfig', {
      x: _this.properties.x,
      y: _this.properties.y,
      width: _this.properties.width,
      height: _this.properties.height,
      anchorX: _this.properties.anchorX,
      anchorY: _this.properties.anchorY,
      scaleX: _this.properties.scaleX,
      scaleY: _this.properties.scaleY,
      color: _this.properties.color,
      angle: _this.properties.angle
    }, 'object');

    _this.nodeConfigWidget = _this.addWidget('ccnode', '节点操控', _this.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    });

    _this.addProperty('string', '', 'string');

    _this.addWidget('string', '文本', _this.properties.string, 'string');

    _this.addProperty('outLineWidth', 0, 'number');

    _this.addWidget('slider', '描边宽度', _this.properties.outLineWidth, 'outLineWidth', {
      precision: 0,
      min: 0,
      max: 100
    });

    _this.addProperty('outLineColor', '#ffffff', 'string');

    _this.addWidget('string', '描边颜色', _this.properties.outLineColor, 'outLineColor');

    _this.addProperty('colliderValue', {}, 'object'); //需要创建设置碰撞框的组件
    // this.addProperty("modal", 0, "number");
    // this.addWidget("slider", '振动强度', this.properties.modal, "modal", {min: 0, max: 1, precision: 0});
    //设置节点的进度，一般来说用于在执行的时候设置
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    // this.properties.precision = 1
    // console.log('节点构建完毕')


    return _this;
  }

  var _proto = createObject.prototype;

  _proto.getExtraMenuOptions = function getExtraMenuOptions(graphcanvas) {
    var _this2 = this;

    // var that = this;
    return [{
      content: "编辑碰撞框",
      callback: function callback() {
        if (window.onGraphMenuClick != null) {
          // console.log(' this.properties.colliderValue.pointArr',  this.properties.colliderValue)
          if (Array.isArray(_this2.properties.colliderValue) == true) {
            _this2.properties.colliderValue = {};
          }

          window.onGraphMenuClick('editColider', {
            img: _this2.getPreviewImg(),
            scale: _this2.properties.colliderValue.scale || 1,
            pointArr: _this2.properties.colliderValue.pointArr || [],
            onValueChange: function onValueChange(pointArr, scale) {
              console.log('pointArr', pointArr, scale);
              _this2.properties.colliderValue.pointArr = pointArr;
              _this2.properties.colliderValue.baseWidth = _this2.properties.width;
              _this2.properties.colliderValue.baseHeight = _this2.properties.height;
              _this2.properties.colliderValue.scale = scale;
              var offsetX = 0;
              var offsetY = 0;

              if (_this2._renderSpine != null) {
                if (_this2._renderSpine.canRender) {
                  offsetX = _this2._renderSpine.bounds.offset.x + 0.5 * _this2.properties.width;
                  offsetY = _this2._renderSpine.bounds.offset.y + 0.5 * _this2.properties.height;
                }
              }

              _this2.properties.colliderValue.offsetX = offsetX;
              _this2.properties.colliderValue.offsetY = offsetY; //这个修改了的话，就要删除节点重新创建

              if (_this2.codeNode != null) {
                // console.log('碰撞框已经修改，删除节点重新创建')
                _this2.codeNode.destroyNode();

                _this2.codeNode = null;

                _this2.setOutputData(0, null);

                _this2.createObj();
              }
            }
          });
        }
      }
    }];
  };

  //onAdded每次添加到蓝图中都会调用
  _proto.onAdded = function onAdded() {
    console.log('节点添加到蓝图中了', this.properties.customeName, this.properties.modal); //如果是拖拽资源的话，这里也是需要触发的

    this.updateWidght();
    this.updateRenderAssest(); //重新计算一下默认尺寸

    this.setSize(this.computeSize());
    this.sendAddEvent();
  };

  _proto.onRemoved = function onRemoved() {
    // console.log('我从graph中移除了', this.properties.customeName)
    if (this.codeNode != null) {
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);
    }

    this._image = null;
    this._renderSpine = null;
    this.sendRemoveEvent();

    if (this.checkAssestTimeOut != null) {
      clearInterval(this.checkAssestTimeOut);
      this.checkAssestTimeOut = null;
    }
  } //onConfigure从json还原到蓝图中才会调用，如果从json还原，onAdded会优先触发
  ;

  _proto.onConfigure = function onConfigure() {
    var _this3 = this;

    if (CocosMgr.isInApp == true) {
      return;
    }

    if (CocosMgr.isInImport == true) {
      return;
    } // console.log('createObject节点配置了', this.properties.customeName, this.properties.modal)


    this.updateWidght();
    this.updateRenderAssest();

    if (this.graph && CocosMgr.isSinglePreview == true) {
      //在另一个网页打开的单列，不需要canvas渲染蓝图
      this.createObj();
    } else {
      if (this.graph && this.graph.list_of_graphcanvas != null && this.graph.list_of_graphcanvas.length > 0) {
        //说明在编辑中，始终创建预览
        this.createObj(function () {
          if (_this3.properties.modal == 'spine') {
            setTimeout(function () {
              try {
                //根据连接的animate动画自动设置首选预览图
                var linkedNodes = _this3.getOutputNodes(0);

                if (linkedNodes != null) {
                  linkedNodes = linkedNodes.filter(function (node) {
                    return node.type == 'objects/animates/animate' && node.properties.autoRun == true;
                  });

                  if (linkedNodes[0] != null) {
                    var firstAni = linkedNodes[0];
                    firstAni.onSelected();
                    var skin = firstAni.properties.skin; // console.log('物体创建完成了', this.properties.customeName, this.properties.modal, skin, firstAni.properties.playAniName)

                    _this3.codeNode.setSkin(skin);

                    _this3.codeNode.playAnimation(firstAni.properties.playAniName, firstAni.properties.loop);
                  }
                }
              } catch (error) {}
            }, 1000);
          }
        });
      }
    } // this.createObj()

  } //开始运行会初始化
  ;

  _proto.onStartBeforeLoad = function onStartBeforeLoad() {
    var _this4 = this;

    console.log('createObject onStart', this.properties.showTime);
    var showTime = this.properties.showTime;

    if (showTime == 0) {
      //'初始化时'
      this.graph.config.assestTotal += 1;
      this.createObj(function () {
        _this4.graph.config.assestLoaded += 1;

        if (_this4.graph.checkAssestLoadComplete != null) {
          _this4.graph.checkAssestLoadComplete();
        }
      });
    }
  } //创建一个物体
  ;

  _proto.createObj = function createObj(loadCb) {
    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == true) {
        // if(CocosMgr.isInApp == true){
        //不重复生成，仅仅重置所有参数
        var config = _extends({}, this.properties);

        CocosMgr.syncConfigToCodeNode(this.codeNode, config);

        if (loadCb != null) {
          loadCb();
        }

        this.setOutputData(0, this.codeNode);
        return; // }
        // console.log('我删除了旧的codeNode', this.codeNode.node._id)
        // this.codeNode.destroyNode()
      }

      this.codeNode = null;
      this.setOutputData(0, null);
    }

    var config = _extends({}, this.properties); // console.log('createObj config', config)  //调用一个创建物体的配置


    var rootccNode = this.graph.vars.rootccNode;

    if (rootccNode != null) {
      config['parent'] = rootccNode;
    }

    this.codeNode = CocosMgr.createObj(config, loadCb);
    this.codeNode.graph = this.graph;
    console.log('我创建了的codeNode', this.codeNode.node._id);
    this.setOutputData(0, this.codeNode);
    return this.codeNode;
  };

  _proto.updateOutputData = function updateOutputData(slot) {
    console.log('我收到了更新物体的事件', slot);
    this.setOutputData(slot, this.codeNode);
  } //在不同的蓝图切换，需要查询是否存在预览节点，不存在的话就创建
  //当lagraph attach时此node可能还未创建，所以不能
  // onAttachCanvas(){
  //     console.log('onAttachCanvas', this.properties.customeName )
  //     this.createObj()
  // }
  // onDetachCanvas(){
  //     console.log('onDetachCanvas', this.properties.customeName )
  //     //如果当前是打开的是子蓝图，那就不要删除
  //     console.log('this.graph', this.graph)
  //     if(this.codeNode != null){
  //         this.codeNode.destroyNode()
  //         this.codeNode = null
  //     }
  // }
  // 当节点Toggle时调用
  ;

  _proto.onAction = function onAction(action, param) {
    if (action == '创建') {
      this.createObj();
    }
  };

  _proto.getTitle = function getTitle() {
    var value = this.properties.modal; // var customeName = this.properties.customeName
    // var firstDotIndex = customeName.indexOf('.')
    // if(firstDotIndex != -1){
    //     customeName = customeName.substring(0, firstDotIndex)
    // }

    if (value == '文本') {
      var str = this.properties.string.length < 9 ? this.properties.string : this.properties.string.substring(0, 8) + '..';
      value += ':' + str;
    }

    this.inputs;
    return value; //+ "  " + customeName
  };

  _proto.updateWidght = function updateWidght() {
    var value = this.properties.modal;
    this.widgets.map(function (widget) {
      // widget.name == '描边宽度'
      if (widget.name == '文本' || widget.name == '描边颜色') {
        widget.hidden = value != '文本'; // widget.computedDisabled = value != '文本'
      }

      if (widget.name == '锚点x' || widget.name == '锚点y' || widget.name == '宽度' || widget.name == '高度') {
        widget.disabled = value == 'spine';
      }
    }); // this.expandToFitContent()
  } // onSelected(){
  // }
  ;

  _proto.onPause = function onPause() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null) {
        this.codeNode.spineCom.paused = true;
      }

      cc.director.getActionManager().pauseTarget(this.codeNode);
    }
  } //切换时间缩放
  ;

  _proto.onChangeTimeScale = function onChangeTimeScale() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null && this.graph.config.timeScale != null) {
        this.codeNode.spineCom.timeScale = this.graph.config.timeScale;
      }
    }
  };

  _proto.onResume = function onResume() {
    if (this.codeNode != null) {
      if (this.codeNode.spineCom != null) {
        this.codeNode.spineCom.paused = false;
      }

      cc.director.getActionManager().resumeTarget(this.codeNode);
    }
  };

  _proto.onStop = function onStop() {
    // this.isOutputConnected(0)
    // this.outputs.map((item)=>{
    //     return item.name
    // })
    // this.findInputSlot('播放')
    // let link = this.graph.links.get(2)
    // link.target_id
    //这里不能重制，重置了翻页会闪烁
    this.codeNode.targetOff();

    if (this.codeNode != null && CocosMgr.isInApp == false) {
      var config = _extends({}, this.properties.nodeConfig); // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }
  };

  _proto.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    // console.log('onPropertyChanged', name, value)
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }
      }
    }

    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == false) {
        this.codeNode = null;
        return;
      }

      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);

      if (property == 'string') {
        //修改文本重新设置尺寸
        this.resetSizeConfig();
      }
    } // if(property == 'modal'){
    //   this.updateRenderAssest()
    // }else if(property == 'customeName'){
    //   this.updateRenderAssest()
    // }


    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  _proto.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {
    // console.log('onWidgetChanged', name, value, oldValue, widget)
    // var property = widget.options.property
    if (name == '物体类型') {
      this.updateWidght();
      this.updateRenderAssest();
    } else if (name == '资源') {
      this.updateRenderAssest();
    }

    this.sendOtherEvent('onWidgetChanged', [name]);
  } //更新可以显示的资源
  ;

  _proto.updateRenderAssest = function updateRenderAssest() {
    var _this5 = this;

    if (CocosMgr.isInApp == true) {
      //在App中不会运行此操作
      return;
    } // console.log('导入时不会刷新资源预览', CocosMgr.isInImport)


    if (CocosMgr.isInImport == true) {
      //在App中不会运行此操作
      return;
    } // if(CocosMgr.isSinglePreview == true){
    //     //直接创建物体就行了，不需要创建预览，如果这里不加载预览，可能会导致获取不到资源信息，所以还是应该加载？
    //     this.createObj()
    //     return
    // }


    var modal = this.properties.modal;
    var customeName = this.properties.customeName;
    console.log('updateRenderAssest', modal, customeName);

    if (modal != 'spine') {
      this._renderSpine = null;
    }

    if (modal != '图片') {
      if (this._image != null) {
        this._image.src = null;
        this._image = null;
      }
    }

    if (modal == '图片') {
      if (this._image == null) {
        this._image = new Image();
      }

      var realSrc = CocosMgr.rootHost + '/' + customeName;

      if (this._image.src != realSrc) {
        this._image.src = realSrc;
        this._hasToggleAssestLoad = false;

        if (this.checkAssestTimeOut != null) {
          clearInterval(this.checkAssestTimeOut);
          this.checkAssestTimeOut = null;
        }

        this.checkAssestTimeOut = setInterval(function () {
          _this5.checkAssestLoaded();
        }, 500);
      }
    } else if (modal == 'spine') {
      if (this._renderSpine == null) {
        this._renderSpine = new SpineToImg();
      }

      var assetName = customeName + '.json';

      if (this._renderSpine.assets == null || this._renderSpine.assets.json != assetName) {
        this._hasToggleAssestLoad = false;

        if (this.checkAssestTimeOut != null) {
          clearInterval(this.checkAssestTimeOut);
          this.checkAssestTimeOut = null;
        }

        this.checkAssestTimeOut = setInterval(function () {
          _this5.checkAssestLoaded();
        }, 500); // if(customeName.indexOf('Common_Click') != -1){
        //     this._renderSpine.autoSetAni = true //防止spine预览加载不出来的情况
        // }else{
        //     this._renderSpine.autoSetAni = false
        // }
        // console.log('this._renderSpine.autoSetAni', this._renderSpine.autoSetAni)

        this._renderSpine.setAssets({
          dir: CocosMgr.rootHost,
          json: customeName + '.json',
          atlas: customeName + '.atlas'
        });
      }
    } else if (modal == '文本') {
      this.createObj();
      this.resetSizeConfig();
    } else if (modal == '空物体') {
      //空物体也要提前创建
      this.createObj();
    }
  } //部分动画切换皮肤可能直接就是修改了图片，所以需要重新修改预览
  ;

  _proto.updateSpinePreview = function updateSpinePreview(skin) {
    if (this._renderSpine != null) {
      this._renderSpine.setSkin(skin);

      this._renderSpine.genPreviewImg();
    }
  } //重置尺寸配置信息，只有在编辑模式下会触发
  ;

  _proto.resetSizeConfig = function resetSizeConfig() {
    var width = this.properties.width;
    var height = this.properties.height;

    if (this._image != null) {
      if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {
        width = this._image.width;
        height = this._image.height;
      }
    } else if (this._renderSpine != null) {
      if (this._renderSpine.canRender) {
        width = this._renderSpine.bounds.size.x;
        height = this._renderSpine.bounds.size.y;
      }
    } else if (this.properties.modal == '文本') {
      console.log('当前是否有text节点', this.codeNode);

      if (this.codeNode != null) {
        width = this.codeNode.width;
        height = this.codeNode.height;
      }
    }

    console.log('width', width, height);
    this.widthWidget.setValue(width, {
      e: null,
      node: this,
      canvas: null
    });
    this.heightWidget.setValue(height, {
      e: null,
      node: this,
      canvas: null
    });
    var nodeConfig = this.properties.nodeConfig;
    nodeConfig.width = width;
    nodeConfig.height = height;

    if (this.properties.modal != '文本') {
      //每次都重新创建物体
      this.createObj();
    } // this.nodeConfigWidget.setValue(nodeConfig, )

  };

  _proto.getPreviewImg = function getPreviewImg() {
    if (this._image != null) {
      if (this._image.complete == false) {
        //还没有完全加载完成
        return;
      }

      if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {} else {
        return;
      }

      return this._image.src;
    } else if (this._renderSpine != null) {
      if (this._renderSpine.canRender) {
        return this._renderSpine.getImgUrlOri();
      }
    }
  } //检查资源是否加载成功，之前放在node渲染时加载
  //如果不传ctx就仅仅判断是否加载成功
  ;

  _proto.checkAssestLoaded = function checkAssestLoaded(ctx) {
    var modal = this.properties.modal;

    if (modal == '图片') {
      if (this._image != null) {
        if (this._image.complete == false) {
          //还没有完全加载完成
          return;
        }

        if (this._image.naturalWidth > 0 && this._image.naturalHeight > 0) {} else {
          //没有成功加载图片
          //可以绘制加载丢失的404警告
          if (ctx != null) {
            this.drawErrorTips(ctx);
          }

          return;
        }

        if (this._hasToggleAssestLoad == false) {
          this.resetSizeConfig();
          this._hasToggleAssestLoad = true;

          if (this.checkAssestTimeOut != null) {
            clearInterval(this.checkAssestTimeOut);
            this.checkAssestTimeOut = null;
          }
        }

        if (ctx != null) {
          var rect = this.drawAssestBox(ctx, this._image.width, this._image.height);
          ctx.drawImage(this._image, rect.x, rect.y, rect.width, rect.height);
        }
      }
    } else if (modal == 'spine') {
      //使用spineRender渲染节点
      if (this._renderSpine != null) {
        if (this._renderSpine.canRender) {
          if (ctx != null) {
            if (this._renderSpine.image != null && this._renderSpine.image.naturalWidth > 0 && this._renderSpine.image.naturalHeight > 0) {
              //根据连接的animate动画自动设置首选预览图
              var linkedNodes = this.getOutputNodes(0);

              if (linkedNodes != null) {
                linkedNodes = linkedNodes.filter(function (node) {
                  return node.type == 'objects/animates/animate' && node.properties.autoRun == true;
                });

                if (linkedNodes[0] != null) {
                  var firstAni = linkedNodes[0];
                  var skin = firstAni.properties.skin;
                  this.updateSpinePreview(skin);
                }
              }

              var rect = this.drawAssestBox(ctx, this._renderSpine.image.width, this._renderSpine.image.height);
              ctx.drawImage(this._renderSpine.image, rect.x, rect.y, rect.width, rect.height);
            }
          } // this._renderSpine.render(ctx, rect)


          if (this._hasToggleAssestLoad == false) {
            this.resetSizeConfig();
            this._hasToggleAssestLoad = true;

            if (this.checkAssestTimeOut != null) {
              clearInterval(this.checkAssestTimeOut);
              this.checkAssestTimeOut = null;
            }
          }
        } else {
          //判断是否加载出错
          if (ctx != null) {
            this.drawErrorTips(ctx);
          } // if(this._renderSpine.isLoadingComplete()){
          // }
          // if(this._renderSpine.isLoadIngError()){
          //     // console.log('调用了render spine')
          // }

        }
      }
    }
  };

  _proto.onDrawForeground = function onDrawForeground(ctx, lgCanvas, canvas) {
    // if (this.flags.collapsed) {
    //     return;
    // }
    this.checkAssestLoaded(ctx);
  };

  return createObject;
}(_BaseYwNode.BaseYWNode);

createObject.title = '物体';
createObject.showTypes = ['初始化时', '输入时'];

_litegraph.LiteGraph.registerNodeType("objects/createObject", createObject); //字幕组


var textGroup = /*#__PURE__*/function (_BaseYWNode2) {
  _inheritsLoose(textGroup, _BaseYWNode2);

  function textGroup() {
    var _this6;

    _this6 = _BaseYWNode2.call(this) || this;
    _this6.title = "字幕组";
    _this6.desc = "用于快速创建一个绘本中浮动的字幕";
    _this6.mode = _litegraph.LiteGraph.ON_EVENT;

    _this6.addInput("物体", "codeNode"); // this.addInput("播放", LiteGraph.ACTION)
    // this.addInput("停止", LiteGraph.ACTION)


    _this6.addOutput("列表", 'array');

    _this6.addProperty('showInPageBottom', false, 'boolean');

    _this6.addWidget('toggle', '用作底部字幕', _this6.properties.showInPageBottom, 'showInPageBottom');

    _this6.addProperty('vertical', false, 'boolean');

    _this6.addWidget('toggle', '竖向文本', _this6.properties.vertical, 'vertical');

    _this6.addProperty('layout', '居左/下', 'enum');

    _this6.addWidget('combo', '排列', _this6.properties.layout, {
      property: "layout",
      values: textGroup.layoutEnum
    });

    _this6.addProperty('firstLineOffset', 0, 'number');

    _this6.addWidget('number', '首行缩进', _this6.properties.firstLineOffset, 'firstLineOffset', {
      precision: 0
    });

    _this6.addProperty('lineSpace', 0, 'number');

    _this6.addWidget('number', '行距', _this6.properties.lineSpace, 'lineSpace', {
      precision: 0
    });

    _this6.addProperty('fontSize', 45, 'number');

    _this6.addWidget('number', '字号', _this6.properties.fontSize, 'fontSize', {
      precision: 0
    });

    _this6.addProperty('color', '#000000', 'string');

    _this6.addWidget('string', '颜色', _this6.properties.color, 'color');

    _this6.addProperty('outLineWidth', 4, 'number');

    _this6.addWidget('slider', '描边宽度', _this6.properties.outLineWidth, 'outLineWidth', {
      precision: 0,
      min: 0,
      max: 100
    });

    _this6.addProperty('outLineColor', '#ffffff', 'string');

    _this6.addWidget('string', '描边颜色', _this6.properties.outLineColor, 'outLineColor');

    _this6.addProperty('hideBeforRun', false, 'boolean');

    _this6.addWidget('toggle', '运行前隐藏', _this6.properties.hideBeforRun, 'hideBeforRun');

    _this6.addProperty('hideAfterRun', false, 'boolean');

    _this6.addWidget('toggle', '运行结束隐藏', _this6.properties.hideAfterRun, 'hideAfterRun');

    _this6.addProperty('hideBaseLabel', false, 'boolean');

    _this6.addWidget('toggle', '隐藏底层文字', _this6.properties.hideBaseLabel, 'hideBaseLabel');

    _this6.addProperty('needColorAni', false, 'boolean');

    _this6.addWidget('toggle', '是否颜色过渡', _this6.properties.needColorAni, 'needColorAni');

    _this6.addProperty('maskColor', '#88BF3D', 'string');

    _this6.addWidget('string', '过渡颜色', _this6.properties.maskColor, 'maskColor'); // this.properties.linesNum = 0


    _this6.addProperty('linesNum', 0, 'number');

    _this6.addWidget('button', '添加一行', '', function () {
      _this6.addLine();
    });

    _this6.addWidget('button', '删除一行', '', function () {
      _this6.removeLine();
    }); // this.serialize_widgets = true


    return _this6;
  }

  var _proto2 = textGroup.prototype;

  _proto2.updateWidght = function updateWidght() {
    var value = this.properties.showInPageBottom;
    this.widgets.map(function (widget) {
      if (widget.name != '用作底部字幕') {
        widget.hidden = value;
      }
    });
    this.setSize(this.computeSize());
  } //从配置初始化时，自动创建widget
  ;

  _proto2.onConfigure = function onConfigure() {
    console.log('当前的配置信息', this.properties);

    for (var i = 0; i < this.properties.linesNum; i++) {
      var key = 'text' + (i + 1);
      this.addWidget('string', '文本', this.properties[key], key);
    }

    this.freshTexts();
  };

  _proto2.addLine = function addLine() {
    this.properties.linesNum += 1;
    var key = 'text' + this.properties.linesNum;
    this.addProperty(key, '', 'string');
    this.addWidget('string', '文本', '', key);
    this.freshTexts();
  };

  _proto2.removeLine = function removeLine() {
    if (this.properties.linesNum == 0) {
      return;
    }

    var key = 'text' + this.properties.linesNum;
    this.properties.linesNum -= 1;
    this.removeProperty(key);
    this.widgets.pop();
    this.setSize(this.computeSize());
    this.freshTexts();
  } //当条件修改
  ;

  _proto2.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      // console.warn('textGroup 当前没有物体')
      return;
    }

    if (codeNode.node == null) {
      // console.warn('textGroup 关联物体没有创建node')
      return;
    }

    if (property == 'showInPageBottom') {
      this.updateWidght();

      if (value == false) {
        this.freshTexts();
      } else {
        var codeNode = this.getInputData(0, true);

        if (codeNode != null) {
          codeNode.clearChildren();
        }
      }

      return;
    }

    if (property == 'layout') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var childCodeNode = codeNode.node.children[i].getComponent('CodeNodeLg');

        if (this.properties.vertical == true) {
          if (i == 0) {
            childCodeNode.y = this.properties.firstLineOffset;
          } else {
            childCodeNode.y = 0;
          }

          childCodeNode.anchorY = textGroup.anchorXDit[value];
          childCodeNode.anchorX = 0.5;
        } else {
          if (i == 0) {
            childCodeNode.x = this.properties.firstLineOffset;
          } else {
            childCodeNode.x = 0;
          }

          childCodeNode.anchorY = 0.5;
          childCodeNode.anchorX = textGroup.anchorXDit[value];
        }
      }
    } else if (property == 'vertical') {
      //垂直排列
      var layout = codeNode.checkAddComponent(cc.Layout);

      if (value == false) {
        layout.type = cc.Layout.Type.VERTICAL;
        layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
        layout.spacingY = this.properties.lineSpace;
        layout.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
      } else {
        layout.type = cc.Layout.Type.HORIZONTAL;
        layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
        layout.spacingX = this.properties.lineSpace;
        layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT;
      }

      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _childCodeNode = codeNode.node.children[i].getComponent('CodeNodeLg');

        _childCodeNode.overflow = value ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE;

        if (value == true) {
          if (i == 0) {
            _childCodeNode.y = this.properties.firstLineOffset;
          } else {
            _childCodeNode.y = 0;
          }
        } else {
          if (i == 0) {
            _childCodeNode.x = this.properties.firstLineOffset;
          } else {
            _childCodeNode.x = 0;
          }
        }

        if (value == false) {
          _childCodeNode.anchorX = textGroup.anchorXDit[this.properties.layout];
          _childCodeNode.anchorY = 0.5;
        } else {
          _childCodeNode.anchorX = 0.5;
          _childCodeNode.anchorY = textGroup.anchorXDit[this.properties.layout];
          _childCodeNode.width = this.properties.fontSize + 10;
        }
      } // anchorX: textGroup.anchorXDit[this.properties.layout],
      // overflow: this.properties.vertical ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE,
      // width: this.properties.fontSize + 10   

    } else if (property == 'lineSpace') {
      var _layout = codeNode.checkAddComponent(cc.Layout); // layout.type = cc.Layout.Type.VERTICAL
      // layout.resizeMode = cc.Layout.ResizeMode.CONTAINER


      if (this.properties.vertical) {
        _layout.spacingX = this.properties.lineSpace;
      } else {
        _layout.spacingY = this.properties.lineSpace;
      }
    } else if (property == 'firstLineOffset') {
      var child = codeNode.node.children[0];

      if (child != null) {
        if (this.properties.vertical) {
          child.getComponent('CodeNodeLg').y = this.properties.firstLineOffset;
        } else {
          child.getComponent('CodeNodeLg').x = this.properties.firstLineOffset;
        }
      }
    } else if (property == 'outLineColor') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child = codeNode.node.children[i];
        _child.getComponent('CodeNodeLg').outLineColor = this.properties.outLineColor;
      }
    } else if (property == 'outLineWidth') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child2 = codeNode.node.children[i];
        _child2.getComponent('CodeNodeLg').outLineWidth = this.properties.outLineWidth;
      }
    } else if (property == 'fontSize') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child3 = codeNode.node.children[i];
        _child3.getComponent('CodeNodeLg').fontSize = this.properties.fontSize;

        if (this.properties.vertical) {
          _child3.getComponent('CodeNodeLg').width = this.properties.fontSize + 10;
        }
      }
    } else if (property == 'color') {
      for (var i = 0; i < codeNode.node.children.length; i++) {
        var _child4 = codeNode.node.children[i];
        _child4.getComponent('CodeNodeLg').color = this.properties.color;
      }
    } else {
      var childNode = codeNode.getChildByName(property);

      if (childNode != null) {
        childNode.getComponent('CodeNodeLg').string = value;
      }
    }
  } //根据当前配置刷新界面
  ;

  _proto2.freshTexts = function freshTexts(data) {
    var _this7 = this;

    var codeNode = this.getInputData(0, true);

    if (this.properties.showInPageBottom == true) {
      //只在绘本底部通用导航栏显示
      if (codeNode != null) {
        codeNode.clearChildren();
      }

      return;
    } // console.log('textGroup freshTexts', data,  codeNode)


    if (codeNode == null) {
      console.log('当前没有物体');

      if (CocosMgr.isInApp == false) {
        var linkNode = this.getRealLinkNode();

        if (linkNode == null) {
          console.log('当前没有关联节点');
          return;
        }

        codeNode = linkNode.codeNode;

        if (codeNode == null) {
          console.log('当前关联节点没有codeNode');
          return;
        }
      } else {
        return;
      }
    }

    var layout = codeNode.checkAddComponent(cc.Layout);

    if (this.properties.vertical == false) {
      layout.type = cc.Layout.Type.VERTICAL;
      layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      layout.spacingY = this.properties.lineSpace;
      layout.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
    } else {
      layout.type = cc.Layout.Type.HORIZONTAL;
      layout.resizeMode = cc.Layout.ResizeMode.CONTAINER;
      layout.spacingX = this.properties.lineSpace;
      layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT;
    } // layout.horizontalDirection = cc.Layout.HorizontalDirection.RIGHT_TO_LEFT


    codeNode.clearChildren();
    this.motionTextArr = []; // layout

    for (var i = 1; i <= this.properties.linesNum; i++) {
      var config = {
        parent: codeNode.node,
        modal: CocosMgr.ObjectTypeEnum.text,
        customeName: 'text' + i,
        string: this.properties['text' + i],
        outLineWidth: this.properties.outLineWidth,
        outLineColor: this.properties.outLineColor,
        fontSize: this.properties.fontSize,
        color: this.properties.color,
        // anchorX: textGroup.anchorXDit[this.properties.layout],
        overflow: this.properties.vertical ? cc.Label.Overflow.RESIZE_HEIGHT : cc.Label.Overflow.NONE,
        width: this.properties.fontSize + 10 //只有竖向排列时生效

      };
      var node = CocosMgr.createObj(config);

      if (node != null && data != null) {
        console.log('生成字幕', this.properties.hideBeforRun, this.properties['text' + i], node.node._id, data);
        var motionText = node.checkAddComponent('MotionText');
        motionText.hideBeforRun = this.properties.hideBeforRun;
        motionText.hideAfterRun = this.properties.hideAfterRun;
        motionText.hideBaseLabel = this.properties.hideBaseLabel;
        motionText.dir = this.properties.vertical ? 1 : 0; // console.log('设置了motionText hideAfterRun', this.properties.hideAfterRun)

        motionText.maskColor = this.properties.maskColor;
        this.motionTextArr.push(motionText);
        var index = i - 1;

        if (data[index] != null) {
          motionText.position = data[index].position.map(function (value) {
            if (_this7.properties.needColorAni != true) {
              return 0;
            }

            return value * 0.01;
          }).join(',');
          motionText.positionTime = data[index].times.join(',');
          console.log('设置了motionText hideAfterRun', motionText.position, motionText.positionTime);
        }

        motionText.init();
      } //重新对齐一下


      this.onPropertyChanged('layout', this.properties.layout);
    }
  };

  _proto2.onAction = function onAction(name) {
    var _this8 = this;

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.log('当前没有物体');
      return;
    }

    console.log('textGroup onAction', name);

    if (name == '播放') {
      // for(var i = 0; i < codeNode.node.children.length; i++){
      //    let child = codeNode.node.children[i]
      //    child.getComponent('MotionText').
      // }
      var curIndex = 0;

      var run = function run() {
        var textArr = _this8.motionTextArr;

        if (textArr[curIndex] == null) {
          return;
        }

        var motionText = textArr[curIndex];
        console.log('textGroup 当前执行的motionText', curIndex, textArr[curIndex].node._id, motionText);

        if (motionText == null) {
          return;
        }

        motionText.dir = _this8.properties.vertical ? 1 : 0;
        motionText.inputHandle({
          data: 1
        });

        motionText.outputHandle = function () {
          curIndex += 1;

          if (textArr[curIndex] != null && textArr[curIndex].node.active == true) {
            run();
          } else {// this.scheduleOnce(()=>{
            //     //等待0.3秒再认为结束，因为开启录音会录制到没有说话的部分
            //     if(this.outputHandle != null){
            //         this.outputHandle('onend', 1)
            //     }
            // }, 0.3)
          }
        };
      };

      run();
    } else if (name == '停止') {
      var textArr = this.motionTextArr;

      for (var i = 0; i < textArr.length; i++) {
        var motionText = textArr[i];

        if (motionText != null) {
          motionText.inputHandle({
            data: 0
          });
        }
      }
    }
  };

  return textGroup;
}(_BaseYwNode.BaseYWNode);

textGroup.layoutEnum = ['居左/下', '居中', '居右/上'];
textGroup.anchorXDit = {
  '居左/下': 0,
  '居中': 0.5,
  '居右/上': 1
};
textGroup.title = '字幕组';

_litegraph.LiteGraph.registerNodeType("objects/textGroup", textGroup);

var animate = /*#__PURE__*/function (_BaseYWNode3) {
  _inheritsLoose(animate, _BaseYWNode3);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function animate() {
    var _this9;

    _this9 = _BaseYWNode3.call(this) || this; // this.serialize_widgets = true

    _this9.title = "骨骼动画";
    _this9.desc = "用于控制动画播放";
    _this9.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this9.addInput("物体", "codeNode");

    _this9.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this9.addOutput("结束", _litegraph.LiteGraph.EVENT);

    _this9.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this9._skins = [];
    _this9._animations = [];

    _this9.addProperty('modal', '全设置', 'enum');

    _this9.addWidget('combo', '更新模式', _this9.properties.modal, {
      property: "modal",
      values: animate.modalEnum
    });

    _this9.addProperty('skin', '', 'enum');

    _this9.addWidget('combo', '选择皮肤', _this9.properties.skin, {
      property: "skin",
      values: _this9._skins
    });

    _this9.addProperty('playAniName', '', 'enum');

    _this9.addWidget('combo', '选择动画', _this9.properties.playAniName, {
      property: "playAniName",
      values: _this9._animations
    }); // this.addWidget('button','刷新皮肤和动画选项', "", ()=>{
    //     this.getEnums()
    // })


    _this9.addProperty('loop', false, 'boolean');

    _this9.addWidget('toggle', '是否循环', _this9.properties.loop, 'loop');

    _this9.addProperty('timeScale', 1, 'number');

    _this9.addWidget('slider', '播放速率', _this9.properties.timeScale, 'timeScale', {
      precision: 1,
      min: 0,
      max: 10
    });

    _this9.addProperty('autoRun', false, 'boolean');

    _this9.addWidget('toggle', '是否自动播放', _this9.properties.autoRun, 'autoRun');

    _this9.addProperty('clickWait', false, 'boolean');

    _this9.addWidget('toggle', '点击等待动画结束', _this9.properties.clickWait, 'clickWait');

    _this9.addProperty('softChange', false, 'boolean');

    _this9.addWidget('toggle', '柔和过度', _this9.properties.softChange, 'softChange');

    _this9.addProperty('cancelEvent', false, 'boolean');

    _this9.addWidget('toggle', '取消其他触摸事件', _this9.properties.cancelEvent, 'cancelEvent');

    _this9.addProperty('aniEndCanClick', false, 'boolean');

    _this9.addWidget('toggle', '动画结束后响应点击', _this9.properties.aniEndCanClick, 'aniEndCanClick');

    _this9.addProperty('toggleCount', 1, 'number');

    _this9.addWidget('number', '结束触发次数', _this9.properties.toggleCount, 'toggleCount', {
      precision: 0,
      min: 0
    });

    _this9.addProperty('aniClickReplay', false, 'boolean');

    _this9.addWidget('toggle', '点击重播动画', _this9.properties.aniClickReplay, 'aniClickReplay');

    _this9.addProperty('aniClickTimeSpace', 0, 'number');

    _this9.addWidget('number', '点击时间间隔', _this9.properties.aniClickTimeSpace, 'aniClickTimeSpace');

    _this9.addProperty('canClickOutLine', false, 'boolean');

    _this9.addWidget('toggle', '可点击时显示描边', _this9.properties.canClickOutLine, 'canClickOutLine');

    _this9.addProperty('isCanClick', true, 'boolean');

    var canClickWidget = _this9.addWidget('toggle', '是否可点击', _this9.properties.isCanClick, 'isCanClick');

    var linkSolt = _this9.addInput("触摸提示", "lgraphNode");

    _this9.addProperty('linkClickTip', '', 'string'); //保存一个节点id就行


    var linkTipsWidget = _this9.addWidget('linknode', '添加触摸提示', _this9.properties.linkClickTip, function () {
      _this9.oneClickCreateTouchTip();
    });

    _this9.addProperty('tipsJustOnce', true, 'boolean');

    _this9.addWidget('toggle', '触摸提示只出现一次', _this9.properties.tipsJustOnce, 'tipsJustOnce');

    linkSolt.widget = linkTipsWidget; // linkSolt.pos = [5, 100]
    // console.log("linkSolt.pos", linkSolt.pos)

    _this9.createCaidanBtn = _this9.addWidget('button', '创建点击彩蛋交互', "", function () {
      // this.syncTargetValue()
      _this9.createClickToNextAni();
    });
    _this9.createCaidanBtn.disabled = true;

    _this9.addWidget('button', '预览动画', "", function () {
      _this9.previewAni();

      _this9.sendBtnWidgetClickEvent('预览动画');
    });

    _this9.addProperty('listenAniEvent', true, 'boolean');

    var linkSoundSolt = _this9.addInput("关联音频", "lgraphNode");

    var linkSountWidget = _this9.addWidget('toggle', '关联动画音频', _this9.properties.listenAniEvent, 'listenAniEvent');

    linkSoundSolt.widget = linkSountWidget;

    var isCanClickInput = _this9.addInput('isCanClick', 'boolean');

    isCanClickInput.widget = canClickWidget;

    _this9.addProperty('soundFx', '无', 'enum');

    _this9.addWidget('combo', '音效', _this9.properties.soundFx, {
      property: "soundFx",
      values: soundFxs
    }); //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    //将此动画存在的音频事件也显示出来
    // this.addWidget('button','', "", (btnWidget)=>{
    //     // if(btnWidget.clickeName == '删除控制点'){
    //     // }else if(btnWidget.clickeName == '添加控制点'){
    //     // }
    // }, {buttons: ['事件1', '事件2']})
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this9;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto3 = animate.prototype;

  _proto3.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    // console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
    if (outPutType == 'codeNode') {
      if (linkedNode._renderSpine != null) {
        var _this$_skins, _this$_animations;

        (_this$_skins = this._skins).splice.apply(_this$_skins, [0, this._skins.length].concat(linkedNode._renderSpine.skins()));

        (_this$_animations = this._animations).splice.apply(_this$_animations, [0, this._animations.length].concat(linkedNode._renderSpine.animations()));
      }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto3.onSelected = function onSelected() {
    this.getEnums();
    this.onAction('播放');
    this.sendOtherEvent('onSelected');
  };

  _proto3.onDeselected = function onDeselected() {
    this.onAction('停止');
    this.sendOtherEvent('onDeselected');
  } //当所有创建物体初始化完成后触发
  ;

  _proto3.onStart = function onStart() {
    _BaseYWNode3.prototype.onStart.call(this);

    console.log('animate onStart', this.properties.autoRun);
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }
  };

  _proto3.onStop = function onStop() {
    this.onAction('停止');
  } // onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex){
  //     console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex)
  //     if(outPutType == 'codeNode'){
  //     }
  //     this.sendConnectEvent(inputIndex, linkedNode, outputIndex)
  // }
  ;

  _proto3.getEnums = function getEnums(autoSetLoop) {
    var linkedNode = this.getRealLinkNode();

    if (linkedNode == null) {
      return;
    }

    if (linkedNode._renderSpine != null) {
      var _this$_skins2, _this$_animations2;

      var eventDit = linkedNode._renderSpine.events(); // console.log('skeletonData events', eventDit)


      (_this$_skins2 = this._skins).splice.apply(_this$_skins2, [0, this._skins.length].concat(linkedNode._renderSpine.skins()));

      (_this$_animations2 = this._animations).splice.apply(_this$_animations2, [0, this._animations.length].concat(linkedNode._renderSpine.animations())); //如果只有一个选项，直接设置默认值


      if (this._skins.length == 1) {
        this.setProperty('skin', this._skins[0]);
      } else {
        //为适配旧版本动画，如果当前设置的playAniName是数值，查询可用的动画名称并设置
        if (Number(this.properties.skin) >= 0) {
          var realSkin = this._skins[Number(this.properties.skin)]; // console.log('我获取到了skin', realSkin, this._skins)


          if (realSkin != null) {
            this.setProperty('skin', realSkin);
          }
        }
      }

      if (this._animations.length == 1) {
        this.setProperty('playAniName', this._animations[0]);

        if (autoSetLoop == true) {
          this.setProperty('loop', true);
          this.setProperty('autoRun', true);
          this.collapse();
        }

        this.createCaidanBtn.disabled = true;
      } else {
        //为适配旧版本动画，如果当前设置的playAniName是数值，查询可用的动画名称并设置
        if (Number(this.properties.playAniName) >= 0) {
          var realAni = this._animations[Number(this.properties.playAniName)];

          if (realAni != null) {
            this.setProperty('playAniName', realAni);
          } else {
            console.log("我还是没有找到自己的动画", linkedNode.properties.customeName, this.properties.playAniName, this._animations);
          }
        }

        this.createCaidanBtn.disabled = false;
      }

      console.log('skeletonData eventssss', eventDit[this.properties.playAniName]);

      for (var _i = 0; _i < this.widgets.length; _i++) {
        if (this.widgets[_i].name.indexOf("音频") == 0) {
          this.widgets.splice(_i, 1);
          _i--;
        }
      }

      if (eventDit[this.properties.playAniName] != null) {
        var events = eventDit[this.properties.playAniName]; // console.log('')
        //添加button来显示事件
        // this.widgets.findIndex((item)=>{
        //     return item.name == 
        // })

        for (var i = 0; i < events.length; i++) {
          this.addWidget('button', '音频：' + events[i].name, "");
        }
      }
    }
  } //创建一个过渡到下一个动画的节点
  ;

  _proto3.createClickToNextAni = function createClickToNextAni() {
    var aniNode = _litegraph.LiteGraph.createNode("objects/animates/animate");

    aniNode.pos = [this.pos[0] + this.width + 3, this.pos[1]];
    this.graph.add(aniNode);
    this.connect(1, aniNode, 1);
    aniNode.connect(0, this, 1);
    aniNode.setProperty('skin', this.properties.skin);
    this.setProperty('playAniName', 'std');
    this.setProperty('loop', true);
    this.setProperty('autoRun', true);

    var curIndex = this._animations.indexOf(this.properties.playAniName);

    curIndex += 1;

    if (this._animations[curIndex] == null) {
      curIndex = 0;
    }

    var newAniName = this._animations[curIndex];
    aniNode.setProperty('playAniName', newAniName);
    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    target.connect(0, aniNode, 0);
  };

  _proto3.previewAni = function previewAni() {
    if (this.graph == null) {
      return;
    }

    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    if (this.properties.playAniName == '') {
      return;
    }

    if (target.codeNode != null) {
      target.codeNode.playAnimation(this.properties.playAniName, this.properties.loop);
    }
  };

  _proto3.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (this.graph == null) {
      return;
    }

    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    } // console.log('curLink', curLink, target)


    if (property == 'skin') {
      if (target.updateSpinePreview != null) {
        target.updateSpinePreview(value);
      }

      if (target.codeNode != null) {
        console.log('修改了皮肤', value);
        target.codeNode.setSkin(value); // 需要通知物体重新获取动画预览
        // target.codeNode.playAnimation(value)
      }
    } else if (property == 'playAniName') {
      //动画还是直接播放cocos渲染的，在蓝图中播放太奇怪了
      if (target.codeNode != null) {
        target.codeNode.playAnimation(value, this.properties.loop);
      }
    } else if (property == 'loop') {
      if (target.codeNode != null) {
        target.codeNode.playAnimation(this.properties.playAniName, value);
      }
    } else if (property == 'timeScale') {
      if (target.codeNode != null) {
        target.codeNode.setAnimationProb('timeScale', value);
      }
    } else if (property == 'canClickOutLine') {// if(target.codeNode != null){
      //     target.codeNode.setOutLine(value)
      // }
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } //当扩展切换
  ;

  _proto3.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {// console.log('onWidgetChanged', name, value, oldValue, widget)
  } //动态返回卡片显示的title
  ;

  _proto3.getTitle = function getTitle() {
    return this.title + ' ' + this.properties.skin + '-' + this.properties.playAniName;
  };

  //暂不清楚用处
  _proto3.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  // 当节点Toggle时调用
  ;

  _proto3.onAction = function onAction(action, param) {
    var _this10 = this;

    // console.log("action", action, param)
    if (action == '播放') {
      this.mode = _litegraph.LiteGraph.ALWAYS;
      var codeNode = this.getInputData(0, true);

      if (codeNode != null) {
        //播放动画关联的声音
        this.playLinkSound(); //播放动画关联的音效

        if (this.properties.soundFx != '无' && this.properties.soundFx != '') {
          cc.assetManager.loadRemote(CocosMgr.rootHost + '/' + this.properties.soundFx, function (err, clip) {
            if (err == null) {
              cc.audioEngine.play(clip, false, 1);
            }
          });
        }

        var modal = this.properties.modal;
        var loop = this.properties.loop;
        var softChange = this.properties.softChange;
        var aniEndCanClick = this.properties.aniEndCanClick;
        var clickWait = this.properties.clickWait;
        this.waitCanClick = false;
        this.hideClickTip();

        if (modal == '全设置' || modal == '仅设置皮肤') {
          codeNode.setSkin(this.properties.skin);
        }

        this._toggleCount = 0;

        if (modal == '全设置' || modal == '仅设置动画') {
          if (this.properties.cancelEvent == true) {
            codeNode.targetOff();
          }

          this.clickWaitOutPut = false;
          this.aniEnd = false;
          codeNode.setAnimationProb('timeScale', this.properties.timeScale);
          codeNode.playAnimation(this.properties.playAniName, loop, softChange, function (trackEntry, event) {
            console.log('我收到spine音频事件', event.data.name, event.intValue, _this10.properties.listenAniEvent, _this10.isInputConnected(3), _this10.graph.status);

            if (_this10.properties.listenAniEvent == false) {
              return;
            }

            if (_this10.isInputConnected(3) == true) {
              //当前已经关联了蓝图中的音频播放
              return;
            } // if(event.intValue < 0){
            //     return
            // }


            if (_this10.graph.status != 2) {
              //STATUS_RUNNING
              //当前没有在运行中
              return;
            } // console.log("这里应该播放spine事件声音:", event.data.name, codeNode.node.name + ':' + trackEntry.animation.name)
            //查找是否有音频节点的资源名称为 event.data.name，如果有就可以直接播放音频了
            //this.codeProgress.playSound(event.data.name ,spineCom.node.name + ':' + trackEntry.animation.name)


            var sounds = _this10.graph.findNodesByType('output/sound');

            var soundName = '';

            if (event.data) {
              soundName = event.data.name;
            }

            var soundNode = sounds.find(function (item) {
              return item.properties.customeName.split('.')[0] == soundName;
            }); // console.log("找到了", sounds, soundNode)

            if (soundNode != null) {
              soundNode.onAction('播放');
            } else {
              if (CocosMgr.isInApp == false) {
                CocosMgr.showAlert(codeNode.node.name + ':' + trackEntry.animation.name + '动画没有相应音频节点:' + soundName);
              } else {
                console.warn('没有对应的音频事件');
              }
            }
          }, function () {
            _this10._toggleCount += 1;

            if (_this10._toggleCount <= _this10.properties.toggleCount) {
              _this10.triggerSlot(0);
            }

            if (_this10.aniEnd != true) {
              if (_this10.isOutputConnected(1) || _this10.properties.aniClickReplay) {
                if (aniEndCanClick == true) {
                  if (_this10.getInputOrProperty('isCanClick') == true) {
                    _this10.showClickTip();
                  } else {
                    if (_this10.hasLinkIsCanClick() == true) {
                      _this10.waitCanClick = true;
                    }
                  }
                }
              }
            }

            _this10.aniEnd = true;

            if (_this10.clickWaitOutPut == true) {
              _this10.triggerSlot(1, codeNode);
            }
          }); // console.log("当前是否需要显示触摸提示",aniEndCanClick, this.isOutputConnected(1) , this.properties.aniClickReplay )

          if (this.isOutputConnected(1) || this.properties.aniClickReplay) {
            //监听点击事件
            codeNode.checkAddComponent('SpinePlusComponent');

            if (aniEndCanClick == false) {
              //如果等于true时是结束才显示
              //看看是否需要显示提示点击
              console.log(this.getRealLinkNode().properties.customeName, '当前是否需要等待显示点击', this.getInputOrProperty('isCanClick'), this.hasLinkIsCanClick());

              if (this.getInputOrProperty('isCanClick') == true) {
                this.showClickTip();
              } else {
                if (this.hasLinkIsCanClick() == true) {
                  this.waitCanClick = true;
                }
              }
            } //一进来就要开始等待时间才能点击
            // if(this.properties.aniClickTimeSpace > 0){
            //     this.curWaitTime = this.properties.aniClickTimeSpace
            // }


            codeNode.on(cc.Node.EventType.TOUCH_END, this.onClick.bind(this));
          }
        }
      } else {
        console.warn('当前没有关联codeNode');
      }
    } else if (action = '停止') {
      this.mode = _litegraph.LiteGraph.ON_EVENT;
      var codeNode = this.getInputData(0, true);
      this.waitCanClick = false;

      if (codeNode != null) {
        codeNode.pauseAnimation();
      }
    } //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  } //点击事件拎出来，方便记录调用
  ;

  _proto3.onClick = function onClick() {
    if (CocosMgr.isInApp == false) {
      if (window.onGraphNodeClick != null) {
        window.onGraphNodeClick({
          nodeId: this.getIdWithGraph(),
          time: this.graph.getTime(),
          funcName: 'onClick'
        });
      }
    }

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('点击的时候codeNode为空了');
      return;
    }

    if (this.graph.config.pause == 1) {
      return;
    }

    if (this.properties.aniEndCanClick == false) {//直接可以点击
    } else {
      //等待动画结束了才能点击
      if (this.aniEnd != true) {
        console.log('点击了但动画没有播放结束');
        return;
      }
    }

    var isCanClick = this.getInputOrProperty('isCanClick'); // console.log(this, "isCanClick", isCanClick, this.properties.aniClickTimeSpace, this.properties.aniClickReplay)

    if (isCanClick != true) {
      //可能为空所以不为true就不响应点击
      return;
    }

    if (this.curWaitTime != null) {
      //当前在等待点击
      console.log('当前需等待点击间隔', this.curWaitTime);
      return;
    }

    if (this.properties.aniClickTimeSpace > 0) {
      this.curWaitTime = this.properties.aniClickTimeSpace;
    }

    codeNode.targetOff();

    if (this.properties.clickWait == true) {
      this.clickWaitOutPut = true;
    } else {
      this.triggerSlot(1, codeNode);
      this.hideClickTip();
    }

    if (this.properties.aniClickReplay == true) {
      this.onAction('播放');
    }
  };

  _proto3.onExecute = function onExecute() {
    if (this.curWaitTime != null) {
      var dt = this.graph.elapsed_time; //in ms
      // console.log('dt', dt)

      this.curWaitTime -= dt;

      if (this.curWaitTime <= 0) {
        // console.log('延迟结束播放了声音', this.curWaitTime)
        this.curWaitTime = null;
      }
    } //等待进入可点击状态再显示触摸提示


    if (this.waitCanClick == true) {
      var isCanClick = this.getInputOrProperty('isCanClick'); // console.log(this, "isCanClick", isCanClick, this.properties.aniClickTimeSpace, this.properties.aniClickReplay)

      if (isCanClick == true) {
        //可能为空所以不为true就不响应点击
        this.showClickTip();
        this.waitCanClick = false;
      }
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return animate;
}(_BaseYwNode.BaseYWNode);

animate.title = '骨骼动画';
animate.modalEnum = ['全设置', '仅设置皮肤', '仅设置动画'];

_litegraph.LiteGraph.registerNodeType("objects/animates/animate", animate); //现在的动画编辑起来还是太复杂，下一步新增记录模式，直接记录object修改的属性并切换


var tween = /*#__PURE__*/function (_BaseYWNode4) {
  _inheritsLoose(tween, _BaseYWNode4);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function tween() {
    var _this11;

    _this11 = _BaseYWNode4.call(this) || this;
    _this11.title = "数值动画";
    _this11.desc = "用于控制节点属性变化";
    _this11.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.serialize_widgets = true
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this11.addInput("物体", "codeNode");

    _this11.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this11.addOutput("结束", _litegraph.LiteGraph.EVENT);

    _this11.addOutput("点击", _litegraph.LiteGraph.EVENT);

    _this11.addProperty('duration', 1, 'number');

    _this11.addWidget('number', '动画时长', _this11.properties.duration, 'duration', {
      precision: 1,
      min: 0,
      max: 60
    });

    _this11.addProperty('delay', 0, 'number');

    _this11.addWidget('number', '延迟播放时间', _this11.properties.delay, 'delay', {
      precision: 1,
      min: 0,
      max: 60
    });

    _this11.addProperty('easing', '无', 'enum');

    _this11.addWidget('combo', '缓动效果', _this11.properties.easing, {
      property: "easing",
      values: tween.easingEnum
    });

    _this11.addProperty('tweenMode', '变化目标值', 'enum');

    _this11.addWidget('combo', '动画模式', _this11.properties.tweenMode, {
      property: "tweenMode",
      values: tween.tweenModeEnum
    });

    _this11.addProperty('dontTween', false, 'boolean');

    _this11.addWidget('toggle', '无动画直接修改值', _this11.properties.dontTween, 'dontTween');

    _this11.addProperty('cancelEvent', false, 'boolean');

    _this11.addWidget('toggle', '取消其他触摸事件', _this11.properties.cancelEvent, 'cancelEvent');

    _this11.addProperty('cancelOtherTween', false, 'boolean');

    _this11.addWidget('toggle', '打断其它数值动画', _this11.properties.cancelOtherTween, 'cancelOtherTween');

    _this11.addProperty('autoRun', false, 'boolean');

    _this11.addWidget('toggle', '是否自动播放', _this11.properties.autoRun, 'autoRun');

    _this11.addProperty('x', 0, 'number');

    _this11.addWidget('number', '坐标-x', _this11.properties.x, 'x', {
      precision: 1
    });

    _this11.addProperty('y', 0, 'number');

    _this11.addWidget('number', '坐标-y', _this11.properties.y, 'y', {
      precision: 1
    });

    _this11.addProperty('scaleX', 1, 'number');

    _this11.scaleXWidget = _this11.addWidget('number', '缩放-x', _this11.properties.scaleX, 'scaleX', {
      precision: 1
    });

    _this11.addProperty('scaleY', 1, 'number');

    _this11.scaleYWidget = _this11.addWidget('number', '缩放-y', _this11.properties.scaleY, 'scaleY', {
      precision: 1
    });

    _this11.addProperty('opacity', 255, 'number');

    _this11.addWidget('number', '透明度', _this11.properties.opacity, 'opacity', {
      precision: 0,
      min: -255,
      max: 255
    });

    _this11.addProperty('angle', 0, 'number');

    _this11.addWidget('number', '角度', _this11.properties.angle, 'angle', {
      min: -360,
      max: 360,
      precision: 0
    });

    _this11.addProperty('anchorX', 0.5, 'number');

    _this11.addWidget('number', '锚点x', _this11.properties.anchorX, 'anchorX', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this11.addProperty('anchorY', 0.5, 'number');

    _this11.addWidget('number', '锚点y', _this11.properties.anchorY, 'anchorY', {
      min: -1,
      max: 1,
      precision: 1,
      step2: 0.1
    });

    _this11.addProperty('width', 50, 'number');

    _this11.widthWidget = _this11.addWidget('number', '宽度', _this11.properties.width, 'width', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this11.addProperty('height', 50, 'number');

    _this11.heightWidget = _this11.addWidget('number', '高度', _this11.properties.height, 'height', {
      precision: 0,
      min: 0,
      max: 9999
    });

    _this11.addProperty('color', '#ffffff', 'string');

    _this11.addWidget('string', '物体颜色', _this11.properties.color, 'color');

    _this11.addProperty("zoomRatio", 1, 'number');

    _this11.addWidget("number", "镜头缩放", _this11.properties.zoomRatio, "zoomRatio", {
      precision: 1,
      min: 1,
      max: 10,
      step2: 0.01
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    //节点配置


    _this11.addProperty('nodeConfig', {
      x: _this11.properties.x,
      y: _this11.properties.y,
      width: _this11.properties.width,
      height: _this11.properties.height,
      anchorX: _this11.properties.anchorX,
      anchorY: _this11.properties.anchorY,
      scaleX: _this11.properties.scaleX,
      scaleY: _this11.properties.scaleY,
      color: _this11.properties.color,
      angle: _this11.properties.angle
    }, 'object');

    _this11.nodeConfigWidget = _this11.addWidget('ccnode', '节点操控', _this11.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    });

    _this11.addWidget('button', '同步目标物体属性', "", function () {
      // this.getEnums()
      _this11.syncTargetValue();

      _this11.sendBtnWidgetClickEvent('同步目标物体属性');
    });

    _this11.addWidget('button', '重置变化多少值', "", function () {
      // this.getEnums()
      _this11.setProperty('x', 0);

      _this11.setProperty('y', 0);

      _this11.setProperty('width', 0);

      _this11.setProperty('height', 0);

      _this11.setProperty('anchorX', 0);

      _this11.setProperty('anchorY', 0);

      _this11.setProperty('scaleX', 0);

      _this11.setProperty('scaleY', 0);

      _this11.setProperty('opacity', 0);

      _this11.setProperty('color', '#000000');

      _this11.setProperty('angle', 0);

      _this11.setProperty('zoomRatio', 0);
    });

    _this11.addWidget('button', '预览动画', "", function () {
      if (_this11.previewTween != null) {
        _this11.syncTargetValue(_this11.previewTween);

        _this11.realRun(_this11.previewTween, '播放');
      }
    }); //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this11;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto4 = tween.prototype;

  _proto4.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    var _this12 = this;

    console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex);

    if (outPutType == 'codeNode') {
      // if(linkedNode._renderSpine != null){
      //     this._skins.splice(0, this._skins.length, ...linkedNode._renderSpine.skins())
      //     this._animations.splice(0, this._animations.length, ...linkedNode._renderSpine.animations())
      // }
      if (linkedNode.type == 'objects/camera') {
        if (linkedNode.codeNode != null) {
          setTimeout(function () {
            _this12.syncTargetValue();
          }, 100);
        }
      }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto4.onSelected = function onSelected() {
    // this.getEnums()
    if (this.previewTween == null) {
      var target = this.getRealLinkNode();

      if (target == null) {
        return;
      }

      if (target.codeNode != null && cc.isValid(target.codeNode.node)) {
        // console.log('target.codeNode', target.codeNode)
        var previewNode = cc.instantiate(target.codeNode.node);
        previewNode.isClone = true;
        previewNode.zIndex = 9999;
        this.previewTween = previewNode.getComponent('CodeNodeLg');

        if (this.previewTween != null) {
          this.previewTween.init();
          this.previewTween.parent = target.codeNode.parent;
          this.previewTween.nodeName += '_preview';
          CocosMgr.syncConfigToCodeNode(this.previewTween, this.properties.nodeConfig);
          this.previewTween.updatePreview();
        } else {
          console.warn('获取到了无效节点', previewNode);
        }
      }
    }

    this.sendOtherEvent('onSelected');
  };

  _proto4.onDeselected = function onDeselected() {
    if (this.previewTween != null) {
      this.previewTween.destroyNode();
      this.previewTween = null;
    }
  } //当所有创建物体初始化完成后触发
  ;

  _proto4.onStart = function onStart() {
    console.log('animate onStart', this.properties.autoRun);
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }

    _BaseYWNode4.prototype.onStart.call(this);
  };

  _proto4.onStop = function onStop() {
    this.onAction('停止');
  } //当扩展切换
  // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     // var curLink = this.getInputLink(0)
  //     // if(curLink == null){
  //     //     return
  //     // }
  //     // var target = this.graph.getNodeById(curLink.origin_id)
  //     // if(target == null){
  //     //     return
  //     // }
  //     // // console.log('curLink', curLink, target)
  //     // if(name == '选择皮肤'){
  //     // }
  // }
  //全部放置在canvas下
  //在子蓝图中无法获取到连接的物体，需要多一层查找
  // getRealLinkNode(){
  //     var curLink = this.getInputLink(0)
  //     if(curLink == null){
  //         return null   
  //     }
  //     if(this.graph._is_subgraph == true){
  //         let inputNode = this.graph.getNodeById(curLink.origin_id)
  //         let inputIndex = this.graph._subgraph_node.inputs.findIndex((solt)=>{
  //         return solt.name == inputNode.properties.name
  //         })
  //     //    console.log('getRealLinkNode', inputIndex, inputNode.properties.name, this.graph._subgraph_node.inputs)
  //         if(inputIndex != -1){
  //         let exLink = this.graph._subgraph_node.getInputLink(inputIndex)
  //         if(exLink == null){
  //             return null
  //         }
  //         return this.graph._subgraph_node.graph.getNodeById(exLink.origin_id)
  //         }
  //     }else{
  //         return this.graph.getNodeById(curLink.origin_id)
  //     }
  // }
  // 获取id，如果当前是在子图下，加上子图节点的id
  // getIdWithGraph(){
  //     if(this.graph == null){
  //     return this.id
  //     }
  //     if(this.graph._subgraph_node != null){
  //     return this.id + '_' + this.graph._subgraph_node.id
  //     }
  //     return this.id
  // }
  ;

  _proto4.syncTargetValue = function syncTargetValue(codeNode) {
    var target = this.getRealLinkNode();

    if (target == null) {
      return;
    }

    if (target.widgets) {
      // console.log('syncTargetValue',target.widgets)
      for (var i = 0; i < target.widgets.length; i++) {
        var targetWidget = target.widgets[i];

        if (targetWidget.type == 'ccnode') {
          for (var key in targetWidget.value) {
            var _index = this.widgets.findIndex(function (w) {
              return w.options.property == key;
            });

            if (_index != -1) {
              if (codeNode != null) {
                codeNode[this.widgets[_index].options.property] = targetWidget.value[key];
              } else {
                this.widgets[_index].setValue(targetWidget.value[key], {
                  e: null,
                  node: this,
                  canvas: null
                });
              }
            }
          }

          continue;
        }

        var index = this.widgets.findIndex(function (w) {
          return w.name == targetWidget.name;
        });

        if (index != -1) {
          if (codeNode != null) {
            codeNode[this.widgets[index].options.property] = targetWidget.value;
          } else {
            this.widgets[index].setValue(targetWidget.value, {
              e: null,
              node: this,
              canvas: null
            });
          }
        }
      }
    }
  };

  _proto4.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }

        if (property == 'zoomRatio' && value != 0) {
          if (this.nodeConfigWidget.value['scaleX'] != null) {
            this.nodeConfigWidget.value['scaleX'] = 1 / value;
            this.properties.nodeConfig['scaleX'] = 1 / value;
            this.nodeConfigWidget.value['scaleY'] = 1 / value;
            this.properties.nodeConfig['scaleY'] = 1 / value;
          }

          this.scaleXWidget.value = 1 / value;
          this.scaleYWidget.value = 1 / value;
          this.properties.scaleX = 1 / value;
          this.properties.scaleY = 1 / value;
        }
      }
    }

    if (this.previewTween != null) {
      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config, value)


      CocosMgr.syncConfigToCodeNode(this.previewTween, config);
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  _proto4.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {// var property = widget.options.property
    // console.log('onWidgetChanged', name, value, oldValue, property)
    // if(property != 'nodeConfig'){
    //     //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
    //     if(typeof this.nodeConfigWidget.value == 'object'){
    //         if(this.nodeConfigWidget.value[property] != null){
    //             this.nodeConfigWidget.value[property] = value
    //             this.properties.nodeConfig[property] = value
    //             // console.log('修改了nodeCondig的颜色值', this.nodeConfigWidget.value)
    //         }
    //         if(property == 'zoomRatio'){
    //             if(this.nodeConfigWidget.value['scaleX'] != null){
    //                 this.nodeConfigWidget.value['scaleX'] = 1 /  value
    //                 this.properties.nodeConfig['scaleX'] = 1 / value
    //                 this.nodeConfigWidget.value['scaleY'] = 1 /  value
    //                 this.properties.nodeConfig['scaleY'] = 1 /  value
    //             }
    //             this.scaleXWidget.value = 1 /  value
    //             this.scaleYWidget.value = 1 /  value
    //             this.properties.scaleX = 1 /  value
    //             this.properties.scaleY = 1 /  value
    //         }
    //     }
    // }
    // console.log('onWidgetChanged', name, value, oldValue, widget)
    // if(this.previewTween != null){
    //     var config = {}
    //     if(property == 'nodeConfig'){
    //         config = {...value}
    //     }else{
    //         config[property] = this.properties[property]
    //     }
    //     // console.log('更新节点配置', config, value)
    //     CocosMgr.syncConfigToCodeNode(this.previewTween, config)
    // }
  } //动态返回卡片显示的title
  // getTitle() {
  //    return this.title
  // };
  //暂不清楚用处
  ;

  _proto4.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto4.realRun = function realRun(codeNode) {
    var _this13 = this;

    var delay = this.properties.delay;
    var duration = this.properties.duration;
    var easing = this.properties.easing;
    var dontTween = this.properties.dontTween;
    var cancelOtherTween = this.properties.cancelOtherTween;
    var cancelEvent = this.properties.cancelEvent;
    var tweenMode = this.properties.tweenMode;

    var props = _extends({}, this.properties.nodeConfig); // console.log('当前的颜色值', props.color)


    var color = cc.Color.WHITE.fromHEX(props.color);
    props.r = color.getR();
    props.g = color.getG();
    props.b = color.getB();
    props.opacity = this.properties.opacity;
    delete props['color']; // let props = {x:this.properties.x, y: this.properties.y}
    //构建缓动模式

    if (easing != '无') {
      var index = tween.easingEnum.indexOf(easing);

      if (index != -1) {
        easing = {
          easing: tween.easingConfig[index]
        };
      } else {
        easing = {};
      }
    } else {
      easing = {};
    }

    this.aniEnd = false;
    this.inRun = true;

    if (cancelOtherTween == true) {
      cc.Tween.stopAllByTarget(codeNode);
      cc.Tween.stopAllByTarget(codeNode.node); //有的脚本组件是直接控制node的动画的，也要取消掉
    }

    if (cancelEvent == true) {
      codeNode.targetOff();
    }

    if (dontTween == true) {
      this.aniEnd = true;
      this.inRun = false;
      CocosMgr.syncConfigToCodeNode(codeNode, props);
    } else {
      console.log('开始播放动画', duration, JSON.parse(JSON.stringify(props)), easing);
      this.tweenTag = 'tween_' + this.getIdWithGraph();
      console.log('当前graphid tweenTag', this.graph.id, this.tweenTag);
      cc.Tween.stopAllByTag(this.tweenTag);

      if (codeNode.camera != null) {
        props['zoomRatio'] = this.properties.zoomRatio;
      }

      if (tweenMode == '变化目标值') {
        //变化到目标值，剔除不需要改变的属性
        console.log('目标值');
        CocosMgr.xorConfig(codeNode, props);
        console.log('剔除掉之后的值', props);
        this.tween = cc.tween(codeNode).tag(this.tweenTag).delay(delay).to(duration, props, easing).call(function () {
          _this13.triggerSlot(0, codeNode);

          _this13.aniEnd = true;
          _this13.inRun = false;
        }).start();
      } else if (tweenMode == '变化多少值') {
        CocosMgr.xorConfigZeroValue(props);
        console.log('剔除掉0值之后的值', props);
        this.tween = cc.tween(codeNode).tag(this.tweenTag).delay(delay).by(duration, props, easing).call(function () {
          _this13.triggerSlot(0, codeNode);

          _this13.aniEnd = true;
          _this13.inRun = false;
        }).start();
      }
    }

    if (this.isOutputConnected(1)) {
      //监听点击事件
      codeNode.checkAddComponent('SpinePlusComponent');
      codeNode.on(cc.Node.EventType.TOUCH_END, this.onClick.bind(this));
    }
  } // 当节点Toggle时调用
  ;

  _proto4.onAction = function onAction(action, param) {
    // console.log("action", action, param)
    if (action == '播放') {
      var codeNode = this.getInputData(0, true); // console.log('当前tween目标物体', codeNode)

      if (codeNode != null) {
        this.realRun(codeNode);
      } else {
        console.warn('当前没有关联codeNode');
      }
    } else if (action == '停止') {
      this.tweenTag = 'tween_' + this.getIdWithGraph();
      cc.Tween.stopAllByTag(this.tweenTag);
    } //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器

  };

  _proto4.onClick = function onClick() {
    if (CocosMgr.isInApp == false) {
      if (window.onGraphNodeClick != null) {
        window.onGraphNodeClick({
          nodeId: this.getIdWithGraph(),
          time: this.graph.getTime(),
          funcName: 'onClick'
        });
      }
    }

    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('点击时codeNode == null');
      return;
    }

    if (this.graph.config.pause == 1) {
      return;
    }

    if (this.aniEnd == true) {
      codeNode.targetOff();
      this.triggerSlot(1, codeNode);
    }
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return tween;
}(_BaseYwNode.BaseYWNode);

tween.title = '数值动画';
tween.easingEnum = ['无', '淡入', '淡出', '淡入淡出', '回弹', '弹跳'];
tween.easingConfig = ['none', 'quadIn', 'quadOut', 'quadInOut', 'backOut', 'bounceOut'];
tween.tweenModeEnum = ['变化目标值', '变化多少值'];

_litegraph.LiteGraph.registerNodeType("objects/animates/tween", tween);

var bezierCurve = /*#__PURE__*/function (_BaseYWNode5) {
  _inheritsLoose(bezierCurve, _BaseYWNode5);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function bezierCurve() {
    var _this14;

    _this14 = _BaseYWNode5.call(this) || this;
    _this14.title = "路径动画";
    _this14.desc = "用于控制节点进行曲线移动";
    _this14.mode = _litegraph.LiteGraph.ON_EVENT; //设置触发模式
    // this.serialize_widgets = true
    // this.size = [80, 30];               //设置默认节点尺寸
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    //   this.addInput("B", "number")
    // this.addOutput("bool", "boolean")   //增加一个输出触点，  输出节点的名称， 值类型
    // this.addProperty("msg", "");   //增加一个变量，    变量名称， 变量名称

    _this14.addInput("物体", "codeNode");

    _this14.addInput("长度", 'number');

    _this14.addInput("播放", _litegraph.LiteGraph.ACTION);

    _this14.addInput("重置位置", _litegraph.LiteGraph.ACTION);

    _this14.addOutput("结束", _litegraph.LiteGraph.EVENT); // this.addOutput("点击", LiteGraph.EVENT);


    _this14.addProperty('points', [0, 0, 200, 200, 400, 0], 'array');

    _this14.curveWidget = _this14.addWidget('curve', '曲线控制点', _this14.properties.points, 'points', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight
    }); // this.addProperty('selectPoint', 0, 'number')

    _this14.selectCtrl = _this14.addWidget('number', '选择控制点', -1, function (value) {
      // console.log('选择控制点', value)
      _this14.properties.selectPoint = value;
      _this14.curveWidget.selectPoint = value;
    }, {
      precision: 0,
      min: -1,
      max: _this14.properties.points.length / 2 - 1
    });

    _this14.addWidget('button', '', "", function (btnWidget) {
      if (btnWidget.clickeName == '删除控制点') {
        _this14.curveWidget.remonveCtrlPoint(_assertThisInitialized(_this14));

        _this14.selectCtrl.options.max = _this14.properties.points.length / 2 - 1;
      } else if (btnWidget.clickeName == '添加控制点') {
        _this14.curveWidget.addCtrlPoint(_assertThisInitialized(_this14)); // console.log('this.properties.points.length', this.properties.points.length)


        _this14.selectCtrl.options.max = _this14.properties.points.length / 2 - 1;
      }
    }, {
      buttons: ['删除控制点', '添加控制点']
    }); // this.addWidget('button','删除选中控制点', "", ()=>{
    //     this.curveWidget.remonveCtrlPoint(this)
    //     // console.log('this.properties.points.length', this.properties.points.length)
    //     this.selectCtrl.options.max = this.properties.points.length / 2 - 1
    // })
    // this.addWidget('button','添加控制点', "", ()=>{
    // })
    // this.addWidget('number', '曲线控制点', this.properties.duration, 'duration',  {precision: 1, min: 0, max: 60})


    _this14.addProperty('startT', 0, 'number');

    _this14.addWidget('slider', '起始位置', _this14.properties.startT, 'startT', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    });

    _this14.addProperty('endT', 1, 'number');

    _this14.addWidget('slider', '终点位置', _this14.properties.endT, 'endT', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    }); // this.addProperty('easing', '无', 'enum')
    // this.addWidget('combo', '缓动效果', this.properties.easing, {property: "easing", values: tween.easingEnum })


    _this14.addProperty('aniType', '随步长', 'enum');

    _this14.addWidget('combo', '动画模式', _this14.properties.aniType, {
      property: "aniType",
      values: bezierCurve.tweenModeEnum
    }); // 【随步长】输入一次根据步长增加移动位置的百分比，不停的输入直至移动到终点位置\n
    // 【随时间】输入后自动根据时间从起始位置运行到终点位置\n 
    // 【随长度】根据输入的数值移动对应长度


    _this14.addProperty('duration', 1, 'number');

    _this14.durationWidget = _this14.addWidget('slider', '动画时长', _this14.properties.duration, 'duration', {
      precision: 1,
      min: 0,
      max: 60,
      step2: 0.1
    });

    _this14.addProperty('oneStep', 0.01, 'number');

    _this14.oneStepWidget = _this14.addWidget('slider', '动画步长', _this14.properties.oneStep, 'oneStep', {
      precision: 2,
      min: 0,
      max: 1,
      step2: 0.01
    });

    _this14.addProperty('lookUp', false, 'boolean');

    _this14.addWidget('toggle', '角度跟随路径', _this14.properties.lookUp, 'lookUp');

    _this14.addProperty('startResetT', false, 'boolean');

    _this14.addWidget('toggle', '开始运行时重置', _this14.properties.startResetT, 'startResetT');

    _this14.addProperty('autoRun', false, 'boolean');

    _this14.addWidget('toggle', '是否自动播放', _this14.properties.autoRun, 'autoRun');

    _this14.addWidget('button', '预览动画', "", function () {
      if (_this14.previewTween != null) {
        _this14.realRun(_this14.previewTween, '播放');
      }
    }); //节点配置
    // this.addProperty('nodeConfig',  {
    //     x: this.properties.x, 
    //     y: this.properties.y,
    //     width: this.properties.width,
    //     height: this.properties.height,
    //     anchorX: this.properties.anchorX,
    //     anchorY: this.properties.anchorY,
    //     scaleX: this.properties.scaleX,
    //     scaleY: this.properties.scaleY,
    //     color: this.properties.color,
    //     angle:  this.properties.angle,
    // }, 'object')
    // this.nodeConfigWidget = this.addWidget('ccnode', '节点操控', this.properties.nodeConfig, 'nodeConfig',  { viewWidth: CocosMgr.designViewWidth, viewHeight: CocosMgr.designViewHeight })
    // this.addWidget('button','同步目标物体属性', "", ()=>{
    //     // this.getEnums()
    //     this.syncTargetValue()
    // })
    //仅设置皮肤时，不会影响当前动画播放状态，结束和点击将不会进行输出，也不会取消原来动画绑定的点击事件结束事件
    //当多个Spine类型的物体连接到这个组件，可以实现一个此Robot控制多个物体播放相同的动画
    // this.widget = this.addWidget("text", "Text", "", "msg");
    // this.widgets_up = true;
    // this.size = [200, 30];
    //   this.progress = 0.5               //设置节点的进度，一般来说用于在执行的时候设置
    // this.widget = this.addWidget("toggle","value",true,"value");
    //   this.widget = this.addWidget("number","value",1,"value");  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称
    //  this.serialize_widgets = true; //widget的值是否也可以被序列化，weidget值和Property中的值不是绑定的，如果初始时不一致，就会出现weidget显示的不是真实的值，所以建议绑定
    // this.widgets_up = true;                                    //设置输入组件在顶部（覆盖input和output）
    //   this.properties.precision = 1


    return _this14;
  } // Function to call when the node is executed
  //执行时的方法
  // onExecute() {
  // console.log("consoleInfo onExecute")
  //   var A = this.getInputData(0)
  //可以反向获取输入的值，不需要被动输入值，目前看来确实更合理
  // var msg = this.getInputData(0); //getInputDataByName("msg");
  // console.log('consoleInfo:', msg);
  // if (!msg) msg = this.properties.msg;
  // if (msg != null && typeof msg != "undefined") {
  //     this.properties.msg = msg;
  // }
  // }
  // onSelected(){
  //     console.log("consoleInfo onSelected")
  // }
  //连接到物体时从物体上获取动画信息


  var _proto5 = bezierCurve.prototype;

  _proto5.onConnectInput = function onConnectInput(inputIndex, outPutType, output, linkedNode, outputIndex) {
    console.log('onConnectInput', inputIndex, outPutType, output, linkedNode, outputIndex);

    if (outPutType == 'codeNode') {// if(linkedNode._renderSpine != null){
      //     this._skins.splice(0, this._skins.length, ...linkedNode._renderSpine.skins())
      //     this._animations.splice(0, this._animations.length, ...linkedNode._renderSpine.animations())
      // }
    }

    this.sendConnectEvent(inputIndex, linkedNode, outputIndex);
  };

  _proto5.onAdded = function onAdded() {
    this.updateWidght();
    this.sendAddEvent();
  };

  _proto5.onConfigure = function onConfigure() {
    this.updateWidght();
  } // onConfigure(){
  //     // this.getEnums()
  // }
  ;

  _proto5.onSelected = function onSelected() {
    // this.getEnums()
    if (this.previewTween == null) {
      var target = this.getRealLinkNode();

      if (target == null) {
        return;
      }

      if (target.codeNode != null && cc.isValid(target.codeNode.node)) {
        var previewNode = cc.instantiate(target.codeNode.node);
        previewNode.isClone = true;
        previewNode.zIndex = 9999;
        this.previewTween = previewNode.getComponent('CodeNodeLg');
        this.previewTween.init();
        this.previewTween.parent = target.codeNode.parent;
        this.previewTween.curve = new _bezier.Bezier(this.properties.points);
        this.length = this.previewTween.curve.length();
        this.previewTween.t = this.properties.startT; // CocosMgr.syncConfigToCodeNode(this.previewTween, this.properties.nodeConfig)
      }
    }

    this.sendOtherEvent('onSelected');
  };

  _proto5.onDeselected = function onDeselected() {
    if (this.previewTween != null) {
      this.previewTween.destroyNode();
      this.previewTween = null;
    }
  } //当所有创建物体初始化完成后触发
  ;

  _proto5.onStart = function onStart() {
    console.log('animate onStart', this.properties.autoRun);
    this.length = new _bezier.Bezier(this.properties.points).length() * 2;
    this.t = 0;
    var autoRun = this.properties.autoRun;

    if (autoRun == true) {
      this.onAction('播放');
    }

    _BaseYWNode5.prototype.onStart.call(this);
  };

  _proto5.onStop = function onStop() {
    this.onAction('停止');
  };

  _proto5.updateWidght = function updateWidght() {
    var aniType = this.properties.aniType;
    this.durationWidget.disabled = false;
    this.oneStepWidget.disabled = false;

    if (aniType == '随长度') {
      this.durationWidget.disabled = true;
      this.oneStepWidget.disabled = true;
    } else if (aniType == '随时间') {
      this.oneStepWidget.disabled = true;
    } else if (aniType == '随步长') {
      this.durationWidget.disabled = true;
    }
  };

  _proto5.onWidgetChanged = function onWidgetChanged(name, value, oldValue, widget) {
    var property = widget.options.property; // console.log('onWidgetChanged', name, value, oldValue, property)

    if (property != 'nodeConfig') {//  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      // if(typeof this.nodeConfigWidget.value == 'object'){
      //     if(this.nodeConfigWidget.value[property] != null){
      //         this.nodeConfigWidget.value[property] = value
      //         this.properties.nodeConfig[property] = value
      //         // console.log('修改了nodeCondig的颜色值', this.nodeConfigWidget.value)
      //     }
      // }
    }

    if (name == '动画模式') {
      this.updateWidght();
    }

    if (name == '曲线控制点') {
      this.properties.points = value;
      this.selectCtrl.value = this.curveWidget.selectPoint;

      if (this.previewTween != null) {
        this.previewTween.curve = new _bezier.Bezier(this.properties.points);
        this.length = this.previewTween.curve.length();
        this.previewTween.t = this.properties.startT;
      } else {
        console.log('当前没有previewTween');
      }
    }

    if (name == '起始位置' || name == '终点位置') {
      if (this.previewTween != null) {
        this.previewTween.t = this.properties.startT;
      }
    } // if(this.previewTween != null){
    //     var config = {}
    //     if(property == 'nodeConfig'){
    //         config = {...value}
    //     }else{
    //         config[property] = this.properties[property]
    //     }
    //     // console.log('更新节点配置', config, value)
    //     CocosMgr.syncConfigToCodeNode(this.previewTween, config)
    // }

  } //动态返回卡片显示的title
  // getTitle() {
  //    return this.title
  // };
  //暂不清楚用处
  ;

  _proto5.setValue = function setValue(v) {
    this.setProperty("value", v);
  } // 获取可以接受的输入
  // onGetInputs() {
  // 	return [
  //         ["log", LiteGraph.ACTION],
  //         ["warn", LiteGraph.ACTION],
  //         ["error", LiteGraph.ACTION]
  //     ];
  // };
  ;

  _proto5.realRun = function realRun(codeNode, action) {
    var _this15 = this;

    if (action == '播放') {
      var duration = this.properties.duration;
      var lookUp = this.properties.lookUp;
      var aniType = this.properties.aniType;
      var startResetT = this.properties.startResetT;
      var endT = this.properties.endT; // '随步长','随时间','随长度'

      codeNode.lookUp = lookUp;

      if (codeNode.curve == null) {
        var curve = new _bezier.Bezier(this.properties.points);
        this.length = curve.length();
        codeNode.curve = curve;
      }

      if (aniType == '随长度') {
        var value = this.getInputData(1) || 0;
        var oneStep = value / this.length;
        console.log('输入的value / lenght', value, this.length, oneStep);
        codeNode.t += oneStep;
      } else if (aniType == '随步长') {
        var _oneStep = this.properties.oneStep;
        codeNode.t += _oneStep * 0.01;
      } else if (aniType == '随时间') {
        if (startResetT == true) {
          codeNode.t = this.properties.startT;
        }

        cc.Tween.stopAllByTag(this.tweenTag);
        this.tweenTag = 'curve_' + codeNode.node._id;
        cc.tween(codeNode).tag(this.tweenTag).to(duration, {
          t: endT
        }).call(function () {
          // this.outputHandle('number1', codeNode)
          _this15.triggerSlot(0, codeNode);
        }).start(); // console.log('运行了动画', tween.tag, duration, this.properties.startT, endT)
      }

      this.t = codeNode.t;

      if (codeNode.t == 1) {
        this.triggerSlot(0, codeNode);
      }
    } else if (action == '重置位置') {
      //重置位置
      this.end = false;
      var curve = new _bezier.Bezier(this.properties.points);
      this.length = curve.length();
      codeNode.curve = curve;
      codeNode.t = this.properties.startT * 0.01;
    } else if (action == '停止') {
      cc.Tween.stopAllByTag(this.tweenTag);
    }
  } // 当节点Toggle时调用
  ;

  _proto5.onAction = function onAction(action, param) {
    // console.log("action", action, param)
    var codeNode = this.getInputData(0, true);

    if (codeNode == null) {
      console.warn('当前没有关联codeNode');
      return;
    }

    this.realRun(codeNode, action); //暂时调用网页提醒
    //提供接入cocos的提示，或者是ant的消息提示
    //需要一个统一的接入管理器
  } //自定义触点显示的文字
  // onDrawBackground(ctx) {
  //     //show the current value
  //     this.outputs[0].label = this.properties["value"] ? '真' : '假'
  // };
  //使用ctx绘制需要显示的内容
  // onDrawForeground(ctx){
  //     var size = this.size[1] * 0.5;
  //     var h = this.size[1] * 0.8;
  //     ctx.textAlign = "left";
  //     ctx.fillStyle = "#AAA";
  //     ctx.fillText('测试绘制文字', size * 1.2, h * 0.85);
  //     ctx.textAlign = "left";
  //     // this.outputs[0].label = this.properties["value"].toFixed(2);
  // }
  ;

  return bezierCurve;
}(_BaseYwNode.BaseYWNode);

bezierCurve.title = '路径动画'; // bezierCurve.easingEnum = ['无','淡入','淡出','淡入淡出','回弹','弹跳']
// bezierCurve.easingConfig = ['none', 'quadIn', 'quadOut', 'quadInOut', 'backOut', 'bounceOut']

bezierCurve.tweenModeEnum = ['随步长', '随时间', '随长度'];

_litegraph.LiteGraph.registerNodeType("objects/animates/bezierCurve", bezierCurve); //自定义脚本组件


var camera = /*#__PURE__*/function (_BaseYWNode6) {
  _inheritsLoose(camera, _BaseYWNode6);

  // Name to show
  //不会在显示节点中用到，仅仅在代码中的解释
  // color= '#510'
  function camera() {
    var _this16;

    _this16 = _BaseYWNode6.call(this) || this; // this.serialize_widgets = true
    // this.mode = LiteGraph.ON_EVENT;     //设置触发模式
    // this.size = [80, 20];               //设置默认节点尺寸
    // this.getInputData(0, true)
    // this.addInput("触发", "number")   //增加一个输入触点，  输入触点的名称， 值类型
    // this.addInput("scale", "number")
    // this.addProperty("scale", 0, 'number');   //增加一个变量，    变量名称， 变量名称
    // this.addWidget("number","缩放倍数", this.properties.scale ,"scale", {precision: 1});  //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)

    _this16.title = "镜头";
    _this16.desc = "在绘本中使用镜头位移效果";
    _this16.color = '#3F42EA';
    _this16.priority = -999; //放在最前执行

    _this16.widgets_up = true; // this.addInput("启用", LiteGraph.ACTION);
    // this.addInput("隐藏", LiteGraph.ACTION);

    _this16.addOutput("物体", 'codeNode');

    _this16.addProperty('x', 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget('number', '坐标-x', _this16.properties.x, 'x', {
      precision: 1
    });

    _this16.addProperty("y", 0, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget('number', '坐标-y', _this16.properties.y, 'y', {
      precision: 1
    });

    _this16.addProperty("zoomRatio", 1, 'number'); //增加一个变量，    变量名称， 变量名称


    _this16.addWidget("number", "镜头缩放", _this16.properties.zoomRatio, "zoomRatio", {
      precision: 1,
      min: 1,
      max: 10,
      step2: 0.01
    }); //增加一个控件用于修改变量，  类型，显示名称，默认值，要修改的变量的名称)
    //节点配置


    _this16.addProperty('nodeConfig', {
      x: 0,
      y: 0,
      width: CocosMgr.designViewWidth,
      height: CocosMgr.designViewHeight,
      anchorX: 0.5,
      anchorY: 0.5,
      scaleX: 1,
      scaleY: 1,
      color: '#3F42EA',
      angle: 0
    }, 'object'); ////仅仅绘制边框


    _this16.nodeConfigWidget = _this16.addWidget('ccnode', '节点操控', _this16.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight,
      justDrawBorder: true,
      borderColor: '#3F42EA'
    });

    _this16.addWidget('button', '重置到默认状态', "", function () {
      // console.log("点击了重置属性")
      _this16.setProperty('x', 0);

      _this16.setProperty('y', 0);

      _this16.setProperty('zoomRatio', 1);
    });

    return _this16;
  } //创建一个物体


  var _proto6 = camera.prototype;

  _proto6.createObj = function createObj(loadCb) {
    if (this.codeNode != null) {
      // console.log('我删除了旧的codeNode', this.codeNode.node._id)
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);

      if (this.cameraUi != null) {
        if (cc.isValid(this.cameraUi)) {
          this.cameraUi.destroy();
          this.cameraUi = null;
        }
      }
    }

    if (this.codeNode != null) {
      if (cc.isValid(this.codeNode.node) == true) {
        // if(CocosMgr.isInApp == true){
        //不重复生成，仅仅重置所有参数
        var config = _extends({}, this.properties.nodeConfig);

        config.zoomRatio = this.properties.zoomRatio; // console.log('更新节点配置', config, value)

        CocosMgr.syncConfigToCodeNode(this.codeNode, config);

        if (loadCb != null) {
          loadCb();
        }

        this.setOutputData(0, this.codeNode);
        return;
      }

      this.codeNode = null;
      this.setOutputData(0, null);
    }

    var config = _extends({}, this.properties.nodeConfig);

    var rootccNode = this.graph.vars.rootccNode;

    if (rootccNode != null) {
      config['parent'] = rootccNode;
    } // console.log('createObj config', config)  //调用一个创建物体的配置


    this.codeNode = CocosMgr.createObj(config, loadCb);
    this.codeNode.nodeName = 'Camera'; // console.error("是否创建真实camera", CocosMgr.isPreviewMode, rootccNode)

    if (CocosMgr.isPreviewMode == true) {
      var ctx = this.codeNode.checkAddComponent(cc.Graphics);
      this.codeNode.ctx = ctx;
      this.codeNode.zIndex = 99999;
      this.codeNode.updatePreview();
    } else {
      //添加摄像机组件 
      var _camera2 = this.codeNode.checkAddComponent(cc.Camera);

      _camera2.cullingMask = -31; //特殊配置

      _camera2.clearFlags = 6;
      this.codeNode.camera = _camera2;
      this.codeNode.zoomRatio = this.properties.zoomRatio; // camera.enabled = false
      //还要添加ui camera

      if (CocosMgr.isInApp) {
        var node2 = new cc.Node();
        node2.parent = this.codeNode.node.parent;
        node2.name = 'New 2D Camera';
        var cameraUi = node2.addComponent(cc.Camera);
        cameraUi.cullingMask = 24;
        cameraUi.clearFlags = 6;
        cameraUi.depth = 2; // cameraUi.enabled = false

        this.cameraUi = node2;
      }
    } // console.log('我创建了的codeNode',  this.codeNode.node._id)


    this.setOutputData(0, this.codeNode);
    return this.codeNode;
  };

  _proto6.onAdded = function onAdded() {
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      ///只在编辑器中的时候会创建
      this.createObj();
    }

    this.sendAddEvent();
  };

  _proto6.onSelected = function onSelected() {
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      this.createObj();
    }

    this.sendOtherEvent('onSelected');
  };

  _proto6.updateOutputData = function updateOutputData(slot) {
    // console.log('我收到了更新物体的事件', slot)
    if (this.codeNode == null && CocosMgr.isInApp == false) {
      this.createObj();
    }

    this.setOutputData(slot, this.codeNode);
  } // onSelected(){
  //     // this.getEnums()
  //     // if(this.previewTween == null){
  //     //     var config = {...this.properties.nodeConfig}
  //     //     this.previewTween = CocosMgr.createObj(config)
  //     //     this.previewTween.nodeName = '镜头预览'
  //     //     var ctx = this.previewTween.addComponent(cc.Graphics)
  //     //     this.previewTween.ctx = ctx
  //     //     this.previewTween.zIndex = 10000
  //     //     this.previewTween.updatePreview()
  //     // }
  //     if(this.codeNode != null){
  //     }
  // }
  // onDeselected(){
  //     if(this.previewTween != null){
  //         this.previewTween.destroyNode()
  //         this.previewTween = null
  //     }
  // }
  //在不同的蓝图切换，需要查询是否存在预览节点，不存在的话就创建
  //当lagraph attach时此node可能还未创建，所以不能
  // onAttachCanvas(){
  //     console.log('onAttachCanvas', this.properties.customeName )
  //     this.createObj()
  // }
  // onDetachCanvas(){
  //     console.log('onDetachCanvas', this.properties.customeName )
  //     if(this.codeNode != null){
  //         this.codeNode.destroyNode()
  //         this.codeNode = null
  //     }
  // }
  ;

  _proto6.onStartBeforeLoad = function onStartBeforeLoad() {};

  _proto6.onStart = function onStart() {
    this.createObj();
  };

  _proto6.onPause = function onPause() {
    if (this.codeNode != null) {
      cc.director.getActionManager().pauseTarget(this.codeNode);
    }
  };

  _proto6.onResume = function onResume() {
    if (this.codeNode != null) {
      cc.director.getActionManager().resumeTarget(this.codeNode);
    }
  };

  _proto6.onStop = function onStop() {
    //这里不能重制，重置参数的时候截图会闪烁
    if (this.codeNode != null && CocosMgr.isInApp == false) {
      var config = _extends({}, this.properties.nodeConfig);

      config.zoomRatio = this.properties.zoomRatio; // console.log('更新节点配置', config, value)

      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }
  };

  _proto6.onRemoved = function onRemoved() {
    // console.log('我从graph中移除了', this.properties.customeName)
    if (this.codeNode != null) {
      this.codeNode.destroyNode();
      this.codeNode = null;
      this.setOutputData(0, null);
    }

    if (this.cameraUi != null) {
      if (cc.isValid(this.cameraUi)) {
        this.cameraUi.destroy();
        this.cameraUi = null;
      }
    }

    this.sendRemoveEvent();
  };

  _proto6.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    if (property != 'nodeConfig') {
      //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
      if (typeof this.nodeConfigWidget.value == 'object') {
        if (this.nodeConfigWidget.value[property] != null) {
          this.nodeConfigWidget.value[property] = value;
          this.properties.nodeConfig[property] = value;
        }

        if (property == 'zoomRatio') {
          if (this.nodeConfigWidget.value['scaleX'] != null) {
            this.nodeConfigWidget.value['scaleX'] = 1 / value;
            this.properties.nodeConfig['scaleX'] = 1 / value;
            this.nodeConfigWidget.value['scaleY'] = 1 / value;
            this.properties.nodeConfig['scaleY'] = 1 / value;
          }
        }
      }
    }

    if (this.codeNode != null) {
      var config = {};

      if (property == 'nodeConfig') {
        config = _extends({}, value);
      } else {
        config[property] = this.properties[property];
      } // console.log('更新节点配置', config)


      CocosMgr.syncConfigToCodeNode(this.codeNode, config);
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     var property = widget.options.property
  // }
  // 当节点Toggle时调用
  // onAction(action, param)
  // {
  //    if(action == '修改'){
  //    }
  // }
  ;

  return camera;
}(_BaseYwNode.BaseYWNode);

camera.title = '镜头';

_litegraph.LiteGraph.registerNodeType("objects/camera", camera);

var connection = /*#__PURE__*/function (_BaseYWNode7) {
  _inheritsLoose(connection, _BaseYWNode7);

  // Name to show
  function connection() {
    var _this17;

    _this17 = _BaseYWNode7.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this17.title = "连接零件";
    _this17.desc = "将一个物体设置为另一个物体的子物体";
    _this17.mode = _litegraph.LiteGraph.ON_EVENT;

    _this17.addInput("关联父物体", 'codeNode');

    _this17.addInput("关联子物体", 'codeNode'); // this.addOutput("A", -1);
    // this.addProperty("customeName",'A','string');
    // this.addWidget('string','发送事件', this.properties.customeName, 'customeName')
    // this.widgets_up = true


    return _this17;
  }

  var _proto7 = connection.prototype;

  _proto7.onGetInputs = function onGetInputs() {
    return [["关联子物体", 'codeNode']];
  };

  _proto7.onStart = function onStart() {
    this.onAction();

    _BaseYWNode7.prototype.onStart.call(this);
  };

  _proto7.onSelected = function onSelected() {
    // console.log('connection onSelected')
    this.onAction();
    this.sendOtherEvent('onSelected');
  };

  _proto7.disconnectInput = function disconnectInput(slot, keepReroutes) {
    // console.log('我准备移除输入节点', slot, keepReroutes)
    if (slot >= 1) {
      var codeNode = this.getInputData(slot, true); // console.log("找到了目标节点，移除", slot,codeNode )

      if (codeNode != null) {
        var rootccNode = this.graph.vars.rootccNode;

        if (rootccNode == null) {
          rootccNode = cc.director.getScene().getChildByName('Canvas');
        }

        if (rootccNode != null) {
          codeNode.parent = rootccNode;
        }
      }
    }

    _BaseYWNode7.prototype.disconnectInput.call(this, slot, keepReroutes);
  };

  _proto7.onAction = function onAction() {
    var codeNode = this.getInputData(0, true); // this.linkDatas.cardexSolt[0]

    if (codeNode == null) {
      return;
    }

    var parent = codeNode.node;

    if (parent != null) {
      for (var i = 1; i < this.inputs.length; i++) {
        var _codeNode = this.getInputData(i, true);

        if (_codeNode != null) {
          _codeNode.parent = parent;
        }
      }
    }
  } //   getTitle() {
  //       if (this.flags.collapsed) {
  //           return "发送事件." + this.properties.customeName;
  //       }
  //       return this.title;
  //   };
  // onGetOutputs() {
  //   console.log('我调用了onGetOutputs')
  //   return [["number", "string"]];
  // };
  //   onAction(action, param){
  //     let data = this.getInputData(0)
  //     this.graph.sendEventToAllNodes(this.properties.customeName, data)
  //   }
  ;

  return connection;
}(_BaseYwNode.BaseYWNode);

connection.title = '连接零件'; // Register the node type

_litegraph.LiteGraph.registerNodeType("objects/group/connection", connection);

var groupMove = /*#__PURE__*/function (_BaseYWNode8) {
  _inheritsLoose(groupMove, _BaseYWNode8);

  function groupMove() {
    var _this18;

    _this18 = _BaseYWNode8.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this18.title = "整体移动";
    _this18.desc = "用于在开发时整体移动所有物体";
    _this18.mode = _litegraph.LiteGraph.ON_EVENT;

    _this18.addProperty('x', 0, 'number');

    _this18.addWidget('number', '坐标-x', _this18.properties.x, 'x', {
      precision: 2
    });

    _this18.addProperty('y', 0, 'number');

    _this18.addWidget('number', '坐标-y', _this18.properties.y, 'y', {
      precision: 2
    });

    return _this18;
  } //变量切换


  var _proto8 = groupMove.prototype;

  _proto8.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    console.log('当前变量切换', property, value, oldValue, value - oldValue);
    var objectNodes = this.graph.findNodesByType('objects/createObject');
    var valueChanged = value - oldValue;
    objectNodes.forEach(function (element) {
      element.setProperty(property, element.properties[property] + valueChanged);
    });
    this.sendPropertyChangeEvent(property, value, oldValue);
  };

  return groupMove;
}(_BaseYwNode.BaseYWNode);

groupMove.title = '整体移动';

_litegraph.LiteGraph.registerNodeType("objects/groupMove", groupMove);

var groupScale = /*#__PURE__*/function (_BaseYWNode9) {
  _inheritsLoose(groupScale, _BaseYWNode9);

  function groupScale() {
    var _this19;

    _this19 = _BaseYWNode9.call(this) || this; // this.addProperty("time_in_ms", 1000);
    // this.serialize_widgets = true;
    // this.size = [140, 30]; 

    _this19.title = "分镜预览缩放";
    _this19.desc = "用于在开发时分镜预览缩放，以便看清超出屏幕范围的物体";
    _this19.color = '#FFC082';
    _this19.mode = _litegraph.LiteGraph.ON_EVENT;

    _this19.addProperty('x', 0, 'number');

    _this19.addWidget('number', '位移x', _this19.properties.x, 'x', {
      precision: 2
    });

    _this19.addProperty('y', 0, 'number');

    _this19.addWidget('number', '位移y', _this19.properties.y, 'y', {
      precision: 2
    });

    _this19.addProperty('zoomRatio', 1, 'number');

    _this19.addWidget('slider', '缩放', _this19.properties.zoomRatio, 'zoomRatio', {
      precision: 2,
      min: 0.25,
      max: 1
    }); //节点配置


    _this19.addProperty('nodeConfig', {
      x: 0,
      y: 0,
      width: CocosMgr.designViewWidth,
      height: CocosMgr.designViewHeight,
      anchorX: 0.5,
      anchorY: 0.5,
      scaleX: 1,
      scaleY: 1,
      color: '#FFC082',
      angle: 0
    }, 'object'); ////仅仅绘制边框


    _this19.nodeConfigWidget = _this19.addWidget('ccnode', '节点操控', _this19.properties.nodeConfig, 'nodeConfig', {
      viewWidth: CocosMgr.designViewWidth,
      viewHeight: CocosMgr.designViewHeight,
      justDrawBorder: false,
      borderColor: '#FFC082'
    });

    _this19.addWidget('button', '重置到默认状态', "", function () {
      console.log("点击了重置属性");

      _this19.setProperty('x', 0);

      _this19.setProperty('y', 0);

      _this19.setProperty('zoomRatio', 1);
    });

    return _this19;
  } //变量切换


  var _proto9 = groupScale.prototype;

  _proto9.onPropertyChanged = function onPropertyChanged(property, value, oldValue) {
    // console.log('修改了属性', property, value)
    if (CocosMgr.isInApp == false) {
      var _camera3 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera'); // console.log('修改了属性', , property, value)


      if (property == 'x') {
        _camera3.x = value * -1 / this.properties.zoomRatio;
      } else if (property == 'y') {
        _camera3.y = value * -1 / this.properties.zoomRatio;
      } else if (property == 'zoomRatio') {
        // console.log('设置zoomRatio', 'zoomRatio', value)
        _camera3.getComponent(cc.Camera).zoomRatio = value;
      }

      if (property != 'nodeConfig') {
        //  console.log('this.nodeConfigWidget', this.nodeConfigWidget)
        if (typeof this.nodeConfigWidget.value == 'object') {
          if (this.nodeConfigWidget.value[property] != null) {
            this.nodeConfigWidget.value[property] = value;
            this.properties.nodeConfig[property] = value;
          }

          if (property == 'zoomRatio') {
            if (this.nodeConfigWidget.value['scaleX'] != null) {
              this.nodeConfigWidget.value['scaleX'] = value;
              this.properties.nodeConfig['scaleX'] = value;
              this.nodeConfigWidget.value['scaleY'] = value;
              this.properties.nodeConfig['scaleY'] = value;
            }
          }
        }
      }
    }

    this.sendPropertyChangeEvent(property, value, oldValue);
  } // onWidgetChanged(name, value, oldValue, widget){
  //     // console.log('onWidgetChanged', name, value, oldValue, widget)
  //     var property = widget.options.property
  // }
  ;

  _proto9.onStop = function onStop() {};

  _proto9.onAttachCanvas = function onAttachCanvas() {};

  _proto9.onConfigure = function onConfigure() {
    if (CocosMgr.isInApp == false) {
      var _camera4 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera');

      _camera4.x = this.properties.x * -1 / this.properties.zoomRatio;
      _camera4.y = this.properties.y * -1 / this.properties.zoomRatio;
      _camera4.getComponent(cc.Camera).zoomRatio = this.properties.zoomRatio;
    }
  };

  _proto9.onRemoved = function onRemoved() {
    this.onAction('重置');
    this.sendRemoveEvent();
  };

  _proto9.onAction = function onAction(name) {
    // console.log('调用的方案', name)
    if (name == '重置') {
      var _camera5 = cc.director.getScene().getChildByName('Canvas').getChildByName('Main Camera');

      _camera5.x = 0;
      _camera5.y = 0;
      _camera5.getComponent(cc.Camera).zoomRatio = 1;
    }
  };

  return groupScale;
}(_BaseYwNode.BaseYWNode);

groupScale.title = '分镜预览缩放';

_litegraph.LiteGraph.registerNodeType("objects/groupScale", groupScale);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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